/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-10 at 01:52:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for EventReminder.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventReminder extends com.google.api.client.json.GenericJson {

  /**
   * The method used by this reminder. Possible values are: - "email" - Reminders are sent via
   * email.  - "sms" - Reminders are sent via SMS. These are only available for G Suite customers.
   * Requests to set SMS reminders for other account types are ignored.  - "popup" - Reminders are
   * sent via a UI popup.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String method;

  /**
   * Number of minutes before the start of the event when the reminder should trigger. Valid values
   * are between 0 and 40320 (4 weeks in minutes).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minutes;

  /**
   * The method used by this reminder. Possible values are: - "email" - Reminders are sent via
   * email.  - "sms" - Reminders are sent via SMS. These are only available for G Suite customers.
   * Requests to set SMS reminders for other account types are ignored.  - "popup" - Reminders are
   * sent via a UI popup.
   * @return value or {@code null} for none
   */
  public java.lang.String getMethod() {
    return method;
  }

  /**
   * The method used by this reminder. Possible values are: - "email" - Reminders are sent via
   * email.  - "sms" - Reminders are sent via SMS. These are only available for G Suite customers.
   * Requests to set SMS reminders for other account types are ignored.  - "popup" - Reminders are
   * sent via a UI popup.
   * @param method method or {@code null} for none
   */
  public EventReminder setMethod(java.lang.String method) {
    this.method = method;
    return this;
  }

  /**
   * Number of minutes before the start of the event when the reminder should trigger. Valid values
   * are between 0 and 40320 (4 weeks in minutes).
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinutes() {
    return minutes;
  }

  /**
   * Number of minutes before the start of the event when the reminder should trigger. Valid values
   * are between 0 and 40320 (4 weeks in minutes).
   * @param minutes minutes or {@code null} for none
   */
  public EventReminder setMinutes(java.lang.Integer minutes) {
    this.minutes = minutes;
    return this;
  }

  @Override
  public EventReminder set(String fieldName, Object value) {
    return (EventReminder) super.set(fieldName, value);
  }

  @Override
  public EventReminder clone() {
    return (EventReminder) super.clone();
  }

}
