/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-10 at 01:52:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for EventDateTime.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventDateTime extends com.google.api.client.json.GenericJson {

  /**
   * The date, in the format "yyyy-mm-dd", if this is an all-day event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime date;

  /**
   * The time, as a combined date-time value (formatted according to RFC3339). A time zone offset is
   * required unless a time zone is explicitly specified in timeZone.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime dateTime;

  /**
   * The time zone in which the time is specified. (Formatted as an IANA Time Zone Database name,
   * e.g. "Europe/Zurich".) For recurring events this field is required and specifies the time zone
   * in which the recurrence is expanded. For single events this field is optional and indicates a
   * custom time zone for the event start/end.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeZone;

  /**
   * The date, in the format "yyyy-mm-dd", if this is an all-day event.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getDate() {
    return date;
  }

  /**
   * The date, in the format "yyyy-mm-dd", if this is an all-day event.
   * @param date date or {@code null} for none
   */
  public EventDateTime setDate(com.google.api.client.util.DateTime date) {
    this.date = date;
    return this;
  }

  /**
   * The time, as a combined date-time value (formatted according to RFC3339). A time zone offset is
   * required unless a time zone is explicitly specified in timeZone.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getDateTime() {
    return dateTime;
  }

  /**
   * The time, as a combined date-time value (formatted according to RFC3339). A time zone offset is
   * required unless a time zone is explicitly specified in timeZone.
   * @param dateTime dateTime or {@code null} for none
   */
  public EventDateTime setDateTime(com.google.api.client.util.DateTime dateTime) {
    this.dateTime = dateTime;
    return this;
  }

  /**
   * The time zone in which the time is specified. (Formatted as an IANA Time Zone Database name,
   * e.g. "Europe/Zurich".) For recurring events this field is required and specifies the time zone
   * in which the recurrence is expanded. For single events this field is optional and indicates a
   * custom time zone for the event start/end.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeZone() {
    return timeZone;
  }

  /**
   * The time zone in which the time is specified. (Formatted as an IANA Time Zone Database name,
   * e.g. "Europe/Zurich".) For recurring events this field is required and specifies the time zone
   * in which the recurrence is expanded. For single events this field is optional and indicates a
   * custom time zone for the event start/end.
   * @param timeZone timeZone or {@code null} for none
   */
  public EventDateTime setTimeZone(java.lang.String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  @Override
  public EventDateTime set(String fieldName, Object value) {
    return (EventDateTime) super.set(fieldName, value);
  }

  @Override
  public EventDateTime clone() {
    return (EventDateTime) super.clone();
  }

}
