/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-10 at 01:52:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for EventAttachment.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventAttachment extends com.google.api.client.json.GenericJson {

  /**
   * ID of the attached file. Read-only. For Google Drive files, this is the ID of the corresponding
   * Files resource entry in the Drive API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileId;

  /**
   * URL link to the attachment. For adding Google Drive file attachments use the same format as in
   * alternateLink property of the Files resource in the Drive API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileUrl;

  /**
   * URL link to the attachment's icon. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iconLink;

  /**
   * Internet media type (MIME type) of the attachment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mimeType;

  /**
   * Attachment title.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * ID of the attached file. Read-only. For Google Drive files, this is the ID of the corresponding
   * Files resource entry in the Drive API.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileId() {
    return fileId;
  }

  /**
   * ID of the attached file. Read-only. For Google Drive files, this is the ID of the corresponding
   * Files resource entry in the Drive API.
   * @param fileId fileId or {@code null} for none
   */
  public EventAttachment setFileId(java.lang.String fileId) {
    this.fileId = fileId;
    return this;
  }

  /**
   * URL link to the attachment. For adding Google Drive file attachments use the same format as in
   * alternateLink property of the Files resource in the Drive API.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileUrl() {
    return fileUrl;
  }

  /**
   * URL link to the attachment. For adding Google Drive file attachments use the same format as in
   * alternateLink property of the Files resource in the Drive API.
   * @param fileUrl fileUrl or {@code null} for none
   */
  public EventAttachment setFileUrl(java.lang.String fileUrl) {
    this.fileUrl = fileUrl;
    return this;
  }

  /**
   * URL link to the attachment's icon. Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getIconLink() {
    return iconLink;
  }

  /**
   * URL link to the attachment's icon. Read-only.
   * @param iconLink iconLink or {@code null} for none
   */
  public EventAttachment setIconLink(java.lang.String iconLink) {
    this.iconLink = iconLink;
    return this;
  }

  /**
   * Internet media type (MIME type) of the attachment.
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * Internet media type (MIME type) of the attachment.
   * @param mimeType mimeType or {@code null} for none
   */
  public EventAttachment setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * Attachment title.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * Attachment title.
   * @param title title or {@code null} for none
   */
  public EventAttachment setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  @Override
  public EventAttachment set(String fieldName, Object value) {
    return (EventAttachment) super.set(fieldName, value);
  }

  @Override
  public EventAttachment clone() {
    return (EventAttachment) super.clone();
  }

}
