/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-02-10 at 01:52:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for CalendarListEntry.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CalendarListEntry extends com.google.api.client.json.GenericJson {

  /**
   * The effective access role that the authenticated user has on the calendar. Read-only. Possible
   * values are: - "freeBusyReader" - Provides read access to free/busy information.  - "reader" -
   * Provides read access to the calendar. Private events will appear to users with reader access,
   * but event details will be hidden.  - "writer" - Provides read and write access to the calendar.
   * Private events will appear to users with writer access, and event details will be visible.  -
   * "owner" - Provides ownership of the calendar. This role has all of the permissions of the
   * writer role with the additional ability to see and manipulate ACLs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accessRole;

  /**
   * The main color of the calendar in the hexadecimal format "#0088aa". This property supersedes
   * the index-based colorId property. To set or change this property, you need to specify
   * colorRgbFormat=true in the parameters of the insert, update and patch methods. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String backgroundColor;

  /**
   * The color of the calendar. This is an ID referring to an entry in the calendar section of the
   * colors definition (see the colors endpoint). This property is superseded by the backgroundColor
   * and foregroundColor properties and can be ignored when using these properties. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String colorId;

  /**
   * Conferencing properties for this calendar, for example what types of conferences are allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConferenceProperties conferenceProperties;

  /**
   * The default reminders that the authenticated user has for this calendar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<EventReminder> defaultReminders;

  /**
   * Whether this calendar list entry has been deleted from the calendar list. Read-only. Optional.
   * The default is False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleted;

  /**
   * Description of the calendar. Optional. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * ETag of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The foreground color of the calendar in the hexadecimal format "#ffffff". This property
   * supersedes the index-based colorId property. To set or change this property, you need to
   * specify colorRgbFormat=true in the parameters of the insert, update and patch methods.
   * Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String foregroundColor;

  /**
   * Whether the calendar has been hidden from the list. Optional. The default is False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hidden;

  /**
   * Identifier of the calendar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Type of the resource ("calendar#calendarListEntry").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Geographic location of the calendar as free-form text. Optional. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * The notifications that the authenticated user is receiving for this calendar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NotificationSettings notificationSettings;

  /**
   * Whether the calendar is the primary calendar of the authenticated user. Read-only. Optional.
   * The default is False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean primary;

  /**
   * Whether the calendar content shows up in the calendar UI. Optional. The default is False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean selected;

  /**
   * Title of the calendar. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String summary;

  /**
   * The summary that the authenticated user has set for this calendar. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String summaryOverride;

  /**
   * The time zone of the calendar. Optional. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeZone;

  /**
   * The effective access role that the authenticated user has on the calendar. Read-only. Possible
   * values are: - "freeBusyReader" - Provides read access to free/busy information.  - "reader" -
   * Provides read access to the calendar. Private events will appear to users with reader access,
   * but event details will be hidden.  - "writer" - Provides read and write access to the calendar.
   * Private events will appear to users with writer access, and event details will be visible.  -
   * "owner" - Provides ownership of the calendar. This role has all of the permissions of the
   * writer role with the additional ability to see and manipulate ACLs.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccessRole() {
    return accessRole;
  }

  /**
   * The effective access role that the authenticated user has on the calendar. Read-only. Possible
   * values are: - "freeBusyReader" - Provides read access to free/busy information.  - "reader" -
   * Provides read access to the calendar. Private events will appear to users with reader access,
   * but event details will be hidden.  - "writer" - Provides read and write access to the calendar.
   * Private events will appear to users with writer access, and event details will be visible.  -
   * "owner" - Provides ownership of the calendar. This role has all of the permissions of the
   * writer role with the additional ability to see and manipulate ACLs.
   * @param accessRole accessRole or {@code null} for none
   */
  public CalendarListEntry setAccessRole(java.lang.String accessRole) {
    this.accessRole = accessRole;
    return this;
  }

  /**
   * The main color of the calendar in the hexadecimal format "#0088aa". This property supersedes
   * the index-based colorId property. To set or change this property, you need to specify
   * colorRgbFormat=true in the parameters of the insert, update and patch methods. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getBackgroundColor() {
    return backgroundColor;
  }

  /**
   * The main color of the calendar in the hexadecimal format "#0088aa". This property supersedes
   * the index-based colorId property. To set or change this property, you need to specify
   * colorRgbFormat=true in the parameters of the insert, update and patch methods. Optional.
   * @param backgroundColor backgroundColor or {@code null} for none
   */
  public CalendarListEntry setBackgroundColor(java.lang.String backgroundColor) {
    this.backgroundColor = backgroundColor;
    return this;
  }

  /**
   * The color of the calendar. This is an ID referring to an entry in the calendar section of the
   * colors definition (see the colors endpoint). This property is superseded by the backgroundColor
   * and foregroundColor properties and can be ignored when using these properties. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getColorId() {
    return colorId;
  }

  /**
   * The color of the calendar. This is an ID referring to an entry in the calendar section of the
   * colors definition (see the colors endpoint). This property is superseded by the backgroundColor
   * and foregroundColor properties and can be ignored when using these properties. Optional.
   * @param colorId colorId or {@code null} for none
   */
  public CalendarListEntry setColorId(java.lang.String colorId) {
    this.colorId = colorId;
    return this;
  }

  /**
   * Conferencing properties for this calendar, for example what types of conferences are allowed.
   * @return value or {@code null} for none
   */
  public ConferenceProperties getConferenceProperties() {
    return conferenceProperties;
  }

  /**
   * Conferencing properties for this calendar, for example what types of conferences are allowed.
   * @param conferenceProperties conferenceProperties or {@code null} for none
   */
  public CalendarListEntry setConferenceProperties(ConferenceProperties conferenceProperties) {
    this.conferenceProperties = conferenceProperties;
    return this;
  }

  /**
   * The default reminders that the authenticated user has for this calendar.
   * @return value or {@code null} for none
   */
  public java.util.List<EventReminder> getDefaultReminders() {
    return defaultReminders;
  }

  /**
   * The default reminders that the authenticated user has for this calendar.
   * @param defaultReminders defaultReminders or {@code null} for none
   */
  public CalendarListEntry setDefaultReminders(java.util.List<EventReminder> defaultReminders) {
    this.defaultReminders = defaultReminders;
    return this;
  }

  /**
   * Whether this calendar list entry has been deleted from the calendar list. Read-only. Optional.
   * The default is False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleted() {
    return deleted;
  }

  /**
   * Whether this calendar list entry has been deleted from the calendar list. Read-only. Optional.
   * The default is False.
   * @param deleted deleted or {@code null} for none
   */
  public CalendarListEntry setDeleted(java.lang.Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether this calendar list entry has been deleted from the calendar list. Read-only. Optional. The
 default is False.
   * </p>
   */
  public boolean isDeleted() {
    if (deleted == null || deleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return deleted;
  }

  /**
   * Description of the calendar. Optional. Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Description of the calendar. Optional. Read-only.
   * @param description description or {@code null} for none
   */
  public CalendarListEntry setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * ETag of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * ETag of the resource.
   * @param etag etag or {@code null} for none
   */
  public CalendarListEntry setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The foreground color of the calendar in the hexadecimal format "#ffffff". This property
   * supersedes the index-based colorId property. To set or change this property, you need to
   * specify colorRgbFormat=true in the parameters of the insert, update and patch methods.
   * Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getForegroundColor() {
    return foregroundColor;
  }

  /**
   * The foreground color of the calendar in the hexadecimal format "#ffffff". This property
   * supersedes the index-based colorId property. To set or change this property, you need to
   * specify colorRgbFormat=true in the parameters of the insert, update and patch methods.
   * Optional.
   * @param foregroundColor foregroundColor or {@code null} for none
   */
  public CalendarListEntry setForegroundColor(java.lang.String foregroundColor) {
    this.foregroundColor = foregroundColor;
    return this;
  }

  /**
   * Whether the calendar has been hidden from the list. Optional. The default is False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHidden() {
    return hidden;
  }

  /**
   * Whether the calendar has been hidden from the list. Optional. The default is False.
   * @param hidden hidden or {@code null} for none
   */
  public CalendarListEntry setHidden(java.lang.Boolean hidden) {
    this.hidden = hidden;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether the calendar has been hidden from the list. Optional. The default is False.
   * </p>
   */
  public boolean isHidden() {
    if (hidden == null || hidden == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return hidden;
  }

  /**
   * Identifier of the calendar.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Identifier of the calendar.
   * @param id id or {@code null} for none
   */
  public CalendarListEntry setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource ("calendar#calendarListEntry").
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource ("calendar#calendarListEntry").
   * @param kind kind or {@code null} for none
   */
  public CalendarListEntry setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Geographic location of the calendar as free-form text. Optional. Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * Geographic location of the calendar as free-form text. Optional. Read-only.
   * @param location location or {@code null} for none
   */
  public CalendarListEntry setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * The notifications that the authenticated user is receiving for this calendar.
   * @return value or {@code null} for none
   */
  public NotificationSettings getNotificationSettings() {
    return notificationSettings;
  }

  /**
   * The notifications that the authenticated user is receiving for this calendar.
   * @param notificationSettings notificationSettings or {@code null} for none
   */
  public CalendarListEntry setNotificationSettings(NotificationSettings notificationSettings) {
    this.notificationSettings = notificationSettings;
    return this;
  }

  /**
   * Whether the calendar is the primary calendar of the authenticated user. Read-only. Optional.
   * The default is False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPrimary() {
    return primary;
  }

  /**
   * Whether the calendar is the primary calendar of the authenticated user. Read-only. Optional.
   * The default is False.
   * @param primary primary or {@code null} for none
   */
  public CalendarListEntry setPrimary(java.lang.Boolean primary) {
    this.primary = primary;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether the calendar is the primary calendar of the authenticated user. Read-only. Optional. The
 default is False.
   * </p>
   */
  public boolean isPrimary() {
    if (primary == null || primary == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return primary;
  }

  /**
   * Whether the calendar content shows up in the calendar UI. Optional. The default is False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSelected() {
    return selected;
  }

  /**
   * Whether the calendar content shows up in the calendar UI. Optional. The default is False.
   * @param selected selected or {@code null} for none
   */
  public CalendarListEntry setSelected(java.lang.Boolean selected) {
    this.selected = selected;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether the calendar content shows up in the calendar UI. Optional. The default is False.
   * </p>
   */
  public boolean isSelected() {
    if (selected == null || selected == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return selected;
  }

  /**
   * Title of the calendar. Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getSummary() {
    return summary;
  }

  /**
   * Title of the calendar. Read-only.
   * @param summary summary or {@code null} for none
   */
  public CalendarListEntry setSummary(java.lang.String summary) {
    this.summary = summary;
    return this;
  }

  /**
   * The summary that the authenticated user has set for this calendar. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getSummaryOverride() {
    return summaryOverride;
  }

  /**
   * The summary that the authenticated user has set for this calendar. Optional.
   * @param summaryOverride summaryOverride or {@code null} for none
   */
  public CalendarListEntry setSummaryOverride(java.lang.String summaryOverride) {
    this.summaryOverride = summaryOverride;
    return this;
  }

  /**
   * The time zone of the calendar. Optional. Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeZone() {
    return timeZone;
  }

  /**
   * The time zone of the calendar. Optional. Read-only.
   * @param timeZone timeZone or {@code null} for none
   */
  public CalendarListEntry setTimeZone(java.lang.String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  @Override
  public CalendarListEntry set(String fieldName, Object value) {
    return (CalendarListEntry) super.set(fieldName, value);
  }

  @Override
  public CalendarListEntry clone() {
    return (CalendarListEntry) super.clone();
  }

  /**
   * The notifications that the authenticated user is receiving for this calendar.
   */
  public static final class NotificationSettings extends com.google.api.client.json.GenericJson {

    /**
     * The list of notifications set for this calendar.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<CalendarNotification> notifications;

    /**
     * The list of notifications set for this calendar.
     * @return value or {@code null} for none
     */
    public java.util.List<CalendarNotification> getNotifications() {
      return notifications;
    }

    /**
     * The list of notifications set for this calendar.
     * @param notifications notifications or {@code null} for none
     */
    public NotificationSettings setNotifications(java.util.List<CalendarNotification> notifications) {
      this.notifications = notifications;
      return this;
    }

    @Override
    public NotificationSettings set(String fieldName, Object value) {
      return (NotificationSettings) super.set(fieldName, value);
    }

    @Override
    public NotificationSettings clone() {
      return (NotificationSettings) super.clone();
    }

  }

}
