/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for Events.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Events extends com.google.api.client.json.GenericJson {

  /**
   * The user's access role for this calendar. Read-only. Possible values are: - "none" - The user
   * has no access.  - "freeBusyReader" - The user has read access to free/busy information.  -
   * "reader" - The user has read access to the calendar. Private events will appear to users with
   * reader access, but event details will be hidden.  - "writer" - The user has read and write
   * access to the calendar. Private events will appear to users with writer access, and event
   * details will be visible.  - "owner" - The user has manager access to the calendar. This role
   * has all of the permissions of the writer role with the additional ability to see and modify
   * access levels of other users. Important: the owner role is different from the calendar's data
   * owner. A calendar has a single data owner, but can have multiple users with owner role.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accessRole;

  /**
   * The default reminders on the calendar for the authenticated user. These reminders apply to all
   * events on this calendar that do not explicitly override them (i.e. do not have
   * reminders.useDefault set to True).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<EventReminder> defaultReminders;

  static {
    // hack to force ProGuard to consider EventReminder used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(EventReminder.class);
  }

  /**
   * Description of the calendar. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * ETag of the collection.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * List of events on the calendar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Event> items;

  static {
    // hack to force ProGuard to consider Event used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Event.class);
  }

  /**
   * Type of the collection ("calendar#events").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Token used to access the next page of this result. Omitted if no further results are available,
   * in which case nextSyncToken is provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Token used at a later point in time to retrieve only the entries that have changed since this
   * result was returned. Omitted if further results are available, in which case nextPageToken is
   * provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextSyncToken;

  /**
   * Title of the calendar. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String summary;

  /**
   * The time zone of the calendar. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeZone;

  /**
   * Last modification time of the calendar (as a RFC3339 timestamp). Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * The user's access role for this calendar. Read-only. Possible values are: - "none" - The user
   * has no access.  - "freeBusyReader" - The user has read access to free/busy information.  -
   * "reader" - The user has read access to the calendar. Private events will appear to users with
   * reader access, but event details will be hidden.  - "writer" - The user has read and write
   * access to the calendar. Private events will appear to users with writer access, and event
   * details will be visible.  - "owner" - The user has manager access to the calendar. This role
   * has all of the permissions of the writer role with the additional ability to see and modify
   * access levels of other users. Important: the owner role is different from the calendar's data
   * owner. A calendar has a single data owner, but can have multiple users with owner role.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccessRole() {
    return accessRole;
  }

  /**
   * The user's access role for this calendar. Read-only. Possible values are: - "none" - The user
   * has no access.  - "freeBusyReader" - The user has read access to free/busy information.  -
   * "reader" - The user has read access to the calendar. Private events will appear to users with
   * reader access, but event details will be hidden.  - "writer" - The user has read and write
   * access to the calendar. Private events will appear to users with writer access, and event
   * details will be visible.  - "owner" - The user has manager access to the calendar. This role
   * has all of the permissions of the writer role with the additional ability to see and modify
   * access levels of other users. Important: the owner role is different from the calendar's data
   * owner. A calendar has a single data owner, but can have multiple users with owner role.
   * @param accessRole accessRole or {@code null} for none
   */
  public Events setAccessRole(java.lang.String accessRole) {
    this.accessRole = accessRole;
    return this;
  }

  /**
   * The default reminders on the calendar for the authenticated user. These reminders apply to all
   * events on this calendar that do not explicitly override them (i.e. do not have
   * reminders.useDefault set to True).
   * @return value or {@code null} for none
   */
  public java.util.List<EventReminder> getDefaultReminders() {
    return defaultReminders;
  }

  /**
   * The default reminders on the calendar for the authenticated user. These reminders apply to all
   * events on this calendar that do not explicitly override them (i.e. do not have
   * reminders.useDefault set to True).
   * @param defaultReminders defaultReminders or {@code null} for none
   */
  public Events setDefaultReminders(java.util.List<EventReminder> defaultReminders) {
    this.defaultReminders = defaultReminders;
    return this;
  }

  /**
   * Description of the calendar. Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Description of the calendar. Read-only.
   * @param description description or {@code null} for none
   */
  public Events setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * ETag of the collection.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * ETag of the collection.
   * @param etag etag or {@code null} for none
   */
  public Events setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * List of events on the calendar.
   * @return value or {@code null} for none
   */
  public java.util.List<Event> getItems() {
    return items;
  }

  /**
   * List of events on the calendar.
   * @param items items or {@code null} for none
   */
  public Events setItems(java.util.List<Event> items) {
    this.items = items;
    return this;
  }

  /**
   * Type of the collection ("calendar#events").
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the collection ("calendar#events").
   * @param kind kind or {@code null} for none
   */
  public Events setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Token used to access the next page of this result. Omitted if no further results are available,
   * in which case nextSyncToken is provided.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Token used to access the next page of this result. Omitted if no further results are available,
   * in which case nextSyncToken is provided.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public Events setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Token used at a later point in time to retrieve only the entries that have changed since this
   * result was returned. Omitted if further results are available, in which case nextPageToken is
   * provided.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextSyncToken() {
    return nextSyncToken;
  }

  /**
   * Token used at a later point in time to retrieve only the entries that have changed since this
   * result was returned. Omitted if further results are available, in which case nextPageToken is
   * provided.
   * @param nextSyncToken nextSyncToken or {@code null} for none
   */
  public Events setNextSyncToken(java.lang.String nextSyncToken) {
    this.nextSyncToken = nextSyncToken;
    return this;
  }

  /**
   * Title of the calendar. Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getSummary() {
    return summary;
  }

  /**
   * Title of the calendar. Read-only.
   * @param summary summary or {@code null} for none
   */
  public Events setSummary(java.lang.String summary) {
    this.summary = summary;
    return this;
  }

  /**
   * The time zone of the calendar. Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeZone() {
    return timeZone;
  }

  /**
   * The time zone of the calendar. Read-only.
   * @param timeZone timeZone or {@code null} for none
   */
  public Events setTimeZone(java.lang.String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  /**
   * Last modification time of the calendar (as a RFC3339 timestamp). Read-only.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * Last modification time of the calendar (as a RFC3339 timestamp). Read-only.
   * @param updated updated or {@code null} for none
   */
  public Events setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  @Override
  public Events set(String fieldName, Object value) {
    return (Events) super.set(fieldName, value);
  }

  @Override
  public Events clone() {
    return (Events) super.clone();
  }

}
