/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for ConferenceProperties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ConferenceProperties extends com.google.api.client.json.GenericJson {

  /**
   * The types of conference solutions that are supported for this calendar. The possible values
   * are:   - "eventHangout"  - "eventNamedHangout"  - "hangoutsMeet"  Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> allowedConferenceSolutionTypes;

  /**
   * The types of conference solutions that are supported for this calendar. The possible values
   * are:   - "eventHangout"  - "eventNamedHangout"  - "hangoutsMeet"  Optional.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAllowedConferenceSolutionTypes() {
    return allowedConferenceSolutionTypes;
  }

  /**
   * The types of conference solutions that are supported for this calendar. The possible values
   * are:   - "eventHangout"  - "eventNamedHangout"  - "hangoutsMeet"  Optional.
   * @param allowedConferenceSolutionTypes allowedConferenceSolutionTypes or {@code null} for none
   */
  public ConferenceProperties setAllowedConferenceSolutionTypes(java.util.List<java.lang.String> allowedConferenceSolutionTypes) {
    this.allowedConferenceSolutionTypes = allowedConferenceSolutionTypes;
    return this;
  }

  @Override
  public ConferenceProperties set(String fieldName, Object value) {
    return (ConferenceProperties) super.set(fieldName, value);
  }

  @Override
  public ConferenceProperties clone() {
    return (ConferenceProperties) super.clone();
  }

}
