/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.calendar;

/**
 * Available OAuth 2.0 scopes for use with the Calendar API.
 *
 * @since 1.4
 */
public class CalendarScopes {

  /** See, edit, share, and permanently delete all the calendars you can access using Google Calendar. */
  public static final String CALENDAR = "https://www.googleapis.com/auth/calendar";

  /** See and change the sharing permissions of Google calendars you own. */
  public static final String CALENDAR_ACLS = "https://www.googleapis.com/auth/calendar.acls";

  /** See the sharing permissions of Google calendars you own. */
  public static final String CALENDAR_ACLS_READONLY = "https://www.googleapis.com/auth/calendar.acls.readonly";

  /** Make secondary Google calendars, and see, create, change, and delete events on them. */
  public static final String CALENDAR_APP_CREATED = "https://www.googleapis.com/auth/calendar.app.created";

  /** See, add, and remove Google calendars you’re subscribed to. */
  public static final String CALENDAR_CALENDARLIST = "https://www.googleapis.com/auth/calendar.calendarlist";

  /** See the list of Google calendars you’re subscribed to. */
  public static final String CALENDAR_CALENDARLIST_READONLY = "https://www.googleapis.com/auth/calendar.calendarlist.readonly";

  /** See and change the properties of Google calendars you have access to, and create secondary calendars. */
  public static final String CALENDAR_CALENDARS = "https://www.googleapis.com/auth/calendar.calendars";

  /** See the title, description, default time zone, and other properties of Google calendars you have access to. */
  public static final String CALENDAR_CALENDARS_READONLY = "https://www.googleapis.com/auth/calendar.calendars.readonly";

  /** View and edit events on all your calendars. */
  public static final String CALENDAR_EVENTS = "https://www.googleapis.com/auth/calendar.events";

  /** See the availability on Google calendars you have access to. */
  public static final String CALENDAR_EVENTS_FREEBUSY = "https://www.googleapis.com/auth/calendar.events.freebusy";

  /** See, create, change, and delete events on Google calendars you own. */
  public static final String CALENDAR_EVENTS_OWNED = "https://www.googleapis.com/auth/calendar.events.owned";

  /** See the events on Google calendars you own. */
  public static final String CALENDAR_EVENTS_OWNED_READONLY = "https://www.googleapis.com/auth/calendar.events.owned.readonly";

  /** See the events on public calendars. */
  public static final String CALENDAR_EVENTS_PUBLIC_READONLY = "https://www.googleapis.com/auth/calendar.events.public.readonly";

  /** View events on all your calendars. */
  public static final String CALENDAR_EVENTS_READONLY = "https://www.googleapis.com/auth/calendar.events.readonly";

  /** View your availability in your calendars. */
  public static final String CALENDAR_FREEBUSY = "https://www.googleapis.com/auth/calendar.freebusy";

  /** See and download any calendar you can access using your Google Calendar. */
  public static final String CALENDAR_READONLY = "https://www.googleapis.com/auth/calendar.readonly";

  /** View your Calendar settings. */
  public static final String CALENDAR_SETTINGS_READONLY = "https://www.googleapis.com/auth/calendar.settings.readonly";

  /**
   * Returns an unmodifiable set that contains all scopes declared by this class.
   *
   * @since 1.16
   */
  public static java.util.Set<String> all() {
    java.util.Set<String> set = new java.util.HashSet<String>();
    set.add(CALENDAR);
    set.add(CALENDAR_ACLS);
    set.add(CALENDAR_ACLS_READONLY);
    set.add(CALENDAR_APP_CREATED);
    set.add(CALENDAR_CALENDARLIST);
    set.add(CALENDAR_CALENDARLIST_READONLY);
    set.add(CALENDAR_CALENDARS);
    set.add(CALENDAR_CALENDARS_READONLY);
    set.add(CALENDAR_EVENTS);
    set.add(CALENDAR_EVENTS_FREEBUSY);
    set.add(CALENDAR_EVENTS_OWNED);
    set.add(CALENDAR_EVENTS_OWNED_READONLY);
    set.add(CALENDAR_EVENTS_PUBLIC_READONLY);
    set.add(CALENDAR_EVENTS_READONLY);
    set.add(CALENDAR_FREEBUSY);
    set.add(CALENDAR_READONLY);
    set.add(CALENDAR_SETTINGS_READONLY);
    return java.util.Collections.unmodifiableSet(set);
  }

  private CalendarScopes() {
  }
}
