/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for EventOutOfOfficeProperties.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EventOutOfOfficeProperties extends com.google.api.client.json.GenericJson {

  /**
   * Whether to decline meeting invitations which overlap Out of office events. Valid values are
   * declineNone, meaning that no meeting invitations are declined;
   * declineAllConflictingInvitations, meaning that all conflicting meeting invitations that
   * conflict with the event are declined; and declineOnlyNewConflictingInvitations, meaning that
   * only new conflicting meeting invitations which arrive while the Out of office event is present
   * are to be declined.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String autoDeclineMode;

  /**
   * Response message to set if an existing event or new invitation is automatically declined by
   * Calendar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String declineMessage;

  /**
   * Whether to decline meeting invitations which overlap Out of office events. Valid values are
   * declineNone, meaning that no meeting invitations are declined;
   * declineAllConflictingInvitations, meaning that all conflicting meeting invitations that
   * conflict with the event are declined; and declineOnlyNewConflictingInvitations, meaning that
   * only new conflicting meeting invitations which arrive while the Out of office event is present
   * are to be declined.
   * @return value or {@code null} for none
   */
  public java.lang.String getAutoDeclineMode() {
    return autoDeclineMode;
  }

  /**
   * Whether to decline meeting invitations which overlap Out of office events. Valid values are
   * declineNone, meaning that no meeting invitations are declined;
   * declineAllConflictingInvitations, meaning that all conflicting meeting invitations that
   * conflict with the event are declined; and declineOnlyNewConflictingInvitations, meaning that
   * only new conflicting meeting invitations which arrive while the Out of office event is present
   * are to be declined.
   * @param autoDeclineMode autoDeclineMode or {@code null} for none
   */
  public EventOutOfOfficeProperties setAutoDeclineMode(java.lang.String autoDeclineMode) {
    this.autoDeclineMode = autoDeclineMode;
    return this;
  }

  /**
   * Response message to set if an existing event or new invitation is automatically declined by
   * Calendar.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeclineMessage() {
    return declineMessage;
  }

  /**
   * Response message to set if an existing event or new invitation is automatically declined by
   * Calendar.
   * @param declineMessage declineMessage or {@code null} for none
   */
  public EventOutOfOfficeProperties setDeclineMessage(java.lang.String declineMessage) {
    this.declineMessage = declineMessage;
    return this;
  }

  @Override
  public EventOutOfOfficeProperties set(String fieldName, Object value) {
    return (EventOutOfOfficeProperties) super.set(fieldName, value);
  }

  @Override
  public EventOutOfOfficeProperties clone() {
    return (EventOutOfOfficeProperties) super.clone();
  }

}
