/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for Colors.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Colors extends com.google.api.client.json.GenericJson {

  /**
   * A global palette of calendar colors, mapping from the color ID to its definition. A
   * calendarListEntry resource refers to one of these color IDs in its colorId field. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, ColorDefinition> calendar;

  static {
    // hack to force ProGuard to consider ColorDefinition used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ColorDefinition.class);
  }

  /**
   * A global palette of event colors, mapping from the color ID to its definition. An event
   * resource may refer to one of these color IDs in its colorId field. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, ColorDefinition> event;

  static {
    // hack to force ProGuard to consider ColorDefinition used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ColorDefinition.class);
  }

  /**
   * Type of the resource ("calendar#colors").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Last modification time of the color palette (as a RFC3339 timestamp). Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * A global palette of calendar colors, mapping from the color ID to its definition. A
   * calendarListEntry resource refers to one of these color IDs in its colorId field. Read-only.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, ColorDefinition> getCalendar() {
    return calendar;
  }

  /**
   * A global palette of calendar colors, mapping from the color ID to its definition. A
   * calendarListEntry resource refers to one of these color IDs in its colorId field. Read-only.
   * @param calendar calendar or {@code null} for none
   */
  public Colors setCalendar(java.util.Map<String, ColorDefinition> calendar) {
    this.calendar = calendar;
    return this;
  }

  /**
   * A global palette of event colors, mapping from the color ID to its definition. An event
   * resource may refer to one of these color IDs in its colorId field. Read-only.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, ColorDefinition> getEvent() {
    return event;
  }

  /**
   * A global palette of event colors, mapping from the color ID to its definition. An event
   * resource may refer to one of these color IDs in its colorId field. Read-only.
   * @param event event or {@code null} for none
   */
  public Colors setEvent(java.util.Map<String, ColorDefinition> event) {
    this.event = event;
    return this;
  }

  /**
   * Type of the resource ("calendar#colors").
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource ("calendar#colors").
   * @param kind kind or {@code null} for none
   */
  public Colors setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Last modification time of the color palette (as a RFC3339 timestamp). Read-only.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * Last modification time of the color palette (as a RFC3339 timestamp). Read-only.
   * @param updated updated or {@code null} for none
   */
  public Colors setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  @Override
  public Colors set(String fieldName, Object value) {
    return (Colors) super.set(fieldName, value);
  }

  @Override
  public Colors clone() {
    return (Colors) super.clone();
  }

}
