/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.calendar;

/**
 * Service definition for Calendar (v3).
 *
 * <p>
 * Manipulates events and other calendar data.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/google-apps/calendar/firstapp" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link CalendarRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Calendar extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the Calendar API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://www.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "calendar/v3/";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch/calendar/v3";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Calendar(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Calendar(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Acl collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Calendar calendar = new Calendar(...);}
   *   {@code Calendar.Acl.List request = calendar.acl().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Acl acl() {
    return new Acl();
  }

  /**
   * The "acl" collection of methods.
   */
  public class Acl {

    /**
     * Deletes an access control rule.
     *
     * Create a request for the method "acl.delete".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param ruleId ACL rule identifier.
     * @return the request
     */
    public Delete delete(java.lang.String calendarId, java.lang.String ruleId) throws java.io.IOException {
      Delete result = new Delete(calendarId, ruleId);
      initialize(result);
      return result;
    }

    public class Delete extends CalendarRequest<Void> {

      private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";

      /**
       * Deletes an access control rule.
       *
       * Create a request for the method "acl.delete".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param ruleId ACL rule identifier.
       * @since 1.13
       */
      protected Delete(java.lang.String calendarId, java.lang.String ruleId) {
        super(Calendar.this, "DELETE", REST_PATH, null, Void.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
        this.ruleId = com.google.api.client.util.Preconditions.checkNotNull(ruleId, "Required parameter ruleId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Delete setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /** ACL rule identifier. */
      @com.google.api.client.util.Key
      private java.lang.String ruleId;

      /** ACL rule identifier.
       */
      public java.lang.String getRuleId() {
        return ruleId;
      }

      /** ACL rule identifier. */
      public Delete setRuleId(java.lang.String ruleId) {
        this.ruleId = ruleId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns an access control rule.
     *
     * Create a request for the method "acl.get".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param ruleId ACL rule identifier.
     * @return the request
     */
    public Get get(java.lang.String calendarId, java.lang.String ruleId) throws java.io.IOException {
      Get result = new Get(calendarId, ruleId);
      initialize(result);
      return result;
    }

    public class Get extends CalendarRequest<com.google.api.services.calendar.model.AclRule> {

      private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";

      /**
       * Returns an access control rule.
       *
       * Create a request for the method "acl.get".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param ruleId ACL rule identifier.
       * @since 1.13
       */
      protected Get(java.lang.String calendarId, java.lang.String ruleId) {
        super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.AclRule.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
        this.ruleId = com.google.api.client.util.Preconditions.checkNotNull(ruleId, "Required parameter ruleId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Get setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /** ACL rule identifier. */
      @com.google.api.client.util.Key
      private java.lang.String ruleId;

      /** ACL rule identifier.
       */
      public java.lang.String getRuleId() {
        return ruleId;
      }

      /** ACL rule identifier. */
      public Get setRuleId(java.lang.String ruleId) {
        this.ruleId = ruleId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates an access control rule.
     *
     * Create a request for the method "acl.insert".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param content the {@link com.google.api.services.calendar.model.AclRule}
     * @return the request
     */
    public Insert insert(java.lang.String calendarId, com.google.api.services.calendar.model.AclRule content) throws java.io.IOException {
      Insert result = new Insert(calendarId, content);
      initialize(result);
      return result;
    }

    public class Insert extends CalendarRequest<com.google.api.services.calendar.model.AclRule> {

      private static final String REST_PATH = "calendars/{calendarId}/acl";

      /**
       * Creates an access control rule.
       *
       * Create a request for the method "acl.insert".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param content the {@link com.google.api.services.calendar.model.AclRule}
       * @since 1.13
       */
      protected Insert(java.lang.String calendarId, com.google.api.services.calendar.model.AclRule content) {
        super(Calendar.this, "POST", REST_PATH, content, com.google.api.services.calendar.model.AclRule.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getRole(), "AclRule.getRole()");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getScope(), "AclRule.getScope()");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getScope().getType(), "AclRule.getScope().getType()");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Insert setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /**
       * Whether to send notifications about the calendar sharing change. Optional. The default is
       * True.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sendNotifications;

      /** Whether to send notifications about the calendar sharing change. Optional. The default is True.
       */
      public java.lang.Boolean getSendNotifications() {
        return sendNotifications;
      }

      /**
       * Whether to send notifications about the calendar sharing change. Optional. The default is
       * True.
       */
      public Insert setSendNotifications(java.lang.Boolean sendNotifications) {
        this.sendNotifications = sendNotifications;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns the rules in the access control list for the calendar.
     *
     * Create a request for the method "acl.list".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @return the request
     */
    public List list(java.lang.String calendarId) throws java.io.IOException {
      List result = new List(calendarId);
      initialize(result);
      return result;
    }

    public class List extends CalendarRequest<com.google.api.services.calendar.model.Acl> {

      private static final String REST_PATH = "calendars/{calendarId}/acl";

      /**
       * Returns the rules in the access control list for the calendar.
       *
       * Create a request for the method "acl.list".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @since 1.13
       */
      protected List(java.lang.String calendarId) {
        super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Acl.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public List setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /**
       * Maximum number of entries returned on one result page. By default the value is 100 entries.
       * The page size can never be larger than 250 entries. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of entries returned on one result page. By default the value is 100 entries. The
     page size can never be larger than 250 entries. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of entries returned on one result page. By default the value is 100 entries.
       * The page size can never be larger than 250 entries. Optional.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Token specifying which result page to return. Optional. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Token specifying which result page to return. Optional.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Token specifying which result page to return. Optional. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Whether to include deleted ACLs in the result. Deleted ACLs are represented by role equal
       * to "none". Deleted ACLs will always be included if syncToken is provided. Optional. The
       * default is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean showDeleted;

      /** Whether to include deleted ACLs in the result. Deleted ACLs are represented by role equal to
     "none". Deleted ACLs will always be included if syncToken is provided. Optional. The default is
     False.
       */
      public java.lang.Boolean getShowDeleted() {
        return showDeleted;
      }

      /**
       * Whether to include deleted ACLs in the result. Deleted ACLs are represented by role equal
       * to "none". Deleted ACLs will always be included if syncToken is provided. Optional. The
       * default is False.
       */
      public List setShowDeleted(java.lang.Boolean showDeleted) {
        this.showDeleted = showDeleted;
        return this;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. All entries deleted since the previous list request will always be
       * in the result set and it is not allowed to set showDeleted to False. If the syncToken
       * expires, the server will respond with a 410 GONE response code and the client should clear
       * its storage and perform a full synchronization without any syncToken. Learn more about
       * incremental synchronization. Optional. The default is to return all entries.
       */
      @com.google.api.client.util.Key
      private java.lang.String syncToken;

      /** Token obtained from the nextSyncToken field returned on the last page of results from the previous
     list request. It makes the result of this list request contain only entries that have changed since
     then. All entries deleted since the previous list request will always be in the result set and it
     is not allowed to set showDeleted to False. If the syncToken expires, the server will respond with
     a 410 GONE response code and the client should clear its storage and perform a full synchronization
     without any syncToken. Learn more about incremental synchronization. Optional. The default is to
     return all entries.
       */
      public java.lang.String getSyncToken() {
        return syncToken;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. All entries deleted since the previous list request will always be
       * in the result set and it is not allowed to set showDeleted to False. If the syncToken
       * expires, the server will respond with a 410 GONE response code and the client should clear
       * its storage and perform a full synchronization without any syncToken. Learn more about
       * incremental synchronization. Optional. The default is to return all entries.
       */
      public List setSyncToken(java.lang.String syncToken) {
        this.syncToken = syncToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an access control rule. This method supports patch semantics.
     *
     * Create a request for the method "acl.patch".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param ruleId ACL rule identifier.
     * @param content the {@link com.google.api.services.calendar.model.AclRule}
     * @return the request
     */
    public Patch patch(java.lang.String calendarId, java.lang.String ruleId, com.google.api.services.calendar.model.AclRule content) throws java.io.IOException {
      Patch result = new Patch(calendarId, ruleId, content);
      initialize(result);
      return result;
    }

    public class Patch extends CalendarRequest<com.google.api.services.calendar.model.AclRule> {

      private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";

      /**
       * Updates an access control rule. This method supports patch semantics.
       *
       * Create a request for the method "acl.patch".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param ruleId ACL rule identifier.
       * @param content the {@link com.google.api.services.calendar.model.AclRule}
       * @since 1.13
       */
      protected Patch(java.lang.String calendarId, java.lang.String ruleId, com.google.api.services.calendar.model.AclRule content) {
        super(Calendar.this, "PATCH", REST_PATH, content, com.google.api.services.calendar.model.AclRule.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
        this.ruleId = com.google.api.client.util.Preconditions.checkNotNull(ruleId, "Required parameter ruleId must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Patch setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /** ACL rule identifier. */
      @com.google.api.client.util.Key
      private java.lang.String ruleId;

      /** ACL rule identifier.
       */
      public java.lang.String getRuleId() {
        return ruleId;
      }

      /** ACL rule identifier. */
      public Patch setRuleId(java.lang.String ruleId) {
        this.ruleId = ruleId;
        return this;
      }

      /**
       * Whether to send notifications about the calendar sharing change. Note that there are no
       * notifications on access removal. Optional. The default is True.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sendNotifications;

      /** Whether to send notifications about the calendar sharing change. Note that there are no
     notifications on access removal. Optional. The default is True.
       */
      public java.lang.Boolean getSendNotifications() {
        return sendNotifications;
      }

      /**
       * Whether to send notifications about the calendar sharing change. Note that there are no
       * notifications on access removal. Optional. The default is True.
       */
      public Patch setSendNotifications(java.lang.Boolean sendNotifications) {
        this.sendNotifications = sendNotifications;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an access control rule.
     *
     * Create a request for the method "acl.update".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param ruleId ACL rule identifier.
     * @param content the {@link com.google.api.services.calendar.model.AclRule}
     * @return the request
     */
    public Update update(java.lang.String calendarId, java.lang.String ruleId, com.google.api.services.calendar.model.AclRule content) throws java.io.IOException {
      Update result = new Update(calendarId, ruleId, content);
      initialize(result);
      return result;
    }

    public class Update extends CalendarRequest<com.google.api.services.calendar.model.AclRule> {

      private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";

      /**
       * Updates an access control rule.
       *
       * Create a request for the method "acl.update".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param ruleId ACL rule identifier.
       * @param content the {@link com.google.api.services.calendar.model.AclRule}
       * @since 1.13
       */
      protected Update(java.lang.String calendarId, java.lang.String ruleId, com.google.api.services.calendar.model.AclRule content) {
        super(Calendar.this, "PUT", REST_PATH, content, com.google.api.services.calendar.model.AclRule.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
        this.ruleId = com.google.api.client.util.Preconditions.checkNotNull(ruleId, "Required parameter ruleId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getScope(), "AclRule.getScope()");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getScope().getType(), "AclRule.getScope().getType()");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Update setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /** ACL rule identifier. */
      @com.google.api.client.util.Key
      private java.lang.String ruleId;

      /** ACL rule identifier.
       */
      public java.lang.String getRuleId() {
        return ruleId;
      }

      /** ACL rule identifier. */
      public Update setRuleId(java.lang.String ruleId) {
        this.ruleId = ruleId;
        return this;
      }

      /**
       * Whether to send notifications about the calendar sharing change. Note that there are no
       * notifications on access removal. Optional. The default is True.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sendNotifications;

      /** Whether to send notifications about the calendar sharing change. Note that there are no
     notifications on access removal. Optional. The default is True.
       */
      public java.lang.Boolean getSendNotifications() {
        return sendNotifications;
      }

      /**
       * Whether to send notifications about the calendar sharing change. Note that there are no
       * notifications on access removal. Optional. The default is True.
       */
      public Update setSendNotifications(java.lang.Boolean sendNotifications) {
        this.sendNotifications = sendNotifications;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
    /**
     * Watch for changes to ACL resources.
     *
     * Create a request for the method "acl.watch".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Watch#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param content the {@link com.google.api.services.calendar.model.Channel}
     * @return the request
     */
    public Watch watch(java.lang.String calendarId, com.google.api.services.calendar.model.Channel content) throws java.io.IOException {
      Watch result = new Watch(calendarId, content);
      initialize(result);
      return result;
    }

    public class Watch extends CalendarRequest<com.google.api.services.calendar.model.Channel> {

      private static final String REST_PATH = "calendars/{calendarId}/acl/watch";

      /**
       * Watch for changes to ACL resources.
       *
       * Create a request for the method "acl.watch".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Watch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Watch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param content the {@link com.google.api.services.calendar.model.Channel}
       * @since 1.13
       */
      protected Watch(java.lang.String calendarId, com.google.api.services.calendar.model.Channel content) {
        super(Calendar.this, "POST", REST_PATH, content, com.google.api.services.calendar.model.Channel.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public Watch setAlt(java.lang.String alt) {
        return (Watch) super.setAlt(alt);
      }

      @Override
      public Watch setFields(java.lang.String fields) {
        return (Watch) super.setFields(fields);
      }

      @Override
      public Watch setKey(java.lang.String key) {
        return (Watch) super.setKey(key);
      }

      @Override
      public Watch setOauthToken(java.lang.String oauthToken) {
        return (Watch) super.setOauthToken(oauthToken);
      }

      @Override
      public Watch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Watch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Watch setQuotaUser(java.lang.String quotaUser) {
        return (Watch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Watch setUserIp(java.lang.String userIp) {
        return (Watch) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Watch setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /**
       * Maximum number of entries returned on one result page. By default the value is 100 entries.
       * The page size can never be larger than 250 entries. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of entries returned on one result page. By default the value is 100 entries. The
     page size can never be larger than 250 entries. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of entries returned on one result page. By default the value is 100 entries.
       * The page size can never be larger than 250 entries. Optional.
       */
      public Watch setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Token specifying which result page to return. Optional. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Token specifying which result page to return. Optional.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Token specifying which result page to return. Optional. */
      public Watch setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Whether to include deleted ACLs in the result. Deleted ACLs are represented by role equal
       * to "none". Deleted ACLs will always be included if syncToken is provided. Optional. The
       * default is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean showDeleted;

      /** Whether to include deleted ACLs in the result. Deleted ACLs are represented by role equal to
     "none". Deleted ACLs will always be included if syncToken is provided. Optional. The default is
     False.
       */
      public java.lang.Boolean getShowDeleted() {
        return showDeleted;
      }

      /**
       * Whether to include deleted ACLs in the result. Deleted ACLs are represented by role equal
       * to "none". Deleted ACLs will always be included if syncToken is provided. Optional. The
       * default is False.
       */
      public Watch setShowDeleted(java.lang.Boolean showDeleted) {
        this.showDeleted = showDeleted;
        return this;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. All entries deleted since the previous list request will always be
       * in the result set and it is not allowed to set showDeleted to False. If the syncToken
       * expires, the server will respond with a 410 GONE response code and the client should clear
       * its storage and perform a full synchronization without any syncToken. Learn more about
       * incremental synchronization. Optional. The default is to return all entries.
       */
      @com.google.api.client.util.Key
      private java.lang.String syncToken;

      /** Token obtained from the nextSyncToken field returned on the last page of results from the previous
     list request. It makes the result of this list request contain only entries that have changed since
     then. All entries deleted since the previous list request will always be in the result set and it
     is not allowed to set showDeleted to False. If the syncToken expires, the server will respond with
     a 410 GONE response code and the client should clear its storage and perform a full synchronization
     without any syncToken. Learn more about incremental synchronization. Optional. The default is to
     return all entries.
       */
      public java.lang.String getSyncToken() {
        return syncToken;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. All entries deleted since the previous list request will always be
       * in the result set and it is not allowed to set showDeleted to False. If the syncToken
       * expires, the server will respond with a 410 GONE response code and the client should clear
       * its storage and perform a full synchronization without any syncToken. Learn more about
       * incremental synchronization. Optional. The default is to return all entries.
       */
      public Watch setSyncToken(java.lang.String syncToken) {
        this.syncToken = syncToken;
        return this;
      }

      @Override
      public Watch set(String parameterName, Object value) {
        return (Watch) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the CalendarList collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Calendar calendar = new Calendar(...);}
   *   {@code Calendar.CalendarList.List request = calendar.calendarList().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public CalendarList calendarList() {
    return new CalendarList();
  }

  /**
   * The "calendarList" collection of methods.
   */
  public class CalendarList {

    /**
     * Removes a calendar from the user's calendar list.
     *
     * Create a request for the method "calendarList.delete".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @return the request
     */
    public Delete delete(java.lang.String calendarId) throws java.io.IOException {
      Delete result = new Delete(calendarId);
      initialize(result);
      return result;
    }

    public class Delete extends CalendarRequest<Void> {

      private static final String REST_PATH = "users/me/calendarList/{calendarId}";

      /**
       * Removes a calendar from the user's calendar list.
       *
       * Create a request for the method "calendarList.delete".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @since 1.13
       */
      protected Delete(java.lang.String calendarId) {
        super(Calendar.this, "DELETE", REST_PATH, null, Void.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Delete setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns a calendar from the user's calendar list.
     *
     * Create a request for the method "calendarList.get".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @return the request
     */
    public Get get(java.lang.String calendarId) throws java.io.IOException {
      Get result = new Get(calendarId);
      initialize(result);
      return result;
    }

    public class Get extends CalendarRequest<com.google.api.services.calendar.model.CalendarListEntry> {

      private static final String REST_PATH = "users/me/calendarList/{calendarId}";

      /**
       * Returns a calendar from the user's calendar list.
       *
       * Create a request for the method "calendarList.get".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @since 1.13
       */
      protected Get(java.lang.String calendarId) {
        super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.CalendarListEntry.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Get setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Inserts an existing calendar into the user's calendar list.
     *
     * Create a request for the method "calendarList.insert".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.calendar.model.CalendarListEntry}
     * @return the request
     */
    public Insert insert(com.google.api.services.calendar.model.CalendarListEntry content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends CalendarRequest<com.google.api.services.calendar.model.CalendarListEntry> {

      private static final String REST_PATH = "users/me/calendarList";

      /**
       * Inserts an existing calendar into the user's calendar list.
       *
       * Create a request for the method "calendarList.insert".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.calendar.model.CalendarListEntry}
       * @since 1.13
       */
      protected Insert(com.google.api.services.calendar.model.CalendarListEntry content) {
        super(Calendar.this, "POST", REST_PATH, content, com.google.api.services.calendar.model.CalendarListEntry.class);
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getId(), "CalendarListEntry.getId()");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * Whether to use the foregroundColor and backgroundColor fields to write the calendar colors
       * (RGB). If this feature is used, the index-based colorId field will be set to the best
       * matching option automatically. Optional. The default is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean colorRgbFormat;

      /** Whether to use the foregroundColor and backgroundColor fields to write the calendar colors (RGB).
     If this feature is used, the index-based colorId field will be set to the best matching option
     automatically. Optional. The default is False.
       */
      public java.lang.Boolean getColorRgbFormat() {
        return colorRgbFormat;
      }

      /**
       * Whether to use the foregroundColor and backgroundColor fields to write the calendar colors
       * (RGB). If this feature is used, the index-based colorId field will be set to the best
       * matching option automatically. Optional. The default is False.
       */
      public Insert setColorRgbFormat(java.lang.Boolean colorRgbFormat) {
        this.colorRgbFormat = colorRgbFormat;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns the calendars on the user's calendar list.
     *
     * Create a request for the method "calendarList.list".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends CalendarRequest<com.google.api.services.calendar.model.CalendarList> {

      private static final String REST_PATH = "users/me/calendarList";

      /**
       * Returns the calendars on the user's calendar list.
       *
       * Create a request for the method "calendarList.list".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.CalendarList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * Maximum number of entries returned on one result page. By default the value is 100 entries.
       * The page size can never be larger than 250 entries. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of entries returned on one result page. By default the value is 100 entries. The
     page size can never be larger than 250 entries. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of entries returned on one result page. By default the value is 100 entries.
       * The page size can never be larger than 250 entries. Optional.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The minimum access role for the user in the returned entries. Optional. The default is no
       * restriction.
       */
      @com.google.api.client.util.Key
      private java.lang.String minAccessRole;

      /** The minimum access role for the user in the returned entries. Optional. The default is no
     restriction.
       */
      public java.lang.String getMinAccessRole() {
        return minAccessRole;
      }

      /**
       * The minimum access role for the user in the returned entries. Optional. The default is no
       * restriction.
       */
      public List setMinAccessRole(java.lang.String minAccessRole) {
        this.minAccessRole = minAccessRole;
        return this;
      }

      /** Token specifying which result page to return. Optional. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Token specifying which result page to return. Optional.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Token specifying which result page to return. Optional. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Whether to include deleted calendar list entries in the result. Optional. The default is
       * False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean showDeleted;

      /** Whether to include deleted calendar list entries in the result. Optional. The default is False.
       */
      public java.lang.Boolean getShowDeleted() {
        return showDeleted;
      }

      /**
       * Whether to include deleted calendar list entries in the result. Optional. The default is
       * False.
       */
      public List setShowDeleted(java.lang.Boolean showDeleted) {
        this.showDeleted = showDeleted;
        return this;
      }

      /** Whether to show hidden entries. Optional. The default is False. */
      @com.google.api.client.util.Key
      private java.lang.Boolean showHidden;

      /** Whether to show hidden entries. Optional. The default is False.
       */
      public java.lang.Boolean getShowHidden() {
        return showHidden;
      }

      /** Whether to show hidden entries. Optional. The default is False. */
      public List setShowHidden(java.lang.Boolean showHidden) {
        this.showHidden = showHidden;
        return this;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. If only read-only fields such as calendar properties or ACLs have
       * changed, the entry won't be returned. All entries deleted and hidden since the previous
       * list request will always be in the result set and it is not allowed to set showDeleted
       * neither showHidden to False. To ensure client state consistency minAccessRole query
       * parameter cannot be specified together with nextSyncToken. If the syncToken expires, the
       * server will respond with a 410 GONE response code and the client should clear its storage
       * and perform a full synchronization without any syncToken. Learn more about incremental
       * synchronization. Optional. The default is to return all entries.
       */
      @com.google.api.client.util.Key
      private java.lang.String syncToken;

      /** Token obtained from the nextSyncToken field returned on the last page of results from the previous
     list request. It makes the result of this list request contain only entries that have changed since
     then. If only read-only fields such as calendar properties or ACLs have changed, the entry won't be
     returned. All entries deleted and hidden since the previous list request will always be in the
     result set and it is not allowed to set showDeleted neither showHidden to False. To ensure client
     state consistency minAccessRole query parameter cannot be specified together with nextSyncToken. If
     the syncToken expires, the server will respond with a 410 GONE response code and the client should
     clear its storage and perform a full synchronization without any syncToken. Learn more about
     incremental synchronization. Optional. The default is to return all entries.
       */
      public java.lang.String getSyncToken() {
        return syncToken;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. If only read-only fields such as calendar properties or ACLs have
       * changed, the entry won't be returned. All entries deleted and hidden since the previous
       * list request will always be in the result set and it is not allowed to set showDeleted
       * neither showHidden to False. To ensure client state consistency minAccessRole query
       * parameter cannot be specified together with nextSyncToken. If the syncToken expires, the
       * server will respond with a 410 GONE response code and the client should clear its storage
       * and perform a full synchronization without any syncToken. Learn more about incremental
       * synchronization. Optional. The default is to return all entries.
       */
      public List setSyncToken(java.lang.String syncToken) {
        this.syncToken = syncToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing calendar on the user's calendar list. This method supports patch semantics.
     *
     * Create a request for the method "calendarList.patch".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param content the {@link com.google.api.services.calendar.model.CalendarListEntry}
     * @return the request
     */
    public Patch patch(java.lang.String calendarId, com.google.api.services.calendar.model.CalendarListEntry content) throws java.io.IOException {
      Patch result = new Patch(calendarId, content);
      initialize(result);
      return result;
    }

    public class Patch extends CalendarRequest<com.google.api.services.calendar.model.CalendarListEntry> {

      private static final String REST_PATH = "users/me/calendarList/{calendarId}";

      /**
       * Updates an existing calendar on the user's calendar list. This method supports patch semantics.
       *
       * Create a request for the method "calendarList.patch".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param content the {@link com.google.api.services.calendar.model.CalendarListEntry}
       * @since 1.13
       */
      protected Patch(java.lang.String calendarId, com.google.api.services.calendar.model.CalendarListEntry content) {
        super(Calendar.this, "PATCH", REST_PATH, content, com.google.api.services.calendar.model.CalendarListEntry.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Patch setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /**
       * Whether to use the foregroundColor and backgroundColor fields to write the calendar colors
       * (RGB). If this feature is used, the index-based colorId field will be set to the best
       * matching option automatically. Optional. The default is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean colorRgbFormat;

      /** Whether to use the foregroundColor and backgroundColor fields to write the calendar colors (RGB).
     If this feature is used, the index-based colorId field will be set to the best matching option
     automatically. Optional. The default is False.
       */
      public java.lang.Boolean getColorRgbFormat() {
        return colorRgbFormat;
      }

      /**
       * Whether to use the foregroundColor and backgroundColor fields to write the calendar colors
       * (RGB). If this feature is used, the index-based colorId field will be set to the best
       * matching option automatically. Optional. The default is False.
       */
      public Patch setColorRgbFormat(java.lang.Boolean colorRgbFormat) {
        this.colorRgbFormat = colorRgbFormat;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates an existing calendar on the user's calendar list.
     *
     * Create a request for the method "calendarList.update".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param content the {@link com.google.api.services.calendar.model.CalendarListEntry}
     * @return the request
     */
    public Update update(java.lang.String calendarId, com.google.api.services.calendar.model.CalendarListEntry content) throws java.io.IOException {
      Update result = new Update(calendarId, content);
      initialize(result);
      return result;
    }

    public class Update extends CalendarRequest<com.google.api.services.calendar.model.CalendarListEntry> {

      private static final String REST_PATH = "users/me/calendarList/{calendarId}";

      /**
       * Updates an existing calendar on the user's calendar list.
       *
       * Create a request for the method "calendarList.update".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param content the {@link com.google.api.services.calendar.model.CalendarListEntry}
       * @since 1.13
       */
      protected Update(java.lang.String calendarId, com.google.api.services.calendar.model.CalendarListEntry content) {
        super(Calendar.this, "PUT", REST_PATH, content, com.google.api.services.calendar.model.CalendarListEntry.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Update setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /**
       * Whether to use the foregroundColor and backgroundColor fields to write the calendar colors
       * (RGB). If this feature is used, the index-based colorId field will be set to the best
       * matching option automatically. Optional. The default is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean colorRgbFormat;

      /** Whether to use the foregroundColor and backgroundColor fields to write the calendar colors (RGB).
     If this feature is used, the index-based colorId field will be set to the best matching option
     automatically. Optional. The default is False.
       */
      public java.lang.Boolean getColorRgbFormat() {
        return colorRgbFormat;
      }

      /**
       * Whether to use the foregroundColor and backgroundColor fields to write the calendar colors
       * (RGB). If this feature is used, the index-based colorId field will be set to the best
       * matching option automatically. Optional. The default is False.
       */
      public Update setColorRgbFormat(java.lang.Boolean colorRgbFormat) {
        this.colorRgbFormat = colorRgbFormat;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
    /**
     * Watch for changes to CalendarList resources.
     *
     * Create a request for the method "calendarList.watch".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Watch#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.calendar.model.Channel}
     * @return the request
     */
    public Watch watch(com.google.api.services.calendar.model.Channel content) throws java.io.IOException {
      Watch result = new Watch(content);
      initialize(result);
      return result;
    }

    public class Watch extends CalendarRequest<com.google.api.services.calendar.model.Channel> {

      private static final String REST_PATH = "users/me/calendarList/watch";

      /**
       * Watch for changes to CalendarList resources.
       *
       * Create a request for the method "calendarList.watch".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Watch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Watch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.calendar.model.Channel}
       * @since 1.13
       */
      protected Watch(com.google.api.services.calendar.model.Channel content) {
        super(Calendar.this, "POST", REST_PATH, content, com.google.api.services.calendar.model.Channel.class);
      }

      @Override
      public Watch setAlt(java.lang.String alt) {
        return (Watch) super.setAlt(alt);
      }

      @Override
      public Watch setFields(java.lang.String fields) {
        return (Watch) super.setFields(fields);
      }

      @Override
      public Watch setKey(java.lang.String key) {
        return (Watch) super.setKey(key);
      }

      @Override
      public Watch setOauthToken(java.lang.String oauthToken) {
        return (Watch) super.setOauthToken(oauthToken);
      }

      @Override
      public Watch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Watch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Watch setQuotaUser(java.lang.String quotaUser) {
        return (Watch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Watch setUserIp(java.lang.String userIp) {
        return (Watch) super.setUserIp(userIp);
      }

      /**
       * Maximum number of entries returned on one result page. By default the value is 100 entries.
       * The page size can never be larger than 250 entries. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of entries returned on one result page. By default the value is 100 entries. The
     page size can never be larger than 250 entries. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of entries returned on one result page. By default the value is 100 entries.
       * The page size can never be larger than 250 entries. Optional.
       */
      public Watch setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The minimum access role for the user in the returned entries. Optional. The default is no
       * restriction.
       */
      @com.google.api.client.util.Key
      private java.lang.String minAccessRole;

      /** The minimum access role for the user in the returned entries. Optional. The default is no
     restriction.
       */
      public java.lang.String getMinAccessRole() {
        return minAccessRole;
      }

      /**
       * The minimum access role for the user in the returned entries. Optional. The default is no
       * restriction.
       */
      public Watch setMinAccessRole(java.lang.String minAccessRole) {
        this.minAccessRole = minAccessRole;
        return this;
      }

      /** Token specifying which result page to return. Optional. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Token specifying which result page to return. Optional.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Token specifying which result page to return. Optional. */
      public Watch setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Whether to include deleted calendar list entries in the result. Optional. The default is
       * False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean showDeleted;

      /** Whether to include deleted calendar list entries in the result. Optional. The default is False.
       */
      public java.lang.Boolean getShowDeleted() {
        return showDeleted;
      }

      /**
       * Whether to include deleted calendar list entries in the result. Optional. The default is
       * False.
       */
      public Watch setShowDeleted(java.lang.Boolean showDeleted) {
        this.showDeleted = showDeleted;
        return this;
      }

      /** Whether to show hidden entries. Optional. The default is False. */
      @com.google.api.client.util.Key
      private java.lang.Boolean showHidden;

      /** Whether to show hidden entries. Optional. The default is False.
       */
      public java.lang.Boolean getShowHidden() {
        return showHidden;
      }

      /** Whether to show hidden entries. Optional. The default is False. */
      public Watch setShowHidden(java.lang.Boolean showHidden) {
        this.showHidden = showHidden;
        return this;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. If only read-only fields such as calendar properties or ACLs have
       * changed, the entry won't be returned. All entries deleted and hidden since the previous
       * list request will always be in the result set and it is not allowed to set showDeleted
       * neither showHidden to False. To ensure client state consistency minAccessRole query
       * parameter cannot be specified together with nextSyncToken. If the syncToken expires, the
       * server will respond with a 410 GONE response code and the client should clear its storage
       * and perform a full synchronization without any syncToken. Learn more about incremental
       * synchronization. Optional. The default is to return all entries.
       */
      @com.google.api.client.util.Key
      private java.lang.String syncToken;

      /** Token obtained from the nextSyncToken field returned on the last page of results from the previous
     list request. It makes the result of this list request contain only entries that have changed since
     then. If only read-only fields such as calendar properties or ACLs have changed, the entry won't be
     returned. All entries deleted and hidden since the previous list request will always be in the
     result set and it is not allowed to set showDeleted neither showHidden to False. To ensure client
     state consistency minAccessRole query parameter cannot be specified together with nextSyncToken. If
     the syncToken expires, the server will respond with a 410 GONE response code and the client should
     clear its storage and perform a full synchronization without any syncToken. Learn more about
     incremental synchronization. Optional. The default is to return all entries.
       */
      public java.lang.String getSyncToken() {
        return syncToken;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. If only read-only fields such as calendar properties or ACLs have
       * changed, the entry won't be returned. All entries deleted and hidden since the previous
       * list request will always be in the result set and it is not allowed to set showDeleted
       * neither showHidden to False. To ensure client state consistency minAccessRole query
       * parameter cannot be specified together with nextSyncToken. If the syncToken expires, the
       * server will respond with a 410 GONE response code and the client should clear its storage
       * and perform a full synchronization without any syncToken. Learn more about incremental
       * synchronization. Optional. The default is to return all entries.
       */
      public Watch setSyncToken(java.lang.String syncToken) {
        this.syncToken = syncToken;
        return this;
      }

      @Override
      public Watch set(String parameterName, Object value) {
        return (Watch) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Calendars collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Calendar calendar = new Calendar(...);}
   *   {@code Calendar.Calendars.List request = calendar.calendars().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Calendars calendars() {
    return new Calendars();
  }

  /**
   * The "calendars" collection of methods.
   */
  public class Calendars {

    /**
     * Clears a primary calendar. This operation deletes all events associated with the primary calendar
     * of an account.
     *
     * Create a request for the method "calendars.clear".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Clear#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @return the request
     */
    public Clear clear(java.lang.String calendarId) throws java.io.IOException {
      Clear result = new Clear(calendarId);
      initialize(result);
      return result;
    }

    public class Clear extends CalendarRequest<Void> {

      private static final String REST_PATH = "calendars/{calendarId}/clear";

      /**
       * Clears a primary calendar. This operation deletes all events associated with the primary
       * calendar of an account.
       *
       * Create a request for the method "calendars.clear".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Clear#execute()} method to invoke the remote operation.
       * <p> {@link
       * Clear#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @since 1.13
       */
      protected Clear(java.lang.String calendarId) {
        super(Calendar.this, "POST", REST_PATH, null, Void.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public Clear setAlt(java.lang.String alt) {
        return (Clear) super.setAlt(alt);
      }

      @Override
      public Clear setFields(java.lang.String fields) {
        return (Clear) super.setFields(fields);
      }

      @Override
      public Clear setKey(java.lang.String key) {
        return (Clear) super.setKey(key);
      }

      @Override
      public Clear setOauthToken(java.lang.String oauthToken) {
        return (Clear) super.setOauthToken(oauthToken);
      }

      @Override
      public Clear setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Clear) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Clear setQuotaUser(java.lang.String quotaUser) {
        return (Clear) super.setQuotaUser(quotaUser);
      }

      @Override
      public Clear setUserIp(java.lang.String userIp) {
        return (Clear) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Clear setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      @Override
      public Clear set(String parameterName, Object value) {
        return (Clear) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a secondary calendar. Use calendars.clear for clearing all events on primary calendars.
     *
     * Create a request for the method "calendars.delete".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @return the request
     */
    public Delete delete(java.lang.String calendarId) throws java.io.IOException {
      Delete result = new Delete(calendarId);
      initialize(result);
      return result;
    }

    public class Delete extends CalendarRequest<Void> {

      private static final String REST_PATH = "calendars/{calendarId}";

      /**
       * Deletes a secondary calendar. Use calendars.clear for clearing all events on primary calendars.
       *
       * Create a request for the method "calendars.delete".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @since 1.13
       */
      protected Delete(java.lang.String calendarId) {
        super(Calendar.this, "DELETE", REST_PATH, null, Void.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Delete setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns metadata for a calendar.
     *
     * Create a request for the method "calendars.get".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @return the request
     */
    public Get get(java.lang.String calendarId) throws java.io.IOException {
      Get result = new Get(calendarId);
      initialize(result);
      return result;
    }

    public class Get extends CalendarRequest<com.google.api.services.calendar.model.Calendar> {

      private static final String REST_PATH = "calendars/{calendarId}";

      /**
       * Returns metadata for a calendar.
       *
       * Create a request for the method "calendars.get".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @since 1.13
       */
      protected Get(java.lang.String calendarId) {
        super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Calendar.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Get setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a secondary calendar.
     *
     * Create a request for the method "calendars.insert".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.calendar.model.Calendar}
     * @return the request
     */
    public Insert insert(com.google.api.services.calendar.model.Calendar content) throws java.io.IOException {
      Insert result = new Insert(content);
      initialize(result);
      return result;
    }

    public class Insert extends CalendarRequest<com.google.api.services.calendar.model.Calendar> {

      private static final String REST_PATH = "calendars";

      /**
       * Creates a secondary calendar.
       *
       * Create a request for the method "calendars.insert".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.calendar.model.Calendar}
       * @since 1.13
       */
      protected Insert(com.google.api.services.calendar.model.Calendar content) {
        super(Calendar.this, "POST", REST_PATH, content, com.google.api.services.calendar.model.Calendar.class);
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getSummary(), "Calendar.getSummary()");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Updates metadata for a calendar. This method supports patch semantics.
     *
     * Create a request for the method "calendars.patch".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param content the {@link com.google.api.services.calendar.model.Calendar}
     * @return the request
     */
    public Patch patch(java.lang.String calendarId, com.google.api.services.calendar.model.Calendar content) throws java.io.IOException {
      Patch result = new Patch(calendarId, content);
      initialize(result);
      return result;
    }

    public class Patch extends CalendarRequest<com.google.api.services.calendar.model.Calendar> {

      private static final String REST_PATH = "calendars/{calendarId}";

      /**
       * Updates metadata for a calendar. This method supports patch semantics.
       *
       * Create a request for the method "calendars.patch".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param content the {@link com.google.api.services.calendar.model.Calendar}
       * @since 1.13
       */
      protected Patch(java.lang.String calendarId, com.google.api.services.calendar.model.Calendar content) {
        super(Calendar.this, "PATCH", REST_PATH, content, com.google.api.services.calendar.model.Calendar.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Patch setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Updates metadata for a calendar.
     *
     * Create a request for the method "calendars.update".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param content the {@link com.google.api.services.calendar.model.Calendar}
     * @return the request
     */
    public Update update(java.lang.String calendarId, com.google.api.services.calendar.model.Calendar content) throws java.io.IOException {
      Update result = new Update(calendarId, content);
      initialize(result);
      return result;
    }

    public class Update extends CalendarRequest<com.google.api.services.calendar.model.Calendar> {

      private static final String REST_PATH = "calendars/{calendarId}";

      /**
       * Updates metadata for a calendar.
       *
       * Create a request for the method "calendars.update".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param content the {@link com.google.api.services.calendar.model.Calendar}
       * @since 1.13
       */
      protected Update(java.lang.String calendarId, com.google.api.services.calendar.model.Calendar content) {
        super(Calendar.this, "PUT", REST_PATH, content, com.google.api.services.calendar.model.Calendar.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Update setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Channels collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Calendar calendar = new Calendar(...);}
   *   {@code Calendar.Channels.List request = calendar.channels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Channels channels() {
    return new Channels();
  }

  /**
   * The "channels" collection of methods.
   */
  public class Channels {

    /**
     * Stop watching resources through this channel
     *
     * Create a request for the method "channels.stop".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Stop#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.calendar.model.Channel}
     * @return the request
     */
    public Stop stop(com.google.api.services.calendar.model.Channel content) throws java.io.IOException {
      Stop result = new Stop(content);
      initialize(result);
      return result;
    }

    public class Stop extends CalendarRequest<Void> {

      private static final String REST_PATH = "channels/stop";

      /**
       * Stop watching resources through this channel
       *
       * Create a request for the method "channels.stop".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Stop#execute()} method to invoke the remote operation. <p>
       * {@link Stop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.calendar.model.Channel}
       * @since 1.13
       */
      protected Stop(com.google.api.services.calendar.model.Channel content) {
        super(Calendar.this, "POST", REST_PATH, content, Void.class);
      }

      @Override
      public Stop setAlt(java.lang.String alt) {
        return (Stop) super.setAlt(alt);
      }

      @Override
      public Stop setFields(java.lang.String fields) {
        return (Stop) super.setFields(fields);
      }

      @Override
      public Stop setKey(java.lang.String key) {
        return (Stop) super.setKey(key);
      }

      @Override
      public Stop setOauthToken(java.lang.String oauthToken) {
        return (Stop) super.setOauthToken(oauthToken);
      }

      @Override
      public Stop setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Stop) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Stop setQuotaUser(java.lang.String quotaUser) {
        return (Stop) super.setQuotaUser(quotaUser);
      }

      @Override
      public Stop setUserIp(java.lang.String userIp) {
        return (Stop) super.setUserIp(userIp);
      }

      @Override
      public Stop set(String parameterName, Object value) {
        return (Stop) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Colors collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Calendar calendar = new Calendar(...);}
   *   {@code Calendar.Colors.List request = calendar.colors().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Colors colors() {
    return new Colors();
  }

  /**
   * The "colors" collection of methods.
   */
  public class Colors {

    /**
     * Returns the color definitions for calendars and events.
     *
     * Create a request for the method "colors.get".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public Get get() throws java.io.IOException {
      Get result = new Get();
      initialize(result);
      return result;
    }

    public class Get extends CalendarRequest<com.google.api.services.calendar.model.Colors> {

      private static final String REST_PATH = "colors";

      /**
       * Returns the color definitions for calendars and events.
       *
       * Create a request for the method "colors.get".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected Get() {
        super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Colors.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Events collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Calendar calendar = new Calendar(...);}
   *   {@code Calendar.Events.List request = calendar.events().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Events events() {
    return new Events();
  }

  /**
   * The "events" collection of methods.
   */
  public class Events {

    /**
     * Deletes an event.
     *
     * Create a request for the method "events.delete".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param eventId Event identifier.
     * @return the request
     */
    public Delete delete(java.lang.String calendarId, java.lang.String eventId) throws java.io.IOException {
      Delete result = new Delete(calendarId, eventId);
      initialize(result);
      return result;
    }

    public class Delete extends CalendarRequest<Void> {

      private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";

      /**
       * Deletes an event.
       *
       * Create a request for the method "events.delete".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param eventId Event identifier.
       * @since 1.13
       */
      protected Delete(java.lang.String calendarId, java.lang.String eventId) {
        super(Calendar.this, "DELETE", REST_PATH, null, Void.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
        this.eventId = com.google.api.client.util.Preconditions.checkNotNull(eventId, "Required parameter eventId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Delete setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /** Event identifier. */
      @com.google.api.client.util.Key
      private java.lang.String eventId;

      /** Event identifier.
       */
      public java.lang.String getEventId() {
        return eventId;
      }

      /** Event identifier. */
      public Delete setEventId(java.lang.String eventId) {
        this.eventId = eventId;
        return this;
      }

      /**
       * Deprecated. Please use sendUpdates instead.
       *
       * Whether to send notifications about the deletion of the event. Note that some emails might
       * still be sent even if you set the value to false. The default is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sendNotifications;

      /** Deprecated. Please use sendUpdates instead.

     Whether to send notifications about the deletion of the event. Note that some emails might still be
     sent even if you set the value to false. The default is false.
       */
      public java.lang.Boolean getSendNotifications() {
        return sendNotifications;
      }

      /**
       * Deprecated. Please use sendUpdates instead.
       *
       * Whether to send notifications about the deletion of the event. Note that some emails might
       * still be sent even if you set the value to false. The default is false.
       */
      public Delete setSendNotifications(java.lang.Boolean sendNotifications) {
        this.sendNotifications = sendNotifications;
        return this;
      }

      /** Guests who should receive notifications about the deletion of the event. */
      @com.google.api.client.util.Key
      private java.lang.String sendUpdates;

      /** Guests who should receive notifications about the deletion of the event.
       */
      public java.lang.String getSendUpdates() {
        return sendUpdates;
      }

      /** Guests who should receive notifications about the deletion of the event. */
      public Delete setSendUpdates(java.lang.String sendUpdates) {
        this.sendUpdates = sendUpdates;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns an event based on its Google Calendar ID. To retrieve an event using its iCalendar ID,
     * call the events.list method using the iCalUID parameter.
     *
     * Create a request for the method "events.get".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param eventId Event identifier.
     * @return the request
     */
    public Get get(java.lang.String calendarId, java.lang.String eventId) throws java.io.IOException {
      Get result = new Get(calendarId, eventId);
      initialize(result);
      return result;
    }

    public class Get extends CalendarRequest<com.google.api.services.calendar.model.Event> {

      private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";

      /**
       * Returns an event based on its Google Calendar ID. To retrieve an event using its iCalendar ID,
       * call the events.list method using the iCalUID parameter.
       *
       * Create a request for the method "events.get".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param eventId Event identifier.
       * @since 1.13
       */
      protected Get(java.lang.String calendarId, java.lang.String eventId) {
        super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Event.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
        this.eventId = com.google.api.client.util.Preconditions.checkNotNull(eventId, "Required parameter eventId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Get setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /** Event identifier. */
      @com.google.api.client.util.Key
      private java.lang.String eventId;

      /** Event identifier.
       */
      public java.lang.String getEventId() {
        return eventId;
      }

      /** Event identifier. */
      public Get setEventId(java.lang.String eventId) {
        this.eventId = eventId;
        return this;
      }

      /**
       * Deprecated and ignored. A value will always be returned in the email field for the
       * organizer, creator and attendees, even if no real email address is available (i.e. a
       * generated, non-working value will be provided).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean alwaysIncludeEmail;

      /** Deprecated and ignored. A value will always be returned in the email field for the organizer,
     creator and attendees, even if no real email address is available (i.e. a generated, non-working
     value will be provided).
       */
      public java.lang.Boolean getAlwaysIncludeEmail() {
        return alwaysIncludeEmail;
      }

      /**
       * Deprecated and ignored. A value will always be returned in the email field for the
       * organizer, creator and attendees, even if no real email address is available (i.e. a
       * generated, non-working value will be provided).
       */
      public Get setAlwaysIncludeEmail(java.lang.Boolean alwaysIncludeEmail) {
        this.alwaysIncludeEmail = alwaysIncludeEmail;
        return this;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxAttendees;

      /** The maximum number of attendees to include in the response. If there are more than the specified
     number of attendees, only the participant is returned. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxAttendees() {
        return maxAttendees;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      public Get setMaxAttendees(java.lang.Integer maxAttendees) {
        this.maxAttendees = maxAttendees;
        return this;
      }

      /**
       * Time zone used in the response. Optional. The default is the time zone of the calendar.
       */
      @com.google.api.client.util.Key
      private java.lang.String timeZone;

      /** Time zone used in the response. Optional. The default is the time zone of the calendar.
       */
      public java.lang.String getTimeZone() {
        return timeZone;
      }

      /**
       * Time zone used in the response. Optional. The default is the time zone of the calendar.
       */
      public Get setTimeZone(java.lang.String timeZone) {
        this.timeZone = timeZone;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Imports an event. This operation is used to add a private copy of an existing event to a
     * calendar. Only events with an eventType of default may be imported. Deprecated behavior: If a
     * non-default event is imported, its type will be changed to default and any event-type-specific
     * properties it may have will be dropped.
     *
     * Create a request for the method "events.import".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link CalendarImport#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param content the {@link com.google.api.services.calendar.model.Event}
     * @return the request
     */
    public CalendarImport calendarImport(java.lang.String calendarId, com.google.api.services.calendar.model.Event content) throws java.io.IOException {
      CalendarImport result = new CalendarImport(calendarId, content);
      initialize(result);
      return result;
    }

    public class CalendarImport extends CalendarRequest<com.google.api.services.calendar.model.Event> {

      private static final String REST_PATH = "calendars/{calendarId}/events/import";

      /**
       * Imports an event. This operation is used to add a private copy of an existing event to a
       * calendar. Only events with an eventType of default may be imported. Deprecated behavior: If a
       * non-default event is imported, its type will be changed to default and any event-type-specific
       * properties it may have will be dropped.
       *
       * Create a request for the method "events.import".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link CalendarImport#execute()} method to invoke the remote
       * operation. <p> {@link CalendarImport#initialize(com.google.api.client.googleapis.services.Abstr
       * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param content the {@link com.google.api.services.calendar.model.Event}
       * @since 1.13
       */
      protected CalendarImport(java.lang.String calendarId, com.google.api.services.calendar.model.Event content) {
        super(Calendar.this, "POST", REST_PATH, content, com.google.api.services.calendar.model.Event.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getICalUID(), "Event.getICalUID()");
      }

      @Override
      public CalendarImport setAlt(java.lang.String alt) {
        return (CalendarImport) super.setAlt(alt);
      }

      @Override
      public CalendarImport setFields(java.lang.String fields) {
        return (CalendarImport) super.setFields(fields);
      }

      @Override
      public CalendarImport setKey(java.lang.String key) {
        return (CalendarImport) super.setKey(key);
      }

      @Override
      public CalendarImport setOauthToken(java.lang.String oauthToken) {
        return (CalendarImport) super.setOauthToken(oauthToken);
      }

      @Override
      public CalendarImport setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (CalendarImport) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CalendarImport setQuotaUser(java.lang.String quotaUser) {
        return (CalendarImport) super.setQuotaUser(quotaUser);
      }

      @Override
      public CalendarImport setUserIp(java.lang.String userIp) {
        return (CalendarImport) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public CalendarImport setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /**
       * Version number of conference data supported by the API client. Version 0 assumes no
       * conference data support and ignores conference data in the event's body. Version 1 enables
       * support for copying of ConferenceData as well as for creating new conferences using the
       * createRequest field of conferenceData. The default is 0.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer conferenceDataVersion;

      /** Version number of conference data supported by the API client. Version 0 assumes no conference data
     support and ignores conference data in the event's body. Version 1 enables support for copying of
     ConferenceData as well as for creating new conferences using the createRequest field of
     conferenceData. The default is 0.

     [minimum: 0] [maximum: 1]
       */
      public java.lang.Integer getConferenceDataVersion() {
        return conferenceDataVersion;
      }

      /**
       * Version number of conference data supported by the API client. Version 0 assumes no
       * conference data support and ignores conference data in the event's body. Version 1 enables
       * support for copying of ConferenceData as well as for creating new conferences using the
       * createRequest field of conferenceData. The default is 0.
       */
      public CalendarImport setConferenceDataVersion(java.lang.Integer conferenceDataVersion) {
        this.conferenceDataVersion = conferenceDataVersion;
        return this;
      }

      /**
       * Whether API client performing operation supports event attachments. Optional. The default
       * is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAttachments;

      /** Whether API client performing operation supports event attachments. Optional. The default is False.
       */
      public java.lang.Boolean getSupportsAttachments() {
        return supportsAttachments;
      }

      /**
       * Whether API client performing operation supports event attachments. Optional. The default
       * is False.
       */
      public CalendarImport setSupportsAttachments(java.lang.Boolean supportsAttachments) {
        this.supportsAttachments = supportsAttachments;
        return this;
      }

      @Override
      public CalendarImport set(String parameterName, Object value) {
        return (CalendarImport) super.set(parameterName, value);
      }
    }
    /**
     * Creates an event.
     *
     * Create a request for the method "events.insert".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param content the {@link com.google.api.services.calendar.model.Event}
     * @return the request
     */
    public Insert insert(java.lang.String calendarId, com.google.api.services.calendar.model.Event content) throws java.io.IOException {
      Insert result = new Insert(calendarId, content);
      initialize(result);
      return result;
    }

    public class Insert extends CalendarRequest<com.google.api.services.calendar.model.Event> {

      private static final String REST_PATH = "calendars/{calendarId}/events";

      /**
       * Creates an event.
       *
       * Create a request for the method "events.insert".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param content the {@link com.google.api.services.calendar.model.Event}
       * @since 1.13
       */
      protected Insert(java.lang.String calendarId, com.google.api.services.calendar.model.Event content) {
        super(Calendar.this, "POST", REST_PATH, content, com.google.api.services.calendar.model.Event.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUserIp(java.lang.String userIp) {
        return (Insert) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Insert setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /**
       * Version number of conference data supported by the API client. Version 0 assumes no
       * conference data support and ignores conference data in the event's body. Version 1 enables
       * support for copying of ConferenceData as well as for creating new conferences using the
       * createRequest field of conferenceData. The default is 0.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer conferenceDataVersion;

      /** Version number of conference data supported by the API client. Version 0 assumes no conference data
     support and ignores conference data in the event's body. Version 1 enables support for copying of
     ConferenceData as well as for creating new conferences using the createRequest field of
     conferenceData. The default is 0.

     [minimum: 0] [maximum: 1]
       */
      public java.lang.Integer getConferenceDataVersion() {
        return conferenceDataVersion;
      }

      /**
       * Version number of conference data supported by the API client. Version 0 assumes no
       * conference data support and ignores conference data in the event's body. Version 1 enables
       * support for copying of ConferenceData as well as for creating new conferences using the
       * createRequest field of conferenceData. The default is 0.
       */
      public Insert setConferenceDataVersion(java.lang.Integer conferenceDataVersion) {
        this.conferenceDataVersion = conferenceDataVersion;
        return this;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxAttendees;

      /** The maximum number of attendees to include in the response. If there are more than the specified
     number of attendees, only the participant is returned. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxAttendees() {
        return maxAttendees;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      public Insert setMaxAttendees(java.lang.Integer maxAttendees) {
        this.maxAttendees = maxAttendees;
        return this;
      }

      /**
       * Deprecated. Please use sendUpdates instead.
       *
       * Whether to send notifications about the creation of the new event. Note that some emails
       * might still be sent even if you set the value to false. The default is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sendNotifications;

      /** Deprecated. Please use sendUpdates instead.

     Whether to send notifications about the creation of the new event. Note that some emails might
     still be sent even if you set the value to false. The default is false.
       */
      public java.lang.Boolean getSendNotifications() {
        return sendNotifications;
      }

      /**
       * Deprecated. Please use sendUpdates instead.
       *
       * Whether to send notifications about the creation of the new event. Note that some emails
       * might still be sent even if you set the value to false. The default is false.
       */
      public Insert setSendNotifications(java.lang.Boolean sendNotifications) {
        this.sendNotifications = sendNotifications;
        return this;
      }

      /**
       * Whether to send notifications about the creation of the new event. Note that some emails
       * might still be sent. The default is false.
       */
      @com.google.api.client.util.Key
      private java.lang.String sendUpdates;

      /** Whether to send notifications about the creation of the new event. Note that some emails might
     still be sent. The default is false.
       */
      public java.lang.String getSendUpdates() {
        return sendUpdates;
      }

      /**
       * Whether to send notifications about the creation of the new event. Note that some emails
       * might still be sent. The default is false.
       */
      public Insert setSendUpdates(java.lang.String sendUpdates) {
        this.sendUpdates = sendUpdates;
        return this;
      }

      /**
       * Whether API client performing operation supports event attachments. Optional. The default
       * is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAttachments;

      /** Whether API client performing operation supports event attachments. Optional. The default is False.
       */
      public java.lang.Boolean getSupportsAttachments() {
        return supportsAttachments;
      }

      /**
       * Whether API client performing operation supports event attachments. Optional. The default
       * is False.
       */
      public Insert setSupportsAttachments(java.lang.Boolean supportsAttachments) {
        this.supportsAttachments = supportsAttachments;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Returns instances of the specified recurring event.
     *
     * Create a request for the method "events.instances".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Instances#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param eventId Recurring event identifier.
     * @return the request
     */
    public Instances instances(java.lang.String calendarId, java.lang.String eventId) throws java.io.IOException {
      Instances result = new Instances(calendarId, eventId);
      initialize(result);
      return result;
    }

    public class Instances extends CalendarRequest<com.google.api.services.calendar.model.Events> {

      private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}/instances";

      /**
       * Returns instances of the specified recurring event.
       *
       * Create a request for the method "events.instances".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Instances#execute()} method to invoke the remote
       * operation. <p> {@link
       * Instances#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param eventId Recurring event identifier.
       * @since 1.13
       */
      protected Instances(java.lang.String calendarId, java.lang.String eventId) {
        super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Events.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
        this.eventId = com.google.api.client.util.Preconditions.checkNotNull(eventId, "Required parameter eventId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Instances setAlt(java.lang.String alt) {
        return (Instances) super.setAlt(alt);
      }

      @Override
      public Instances setFields(java.lang.String fields) {
        return (Instances) super.setFields(fields);
      }

      @Override
      public Instances setKey(java.lang.String key) {
        return (Instances) super.setKey(key);
      }

      @Override
      public Instances setOauthToken(java.lang.String oauthToken) {
        return (Instances) super.setOauthToken(oauthToken);
      }

      @Override
      public Instances setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Instances) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Instances setQuotaUser(java.lang.String quotaUser) {
        return (Instances) super.setQuotaUser(quotaUser);
      }

      @Override
      public Instances setUserIp(java.lang.String userIp) {
        return (Instances) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Instances setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /** Recurring event identifier. */
      @com.google.api.client.util.Key
      private java.lang.String eventId;

      /** Recurring event identifier.
       */
      public java.lang.String getEventId() {
        return eventId;
      }

      /** Recurring event identifier. */
      public Instances setEventId(java.lang.String eventId) {
        this.eventId = eventId;
        return this;
      }

      /**
       * Deprecated and ignored. A value will always be returned in the email field for the
       * organizer, creator and attendees, even if no real email address is available (i.e. a
       * generated, non-working value will be provided).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean alwaysIncludeEmail;

      /** Deprecated and ignored. A value will always be returned in the email field for the organizer,
     creator and attendees, even if no real email address is available (i.e. a generated, non-working
     value will be provided).
       */
      public java.lang.Boolean getAlwaysIncludeEmail() {
        return alwaysIncludeEmail;
      }

      /**
       * Deprecated and ignored. A value will always be returned in the email field for the
       * organizer, creator and attendees, even if no real email address is available (i.e. a
       * generated, non-working value will be provided).
       */
      public Instances setAlwaysIncludeEmail(java.lang.Boolean alwaysIncludeEmail) {
        this.alwaysIncludeEmail = alwaysIncludeEmail;
        return this;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxAttendees;

      /** The maximum number of attendees to include in the response. If there are more than the specified
     number of attendees, only the participant is returned. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxAttendees() {
        return maxAttendees;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      public Instances setMaxAttendees(java.lang.Integer maxAttendees) {
        this.maxAttendees = maxAttendees;
        return this;
      }

      /**
       * Maximum number of events returned on one result page. By default the value is 250 events.
       * The page size can never be larger than 2500 events. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of events returned on one result page. By default the value is 250 events. The page
     size can never be larger than 2500 events. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of events returned on one result page. By default the value is 250 events.
       * The page size can never be larger than 2500 events. Optional.
       */
      public Instances setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** The original start time of the instance in the result. Optional. */
      @com.google.api.client.util.Key
      private java.lang.String originalStart;

      /** The original start time of the instance in the result. Optional.
       */
      public java.lang.String getOriginalStart() {
        return originalStart;
      }

      /** The original start time of the instance in the result. Optional. */
      public Instances setOriginalStart(java.lang.String originalStart) {
        this.originalStart = originalStart;
        return this;
      }

      /** Token specifying which result page to return. Optional. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Token specifying which result page to return. Optional.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Token specifying which result page to return. Optional. */
      public Instances setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Whether to include deleted events (with status equals "cancelled") in the result. Cancelled
       * instances of recurring events will still be included if singleEvents is False. Optional.
       * The default is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean showDeleted;

      /** Whether to include deleted events (with status equals "cancelled") in the result. Cancelled
     instances of recurring events will still be included if singleEvents is False. Optional. The
     default is False.
       */
      public java.lang.Boolean getShowDeleted() {
        return showDeleted;
      }

      /**
       * Whether to include deleted events (with status equals "cancelled") in the result. Cancelled
       * instances of recurring events will still be included if singleEvents is False. Optional.
       * The default is False.
       */
      public Instances setShowDeleted(java.lang.Boolean showDeleted) {
        this.showDeleted = showDeleted;
        return this;
      }

      /**
       * Upper bound (exclusive) for an event's start time to filter by. Optional. The default is
       * not to filter by start time. Must be an RFC3339 timestamp with mandatory time zone offset.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime timeMax;

      /** Upper bound (exclusive) for an event's start time to filter by. Optional. The default is not to
     filter by start time. Must be an RFC3339 timestamp with mandatory time zone offset.
       */
      public com.google.api.client.util.DateTime getTimeMax() {
        return timeMax;
      }

      /**
       * Upper bound (exclusive) for an event's start time to filter by. Optional. The default is
       * not to filter by start time. Must be an RFC3339 timestamp with mandatory time zone offset.
       */
      public Instances setTimeMax(com.google.api.client.util.DateTime timeMax) {
        this.timeMax = timeMax;
        return this;
      }

      /**
       * Lower bound (inclusive) for an event's end time to filter by. Optional. The default is not
       * to filter by end time. Must be an RFC3339 timestamp with mandatory time zone offset.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime timeMin;

      /** Lower bound (inclusive) for an event's end time to filter by. Optional. The default is not to
     filter by end time. Must be an RFC3339 timestamp with mandatory time zone offset.
       */
      public com.google.api.client.util.DateTime getTimeMin() {
        return timeMin;
      }

      /**
       * Lower bound (inclusive) for an event's end time to filter by. Optional. The default is not
       * to filter by end time. Must be an RFC3339 timestamp with mandatory time zone offset.
       */
      public Instances setTimeMin(com.google.api.client.util.DateTime timeMin) {
        this.timeMin = timeMin;
        return this;
      }

      /**
       * Time zone used in the response. Optional. The default is the time zone of the calendar.
       */
      @com.google.api.client.util.Key
      private java.lang.String timeZone;

      /** Time zone used in the response. Optional. The default is the time zone of the calendar.
       */
      public java.lang.String getTimeZone() {
        return timeZone;
      }

      /**
       * Time zone used in the response. Optional. The default is the time zone of the calendar.
       */
      public Instances setTimeZone(java.lang.String timeZone) {
        this.timeZone = timeZone;
        return this;
      }

      @Override
      public Instances set(String parameterName, Object value) {
        return (Instances) super.set(parameterName, value);
      }
    }
    /**
     * Returns events on the specified calendar.
     *
     * Create a request for the method "events.list".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @return the request
     */
    public List list(java.lang.String calendarId) throws java.io.IOException {
      List result = new List(calendarId);
      initialize(result);
      return result;
    }

    public class List extends CalendarRequest<com.google.api.services.calendar.model.Events> {

      private static final String REST_PATH = "calendars/{calendarId}/events";

      /**
       * Returns events on the specified calendar.
       *
       * Create a request for the method "events.list".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @since 1.13
       */
      protected List(java.lang.String calendarId) {
        super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Events.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public List setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /** Deprecated and ignored. */
      @com.google.api.client.util.Key
      private java.lang.Boolean alwaysIncludeEmail;

      /** Deprecated and ignored.
       */
      public java.lang.Boolean getAlwaysIncludeEmail() {
        return alwaysIncludeEmail;
      }

      /** Deprecated and ignored. */
      public List setAlwaysIncludeEmail(java.lang.Boolean alwaysIncludeEmail) {
        this.alwaysIncludeEmail = alwaysIncludeEmail;
        return this;
      }

      /**
       * Event types to return. Optional. This parameter can be repeated multiple times to return
       * events of different types. If unset, returns all event types.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> eventTypes;

      /** Event types to return. Optional. This parameter can be repeated multiple times to return events of
     different types. If unset, returns all event types.
       */
      public java.util.List<java.lang.String> getEventTypes() {
        return eventTypes;
      }

      /**
       * Event types to return. Optional. This parameter can be repeated multiple times to return
       * events of different types. If unset, returns all event types.
       */
      public List setEventTypes(java.util.List<java.lang.String> eventTypes) {
        this.eventTypes = eventTypes;
        return this;
      }

      /**
       * Specifies an event ID in the iCalendar format to be provided in the response. Optional. Use
       * this if you want to search for an event by its iCalendar ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String iCalUID;

      /** Specifies an event ID in the iCalendar format to be provided in the response. Optional. Use this if
     you want to search for an event by its iCalendar ID.
       */
      public java.lang.String getICalUID() {
        return iCalUID;
      }

      /**
       * Specifies an event ID in the iCalendar format to be provided in the response. Optional. Use
       * this if you want to search for an event by its iCalendar ID.
       */
      public List setICalUID(java.lang.String iCalUID) {
        this.iCalUID = iCalUID;
        return this;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxAttendees;

      /** The maximum number of attendees to include in the response. If there are more than the specified
     number of attendees, only the participant is returned. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxAttendees() {
        return maxAttendees;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      public List setMaxAttendees(java.lang.Integer maxAttendees) {
        this.maxAttendees = maxAttendees;
        return this;
      }

      /**
       * Maximum number of events returned on one result page. The number of events in the resulting
       * page may be less than this value, or none at all, even if there are more events matching
       * the query. Incomplete pages can be detected by a non-empty nextPageToken field in the
       * response. By default the value is 250 events. The page size can never be larger than 2500
       * events. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of events returned on one result page. The number of events in the resulting page
     may be less than this value, or none at all, even if there are more events matching the query.
     Incomplete pages can be detected by a non-empty nextPageToken field in the response. By default the
     value is 250 events. The page size can never be larger than 2500 events. Optional. [default: 250]
     [minimum: 1]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of events returned on one result page. The number of events in the resulting
       * page may be less than this value, or none at all, even if there are more events matching
       * the query. Incomplete pages can be detected by a non-empty nextPageToken field in the
       * response. By default the value is 250 events. The page size can never be larger than 2500
       * events. Optional.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The order of the events returned in the result. Optional. The default is an unspecified,
       * stable order.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** The order of the events returned in the result. Optional. The default is an unspecified, stable
     order.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * The order of the events returned in the result. Optional. The default is an unspecified,
       * stable order.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /** Token specifying which result page to return. Optional. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Token specifying which result page to return. Optional.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Token specifying which result page to return. Optional. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Extended properties constraint specified as propertyName=value. Matches only private
       * properties. This parameter might be repeated multiple times to return events that match all
       * given constraints.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> privateExtendedProperty;

      /** Extended properties constraint specified as propertyName=value. Matches only private properties.
     This parameter might be repeated multiple times to return events that match all given constraints.
       */
      public java.util.List<java.lang.String> getPrivateExtendedProperty() {
        return privateExtendedProperty;
      }

      /**
       * Extended properties constraint specified as propertyName=value. Matches only private
       * properties. This parameter might be repeated multiple times to return events that match all
       * given constraints.
       */
      public List setPrivateExtendedProperty(java.util.List<java.lang.String> privateExtendedProperty) {
        this.privateExtendedProperty = privateExtendedProperty;
        return this;
      }

      /**
       * Free text search terms to find events that match these terms in the following fields:
       *
       * - summary - description - location - attendee's displayName - attendee's email -
       * organizer's displayName - organizer's email -
       * workingLocationProperties.officeLocation.buildingId -
       * workingLocationProperties.officeLocation.deskId -
       * workingLocationProperties.officeLocation.label -
       * workingLocationProperties.customLocation.label These search terms also match predefined
       * keywords against all display title translations of working location, out-of-office, and
       * focus-time events. For example, searching for "Office" or "Bureau" returns working location
       * events of type officeLocation, whereas searching for "Out of office" or "Abwesend" returns
       * out-of-office events. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** Free text search terms to find events that match these terms in the following fields:

     - summary - description - location - attendee's displayName - attendee's email - organizer's
     displayName - organizer's email - workingLocationProperties.officeLocation.buildingId -
     workingLocationProperties.officeLocation.deskId - workingLocationProperties.officeLocation.label -
     workingLocationProperties.customLocation.label These search terms also match predefined keywords
     against all display title translations of working location, out-of-office, and focus-time events.
     For example, searching for "Office" or "Bureau" returns working location events of type
     officeLocation, whereas searching for "Out of office" or "Abwesend" returns out-of-office events.
     Optional.
       */
      public java.lang.String getQ() {
        return q;
      }

      /**
       * Free text search terms to find events that match these terms in the following fields:
       *
       * - summary - description - location - attendee's displayName - attendee's email -
       * organizer's displayName - organizer's email -
       * workingLocationProperties.officeLocation.buildingId -
       * workingLocationProperties.officeLocation.deskId -
       * workingLocationProperties.officeLocation.label -
       * workingLocationProperties.customLocation.label These search terms also match predefined
       * keywords against all display title translations of working location, out-of-office, and
       * focus-time events. For example, searching for "Office" or "Bureau" returns working location
       * events of type officeLocation, whereas searching for "Out of office" or "Abwesend" returns
       * out-of-office events. Optional.
       */
      public List setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /**
       * Extended properties constraint specified as propertyName=value. Matches only shared
       * properties. This parameter might be repeated multiple times to return events that match all
       * given constraints.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> sharedExtendedProperty;

      /** Extended properties constraint specified as propertyName=value. Matches only shared properties.
     This parameter might be repeated multiple times to return events that match all given constraints.
       */
      public java.util.List<java.lang.String> getSharedExtendedProperty() {
        return sharedExtendedProperty;
      }

      /**
       * Extended properties constraint specified as propertyName=value. Matches only shared
       * properties. This parameter might be repeated multiple times to return events that match all
       * given constraints.
       */
      public List setSharedExtendedProperty(java.util.List<java.lang.String> sharedExtendedProperty) {
        this.sharedExtendedProperty = sharedExtendedProperty;
        return this;
      }

      /**
       * Whether to include deleted events (with status equals "cancelled") in the result. Cancelled
       * instances of recurring events (but not the underlying recurring event) will still be
       * included if showDeleted and singleEvents are both False. If showDeleted and singleEvents
       * are both True, only single instances of deleted events (but not the underlying recurring
       * events) are returned. Optional. The default is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean showDeleted;

      /** Whether to include deleted events (with status equals "cancelled") in the result. Cancelled
     instances of recurring events (but not the underlying recurring event) will still be included if
     showDeleted and singleEvents are both False. If showDeleted and singleEvents are both True, only
     single instances of deleted events (but not the underlying recurring events) are returned.
     Optional. The default is False.
       */
      public java.lang.Boolean getShowDeleted() {
        return showDeleted;
      }

      /**
       * Whether to include deleted events (with status equals "cancelled") in the result. Cancelled
       * instances of recurring events (but not the underlying recurring event) will still be
       * included if showDeleted and singleEvents are both False. If showDeleted and singleEvents
       * are both True, only single instances of deleted events (but not the underlying recurring
       * events) are returned. Optional. The default is False.
       */
      public List setShowDeleted(java.lang.Boolean showDeleted) {
        this.showDeleted = showDeleted;
        return this;
      }

      /** Whether to include hidden invitations in the result. Optional. The default is False. */
      @com.google.api.client.util.Key
      private java.lang.Boolean showHiddenInvitations;

      /** Whether to include hidden invitations in the result. Optional. The default is False.
       */
      public java.lang.Boolean getShowHiddenInvitations() {
        return showHiddenInvitations;
      }

      /** Whether to include hidden invitations in the result. Optional. The default is False. */
      public List setShowHiddenInvitations(java.lang.Boolean showHiddenInvitations) {
        this.showHiddenInvitations = showHiddenInvitations;
        return this;
      }

      /**
       * Whether to expand recurring events into instances and only return single one-off events and
       * instances of recurring events, but not the underlying recurring events themselves.
       * Optional. The default is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean singleEvents;

      /** Whether to expand recurring events into instances and only return single one-off events and
     instances of recurring events, but not the underlying recurring events themselves. Optional. The
     default is False.
       */
      public java.lang.Boolean getSingleEvents() {
        return singleEvents;
      }

      /**
       * Whether to expand recurring events into instances and only return single one-off events and
       * instances of recurring events, but not the underlying recurring events themselves.
       * Optional. The default is False.
       */
      public List setSingleEvents(java.lang.Boolean singleEvents) {
        this.singleEvents = singleEvents;
        return this;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. All events deleted since the previous list request will always be
       * in the result set and it is not allowed to set showDeleted to False. There are several
       * query parameters that cannot be specified together with nextSyncToken to ensure consistency
       * of the client state.
       *
       * These are: - iCalUID - orderBy - privateExtendedProperty - q - sharedExtendedProperty -
       * timeMin - timeMax - updatedMin All other query parameters should be the same as for the
       * initial synchronization to avoid undefined behavior. If the syncToken expires, the server
       * will respond with a 410 GONE response code and the client should clear its storage and
       * perform a full synchronization without any syncToken. Learn more about incremental
       * synchronization. Optional. The default is to return all entries.
       */
      @com.google.api.client.util.Key
      private java.lang.String syncToken;

      /** Token obtained from the nextSyncToken field returned on the last page of results from the previous
     list request. It makes the result of this list request contain only entries that have changed since
     then. All events deleted since the previous list request will always be in the result set and it is
     not allowed to set showDeleted to False. There are several query parameters that cannot be
     specified together with nextSyncToken to ensure consistency of the client state.

     These are: - iCalUID - orderBy - privateExtendedProperty - q - sharedExtendedProperty - timeMin -
     timeMax - updatedMin All other query parameters should be the same as for the initial
     synchronization to avoid undefined behavior. If the syncToken expires, the server will respond with
     a 410 GONE response code and the client should clear its storage and perform a full synchronization
     without any syncToken. Learn more about incremental synchronization. Optional. The default is to
     return all entries.
       */
      public java.lang.String getSyncToken() {
        return syncToken;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. All events deleted since the previous list request will always be
       * in the result set and it is not allowed to set showDeleted to False. There are several
       * query parameters that cannot be specified together with nextSyncToken to ensure consistency
       * of the client state.
       *
       * These are: - iCalUID - orderBy - privateExtendedProperty - q - sharedExtendedProperty -
       * timeMin - timeMax - updatedMin All other query parameters should be the same as for the
       * initial synchronization to avoid undefined behavior. If the syncToken expires, the server
       * will respond with a 410 GONE response code and the client should clear its storage and
       * perform a full synchronization without any syncToken. Learn more about incremental
       * synchronization. Optional. The default is to return all entries.
       */
      public List setSyncToken(java.lang.String syncToken) {
        this.syncToken = syncToken;
        return this;
      }

      /**
       * Upper bound (exclusive) for an event's start time to filter by. Optional. The default is
       * not to filter by start time. Must be an RFC3339 timestamp with mandatory time zone offset,
       * for example, 2011-06-03T10:00:00-07:00, 2011-06-03T10:00:00Z. Milliseconds may be provided
       * but are ignored. If timeMin is set, timeMax must be greater than timeMin.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime timeMax;

      /** Upper bound (exclusive) for an event's start time to filter by. Optional. The default is not to
     filter by start time. Must be an RFC3339 timestamp with mandatory time zone offset, for example,
     2011-06-03T10:00:00-07:00, 2011-06-03T10:00:00Z. Milliseconds may be provided but are ignored. If
     timeMin is set, timeMax must be greater than timeMin.
       */
      public com.google.api.client.util.DateTime getTimeMax() {
        return timeMax;
      }

      /**
       * Upper bound (exclusive) for an event's start time to filter by. Optional. The default is
       * not to filter by start time. Must be an RFC3339 timestamp with mandatory time zone offset,
       * for example, 2011-06-03T10:00:00-07:00, 2011-06-03T10:00:00Z. Milliseconds may be provided
       * but are ignored. If timeMin is set, timeMax must be greater than timeMin.
       */
      public List setTimeMax(com.google.api.client.util.DateTime timeMax) {
        this.timeMax = timeMax;
        return this;
      }

      /**
       * Lower bound (exclusive) for an event's end time to filter by. Optional. The default is not
       * to filter by end time. Must be an RFC3339 timestamp with mandatory time zone offset, for
       * example, 2011-06-03T10:00:00-07:00, 2011-06-03T10:00:00Z. Milliseconds may be provided but
       * are ignored. If timeMax is set, timeMin must be smaller than timeMax.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime timeMin;

      /** Lower bound (exclusive) for an event's end time to filter by. Optional. The default is not to
     filter by end time. Must be an RFC3339 timestamp with mandatory time zone offset, for example,
     2011-06-03T10:00:00-07:00, 2011-06-03T10:00:00Z. Milliseconds may be provided but are ignored. If
     timeMax is set, timeMin must be smaller than timeMax.
       */
      public com.google.api.client.util.DateTime getTimeMin() {
        return timeMin;
      }

      /**
       * Lower bound (exclusive) for an event's end time to filter by. Optional. The default is not
       * to filter by end time. Must be an RFC3339 timestamp with mandatory time zone offset, for
       * example, 2011-06-03T10:00:00-07:00, 2011-06-03T10:00:00Z. Milliseconds may be provided but
       * are ignored. If timeMax is set, timeMin must be smaller than timeMax.
       */
      public List setTimeMin(com.google.api.client.util.DateTime timeMin) {
        this.timeMin = timeMin;
        return this;
      }

      /**
       * Time zone used in the response. Optional. The default is the time zone of the calendar.
       */
      @com.google.api.client.util.Key
      private java.lang.String timeZone;

      /** Time zone used in the response. Optional. The default is the time zone of the calendar.
       */
      public java.lang.String getTimeZone() {
        return timeZone;
      }

      /**
       * Time zone used in the response. Optional. The default is the time zone of the calendar.
       */
      public List setTimeZone(java.lang.String timeZone) {
        this.timeZone = timeZone;
        return this;
      }

      /**
       * Lower bound for an event's last modification time (as a RFC3339 timestamp) to filter by.
       * When specified, entries deleted since this time will always be included regardless of
       * showDeleted. Optional. The default is not to filter by last modification time.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime updatedMin;

      /** Lower bound for an event's last modification time (as a RFC3339 timestamp) to filter by. When
     specified, entries deleted since this time will always be included regardless of showDeleted.
     Optional. The default is not to filter by last modification time.
       */
      public com.google.api.client.util.DateTime getUpdatedMin() {
        return updatedMin;
      }

      /**
       * Lower bound for an event's last modification time (as a RFC3339 timestamp) to filter by.
       * When specified, entries deleted since this time will always be included regardless of
       * showDeleted. Optional. The default is not to filter by last modification time.
       */
      public List setUpdatedMin(com.google.api.client.util.DateTime updatedMin) {
        this.updatedMin = updatedMin;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Moves an event to another calendar, i.e. changes an event's organizer. Note that only default
     * events can be moved; outOfOffice, focusTime, workingLocation and fromGmail events cannot be
     * moved.
     *
     * Create a request for the method "events.move".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Move#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier of the source calendar where the event currently is on.
     * @param eventId Event identifier.
     * @param destination Calendar identifier of the target calendar where the event is to be moved to.
     * @return the request
     */
    public Move move(java.lang.String calendarId, java.lang.String eventId, java.lang.String destination) throws java.io.IOException {
      Move result = new Move(calendarId, eventId, destination);
      initialize(result);
      return result;
    }

    public class Move extends CalendarRequest<com.google.api.services.calendar.model.Event> {

      private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}/move";

      /**
       * Moves an event to another calendar, i.e. changes an event's organizer. Note that only default
       * events can be moved; outOfOffice, focusTime, workingLocation and fromGmail events cannot be
       * moved.
       *
       * Create a request for the method "events.move".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Move#execute()} method to invoke the remote operation. <p>
       * {@link Move#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier of the source calendar where the event currently is on.
       * @param eventId Event identifier.
       * @param destination Calendar identifier of the target calendar where the event is to be moved to.
       * @since 1.13
       */
      protected Move(java.lang.String calendarId, java.lang.String eventId, java.lang.String destination) {
        super(Calendar.this, "POST", REST_PATH, null, com.google.api.services.calendar.model.Event.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
        this.eventId = com.google.api.client.util.Preconditions.checkNotNull(eventId, "Required parameter eventId must be specified.");
        this.destination = com.google.api.client.util.Preconditions.checkNotNull(destination, "Required parameter destination must be specified.");
      }

      @Override
      public Move setAlt(java.lang.String alt) {
        return (Move) super.setAlt(alt);
      }

      @Override
      public Move setFields(java.lang.String fields) {
        return (Move) super.setFields(fields);
      }

      @Override
      public Move setKey(java.lang.String key) {
        return (Move) super.setKey(key);
      }

      @Override
      public Move setOauthToken(java.lang.String oauthToken) {
        return (Move) super.setOauthToken(oauthToken);
      }

      @Override
      public Move setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Move) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Move setQuotaUser(java.lang.String quotaUser) {
        return (Move) super.setQuotaUser(quotaUser);
      }

      @Override
      public Move setUserIp(java.lang.String userIp) {
        return (Move) super.setUserIp(userIp);
      }

      /** Calendar identifier of the source calendar where the event currently is on. */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier of the source calendar where the event currently is on.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /** Calendar identifier of the source calendar where the event currently is on. */
      public Move setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /** Event identifier. */
      @com.google.api.client.util.Key
      private java.lang.String eventId;

      /** Event identifier.
       */
      public java.lang.String getEventId() {
        return eventId;
      }

      /** Event identifier. */
      public Move setEventId(java.lang.String eventId) {
        this.eventId = eventId;
        return this;
      }

      /** Calendar identifier of the target calendar where the event is to be moved to. */
      @com.google.api.client.util.Key
      private java.lang.String destination;

      /** Calendar identifier of the target calendar where the event is to be moved to.
       */
      public java.lang.String getDestination() {
        return destination;
      }

      /** Calendar identifier of the target calendar where the event is to be moved to. */
      public Move setDestination(java.lang.String destination) {
        this.destination = destination;
        return this;
      }

      /**
       * Deprecated. Please use sendUpdates instead.
       *
       * Whether to send notifications about the change of the event's organizer. Note that some
       * emails might still be sent even if you set the value to false. The default is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sendNotifications;

      /** Deprecated. Please use sendUpdates instead.

     Whether to send notifications about the change of the event's organizer. Note that some emails
     might still be sent even if you set the value to false. The default is false.
       */
      public java.lang.Boolean getSendNotifications() {
        return sendNotifications;
      }

      /**
       * Deprecated. Please use sendUpdates instead.
       *
       * Whether to send notifications about the change of the event's organizer. Note that some
       * emails might still be sent even if you set the value to false. The default is false.
       */
      public Move setSendNotifications(java.lang.Boolean sendNotifications) {
        this.sendNotifications = sendNotifications;
        return this;
      }

      /** Guests who should receive notifications about the change of the event's organizer. */
      @com.google.api.client.util.Key
      private java.lang.String sendUpdates;

      /** Guests who should receive notifications about the change of the event's organizer.
       */
      public java.lang.String getSendUpdates() {
        return sendUpdates;
      }

      /** Guests who should receive notifications about the change of the event's organizer. */
      public Move setSendUpdates(java.lang.String sendUpdates) {
        this.sendUpdates = sendUpdates;
        return this;
      }

      @Override
      public Move set(String parameterName, Object value) {
        return (Move) super.set(parameterName, value);
      }
    }
    /**
     * Updates an event. This method supports patch semantics.
     *
     * Create a request for the method "events.patch".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param eventId Event identifier.
     * @param content the {@link com.google.api.services.calendar.model.Event}
     * @return the request
     */
    public Patch patch(java.lang.String calendarId, java.lang.String eventId, com.google.api.services.calendar.model.Event content) throws java.io.IOException {
      Patch result = new Patch(calendarId, eventId, content);
      initialize(result);
      return result;
    }

    public class Patch extends CalendarRequest<com.google.api.services.calendar.model.Event> {

      private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";

      /**
       * Updates an event. This method supports patch semantics.
       *
       * Create a request for the method "events.patch".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param eventId Event identifier.
       * @param content the {@link com.google.api.services.calendar.model.Event}
       * @since 1.13
       */
      protected Patch(java.lang.String calendarId, java.lang.String eventId, com.google.api.services.calendar.model.Event content) {
        super(Calendar.this, "PATCH", REST_PATH, content, com.google.api.services.calendar.model.Event.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
        this.eventId = com.google.api.client.util.Preconditions.checkNotNull(eventId, "Required parameter eventId must be specified.");
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUserIp(java.lang.String userIp) {
        return (Patch) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Patch setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /** Event identifier. */
      @com.google.api.client.util.Key
      private java.lang.String eventId;

      /** Event identifier.
       */
      public java.lang.String getEventId() {
        return eventId;
      }

      /** Event identifier. */
      public Patch setEventId(java.lang.String eventId) {
        this.eventId = eventId;
        return this;
      }

      /**
       * Deprecated and ignored. A value will always be returned in the email field for the
       * organizer, creator and attendees, even if no real email address is available (i.e. a
       * generated, non-working value will be provided).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean alwaysIncludeEmail;

      /** Deprecated and ignored. A value will always be returned in the email field for the organizer,
     creator and attendees, even if no real email address is available (i.e. a generated, non-working
     value will be provided).
       */
      public java.lang.Boolean getAlwaysIncludeEmail() {
        return alwaysIncludeEmail;
      }

      /**
       * Deprecated and ignored. A value will always be returned in the email field for the
       * organizer, creator and attendees, even if no real email address is available (i.e. a
       * generated, non-working value will be provided).
       */
      public Patch setAlwaysIncludeEmail(java.lang.Boolean alwaysIncludeEmail) {
        this.alwaysIncludeEmail = alwaysIncludeEmail;
        return this;
      }

      /**
       * Version number of conference data supported by the API client. Version 0 assumes no
       * conference data support and ignores conference data in the event's body. Version 1 enables
       * support for copying of ConferenceData as well as for creating new conferences using the
       * createRequest field of conferenceData. The default is 0.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer conferenceDataVersion;

      /** Version number of conference data supported by the API client. Version 0 assumes no conference data
     support and ignores conference data in the event's body. Version 1 enables support for copying of
     ConferenceData as well as for creating new conferences using the createRequest field of
     conferenceData. The default is 0.

     [minimum: 0] [maximum: 1]
       */
      public java.lang.Integer getConferenceDataVersion() {
        return conferenceDataVersion;
      }

      /**
       * Version number of conference data supported by the API client. Version 0 assumes no
       * conference data support and ignores conference data in the event's body. Version 1 enables
       * support for copying of ConferenceData as well as for creating new conferences using the
       * createRequest field of conferenceData. The default is 0.
       */
      public Patch setConferenceDataVersion(java.lang.Integer conferenceDataVersion) {
        this.conferenceDataVersion = conferenceDataVersion;
        return this;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxAttendees;

      /** The maximum number of attendees to include in the response. If there are more than the specified
     number of attendees, only the participant is returned. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxAttendees() {
        return maxAttendees;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      public Patch setMaxAttendees(java.lang.Integer maxAttendees) {
        this.maxAttendees = maxAttendees;
        return this;
      }

      /**
       * Deprecated. Please use sendUpdates instead.
       *
       * Whether to send notifications about the event update (for example, description changes,
       * etc.). Note that some emails might still be sent even if you set the value to false. The
       * default is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sendNotifications;

      /** Deprecated. Please use sendUpdates instead.

     Whether to send notifications about the event update (for example, description changes, etc.). Note
     that some emails might still be sent even if you set the value to false. The default is false.
       */
      public java.lang.Boolean getSendNotifications() {
        return sendNotifications;
      }

      /**
       * Deprecated. Please use sendUpdates instead.
       *
       * Whether to send notifications about the event update (for example, description changes,
       * etc.). Note that some emails might still be sent even if you set the value to false. The
       * default is false.
       */
      public Patch setSendNotifications(java.lang.Boolean sendNotifications) {
        this.sendNotifications = sendNotifications;
        return this;
      }

      /**
       * Guests who should receive notifications about the event update (for example, title changes,
       * etc.).
       */
      @com.google.api.client.util.Key
      private java.lang.String sendUpdates;

      /** Guests who should receive notifications about the event update (for example, title changes, etc.).
       */
      public java.lang.String getSendUpdates() {
        return sendUpdates;
      }

      /**
       * Guests who should receive notifications about the event update (for example, title changes,
       * etc.).
       */
      public Patch setSendUpdates(java.lang.String sendUpdates) {
        this.sendUpdates = sendUpdates;
        return this;
      }

      /**
       * Whether API client performing operation supports event attachments. Optional. The default
       * is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAttachments;

      /** Whether API client performing operation supports event attachments. Optional. The default is False.
       */
      public java.lang.Boolean getSupportsAttachments() {
        return supportsAttachments;
      }

      /**
       * Whether API client performing operation supports event attachments. Optional. The default
       * is False.
       */
      public Patch setSupportsAttachments(java.lang.Boolean supportsAttachments) {
        this.supportsAttachments = supportsAttachments;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Creates an event based on a simple text string.
     *
     * Create a request for the method "events.quickAdd".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link QuickAdd#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param text The text describing the event to be created.
     * @return the request
     */
    public QuickAdd quickAdd(java.lang.String calendarId, java.lang.String text) throws java.io.IOException {
      QuickAdd result = new QuickAdd(calendarId, text);
      initialize(result);
      return result;
    }

    public class QuickAdd extends CalendarRequest<com.google.api.services.calendar.model.Event> {

      private static final String REST_PATH = "calendars/{calendarId}/events/quickAdd";

      /**
       * Creates an event based on a simple text string.
       *
       * Create a request for the method "events.quickAdd".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link QuickAdd#execute()} method to invoke the remote operation.
       * <p> {@link
       * QuickAdd#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param text The text describing the event to be created.
       * @since 1.13
       */
      protected QuickAdd(java.lang.String calendarId, java.lang.String text) {
        super(Calendar.this, "POST", REST_PATH, null, com.google.api.services.calendar.model.Event.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
        this.text = com.google.api.client.util.Preconditions.checkNotNull(text, "Required parameter text must be specified.");
      }

      @Override
      public QuickAdd setAlt(java.lang.String alt) {
        return (QuickAdd) super.setAlt(alt);
      }

      @Override
      public QuickAdd setFields(java.lang.String fields) {
        return (QuickAdd) super.setFields(fields);
      }

      @Override
      public QuickAdd setKey(java.lang.String key) {
        return (QuickAdd) super.setKey(key);
      }

      @Override
      public QuickAdd setOauthToken(java.lang.String oauthToken) {
        return (QuickAdd) super.setOauthToken(oauthToken);
      }

      @Override
      public QuickAdd setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (QuickAdd) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public QuickAdd setQuotaUser(java.lang.String quotaUser) {
        return (QuickAdd) super.setQuotaUser(quotaUser);
      }

      @Override
      public QuickAdd setUserIp(java.lang.String userIp) {
        return (QuickAdd) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public QuickAdd setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /** The text describing the event to be created. */
      @com.google.api.client.util.Key
      private java.lang.String text;

      /** The text describing the event to be created.
       */
      public java.lang.String getText() {
        return text;
      }

      /** The text describing the event to be created. */
      public QuickAdd setText(java.lang.String text) {
        this.text = text;
        return this;
      }

      /**
       * Deprecated. Please use sendUpdates instead.
       *
       * Whether to send notifications about the creation of the event. Note that some emails might
       * still be sent even if you set the value to false. The default is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sendNotifications;

      /** Deprecated. Please use sendUpdates instead.

     Whether to send notifications about the creation of the event. Note that some emails might still be
     sent even if you set the value to false. The default is false.
       */
      public java.lang.Boolean getSendNotifications() {
        return sendNotifications;
      }

      /**
       * Deprecated. Please use sendUpdates instead.
       *
       * Whether to send notifications about the creation of the event. Note that some emails might
       * still be sent even if you set the value to false. The default is false.
       */
      public QuickAdd setSendNotifications(java.lang.Boolean sendNotifications) {
        this.sendNotifications = sendNotifications;
        return this;
      }

      /** Guests who should receive notifications about the creation of the new event. */
      @com.google.api.client.util.Key
      private java.lang.String sendUpdates;

      /** Guests who should receive notifications about the creation of the new event.
       */
      public java.lang.String getSendUpdates() {
        return sendUpdates;
      }

      /** Guests who should receive notifications about the creation of the new event. */
      public QuickAdd setSendUpdates(java.lang.String sendUpdates) {
        this.sendUpdates = sendUpdates;
        return this;
      }

      @Override
      public QuickAdd set(String parameterName, Object value) {
        return (QuickAdd) super.set(parameterName, value);
      }
    }
    /**
     * Updates an event.
     *
     * Create a request for the method "events.update".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param eventId Event identifier.
     * @param content the {@link com.google.api.services.calendar.model.Event}
     * @return the request
     */
    public Update update(java.lang.String calendarId, java.lang.String eventId, com.google.api.services.calendar.model.Event content) throws java.io.IOException {
      Update result = new Update(calendarId, eventId, content);
      initialize(result);
      return result;
    }

    public class Update extends CalendarRequest<com.google.api.services.calendar.model.Event> {

      private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";

      /**
       * Updates an event.
       *
       * Create a request for the method "events.update".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param eventId Event identifier.
       * @param content the {@link com.google.api.services.calendar.model.Event}
       * @since 1.13
       */
      protected Update(java.lang.String calendarId, java.lang.String eventId, com.google.api.services.calendar.model.Event content) {
        super(Calendar.this, "PUT", REST_PATH, content, com.google.api.services.calendar.model.Event.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
        this.eventId = com.google.api.client.util.Preconditions.checkNotNull(eventId, "Required parameter eventId must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Update setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /** Event identifier. */
      @com.google.api.client.util.Key
      private java.lang.String eventId;

      /** Event identifier.
       */
      public java.lang.String getEventId() {
        return eventId;
      }

      /** Event identifier. */
      public Update setEventId(java.lang.String eventId) {
        this.eventId = eventId;
        return this;
      }

      /**
       * Deprecated and ignored. A value will always be returned in the email field for the
       * organizer, creator and attendees, even if no real email address is available (i.e. a
       * generated, non-working value will be provided).
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean alwaysIncludeEmail;

      /** Deprecated and ignored. A value will always be returned in the email field for the organizer,
     creator and attendees, even if no real email address is available (i.e. a generated, non-working
     value will be provided).
       */
      public java.lang.Boolean getAlwaysIncludeEmail() {
        return alwaysIncludeEmail;
      }

      /**
       * Deprecated and ignored. A value will always be returned in the email field for the
       * organizer, creator and attendees, even if no real email address is available (i.e. a
       * generated, non-working value will be provided).
       */
      public Update setAlwaysIncludeEmail(java.lang.Boolean alwaysIncludeEmail) {
        this.alwaysIncludeEmail = alwaysIncludeEmail;
        return this;
      }

      /**
       * Version number of conference data supported by the API client. Version 0 assumes no
       * conference data support and ignores conference data in the event's body. Version 1 enables
       * support for copying of ConferenceData as well as for creating new conferences using the
       * createRequest field of conferenceData. The default is 0.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer conferenceDataVersion;

      /** Version number of conference data supported by the API client. Version 0 assumes no conference data
     support and ignores conference data in the event's body. Version 1 enables support for copying of
     ConferenceData as well as for creating new conferences using the createRequest field of
     conferenceData. The default is 0.

     [minimum: 0] [maximum: 1]
       */
      public java.lang.Integer getConferenceDataVersion() {
        return conferenceDataVersion;
      }

      /**
       * Version number of conference data supported by the API client. Version 0 assumes no
       * conference data support and ignores conference data in the event's body. Version 1 enables
       * support for copying of ConferenceData as well as for creating new conferences using the
       * createRequest field of conferenceData. The default is 0.
       */
      public Update setConferenceDataVersion(java.lang.Integer conferenceDataVersion) {
        this.conferenceDataVersion = conferenceDataVersion;
        return this;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxAttendees;

      /** The maximum number of attendees to include in the response. If there are more than the specified
     number of attendees, only the participant is returned. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxAttendees() {
        return maxAttendees;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      public Update setMaxAttendees(java.lang.Integer maxAttendees) {
        this.maxAttendees = maxAttendees;
        return this;
      }

      /**
       * Deprecated. Please use sendUpdates instead.
       *
       * Whether to send notifications about the event update (for example, description changes,
       * etc.). Note that some emails might still be sent even if you set the value to false. The
       * default is false.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sendNotifications;

      /** Deprecated. Please use sendUpdates instead.

     Whether to send notifications about the event update (for example, description changes, etc.). Note
     that some emails might still be sent even if you set the value to false. The default is false.
       */
      public java.lang.Boolean getSendNotifications() {
        return sendNotifications;
      }

      /**
       * Deprecated. Please use sendUpdates instead.
       *
       * Whether to send notifications about the event update (for example, description changes,
       * etc.). Note that some emails might still be sent even if you set the value to false. The
       * default is false.
       */
      public Update setSendNotifications(java.lang.Boolean sendNotifications) {
        this.sendNotifications = sendNotifications;
        return this;
      }

      /**
       * Guests who should receive notifications about the event update (for example, title changes,
       * etc.).
       */
      @com.google.api.client.util.Key
      private java.lang.String sendUpdates;

      /** Guests who should receive notifications about the event update (for example, title changes, etc.).
       */
      public java.lang.String getSendUpdates() {
        return sendUpdates;
      }

      /**
       * Guests who should receive notifications about the event update (for example, title changes,
       * etc.).
       */
      public Update setSendUpdates(java.lang.String sendUpdates) {
        this.sendUpdates = sendUpdates;
        return this;
      }

      /**
       * Whether API client performing operation supports event attachments. Optional. The default
       * is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsAttachments;

      /** Whether API client performing operation supports event attachments. Optional. The default is False.
       */
      public java.lang.Boolean getSupportsAttachments() {
        return supportsAttachments;
      }

      /**
       * Whether API client performing operation supports event attachments. Optional. The default
       * is False.
       */
      public Update setSupportsAttachments(java.lang.Boolean supportsAttachments) {
        this.supportsAttachments = supportsAttachments;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
    /**
     * Watch for changes to Events resources.
     *
     * Create a request for the method "events.watch".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Watch#execute()} method to invoke the remote operation.
     *
     * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
     * @param content the {@link com.google.api.services.calendar.model.Channel}
     * @return the request
     */
    public Watch watch(java.lang.String calendarId, com.google.api.services.calendar.model.Channel content) throws java.io.IOException {
      Watch result = new Watch(calendarId, content);
      initialize(result);
      return result;
    }

    public class Watch extends CalendarRequest<com.google.api.services.calendar.model.Channel> {

      private static final String REST_PATH = "calendars/{calendarId}/events/watch";

      /**
       * Watch for changes to Events resources.
       *
       * Create a request for the method "events.watch".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Watch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Watch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param calendarId Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     *        access the primary calendar of the currently logged in user, use the "primary" keyword.
       * @param content the {@link com.google.api.services.calendar.model.Channel}
       * @since 1.13
       */
      protected Watch(java.lang.String calendarId, com.google.api.services.calendar.model.Channel content) {
        super(Calendar.this, "POST", REST_PATH, content, com.google.api.services.calendar.model.Channel.class);
        this.calendarId = com.google.api.client.util.Preconditions.checkNotNull(calendarId, "Required parameter calendarId must be specified.");
      }

      @Override
      public Watch setAlt(java.lang.String alt) {
        return (Watch) super.setAlt(alt);
      }

      @Override
      public Watch setFields(java.lang.String fields) {
        return (Watch) super.setFields(fields);
      }

      @Override
      public Watch setKey(java.lang.String key) {
        return (Watch) super.setKey(key);
      }

      @Override
      public Watch setOauthToken(java.lang.String oauthToken) {
        return (Watch) super.setOauthToken(oauthToken);
      }

      @Override
      public Watch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Watch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Watch setQuotaUser(java.lang.String quotaUser) {
        return (Watch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Watch setUserIp(java.lang.String userIp) {
        return (Watch) super.setUserIp(userIp);
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      @com.google.api.client.util.Key
      private java.lang.String calendarId;

      /** Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you want to
     access the primary calendar of the currently logged in user, use the "primary" keyword.
       */
      public java.lang.String getCalendarId() {
        return calendarId;
      }

      /**
       * Calendar identifier. To retrieve calendar IDs call the calendarList.list method. If you
       * want to access the primary calendar of the currently logged in user, use the "primary"
       * keyword.
       */
      public Watch setCalendarId(java.lang.String calendarId) {
        this.calendarId = calendarId;
        return this;
      }

      /** Deprecated and ignored. */
      @com.google.api.client.util.Key
      private java.lang.Boolean alwaysIncludeEmail;

      /** Deprecated and ignored.
       */
      public java.lang.Boolean getAlwaysIncludeEmail() {
        return alwaysIncludeEmail;
      }

      /** Deprecated and ignored. */
      public Watch setAlwaysIncludeEmail(java.lang.Boolean alwaysIncludeEmail) {
        this.alwaysIncludeEmail = alwaysIncludeEmail;
        return this;
      }

      /**
       * Event types to return. Optional. This parameter can be repeated multiple times to return
       * events of different types. If unset, returns all event types.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> eventTypes;

      /** Event types to return. Optional. This parameter can be repeated multiple times to return events of
     different types. If unset, returns all event types.
       */
      public java.util.List<java.lang.String> getEventTypes() {
        return eventTypes;
      }

      /**
       * Event types to return. Optional. This parameter can be repeated multiple times to return
       * events of different types. If unset, returns all event types.
       */
      public Watch setEventTypes(java.util.List<java.lang.String> eventTypes) {
        this.eventTypes = eventTypes;
        return this;
      }

      /**
       * Specifies an event ID in the iCalendar format to be provided in the response. Optional. Use
       * this if you want to search for an event by its iCalendar ID.
       */
      @com.google.api.client.util.Key
      private java.lang.String iCalUID;

      /** Specifies an event ID in the iCalendar format to be provided in the response. Optional. Use this if
     you want to search for an event by its iCalendar ID.
       */
      public java.lang.String getICalUID() {
        return iCalUID;
      }

      /**
       * Specifies an event ID in the iCalendar format to be provided in the response. Optional. Use
       * this if you want to search for an event by its iCalendar ID.
       */
      public Watch setICalUID(java.lang.String iCalUID) {
        this.iCalUID = iCalUID;
        return this;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxAttendees;

      /** The maximum number of attendees to include in the response. If there are more than the specified
     number of attendees, only the participant is returned. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxAttendees() {
        return maxAttendees;
      }

      /**
       * The maximum number of attendees to include in the response. If there are more than the
       * specified number of attendees, only the participant is returned. Optional.
       */
      public Watch setMaxAttendees(java.lang.Integer maxAttendees) {
        this.maxAttendees = maxAttendees;
        return this;
      }

      /**
       * Maximum number of events returned on one result page. The number of events in the resulting
       * page may be less than this value, or none at all, even if there are more events matching
       * the query. Incomplete pages can be detected by a non-empty nextPageToken field in the
       * response. By default the value is 250 events. The page size can never be larger than 2500
       * events. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of events returned on one result page. The number of events in the resulting page
     may be less than this value, or none at all, even if there are more events matching the query.
     Incomplete pages can be detected by a non-empty nextPageToken field in the response. By default the
     value is 250 events. The page size can never be larger than 2500 events. Optional. [default: 250]
     [minimum: 1]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of events returned on one result page. The number of events in the resulting
       * page may be less than this value, or none at all, even if there are more events matching
       * the query. Incomplete pages can be detected by a non-empty nextPageToken field in the
       * response. By default the value is 250 events. The page size can never be larger than 2500
       * events. Optional.
       */
      public Watch setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * The order of the events returned in the result. Optional. The default is an unspecified,
       * stable order.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** The order of the events returned in the result. Optional. The default is an unspecified, stable
     order.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * The order of the events returned in the result. Optional. The default is an unspecified,
       * stable order.
       */
      public Watch setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /** Token specifying which result page to return. Optional. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Token specifying which result page to return. Optional.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Token specifying which result page to return. Optional. */
      public Watch setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Extended properties constraint specified as propertyName=value. Matches only private
       * properties. This parameter might be repeated multiple times to return events that match all
       * given constraints.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> privateExtendedProperty;

      /** Extended properties constraint specified as propertyName=value. Matches only private properties.
     This parameter might be repeated multiple times to return events that match all given constraints.
       */
      public java.util.List<java.lang.String> getPrivateExtendedProperty() {
        return privateExtendedProperty;
      }

      /**
       * Extended properties constraint specified as propertyName=value. Matches only private
       * properties. This parameter might be repeated multiple times to return events that match all
       * given constraints.
       */
      public Watch setPrivateExtendedProperty(java.util.List<java.lang.String> privateExtendedProperty) {
        this.privateExtendedProperty = privateExtendedProperty;
        return this;
      }

      /**
       * Free text search terms to find events that match these terms in the following fields:
       *
       * - summary - description - location - attendee's displayName - attendee's email -
       * organizer's displayName - organizer's email -
       * workingLocationProperties.officeLocation.buildingId -
       * workingLocationProperties.officeLocation.deskId -
       * workingLocationProperties.officeLocation.label -
       * workingLocationProperties.customLocation.label These search terms also match predefined
       * keywords against all display title translations of working location, out-of-office, and
       * focus-time events. For example, searching for "Office" or "Bureau" returns working location
       * events of type officeLocation, whereas searching for "Out of office" or "Abwesend" returns
       * out-of-office events. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** Free text search terms to find events that match these terms in the following fields:

     - summary - description - location - attendee's displayName - attendee's email - organizer's
     displayName - organizer's email - workingLocationProperties.officeLocation.buildingId -
     workingLocationProperties.officeLocation.deskId - workingLocationProperties.officeLocation.label -
     workingLocationProperties.customLocation.label These search terms also match predefined keywords
     against all display title translations of working location, out-of-office, and focus-time events.
     For example, searching for "Office" or "Bureau" returns working location events of type
     officeLocation, whereas searching for "Out of office" or "Abwesend" returns out-of-office events.
     Optional.
       */
      public java.lang.String getQ() {
        return q;
      }

      /**
       * Free text search terms to find events that match these terms in the following fields:
       *
       * - summary - description - location - attendee's displayName - attendee's email -
       * organizer's displayName - organizer's email -
       * workingLocationProperties.officeLocation.buildingId -
       * workingLocationProperties.officeLocation.deskId -
       * workingLocationProperties.officeLocation.label -
       * workingLocationProperties.customLocation.label These search terms also match predefined
       * keywords against all display title translations of working location, out-of-office, and
       * focus-time events. For example, searching for "Office" or "Bureau" returns working location
       * events of type officeLocation, whereas searching for "Out of office" or "Abwesend" returns
       * out-of-office events. Optional.
       */
      public Watch setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /**
       * Extended properties constraint specified as propertyName=value. Matches only shared
       * properties. This parameter might be repeated multiple times to return events that match all
       * given constraints.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> sharedExtendedProperty;

      /** Extended properties constraint specified as propertyName=value. Matches only shared properties.
     This parameter might be repeated multiple times to return events that match all given constraints.
       */
      public java.util.List<java.lang.String> getSharedExtendedProperty() {
        return sharedExtendedProperty;
      }

      /**
       * Extended properties constraint specified as propertyName=value. Matches only shared
       * properties. This parameter might be repeated multiple times to return events that match all
       * given constraints.
       */
      public Watch setSharedExtendedProperty(java.util.List<java.lang.String> sharedExtendedProperty) {
        this.sharedExtendedProperty = sharedExtendedProperty;
        return this;
      }

      /**
       * Whether to include deleted events (with status equals "cancelled") in the result. Cancelled
       * instances of recurring events (but not the underlying recurring event) will still be
       * included if showDeleted and singleEvents are both False. If showDeleted and singleEvents
       * are both True, only single instances of deleted events (but not the underlying recurring
       * events) are returned. Optional. The default is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean showDeleted;

      /** Whether to include deleted events (with status equals "cancelled") in the result. Cancelled
     instances of recurring events (but not the underlying recurring event) will still be included if
     showDeleted and singleEvents are both False. If showDeleted and singleEvents are both True, only
     single instances of deleted events (but not the underlying recurring events) are returned.
     Optional. The default is False.
       */
      public java.lang.Boolean getShowDeleted() {
        return showDeleted;
      }

      /**
       * Whether to include deleted events (with status equals "cancelled") in the result. Cancelled
       * instances of recurring events (but not the underlying recurring event) will still be
       * included if showDeleted and singleEvents are both False. If showDeleted and singleEvents
       * are both True, only single instances of deleted events (but not the underlying recurring
       * events) are returned. Optional. The default is False.
       */
      public Watch setShowDeleted(java.lang.Boolean showDeleted) {
        this.showDeleted = showDeleted;
        return this;
      }

      /** Whether to include hidden invitations in the result. Optional. The default is False. */
      @com.google.api.client.util.Key
      private java.lang.Boolean showHiddenInvitations;

      /** Whether to include hidden invitations in the result. Optional. The default is False.
       */
      public java.lang.Boolean getShowHiddenInvitations() {
        return showHiddenInvitations;
      }

      /** Whether to include hidden invitations in the result. Optional. The default is False. */
      public Watch setShowHiddenInvitations(java.lang.Boolean showHiddenInvitations) {
        this.showHiddenInvitations = showHiddenInvitations;
        return this;
      }

      /**
       * Whether to expand recurring events into instances and only return single one-off events and
       * instances of recurring events, but not the underlying recurring events themselves.
       * Optional. The default is False.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean singleEvents;

      /** Whether to expand recurring events into instances and only return single one-off events and
     instances of recurring events, but not the underlying recurring events themselves. Optional. The
     default is False.
       */
      public java.lang.Boolean getSingleEvents() {
        return singleEvents;
      }

      /**
       * Whether to expand recurring events into instances and only return single one-off events and
       * instances of recurring events, but not the underlying recurring events themselves.
       * Optional. The default is False.
       */
      public Watch setSingleEvents(java.lang.Boolean singleEvents) {
        this.singleEvents = singleEvents;
        return this;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. All events deleted since the previous list request will always be
       * in the result set and it is not allowed to set showDeleted to False. There are several
       * query parameters that cannot be specified together with nextSyncToken to ensure consistency
       * of the client state.
       *
       * These are: - iCalUID - orderBy - privateExtendedProperty - q - sharedExtendedProperty -
       * timeMin - timeMax - updatedMin All other query parameters should be the same as for the
       * initial synchronization to avoid undefined behavior. If the syncToken expires, the server
       * will respond with a 410 GONE response code and the client should clear its storage and
       * perform a full synchronization without any syncToken. Learn more about incremental
       * synchronization. Optional. The default is to return all entries.
       */
      @com.google.api.client.util.Key
      private java.lang.String syncToken;

      /** Token obtained from the nextSyncToken field returned on the last page of results from the previous
     list request. It makes the result of this list request contain only entries that have changed since
     then. All events deleted since the previous list request will always be in the result set and it is
     not allowed to set showDeleted to False. There are several query parameters that cannot be
     specified together with nextSyncToken to ensure consistency of the client state.

     These are: - iCalUID - orderBy - privateExtendedProperty - q - sharedExtendedProperty - timeMin -
     timeMax - updatedMin All other query parameters should be the same as for the initial
     synchronization to avoid undefined behavior. If the syncToken expires, the server will respond with
     a 410 GONE response code and the client should clear its storage and perform a full synchronization
     without any syncToken. Learn more about incremental synchronization. Optional. The default is to
     return all entries.
       */
      public java.lang.String getSyncToken() {
        return syncToken;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. All events deleted since the previous list request will always be
       * in the result set and it is not allowed to set showDeleted to False. There are several
       * query parameters that cannot be specified together with nextSyncToken to ensure consistency
       * of the client state.
       *
       * These are: - iCalUID - orderBy - privateExtendedProperty - q - sharedExtendedProperty -
       * timeMin - timeMax - updatedMin All other query parameters should be the same as for the
       * initial synchronization to avoid undefined behavior. If the syncToken expires, the server
       * will respond with a 410 GONE response code and the client should clear its storage and
       * perform a full synchronization without any syncToken. Learn more about incremental
       * synchronization. Optional. The default is to return all entries.
       */
      public Watch setSyncToken(java.lang.String syncToken) {
        this.syncToken = syncToken;
        return this;
      }

      /**
       * Upper bound (exclusive) for an event's start time to filter by. Optional. The default is
       * not to filter by start time. Must be an RFC3339 timestamp with mandatory time zone offset,
       * for example, 2011-06-03T10:00:00-07:00, 2011-06-03T10:00:00Z. Milliseconds may be provided
       * but are ignored. If timeMin is set, timeMax must be greater than timeMin.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime timeMax;

      /** Upper bound (exclusive) for an event's start time to filter by. Optional. The default is not to
     filter by start time. Must be an RFC3339 timestamp with mandatory time zone offset, for example,
     2011-06-03T10:00:00-07:00, 2011-06-03T10:00:00Z. Milliseconds may be provided but are ignored. If
     timeMin is set, timeMax must be greater than timeMin.
       */
      public com.google.api.client.util.DateTime getTimeMax() {
        return timeMax;
      }

      /**
       * Upper bound (exclusive) for an event's start time to filter by. Optional. The default is
       * not to filter by start time. Must be an RFC3339 timestamp with mandatory time zone offset,
       * for example, 2011-06-03T10:00:00-07:00, 2011-06-03T10:00:00Z. Milliseconds may be provided
       * but are ignored. If timeMin is set, timeMax must be greater than timeMin.
       */
      public Watch setTimeMax(com.google.api.client.util.DateTime timeMax) {
        this.timeMax = timeMax;
        return this;
      }

      /**
       * Lower bound (exclusive) for an event's end time to filter by. Optional. The default is not
       * to filter by end time. Must be an RFC3339 timestamp with mandatory time zone offset, for
       * example, 2011-06-03T10:00:00-07:00, 2011-06-03T10:00:00Z. Milliseconds may be provided but
       * are ignored. If timeMax is set, timeMin must be smaller than timeMax.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime timeMin;

      /** Lower bound (exclusive) for an event's end time to filter by. Optional. The default is not to
     filter by end time. Must be an RFC3339 timestamp with mandatory time zone offset, for example,
     2011-06-03T10:00:00-07:00, 2011-06-03T10:00:00Z. Milliseconds may be provided but are ignored. If
     timeMax is set, timeMin must be smaller than timeMax.
       */
      public com.google.api.client.util.DateTime getTimeMin() {
        return timeMin;
      }

      /**
       * Lower bound (exclusive) for an event's end time to filter by. Optional. The default is not
       * to filter by end time. Must be an RFC3339 timestamp with mandatory time zone offset, for
       * example, 2011-06-03T10:00:00-07:00, 2011-06-03T10:00:00Z. Milliseconds may be provided but
       * are ignored. If timeMax is set, timeMin must be smaller than timeMax.
       */
      public Watch setTimeMin(com.google.api.client.util.DateTime timeMin) {
        this.timeMin = timeMin;
        return this;
      }

      /**
       * Time zone used in the response. Optional. The default is the time zone of the calendar.
       */
      @com.google.api.client.util.Key
      private java.lang.String timeZone;

      /** Time zone used in the response. Optional. The default is the time zone of the calendar.
       */
      public java.lang.String getTimeZone() {
        return timeZone;
      }

      /**
       * Time zone used in the response. Optional. The default is the time zone of the calendar.
       */
      public Watch setTimeZone(java.lang.String timeZone) {
        this.timeZone = timeZone;
        return this;
      }

      /**
       * Lower bound for an event's last modification time (as a RFC3339 timestamp) to filter by.
       * When specified, entries deleted since this time will always be included regardless of
       * showDeleted. Optional. The default is not to filter by last modification time.
       */
      @com.google.api.client.util.Key
      private com.google.api.client.util.DateTime updatedMin;

      /** Lower bound for an event's last modification time (as a RFC3339 timestamp) to filter by. When
     specified, entries deleted since this time will always be included regardless of showDeleted.
     Optional. The default is not to filter by last modification time.
       */
      public com.google.api.client.util.DateTime getUpdatedMin() {
        return updatedMin;
      }

      /**
       * Lower bound for an event's last modification time (as a RFC3339 timestamp) to filter by.
       * When specified, entries deleted since this time will always be included regardless of
       * showDeleted. Optional. The default is not to filter by last modification time.
       */
      public Watch setUpdatedMin(com.google.api.client.util.DateTime updatedMin) {
        this.updatedMin = updatedMin;
        return this;
      }

      @Override
      public Watch set(String parameterName, Object value) {
        return (Watch) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Freebusy collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Calendar calendar = new Calendar(...);}
   *   {@code Calendar.Freebusy.List request = calendar.freebusy().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Freebusy freebusy() {
    return new Freebusy();
  }

  /**
   * The "freebusy" collection of methods.
   */
  public class Freebusy {

    /**
     * Returns free/busy information for a set of calendars.
     *
     * Create a request for the method "freebusy.query".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Query#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.calendar.model.FreeBusyRequest}
     * @return the request
     */
    public Query query(com.google.api.services.calendar.model.FreeBusyRequest content) throws java.io.IOException {
      Query result = new Query(content);
      initialize(result);
      return result;
    }

    public class Query extends CalendarRequest<com.google.api.services.calendar.model.FreeBusyResponse> {

      private static final String REST_PATH = "freeBusy";

      /**
       * Returns free/busy information for a set of calendars.
       *
       * Create a request for the method "freebusy.query".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Query#execute()} method to invoke the remote operation.
       * <p> {@link
       * Query#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.calendar.model.FreeBusyRequest}
       * @since 1.13
       */
      protected Query(com.google.api.services.calendar.model.FreeBusyRequest content) {
        super(Calendar.this, "POST", REST_PATH, content, com.google.api.services.calendar.model.FreeBusyResponse.class);
      }

      @Override
      public Query setAlt(java.lang.String alt) {
        return (Query) super.setAlt(alt);
      }

      @Override
      public Query setFields(java.lang.String fields) {
        return (Query) super.setFields(fields);
      }

      @Override
      public Query setKey(java.lang.String key) {
        return (Query) super.setKey(key);
      }

      @Override
      public Query setOauthToken(java.lang.String oauthToken) {
        return (Query) super.setOauthToken(oauthToken);
      }

      @Override
      public Query setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Query) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Query setQuotaUser(java.lang.String quotaUser) {
        return (Query) super.setQuotaUser(quotaUser);
      }

      @Override
      public Query setUserIp(java.lang.String userIp) {
        return (Query) super.setUserIp(userIp);
      }

      @Override
      public Query set(String parameterName, Object value) {
        return (Query) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Settings collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Calendar calendar = new Calendar(...);}
   *   {@code Calendar.Settings.List request = calendar.settings().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Settings settings() {
    return new Settings();
  }

  /**
   * The "settings" collection of methods.
   */
  public class Settings {

    /**
     * Returns a single user setting.
     *
     * Create a request for the method "settings.get".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param setting The id of the user setting.
     * @return the request
     */
    public Get get(java.lang.String setting) throws java.io.IOException {
      Get result = new Get(setting);
      initialize(result);
      return result;
    }

    public class Get extends CalendarRequest<com.google.api.services.calendar.model.Setting> {

      private static final String REST_PATH = "users/me/settings/{setting}";

      /**
       * Returns a single user setting.
       *
       * Create a request for the method "settings.get".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param setting The id of the user setting.
       * @since 1.13
       */
      protected Get(java.lang.String setting) {
        super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Setting.class);
        this.setting = com.google.api.client.util.Preconditions.checkNotNull(setting, "Required parameter setting must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The id of the user setting. */
      @com.google.api.client.util.Key
      private java.lang.String setting;

      /** The id of the user setting.
       */
      public java.lang.String getSetting() {
        return setting;
      }

      /** The id of the user setting. */
      public Get setSetting(java.lang.String setting) {
        this.setting = setting;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Returns all user settings for the authenticated user.
     *
     * Create a request for the method "settings.list".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends CalendarRequest<com.google.api.services.calendar.model.Settings> {

      private static final String REST_PATH = "users/me/settings";

      /**
       * Returns all user settings for the authenticated user.
       *
       * Create a request for the method "settings.list".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Calendar.this, "GET", REST_PATH, null, com.google.api.services.calendar.model.Settings.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * Maximum number of entries returned on one result page. By default the value is 100 entries.
       * The page size can never be larger than 250 entries. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of entries returned on one result page. By default the value is 100 entries. The
     page size can never be larger than 250 entries. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of entries returned on one result page. By default the value is 100 entries.
       * The page size can never be larger than 250 entries. Optional.
       */
      public List setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Token specifying which result page to return. Optional. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Token specifying which result page to return. Optional.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Token specifying which result page to return. Optional. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. If the syncToken expires, the server will respond with a 410 GONE
       * response code and the client should clear its storage and perform a full synchronization
       * without any syncToken. Learn more about incremental synchronization. Optional. The default
       * is to return all entries.
       */
      @com.google.api.client.util.Key
      private java.lang.String syncToken;

      /** Token obtained from the nextSyncToken field returned on the last page of results from the previous
     list request. It makes the result of this list request contain only entries that have changed since
     then. If the syncToken expires, the server will respond with a 410 GONE response code and the
     client should clear its storage and perform a full synchronization without any syncToken. Learn
     more about incremental synchronization. Optional. The default is to return all entries.
       */
      public java.lang.String getSyncToken() {
        return syncToken;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. If the syncToken expires, the server will respond with a 410 GONE
       * response code and the client should clear its storage and perform a full synchronization
       * without any syncToken. Learn more about incremental synchronization. Optional. The default
       * is to return all entries.
       */
      public List setSyncToken(java.lang.String syncToken) {
        this.syncToken = syncToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Watch for changes to Settings resources.
     *
     * Create a request for the method "settings.watch".
     *
     * This request holds the parameters needed by the calendar server.  After setting any optional
     * parameters, call the {@link Watch#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.calendar.model.Channel}
     * @return the request
     */
    public Watch watch(com.google.api.services.calendar.model.Channel content) throws java.io.IOException {
      Watch result = new Watch(content);
      initialize(result);
      return result;
    }

    public class Watch extends CalendarRequest<com.google.api.services.calendar.model.Channel> {

      private static final String REST_PATH = "users/me/settings/watch";

      /**
       * Watch for changes to Settings resources.
       *
       * Create a request for the method "settings.watch".
       *
       * This request holds the parameters needed by the the calendar server.  After setting any
       * optional parameters, call the {@link Watch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Watch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.calendar.model.Channel}
       * @since 1.13
       */
      protected Watch(com.google.api.services.calendar.model.Channel content) {
        super(Calendar.this, "POST", REST_PATH, content, com.google.api.services.calendar.model.Channel.class);
      }

      @Override
      public Watch setAlt(java.lang.String alt) {
        return (Watch) super.setAlt(alt);
      }

      @Override
      public Watch setFields(java.lang.String fields) {
        return (Watch) super.setFields(fields);
      }

      @Override
      public Watch setKey(java.lang.String key) {
        return (Watch) super.setKey(key);
      }

      @Override
      public Watch setOauthToken(java.lang.String oauthToken) {
        return (Watch) super.setOauthToken(oauthToken);
      }

      @Override
      public Watch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Watch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Watch setQuotaUser(java.lang.String quotaUser) {
        return (Watch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Watch setUserIp(java.lang.String userIp) {
        return (Watch) super.setUserIp(userIp);
      }

      /**
       * Maximum number of entries returned on one result page. By default the value is 100 entries.
       * The page size can never be larger than 250 entries. Optional.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxResults;

      /** Maximum number of entries returned on one result page. By default the value is 100 entries. The
     page size can never be larger than 250 entries. Optional.

     [minimum: 1]
       */
      public java.lang.Integer getMaxResults() {
        return maxResults;
      }

      /**
       * Maximum number of entries returned on one result page. By default the value is 100 entries.
       * The page size can never be larger than 250 entries. Optional.
       */
      public Watch setMaxResults(java.lang.Integer maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Token specifying which result page to return. Optional. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Token specifying which result page to return. Optional.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Token specifying which result page to return. Optional. */
      public Watch setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. If the syncToken expires, the server will respond with a 410 GONE
       * response code and the client should clear its storage and perform a full synchronization
       * without any syncToken. Learn more about incremental synchronization. Optional. The default
       * is to return all entries.
       */
      @com.google.api.client.util.Key
      private java.lang.String syncToken;

      /** Token obtained from the nextSyncToken field returned on the last page of results from the previous
     list request. It makes the result of this list request contain only entries that have changed since
     then. If the syncToken expires, the server will respond with a 410 GONE response code and the
     client should clear its storage and perform a full synchronization without any syncToken. Learn
     more about incremental synchronization. Optional. The default is to return all entries.
       */
      public java.lang.String getSyncToken() {
        return syncToken;
      }

      /**
       * Token obtained from the nextSyncToken field returned on the last page of results from the
       * previous list request. It makes the result of this list request contain only entries that
       * have changed since then. If the syncToken expires, the server will respond with a 410 GONE
       * response code and the client should clear its storage and perform a full synchronization
       * without any syncToken. Learn more about incremental synchronization. Optional. The default
       * is to return all entries.
       */
      public Watch setSyncToken(java.lang.String syncToken) {
        this.syncToken = syncToken;
        return this;
      }

      @Override
      public Watch set(String parameterName, Object value) {
        return (Watch) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Calendar}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Calendar}. */
    @Override
    public Calendar build() {
      return new Calendar(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link CalendarRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setCalendarRequestInitializer(
        CalendarRequestInitializer calendarRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(calendarRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }

    @Override
    public Builder setUniverseDomain(String universeDomain) {
      return (Builder) super.setUniverseDomain(universeDomain);
    }
  }
}
