/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for Event.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Event extends com.google.api.client.json.GenericJson {

  /**
   * Whether anyone can invite themselves to the event (deprecated). Optional. The default is False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean anyoneCanAddSelf;

  /**
   * File attachments for the event. In order to modify attachments the supportsAttachments request
   * parameter should be set to true. There can be at most 25 attachments per event,
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<EventAttachment> attachments;

  /**
   * The attendees of the event. See the Events with attendees guide for more information on
   * scheduling events with other calendar users. Service accounts need to use domain-wide
   * delegation of authority to populate the attendee list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<EventAttendee> attendees;

  /**
   * Whether attendees may have been omitted from the event's representation. When retrieving an
   * event, this may be due to a restriction specified by the maxAttendee query parameter. When
   * updating an event, this can be used to only update the participant's response. Optional. The
   * default is False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean attendeesOmitted;

  /**
   * The color of the event. This is an ID referring to an entry in the event section of the colors
   * definition (see the  colors endpoint). Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String colorId;

  /**
   * The conference-related information, such as details of a Google Meet conference. To create new
   * conference details use the createRequest field. To persist your changes, remember to set the
   * conferenceDataVersion request parameter to 1 for all event modification requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ConferenceData conferenceData;

  /**
   * Creation time of the event (as a RFC3339 timestamp). Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime created;

  /**
   * The creator of the event. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Creator creator;

  /**
   * Description of the event. Can contain HTML. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The (exclusive) end time of the event. For a recurring event, this is the end time of the first
   * instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EventDateTime end;

  /**
   * Whether the end time is actually unspecified. An end time is still provided for compatibility
   * reasons, even if this attribute is set to True. The default is False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean endTimeUnspecified;

  /**
   * ETag of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Specific type of the event. This cannot be modified after the event is created. Possible values
   * are: - "default" - A regular event or not further specified.  - "outOfOffice" - An out-of-
   * office event.  - "focusTime" - A focus-time event.  - "workingLocation" - A working location
   * event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String eventType;

  /**
   * Extended properties of the event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ExtendedProperties extendedProperties;

  /**
   * Focus Time event data. Used if eventType is focusTime.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EventFocusTimeProperties focusTimeProperties;

  /**
   * A gadget that extends this event. Gadgets are deprecated; this structure is instead only used
   * for returning birthday calendar metadata.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Gadget gadget;

  /**
   * Whether attendees other than the organizer can invite others to the event. Optional. The
   * default is True.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean guestsCanInviteOthers;

  /**
   * Whether attendees other than the organizer can modify the event. Optional. The default is
   * False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean guestsCanModify;

  /**
   * Whether attendees other than the organizer can see who the event's attendees are. Optional. The
   * default is True.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean guestsCanSeeOtherGuests;

  /**
   * An absolute link to the Google Hangout associated with this event. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hangoutLink;

  /**
   * An absolute link to this event in the Google Calendar Web UI. Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String htmlLink;

  /**
   * Event unique identifier as defined in RFC5545. It is used to uniquely identify events accross
   * calendaring systems and must be supplied when importing events via the import method. Note that
   * the iCalUID and the id are not identical and only one of them should be supplied at event
   * creation time. One difference in their semantics is that in recurring events, all occurrences
   * of one event have different ids while they all share the same iCalUIDs. To retrieve an event
   * using its iCalUID, call the events.list method using the iCalUID parameter. To retrieve an
   * event using its id, call the events.get method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iCalUID;

  /**
   * Opaque identifier of the event. When creating new single or recurring events, you can specify
   * their IDs. Provided IDs must follow these rules: - characters allowed in the ID are those used
   * in base32hex encoding, i.e. lowercase letters a-v and digits 0-9, see section 3.1.2 in RFC2938
   * - the length of the ID must be between 5 and 1024 characters  - the ID must be unique per
   * calendar  Due to the globally distributed nature of the system, we cannot guarantee that ID
   * collisions will be detected at event creation time. To minimize the risk of collisions we
   * recommend using an established UUID algorithm such as one described in RFC4122. If you do not
   * specify an ID, it will be automatically generated by the server. Note that the icalUID and the
   * id are not identical and only one of them should be supplied at event creation time. One
   * difference in their semantics is that in recurring events, all occurrences of one event have
   * different ids while they all share the same icalUIDs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Type of the resource ("calendar#event").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Geographic location of the event as free-form text. Optional.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * Whether this is a locked event copy where no changes can be made to the main event fields
   * "summary", "description", "location", "start", "end" or "recurrence". The default is False.
   * Read-Only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean locked;

  /**
   * The organizer of the event. If the organizer is also an attendee, this is indicated with a
   * separate entry in attendees with the organizer field set to True. To change the organizer, use
   * the move operation. Read-only, except when importing an event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Organizer organizer;

  /**
   * For an instance of a recurring event, this is the time at which this event would start
   * according to the recurrence data in the recurring event identified by recurringEventId. It
   * uniquely identifies the instance within the recurring event series even if the instance was
   * moved to a different time. Immutable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EventDateTime originalStartTime;

  /**
   * Out of office event data. Used if eventType is outOfOffice.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EventOutOfOfficeProperties outOfOfficeProperties;

  /**
   * If set to True, Event propagation is disabled. Note that it is not the same thing as Private
   * event properties. Optional. Immutable. The default is False.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean privateCopy;

  /**
   * List of RRULE, EXRULE, RDATE and EXDATE lines for a recurring event, as specified in RFC5545.
   * Note that DTSTART and DTEND lines are not allowed in this field; event start and end times are
   * specified in the start and end fields. This field is omitted for single events or instances of
   * recurring events.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> recurrence;

  /**
   * For an instance of a recurring event, this is the id of the recurring event to which this
   * instance belongs. Immutable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String recurringEventId;

  /**
   * Information about the event's reminders for the authenticated user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Reminders reminders;

  /**
   * Sequence number as per iCalendar.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer sequence;

  /**
   * Source from which the event was created. For example, a web page, an email message or any
   * document identifiable by an URL with HTTP or HTTPS scheme. Can only be seen or modified by the
   * creator of the event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Source source;

  /**
   * The (inclusive) start time of the event. For a recurring event, this is the start time of the
   * first instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EventDateTime start;

  /**
   * Status of the event. Optional. Possible values are: - "confirmed" - The event is confirmed.
   * This is the default status.  - "tentative" - The event is tentatively confirmed.  - "cancelled"
   * - The event is cancelled (deleted). The list method returns cancelled events only on
   * incremental sync (when syncToken or updatedMin are specified) or if the showDeleted flag is set
   * to true. The get method always returns them. A cancelled status represents two different states
   * depending on the event type:   - Cancelled exceptions of an uncancelled recurring event
   * indicate that this instance should no longer be presented to the user. Clients should store
   * these events for the lifetime of the parent recurring event. Cancelled exceptions are only
   * guaranteed to have values for the id, recurringEventId and originalStartTime fields populated.
   * The other fields might be empty.   - All other cancelled events represent deleted events.
   * Clients should remove their locally synced copies. Such cancelled events will eventually
   * disappear, so do not rely on them being available indefinitely. Deleted events are only
   * guaranteed to have the id field populated.   On the organizer's calendar, cancelled events
   * continue to expose event details (summary, location, etc.) so that they can be restored
   * (undeleted). Similarly, the events to which the user was invited and that they manually removed
   * continue to provide details. However, incremental sync requests with showDeleted set to false
   * will not return these details. If an event changes its organizer (for example via the move
   * operation) and the original organizer is not on the attendee list, it will leave behind a
   * cancelled event where only the id field is guaranteed to be populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Title of the event.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String summary;

  /**
   * Whether the event blocks time on the calendar. Optional. Possible values are: - "opaque" -
   * Default value. The event does block time on the calendar. This is equivalent to setting Show me
   * as to Busy in the Calendar UI.  - "transparent" - The event does not block time on the
   * calendar. This is equivalent to setting Show me as to Available in the Calendar UI.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String transparency;

  /**
   * Last modification time of the event (as a RFC3339 timestamp). Read-only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime updated;

  /**
   * Visibility of the event. Optional. Possible values are: - "default" - Uses the default
   * visibility for events on the calendar. This is the default value.  - "public" - The event is
   * public and event details are visible to all readers of the calendar.  - "private" - The event
   * is private and only event attendees may view event details.  - "confidential" - The event is
   * private. This value is provided for compatibility reasons.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String visibility;

  /**
   * Working location event data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EventWorkingLocationProperties workingLocationProperties;

  /**
   * Whether anyone can invite themselves to the event (deprecated). Optional. The default is False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAnyoneCanAddSelf() {
    return anyoneCanAddSelf;
  }

  /**
   * Whether anyone can invite themselves to the event (deprecated). Optional. The default is False.
   * @param anyoneCanAddSelf anyoneCanAddSelf or {@code null} for none
   */
  public Event setAnyoneCanAddSelf(java.lang.Boolean anyoneCanAddSelf) {
    this.anyoneCanAddSelf = anyoneCanAddSelf;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether anyone can invite themselves to the event (deprecated). Optional. The default is False.
   * </p>
   */
  public boolean isAnyoneCanAddSelf() {
    if (anyoneCanAddSelf == null || anyoneCanAddSelf == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return anyoneCanAddSelf;
  }

  /**
   * File attachments for the event. In order to modify attachments the supportsAttachments request
   * parameter should be set to true. There can be at most 25 attachments per event,
   * @return value or {@code null} for none
   */
  public java.util.List<EventAttachment> getAttachments() {
    return attachments;
  }

  /**
   * File attachments for the event. In order to modify attachments the supportsAttachments request
   * parameter should be set to true. There can be at most 25 attachments per event,
   * @param attachments attachments or {@code null} for none
   */
  public Event setAttachments(java.util.List<EventAttachment> attachments) {
    this.attachments = attachments;
    return this;
  }

  /**
   * The attendees of the event. See the Events with attendees guide for more information on
   * scheduling events with other calendar users. Service accounts need to use domain-wide
   * delegation of authority to populate the attendee list.
   * @return value or {@code null} for none
   */
  public java.util.List<EventAttendee> getAttendees() {
    return attendees;
  }

  /**
   * The attendees of the event. See the Events with attendees guide for more information on
   * scheduling events with other calendar users. Service accounts need to use domain-wide
   * delegation of authority to populate the attendee list.
   * @param attendees attendees or {@code null} for none
   */
  public Event setAttendees(java.util.List<EventAttendee> attendees) {
    this.attendees = attendees;
    return this;
  }

  /**
   * Whether attendees may have been omitted from the event's representation. When retrieving an
   * event, this may be due to a restriction specified by the maxAttendee query parameter. When
   * updating an event, this can be used to only update the participant's response. Optional. The
   * default is False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAttendeesOmitted() {
    return attendeesOmitted;
  }

  /**
   * Whether attendees may have been omitted from the event's representation. When retrieving an
   * event, this may be due to a restriction specified by the maxAttendee query parameter. When
   * updating an event, this can be used to only update the participant's response. Optional. The
   * default is False.
   * @param attendeesOmitted attendeesOmitted or {@code null} for none
   */
  public Event setAttendeesOmitted(java.lang.Boolean attendeesOmitted) {
    this.attendeesOmitted = attendeesOmitted;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether attendees may have been omitted from the event's representation. When retrieving an event,
 this may be due to a restriction specified by the maxAttendee query parameter. When updating an
 event, this can be used to only update the participant's response. Optional. The default is False.
   * </p>
   */
  public boolean isAttendeesOmitted() {
    if (attendeesOmitted == null || attendeesOmitted == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return attendeesOmitted;
  }

  /**
   * The color of the event. This is an ID referring to an entry in the event section of the colors
   * definition (see the  colors endpoint). Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getColorId() {
    return colorId;
  }

  /**
   * The color of the event. This is an ID referring to an entry in the event section of the colors
   * definition (see the  colors endpoint). Optional.
   * @param colorId colorId or {@code null} for none
   */
  public Event setColorId(java.lang.String colorId) {
    this.colorId = colorId;
    return this;
  }

  /**
   * The conference-related information, such as details of a Google Meet conference. To create new
   * conference details use the createRequest field. To persist your changes, remember to set the
   * conferenceDataVersion request parameter to 1 for all event modification requests.
   * @return value or {@code null} for none
   */
  public ConferenceData getConferenceData() {
    return conferenceData;
  }

  /**
   * The conference-related information, such as details of a Google Meet conference. To create new
   * conference details use the createRequest field. To persist your changes, remember to set the
   * conferenceDataVersion request parameter to 1 for all event modification requests.
   * @param conferenceData conferenceData or {@code null} for none
   */
  public Event setConferenceData(ConferenceData conferenceData) {
    this.conferenceData = conferenceData;
    return this;
  }

  /**
   * Creation time of the event (as a RFC3339 timestamp). Read-only.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreated() {
    return created;
  }

  /**
   * Creation time of the event (as a RFC3339 timestamp). Read-only.
   * @param created created or {@code null} for none
   */
  public Event setCreated(com.google.api.client.util.DateTime created) {
    this.created = created;
    return this;
  }

  /**
   * The creator of the event. Read-only.
   * @return value or {@code null} for none
   */
  public Creator getCreator() {
    return creator;
  }

  /**
   * The creator of the event. Read-only.
   * @param creator creator or {@code null} for none
   */
  public Event setCreator(Creator creator) {
    this.creator = creator;
    return this;
  }

  /**
   * Description of the event. Can contain HTML. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Description of the event. Can contain HTML. Optional.
   * @param description description or {@code null} for none
   */
  public Event setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * The (exclusive) end time of the event. For a recurring event, this is the end time of the first
   * instance.
   * @return value or {@code null} for none
   */
  public EventDateTime getEnd() {
    return end;
  }

  /**
   * The (exclusive) end time of the event. For a recurring event, this is the end time of the first
   * instance.
   * @param end end or {@code null} for none
   */
  public Event setEnd(EventDateTime end) {
    this.end = end;
    return this;
  }

  /**
   * Whether the end time is actually unspecified. An end time is still provided for compatibility
   * reasons, even if this attribute is set to True. The default is False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEndTimeUnspecified() {
    return endTimeUnspecified;
  }

  /**
   * Whether the end time is actually unspecified. An end time is still provided for compatibility
   * reasons, even if this attribute is set to True. The default is False.
   * @param endTimeUnspecified endTimeUnspecified or {@code null} for none
   */
  public Event setEndTimeUnspecified(java.lang.Boolean endTimeUnspecified) {
    this.endTimeUnspecified = endTimeUnspecified;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether the end time is actually unspecified. An end time is still provided for compatibility
 reasons, even if this attribute is set to True. The default is False.
   * </p>
   */
  public boolean isEndTimeUnspecified() {
    if (endTimeUnspecified == null || endTimeUnspecified == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return endTimeUnspecified;
  }

  /**
   * ETag of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * ETag of the resource.
   * @param etag etag or {@code null} for none
   */
  public Event setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Specific type of the event. This cannot be modified after the event is created. Possible values
   * are: - "default" - A regular event or not further specified.  - "outOfOffice" - An out-of-
   * office event.  - "focusTime" - A focus-time event.  - "workingLocation" - A working location
   * event.
   * @return value or {@code null} for none
   */
  public java.lang.String getEventType() {
    return eventType;
  }

  /**
   * Specific type of the event. This cannot be modified after the event is created. Possible values
   * are: - "default" - A regular event or not further specified.  - "outOfOffice" - An out-of-
   * office event.  - "focusTime" - A focus-time event.  - "workingLocation" - A working location
   * event.
   * @param eventType eventType or {@code null} for none
   */
  public Event setEventType(java.lang.String eventType) {
    this.eventType = eventType;
    return this;
  }

  /**
   * Extended properties of the event.
   * @return value or {@code null} for none
   */
  public ExtendedProperties getExtendedProperties() {
    return extendedProperties;
  }

  /**
   * Extended properties of the event.
   * @param extendedProperties extendedProperties or {@code null} for none
   */
  public Event setExtendedProperties(ExtendedProperties extendedProperties) {
    this.extendedProperties = extendedProperties;
    return this;
  }

  /**
   * Focus Time event data. Used if eventType is focusTime.
   * @return value or {@code null} for none
   */
  public EventFocusTimeProperties getFocusTimeProperties() {
    return focusTimeProperties;
  }

  /**
   * Focus Time event data. Used if eventType is focusTime.
   * @param focusTimeProperties focusTimeProperties or {@code null} for none
   */
  public Event setFocusTimeProperties(EventFocusTimeProperties focusTimeProperties) {
    this.focusTimeProperties = focusTimeProperties;
    return this;
  }

  /**
   * A gadget that extends this event. Gadgets are deprecated; this structure is instead only used
   * for returning birthday calendar metadata.
   * @return value or {@code null} for none
   */
  public Gadget getGadget() {
    return gadget;
  }

  /**
   * A gadget that extends this event. Gadgets are deprecated; this structure is instead only used
   * for returning birthday calendar metadata.
   * @param gadget gadget or {@code null} for none
   */
  public Event setGadget(Gadget gadget) {
    this.gadget = gadget;
    return this;
  }

  /**
   * Whether attendees other than the organizer can invite others to the event. Optional. The
   * default is True.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getGuestsCanInviteOthers() {
    return guestsCanInviteOthers;
  }

  /**
   * Whether attendees other than the organizer can invite others to the event. Optional. The
   * default is True.
   * @param guestsCanInviteOthers guestsCanInviteOthers or {@code null} for none
   */
  public Event setGuestsCanInviteOthers(java.lang.Boolean guestsCanInviteOthers) {
    this.guestsCanInviteOthers = guestsCanInviteOthers;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether attendees other than the organizer can invite others to the event. Optional. The default is
 True.
   * </p>
   */
  public boolean isGuestsCanInviteOthers() {
    if (guestsCanInviteOthers == null || guestsCanInviteOthers == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return true;
    }
    return guestsCanInviteOthers;
  }

  /**
   * Whether attendees other than the organizer can modify the event. Optional. The default is
   * False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getGuestsCanModify() {
    return guestsCanModify;
  }

  /**
   * Whether attendees other than the organizer can modify the event. Optional. The default is
   * False.
   * @param guestsCanModify guestsCanModify or {@code null} for none
   */
  public Event setGuestsCanModify(java.lang.Boolean guestsCanModify) {
    this.guestsCanModify = guestsCanModify;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether attendees other than the organizer can modify the event. Optional. The default is False.
   * </p>
   */
  public boolean isGuestsCanModify() {
    if (guestsCanModify == null || guestsCanModify == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return guestsCanModify;
  }

  /**
   * Whether attendees other than the organizer can see who the event's attendees are. Optional. The
   * default is True.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getGuestsCanSeeOtherGuests() {
    return guestsCanSeeOtherGuests;
  }

  /**
   * Whether attendees other than the organizer can see who the event's attendees are. Optional. The
   * default is True.
   * @param guestsCanSeeOtherGuests guestsCanSeeOtherGuests or {@code null} for none
   */
  public Event setGuestsCanSeeOtherGuests(java.lang.Boolean guestsCanSeeOtherGuests) {
    this.guestsCanSeeOtherGuests = guestsCanSeeOtherGuests;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether attendees other than the organizer can see who the event's attendees are. Optional. The
 default is True.
   * </p>
   */
  public boolean isGuestsCanSeeOtherGuests() {
    if (guestsCanSeeOtherGuests == null || guestsCanSeeOtherGuests == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return true;
    }
    return guestsCanSeeOtherGuests;
  }

  /**
   * An absolute link to the Google Hangout associated with this event. Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getHangoutLink() {
    return hangoutLink;
  }

  /**
   * An absolute link to the Google Hangout associated with this event. Read-only.
   * @param hangoutLink hangoutLink or {@code null} for none
   */
  public Event setHangoutLink(java.lang.String hangoutLink) {
    this.hangoutLink = hangoutLink;
    return this;
  }

  /**
   * An absolute link to this event in the Google Calendar Web UI. Read-only.
   * @return value or {@code null} for none
   */
  public java.lang.String getHtmlLink() {
    return htmlLink;
  }

  /**
   * An absolute link to this event in the Google Calendar Web UI. Read-only.
   * @param htmlLink htmlLink or {@code null} for none
   */
  public Event setHtmlLink(java.lang.String htmlLink) {
    this.htmlLink = htmlLink;
    return this;
  }

  /**
   * Event unique identifier as defined in RFC5545. It is used to uniquely identify events accross
   * calendaring systems and must be supplied when importing events via the import method. Note that
   * the iCalUID and the id are not identical and only one of them should be supplied at event
   * creation time. One difference in their semantics is that in recurring events, all occurrences
   * of one event have different ids while they all share the same iCalUIDs. To retrieve an event
   * using its iCalUID, call the events.list method using the iCalUID parameter. To retrieve an
   * event using its id, call the events.get method.
   * @return value or {@code null} for none
   */
  public java.lang.String getICalUID() {
    return iCalUID;
  }

  /**
   * Event unique identifier as defined in RFC5545. It is used to uniquely identify events accross
   * calendaring systems and must be supplied when importing events via the import method. Note that
   * the iCalUID and the id are not identical and only one of them should be supplied at event
   * creation time. One difference in their semantics is that in recurring events, all occurrences
   * of one event have different ids while they all share the same iCalUIDs. To retrieve an event
   * using its iCalUID, call the events.list method using the iCalUID parameter. To retrieve an
   * event using its id, call the events.get method.
   * @param iCalUID iCalUID or {@code null} for none
   */
  public Event setICalUID(java.lang.String iCalUID) {
    this.iCalUID = iCalUID;
    return this;
  }

  /**
   * Opaque identifier of the event. When creating new single or recurring events, you can specify
   * their IDs. Provided IDs must follow these rules: - characters allowed in the ID are those used
   * in base32hex encoding, i.e. lowercase letters a-v and digits 0-9, see section 3.1.2 in RFC2938
   * - the length of the ID must be between 5 and 1024 characters  - the ID must be unique per
   * calendar  Due to the globally distributed nature of the system, we cannot guarantee that ID
   * collisions will be detected at event creation time. To minimize the risk of collisions we
   * recommend using an established UUID algorithm such as one described in RFC4122. If you do not
   * specify an ID, it will be automatically generated by the server. Note that the icalUID and the
   * id are not identical and only one of them should be supplied at event creation time. One
   * difference in their semantics is that in recurring events, all occurrences of one event have
   * different ids while they all share the same icalUIDs.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Opaque identifier of the event. When creating new single or recurring events, you can specify
   * their IDs. Provided IDs must follow these rules: - characters allowed in the ID are those used
   * in base32hex encoding, i.e. lowercase letters a-v and digits 0-9, see section 3.1.2 in RFC2938
   * - the length of the ID must be between 5 and 1024 characters  - the ID must be unique per
   * calendar  Due to the globally distributed nature of the system, we cannot guarantee that ID
   * collisions will be detected at event creation time. To minimize the risk of collisions we
   * recommend using an established UUID algorithm such as one described in RFC4122. If you do not
   * specify an ID, it will be automatically generated by the server. Note that the icalUID and the
   * id are not identical and only one of them should be supplied at event creation time. One
   * difference in their semantics is that in recurring events, all occurrences of one event have
   * different ids while they all share the same icalUIDs.
   * @param id id or {@code null} for none
   */
  public Event setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource ("calendar#event").
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource ("calendar#event").
   * @param kind kind or {@code null} for none
   */
  public Event setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Geographic location of the event as free-form text. Optional.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * Geographic location of the event as free-form text. Optional.
   * @param location location or {@code null} for none
   */
  public Event setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * Whether this is a locked event copy where no changes can be made to the main event fields
   * "summary", "description", "location", "start", "end" or "recurrence". The default is False.
   * Read-Only.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getLocked() {
    return locked;
  }

  /**
   * Whether this is a locked event copy where no changes can be made to the main event fields
   * "summary", "description", "location", "start", "end" or "recurrence". The default is False.
   * Read-Only.
   * @param locked locked or {@code null} for none
   */
  public Event setLocked(java.lang.Boolean locked) {
    this.locked = locked;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Whether this is a locked event copy where no changes can be made to the main event fields
 "summary", "description", "location", "start", "end" or "recurrence". The default is False. Read-
 Only.
   * </p>
   */
  public boolean isLocked() {
    if (locked == null || locked == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return locked;
  }

  /**
   * The organizer of the event. If the organizer is also an attendee, this is indicated with a
   * separate entry in attendees with the organizer field set to True. To change the organizer, use
   * the move operation. Read-only, except when importing an event.
   * @return value or {@code null} for none
   */
  public Organizer getOrganizer() {
    return organizer;
  }

  /**
   * The organizer of the event. If the organizer is also an attendee, this is indicated with a
   * separate entry in attendees with the organizer field set to True. To change the organizer, use
   * the move operation. Read-only, except when importing an event.
   * @param organizer organizer or {@code null} for none
   */
  public Event setOrganizer(Organizer organizer) {
    this.organizer = organizer;
    return this;
  }

  /**
   * For an instance of a recurring event, this is the time at which this event would start
   * according to the recurrence data in the recurring event identified by recurringEventId. It
   * uniquely identifies the instance within the recurring event series even if the instance was
   * moved to a different time. Immutable.
   * @return value or {@code null} for none
   */
  public EventDateTime getOriginalStartTime() {
    return originalStartTime;
  }

  /**
   * For an instance of a recurring event, this is the time at which this event would start
   * according to the recurrence data in the recurring event identified by recurringEventId. It
   * uniquely identifies the instance within the recurring event series even if the instance was
   * moved to a different time. Immutable.
   * @param originalStartTime originalStartTime or {@code null} for none
   */
  public Event setOriginalStartTime(EventDateTime originalStartTime) {
    this.originalStartTime = originalStartTime;
    return this;
  }

  /**
   * Out of office event data. Used if eventType is outOfOffice.
   * @return value or {@code null} for none
   */
  public EventOutOfOfficeProperties getOutOfOfficeProperties() {
    return outOfOfficeProperties;
  }

  /**
   * Out of office event data. Used if eventType is outOfOffice.
   * @param outOfOfficeProperties outOfOfficeProperties or {@code null} for none
   */
  public Event setOutOfOfficeProperties(EventOutOfOfficeProperties outOfOfficeProperties) {
    this.outOfOfficeProperties = outOfOfficeProperties;
    return this;
  }

  /**
   * If set to True, Event propagation is disabled. Note that it is not the same thing as Private
   * event properties. Optional. Immutable. The default is False.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPrivateCopy() {
    return privateCopy;
  }

  /**
   * If set to True, Event propagation is disabled. Note that it is not the same thing as Private
   * event properties. Optional. Immutable. The default is False.
   * @param privateCopy privateCopy or {@code null} for none
   */
  public Event setPrivateCopy(java.lang.Boolean privateCopy) {
    this.privateCopy = privateCopy;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * If set to True, Event propagation is disabled. Note that it is not the same thing as Private event
 properties. Optional. Immutable. The default is False.
   * </p>
   */
  public boolean isPrivateCopy() {
    if (privateCopy == null || privateCopy == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return false;
    }
    return privateCopy;
  }

  /**
   * List of RRULE, EXRULE, RDATE and EXDATE lines for a recurring event, as specified in RFC5545.
   * Note that DTSTART and DTEND lines are not allowed in this field; event start and end times are
   * specified in the start and end fields. This field is omitted for single events or instances of
   * recurring events.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getRecurrence() {
    return recurrence;
  }

  /**
   * List of RRULE, EXRULE, RDATE and EXDATE lines for a recurring event, as specified in RFC5545.
   * Note that DTSTART and DTEND lines are not allowed in this field; event start and end times are
   * specified in the start and end fields. This field is omitted for single events or instances of
   * recurring events.
   * @param recurrence recurrence or {@code null} for none
   */
  public Event setRecurrence(java.util.List<java.lang.String> recurrence) {
    this.recurrence = recurrence;
    return this;
  }

  /**
   * For an instance of a recurring event, this is the id of the recurring event to which this
   * instance belongs. Immutable.
   * @return value or {@code null} for none
   */
  public java.lang.String getRecurringEventId() {
    return recurringEventId;
  }

  /**
   * For an instance of a recurring event, this is the id of the recurring event to which this
   * instance belongs. Immutable.
   * @param recurringEventId recurringEventId or {@code null} for none
   */
  public Event setRecurringEventId(java.lang.String recurringEventId) {
    this.recurringEventId = recurringEventId;
    return this;
  }

  /**
   * Information about the event's reminders for the authenticated user.
   * @return value or {@code null} for none
   */
  public Reminders getReminders() {
    return reminders;
  }

  /**
   * Information about the event's reminders for the authenticated user.
   * @param reminders reminders or {@code null} for none
   */
  public Event setReminders(Reminders reminders) {
    this.reminders = reminders;
    return this;
  }

  /**
   * Sequence number as per iCalendar.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getSequence() {
    return sequence;
  }

  /**
   * Sequence number as per iCalendar.
   * @param sequence sequence or {@code null} for none
   */
  public Event setSequence(java.lang.Integer sequence) {
    this.sequence = sequence;
    return this;
  }

  /**
   * Source from which the event was created. For example, a web page, an email message or any
   * document identifiable by an URL with HTTP or HTTPS scheme. Can only be seen or modified by the
   * creator of the event.
   * @return value or {@code null} for none
   */
  public Source getSource() {
    return source;
  }

  /**
   * Source from which the event was created. For example, a web page, an email message or any
   * document identifiable by an URL with HTTP or HTTPS scheme. Can only be seen or modified by the
   * creator of the event.
   * @param source source or {@code null} for none
   */
  public Event setSource(Source source) {
    this.source = source;
    return this;
  }

  /**
   * The (inclusive) start time of the event. For a recurring event, this is the start time of the
   * first instance.
   * @return value or {@code null} for none
   */
  public EventDateTime getStart() {
    return start;
  }

  /**
   * The (inclusive) start time of the event. For a recurring event, this is the start time of the
   * first instance.
   * @param start start or {@code null} for none
   */
  public Event setStart(EventDateTime start) {
    this.start = start;
    return this;
  }

  /**
   * Status of the event. Optional. Possible values are: - "confirmed" - The event is confirmed.
   * This is the default status.  - "tentative" - The event is tentatively confirmed.  - "cancelled"
   * - The event is cancelled (deleted). The list method returns cancelled events only on
   * incremental sync (when syncToken or updatedMin are specified) or if the showDeleted flag is set
   * to true. The get method always returns them. A cancelled status represents two different states
   * depending on the event type:   - Cancelled exceptions of an uncancelled recurring event
   * indicate that this instance should no longer be presented to the user. Clients should store
   * these events for the lifetime of the parent recurring event. Cancelled exceptions are only
   * guaranteed to have values for the id, recurringEventId and originalStartTime fields populated.
   * The other fields might be empty.   - All other cancelled events represent deleted events.
   * Clients should remove their locally synced copies. Such cancelled events will eventually
   * disappear, so do not rely on them being available indefinitely. Deleted events are only
   * guaranteed to have the id field populated.   On the organizer's calendar, cancelled events
   * continue to expose event details (summary, location, etc.) so that they can be restored
   * (undeleted). Similarly, the events to which the user was invited and that they manually removed
   * continue to provide details. However, incremental sync requests with showDeleted set to false
   * will not return these details. If an event changes its organizer (for example via the move
   * operation) and the original organizer is not on the attendee list, it will leave behind a
   * cancelled event where only the id field is guaranteed to be populated.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Status of the event. Optional. Possible values are: - "confirmed" - The event is confirmed.
   * This is the default status.  - "tentative" - The event is tentatively confirmed.  - "cancelled"
   * - The event is cancelled (deleted). The list method returns cancelled events only on
   * incremental sync (when syncToken or updatedMin are specified) or if the showDeleted flag is set
   * to true. The get method always returns them. A cancelled status represents two different states
   * depending on the event type:   - Cancelled exceptions of an uncancelled recurring event
   * indicate that this instance should no longer be presented to the user. Clients should store
   * these events for the lifetime of the parent recurring event. Cancelled exceptions are only
   * guaranteed to have values for the id, recurringEventId and originalStartTime fields populated.
   * The other fields might be empty.   - All other cancelled events represent deleted events.
   * Clients should remove their locally synced copies. Such cancelled events will eventually
   * disappear, so do not rely on them being available indefinitely. Deleted events are only
   * guaranteed to have the id field populated.   On the organizer's calendar, cancelled events
   * continue to expose event details (summary, location, etc.) so that they can be restored
   * (undeleted). Similarly, the events to which the user was invited and that they manually removed
   * continue to provide details. However, incremental sync requests with showDeleted set to false
   * will not return these details. If an event changes its organizer (for example via the move
   * operation) and the original organizer is not on the attendee list, it will leave behind a
   * cancelled event where only the id field is guaranteed to be populated.
   * @param status status or {@code null} for none
   */
  public Event setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  /**
   * Title of the event.
   * @return value or {@code null} for none
   */
  public java.lang.String getSummary() {
    return summary;
  }

  /**
   * Title of the event.
   * @param summary summary or {@code null} for none
   */
  public Event setSummary(java.lang.String summary) {
    this.summary = summary;
    return this;
  }

  /**
   * Whether the event blocks time on the calendar. Optional. Possible values are: - "opaque" -
   * Default value. The event does block time on the calendar. This is equivalent to setting Show me
   * as to Busy in the Calendar UI.  - "transparent" - The event does not block time on the
   * calendar. This is equivalent to setting Show me as to Available in the Calendar UI.
   * @return value or {@code null} for none
   */
  public java.lang.String getTransparency() {
    return transparency;
  }

  /**
   * Whether the event blocks time on the calendar. Optional. Possible values are: - "opaque" -
   * Default value. The event does block time on the calendar. This is equivalent to setting Show me
   * as to Busy in the Calendar UI.  - "transparent" - The event does not block time on the
   * calendar. This is equivalent to setting Show me as to Available in the Calendar UI.
   * @param transparency transparency or {@code null} for none
   */
  public Event setTransparency(java.lang.String transparency) {
    this.transparency = transparency;
    return this;
  }

  /**
   * Last modification time of the event (as a RFC3339 timestamp). Read-only.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getUpdated() {
    return updated;
  }

  /**
   * Last modification time of the event (as a RFC3339 timestamp). Read-only.
   * @param updated updated or {@code null} for none
   */
  public Event setUpdated(com.google.api.client.util.DateTime updated) {
    this.updated = updated;
    return this;
  }

  /**
   * Visibility of the event. Optional. Possible values are: - "default" - Uses the default
   * visibility for events on the calendar. This is the default value.  - "public" - The event is
   * public and event details are visible to all readers of the calendar.  - "private" - The event
   * is private and only event attendees may view event details.  - "confidential" - The event is
   * private. This value is provided for compatibility reasons.
   * @return value or {@code null} for none
   */
  public java.lang.String getVisibility() {
    return visibility;
  }

  /**
   * Visibility of the event. Optional. Possible values are: - "default" - Uses the default
   * visibility for events on the calendar. This is the default value.  - "public" - The event is
   * public and event details are visible to all readers of the calendar.  - "private" - The event
   * is private and only event attendees may view event details.  - "confidential" - The event is
   * private. This value is provided for compatibility reasons.
   * @param visibility visibility or {@code null} for none
   */
  public Event setVisibility(java.lang.String visibility) {
    this.visibility = visibility;
    return this;
  }

  /**
   * Working location event data.
   * @return value or {@code null} for none
   */
  public EventWorkingLocationProperties getWorkingLocationProperties() {
    return workingLocationProperties;
  }

  /**
   * Working location event data.
   * @param workingLocationProperties workingLocationProperties or {@code null} for none
   */
  public Event setWorkingLocationProperties(EventWorkingLocationProperties workingLocationProperties) {
    this.workingLocationProperties = workingLocationProperties;
    return this;
  }

  @Override
  public Event set(String fieldName, Object value) {
    return (Event) super.set(fieldName, value);
  }

  @Override
  public Event clone() {
    return (Event) super.clone();
  }

  /**
   * The creator of the event. Read-only.
   */
  public static final class Creator extends com.google.api.client.json.GenericJson {

    /**
     * The creator's name, if available.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String displayName;

    /**
     * The creator's email address, if available.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String email;

    /**
     * The creator's Profile ID, if available.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String id;

    /**
     * Whether the creator corresponds to the calendar on which this copy of the event appears. Read-
     * only. The default is False.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean self;

    /**
     * The creator's name, if available.
     * @return value or {@code null} for none
     */
    public java.lang.String getDisplayName() {
      return displayName;
    }

    /**
     * The creator's name, if available.
     * @param displayName displayName or {@code null} for none
     */
    public Creator setDisplayName(java.lang.String displayName) {
      this.displayName = displayName;
      return this;
    }

    /**
     * The creator's email address, if available.
     * @return value or {@code null} for none
     */
    public java.lang.String getEmail() {
      return email;
    }

    /**
     * The creator's email address, if available.
     * @param email email or {@code null} for none
     */
    public Creator setEmail(java.lang.String email) {
      this.email = email;
      return this;
    }

    /**
     * The creator's Profile ID, if available.
     * @return value or {@code null} for none
     */
    public java.lang.String getId() {
      return id;
    }

    /**
     * The creator's Profile ID, if available.
     * @param id id or {@code null} for none
     */
    public Creator setId(java.lang.String id) {
      this.id = id;
      return this;
    }

    /**
     * Whether the creator corresponds to the calendar on which this copy of the event appears. Read-
     * only. The default is False.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getSelf() {
      return self;
    }

    /**
     * Whether the creator corresponds to the calendar on which this copy of the event appears. Read-
     * only. The default is False.
     * @param self self or {@code null} for none
     */
    public Creator setSelf(java.lang.Boolean self) {
      this.self = self;
      return this;
    }

    /**
     * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
     *
     * <p>
     * Boolean properties can have four possible values:
     * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
     * or {@link Boolean#FALSE}.
     * </p>
     *
     * <p>
     * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
     * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
     * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
     * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
     * </p>
     *
     * <p>
     * Whether the creator corresponds to the calendar on which this copy of the event appears. Read-only.
   The default is False.
     * </p>
     */
    public boolean isSelf() {
      if (self == null || self == com.google.api.client.util.Data.NULL_BOOLEAN) {
        return false;
      }
      return self;
    }

    @Override
    public Creator set(String fieldName, Object value) {
      return (Creator) super.set(fieldName, value);
    }

    @Override
    public Creator clone() {
      return (Creator) super.clone();
    }

  }

  /**
   * Extended properties of the event.
   */
  public static final class ExtendedProperties extends com.google.api.client.json.GenericJson {

    /**
     * Properties that are private to the copy of the event that appears on this calendar.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key("private")
    private java.util.Map<String, java.lang.String> private__;

    /**
     * Properties that are shared between copies of the event on other attendees' calendars.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.Map<String, java.lang.String> shared;

    /**
     * Properties that are private to the copy of the event that appears on this calendar.
     * @return value or {@code null} for none
     */
    public java.util.Map<String, java.lang.String> getPrivate() {
      return private__;
    }

    /**
     * Properties that are private to the copy of the event that appears on this calendar.
     * @param private__ private__ or {@code null} for none
     */
    public ExtendedProperties setPrivate(java.util.Map<String, java.lang.String> private__) {
      this.private__ = private__;
      return this;
    }

    /**
     * Properties that are shared between copies of the event on other attendees' calendars.
     * @return value or {@code null} for none
     */
    public java.util.Map<String, java.lang.String> getShared() {
      return shared;
    }

    /**
     * Properties that are shared between copies of the event on other attendees' calendars.
     * @param shared shared or {@code null} for none
     */
    public ExtendedProperties setShared(java.util.Map<String, java.lang.String> shared) {
      this.shared = shared;
      return this;
    }

    @Override
    public ExtendedProperties set(String fieldName, Object value) {
      return (ExtendedProperties) super.set(fieldName, value);
    }

    @Override
    public ExtendedProperties clone() {
      return (ExtendedProperties) super.clone();
    }

  }

  /**
   * A gadget that extends this event. Gadgets are deprecated; this structure is instead only used for
   * returning birthday calendar metadata.
   */
  public static final class Gadget extends com.google.api.client.json.GenericJson {

    /**
     * The gadget's display mode. Deprecated. Possible values are: - "icon" - The gadget displays next
     * to the event's title in the calendar view.  - "chip" - The gadget displays when the event is
     * clicked.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String display;

    /**
     * The gadget's height in pixels. The height must be an integer greater than 0. Optional.
     * Deprecated.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer height;

    /**
     * The gadget's icon URL. The URL scheme must be HTTPS. Deprecated.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String iconLink;

    /**
     * The gadget's URL. The URL scheme must be HTTPS. Deprecated.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String link;

    /**
     * Preferences.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.Map<String, java.lang.String> preferences;

    /**
     * The gadget's title. Deprecated.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String title;

    /**
     * The gadget's type. Deprecated.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * The gadget's width in pixels. The width must be an integer greater than 0. Optional.
     * Deprecated.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer width;

    /**
     * The gadget's display mode. Deprecated. Possible values are: - "icon" - The gadget displays next
     * to the event's title in the calendar view.  - "chip" - The gadget displays when the event is
     * clicked.
     * @return value or {@code null} for none
     */
    public java.lang.String getDisplay() {
      return display;
    }

    /**
     * The gadget's display mode. Deprecated. Possible values are: - "icon" - The gadget displays next
     * to the event's title in the calendar view.  - "chip" - The gadget displays when the event is
     * clicked.
     * @param display display or {@code null} for none
     */
    public Gadget setDisplay(java.lang.String display) {
      this.display = display;
      return this;
    }

    /**
     * The gadget's height in pixels. The height must be an integer greater than 0. Optional.
     * Deprecated.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getHeight() {
      return height;
    }

    /**
     * The gadget's height in pixels. The height must be an integer greater than 0. Optional.
     * Deprecated.
     * @param height height or {@code null} for none
     */
    public Gadget setHeight(java.lang.Integer height) {
      this.height = height;
      return this;
    }

    /**
     * The gadget's icon URL. The URL scheme must be HTTPS. Deprecated.
     * @return value or {@code null} for none
     */
    public java.lang.String getIconLink() {
      return iconLink;
    }

    /**
     * The gadget's icon URL. The URL scheme must be HTTPS. Deprecated.
     * @param iconLink iconLink or {@code null} for none
     */
    public Gadget setIconLink(java.lang.String iconLink) {
      this.iconLink = iconLink;
      return this;
    }

    /**
     * The gadget's URL. The URL scheme must be HTTPS. Deprecated.
     * @return value or {@code null} for none
     */
    public java.lang.String getLink() {
      return link;
    }

    /**
     * The gadget's URL. The URL scheme must be HTTPS. Deprecated.
     * @param link link or {@code null} for none
     */
    public Gadget setLink(java.lang.String link) {
      this.link = link;
      return this;
    }

    /**
     * Preferences.
     * @return value or {@code null} for none
     */
    public java.util.Map<String, java.lang.String> getPreferences() {
      return preferences;
    }

    /**
     * Preferences.
     * @param preferences preferences or {@code null} for none
     */
    public Gadget setPreferences(java.util.Map<String, java.lang.String> preferences) {
      this.preferences = preferences;
      return this;
    }

    /**
     * The gadget's title. Deprecated.
     * @return value or {@code null} for none
     */
    public java.lang.String getTitle() {
      return title;
    }

    /**
     * The gadget's title. Deprecated.
     * @param title title or {@code null} for none
     */
    public Gadget setTitle(java.lang.String title) {
      this.title = title;
      return this;
    }

    /**
     * The gadget's type. Deprecated.
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * The gadget's type. Deprecated.
     * @param type type or {@code null} for none
     */
    public Gadget setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    /**
     * The gadget's width in pixels. The width must be an integer greater than 0. Optional.
     * Deprecated.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getWidth() {
      return width;
    }

    /**
     * The gadget's width in pixels. The width must be an integer greater than 0. Optional.
     * Deprecated.
     * @param width width or {@code null} for none
     */
    public Gadget setWidth(java.lang.Integer width) {
      this.width = width;
      return this;
    }

    @Override
    public Gadget set(String fieldName, Object value) {
      return (Gadget) super.set(fieldName, value);
    }

    @Override
    public Gadget clone() {
      return (Gadget) super.clone();
    }

  }

  /**
   * The organizer of the event. If the organizer is also an attendee, this is indicated with a
   * separate entry in attendees with the organizer field set to True. To change the organizer, use
   * the move operation. Read-only, except when importing an event.
   */
  public static final class Organizer extends com.google.api.client.json.GenericJson {

    /**
     * The organizer's name, if available.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String displayName;

    /**
     * The organizer's email address, if available. It must be a valid email address as per RFC5322.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String email;

    /**
     * The organizer's Profile ID, if available.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String id;

    /**
     * Whether the organizer corresponds to the calendar on which this copy of the event appears.
     * Read-only. The default is False.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean self;

    /**
     * The organizer's name, if available.
     * @return value or {@code null} for none
     */
    public java.lang.String getDisplayName() {
      return displayName;
    }

    /**
     * The organizer's name, if available.
     * @param displayName displayName or {@code null} for none
     */
    public Organizer setDisplayName(java.lang.String displayName) {
      this.displayName = displayName;
      return this;
    }

    /**
     * The organizer's email address, if available. It must be a valid email address as per RFC5322.
     * @return value or {@code null} for none
     */
    public java.lang.String getEmail() {
      return email;
    }

    /**
     * The organizer's email address, if available. It must be a valid email address as per RFC5322.
     * @param email email or {@code null} for none
     */
    public Organizer setEmail(java.lang.String email) {
      this.email = email;
      return this;
    }

    /**
     * The organizer's Profile ID, if available.
     * @return value or {@code null} for none
     */
    public java.lang.String getId() {
      return id;
    }

    /**
     * The organizer's Profile ID, if available.
     * @param id id or {@code null} for none
     */
    public Organizer setId(java.lang.String id) {
      this.id = id;
      return this;
    }

    /**
     * Whether the organizer corresponds to the calendar on which this copy of the event appears.
     * Read-only. The default is False.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getSelf() {
      return self;
    }

    /**
     * Whether the organizer corresponds to the calendar on which this copy of the event appears.
     * Read-only. The default is False.
     * @param self self or {@code null} for none
     */
    public Organizer setSelf(java.lang.Boolean self) {
      this.self = self;
      return this;
    }

    /**
     * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
     *
     * <p>
     * Boolean properties can have four possible values:
     * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
     * or {@link Boolean#FALSE}.
     * </p>
     *
     * <p>
     * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
     * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
     * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
     * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
     * </p>
     *
     * <p>
     * Whether the organizer corresponds to the calendar on which this copy of the event appears. Read-
   only. The default is False.
     * </p>
     */
    public boolean isSelf() {
      if (self == null || self == com.google.api.client.util.Data.NULL_BOOLEAN) {
        return false;
      }
      return self;
    }

    @Override
    public Organizer set(String fieldName, Object value) {
      return (Organizer) super.set(fieldName, value);
    }

    @Override
    public Organizer clone() {
      return (Organizer) super.clone();
    }

  }

  /**
   * Information about the event's reminders for the authenticated user.
   */
  public static final class Reminders extends com.google.api.client.json.GenericJson {

    /**
     * If the event doesn't use the default reminders, this lists the reminders specific to the event,
     * or, if not set, indicates that no reminders are set for this event. The maximum number of
     * override reminders is 5.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.util.List<EventReminder> overrides;

    /**
     * Whether the default reminders of the calendar apply to the event.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean useDefault;

    /**
     * If the event doesn't use the default reminders, this lists the reminders specific to the event,
     * or, if not set, indicates that no reminders are set for this event. The maximum number of
     * override reminders is 5.
     * @return value or {@code null} for none
     */
    public java.util.List<EventReminder> getOverrides() {
      return overrides;
    }

    /**
     * If the event doesn't use the default reminders, this lists the reminders specific to the event,
     * or, if not set, indicates that no reminders are set for this event. The maximum number of
     * override reminders is 5.
     * @param overrides overrides or {@code null} for none
     */
    public Reminders setOverrides(java.util.List<EventReminder> overrides) {
      this.overrides = overrides;
      return this;
    }

    /**
     * Whether the default reminders of the calendar apply to the event.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getUseDefault() {
      return useDefault;
    }

    /**
     * Whether the default reminders of the calendar apply to the event.
     * @param useDefault useDefault or {@code null} for none
     */
    public Reminders setUseDefault(java.lang.Boolean useDefault) {
      this.useDefault = useDefault;
      return this;
    }

    @Override
    public Reminders set(String fieldName, Object value) {
      return (Reminders) super.set(fieldName, value);
    }

    @Override
    public Reminders clone() {
      return (Reminders) super.clone();
    }

  }

  /**
   * Source from which the event was created. For example, a web page, an email message or any
   * document identifiable by an URL with HTTP or HTTPS scheme. Can only be seen or modified by the
   * creator of the event.
   */
  public static final class Source extends com.google.api.client.json.GenericJson {

    /**
     * Title of the source; for example a title of a web page or an email subject.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String title;

    /**
     * URL of the source pointing to a resource. The URL scheme must be HTTP or HTTPS.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String url;

    /**
     * Title of the source; for example a title of a web page or an email subject.
     * @return value or {@code null} for none
     */
    public java.lang.String getTitle() {
      return title;
    }

    /**
     * Title of the source; for example a title of a web page or an email subject.
     * @param title title or {@code null} for none
     */
    public Source setTitle(java.lang.String title) {
      this.title = title;
      return this;
    }

    /**
     * URL of the source pointing to a resource. The URL scheme must be HTTP or HTTPS.
     * @return value or {@code null} for none
     */
    public java.lang.String getUrl() {
      return url;
    }

    /**
     * URL of the source pointing to a resource. The URL scheme must be HTTP or HTTPS.
     * @param url url or {@code null} for none
     */
    public Source setUrl(java.lang.String url) {
      this.url = url;
      return this;
    }

    @Override
    public Source set(String fieldName, Object value) {
      return (Source) super.set(fieldName, value);
    }

    @Override
    public Source clone() {
      return (Source) super.clone();
    }

  }

}
