/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for Model.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Model extends com.google.api.client.json.GenericJson {

  /**
   * The best trial_id across all training runs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long bestTrialId;

  /**
   * Output only. The time when this model was created, in millisecs since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long creationTime;

  /**
   * Output only. The default trial_id to use in TVFs when the trial_id is not passed in. For
   * single-objective [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, this is the best
   * trial ID. For multi-objective [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, this is the
   * smallest trial ID among all Pareto optimal trials.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long defaultTrialId;

  /**
   * Optional. A user-friendly description of this model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Custom encryption configuration (e.g., Cloud KMS keys). This shows the encryption configuration
   * of the model data while stored in BigQuery storage. This field can be used with PatchModel to
   * update encryption key for an already encrypted model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EncryptionConfiguration encryptionConfiguration;

  /**
   * Output only. A hash of this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Optional. The time when this model expires, in milliseconds since the epoch. If not present,
   * the model will persist indefinitely. Expired models will be deleted and their storage
   * reclaimed. The defaultTableExpirationMs property of the encapsulating dataset can be used to
   * set a default expirationTime on newly created models.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expirationTime;

  /**
   * Output only. Input feature columns for the model inference. If the model is trained with
   * TRANSFORM clause, these are the input of the TRANSFORM clause.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StandardSqlField> featureColumns;

  /**
   * Optional. A descriptive name for this model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String friendlyName;

  /**
   * Output only. All hyperparameter search spaces in this model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private HparamSearchSpaces hparamSearchSpaces;

  /**
   * Output only. Trials of a [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) model sorted by trial_id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<HparamTuningTrial> hparamTrials;

  static {
    // hack to force ProGuard to consider HparamTuningTrial used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(HparamTuningTrial.class);
  }

  /**
   * Output only. Label columns that were used to train this model. The output of the model will
   * have a "predicted_" prefix to these columns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StandardSqlField> labelColumns;

  /**
   * The labels associated with this model. You can use these to organize and group your models.
   * Label keys and values can be no longer than 63 characters, can only contain lowercase letters,
   * numeric characters, underscores and dashes. International characters are allowed. Label values
   * are optional. Label keys must start with a letter and each label in the list must have a
   * different key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Output only. The time when this model was last modified, in millisecs since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long lastModifiedTime;

  /**
   * Output only. The geographic location where the model resides. This value is inherited from the
   * dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * Required. Unique identifier for this model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ModelReference modelReference;

  /**
   * Output only. Type of the model resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String modelType;

  /**
   * Output only. For single-objective [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, it only contains
   * the best trial. For multi-objective [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, it contains all
   * Pareto optimal trials sorted by trial_id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> optimalTrialIds;

  /**
   * Output only. Remote model info
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RemoteModelInfo remoteModelInfo;

  /**
   * Information for all training runs in increasing order of start_time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TrainingRun> trainingRuns;

  /**
   * Output only. This field will be populated if a TRANSFORM clause was used to train a model.
   * TRANSFORM clause (if used) takes feature_columns as input and outputs transform_columns.
   * transform_columns then are used to train the model.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TransformColumn> transformColumns;

  /**
   * The best trial_id across all training runs.
   * @return value or {@code null} for none
   */
  public java.lang.Long getBestTrialId() {
    return bestTrialId;
  }

  /**
   * The best trial_id across all training runs.
   * @param bestTrialId bestTrialId or {@code null} for none
   */
  public Model setBestTrialId(java.lang.Long bestTrialId) {
    this.bestTrialId = bestTrialId;
    return this;
  }

  /**
   * Output only. The time when this model was created, in millisecs since the epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCreationTime() {
    return creationTime;
  }

  /**
   * Output only. The time when this model was created, in millisecs since the epoch.
   * @param creationTime creationTime or {@code null} for none
   */
  public Model setCreationTime(java.lang.Long creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * Output only. The default trial_id to use in TVFs when the trial_id is not passed in. For
   * single-objective [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, this is the best
   * trial ID. For multi-objective [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, this is the
   * smallest trial ID among all Pareto optimal trials.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDefaultTrialId() {
    return defaultTrialId;
  }

  /**
   * Output only. The default trial_id to use in TVFs when the trial_id is not passed in. For
   * single-objective [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, this is the best
   * trial ID. For multi-objective [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, this is the
   * smallest trial ID among all Pareto optimal trials.
   * @param defaultTrialId defaultTrialId or {@code null} for none
   */
  public Model setDefaultTrialId(java.lang.Long defaultTrialId) {
    this.defaultTrialId = defaultTrialId;
    return this;
  }

  /**
   * Optional. A user-friendly description of this model.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Optional. A user-friendly description of this model.
   * @param description description or {@code null} for none
   */
  public Model setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Custom encryption configuration (e.g., Cloud KMS keys). This shows the encryption configuration
   * of the model data while stored in BigQuery storage. This field can be used with PatchModel to
   * update encryption key for an already encrypted model.
   * @return value or {@code null} for none
   */
  public EncryptionConfiguration getEncryptionConfiguration() {
    return encryptionConfiguration;
  }

  /**
   * Custom encryption configuration (e.g., Cloud KMS keys). This shows the encryption configuration
   * of the model data while stored in BigQuery storage. This field can be used with PatchModel to
   * update encryption key for an already encrypted model.
   * @param encryptionConfiguration encryptionConfiguration or {@code null} for none
   */
  public Model setEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
    this.encryptionConfiguration = encryptionConfiguration;
    return this;
  }

  /**
   * Output only. A hash of this resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Output only. A hash of this resource.
   * @param etag etag or {@code null} for none
   */
  public Model setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Optional. The time when this model expires, in milliseconds since the epoch. If not present,
   * the model will persist indefinitely. Expired models will be deleted and their storage
   * reclaimed. The defaultTableExpirationMs property of the encapsulating dataset can be used to
   * set a default expirationTime on newly created models.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpirationTime() {
    return expirationTime;
  }

  /**
   * Optional. The time when this model expires, in milliseconds since the epoch. If not present,
   * the model will persist indefinitely. Expired models will be deleted and their storage
   * reclaimed. The defaultTableExpirationMs property of the encapsulating dataset can be used to
   * set a default expirationTime on newly created models.
   * @param expirationTime expirationTime or {@code null} for none
   */
  public Model setExpirationTime(java.lang.Long expirationTime) {
    this.expirationTime = expirationTime;
    return this;
  }

  /**
   * Output only. Input feature columns for the model inference. If the model is trained with
   * TRANSFORM clause, these are the input of the TRANSFORM clause.
   * @return value or {@code null} for none
   */
  public java.util.List<StandardSqlField> getFeatureColumns() {
    return featureColumns;
  }

  /**
   * Output only. Input feature columns for the model inference. If the model is trained with
   * TRANSFORM clause, these are the input of the TRANSFORM clause.
   * @param featureColumns featureColumns or {@code null} for none
   */
  public Model setFeatureColumns(java.util.List<StandardSqlField> featureColumns) {
    this.featureColumns = featureColumns;
    return this;
  }

  /**
   * Optional. A descriptive name for this model.
   * @return value or {@code null} for none
   */
  public java.lang.String getFriendlyName() {
    return friendlyName;
  }

  /**
   * Optional. A descriptive name for this model.
   * @param friendlyName friendlyName or {@code null} for none
   */
  public Model setFriendlyName(java.lang.String friendlyName) {
    this.friendlyName = friendlyName;
    return this;
  }

  /**
   * Output only. All hyperparameter search spaces in this model.
   * @return value or {@code null} for none
   */
  public HparamSearchSpaces getHparamSearchSpaces() {
    return hparamSearchSpaces;
  }

  /**
   * Output only. All hyperparameter search spaces in this model.
   * @param hparamSearchSpaces hparamSearchSpaces or {@code null} for none
   */
  public Model setHparamSearchSpaces(HparamSearchSpaces hparamSearchSpaces) {
    this.hparamSearchSpaces = hparamSearchSpaces;
    return this;
  }

  /**
   * Output only. Trials of a [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) model sorted by trial_id.
   * @return value or {@code null} for none
   */
  public java.util.List<HparamTuningTrial> getHparamTrials() {
    return hparamTrials;
  }

  /**
   * Output only. Trials of a [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) model sorted by trial_id.
   * @param hparamTrials hparamTrials or {@code null} for none
   */
  public Model setHparamTrials(java.util.List<HparamTuningTrial> hparamTrials) {
    this.hparamTrials = hparamTrials;
    return this;
  }

  /**
   * Output only. Label columns that were used to train this model. The output of the model will
   * have a "predicted_" prefix to these columns.
   * @return value or {@code null} for none
   */
  public java.util.List<StandardSqlField> getLabelColumns() {
    return labelColumns;
  }

  /**
   * Output only. Label columns that were used to train this model. The output of the model will
   * have a "predicted_" prefix to these columns.
   * @param labelColumns labelColumns or {@code null} for none
   */
  public Model setLabelColumns(java.util.List<StandardSqlField> labelColumns) {
    this.labelColumns = labelColumns;
    return this;
  }

  /**
   * The labels associated with this model. You can use these to organize and group your models.
   * Label keys and values can be no longer than 63 characters, can only contain lowercase letters,
   * numeric characters, underscores and dashes. International characters are allowed. Label values
   * are optional. Label keys must start with a letter and each label in the list must have a
   * different key.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * The labels associated with this model. You can use these to organize and group your models.
   * Label keys and values can be no longer than 63 characters, can only contain lowercase letters,
   * numeric characters, underscores and dashes. International characters are allowed. Label values
   * are optional. Label keys must start with a letter and each label in the list must have a
   * different key.
   * @param labels labels or {@code null} for none
   */
  public Model setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Output only. The time when this model was last modified, in millisecs since the epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * Output only. The time when this model was last modified, in millisecs since the epoch.
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public Model setLastModifiedTime(java.lang.Long lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * Output only. The geographic location where the model resides. This value is inherited from the
   * dataset.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * Output only. The geographic location where the model resides. This value is inherited from the
   * dataset.
   * @param location location or {@code null} for none
   */
  public Model setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * Required. Unique identifier for this model.
   * @return value or {@code null} for none
   */
  public ModelReference getModelReference() {
    return modelReference;
  }

  /**
   * Required. Unique identifier for this model.
   * @param modelReference modelReference or {@code null} for none
   */
  public Model setModelReference(ModelReference modelReference) {
    this.modelReference = modelReference;
    return this;
  }

  /**
   * Output only. Type of the model resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getModelType() {
    return modelType;
  }

  /**
   * Output only. Type of the model resource.
   * @param modelType modelType or {@code null} for none
   */
  public Model setModelType(java.lang.String modelType) {
    this.modelType = modelType;
    return this;
  }

  /**
   * Output only. For single-objective [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, it only contains
   * the best trial. For multi-objective [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, it contains all
   * Pareto optimal trials sorted by trial_id.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getOptimalTrialIds() {
    return optimalTrialIds;
  }

  /**
   * Output only. For single-objective [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, it only contains
   * the best trial. For multi-objective [hyperparameter tuning](https://cloud.google.com/bigquery-
   * ml/docs/reference/standard-sql/bigqueryml-syntax-hp-tuning-overview) models, it contains all
   * Pareto optimal trials sorted by trial_id.
   * @param optimalTrialIds optimalTrialIds or {@code null} for none
   */
  public Model setOptimalTrialIds(java.util.List<java.lang.Long> optimalTrialIds) {
    this.optimalTrialIds = optimalTrialIds;
    return this;
  }

  /**
   * Output only. Remote model info
   * @return value or {@code null} for none
   */
  public RemoteModelInfo getRemoteModelInfo() {
    return remoteModelInfo;
  }

  /**
   * Output only. Remote model info
   * @param remoteModelInfo remoteModelInfo or {@code null} for none
   */
  public Model setRemoteModelInfo(RemoteModelInfo remoteModelInfo) {
    this.remoteModelInfo = remoteModelInfo;
    return this;
  }

  /**
   * Information for all training runs in increasing order of start_time.
   * @return value or {@code null} for none
   */
  public java.util.List<TrainingRun> getTrainingRuns() {
    return trainingRuns;
  }

  /**
   * Information for all training runs in increasing order of start_time.
   * @param trainingRuns trainingRuns or {@code null} for none
   */
  public Model setTrainingRuns(java.util.List<TrainingRun> trainingRuns) {
    this.trainingRuns = trainingRuns;
    return this;
  }

  /**
   * Output only. This field will be populated if a TRANSFORM clause was used to train a model.
   * TRANSFORM clause (if used) takes feature_columns as input and outputs transform_columns.
   * transform_columns then are used to train the model.
   * @return value or {@code null} for none
   */
  public java.util.List<TransformColumn> getTransformColumns() {
    return transformColumns;
  }

  /**
   * Output only. This field will be populated if a TRANSFORM clause was used to train a model.
   * TRANSFORM clause (if used) takes feature_columns as input and outputs transform_columns.
   * transform_columns then are used to train the model.
   * @param transformColumns transformColumns or {@code null} for none
   */
  public Model setTransformColumns(java.util.List<TransformColumn> transformColumns) {
    this.transformColumns = transformColumns;
    return this;
  }

  @Override
  public Model set(String fieldName, Object value) {
    return (Model) super.set(fieldName, value);
  }

  @Override
  public Model clone() {
    return (Model) super.clone();
  }

}
