/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Represents a BigQuery dataset.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Dataset extends com.google.api.client.json.GenericJson {

  /**
   * Optional. An array of objects that define dataset access for one or more entities. You can set
   * this property when inserting or updating a dataset in order to control who is allowed to access
   * the data. If unspecified at dataset creation time, BigQuery adds default dataset access for the
   * following entities: access.specialGroup: projectReaders; access.role: READER;
   * access.specialGroup: projectWriters; access.role: WRITER; access.specialGroup: projectOwners;
   * access.role: OWNER; access.userByEmail: [dataset creator email]; access.role: OWNER; If you
   * patch a dataset, then this field is overwritten by the patched dataset's access field. To add
   * entities, you must supply the entire existing access array in addition to any new entities that
   * you want to add.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Access> access;

  static {
    // hack to force ProGuard to consider Access used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Access.class);
  }

  /**
   * Output only. The time when this dataset was created, in milliseconds since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long creationTime;

  /**
   * Required. A reference that identifies the dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DatasetReference datasetReference;

  /**
   * Optional. Defines the default collation specification of future tables created in the dataset.
   * If a table is created in this dataset without table-level default collation, then the table
   * inherits the dataset default collation, which is applied to the string fields that do not have
   * explicit collation specified. A change to this field affects only tables created afterwards,
   * and does not alter the existing tables. The following values are supported: * 'und:ci':
   * undetermined locale, case insensitive. * '': empty string. Default to case-sensitive behavior.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultCollation;

  /**
   * The default encryption key for all tables in the dataset. After this property is set, the
   * encryption key of all newly-created tables in the dataset is set to this value unless the table
   * creation request or query explicitly overrides the key.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EncryptionConfiguration defaultEncryptionConfiguration;

  /**
   * This default partition expiration, expressed in milliseconds. When new time-partitioned tables
   * are created in a dataset where this property is set, the table will inherit this value,
   * propagated as the `TimePartitioning.expirationMs` property on the new table. If you set
   * `TimePartitioning.expirationMs` explicitly when creating a table, the
   * `defaultPartitionExpirationMs` of the containing dataset is ignored. When creating a
   * partitioned table, if `defaultPartitionExpirationMs` is set, the `defaultTableExpirationMs`
   * value is ignored and the table will not be inherit a table expiration deadline.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long defaultPartitionExpirationMs;

  /**
   * Optional. Defines the default rounding mode specification of new tables created within this
   * dataset. During table creation, if this field is specified, the table within this dataset will
   * inherit the default rounding mode of the dataset. Setting the default rounding mode on a table
   * overrides this option. Existing tables in the dataset are unaffected. If columns are defined
   * during that table creation, they will immediately inherit the table's default rounding mode,
   * unless otherwise specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultRoundingMode;

  /**
   * Optional. The default lifetime of all tables in the dataset, in milliseconds. The minimum
   * lifetime value is 3600000 milliseconds (one hour). To clear an existing default expiration with
   * a PATCH request, set to 0. Once this property is set, all newly-created tables in the dataset
   * will have an expirationTime property set to the creation time plus the value in this property,
   * and changing the value will only affect new tables, not existing ones. When the expirationTime
   * for a given table is reached, that table will be deleted automatically. If a table's
   * expirationTime is modified or removed before the table expires, or if you provide an explicit
   * expirationTime when creating a table, that value takes precedence over the default expiration
   * time indicated by this property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long defaultTableExpirationMs;

  /**
   * Optional. A user-friendly description of the dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Output only. A hash of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Optional. Options defining open source compatible datasets living in the BigQuery catalog.
   * Contains metadata of open source database, schema or namespace represented by the current
   * dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ExternalCatalogDatasetOptions externalCatalogDatasetOptions;

  /**
   * Optional. Reference to a read-only external dataset defined in data catalogs outside of
   * BigQuery. Filled out when the dataset type is EXTERNAL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ExternalDatasetReference externalDatasetReference;

  /**
   * Optional. A descriptive name for the dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String friendlyName;

  /**
   * Output only. The fully-qualified unique name of the dataset in the format projectId:datasetId.
   * The dataset name without the project name is given in the datasetId field. When creating a new
   * dataset, leave this field blank, and instead specify the datasetId field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Optional. TRUE if the dataset and its table names are case-insensitive, otherwise FALSE. By
   * default, this is FALSE, which means the dataset and its table names are case-sensitive. This
   * field does not affect routine references.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isCaseInsensitive;

  /**
   * Output only. The resource type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The labels associated with this dataset. You can use these to organize and group your datasets.
   * You can set this property when inserting or updating a dataset. See [Creating and Updating
   * Dataset Labels](https://cloud.google.com/bigquery/docs/creating-managing-
   * labels#creating_and_updating_dataset_labels) for more information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Output only. The date when this dataset was last modified, in milliseconds since the epoch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long lastModifiedTime;

  /**
   * Output only. Metadata about the LinkedDataset. Filled out when the dataset type is LINKED.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LinkedDatasetMetadata linkedDatasetMetadata;

  /**
   * Optional. The source dataset reference when the dataset is of type LINKED. For all other
   * dataset types it is not set. This field cannot be updated once it is set. Any attempt to update
   * this field using Update and Patch API Operations will be ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LinkedDatasetSource linkedDatasetSource;

  /**
   * The geographic location where the dataset should reside. See
   * https://cloud.google.com/bigquery/docs/locations for supported locations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * Optional. Defines the time travel window in hours. The value can be from 48 to 168 hours (2 to
   * 7 days). The default value is 168 hours if this is not set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxTimeTravelHours;

  /**
   * Optional. The [tags](https://cloud.google.com/bigquery/docs/tags) attached to this dataset. Tag
   * keys are globally unique. Tag key is expected to be in the namespaced format, for example
   * "123456789012/environment" where 123456789012 is the ID of the parent organization or project
   * resource for this tag key. Tag value is expected to be the short name, for example
   * "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-
   * control#definitions) for more details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> resourceTags;

  /**
   * Optional. Output only. Restriction config for all tables and dataset. If set, restrict certain
   * accesses on the dataset and all its tables based on the config. See [Data
   * egress](https://cloud.google.com/bigquery/docs/analytics-hub-introduction#data_egress) for more
   * details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RestrictionConfig restrictions;

  /**
   * Output only. Reserved for future use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean satisfiesPzi;

  /**
   * Output only. Reserved for future use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean satisfiesPzs;

  /**
   * Output only. A URL that can be used to access the resource again. You can use this URL in Get
   * or Update requests to the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Optional. Updates storage_billing_model for the dataset.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String storageBillingModel;

  /**
   * Output only. Tags for the dataset. To provide tags as inputs, use the `resourceTags` field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Tags> tags;

  static {
    // hack to force ProGuard to consider Tags used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Tags.class);
  }

  /**
   * Output only. Same as `type` in `ListFormatDataset`. The type of the dataset, one of: * DEFAULT
   * - only accessible by owner and authorized accounts, * PUBLIC - accessible by everyone, * LINKED
   * - linked dataset, * EXTERNAL - dataset with definition in external metadata catalog.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Optional. An array of objects that define dataset access for one or more entities. You can set
   * this property when inserting or updating a dataset in order to control who is allowed to access
   * the data. If unspecified at dataset creation time, BigQuery adds default dataset access for the
   * following entities: access.specialGroup: projectReaders; access.role: READER;
   * access.specialGroup: projectWriters; access.role: WRITER; access.specialGroup: projectOwners;
   * access.role: OWNER; access.userByEmail: [dataset creator email]; access.role: OWNER; If you
   * patch a dataset, then this field is overwritten by the patched dataset's access field. To add
   * entities, you must supply the entire existing access array in addition to any new entities that
   * you want to add.
   * @return value or {@code null} for none
   */
  public java.util.List<Access> getAccess() {
    return access;
  }

  /**
   * Optional. An array of objects that define dataset access for one or more entities. You can set
   * this property when inserting or updating a dataset in order to control who is allowed to access
   * the data. If unspecified at dataset creation time, BigQuery adds default dataset access for the
   * following entities: access.specialGroup: projectReaders; access.role: READER;
   * access.specialGroup: projectWriters; access.role: WRITER; access.specialGroup: projectOwners;
   * access.role: OWNER; access.userByEmail: [dataset creator email]; access.role: OWNER; If you
   * patch a dataset, then this field is overwritten by the patched dataset's access field. To add
   * entities, you must supply the entire existing access array in addition to any new entities that
   * you want to add.
   * @param access access or {@code null} for none
   */
  public Dataset setAccess(java.util.List<Access> access) {
    this.access = access;
    return this;
  }

  /**
   * Output only. The time when this dataset was created, in milliseconds since the epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCreationTime() {
    return creationTime;
  }

  /**
   * Output only. The time when this dataset was created, in milliseconds since the epoch.
   * @param creationTime creationTime or {@code null} for none
   */
  public Dataset setCreationTime(java.lang.Long creationTime) {
    this.creationTime = creationTime;
    return this;
  }

  /**
   * Required. A reference that identifies the dataset.
   * @return value or {@code null} for none
   */
  public DatasetReference getDatasetReference() {
    return datasetReference;
  }

  /**
   * Required. A reference that identifies the dataset.
   * @param datasetReference datasetReference or {@code null} for none
   */
  public Dataset setDatasetReference(DatasetReference datasetReference) {
    this.datasetReference = datasetReference;
    return this;
  }

  /**
   * Optional. Defines the default collation specification of future tables created in the dataset.
   * If a table is created in this dataset without table-level default collation, then the table
   * inherits the dataset default collation, which is applied to the string fields that do not have
   * explicit collation specified. A change to this field affects only tables created afterwards,
   * and does not alter the existing tables. The following values are supported: * 'und:ci':
   * undetermined locale, case insensitive. * '': empty string. Default to case-sensitive behavior.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultCollation() {
    return defaultCollation;
  }

  /**
   * Optional. Defines the default collation specification of future tables created in the dataset.
   * If a table is created in this dataset without table-level default collation, then the table
   * inherits the dataset default collation, which is applied to the string fields that do not have
   * explicit collation specified. A change to this field affects only tables created afterwards,
   * and does not alter the existing tables. The following values are supported: * 'und:ci':
   * undetermined locale, case insensitive. * '': empty string. Default to case-sensitive behavior.
   * @param defaultCollation defaultCollation or {@code null} for none
   */
  public Dataset setDefaultCollation(java.lang.String defaultCollation) {
    this.defaultCollation = defaultCollation;
    return this;
  }

  /**
   * The default encryption key for all tables in the dataset. After this property is set, the
   * encryption key of all newly-created tables in the dataset is set to this value unless the table
   * creation request or query explicitly overrides the key.
   * @return value or {@code null} for none
   */
  public EncryptionConfiguration getDefaultEncryptionConfiguration() {
    return defaultEncryptionConfiguration;
  }

  /**
   * The default encryption key for all tables in the dataset. After this property is set, the
   * encryption key of all newly-created tables in the dataset is set to this value unless the table
   * creation request or query explicitly overrides the key.
   * @param defaultEncryptionConfiguration defaultEncryptionConfiguration or {@code null} for none
   */
  public Dataset setDefaultEncryptionConfiguration(EncryptionConfiguration defaultEncryptionConfiguration) {
    this.defaultEncryptionConfiguration = defaultEncryptionConfiguration;
    return this;
  }

  /**
   * This default partition expiration, expressed in milliseconds. When new time-partitioned tables
   * are created in a dataset where this property is set, the table will inherit this value,
   * propagated as the `TimePartitioning.expirationMs` property on the new table. If you set
   * `TimePartitioning.expirationMs` explicitly when creating a table, the
   * `defaultPartitionExpirationMs` of the containing dataset is ignored. When creating a
   * partitioned table, if `defaultPartitionExpirationMs` is set, the `defaultTableExpirationMs`
   * value is ignored and the table will not be inherit a table expiration deadline.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDefaultPartitionExpirationMs() {
    return defaultPartitionExpirationMs;
  }

  /**
   * This default partition expiration, expressed in milliseconds. When new time-partitioned tables
   * are created in a dataset where this property is set, the table will inherit this value,
   * propagated as the `TimePartitioning.expirationMs` property on the new table. If you set
   * `TimePartitioning.expirationMs` explicitly when creating a table, the
   * `defaultPartitionExpirationMs` of the containing dataset is ignored. When creating a
   * partitioned table, if `defaultPartitionExpirationMs` is set, the `defaultTableExpirationMs`
   * value is ignored and the table will not be inherit a table expiration deadline.
   * @param defaultPartitionExpirationMs defaultPartitionExpirationMs or {@code null} for none
   */
  public Dataset setDefaultPartitionExpirationMs(java.lang.Long defaultPartitionExpirationMs) {
    this.defaultPartitionExpirationMs = defaultPartitionExpirationMs;
    return this;
  }

  /**
   * Optional. Defines the default rounding mode specification of new tables created within this
   * dataset. During table creation, if this field is specified, the table within this dataset will
   * inherit the default rounding mode of the dataset. Setting the default rounding mode on a table
   * overrides this option. Existing tables in the dataset are unaffected. If columns are defined
   * during that table creation, they will immediately inherit the table's default rounding mode,
   * unless otherwise specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultRoundingMode() {
    return defaultRoundingMode;
  }

  /**
   * Optional. Defines the default rounding mode specification of new tables created within this
   * dataset. During table creation, if this field is specified, the table within this dataset will
   * inherit the default rounding mode of the dataset. Setting the default rounding mode on a table
   * overrides this option. Existing tables in the dataset are unaffected. If columns are defined
   * during that table creation, they will immediately inherit the table's default rounding mode,
   * unless otherwise specified.
   * @param defaultRoundingMode defaultRoundingMode or {@code null} for none
   */
  public Dataset setDefaultRoundingMode(java.lang.String defaultRoundingMode) {
    this.defaultRoundingMode = defaultRoundingMode;
    return this;
  }

  /**
   * Optional. The default lifetime of all tables in the dataset, in milliseconds. The minimum
   * lifetime value is 3600000 milliseconds (one hour). To clear an existing default expiration with
   * a PATCH request, set to 0. Once this property is set, all newly-created tables in the dataset
   * will have an expirationTime property set to the creation time plus the value in this property,
   * and changing the value will only affect new tables, not existing ones. When the expirationTime
   * for a given table is reached, that table will be deleted automatically. If a table's
   * expirationTime is modified or removed before the table expires, or if you provide an explicit
   * expirationTime when creating a table, that value takes precedence over the default expiration
   * time indicated by this property.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDefaultTableExpirationMs() {
    return defaultTableExpirationMs;
  }

  /**
   * Optional. The default lifetime of all tables in the dataset, in milliseconds. The minimum
   * lifetime value is 3600000 milliseconds (one hour). To clear an existing default expiration with
   * a PATCH request, set to 0. Once this property is set, all newly-created tables in the dataset
   * will have an expirationTime property set to the creation time plus the value in this property,
   * and changing the value will only affect new tables, not existing ones. When the expirationTime
   * for a given table is reached, that table will be deleted automatically. If a table's
   * expirationTime is modified or removed before the table expires, or if you provide an explicit
   * expirationTime when creating a table, that value takes precedence over the default expiration
   * time indicated by this property.
   * @param defaultTableExpirationMs defaultTableExpirationMs or {@code null} for none
   */
  public Dataset setDefaultTableExpirationMs(java.lang.Long defaultTableExpirationMs) {
    this.defaultTableExpirationMs = defaultTableExpirationMs;
    return this;
  }

  /**
   * Optional. A user-friendly description of the dataset.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Optional. A user-friendly description of the dataset.
   * @param description description or {@code null} for none
   */
  public Dataset setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Output only. A hash of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * Output only. A hash of the resource.
   * @param etag etag or {@code null} for none
   */
  public Dataset setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Optional. Options defining open source compatible datasets living in the BigQuery catalog.
   * Contains metadata of open source database, schema or namespace represented by the current
   * dataset.
   * @return value or {@code null} for none
   */
  public ExternalCatalogDatasetOptions getExternalCatalogDatasetOptions() {
    return externalCatalogDatasetOptions;
  }

  /**
   * Optional. Options defining open source compatible datasets living in the BigQuery catalog.
   * Contains metadata of open source database, schema or namespace represented by the current
   * dataset.
   * @param externalCatalogDatasetOptions externalCatalogDatasetOptions or {@code null} for none
   */
  public Dataset setExternalCatalogDatasetOptions(ExternalCatalogDatasetOptions externalCatalogDatasetOptions) {
    this.externalCatalogDatasetOptions = externalCatalogDatasetOptions;
    return this;
  }

  /**
   * Optional. Reference to a read-only external dataset defined in data catalogs outside of
   * BigQuery. Filled out when the dataset type is EXTERNAL.
   * @return value or {@code null} for none
   */
  public ExternalDatasetReference getExternalDatasetReference() {
    return externalDatasetReference;
  }

  /**
   * Optional. Reference to a read-only external dataset defined in data catalogs outside of
   * BigQuery. Filled out when the dataset type is EXTERNAL.
   * @param externalDatasetReference externalDatasetReference or {@code null} for none
   */
  public Dataset setExternalDatasetReference(ExternalDatasetReference externalDatasetReference) {
    this.externalDatasetReference = externalDatasetReference;
    return this;
  }

  /**
   * Optional. A descriptive name for the dataset.
   * @return value or {@code null} for none
   */
  public java.lang.String getFriendlyName() {
    return friendlyName;
  }

  /**
   * Optional. A descriptive name for the dataset.
   * @param friendlyName friendlyName or {@code null} for none
   */
  public Dataset setFriendlyName(java.lang.String friendlyName) {
    this.friendlyName = friendlyName;
    return this;
  }

  /**
   * Output only. The fully-qualified unique name of the dataset in the format projectId:datasetId.
   * The dataset name without the project name is given in the datasetId field. When creating a new
   * dataset, leave this field blank, and instead specify the datasetId field.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Output only. The fully-qualified unique name of the dataset in the format projectId:datasetId.
   * The dataset name without the project name is given in the datasetId field. When creating a new
   * dataset, leave this field blank, and instead specify the datasetId field.
   * @param id id or {@code null} for none
   */
  public Dataset setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Optional. TRUE if the dataset and its table names are case-insensitive, otherwise FALSE. By
   * default, this is FALSE, which means the dataset and its table names are case-sensitive. This
   * field does not affect routine references.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsCaseInsensitive() {
    return isCaseInsensitive;
  }

  /**
   * Optional. TRUE if the dataset and its table names are case-insensitive, otherwise FALSE. By
   * default, this is FALSE, which means the dataset and its table names are case-sensitive. This
   * field does not affect routine references.
   * @param isCaseInsensitive isCaseInsensitive or {@code null} for none
   */
  public Dataset setIsCaseInsensitive(java.lang.Boolean isCaseInsensitive) {
    this.isCaseInsensitive = isCaseInsensitive;
    return this;
  }

  /**
   * Output only. The resource type.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Output only. The resource type.
   * @param kind kind or {@code null} for none
   */
  public Dataset setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The labels associated with this dataset. You can use these to organize and group your datasets.
   * You can set this property when inserting or updating a dataset. See [Creating and Updating
   * Dataset Labels](https://cloud.google.com/bigquery/docs/creating-managing-
   * labels#creating_and_updating_dataset_labels) for more information.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * The labels associated with this dataset. You can use these to organize and group your datasets.
   * You can set this property when inserting or updating a dataset. See [Creating and Updating
   * Dataset Labels](https://cloud.google.com/bigquery/docs/creating-managing-
   * labels#creating_and_updating_dataset_labels) for more information.
   * @param labels labels or {@code null} for none
   */
  public Dataset setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Output only. The date when this dataset was last modified, in milliseconds since the epoch.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLastModifiedTime() {
    return lastModifiedTime;
  }

  /**
   * Output only. The date when this dataset was last modified, in milliseconds since the epoch.
   * @param lastModifiedTime lastModifiedTime or {@code null} for none
   */
  public Dataset setLastModifiedTime(java.lang.Long lastModifiedTime) {
    this.lastModifiedTime = lastModifiedTime;
    return this;
  }

  /**
   * Output only. Metadata about the LinkedDataset. Filled out when the dataset type is LINKED.
   * @return value or {@code null} for none
   */
  public LinkedDatasetMetadata getLinkedDatasetMetadata() {
    return linkedDatasetMetadata;
  }

  /**
   * Output only. Metadata about the LinkedDataset. Filled out when the dataset type is LINKED.
   * @param linkedDatasetMetadata linkedDatasetMetadata or {@code null} for none
   */
  public Dataset setLinkedDatasetMetadata(LinkedDatasetMetadata linkedDatasetMetadata) {
    this.linkedDatasetMetadata = linkedDatasetMetadata;
    return this;
  }

  /**
   * Optional. The source dataset reference when the dataset is of type LINKED. For all other
   * dataset types it is not set. This field cannot be updated once it is set. Any attempt to update
   * this field using Update and Patch API Operations will be ignored.
   * @return value or {@code null} for none
   */
  public LinkedDatasetSource getLinkedDatasetSource() {
    return linkedDatasetSource;
  }

  /**
   * Optional. The source dataset reference when the dataset is of type LINKED. For all other
   * dataset types it is not set. This field cannot be updated once it is set. Any attempt to update
   * this field using Update and Patch API Operations will be ignored.
   * @param linkedDatasetSource linkedDatasetSource or {@code null} for none
   */
  public Dataset setLinkedDatasetSource(LinkedDatasetSource linkedDatasetSource) {
    this.linkedDatasetSource = linkedDatasetSource;
    return this;
  }

  /**
   * The geographic location where the dataset should reside. See
   * https://cloud.google.com/bigquery/docs/locations for supported locations.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * The geographic location where the dataset should reside. See
   * https://cloud.google.com/bigquery/docs/locations for supported locations.
   * @param location location or {@code null} for none
   */
  public Dataset setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * Optional. Defines the time travel window in hours. The value can be from 48 to 168 hours (2 to
   * 7 days). The default value is 168 hours if this is not set.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxTimeTravelHours() {
    return maxTimeTravelHours;
  }

  /**
   * Optional. Defines the time travel window in hours. The value can be from 48 to 168 hours (2 to
   * 7 days). The default value is 168 hours if this is not set.
   * @param maxTimeTravelHours maxTimeTravelHours or {@code null} for none
   */
  public Dataset setMaxTimeTravelHours(java.lang.Long maxTimeTravelHours) {
    this.maxTimeTravelHours = maxTimeTravelHours;
    return this;
  }

  /**
   * Optional. The [tags](https://cloud.google.com/bigquery/docs/tags) attached to this dataset. Tag
   * keys are globally unique. Tag key is expected to be in the namespaced format, for example
   * "123456789012/environment" where 123456789012 is the ID of the parent organization or project
   * resource for this tag key. Tag value is expected to be the short name, for example
   * "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-
   * control#definitions) for more details.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getResourceTags() {
    return resourceTags;
  }

  /**
   * Optional. The [tags](https://cloud.google.com/bigquery/docs/tags) attached to this dataset. Tag
   * keys are globally unique. Tag key is expected to be in the namespaced format, for example
   * "123456789012/environment" where 123456789012 is the ID of the parent organization or project
   * resource for this tag key. Tag value is expected to be the short name, for example
   * "Production". See [Tag definitions](https://cloud.google.com/iam/docs/tags-access-
   * control#definitions) for more details.
   * @param resourceTags resourceTags or {@code null} for none
   */
  public Dataset setResourceTags(java.util.Map<String, java.lang.String> resourceTags) {
    this.resourceTags = resourceTags;
    return this;
  }

  /**
   * Optional. Output only. Restriction config for all tables and dataset. If set, restrict certain
   * accesses on the dataset and all its tables based on the config. See [Data
   * egress](https://cloud.google.com/bigquery/docs/analytics-hub-introduction#data_egress) for more
   * details.
   * @return value or {@code null} for none
   */
  public RestrictionConfig getRestrictions() {
    return restrictions;
  }

  /**
   * Optional. Output only. Restriction config for all tables and dataset. If set, restrict certain
   * accesses on the dataset and all its tables based on the config. See [Data
   * egress](https://cloud.google.com/bigquery/docs/analytics-hub-introduction#data_egress) for more
   * details.
   * @param restrictions restrictions or {@code null} for none
   */
  public Dataset setRestrictions(RestrictionConfig restrictions) {
    this.restrictions = restrictions;
    return this;
  }

  /**
   * Output only. Reserved for future use.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSatisfiesPzi() {
    return satisfiesPzi;
  }

  /**
   * Output only. Reserved for future use.
   * @param satisfiesPzi satisfiesPzi or {@code null} for none
   */
  public Dataset setSatisfiesPzi(java.lang.Boolean satisfiesPzi) {
    this.satisfiesPzi = satisfiesPzi;
    return this;
  }

  /**
   * Output only. Reserved for future use.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSatisfiesPzs() {
    return satisfiesPzs;
  }

  /**
   * Output only. Reserved for future use.
   * @param satisfiesPzs satisfiesPzs or {@code null} for none
   */
  public Dataset setSatisfiesPzs(java.lang.Boolean satisfiesPzs) {
    this.satisfiesPzs = satisfiesPzs;
    return this;
  }

  /**
   * Output only. A URL that can be used to access the resource again. You can use this URL in Get
   * or Update requests to the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Output only. A URL that can be used to access the resource again. You can use this URL in Get
   * or Update requests to the resource.
   * @param selfLink selfLink or {@code null} for none
   */
  public Dataset setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Optional. Updates storage_billing_model for the dataset.
   * @return value or {@code null} for none
   */
  public java.lang.String getStorageBillingModel() {
    return storageBillingModel;
  }

  /**
   * Optional. Updates storage_billing_model for the dataset.
   * @param storageBillingModel storageBillingModel or {@code null} for none
   */
  public Dataset setStorageBillingModel(java.lang.String storageBillingModel) {
    this.storageBillingModel = storageBillingModel;
    return this;
  }

  /**
   * Output only. Tags for the dataset. To provide tags as inputs, use the `resourceTags` field.
   * @return value or {@code null} for none
   */
  public java.util.List<Tags> getTags() {
    return tags;
  }

  /**
   * Output only. Tags for the dataset. To provide tags as inputs, use the `resourceTags` field.
   * @param tags tags or {@code null} for none
   */
  public Dataset setTags(java.util.List<Tags> tags) {
    this.tags = tags;
    return this;
  }

  /**
   * Output only. Same as `type` in `ListFormatDataset`. The type of the dataset, one of: * DEFAULT
   * - only accessible by owner and authorized accounts, * PUBLIC - accessible by everyone, * LINKED
   * - linked dataset, * EXTERNAL - dataset with definition in external metadata catalog.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Output only. Same as `type` in `ListFormatDataset`. The type of the dataset, one of: * DEFAULT
   * - only accessible by owner and authorized accounts, * PUBLIC - accessible by everyone, * LINKED
   * - linked dataset, * EXTERNAL - dataset with definition in external metadata catalog.
   * @param type type or {@code null} for none
   */
  public Dataset setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Dataset set(String fieldName, Object value) {
    return (Dataset) super.set(fieldName, value);
  }

  @Override
  public Dataset clone() {
    return (Dataset) super.clone();
  }

  /**
   * An object that defines dataset access for an entity.
   */
  public static final class Access extends com.google.api.client.json.GenericJson {

    /**
     * Optional. condition for the binding. If CEL expression in this field is true, this access
     * binding will be considered
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Expr condition;

    /**
     * [Pick one] A grant authorizing all resources of a particular type in a particular dataset
     * access to this dataset. Only views are supported for now. The role field is not required when
     * this field is set. If that dataset is deleted and re-created, its access needs to be granted
     * again via an update operation.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private DatasetAccessEntry dataset;

    /**
     * [Pick one] A domain to grant access to. Any users signed in with the domain specified will be
     * granted the specified access. Example: "example.com". Maps to IAM policy member
     * "domain:DOMAIN".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String domain;

    /**
     * [Pick one] An email address of a Google Group to grant access to. Maps to IAM policy member
     * "group:GROUP".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String groupByEmail;

    /**
     * [Pick one] Some other type of member that appears in the IAM Policy but isn't a user, group,
     * domain, or special group.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String iamMember;

    /**
     * An IAM role ID that should be granted to the user, group, or domain specified in this access
     * entry. The following legacy mappings will be applied: * `OWNER`: `roles/bigquery.dataOwner` *
     * `WRITER`: `roles/bigquery.dataEditor` * `READER`: `roles/bigquery.dataViewer` This field will
     * accept any of the above formats, but will return only the legacy format. For example, if you
     * set this field to "roles/bigquery.dataOwner", it will be returned back as "OWNER".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String role;

    /**
     * [Pick one] A routine from a different dataset to grant access to. Queries executed against that
     * routine will have read access to views/tables/routines in this dataset. Only UDF is supported
     * for now. The role field is not required when this field is set. If that routine is updated by
     * any user, access to the routine needs to be granted again via an update operation.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private RoutineReference routine;

    /**
     * [Pick one] A special group to grant access to. Possible values include: * projectOwners: Owners
     * of the enclosing project. * projectReaders: Readers of the enclosing project. * projectWriters:
     * Writers of the enclosing project. * allAuthenticatedUsers: All authenticated BigQuery users.
     * Maps to similarly-named IAM members.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String specialGroup;

    /**
     * [Pick one] An email address of a user to grant access to. For example: fred@example.com. Maps
     * to IAM policy member "user:EMAIL" or "serviceAccount:EMAIL".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String userByEmail;

    /**
     * [Pick one] A view from a different dataset to grant access to. Queries executed against that
     * view will have read access to views/tables/routines in this dataset. The role field is not
     * required when this field is set. If that view is updated by any user, access to the view needs
     * to be granted again via an update operation.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private TableReference view;

    /**
     * Optional. condition for the binding. If CEL expression in this field is true, this access
     * binding will be considered
     * @return value or {@code null} for none
     */
    public Expr getCondition() {
      return condition;
    }

    /**
     * Optional. condition for the binding. If CEL expression in this field is true, this access
     * binding will be considered
     * @param condition condition or {@code null} for none
     */
    public Access setCondition(Expr condition) {
      this.condition = condition;
      return this;
    }

    /**
     * [Pick one] A grant authorizing all resources of a particular type in a particular dataset
     * access to this dataset. Only views are supported for now. The role field is not required when
     * this field is set. If that dataset is deleted and re-created, its access needs to be granted
     * again via an update operation.
     * @return value or {@code null} for none
     */
    public DatasetAccessEntry getDataset() {
      return dataset;
    }

    /**
     * [Pick one] A grant authorizing all resources of a particular type in a particular dataset
     * access to this dataset. Only views are supported for now. The role field is not required when
     * this field is set. If that dataset is deleted and re-created, its access needs to be granted
     * again via an update operation.
     * @param dataset dataset or {@code null} for none
     */
    public Access setDataset(DatasetAccessEntry dataset) {
      this.dataset = dataset;
      return this;
    }

    /**
     * [Pick one] A domain to grant access to. Any users signed in with the domain specified will be
     * granted the specified access. Example: "example.com". Maps to IAM policy member
     * "domain:DOMAIN".
     * @return value or {@code null} for none
     */
    public java.lang.String getDomain() {
      return domain;
    }

    /**
     * [Pick one] A domain to grant access to. Any users signed in with the domain specified will be
     * granted the specified access. Example: "example.com". Maps to IAM policy member
     * "domain:DOMAIN".
     * @param domain domain or {@code null} for none
     */
    public Access setDomain(java.lang.String domain) {
      this.domain = domain;
      return this;
    }

    /**
     * [Pick one] An email address of a Google Group to grant access to. Maps to IAM policy member
     * "group:GROUP".
     * @return value or {@code null} for none
     */
    public java.lang.String getGroupByEmail() {
      return groupByEmail;
    }

    /**
     * [Pick one] An email address of a Google Group to grant access to. Maps to IAM policy member
     * "group:GROUP".
     * @param groupByEmail groupByEmail or {@code null} for none
     */
    public Access setGroupByEmail(java.lang.String groupByEmail) {
      this.groupByEmail = groupByEmail;
      return this;
    }

    /**
     * [Pick one] Some other type of member that appears in the IAM Policy but isn't a user, group,
     * domain, or special group.
     * @return value or {@code null} for none
     */
    public java.lang.String getIamMember() {
      return iamMember;
    }

    /**
     * [Pick one] Some other type of member that appears in the IAM Policy but isn't a user, group,
     * domain, or special group.
     * @param iamMember iamMember or {@code null} for none
     */
    public Access setIamMember(java.lang.String iamMember) {
      this.iamMember = iamMember;
      return this;
    }

    /**
     * An IAM role ID that should be granted to the user, group, or domain specified in this access
     * entry. The following legacy mappings will be applied: * `OWNER`: `roles/bigquery.dataOwner` *
     * `WRITER`: `roles/bigquery.dataEditor` * `READER`: `roles/bigquery.dataViewer` This field will
     * accept any of the above formats, but will return only the legacy format. For example, if you
     * set this field to "roles/bigquery.dataOwner", it will be returned back as "OWNER".
     * @return value or {@code null} for none
     */
    public java.lang.String getRole() {
      return role;
    }

    /**
     * An IAM role ID that should be granted to the user, group, or domain specified in this access
     * entry. The following legacy mappings will be applied: * `OWNER`: `roles/bigquery.dataOwner` *
     * `WRITER`: `roles/bigquery.dataEditor` * `READER`: `roles/bigquery.dataViewer` This field will
     * accept any of the above formats, but will return only the legacy format. For example, if you
     * set this field to "roles/bigquery.dataOwner", it will be returned back as "OWNER".
     * @param role role or {@code null} for none
     */
    public Access setRole(java.lang.String role) {
      this.role = role;
      return this;
    }

    /**
     * [Pick one] A routine from a different dataset to grant access to. Queries executed against that
     * routine will have read access to views/tables/routines in this dataset. Only UDF is supported
     * for now. The role field is not required when this field is set. If that routine is updated by
     * any user, access to the routine needs to be granted again via an update operation.
     * @return value or {@code null} for none
     */
    public RoutineReference getRoutine() {
      return routine;
    }

    /**
     * [Pick one] A routine from a different dataset to grant access to. Queries executed against that
     * routine will have read access to views/tables/routines in this dataset. Only UDF is supported
     * for now. The role field is not required when this field is set. If that routine is updated by
     * any user, access to the routine needs to be granted again via an update operation.
     * @param routine routine or {@code null} for none
     */
    public Access setRoutine(RoutineReference routine) {
      this.routine = routine;
      return this;
    }

    /**
     * [Pick one] A special group to grant access to. Possible values include: * projectOwners: Owners
     * of the enclosing project. * projectReaders: Readers of the enclosing project. * projectWriters:
     * Writers of the enclosing project. * allAuthenticatedUsers: All authenticated BigQuery users.
     * Maps to similarly-named IAM members.
     * @return value or {@code null} for none
     */
    public java.lang.String getSpecialGroup() {
      return specialGroup;
    }

    /**
     * [Pick one] A special group to grant access to. Possible values include: * projectOwners: Owners
     * of the enclosing project. * projectReaders: Readers of the enclosing project. * projectWriters:
     * Writers of the enclosing project. * allAuthenticatedUsers: All authenticated BigQuery users.
     * Maps to similarly-named IAM members.
     * @param specialGroup specialGroup or {@code null} for none
     */
    public Access setSpecialGroup(java.lang.String specialGroup) {
      this.specialGroup = specialGroup;
      return this;
    }

    /**
     * [Pick one] An email address of a user to grant access to. For example: fred@example.com. Maps
     * to IAM policy member "user:EMAIL" or "serviceAccount:EMAIL".
     * @return value or {@code null} for none
     */
    public java.lang.String getUserByEmail() {
      return userByEmail;
    }

    /**
     * [Pick one] An email address of a user to grant access to. For example: fred@example.com. Maps
     * to IAM policy member "user:EMAIL" or "serviceAccount:EMAIL".
     * @param userByEmail userByEmail or {@code null} for none
     */
    public Access setUserByEmail(java.lang.String userByEmail) {
      this.userByEmail = userByEmail;
      return this;
    }

    /**
     * [Pick one] A view from a different dataset to grant access to. Queries executed against that
     * view will have read access to views/tables/routines in this dataset. The role field is not
     * required when this field is set. If that view is updated by any user, access to the view needs
     * to be granted again via an update operation.
     * @return value or {@code null} for none
     */
    public TableReference getView() {
      return view;
    }

    /**
     * [Pick one] A view from a different dataset to grant access to. Queries executed against that
     * view will have read access to views/tables/routines in this dataset. The role field is not
     * required when this field is set. If that view is updated by any user, access to the view needs
     * to be granted again via an update operation.
     * @param view view or {@code null} for none
     */
    public Access setView(TableReference view) {
      this.view = view;
      return this;
    }

    @Override
    public Access set(String fieldName, Object value) {
      return (Access) super.set(fieldName, value);
    }

    @Override
    public Access clone() {
      return (Access) super.clone();
    }

  }

  /**
   * A global tag managed by Resource Manager. https://cloud.google.com/iam/docs/tags-access-
   * control#definitions
   */
  public static final class Tags extends com.google.api.client.json.GenericJson {

    /**
     * Required. The namespaced friendly name of the tag key, e.g. "12345/environment" where 12345 is
     * org id.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String tagKey;

    /**
     * Required. The friendly short name of the tag value, e.g. "production".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String tagValue;

    /**
     * Required. The namespaced friendly name of the tag key, e.g. "12345/environment" where 12345 is
     * org id.
     * @return value or {@code null} for none
     */
    public java.lang.String getTagKey() {
      return tagKey;
    }

    /**
     * Required. The namespaced friendly name of the tag key, e.g. "12345/environment" where 12345 is
     * org id.
     * @param tagKey tagKey or {@code null} for none
     */
    public Tags setTagKey(java.lang.String tagKey) {
      this.tagKey = tagKey;
      return this;
    }

    /**
     * Required. The friendly short name of the tag value, e.g. "production".
     * @return value or {@code null} for none
     */
    public java.lang.String getTagValue() {
      return tagValue;
    }

    /**
     * Required. The friendly short name of the tag value, e.g. "production".
     * @param tagValue tagValue or {@code null} for none
     */
    public Tags setTagValue(java.lang.String tagValue) {
      this.tagValue = tagValue;
      return this;
    }

    @Override
    public Tags set(String fieldName, Object value) {
      return (Tags) super.set(fieldName, value);
    }

    @Override
    public Tags clone() {
      return (Tags) super.clone();
    }

  }

}
