/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Statistics of materialized views considered in a query job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MaterializedViewStatistics extends com.google.api.client.json.GenericJson {

  /**
   * Materialized views considered for the query job. Only certain materialized views are used. For
   * a detailed list, see the child message. If many materialized views are considered, then the
   * list might be incomplete.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MaterializedView> materializedView;

  static {
    // hack to force ProGuard to consider MaterializedView used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MaterializedView.class);
  }

  /**
   * Materialized views considered for the query job. Only certain materialized views are used. For
   * a detailed list, see the child message. If many materialized views are considered, then the
   * list might be incomplete.
   * @return value or {@code null} for none
   */
  public java.util.List<MaterializedView> getMaterializedView() {
    return materializedView;
  }

  /**
   * Materialized views considered for the query job. Only certain materialized views are used. For
   * a detailed list, see the child message. If many materialized views are considered, then the
   * list might be incomplete.
   * @param materializedView materializedView or {@code null} for none
   */
  public MaterializedViewStatistics setMaterializedView(java.util.List<MaterializedView> materializedView) {
    this.materializedView = materializedView;
    return this;
  }

  @Override
  public MaterializedViewStatistics set(String fieldName, Object value) {
    return (MaterializedViewStatistics) super.set(fieldName, value);
  }

  @Override
  public MaterializedViewStatistics clone() {
    return (MaterializedViewStatistics) super.clone();
  }

}
