/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery;

/**
 * Service definition for Bigquery (v2).
 *
 * <p>
 * A data platform for customers to create, manage, share and query data.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/bigquery/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link BigqueryRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Bigquery extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        (com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1))) ||
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION >= 2,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "2.0.0 of the BigQuery API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://bigquery.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://bigquery.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "bigquery/v2/";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch/bigquery/v2";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Bigquery(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Bigquery(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Datasets collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Datasets.List request = bigquery.datasets().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Datasets datasets() {
    return new Datasets();
  }

  /**
   * The "datasets" collection of methods.
   */
  public class Datasets {

    /**
     * Deletes the dataset specified by the datasetId value. Before you can delete a dataset, you must
     * delete all its tables, either manually or by specifying deleteContents. Immediately after
     * deletion, you can create another dataset with the same name.
     *
     * Create a request for the method "datasets.delete".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the dataset being deleted
     * @param datasetId Required. Dataset ID of dataset being deleted
     * @return the request
     */
    public Delete delete(java.lang.String projectId, java.lang.String datasetId) throws java.io.IOException {
      Delete result = new Delete(projectId, datasetId);
      initialize(result);
      return result;
    }

    public class Delete extends BigqueryRequest<Void> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Deletes the dataset specified by the datasetId value. Before you can delete a dataset, you must
       * delete all its tables, either manually or by specifying deleteContents. Immediately after
       * deletion, you can create another dataset with the same name.
       *
       * Create a request for the method "datasets.delete".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the dataset being deleted
       * @param datasetId Required. Dataset ID of dataset being deleted
       * @since 1.13
       */
      protected Delete(java.lang.String projectId, java.lang.String datasetId) {
        super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the dataset being deleted */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the dataset being deleted
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the dataset being deleted */
      public Delete setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of dataset being deleted */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of dataset being deleted
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of dataset being deleted */
      public Delete setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /**
       * If True, delete all the tables in the dataset. If False and the dataset contains tables,
       * the request will fail. Default is False
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean deleteContents;

      /** If True, delete all the tables in the dataset. If False and the dataset contains tables, the
     request will fail. Default is False
       */
      public java.lang.Boolean getDeleteContents() {
        return deleteContents;
      }

      /**
       * If True, delete all the tables in the dataset. If False and the dataset contains tables,
       * the request will fail. Default is False
       */
      public Delete setDeleteContents(java.lang.Boolean deleteContents) {
        this.deleteContents = deleteContents;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns the dataset specified by datasetID.
     *
     * Create a request for the method "datasets.get".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the requested dataset
     * @param datasetId Required. Dataset ID of the requested dataset
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String datasetId) throws java.io.IOException {
      Get result = new Get(projectId, datasetId);
      initialize(result);
      return result;
    }

    public class Get extends BigqueryRequest<com.google.api.services.bigquery.model.Dataset> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Returns the dataset specified by datasetID.
       *
       * Create a request for the method "datasets.get".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the requested dataset
       * @param datasetId Required. Dataset ID of the requested dataset
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String datasetId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.Dataset.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the requested dataset */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the requested dataset
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the requested dataset */
      public Get setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the requested dataset */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the requested dataset
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the requested dataset */
      public Get setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /**
       * Optional. Specifies the view that determines which dataset information is returned. By
       * default, metadata and ACL information are returned.
       */
      @com.google.api.client.util.Key
      private java.lang.String datasetView;

      /** Optional. Specifies the view that determines which dataset information is returned. By default,
     metadata and ACL information are returned.
       */
      public java.lang.String getDatasetView() {
        return datasetView;
      }

      /**
       * Optional. Specifies the view that determines which dataset information is returned. By
       * default, metadata and ACL information are returned.
       */
      public Get setDatasetView(java.lang.String datasetView) {
        this.datasetView = datasetView;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new empty dataset.
     *
     * Create a request for the method "datasets.insert".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the new dataset
     * @param content the {@link com.google.api.services.bigquery.model.Dataset}
     * @return the request
     */
    public Insert insert(java.lang.String projectId, com.google.api.services.bigquery.model.Dataset content) throws java.io.IOException {
      Insert result = new Insert(projectId, content);
      initialize(result);
      return result;
    }

    public class Insert extends BigqueryRequest<com.google.api.services.bigquery.model.Dataset> {

      private static final String REST_PATH = "projects/{+projectId}/datasets";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Creates a new empty dataset.
       *
       * Create a request for the method "datasets.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the new dataset
       * @param content the {@link com.google.api.services.bigquery.model.Dataset}
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, com.google.api.services.bigquery.model.Dataset content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Dataset.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the new dataset */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the new dataset
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the new dataset */
      public Insert setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all datasets in the specified project to which the user has been granted the READER dataset
     * role.
     *
     * Create a request for the method "datasets.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the datasets to be listed
     * @return the request
     */
    public List list(java.lang.String projectId) throws java.io.IOException {
      List result = new List(projectId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.DatasetList> {

      private static final String REST_PATH = "projects/{+projectId}/datasets";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Lists all datasets in the specified project to which the user has been granted the READER
       * dataset role.
       *
       * Create a request for the method "datasets.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the datasets to be listed
       * @since 1.13
       */
      protected List(java.lang.String projectId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.DatasetList.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the datasets to be listed */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the datasets to be listed
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the datasets to be listed */
      public List setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Whether to list all datasets, including hidden ones */
      @com.google.api.client.util.Key
      private java.lang.Boolean all;

      /** Whether to list all datasets, including hidden ones
       */
      public java.lang.Boolean getAll() {
        return all;
      }

      /** Whether to list all datasets, including hidden ones */
      public List setAll(java.lang.Boolean all) {
        this.all = all;
        return this;
      }

      /**
       * An expression for filtering the results of the request by label. The syntax is
       * \"labels.[:]\". Multiple filters can be ANDed together by connecting with a space. Example:
       * \"labels.department:receiving labels.active\". See [Filtering datasets using
       * labels](/bigquery/docs/labeling-datasets#filtering_datasets_using_labels) for details.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** An expression for filtering the results of the request by label. The syntax is \"labels.[:]\".
     Multiple filters can be ANDed together by connecting with a space. Example:
     \"labels.department:receiving labels.active\". See [Filtering datasets using labels](/bigquery/docs
     /labeling-datasets#filtering_datasets_using_labels) for details.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * An expression for filtering the results of the request by label. The syntax is
       * \"labels.[:]\". Multiple filters can be ANDed together by connecting with a space. Example:
       * \"labels.department:receiving labels.active\". See [Filtering datasets using
       * labels](/bigquery/docs/labeling-datasets#filtering_datasets_using_labels) for details.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results to return in a single response page. Leverage the page tokens to
     iterate through the entire collection.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing dataset. The update method replaces the entire dataset
     * resource, whereas the patch method only replaces fields that are provided in the submitted
     * dataset resource. This method supports RFC5789 patch semantics.
     *
     * Create a request for the method "datasets.patch".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the dataset being updated
     * @param datasetId Required. Dataset ID of the dataset being updated
     * @param content the {@link com.google.api.services.bigquery.model.Dataset}
     * @return the request
     */
    public Patch patch(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Dataset content) throws java.io.IOException {
      Patch result = new Patch(projectId, datasetId, content);
      initialize(result);
      return result;
    }

    public class Patch extends BigqueryRequest<com.google.api.services.bigquery.model.Dataset> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Updates information in an existing dataset. The update method replaces the entire dataset
       * resource, whereas the patch method only replaces fields that are provided in the submitted
       * dataset resource. This method supports RFC5789 patch semantics.
       *
       * Create a request for the method "datasets.patch".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the dataset being updated
       * @param datasetId Required. Dataset ID of the dataset being updated
       * @param content the {@link com.google.api.services.bigquery.model.Dataset}
       * @since 1.13
       */
      protected Patch(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Dataset content) {
        super(Bigquery.this, "PATCH", REST_PATH, content, com.google.api.services.bigquery.model.Dataset.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the dataset being updated */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the dataset being updated
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the dataset being updated */
      public Patch setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the dataset being updated */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the dataset being updated
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the dataset being updated */
      public Patch setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Undeletes a dataset which is within time travel window based on datasetId. If a time is
     * specified, the dataset version deleted at that time is undeleted, else the last live version is
     * undeleted.
     *
     * Create a request for the method "datasets.undelete".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Undelete#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the dataset to be undeleted
     * @param datasetId Required. Dataset ID of dataset being deleted
     * @param content the {@link com.google.api.services.bigquery.model.UndeleteDatasetRequest}
     * @return the request
     */
    public Undelete undelete(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.UndeleteDatasetRequest content) throws java.io.IOException {
      Undelete result = new Undelete(projectId, datasetId, content);
      initialize(result);
      return result;
    }

    public class Undelete extends BigqueryRequest<com.google.api.services.bigquery.model.Dataset> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}:undelete";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Undeletes a dataset which is within time travel window based on datasetId. If a time is
       * specified, the dataset version deleted at that time is undeleted, else the last live version is
       * undeleted.
       *
       * Create a request for the method "datasets.undelete".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Undelete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Undelete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the dataset to be undeleted
       * @param datasetId Required. Dataset ID of dataset being deleted
       * @param content the {@link com.google.api.services.bigquery.model.UndeleteDatasetRequest}
       * @since 1.13
       */
      protected Undelete(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.UndeleteDatasetRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Dataset.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Undelete set$Xgafv(java.lang.String $Xgafv) {
        return (Undelete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Undelete setAccessToken(java.lang.String accessToken) {
        return (Undelete) super.setAccessToken(accessToken);
      }

      @Override
      public Undelete setAlt(java.lang.String alt) {
        return (Undelete) super.setAlt(alt);
      }

      @Override
      public Undelete setCallback(java.lang.String callback) {
        return (Undelete) super.setCallback(callback);
      }

      @Override
      public Undelete setFields(java.lang.String fields) {
        return (Undelete) super.setFields(fields);
      }

      @Override
      public Undelete setKey(java.lang.String key) {
        return (Undelete) super.setKey(key);
      }

      @Override
      public Undelete setOauthToken(java.lang.String oauthToken) {
        return (Undelete) super.setOauthToken(oauthToken);
      }

      @Override
      public Undelete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Undelete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Undelete setQuotaUser(java.lang.String quotaUser) {
        return (Undelete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Undelete setUploadType(java.lang.String uploadType) {
        return (Undelete) super.setUploadType(uploadType);
      }

      @Override
      public Undelete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Undelete) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the dataset to be undeleted */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the dataset to be undeleted
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the dataset to be undeleted */
      public Undelete setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of dataset being deleted */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of dataset being deleted
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of dataset being deleted */
      public Undelete setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Undelete set(String parameterName, Object value) {
        return (Undelete) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing dataset. The update method replaces the entire dataset
     * resource, whereas the patch method only replaces fields that are provided in the submitted
     * dataset resource.
     *
     * Create a request for the method "datasets.update".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the dataset being updated
     * @param datasetId Required. Dataset ID of the dataset being updated
     * @param content the {@link com.google.api.services.bigquery.model.Dataset}
     * @return the request
     */
    public Update update(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Dataset content) throws java.io.IOException {
      Update result = new Update(projectId, datasetId, content);
      initialize(result);
      return result;
    }

    public class Update extends BigqueryRequest<com.google.api.services.bigquery.model.Dataset> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Updates information in an existing dataset. The update method replaces the entire dataset
       * resource, whereas the patch method only replaces fields that are provided in the submitted
       * dataset resource.
       *
       * Create a request for the method "datasets.update".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the dataset being updated
       * @param datasetId Required. Dataset ID of the dataset being updated
       * @param content the {@link com.google.api.services.bigquery.model.Dataset}
       * @since 1.13
       */
      protected Update(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Dataset content) {
        super(Bigquery.this, "PUT", REST_PATH, content, com.google.api.services.bigquery.model.Dataset.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the dataset being updated */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the dataset being updated
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the dataset being updated */
      public Update setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the dataset being updated */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the dataset being updated
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the dataset being updated */
      public Update setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Jobs collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Jobs.List request = bigquery.jobs().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Jobs jobs() {
    return new Jobs();
  }

  /**
   * The "jobs" collection of methods.
   */
  public class Jobs {

    /**
     * Requests that a job be cancelled. This call will return immediately, and the client will need to
     * poll for the job status to see if the cancel completed successfully. Cancelled jobs may still
     * incur costs.
     *
     * Create a request for the method "jobs.cancel".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the job to cancel
     * @param jobId Required. Job ID of the job to cancel
     * @return the request
     */
    public Cancel cancel(java.lang.String projectId, java.lang.String jobId) throws java.io.IOException {
      Cancel result = new Cancel(projectId, jobId);
      initialize(result);
      return result;
    }

    public class Cancel extends BigqueryRequest<com.google.api.services.bigquery.model.JobCancelResponse> {

      private static final String REST_PATH = "projects/{+projectId}/jobs/{+jobId}/cancel";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern JOB_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Requests that a job be cancelled. This call will return immediately, and the client will need
       * to poll for the job status to see if the cancel completed successfully. Cancelled jobs may
       * still incur costs.
       *
       * Create a request for the method "jobs.cancel".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
       * <p> {@link
       * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the job to cancel
       * @param jobId Required. Job ID of the job to cancel
       * @since 1.13
       */
      protected Cancel(java.lang.String projectId, java.lang.String jobId) {
        super(Bigquery.this, "POST", REST_PATH, null, com.google.api.services.bigquery.model.JobCancelResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_ID_PATTERN.matcher(jobId).matches(),
              "Parameter jobId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Cancel set$Xgafv(java.lang.String $Xgafv) {
        return (Cancel) super.set$Xgafv($Xgafv);
      }

      @Override
      public Cancel setAccessToken(java.lang.String accessToken) {
        return (Cancel) super.setAccessToken(accessToken);
      }

      @Override
      public Cancel setAlt(java.lang.String alt) {
        return (Cancel) super.setAlt(alt);
      }

      @Override
      public Cancel setCallback(java.lang.String callback) {
        return (Cancel) super.setCallback(callback);
      }

      @Override
      public Cancel setFields(java.lang.String fields) {
        return (Cancel) super.setFields(fields);
      }

      @Override
      public Cancel setKey(java.lang.String key) {
        return (Cancel) super.setKey(key);
      }

      @Override
      public Cancel setOauthToken(java.lang.String oauthToken) {
        return (Cancel) super.setOauthToken(oauthToken);
      }

      @Override
      public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Cancel) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Cancel setQuotaUser(java.lang.String quotaUser) {
        return (Cancel) super.setQuotaUser(quotaUser);
      }

      @Override
      public Cancel setUploadType(java.lang.String uploadType) {
        return (Cancel) super.setUploadType(uploadType);
      }

      @Override
      public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
        return (Cancel) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the job to cancel */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the job to cancel
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the job to cancel */
      public Cancel setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Job ID of the job to cancel */
      @com.google.api.client.util.Key
      private java.lang.String jobId;

      /** Required. Job ID of the job to cancel
       */
      public java.lang.String getJobId() {
        return jobId;
      }

      /** Required. Job ID of the job to cancel */
      public Cancel setJobId(java.lang.String jobId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_ID_PATTERN.matcher(jobId).matches(),
              "Parameter jobId must conform to the pattern " +
              "^[^/]+$");
        }
        this.jobId = jobId;
        return this;
      }

      /**
       * The geographic location of the job. You must specify the location to run the job for the
       * following scenarios: - If the location to run a job is not in the `us` or the `eu` multi-
       * regional location - If the job's location is in a single region (for example, `us-
       * central1`) For more information, see
       * https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /** The geographic location of the job. You must specify the location to run the job for the following
     scenarios: - If the location to run a job is not in the `us` or the `eu` multi-regional location -
     If the job's location is in a single region (for example, `us-central1`) For more information, see
     https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public java.lang.String getLocation() {
        return location;
      }

      /**
       * The geographic location of the job. You must specify the location to run the job for the
       * following scenarios: - If the location to run a job is not in the `us` or the `eu` multi-
       * regional location - If the job's location is in a single region (for example, `us-
       * central1`) For more information, see
       * https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public Cancel setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      @Override
      public Cancel set(String parameterName, Object value) {
        return (Cancel) super.set(parameterName, value);
      }
    }
    /**
     * Requests the deletion of the metadata of a job. This call returns when the job's metadata is
     * deleted.
     *
     * Create a request for the method "jobs.delete".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the job for which metadata is to be deleted.
     * @param jobId Required. Job ID of the job for which metadata is to be deleted. If this is a parent job which has
     *        child jobs, the metadata from all child jobs will be deleted as well. Direct deletion of
     *        the metadata of child jobs is not allowed.
     * @return the request
     */
    public Delete delete(java.lang.String projectId, java.lang.String jobId) throws java.io.IOException {
      Delete result = new Delete(projectId, jobId);
      initialize(result);
      return result;
    }

    public class Delete extends BigqueryRequest<Void> {

      private static final String REST_PATH = "projects/{+projectId}/jobs/{+jobId}/delete";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern JOB_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Requests the deletion of the metadata of a job. This call returns when the job's metadata is
       * deleted.
       *
       * Create a request for the method "jobs.delete".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the job for which metadata is to be deleted.
       * @param jobId Required. Job ID of the job for which metadata is to be deleted. If this is a parent job which has
     *        child jobs, the metadata from all child jobs will be deleted as well. Direct deletion of
     *        the metadata of child jobs is not allowed.
       * @since 1.13
       */
      protected Delete(java.lang.String projectId, java.lang.String jobId) {
        super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_ID_PATTERN.matcher(jobId).matches(),
              "Parameter jobId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the job for which metadata is to be deleted. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the job for which metadata is to be deleted.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the job for which metadata is to be deleted. */
      public Delete setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /**
       * Required. Job ID of the job for which metadata is to be deleted. If this is a parent job
       * which has child jobs, the metadata from all child jobs will be deleted as well. Direct
       * deletion of the metadata of child jobs is not allowed.
       */
      @com.google.api.client.util.Key
      private java.lang.String jobId;

      /** Required. Job ID of the job for which metadata is to be deleted. If this is a parent job which has
     child jobs, the metadata from all child jobs will be deleted as well. Direct deletion of the
     metadata of child jobs is not allowed.
       */
      public java.lang.String getJobId() {
        return jobId;
      }

      /**
       * Required. Job ID of the job for which metadata is to be deleted. If this is a parent job
       * which has child jobs, the metadata from all child jobs will be deleted as well. Direct
       * deletion of the metadata of child jobs is not allowed.
       */
      public Delete setJobId(java.lang.String jobId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_ID_PATTERN.matcher(jobId).matches(),
              "Parameter jobId must conform to the pattern " +
              "^[^/]+$");
        }
        this.jobId = jobId;
        return this;
      }

      /**
       * The geographic location of the job. Required. See details at:
       * https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /** The geographic location of the job. Required. See details at:
     https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public java.lang.String getLocation() {
        return location;
      }

      /**
       * The geographic location of the job. Required. See details at:
       * https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public Delete setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Returns information about a specific job. Job information is available for a six month period
     * after creation. Requires that you're the person who ran the job, or have the Is Owner project
     * role.
     *
     * Create a request for the method "jobs.get".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the requested job.
     * @param jobId Required. Job ID of the requested job.
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String jobId) throws java.io.IOException {
      Get result = new Get(projectId, jobId);
      initialize(result);
      return result;
    }

    public class Get extends BigqueryRequest<com.google.api.services.bigquery.model.Job> {

      private static final String REST_PATH = "projects/{+projectId}/jobs/{+jobId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern JOB_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Returns information about a specific job. Job information is available for a six month period
       * after creation. Requires that you're the person who ran the job, or have the Is Owner project
       * role.
       *
       * Create a request for the method "jobs.get".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the requested job.
       * @param jobId Required. Job ID of the requested job.
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String jobId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.Job.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_ID_PATTERN.matcher(jobId).matches(),
              "Parameter jobId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the requested job. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the requested job.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the requested job. */
      public Get setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Job ID of the requested job. */
      @com.google.api.client.util.Key
      private java.lang.String jobId;

      /** Required. Job ID of the requested job.
       */
      public java.lang.String getJobId() {
        return jobId;
      }

      /** Required. Job ID of the requested job. */
      public Get setJobId(java.lang.String jobId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_ID_PATTERN.matcher(jobId).matches(),
              "Parameter jobId must conform to the pattern " +
              "^[^/]+$");
        }
        this.jobId = jobId;
        return this;
      }

      /**
       * The geographic location of the job. You must specify the location to run the job for the
       * following scenarios: - If the location to run a job is not in the `us` or the `eu` multi-
       * regional location - If the job's location is in a single region (for example, `us-
       * central1`) For more information, see
       * https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /** The geographic location of the job. You must specify the location to run the job for the following
     scenarios: - If the location to run a job is not in the `us` or the `eu` multi-regional location -
     If the job's location is in a single region (for example, `us-central1`) For more information, see
     https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public java.lang.String getLocation() {
        return location;
      }

      /**
       * The geographic location of the job. You must specify the location to run the job for the
       * following scenarios: - If the location to run a job is not in the `us` or the `eu` multi-
       * regional location - If the job's location is in a single region (for example, `us-
       * central1`) For more information, see
       * https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public Get setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * RPC to get the results of a query job.
     *
     * Create a request for the method "jobs.getQueryResults".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link GetQueryResults#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the query job.
     * @param jobId Required. Job ID of the query job.
     * @return the request
     */
    public GetQueryResults getQueryResults(java.lang.String projectId, java.lang.String jobId) throws java.io.IOException {
      GetQueryResults result = new GetQueryResults(projectId, jobId);
      initialize(result);
      return result;
    }

    public class GetQueryResults extends BigqueryRequest<com.google.api.services.bigquery.model.GetQueryResultsResponse> {

      private static final String REST_PATH = "projects/{+projectId}/queries/{+jobId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern JOB_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * RPC to get the results of a query job.
       *
       * Create a request for the method "jobs.getQueryResults".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link GetQueryResults#execute()} method to invoke the remote
       * operation. <p> {@link GetQueryResults#initialize(com.google.api.client.googleapis.services.Abst
       * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
       * the constructor. </p>
       *
       * @param projectId Required. Project ID of the query job.
       * @param jobId Required. Job ID of the query job.
       * @since 1.13
       */
      protected GetQueryResults(java.lang.String projectId, java.lang.String jobId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.GetQueryResultsResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.jobId = com.google.api.client.util.Preconditions.checkNotNull(jobId, "Required parameter jobId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_ID_PATTERN.matcher(jobId).matches(),
              "Parameter jobId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetQueryResults set$Xgafv(java.lang.String $Xgafv) {
        return (GetQueryResults) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetQueryResults setAccessToken(java.lang.String accessToken) {
        return (GetQueryResults) super.setAccessToken(accessToken);
      }

      @Override
      public GetQueryResults setAlt(java.lang.String alt) {
        return (GetQueryResults) super.setAlt(alt);
      }

      @Override
      public GetQueryResults setCallback(java.lang.String callback) {
        return (GetQueryResults) super.setCallback(callback);
      }

      @Override
      public GetQueryResults setFields(java.lang.String fields) {
        return (GetQueryResults) super.setFields(fields);
      }

      @Override
      public GetQueryResults setKey(java.lang.String key) {
        return (GetQueryResults) super.setKey(key);
      }

      @Override
      public GetQueryResults setOauthToken(java.lang.String oauthToken) {
        return (GetQueryResults) super.setOauthToken(oauthToken);
      }

      @Override
      public GetQueryResults setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetQueryResults) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetQueryResults setQuotaUser(java.lang.String quotaUser) {
        return (GetQueryResults) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetQueryResults setUploadType(java.lang.String uploadType) {
        return (GetQueryResults) super.setUploadType(uploadType);
      }

      @Override
      public GetQueryResults setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetQueryResults) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the query job. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the query job.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the query job. */
      public GetQueryResults setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Job ID of the query job. */
      @com.google.api.client.util.Key
      private java.lang.String jobId;

      /** Required. Job ID of the query job.
       */
      public java.lang.String getJobId() {
        return jobId;
      }

      /** Required. Job ID of the query job. */
      public GetQueryResults setJobId(java.lang.String jobId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(JOB_ID_PATTERN.matcher(jobId).matches(),
              "Parameter jobId must conform to the pattern " +
              "^[^/]+$");
        }
        this.jobId = jobId;
        return this;
      }

      /** Optional. Output timestamp as usec int64. Default is false. */
      @com.google.api.client.util.Key("formatOptions.useInt64Timestamp")
      private java.lang.Boolean formatOptionsUseInt64Timestamp;

      /** Optional. Output timestamp as usec int64. Default is false.
       */
      public java.lang.Boolean getFormatOptionsUseInt64Timestamp() {
        return formatOptionsUseInt64Timestamp;
      }

      /** Optional. Output timestamp as usec int64. Default is false. */
      public GetQueryResults setFormatOptionsUseInt64Timestamp(java.lang.Boolean formatOptionsUseInt64Timestamp) {
        this.formatOptionsUseInt64Timestamp = formatOptionsUseInt64Timestamp;
        return this;
      }

      /**
       * The geographic location of the job. You must specify the location to run the job for the
       * following scenarios: - If the location to run a job is not in the `us` or the `eu` multi-
       * regional location - If the job's location is in a single region (for example, `us-
       * central1`) For more information, see
       * https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      @com.google.api.client.util.Key
      private java.lang.String location;

      /** The geographic location of the job. You must specify the location to run the job for the following
     scenarios: - If the location to run a job is not in the `us` or the `eu` multi-regional location -
     If the job's location is in a single region (for example, `us-central1`) For more information, see
     https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public java.lang.String getLocation() {
        return location;
      }

      /**
       * The geographic location of the job. You must specify the location to run the job for the
       * following scenarios: - If the location to run a job is not in the `us` or the `eu` multi-
       * regional location - If the job's location is in a single region (for example, `us-
       * central1`) For more information, see
       * https://cloud.google.com/bigquery/docs/locations#specifying_your_location.
       */
      public GetQueryResults setLocation(java.lang.String location) {
        this.location = location;
        return this;
      }

      /** Maximum number of results to read. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Maximum number of results to read.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Maximum number of results to read. */
      public GetQueryResults setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results. */
      public GetQueryResults setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Zero-based index of the starting row. */
      @com.google.api.client.util.Key
      private java.math.BigInteger startIndex;

      /** Zero-based index of the starting row.
       */
      public java.math.BigInteger getStartIndex() {
        return startIndex;
      }

      /** Zero-based index of the starting row. */
      public GetQueryResults setStartIndex(java.math.BigInteger startIndex) {
        this.startIndex = startIndex;
        return this;
      }

      /**
       * Optional: Specifies the maximum amount of time, in milliseconds, that the client is willing
       * to wait for the query to complete. By default, this limit is 10 seconds (10,000
       * milliseconds). If the query is complete, the jobComplete field in the response is true. If
       * the query has not yet completed, jobComplete is false. You can request a longer timeout
       * period in the timeoutMs field. However, the call is not guaranteed to wait for the
       * specified timeout; it typically returns after around 200 seconds (200,000 milliseconds),
       * even if the query is not complete. If jobComplete is false, you can continue to wait for
       * the query to complete by calling the getQueryResults method until the jobComplete field in
       * the getQueryResults response is true.
       */
      @com.google.api.client.util.Key
      private java.lang.Long timeoutMs;

      /** Optional: Specifies the maximum amount of time, in milliseconds, that the client is willing to wait
     for the query to complete. By default, this limit is 10 seconds (10,000 milliseconds). If the query
     is complete, the jobComplete field in the response is true. If the query has not yet completed,
     jobComplete is false. You can request a longer timeout period in the timeoutMs field. However, the
     call is not guaranteed to wait for the specified timeout; it typically returns after around 200
     seconds (200,000 milliseconds), even if the query is not complete. If jobComplete is false, you can
     continue to wait for the query to complete by calling the getQueryResults method until the
     jobComplete field in the getQueryResults response is true.
       */
      public java.lang.Long getTimeoutMs() {
        return timeoutMs;
      }

      /**
       * Optional: Specifies the maximum amount of time, in milliseconds, that the client is willing
       * to wait for the query to complete. By default, this limit is 10 seconds (10,000
       * milliseconds). If the query is complete, the jobComplete field in the response is true. If
       * the query has not yet completed, jobComplete is false. You can request a longer timeout
       * period in the timeoutMs field. However, the call is not guaranteed to wait for the
       * specified timeout; it typically returns after around 200 seconds (200,000 milliseconds),
       * even if the query is not complete. If jobComplete is false, you can continue to wait for
       * the query to complete by calling the getQueryResults method until the jobComplete field in
       * the getQueryResults response is true.
       */
      public GetQueryResults setTimeoutMs(java.lang.Long timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
      }

      @Override
      public GetQueryResults set(String parameterName, Object value) {
        return (GetQueryResults) super.set(parameterName, value);
      }
    }
    /**
     * Starts a new asynchronous job. This API has two different kinds of endpoint URIs, as this method
     * supports a variety of use cases. * The *Metadata* URI is used for most interactions, as it
     * accepts the job configuration directly. * The *Upload* URI is ONLY for the case when you're
     * sending both a load job configuration and a data stream together. In this case, the Upload URI
     * accepts the job configuration and the data as two distinct multipart MIME parts.
     *
     * Create a request for the method "jobs.insert".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of project that will be billed for the job.
     * @param content the {@link com.google.api.services.bigquery.model.Job}
     * @return the request
     */
    public Insert insert(java.lang.String projectId, com.google.api.services.bigquery.model.Job content) throws java.io.IOException {
      Insert result = new Insert(projectId, content);
      initialize(result);
      return result;
    }

    /**
     * Starts a new asynchronous job. This API has two different kinds of endpoint URIs, as this method
     * supports a variety of use cases. * The *Metadata* URI is used for most interactions, as it
     * accepts the job configuration directly. * The *Upload* URI is ONLY for the case when you're
     * sending both a load job configuration and a data stream together. In this case, the Upload URI
     * accepts the job configuration and the data as two distinct multipart MIME parts.
     *
     * Create a request for the method "jobs.insert".
     *
     * This request holds the parameters needed by the the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param projectId Project ID of project that will be billed for the job.
     * @param content the {@link com.google.api.services.bigquery.model.Job} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Insert insert(java.lang.String projectId, com.google.api.services.bigquery.model.Job content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Insert result = new Insert(projectId, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Insert extends BigqueryRequest<com.google.api.services.bigquery.model.Job> {

      private static final String REST_PATH = "projects/{+projectId}/jobs";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Starts a new asynchronous job. This API has two different kinds of endpoint URIs, as this
       * method supports a variety of use cases. * The *Metadata* URI is used for most interactions, as
       * it accepts the job configuration directly. * The *Upload* URI is ONLY for the case when you're
       * sending both a load job configuration and a data stream together. In this case, the Upload URI
       * accepts the job configuration and the data as two distinct multipart MIME parts.
       *
       * Create a request for the method "jobs.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of project that will be billed for the job.
       * @param content the {@link com.google.api.services.bigquery.model.Job}
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, com.google.api.services.bigquery.model.Job content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Job.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      /**
       * Starts a new asynchronous job. This API has two different kinds of endpoint URIs, as this
       * method supports a variety of use cases. * The *Metadata* URI is used for most interactions, as
       * it accepts the job configuration directly. * The *Upload* URI is ONLY for the case when you're
       * sending both a load job configuration and a data stream together. In this case, the Upload URI
       * accepts the job configuration and the data as two distinct multipart MIME parts.
       *
       * Create a request for the method "jobs.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param projectId Project ID of project that will be billed for the job.
       * @param content the {@link com.google.api.services.bigquery.model.Job} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content.
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, com.google.api.services.bigquery.model.Job content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Bigquery.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.bigquery.model.Job.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        com.google.api.client.util.Preconditions.checkNotNull(mediaContent, "Required parameter mediaContent must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /** Project ID of project that will be billed for the job. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of project that will be billed for the job.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of project that will be billed for the job. */
      public Insert setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all jobs that you started in the specified project. Job information is available for a six
     * month period after creation. The job list is sorted in reverse chronological order, by job
     * creation time. Requires the Can View project role, or the Is Owner project role if you set the
     * allUsers property.
     *
     * Create a request for the method "jobs.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Project ID of the jobs to list.
     * @return the request
     */
    public List list(java.lang.String projectId) throws java.io.IOException {
      List result = new List(projectId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.JobList> {

      private static final String REST_PATH = "projects/{+projectId}/jobs";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Lists all jobs that you started in the specified project. Job information is available for a
       * six month period after creation. The job list is sorted in reverse chronological order, by job
       * creation time. Requires the Can View project role, or the Is Owner project role if you set the
       * allUsers property.
       *
       * Create a request for the method "jobs.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Project ID of the jobs to list.
       * @since 1.13
       */
      protected List(java.lang.String projectId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.JobList.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Project ID of the jobs to list. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Project ID of the jobs to list.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Project ID of the jobs to list. */
      public List setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Whether to display jobs owned by all users in the project. Default False. */
      @com.google.api.client.util.Key
      private java.lang.Boolean allUsers;

      /** Whether to display jobs owned by all users in the project. Default False.
       */
      public java.lang.Boolean getAllUsers() {
        return allUsers;
      }

      /** Whether to display jobs owned by all users in the project. Default False. */
      public List setAllUsers(java.lang.Boolean allUsers) {
        this.allUsers = allUsers;
        return this;
      }

      /**
       * Max value for job creation time, in milliseconds since the POSIX epoch. If set, only jobs
       * created before or at this timestamp are returned.
       */
      @com.google.api.client.util.Key
      private java.math.BigInteger maxCreationTime;

      /** Max value for job creation time, in milliseconds since the POSIX epoch. If set, only jobs created
     before or at this timestamp are returned.
       */
      public java.math.BigInteger getMaxCreationTime() {
        return maxCreationTime;
      }

      /**
       * Max value for job creation time, in milliseconds since the POSIX epoch. If set, only jobs
       * created before or at this timestamp are returned.
       */
      public List setMaxCreationTime(java.math.BigInteger maxCreationTime) {
        this.maxCreationTime = maxCreationTime;
        return this;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results to return in a single response page. Leverage the page tokens to
     iterate through the entire collection.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Min value for job creation time, in milliseconds since the POSIX epoch. If set, only jobs
       * created after or at this timestamp are returned.
       */
      @com.google.api.client.util.Key
      private java.math.BigInteger minCreationTime;

      /** Min value for job creation time, in milliseconds since the POSIX epoch. If set, only jobs created
     after or at this timestamp are returned.
       */
      public java.math.BigInteger getMinCreationTime() {
        return minCreationTime;
      }

      /**
       * Min value for job creation time, in milliseconds since the POSIX epoch. If set, only jobs
       * created after or at this timestamp are returned.
       */
      public List setMinCreationTime(java.math.BigInteger minCreationTime) {
        this.minCreationTime = minCreationTime;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * If set, show only child jobs of the specified parent. Otherwise, show all top-level jobs.
       */
      @com.google.api.client.util.Key
      private java.lang.String parentJobId;

      /** If set, show only child jobs of the specified parent. Otherwise, show all top-level jobs.
       */
      public java.lang.String getParentJobId() {
        return parentJobId;
      }

      /**
       * If set, show only child jobs of the specified parent. Otherwise, show all top-level jobs.
       */
      public List setParentJobId(java.lang.String parentJobId) {
        this.parentJobId = parentJobId;
        return this;
      }

      /** Restrict information returned to a set of selected fields */
      @com.google.api.client.util.Key
      private java.lang.String projection;

      /** Restrict information returned to a set of selected fields
       */
      public java.lang.String getProjection() {
        return projection;
      }

      /** Restrict information returned to a set of selected fields */
      public List setProjection(java.lang.String projection) {
        this.projection = projection;
        return this;
      }

      /** Filter for job state */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> stateFilter;

      /** Filter for job state
       */
      public java.util.List<java.lang.String> getStateFilter() {
        return stateFilter;
      }

      /** Filter for job state */
      public List setStateFilter(java.util.List<java.lang.String> stateFilter) {
        this.stateFilter = stateFilter;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Runs a BigQuery SQL query synchronously and returns query results if the query completes within a
     * specified timeout.
     *
     * Create a request for the method "jobs.query".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Query#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the query request.
     * @param content the {@link com.google.api.services.bigquery.model.QueryRequest}
     * @return the request
     */
    public Query query(java.lang.String projectId, com.google.api.services.bigquery.model.QueryRequest content) throws java.io.IOException {
      Query result = new Query(projectId, content);
      initialize(result);
      return result;
    }

    public class Query extends BigqueryRequest<com.google.api.services.bigquery.model.QueryResponse> {

      private static final String REST_PATH = "projects/{+projectId}/queries";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Runs a BigQuery SQL query synchronously and returns query results if the query completes within
       * a specified timeout.
       *
       * Create a request for the method "jobs.query".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Query#execute()} method to invoke the remote operation.
       * <p> {@link
       * Query#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the query request.
       * @param content the {@link com.google.api.services.bigquery.model.QueryRequest}
       * @since 1.13
       */
      protected Query(java.lang.String projectId, com.google.api.services.bigquery.model.QueryRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.QueryResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Query set$Xgafv(java.lang.String $Xgafv) {
        return (Query) super.set$Xgafv($Xgafv);
      }

      @Override
      public Query setAccessToken(java.lang.String accessToken) {
        return (Query) super.setAccessToken(accessToken);
      }

      @Override
      public Query setAlt(java.lang.String alt) {
        return (Query) super.setAlt(alt);
      }

      @Override
      public Query setCallback(java.lang.String callback) {
        return (Query) super.setCallback(callback);
      }

      @Override
      public Query setFields(java.lang.String fields) {
        return (Query) super.setFields(fields);
      }

      @Override
      public Query setKey(java.lang.String key) {
        return (Query) super.setKey(key);
      }

      @Override
      public Query setOauthToken(java.lang.String oauthToken) {
        return (Query) super.setOauthToken(oauthToken);
      }

      @Override
      public Query setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Query) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Query setQuotaUser(java.lang.String quotaUser) {
        return (Query) super.setQuotaUser(quotaUser);
      }

      @Override
      public Query setUploadType(java.lang.String uploadType) {
        return (Query) super.setUploadType(uploadType);
      }

      @Override
      public Query setUploadProtocol(java.lang.String uploadProtocol) {
        return (Query) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the query request. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the query request.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the query request. */
      public Query setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      @Override
      public Query set(String parameterName, Object value) {
        return (Query) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Models collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Models.List request = bigquery.models().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Models models() {
    return new Models();
  }

  /**
   * The "models" collection of methods.
   */
  public class Models {

    /**
     * Deletes the model specified by modelId from the dataset.
     *
     * Create a request for the method "models.delete".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the model to delete.
     * @param datasetId Required. Dataset ID of the model to delete.
     * @param modelId Required. Model ID of the model to delete.
     * @return the request
     */
    public Delete delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String modelId) throws java.io.IOException {
      Delete result = new Delete(projectId, datasetId, modelId);
      initialize(result);
      return result;
    }

    public class Delete extends BigqueryRequest<Void> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern MODEL_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Deletes the model specified by modelId from the dataset.
       *
       * Create a request for the method "models.delete".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the model to delete.
       * @param datasetId Required. Dataset ID of the model to delete.
       * @param modelId Required. Model ID of the model to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String modelId) {
        super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.modelId = com.google.api.client.util.Preconditions.checkNotNull(modelId, "Required parameter modelId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MODEL_ID_PATTERN.matcher(modelId).matches(),
              "Parameter modelId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the model to delete. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the model to delete.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the model to delete. */
      public Delete setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the model to delete. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the model to delete.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the model to delete. */
      public Delete setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Model ID of the model to delete. */
      @com.google.api.client.util.Key
      private java.lang.String modelId;

      /** Required. Model ID of the model to delete.
       */
      public java.lang.String getModelId() {
        return modelId;
      }

      /** Required. Model ID of the model to delete. */
      public Delete setModelId(java.lang.String modelId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MODEL_ID_PATTERN.matcher(modelId).matches(),
              "Parameter modelId must conform to the pattern " +
              "^[^/]+$");
        }
        this.modelId = modelId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets the specified model resource by model ID.
     *
     * Create a request for the method "models.get".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the requested model.
     * @param datasetId Required. Dataset ID of the requested model.
     * @param modelId Required. Model ID of the requested model.
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String datasetId, java.lang.String modelId) throws java.io.IOException {
      Get result = new Get(projectId, datasetId, modelId);
      initialize(result);
      return result;
    }

    public class Get extends BigqueryRequest<com.google.api.services.bigquery.model.Model> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern MODEL_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Gets the specified model resource by model ID.
       *
       * Create a request for the method "models.get".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the requested model.
       * @param datasetId Required. Dataset ID of the requested model.
       * @param modelId Required. Model ID of the requested model.
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String datasetId, java.lang.String modelId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.Model.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.modelId = com.google.api.client.util.Preconditions.checkNotNull(modelId, "Required parameter modelId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MODEL_ID_PATTERN.matcher(modelId).matches(),
              "Parameter modelId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the requested model. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the requested model.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the requested model. */
      public Get setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the requested model. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the requested model.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the requested model. */
      public Get setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Model ID of the requested model. */
      @com.google.api.client.util.Key
      private java.lang.String modelId;

      /** Required. Model ID of the requested model.
       */
      public java.lang.String getModelId() {
        return modelId;
      }

      /** Required. Model ID of the requested model. */
      public Get setModelId(java.lang.String modelId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MODEL_ID_PATTERN.matcher(modelId).matches(),
              "Parameter modelId must conform to the pattern " +
              "^[^/]+$");
        }
        this.modelId = modelId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists all models in the specified dataset. Requires the READER dataset role. After retrieving the
     * list of models, you can get information about a particular model by calling the models.get
     * method.
     *
     * Create a request for the method "models.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the models to list.
     * @param datasetId Required. Dataset ID of the models to list.
     * @return the request
     */
    public List list(java.lang.String projectId, java.lang.String datasetId) throws java.io.IOException {
      List result = new List(projectId, datasetId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.ListModelsResponse> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Lists all models in the specified dataset. Requires the READER dataset role. After retrieving
       * the list of models, you can get information about a particular model by calling the models.get
       * method.
       *
       * Create a request for the method "models.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the models to list.
       * @param datasetId Required. Dataset ID of the models to list.
       * @since 1.13
       */
      protected List(java.lang.String projectId, java.lang.String datasetId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.ListModelsResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the models to list. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the models to list.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the models to list. */
      public List setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the models to list. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the models to list.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the models to list. */
      public List setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results to return in a single response page. Leverage the page tokens to
     iterate through the entire collection.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Patch specific fields in the specified model.
     *
     * Create a request for the method "models.patch".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the model to patch.
     * @param datasetId Required. Dataset ID of the model to patch.
     * @param modelId Required. Model ID of the model to patch.
     * @param content the {@link com.google.api.services.bigquery.model.Model}
     * @return the request
     */
    public Patch patch(java.lang.String projectId, java.lang.String datasetId, java.lang.String modelId, com.google.api.services.bigquery.model.Model content) throws java.io.IOException {
      Patch result = new Patch(projectId, datasetId, modelId, content);
      initialize(result);
      return result;
    }

    public class Patch extends BigqueryRequest<com.google.api.services.bigquery.model.Model> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/models/{+modelId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern MODEL_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Patch specific fields in the specified model.
       *
       * Create a request for the method "models.patch".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the model to patch.
       * @param datasetId Required. Dataset ID of the model to patch.
       * @param modelId Required. Model ID of the model to patch.
       * @param content the {@link com.google.api.services.bigquery.model.Model}
       * @since 1.13
       */
      protected Patch(java.lang.String projectId, java.lang.String datasetId, java.lang.String modelId, com.google.api.services.bigquery.model.Model content) {
        super(Bigquery.this, "PATCH", REST_PATH, content, com.google.api.services.bigquery.model.Model.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.modelId = com.google.api.client.util.Preconditions.checkNotNull(modelId, "Required parameter modelId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MODEL_ID_PATTERN.matcher(modelId).matches(),
              "Parameter modelId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the model to patch. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the model to patch.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the model to patch. */
      public Patch setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the model to patch. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the model to patch.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the model to patch. */
      public Patch setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Model ID of the model to patch. */
      @com.google.api.client.util.Key
      private java.lang.String modelId;

      /** Required. Model ID of the model to patch.
       */
      public java.lang.String getModelId() {
        return modelId;
      }

      /** Required. Model ID of the model to patch. */
      public Patch setModelId(java.lang.String modelId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(MODEL_ID_PATTERN.matcher(modelId).matches(),
              "Parameter modelId must conform to the pattern " +
              "^[^/]+$");
        }
        this.modelId = modelId;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Projects.List request = bigquery.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * RPC to get the service account for a project used for interactions with Google Cloud KMS
     *
     * Create a request for the method "projects.getServiceAccount".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link GetServiceAccount#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. ID of the project.
     * @return the request
     */
    public GetServiceAccount getServiceAccount(java.lang.String projectId) throws java.io.IOException {
      GetServiceAccount result = new GetServiceAccount(projectId);
      initialize(result);
      return result;
    }

    public class GetServiceAccount extends BigqueryRequest<com.google.api.services.bigquery.model.GetServiceAccountResponse> {

      private static final String REST_PATH = "projects/{+projectId}/serviceAccount";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * RPC to get the service account for a project used for interactions with Google Cloud KMS
       *
       * Create a request for the method "projects.getServiceAccount".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link GetServiceAccount#execute()} method to invoke the remote
       * operation. <p> {@link GetServiceAccount#initialize(com.google.api.client.googleapis.services.Ab
       * stractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param projectId Required. ID of the project.
       * @since 1.13
       */
      protected GetServiceAccount(java.lang.String projectId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.GetServiceAccountResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetServiceAccount set$Xgafv(java.lang.String $Xgafv) {
        return (GetServiceAccount) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetServiceAccount setAccessToken(java.lang.String accessToken) {
        return (GetServiceAccount) super.setAccessToken(accessToken);
      }

      @Override
      public GetServiceAccount setAlt(java.lang.String alt) {
        return (GetServiceAccount) super.setAlt(alt);
      }

      @Override
      public GetServiceAccount setCallback(java.lang.String callback) {
        return (GetServiceAccount) super.setCallback(callback);
      }

      @Override
      public GetServiceAccount setFields(java.lang.String fields) {
        return (GetServiceAccount) super.setFields(fields);
      }

      @Override
      public GetServiceAccount setKey(java.lang.String key) {
        return (GetServiceAccount) super.setKey(key);
      }

      @Override
      public GetServiceAccount setOauthToken(java.lang.String oauthToken) {
        return (GetServiceAccount) super.setOauthToken(oauthToken);
      }

      @Override
      public GetServiceAccount setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetServiceAccount) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetServiceAccount setQuotaUser(java.lang.String quotaUser) {
        return (GetServiceAccount) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetServiceAccount setUploadType(java.lang.String uploadType) {
        return (GetServiceAccount) super.setUploadType(uploadType);
      }

      @Override
      public GetServiceAccount setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetServiceAccount) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. ID of the project. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. ID of the project.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. ID of the project. */
      public GetServiceAccount setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      @Override
      public GetServiceAccount set(String parameterName, Object value) {
        return (GetServiceAccount) super.set(parameterName, value);
      }
    }
    /**
     * RPC to list projects to which the user has been granted any project role. Users of this method
     * are encouraged to consider the [Resource Manager](https://cloud.google.com/resource-
     * manager/docs/) API, which provides the underlying data for this method and has more capabilities.
     *
     * Create a request for the method "projects.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.ProjectList> {

      private static final String REST_PATH = "projects";

      /**
       * RPC to list projects to which the user has been granted any project role. Users of this method
       * are encouraged to consider the [Resource Manager](https://cloud.google.com/resource-
       * manager/docs/) API, which provides the underlying data for this method and has more
       * capabilities.
       *
       * Create a request for the method "projects.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.ProjectList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * `maxResults` unset returns all results, up to 50 per page. Additionally, the number of
       * projects in a page may be fewer than `maxResults` because projects are retrieved and then
       * filtered to only projects with the BigQuery API enabled.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /**` maxResults` unset returns all results, up to 50 per page. Additionally, the number of projects in
    ` a page may be fewer than `maxResults` because projects are retrieved and then filtered to only
    ` projects with the BigQuery API enabled.
    `

       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * `maxResults` unset returns all results, up to 50 per page. Additionally, the number of
       * projects in a page may be fewer than `maxResults` because projects are retrieved and then
       * filtered to only projects with the BigQuery API enabled.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * Page token, returned by a previous call, to request the next page of results. If not
       * present, no further pages are present.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results. If not present, no
     further pages are present.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Page token, returned by a previous call, to request the next page of results. If not
       * present, no further pages are present.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Routines collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Routines.List request = bigquery.routines().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Routines routines() {
    return new Routines();
  }

  /**
   * The "routines" collection of methods.
   */
  public class Routines {

    /**
     * Deletes the routine specified by routineId from the dataset.
     *
     * Create a request for the method "routines.delete".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the routine to delete
     * @param datasetId Required. Dataset ID of the routine to delete
     * @param routineId Required. Routine ID of the routine to delete
     * @return the request
     */
    public Delete delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String routineId) throws java.io.IOException {
      Delete result = new Delete(projectId, datasetId, routineId);
      initialize(result);
      return result;
    }

    public class Delete extends BigqueryRequest<Void> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern ROUTINE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Deletes the routine specified by routineId from the dataset.
       *
       * Create a request for the method "routines.delete".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the routine to delete
       * @param datasetId Required. Dataset ID of the routine to delete
       * @param routineId Required. Routine ID of the routine to delete
       * @since 1.13
       */
      protected Delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String routineId) {
        super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.routineId = com.google.api.client.util.Preconditions.checkNotNull(routineId, "Required parameter routineId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTINE_ID_PATTERN.matcher(routineId).matches(),
              "Parameter routineId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the routine to delete */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the routine to delete
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the routine to delete */
      public Delete setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the routine to delete */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the routine to delete
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the routine to delete */
      public Delete setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Routine ID of the routine to delete */
      @com.google.api.client.util.Key
      private java.lang.String routineId;

      /** Required. Routine ID of the routine to delete
       */
      public java.lang.String getRoutineId() {
        return routineId;
      }

      /** Required. Routine ID of the routine to delete */
      public Delete setRoutineId(java.lang.String routineId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTINE_ID_PATTERN.matcher(routineId).matches(),
              "Parameter routineId must conform to the pattern " +
              "^[^/]+$");
        }
        this.routineId = routineId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets the specified routine resource by routine ID.
     *
     * Create a request for the method "routines.get".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the requested routine
     * @param datasetId Required. Dataset ID of the requested routine
     * @param routineId Required. Routine ID of the requested routine
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String datasetId, java.lang.String routineId) throws java.io.IOException {
      Get result = new Get(projectId, datasetId, routineId);
      initialize(result);
      return result;
    }

    public class Get extends BigqueryRequest<com.google.api.services.bigquery.model.Routine> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern ROUTINE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Gets the specified routine resource by routine ID.
       *
       * Create a request for the method "routines.get".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the requested routine
       * @param datasetId Required. Dataset ID of the requested routine
       * @param routineId Required. Routine ID of the requested routine
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String datasetId, java.lang.String routineId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.Routine.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.routineId = com.google.api.client.util.Preconditions.checkNotNull(routineId, "Required parameter routineId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTINE_ID_PATTERN.matcher(routineId).matches(),
              "Parameter routineId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the requested routine */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the requested routine
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the requested routine */
      public Get setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the requested routine */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the requested routine
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the requested routine */
      public Get setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Routine ID of the requested routine */
      @com.google.api.client.util.Key
      private java.lang.String routineId;

      /** Required. Routine ID of the requested routine
       */
      public java.lang.String getRoutineId() {
        return routineId;
      }

      /** Required. Routine ID of the requested routine */
      public Get setRoutineId(java.lang.String routineId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTINE_ID_PATTERN.matcher(routineId).matches(),
              "Parameter routineId must conform to the pattern " +
              "^[^/]+$");
        }
        this.routineId = routineId;
        return this;
      }

      /**
       * If set, only the Routine fields in the field mask are returned in the response. If unset,
       * all Routine fields are returned.
       */
      @com.google.api.client.util.Key
      private String readMask;

      /** If set, only the Routine fields in the field mask are returned in the response. If unset, all
     Routine fields are returned.
       */
      public String getReadMask() {
        return readMask;
      }

      /**
       * If set, only the Routine fields in the field mask are returned in the response. If unset,
       * all Routine fields are returned.
       */
      public Get setReadMask(String readMask) {
        this.readMask = readMask;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new routine in the dataset.
     *
     * Create a request for the method "routines.insert".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the new routine
     * @param datasetId Required. Dataset ID of the new routine
     * @param content the {@link com.google.api.services.bigquery.model.Routine}
     * @return the request
     */
    public Insert insert(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Routine content) throws java.io.IOException {
      Insert result = new Insert(projectId, datasetId, content);
      initialize(result);
      return result;
    }

    public class Insert extends BigqueryRequest<com.google.api.services.bigquery.model.Routine> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Creates a new routine in the dataset.
       *
       * Create a request for the method "routines.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the new routine
       * @param datasetId Required. Dataset ID of the new routine
       * @param content the {@link com.google.api.services.bigquery.model.Routine}
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Routine content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Routine.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the new routine */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the new routine
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the new routine */
      public Insert setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the new routine */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the new routine
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the new routine */
      public Insert setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all routines in the specified dataset. Requires the READER dataset role.
     *
     * Create a request for the method "routines.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the routines to list
     * @param datasetId Required. Dataset ID of the routines to list
     * @return the request
     */
    public List list(java.lang.String projectId, java.lang.String datasetId) throws java.io.IOException {
      List result = new List(projectId, datasetId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.ListRoutinesResponse> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Lists all routines in the specified dataset. Requires the READER dataset role.
       *
       * Create a request for the method "routines.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the routines to list
       * @param datasetId Required. Dataset ID of the routines to list
       * @since 1.13
       */
      protected List(java.lang.String projectId, java.lang.String datasetId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.ListRoutinesResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the routines to list */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the routines to list
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the routines to list */
      public List setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the routines to list */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the routines to list
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the routines to list */
      public List setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /**
       * If set, then only the Routines matching this filter are returned. The supported format is
       * `routineType:{RoutineType}`, where `{RoutineType}` is a RoutineType enum. For example:
       * `routineType:SCALAR_FUNCTION`.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** If set, then only the Routines matching this filter are returned. The supported format is
     `routineType:{RoutineType}`, where `{RoutineType}` is a RoutineType enum. For example:
     `routineType:SCALAR_FUNCTION`.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * If set, then only the Routines matching this filter are returned. The supported format is
       * `routineType:{RoutineType}`, where `{RoutineType}` is a RoutineType enum. For example:
       * `routineType:SCALAR_FUNCTION`.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results to return in a single response page. Leverage the page tokens to
     iterate through the entire collection.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * If set, then only the Routine fields in the field mask, as well as project_id, dataset_id
       * and routine_id, are returned in the response. If unset, then the following Routine fields
       * are returned: etag, project_id, dataset_id, routine_id, routine_type, creation_time,
       * last_modified_time, and language.
       */
      @com.google.api.client.util.Key
      private String readMask;

      /** If set, then only the Routine fields in the field mask, as well as project_id, dataset_id and
     routine_id, are returned in the response. If unset, then the following Routine fields are returned:
     etag, project_id, dataset_id, routine_id, routine_type, creation_time, last_modified_time, and
     language.
       */
      public String getReadMask() {
        return readMask;
      }

      /**
       * If set, then only the Routine fields in the field mask, as well as project_id, dataset_id
       * and routine_id, are returned in the response. If unset, then the following Routine fields
       * are returned: etag, project_id, dataset_id, routine_id, routine_type, creation_time,
       * last_modified_time, and language.
       */
      public List setReadMask(String readMask) {
        this.readMask = readMask;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing routine. The update method replaces the entire Routine
     * resource.
     *
     * Create a request for the method "routines.update".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the routine to update
     * @param datasetId Required. Dataset ID of the routine to update
     * @param routineId Required. Routine ID of the routine to update
     * @param content the {@link com.google.api.services.bigquery.model.Routine}
     * @return the request
     */
    public Update update(java.lang.String projectId, java.lang.String datasetId, java.lang.String routineId, com.google.api.services.bigquery.model.Routine content) throws java.io.IOException {
      Update result = new Update(projectId, datasetId, routineId, content);
      initialize(result);
      return result;
    }

    public class Update extends BigqueryRequest<com.google.api.services.bigquery.model.Routine> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/routines/{+routineId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern ROUTINE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Updates information in an existing routine. The update method replaces the entire Routine
       * resource.
       *
       * Create a request for the method "routines.update".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the routine to update
       * @param datasetId Required. Dataset ID of the routine to update
       * @param routineId Required. Routine ID of the routine to update
       * @param content the {@link com.google.api.services.bigquery.model.Routine}
       * @since 1.13
       */
      protected Update(java.lang.String projectId, java.lang.String datasetId, java.lang.String routineId, com.google.api.services.bigquery.model.Routine content) {
        super(Bigquery.this, "PUT", REST_PATH, content, com.google.api.services.bigquery.model.Routine.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.routineId = com.google.api.client.util.Preconditions.checkNotNull(routineId, "Required parameter routineId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTINE_ID_PATTERN.matcher(routineId).matches(),
              "Parameter routineId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the routine to update */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the routine to update
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the routine to update */
      public Update setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the routine to update */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the routine to update
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the routine to update */
      public Update setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Routine ID of the routine to update */
      @com.google.api.client.util.Key
      private java.lang.String routineId;

      /** Required. Routine ID of the routine to update
       */
      public java.lang.String getRoutineId() {
        return routineId;
      }

      /** Required. Routine ID of the routine to update */
      public Update setRoutineId(java.lang.String routineId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(ROUTINE_ID_PATTERN.matcher(routineId).matches(),
              "Parameter routineId must conform to the pattern " +
              "^[^/]+$");
        }
        this.routineId = routineId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the RowAccessPolicies collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.RowAccessPolicies.List request = bigquery.rowAccessPolicies().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public RowAccessPolicies rowAccessPolicies() {
    return new RowAccessPolicies();
  }

  /**
   * The "rowAccessPolicies" collection of methods.
   */
  public class RowAccessPolicies {

    /**
     * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
     * does not have a policy set.
     *
     * Create a request for the method "rowAccessPolicies.getIamPolicy".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
     * @param content the {@link com.google.api.services.bigquery.model.GetIamPolicyRequest}
     * @return the request
     */
    public GetIamPolicy getIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.GetIamPolicyRequest content) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class GetIamPolicy extends BigqueryRequest<com.google.api.services.bigquery.model.Policy> {

      private static final String REST_PATH = "{+resource}:getIamPolicy";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");

      /**
       * Gets the access control policy for a resource. Returns an empty policy if the resource exists
       * and does not have a policy set.
       *
       * Create a request for the method "rowAccessPolicies.getIamPolicy".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
       * operation. <p> {@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
       * @param content the {@link com.google.api.services.bigquery.model.GetIamPolicyRequest}
       * @since 1.13
       */
      protected GetIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.GetIamPolicyRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
        }
      }

      @Override
      public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (GetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (GetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public GetIamPolicy setAlt(java.lang.String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setCallback(java.lang.String callback) {
        return (GetIamPolicy) super.setCallback(callback);
      }

      @Override
      public GetIamPolicy setFields(java.lang.String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(java.lang.String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUploadType(java.lang.String uploadType) {
        return (GetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy is being requested. See [Resource
     names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
     field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      public GetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Lists all row access policies on the specified table.
     *
     * Create a request for the method "rowAccessPolicies.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the row access policies to list.
     * @param datasetId Required. Dataset ID of row access policies to list.
     * @param tableId Required. Table ID of the table to list row access policies.
     * @return the request
     */
    public List list(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) throws java.io.IOException {
      List result = new List(projectId, datasetId, tableId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.ListRowAccessPoliciesResponse> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/rowAccessPolicies";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern TABLE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Lists all row access policies on the specified table.
       *
       * Create a request for the method "rowAccessPolicies.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the row access policies to list.
       * @param datasetId Required. Dataset ID of row access policies to list.
       * @param tableId Required. Table ID of the table to list row access policies.
       * @since 1.13
       */
      protected List(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.ListRowAccessPoliciesResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the row access policies to list. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the row access policies to list.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the row access policies to list. */
      public List setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of row access policies to list. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of row access policies to list.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of row access policies to list. */
      public List setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Table ID of the table to list row access policies. */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Required. Table ID of the table to list row access policies.
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Required. Table ID of the table to list row access policies. */
      public List setTableId(java.lang.String tableId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = tableId;
        return this;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of results to return in a single response page. Leverage the page tokens to
     iterate through the entire collection.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified resource. If the resource does not exist,
     * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
     * designed to be used for building permission-aware UIs and command-line tools, not for
     * authorization checking. This operation may "fail open" without warning.
     *
     * Create a request for the method "rowAccessPolicies.testIamPermissions".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
     * @param content the {@link com.google.api.services.bigquery.model.TestIamPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.bigquery.model.TestIamPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends BigqueryRequest<com.google.api.services.bigquery.model.TestIamPermissionsResponse> {

      private static final String REST_PATH = "{+resource}:testIamPermissions";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");

      /**
       * Returns permissions that a caller has on the specified resource. If the resource does not
       * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
       * operation is designed to be used for building permission-aware UIs and command-line tools, not
       * for authorization checking. This operation may "fail open" without warning.
       *
       * Create a request for the method "rowAccessPolicies.testIamPermissions".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
       * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
       * @param content the {@link com.google.api.services.bigquery.model.TestIamPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String resource, com.google.api.services.bigquery.model.TestIamPermissionsRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.TestIamPermissionsResponse.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
        }
      }

      @Override
      public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
        return (TestIamPermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public TestIamPermissions setAccessToken(java.lang.String accessToken) {
        return (TestIamPermissions) super.setAccessToken(accessToken);
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setCallback(java.lang.String callback) {
        return (TestIamPermissions) super.setCallback(callback);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(java.lang.String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy detail is being requested. See [Resource
     names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
     field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      public TestIamPermissions setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+/rowAccessPolicies/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Tabledata collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Tabledata.List request = bigquery.tabledata().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Tabledata tabledata() {
    return new Tabledata();
  }

  /**
   * The "tabledata" collection of methods.
   */
  public class Tabledata {

    /**
     * Streams data into BigQuery one record at a time without needing to run a load job.
     *
     * Create a request for the method "tabledata.insertAll".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link InsertAll#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the destination.
     * @param datasetId Required. Dataset ID of the destination.
     * @param tableId Required. Table ID of the destination.
     * @param content the {@link com.google.api.services.bigquery.model.TableDataInsertAllRequest}
     * @return the request
     */
    public InsertAll insertAll(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.TableDataInsertAllRequest content) throws java.io.IOException {
      InsertAll result = new InsertAll(projectId, datasetId, tableId, content);
      initialize(result);
      return result;
    }

    public class InsertAll extends BigqueryRequest<com.google.api.services.bigquery.model.TableDataInsertAllResponse> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/insertAll";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern TABLE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Streams data into BigQuery one record at a time without needing to run a load job.
       *
       * Create a request for the method "tabledata.insertAll".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link InsertAll#execute()} method to invoke the remote
       * operation. <p> {@link
       * InsertAll#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the destination.
       * @param datasetId Required. Dataset ID of the destination.
       * @param tableId Required. Table ID of the destination.
       * @param content the {@link com.google.api.services.bigquery.model.TableDataInsertAllRequest}
       * @since 1.13
       */
      protected InsertAll(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.TableDataInsertAllRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.TableDataInsertAllResponse.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public InsertAll set$Xgafv(java.lang.String $Xgafv) {
        return (InsertAll) super.set$Xgafv($Xgafv);
      }

      @Override
      public InsertAll setAccessToken(java.lang.String accessToken) {
        return (InsertAll) super.setAccessToken(accessToken);
      }

      @Override
      public InsertAll setAlt(java.lang.String alt) {
        return (InsertAll) super.setAlt(alt);
      }

      @Override
      public InsertAll setCallback(java.lang.String callback) {
        return (InsertAll) super.setCallback(callback);
      }

      @Override
      public InsertAll setFields(java.lang.String fields) {
        return (InsertAll) super.setFields(fields);
      }

      @Override
      public InsertAll setKey(java.lang.String key) {
        return (InsertAll) super.setKey(key);
      }

      @Override
      public InsertAll setOauthToken(java.lang.String oauthToken) {
        return (InsertAll) super.setOauthToken(oauthToken);
      }

      @Override
      public InsertAll setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (InsertAll) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public InsertAll setQuotaUser(java.lang.String quotaUser) {
        return (InsertAll) super.setQuotaUser(quotaUser);
      }

      @Override
      public InsertAll setUploadType(java.lang.String uploadType) {
        return (InsertAll) super.setUploadType(uploadType);
      }

      @Override
      public InsertAll setUploadProtocol(java.lang.String uploadProtocol) {
        return (InsertAll) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the destination. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the destination.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the destination. */
      public InsertAll setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the destination. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the destination.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the destination. */
      public InsertAll setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Table ID of the destination. */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Required. Table ID of the destination.
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Required. Table ID of the destination. */
      public InsertAll setTableId(java.lang.String tableId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = tableId;
        return this;
      }

      @Override
      public InsertAll set(String parameterName, Object value) {
        return (InsertAll) super.set(parameterName, value);
      }
    }
    /**
     * List the content of a table in rows.
     *
     * Create a request for the method "tabledata.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project id of the table to list.
     * @param datasetId Required. Dataset id of the table to list.
     * @param tableId Required. Table id of the table to list.
     * @return the request
     */
    public List list(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) throws java.io.IOException {
      List result = new List(projectId, datasetId, tableId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.TableDataList> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}/data";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern TABLE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * List the content of a table in rows.
       *
       * Create a request for the method "tabledata.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project id of the table to list.
       * @param datasetId Required. Dataset id of the table to list.
       * @param tableId Required. Table id of the table to list.
       * @since 1.13
       */
      protected List(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.TableDataList.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project id of the table to list. */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project id of the table to list.
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project id of the table to list. */
      public List setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset id of the table to list. */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset id of the table to list.
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset id of the table to list. */
      public List setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Table id of the table to list. */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Required. Table id of the table to list.
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Required. Table id of the table to list. */
      public List setTableId(java.lang.String tableId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = tableId;
        return this;
      }

      /** Optional. Output timestamp as usec int64. Default is false. */
      @com.google.api.client.util.Key("formatOptions.useInt64Timestamp")
      private java.lang.Boolean formatOptionsUseInt64Timestamp;

      /** Optional. Output timestamp as usec int64. Default is false.
       */
      public java.lang.Boolean getFormatOptionsUseInt64Timestamp() {
        return formatOptionsUseInt64Timestamp;
      }

      /** Optional. Output timestamp as usec int64. Default is false. */
      public List setFormatOptionsUseInt64Timestamp(java.lang.Boolean formatOptionsUseInt64Timestamp) {
        this.formatOptionsUseInt64Timestamp = formatOptionsUseInt64Timestamp;
        return this;
      }

      /** Row limit of the table. */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** Row limit of the table.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /** Row limit of the table. */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /**
       * To retrieve the next page of table data, set this field to the string provided in the
       * pageToken field of the response body from your previous call to tabledata.list.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** To retrieve the next page of table data, set this field to the string provided in the pageToken
     field of the response body from your previous call to tabledata.list.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * To retrieve the next page of table data, set this field to the string provided in the
       * pageToken field of the response body from your previous call to tabledata.list.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Subset of fields to return, supports select into sub fields. Example: selected_fields =
       * "a,e.d.f";
       */
      @com.google.api.client.util.Key
      private java.lang.String selectedFields;

      /** Subset of fields to return, supports select into sub fields. Example: selected_fields = "a,e.d.f";
       */
      public java.lang.String getSelectedFields() {
        return selectedFields;
      }

      /**
       * Subset of fields to return, supports select into sub fields. Example: selected_fields =
       * "a,e.d.f";
       */
      public List setSelectedFields(java.lang.String selectedFields) {
        this.selectedFields = selectedFields;
        return this;
      }

      /** Start row index of the table. */
      @com.google.api.client.util.Key
      private java.math.BigInteger startIndex;

      /** Start row index of the table.
       */
      public java.math.BigInteger getStartIndex() {
        return startIndex;
      }

      /** Start row index of the table. */
      public List setStartIndex(java.math.BigInteger startIndex) {
        this.startIndex = startIndex;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Tables collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Bigquery bigquery = new Bigquery(...);}
   *   {@code Bigquery.Tables.List request = bigquery.tables().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Tables tables() {
    return new Tables();
  }

  /**
   * The "tables" collection of methods.
   */
  public class Tables {

    /**
     * Deletes the table specified by tableId from the dataset. If the table contains data, all the data
     * will be deleted.
     *
     * Create a request for the method "tables.delete".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the table to delete
     * @param datasetId Required. Dataset ID of the table to delete
     * @param tableId Required. Table ID of the table to delete
     * @return the request
     */
    public Delete delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) throws java.io.IOException {
      Delete result = new Delete(projectId, datasetId, tableId);
      initialize(result);
      return result;
    }

    public class Delete extends BigqueryRequest<Void> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern TABLE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Deletes the table specified by tableId from the dataset. If the table contains data, all the
       * data will be deleted.
       *
       * Create a request for the method "tables.delete".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       * <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the table to delete
       * @param datasetId Required. Dataset ID of the table to delete
       * @param tableId Required. Table ID of the table to delete
       * @since 1.13
       */
      protected Delete(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) {
        super(Bigquery.this, "DELETE", REST_PATH, null, Void.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the table to delete */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the table to delete
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the table to delete */
      public Delete setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the table to delete */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the table to delete
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the table to delete */
      public Delete setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Table ID of the table to delete */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Required. Table ID of the table to delete
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Required. Table ID of the table to delete */
      public Delete setTableId(java.lang.String tableId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = tableId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets the specified table resource by table ID. This method does not return the data in the table,
     * it only returns the table resource, which describes the structure of this table.
     *
     * Create a request for the method "tables.get".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the requested table
     * @param datasetId Required. Dataset ID of the requested table
     * @param tableId Required. Table ID of the requested table
     * @return the request
     */
    public Get get(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) throws java.io.IOException {
      Get result = new Get(projectId, datasetId, tableId);
      initialize(result);
      return result;
    }

    public class Get extends BigqueryRequest<com.google.api.services.bigquery.model.Table> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern TABLE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Gets the specified table resource by table ID. This method does not return the data in the
       * table, it only returns the table resource, which describes the structure of this table.
       *
       * Create a request for the method "tables.get".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the requested table
       * @param datasetId Required. Dataset ID of the requested table
       * @param tableId Required. Table ID of the requested table
       * @since 1.13
       */
      protected Get(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.Table.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the requested table */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the requested table
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the requested table */
      public Get setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the requested table */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the requested table
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the requested table */
      public Get setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Table ID of the requested table */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Required. Table ID of the requested table
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Required. Table ID of the requested table */
      public Get setTableId(java.lang.String tableId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = tableId;
        return this;
      }

      /**
       * List of table schema fields to return (comma-separated). If unspecified, all fields are
       * returned. A fieldMask cannot be used here because the fields will automatically be
       * converted from camelCase to snake_case and the conversion will fail if there are
       * underscores. Since these are fields in BigQuery table schemas, underscores are allowed.
       */
      @com.google.api.client.util.Key
      private java.lang.String selectedFields;

      /** List of table schema fields to return (comma-separated). If unspecified, all fields are returned. A
     fieldMask cannot be used here because the fields will automatically be converted from camelCase to
     snake_case and the conversion will fail if there are underscores. Since these are fields in
     BigQuery table schemas, underscores are allowed.
       */
      public java.lang.String getSelectedFields() {
        return selectedFields;
      }

      /**
       * List of table schema fields to return (comma-separated). If unspecified, all fields are
       * returned. A fieldMask cannot be used here because the fields will automatically be
       * converted from camelCase to snake_case and the conversion will fail if there are
       * underscores. Since these are fields in BigQuery table schemas, underscores are allowed.
       */
      public Get setSelectedFields(java.lang.String selectedFields) {
        this.selectedFields = selectedFields;
        return this;
      }

      /**
       * Optional. Specifies the view that determines which table information is returned. By
       * default, basic table information and storage statistics (STORAGE_STATS) are returned.
       */
      @com.google.api.client.util.Key
      private java.lang.String view;

      /** Optional. Specifies the view that determines which table information is returned. By default, basic
     table information and storage statistics (STORAGE_STATS) are returned.
       */
      public java.lang.String getView() {
        return view;
      }

      /**
       * Optional. Specifies the view that determines which table information is returned. By
       * default, basic table information and storage statistics (STORAGE_STATS) are returned.
       */
      public Get setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
     * does not have a policy set.
     *
     * Create a request for the method "tables.getIamPolicy".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
     * @param content the {@link com.google.api.services.bigquery.model.GetIamPolicyRequest}
     * @return the request
     */
    public GetIamPolicy getIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.GetIamPolicyRequest content) throws java.io.IOException {
      GetIamPolicy result = new GetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class GetIamPolicy extends BigqueryRequest<com.google.api.services.bigquery.model.Policy> {

      private static final String REST_PATH = "{+resource}:getIamPolicy";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");

      /**
       * Gets the access control policy for a resource. Returns an empty policy if the resource exists
       * and does not have a policy set.
       *
       * Create a request for the method "tables.getIamPolicy".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
       * operation. <p> {@link
       * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy is being requested. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
       * @param content the {@link com.google.api.services.bigquery.model.GetIamPolicyRequest}
       * @since 1.13
       */
      protected GetIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.GetIamPolicyRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
        }
      }

      @Override
      public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (GetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (GetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public GetIamPolicy setAlt(java.lang.String alt) {
        return (GetIamPolicy) super.setAlt(alt);
      }

      @Override
      public GetIamPolicy setCallback(java.lang.String callback) {
        return (GetIamPolicy) super.setCallback(callback);
      }

      @Override
      public GetIamPolicy setFields(java.lang.String fields) {
        return (GetIamPolicy) super.setFields(fields);
      }

      @Override
      public GetIamPolicy setKey(java.lang.String key) {
        return (GetIamPolicy) super.setKey(key);
      }

      @Override
      public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (GetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (GetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetIamPolicy setUploadType(java.lang.String uploadType) {
        return (GetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy is being requested. See [Resource
     names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
     field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy is being requested. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      public GetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public GetIamPolicy set(String parameterName, Object value) {
        return (GetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new, empty table in the dataset.
     *
     * Create a request for the method "tables.insert".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Insert#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the new table
     * @param datasetId Required. Dataset ID of the new table
     * @param content the {@link com.google.api.services.bigquery.model.Table}
     * @return the request
     */
    public Insert insert(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Table content) throws java.io.IOException {
      Insert result = new Insert(projectId, datasetId, content);
      initialize(result);
      return result;
    }

    public class Insert extends BigqueryRequest<com.google.api.services.bigquery.model.Table> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Creates a new, empty table in the dataset.
       *
       * Create a request for the method "tables.insert".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Insert#execute()} method to invoke the remote operation.
       * <p> {@link
       * Insert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the new table
       * @param datasetId Required. Dataset ID of the new table
       * @param content the {@link com.google.api.services.bigquery.model.Table}
       * @since 1.13
       */
      protected Insert(java.lang.String projectId, java.lang.String datasetId, com.google.api.services.bigquery.model.Table content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Table.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Insert set$Xgafv(java.lang.String $Xgafv) {
        return (Insert) super.set$Xgafv($Xgafv);
      }

      @Override
      public Insert setAccessToken(java.lang.String accessToken) {
        return (Insert) super.setAccessToken(accessToken);
      }

      @Override
      public Insert setAlt(java.lang.String alt) {
        return (Insert) super.setAlt(alt);
      }

      @Override
      public Insert setCallback(java.lang.String callback) {
        return (Insert) super.setCallback(callback);
      }

      @Override
      public Insert setFields(java.lang.String fields) {
        return (Insert) super.setFields(fields);
      }

      @Override
      public Insert setKey(java.lang.String key) {
        return (Insert) super.setKey(key);
      }

      @Override
      public Insert setOauthToken(java.lang.String oauthToken) {
        return (Insert) super.setOauthToken(oauthToken);
      }

      @Override
      public Insert setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Insert) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Insert setQuotaUser(java.lang.String quotaUser) {
        return (Insert) super.setQuotaUser(quotaUser);
      }

      @Override
      public Insert setUploadType(java.lang.String uploadType) {
        return (Insert) super.setUploadType(uploadType);
      }

      @Override
      public Insert setUploadProtocol(java.lang.String uploadProtocol) {
        return (Insert) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the new table */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the new table
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the new table */
      public Insert setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the new table */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the new table
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the new table */
      public Insert setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      @Override
      public Insert set(String parameterName, Object value) {
        return (Insert) super.set(parameterName, value);
      }
    }
    /**
     * Lists all tables in the specified dataset. Requires the READER dataset role.
     *
     * Create a request for the method "tables.list".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the tables to list
     * @param datasetId Required. Dataset ID of the tables to list
     * @return the request
     */
    public List list(java.lang.String projectId, java.lang.String datasetId) throws java.io.IOException {
      List result = new List(projectId, datasetId);
      initialize(result);
      return result;
    }

    public class List extends BigqueryRequest<com.google.api.services.bigquery.model.TableList> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Lists all tables in the specified dataset. Requires the READER dataset role.
       *
       * Create a request for the method "tables.list".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the tables to list
       * @param datasetId Required. Dataset ID of the tables to list
       * @since 1.13
       */
      protected List(java.lang.String projectId, java.lang.String datasetId) {
        super(Bigquery.this, "GET", REST_PATH, null, com.google.api.services.bigquery.model.TableList.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the tables to list */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the tables to list
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the tables to list */
      public List setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the tables to list */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the tables to list
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the tables to list */
      public List setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      @com.google.api.client.util.Key
      private java.lang.Long maxResults;

      /** The maximum number of results to return in a single response page. Leverage the page tokens to
     iterate through the entire collection.
       */
      public java.lang.Long getMaxResults() {
        return maxResults;
      }

      /**
       * The maximum number of results to return in a single response page. Leverage the page tokens
       * to iterate through the entire collection.
       */
      public List setMaxResults(java.lang.Long maxResults) {
        this.maxResults = maxResults;
        return this;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token, returned by a previous call, to request the next page of results
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token, returned by a previous call, to request the next page of results */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing table. The update method replaces the entire table resource,
     * whereas the patch method only replaces fields that are provided in the submitted table resource.
     * This method supports RFC5789 patch semantics.
     *
     * Create a request for the method "tables.patch".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the table to update
     * @param datasetId Required. Dataset ID of the table to update
     * @param tableId Required. Table ID of the table to update
     * @param content the {@link com.google.api.services.bigquery.model.Table}
     * @return the request
     */
    public Patch patch(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.Table content) throws java.io.IOException {
      Patch result = new Patch(projectId, datasetId, tableId, content);
      initialize(result);
      return result;
    }

    public class Patch extends BigqueryRequest<com.google.api.services.bigquery.model.Table> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern TABLE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Updates information in an existing table. The update method replaces the entire table resource,
       * whereas the patch method only replaces fields that are provided in the submitted table
       * resource. This method supports RFC5789 patch semantics.
       *
       * Create a request for the method "tables.patch".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       * <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the table to update
       * @param datasetId Required. Dataset ID of the table to update
       * @param tableId Required. Table ID of the table to update
       * @param content the {@link com.google.api.services.bigquery.model.Table}
       * @since 1.13
       */
      protected Patch(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.Table content) {
        super(Bigquery.this, "PATCH", REST_PATH, content, com.google.api.services.bigquery.model.Table.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the table to update
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the table to update */
      public Patch setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the table to update
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the table to update */
      public Patch setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Table ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Required. Table ID of the table to update
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Required. Table ID of the table to update */
      public Patch setTableId(java.lang.String tableId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = tableId;
        return this;
      }

      /** Optional.  When true will autodetect schema, else will keep original schema */
      @com.google.api.client.util.Key("autodetect_schema")
      private java.lang.Boolean autodetectSchema;

      /** Optional.  When true will autodetect schema, else will keep original schema
       */
      public java.lang.Boolean getAutodetectSchema() {
        return autodetectSchema;
      }

      /** Optional.  When true will autodetect schema, else will keep original schema */
      public Patch setAutodetectSchema(java.lang.Boolean autodetectSchema) {
        this.autodetectSchema = autodetectSchema;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }
    /**
     * Sets the access control policy on the specified resource. Replaces any existing policy. Can
     * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
     *
     * Create a request for the method "tables.setIamPolicy".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy is being specified. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
     * @param content the {@link com.google.api.services.bigquery.model.SetIamPolicyRequest}
     * @return the request
     */
    public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.SetIamPolicyRequest content) throws java.io.IOException {
      SetIamPolicy result = new SetIamPolicy(resource, content);
      initialize(result);
      return result;
    }

    public class SetIamPolicy extends BigqueryRequest<com.google.api.services.bigquery.model.Policy> {

      private static final String REST_PATH = "{+resource}:setIamPolicy";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");

      /**
       * Sets the access control policy on the specified resource. Replaces any existing policy. Can
       * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
       *
       * Create a request for the method "tables.setIamPolicy".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
       * operation. <p> {@link
       * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy is being specified. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
       * @param content the {@link com.google.api.services.bigquery.model.SetIamPolicyRequest}
       * @since 1.13
       */
      protected SetIamPolicy(java.lang.String resource, com.google.api.services.bigquery.model.SetIamPolicyRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.Policy.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
        }
      }

      @Override
      public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
        return (SetIamPolicy) super.set$Xgafv($Xgafv);
      }

      @Override
      public SetIamPolicy setAccessToken(java.lang.String accessToken) {
        return (SetIamPolicy) super.setAccessToken(accessToken);
      }

      @Override
      public SetIamPolicy setAlt(java.lang.String alt) {
        return (SetIamPolicy) super.setAlt(alt);
      }

      @Override
      public SetIamPolicy setCallback(java.lang.String callback) {
        return (SetIamPolicy) super.setCallback(callback);
      }

      @Override
      public SetIamPolicy setFields(java.lang.String fields) {
        return (SetIamPolicy) super.setFields(fields);
      }

      @Override
      public SetIamPolicy setKey(java.lang.String key) {
        return (SetIamPolicy) super.setKey(key);
      }

      @Override
      public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
        return (SetIamPolicy) super.setOauthToken(oauthToken);
      }

      @Override
      public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
        return (SetIamPolicy) super.setQuotaUser(quotaUser);
      }

      @Override
      public SetIamPolicy setUploadType(java.lang.String uploadType) {
        return (SetIamPolicy) super.setUploadType(uploadType);
      }

      @Override
      public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
        return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy is being specified. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy is being specified. See [Resource
     names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
     field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy is being specified. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      public SetIamPolicy setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public SetIamPolicy set(String parameterName, Object value) {
        return (SetIamPolicy) super.set(parameterName, value);
      }
    }
    /**
     * Returns permissions that a caller has on the specified resource. If the resource does not exist,
     * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
     * designed to be used for building permission-aware UIs and command-line tools, not for
     * authorization checking. This operation may "fail open" without warning.
     *
     * Create a request for the method "tables.testIamPermissions".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
     *
     * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
     * @param content the {@link com.google.api.services.bigquery.model.TestIamPermissionsRequest}
     * @return the request
     */
    public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.bigquery.model.TestIamPermissionsRequest content) throws java.io.IOException {
      TestIamPermissions result = new TestIamPermissions(resource, content);
      initialize(result);
      return result;
    }

    public class TestIamPermissions extends BigqueryRequest<com.google.api.services.bigquery.model.TestIamPermissionsResponse> {

      private static final String REST_PATH = "{+resource}:testIamPermissions";

      private final java.util.regex.Pattern RESOURCE_PATTERN =
          java.util.regex.Pattern.compile("^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");

      /**
       * Returns permissions that a caller has on the specified resource. If the resource does not
       * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
       * operation is designed to be used for building permission-aware UIs and command-line tools, not
       * for authorization checking. This operation may "fail open" without warning.
       *
       * Create a request for the method "tables.testIamPermissions".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
       * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param resource REQUIRED: The resource for which the policy detail is being requested. See [Resource
     *        names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
     *        this field.
       * @param content the {@link com.google.api.services.bigquery.model.TestIamPermissionsRequest}
       * @since 1.13
       */
      protected TestIamPermissions(java.lang.String resource, com.google.api.services.bigquery.model.TestIamPermissionsRequest content) {
        super(Bigquery.this, "POST", REST_PATH, content, com.google.api.services.bigquery.model.TestIamPermissionsResponse.class);
        this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
        }
      }

      @Override
      public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
        return (TestIamPermissions) super.set$Xgafv($Xgafv);
      }

      @Override
      public TestIamPermissions setAccessToken(java.lang.String accessToken) {
        return (TestIamPermissions) super.setAccessToken(accessToken);
      }

      @Override
      public TestIamPermissions setAlt(java.lang.String alt) {
        return (TestIamPermissions) super.setAlt(alt);
      }

      @Override
      public TestIamPermissions setCallback(java.lang.String callback) {
        return (TestIamPermissions) super.setCallback(callback);
      }

      @Override
      public TestIamPermissions setFields(java.lang.String fields) {
        return (TestIamPermissions) super.setFields(fields);
      }

      @Override
      public TestIamPermissions setKey(java.lang.String key) {
        return (TestIamPermissions) super.setKey(key);
      }

      @Override
      public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
        return (TestIamPermissions) super.setOauthToken(oauthToken);
      }

      @Override
      public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
        return (TestIamPermissions) super.setQuotaUser(quotaUser);
      }

      @Override
      public TestIamPermissions setUploadType(java.lang.String uploadType) {
        return (TestIamPermissions) super.setUploadType(uploadType);
      }

      @Override
      public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
        return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      @com.google.api.client.util.Key
      private java.lang.String resource;

      /** REQUIRED: The resource for which the policy detail is being requested. See [Resource
     names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for this
     field.
       */
      public java.lang.String getResource() {
        return resource;
      }

      /**
       * REQUIRED: The resource for which the policy detail is being requested. See [Resource
       * names](https://cloud.google.com/apis/design/resource_names) for the appropriate value for
       * this field.
       */
      public TestIamPermissions setResource(java.lang.String resource) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
              "Parameter resource must conform to the pattern " +
              "^projects/[^/]+/datasets/[^/]+/tables/[^/]+$");
        }
        this.resource = resource;
        return this;
      }

      @Override
      public TestIamPermissions set(String parameterName, Object value) {
        return (TestIamPermissions) super.set(parameterName, value);
      }
    }
    /**
     * Updates information in an existing table. The update method replaces the entire Table resource,
     * whereas the patch method only replaces fields that are provided in the submitted Table resource.
     *
     * Create a request for the method "tables.update".
     *
     * This request holds the parameters needed by the bigquery server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param projectId Required. Project ID of the table to update
     * @param datasetId Required. Dataset ID of the table to update
     * @param tableId Required. Table ID of the table to update
     * @param content the {@link com.google.api.services.bigquery.model.Table}
     * @return the request
     */
    public Update update(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.Table content) throws java.io.IOException {
      Update result = new Update(projectId, datasetId, tableId, content);
      initialize(result);
      return result;
    }

    public class Update extends BigqueryRequest<com.google.api.services.bigquery.model.Table> {

      private static final String REST_PATH = "projects/{+projectId}/datasets/{+datasetId}/tables/{+tableId}";

      private final java.util.regex.Pattern PROJECT_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern DATASET_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      private final java.util.regex.Pattern TABLE_ID_PATTERN =
          java.util.regex.Pattern.compile("^[^/]+$");

      /**
       * Updates information in an existing table. The update method replaces the entire Table resource,
       * whereas the patch method only replaces fields that are provided in the submitted Table
       * resource.
       *
       * Create a request for the method "tables.update".
       *
       * This request holds the parameters needed by the the bigquery server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param projectId Required. Project ID of the table to update
       * @param datasetId Required. Dataset ID of the table to update
       * @param tableId Required. Table ID of the table to update
       * @param content the {@link com.google.api.services.bigquery.model.Table}
       * @since 1.13
       */
      protected Update(java.lang.String projectId, java.lang.String datasetId, java.lang.String tableId, com.google.api.services.bigquery.model.Table content) {
        super(Bigquery.this, "PUT", REST_PATH, content, com.google.api.services.bigquery.model.Table.class);
        this.projectId = com.google.api.client.util.Preconditions.checkNotNull(projectId, "Required parameter projectId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = com.google.api.client.util.Preconditions.checkNotNull(datasetId, "Required parameter datasetId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = com.google.api.client.util.Preconditions.checkNotNull(tableId, "Required parameter tableId must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Project ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String projectId;

      /** Required. Project ID of the table to update
       */
      public java.lang.String getProjectId() {
        return projectId;
      }

      /** Required. Project ID of the table to update */
      public Update setProjectId(java.lang.String projectId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(PROJECT_ID_PATTERN.matcher(projectId).matches(),
              "Parameter projectId must conform to the pattern " +
              "^[^/]+$");
        }
        this.projectId = projectId;
        return this;
      }

      /** Required. Dataset ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String datasetId;

      /** Required. Dataset ID of the table to update
       */
      public java.lang.String getDatasetId() {
        return datasetId;
      }

      /** Required. Dataset ID of the table to update */
      public Update setDatasetId(java.lang.String datasetId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(DATASET_ID_PATTERN.matcher(datasetId).matches(),
              "Parameter datasetId must conform to the pattern " +
              "^[^/]+$");
        }
        this.datasetId = datasetId;
        return this;
      }

      /** Required. Table ID of the table to update */
      @com.google.api.client.util.Key
      private java.lang.String tableId;

      /** Required. Table ID of the table to update
       */
      public java.lang.String getTableId() {
        return tableId;
      }

      /** Required. Table ID of the table to update */
      public Update setTableId(java.lang.String tableId) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(TABLE_ID_PATTERN.matcher(tableId).matches(),
              "Parameter tableId must conform to the pattern " +
              "^[^/]+$");
        }
        this.tableId = tableId;
        return this;
      }

      /** Optional.  When true will autodetect schema, else will keep original schema */
      @com.google.api.client.util.Key("autodetect_schema")
      private java.lang.Boolean autodetectSchema;

      /** Optional.  When true will autodetect schema, else will keep original schema
       */
      public java.lang.Boolean getAutodetectSchema() {
        return autodetectSchema;
      }

      /** Optional.  When true will autodetect schema, else will keep original schema */
      public Update setAutodetectSchema(java.lang.Boolean autodetectSchema) {
        this.autodetectSchema = autodetectSchema;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Bigquery}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Bigquery}. */
    @Override
    public Bigquery build() {
      return new Bigquery(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link BigqueryRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setBigqueryRequestInitializer(
        BigqueryRequestInitializer bigqueryRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(bigqueryRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
