/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Model definition for QueryTimelineSample.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class QueryTimelineSample extends com.google.api.client.json.GenericJson {

  /**
   * Total number of units currently being processed by workers. This does not correspond directly
   * to slot usage. This is the largest value observed since the last sample.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long activeUnits;

  /**
   * Total parallel units of work completed by this query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long completedUnits;

  /**
   * Milliseconds elapsed since the start of query execution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long elapsedMs;

  /**
   * Units of work that can be scheduled immediately. Providing additional slots for these units of
   * work will speed up the query, provided no other query in the reservation needs additional
   * slots.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long estimatedRunnableUnits;

  /**
   * Total units of work remaining for the query. This number can be revised (increased or
   * decreased) while the query is running.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long pendingUnits;

  /**
   * Cumulative slot-ms consumed by the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalSlotMs;

  /**
   * Total number of units currently being processed by workers. This does not correspond directly
   * to slot usage. This is the largest value observed since the last sample.
   * @return value or {@code null} for none
   */
  public java.lang.Long getActiveUnits() {
    return activeUnits;
  }

  /**
   * Total number of units currently being processed by workers. This does not correspond directly
   * to slot usage. This is the largest value observed since the last sample.
   * @param activeUnits activeUnits or {@code null} for none
   */
  public QueryTimelineSample setActiveUnits(java.lang.Long activeUnits) {
    this.activeUnits = activeUnits;
    return this;
  }

  /**
   * Total parallel units of work completed by this query.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCompletedUnits() {
    return completedUnits;
  }

  /**
   * Total parallel units of work completed by this query.
   * @param completedUnits completedUnits or {@code null} for none
   */
  public QueryTimelineSample setCompletedUnits(java.lang.Long completedUnits) {
    this.completedUnits = completedUnits;
    return this;
  }

  /**
   * Milliseconds elapsed since the start of query execution.
   * @return value or {@code null} for none
   */
  public java.lang.Long getElapsedMs() {
    return elapsedMs;
  }

  /**
   * Milliseconds elapsed since the start of query execution.
   * @param elapsedMs elapsedMs or {@code null} for none
   */
  public QueryTimelineSample setElapsedMs(java.lang.Long elapsedMs) {
    this.elapsedMs = elapsedMs;
    return this;
  }

  /**
   * Units of work that can be scheduled immediately. Providing additional slots for these units of
   * work will speed up the query, provided no other query in the reservation needs additional
   * slots.
   * @return value or {@code null} for none
   */
  public java.lang.Long getEstimatedRunnableUnits() {
    return estimatedRunnableUnits;
  }

  /**
   * Units of work that can be scheduled immediately. Providing additional slots for these units of
   * work will speed up the query, provided no other query in the reservation needs additional
   * slots.
   * @param estimatedRunnableUnits estimatedRunnableUnits or {@code null} for none
   */
  public QueryTimelineSample setEstimatedRunnableUnits(java.lang.Long estimatedRunnableUnits) {
    this.estimatedRunnableUnits = estimatedRunnableUnits;
    return this;
  }

  /**
   * Total units of work remaining for the query. This number can be revised (increased or
   * decreased) while the query is running.
   * @return value or {@code null} for none
   */
  public java.lang.Long getPendingUnits() {
    return pendingUnits;
  }

  /**
   * Total units of work remaining for the query. This number can be revised (increased or
   * decreased) while the query is running.
   * @param pendingUnits pendingUnits or {@code null} for none
   */
  public QueryTimelineSample setPendingUnits(java.lang.Long pendingUnits) {
    this.pendingUnits = pendingUnits;
    return this;
  }

  /**
   * Cumulative slot-ms consumed by the query.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalSlotMs() {
    return totalSlotMs;
  }

  /**
   * Cumulative slot-ms consumed by the query.
   * @param totalSlotMs totalSlotMs or {@code null} for none
   */
  public QueryTimelineSample setTotalSlotMs(java.lang.Long totalSlotMs) {
    this.totalSlotMs = totalSlotMs;
    return this;
  }

  @Override
  public QueryTimelineSample set(String fieldName, Object value) {
    return (QueryTimelineSample) super.set(fieldName, value);
  }

  @Override
  public QueryTimelineSample clone() {
    return (QueryTimelineSample) super.clone();
  }

}
