/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * Sequence conditions consist of one or more steps, where each step is defined by one or more
 * dimension/metric conditions. Multiple steps can be combined with special sequence operators.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SequenceSegment extends com.google.api.client.json.GenericJson {

  /**
   * If set, first step condition must match the first hit of the visitor (in the date range).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean firstStepShouldMatchFirstHit;

  /**
   * The list of steps in the sequence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SegmentSequenceStep> segmentSequenceSteps;

  static {
    // hack to force ProGuard to consider SegmentSequenceStep used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(SegmentSequenceStep.class);
  }

  /**
   * If set, first step condition must match the first hit of the visitor (in the date range).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFirstStepShouldMatchFirstHit() {
    return firstStepShouldMatchFirstHit;
  }

  /**
   * If set, first step condition must match the first hit of the visitor (in the date range).
   * @param firstStepShouldMatchFirstHit firstStepShouldMatchFirstHit or {@code null} for none
   */
  public SequenceSegment setFirstStepShouldMatchFirstHit(java.lang.Boolean firstStepShouldMatchFirstHit) {
    this.firstStepShouldMatchFirstHit = firstStepShouldMatchFirstHit;
    return this;
  }

  /**
   * The list of steps in the sequence.
   * @return value or {@code null} for none
   */
  public java.util.List<SegmentSequenceStep> getSegmentSequenceSteps() {
    return segmentSequenceSteps;
  }

  /**
   * The list of steps in the sequence.
   * @param segmentSequenceSteps segmentSequenceSteps or {@code null} for none
   */
  public SequenceSegment setSegmentSequenceSteps(java.util.List<SegmentSequenceStep> segmentSequenceSteps) {
    this.segmentSequenceSteps = segmentSequenceSteps;
    return this;
  }

  @Override
  public SequenceSegment set(String fieldName, Object value) {
    return (SequenceSegment) super.set(fieldName, value);
  }

  @Override
  public SequenceSegment clone() {
    return (SequenceSegment) super.clone();
  }

}
