/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * SegmentFilter defines the segment to be either a simple or a sequence segment. A simple segment
 * condition contains dimension and metric conditions to select the sessions or users. A sequence
 * segment condition can be used to select users or sessions based on sequential conditions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SegmentFilter extends com.google.api.client.json.GenericJson {

  /**
   * If true, match the complement of simple or sequence segment. For example, to match all visits
   * not from "New York", we can define the segment as follows: "sessionSegment": {
   * "segmentFilters": [{ "simpleSegment" :{ "orFiltersForSegment": [{ "segmentFilterClauses":[{
   * "dimensionFilter": { "dimensionName": "ga:city", "expressions": ["New York"] } }] }] }, "not":
   * "True" }] },
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean not;

  /**
   * Sequence conditions consist of one or more steps, where each step is defined by one or more
   * dimension/metric conditions. Multiple steps can be combined with special sequence operators.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SequenceSegment sequenceSegment;

  /**
   * A Simple segment conditions consist of one or more dimension/metric conditions that can be
   * combined
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SimpleSegment simpleSegment;

  /**
   * If true, match the complement of simple or sequence segment. For example, to match all visits
   * not from "New York", we can define the segment as follows: "sessionSegment": {
   * "segmentFilters": [{ "simpleSegment" :{ "orFiltersForSegment": [{ "segmentFilterClauses":[{
   * "dimensionFilter": { "dimensionName": "ga:city", "expressions": ["New York"] } }] }] }, "not":
   * "True" }] },
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNot() {
    return not;
  }

  /**
   * If true, match the complement of simple or sequence segment. For example, to match all visits
   * not from "New York", we can define the segment as follows: "sessionSegment": {
   * "segmentFilters": [{ "simpleSegment" :{ "orFiltersForSegment": [{ "segmentFilterClauses":[{
   * "dimensionFilter": { "dimensionName": "ga:city", "expressions": ["New York"] } }] }] }, "not":
   * "True" }] },
   * @param not not or {@code null} for none
   */
  public SegmentFilter setNot(java.lang.Boolean not) {
    this.not = not;
    return this;
  }

  /**
   * Sequence conditions consist of one or more steps, where each step is defined by one or more
   * dimension/metric conditions. Multiple steps can be combined with special sequence operators.
   * @return value or {@code null} for none
   */
  public SequenceSegment getSequenceSegment() {
    return sequenceSegment;
  }

  /**
   * Sequence conditions consist of one or more steps, where each step is defined by one or more
   * dimension/metric conditions. Multiple steps can be combined with special sequence operators.
   * @param sequenceSegment sequenceSegment or {@code null} for none
   */
  public SegmentFilter setSequenceSegment(SequenceSegment sequenceSegment) {
    this.sequenceSegment = sequenceSegment;
    return this;
  }

  /**
   * A Simple segment conditions consist of one or more dimension/metric conditions that can be
   * combined
   * @return value or {@code null} for none
   */
  public SimpleSegment getSimpleSegment() {
    return simpleSegment;
  }

  /**
   * A Simple segment conditions consist of one or more dimension/metric conditions that can be
   * combined
   * @param simpleSegment simpleSegment or {@code null} for none
   */
  public SegmentFilter setSimpleSegment(SimpleSegment simpleSegment) {
    this.simpleSegment = simpleSegment;
    return this;
  }

  @Override
  public SegmentFilter set(String fieldName, Object value) {
    return (SegmentFilter) super.set(fieldName, value);
  }

  @Override
  public SegmentFilter clone() {
    return (SegmentFilter) super.clone();
  }

}
