/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * The main request class which specifies the Reporting API request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportRequest extends com.google.api.client.json.GenericJson {

  /**
   * Cohort group associated with this request. If there is a cohort group in the request the
   * `ga:cohort` dimension must be present. Every [ReportRequest](#ReportRequest) within a
   * `batchGet` method must contain the same `cohortGroup` definition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CohortGroup cohortGroup;

  /**
   * Date ranges in the request. The request can have a maximum of 2 date ranges. The response will
   * contain a set of metric values for each combination of the dimensions for each date range in
   * the request. So, if there are two date ranges, there will be two set of metric values, one for
   * the original date range and one for the second date range. The `reportRequest.dateRanges` field
   * should not be specified for cohorts or Lifetime value requests. If a date range is not
   * provided, the default date range is (startDate: current date - 7 days, endDate: current date -
   * 1 day). Every [ReportRequest](#ReportRequest) within a `batchGet` method must contain the same
   * `dateRanges` definition.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DateRange> dateRanges;

  static {
    // hack to force ProGuard to consider DateRange used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DateRange.class);
  }

  /**
   * The dimension filter clauses for filtering Dimension Values. They are logically combined with
   * the `AND` operator. Note that filtering occurs before any dimensions are aggregated, so that
   * the returned metrics represent the total for only the relevant dimensions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DimensionFilterClause> dimensionFilterClauses;

  static {
    // hack to force ProGuard to consider DimensionFilterClause used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DimensionFilterClause.class);
  }

  /**
   * The dimensions requested. Requests can have a total of 9 dimensions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Dimension> dimensions;

  static {
    // hack to force ProGuard to consider Dimension used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Dimension.class);
  }

  /**
   * Dimension or metric filters that restrict the data returned for your request. To use the
   * `filtersExpression`, supply a dimension or metric on which to filter, followed by the filter
   * expression. For example, the following expression selects `ga:browser` dimension which starts
   * with Firefox; `ga:browser=~^Firefox`. For more information on dimensions and metric filters,
   * see [Filters reference](https://developers.google.com/analytics/devguides/reporting/core/v3/ref
   * erence#filters).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filtersExpression;

  /**
   * If set to true, hides the total of all metrics for all the matching rows, for every date range.
   * The default false and will return the totals.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hideTotals;

  /**
   * If set to true, hides the minimum and maximum across all matching rows. The default is false
   * and the value ranges are returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hideValueRanges;

  /**
   * If set to false, the response does not include rows if all the retrieved metrics are equal to
   * zero. The default is false which will exclude these rows.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean includeEmptyRows;

  /**
   * The metric filter clauses. They are logically combined with the `AND` operator. Metric filters
   * look at only the first date range and not the comparing date range. Note that filtering on
   * metrics occurs after the metrics are aggregated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MetricFilterClause> metricFilterClauses;

  static {
    // hack to force ProGuard to consider MetricFilterClause used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MetricFilterClause.class);
  }

  /**
   * The metrics requested. Requests must specify at least one metric. Requests can have a total of
   * 10 metrics.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Metric> metrics;

  static {
    // hack to force ProGuard to consider Metric used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Metric.class);
  }

  /**
   * Sort order on output rows. To compare two rows, the elements of the following are applied in
   * order until a difference is found. All date ranges in the output get the same row order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<OrderBy> orderBys;

  static {
    // hack to force ProGuard to consider OrderBy used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(OrderBy.class);
  }

  /**
   * Page size is for paging and specifies the maximum number of returned rows. Page size should be
   * >= 0. A query returns the default of 1,000 rows. The Analytics Core Reporting API returns a
   * maximum of 100,000 rows per request, no matter how many you ask for. It can also return fewer
   * rows than requested, if there aren't as many dimension segments as you expect. For instance,
   * there are fewer than 300 possible values for `ga:country`, so when segmenting only by country,
   * you can't get more than 300 rows, even if you set `pageSize` to a higher value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer pageSize;

  /**
   * A continuation token to get the next page of the results. Adding this to the request will
   * return the rows after the pageToken. The pageToken should be the value returned in the
   * nextPageToken parameter in the response to the GetReports request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pageToken;

  /**
   * The pivot definitions. Requests can have a maximum of 2 pivots.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Pivot> pivots;

  static {
    // hack to force ProGuard to consider Pivot used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Pivot.class);
  }

  /**
   * The desired report [sample](https://support.google.com/analytics/answer/2637192) size. If the
   * the `samplingLevel` field is unspecified the `DEFAULT` sampling level is used. Every
   * [ReportRequest](#ReportRequest) within a `batchGet` method must contain the same
   * `samplingLevel` definition. See [developer
   * guide](/analytics/devguides/reporting/core/v4/basics#sampling) for details.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String samplingLevel;

  /**
   * Segment the data returned for the request. A segment definition helps look at a subset of the
   * segment request. A request can contain up to four segments. Every
   * [ReportRequest](#ReportRequest) within a `batchGet` method must contain the same `segments`
   * definition. Requests with segments must have the `ga:segment` dimension.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Segment> segments;

  /**
   * The Analytics [view ID](https://support.google.com/analytics/answer/1009618) from which to
   * retrieve data. Every [ReportRequest](#ReportRequest) within a `batchGet` method must contain
   * the same `viewId`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String viewId;

  /**
   * Cohort group associated with this request. If there is a cohort group in the request the
   * `ga:cohort` dimension must be present. Every [ReportRequest](#ReportRequest) within a
   * `batchGet` method must contain the same `cohortGroup` definition.
   * @return value or {@code null} for none
   */
  public CohortGroup getCohortGroup() {
    return cohortGroup;
  }

  /**
   * Cohort group associated with this request. If there is a cohort group in the request the
   * `ga:cohort` dimension must be present. Every [ReportRequest](#ReportRequest) within a
   * `batchGet` method must contain the same `cohortGroup` definition.
   * @param cohortGroup cohortGroup or {@code null} for none
   */
  public ReportRequest setCohortGroup(CohortGroup cohortGroup) {
    this.cohortGroup = cohortGroup;
    return this;
  }

  /**
   * Date ranges in the request. The request can have a maximum of 2 date ranges. The response will
   * contain a set of metric values for each combination of the dimensions for each date range in
   * the request. So, if there are two date ranges, there will be two set of metric values, one for
   * the original date range and one for the second date range. The `reportRequest.dateRanges` field
   * should not be specified for cohorts or Lifetime value requests. If a date range is not
   * provided, the default date range is (startDate: current date - 7 days, endDate: current date -
   * 1 day). Every [ReportRequest](#ReportRequest) within a `batchGet` method must contain the same
   * `dateRanges` definition.
   * @return value or {@code null} for none
   */
  public java.util.List<DateRange> getDateRanges() {
    return dateRanges;
  }

  /**
   * Date ranges in the request. The request can have a maximum of 2 date ranges. The response will
   * contain a set of metric values for each combination of the dimensions for each date range in
   * the request. So, if there are two date ranges, there will be two set of metric values, one for
   * the original date range and one for the second date range. The `reportRequest.dateRanges` field
   * should not be specified for cohorts or Lifetime value requests. If a date range is not
   * provided, the default date range is (startDate: current date - 7 days, endDate: current date -
   * 1 day). Every [ReportRequest](#ReportRequest) within a `batchGet` method must contain the same
   * `dateRanges` definition.
   * @param dateRanges dateRanges or {@code null} for none
   */
  public ReportRequest setDateRanges(java.util.List<DateRange> dateRanges) {
    this.dateRanges = dateRanges;
    return this;
  }

  /**
   * The dimension filter clauses for filtering Dimension Values. They are logically combined with
   * the `AND` operator. Note that filtering occurs before any dimensions are aggregated, so that
   * the returned metrics represent the total for only the relevant dimensions.
   * @return value or {@code null} for none
   */
  public java.util.List<DimensionFilterClause> getDimensionFilterClauses() {
    return dimensionFilterClauses;
  }

  /**
   * The dimension filter clauses for filtering Dimension Values. They are logically combined with
   * the `AND` operator. Note that filtering occurs before any dimensions are aggregated, so that
   * the returned metrics represent the total for only the relevant dimensions.
   * @param dimensionFilterClauses dimensionFilterClauses or {@code null} for none
   */
  public ReportRequest setDimensionFilterClauses(java.util.List<DimensionFilterClause> dimensionFilterClauses) {
    this.dimensionFilterClauses = dimensionFilterClauses;
    return this;
  }

  /**
   * The dimensions requested. Requests can have a total of 9 dimensions.
   * @return value or {@code null} for none
   */
  public java.util.List<Dimension> getDimensions() {
    return dimensions;
  }

  /**
   * The dimensions requested. Requests can have a total of 9 dimensions.
   * @param dimensions dimensions or {@code null} for none
   */
  public ReportRequest setDimensions(java.util.List<Dimension> dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  /**
   * Dimension or metric filters that restrict the data returned for your request. To use the
   * `filtersExpression`, supply a dimension or metric on which to filter, followed by the filter
   * expression. For example, the following expression selects `ga:browser` dimension which starts
   * with Firefox; `ga:browser=~^Firefox`. For more information on dimensions and metric filters,
   * see [Filters reference](https://developers.google.com/analytics/devguides/reporting/core/v3/ref
   * erence#filters).
   * @return value or {@code null} for none
   */
  public java.lang.String getFiltersExpression() {
    return filtersExpression;
  }

  /**
   * Dimension or metric filters that restrict the data returned for your request. To use the
   * `filtersExpression`, supply a dimension or metric on which to filter, followed by the filter
   * expression. For example, the following expression selects `ga:browser` dimension which starts
   * with Firefox; `ga:browser=~^Firefox`. For more information on dimensions and metric filters,
   * see [Filters reference](https://developers.google.com/analytics/devguides/reporting/core/v3/ref
   * erence#filters).
   * @param filtersExpression filtersExpression or {@code null} for none
   */
  public ReportRequest setFiltersExpression(java.lang.String filtersExpression) {
    this.filtersExpression = filtersExpression;
    return this;
  }

  /**
   * If set to true, hides the total of all metrics for all the matching rows, for every date range.
   * The default false and will return the totals.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHideTotals() {
    return hideTotals;
  }

  /**
   * If set to true, hides the total of all metrics for all the matching rows, for every date range.
   * The default false and will return the totals.
   * @param hideTotals hideTotals or {@code null} for none
   */
  public ReportRequest setHideTotals(java.lang.Boolean hideTotals) {
    this.hideTotals = hideTotals;
    return this;
  }

  /**
   * If set to true, hides the minimum and maximum across all matching rows. The default is false
   * and the value ranges are returned.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHideValueRanges() {
    return hideValueRanges;
  }

  /**
   * If set to true, hides the minimum and maximum across all matching rows. The default is false
   * and the value ranges are returned.
   * @param hideValueRanges hideValueRanges or {@code null} for none
   */
  public ReportRequest setHideValueRanges(java.lang.Boolean hideValueRanges) {
    this.hideValueRanges = hideValueRanges;
    return this;
  }

  /**
   * If set to false, the response does not include rows if all the retrieved metrics are equal to
   * zero. The default is false which will exclude these rows.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIncludeEmptyRows() {
    return includeEmptyRows;
  }

  /**
   * If set to false, the response does not include rows if all the retrieved metrics are equal to
   * zero. The default is false which will exclude these rows.
   * @param includeEmptyRows includeEmptyRows or {@code null} for none
   */
  public ReportRequest setIncludeEmptyRows(java.lang.Boolean includeEmptyRows) {
    this.includeEmptyRows = includeEmptyRows;
    return this;
  }

  /**
   * The metric filter clauses. They are logically combined with the `AND` operator. Metric filters
   * look at only the first date range and not the comparing date range. Note that filtering on
   * metrics occurs after the metrics are aggregated.
   * @return value or {@code null} for none
   */
  public java.util.List<MetricFilterClause> getMetricFilterClauses() {
    return metricFilterClauses;
  }

  /**
   * The metric filter clauses. They are logically combined with the `AND` operator. Metric filters
   * look at only the first date range and not the comparing date range. Note that filtering on
   * metrics occurs after the metrics are aggregated.
   * @param metricFilterClauses metricFilterClauses or {@code null} for none
   */
  public ReportRequest setMetricFilterClauses(java.util.List<MetricFilterClause> metricFilterClauses) {
    this.metricFilterClauses = metricFilterClauses;
    return this;
  }

  /**
   * The metrics requested. Requests must specify at least one metric. Requests can have a total of
   * 10 metrics.
   * @return value or {@code null} for none
   */
  public java.util.List<Metric> getMetrics() {
    return metrics;
  }

  /**
   * The metrics requested. Requests must specify at least one metric. Requests can have a total of
   * 10 metrics.
   * @param metrics metrics or {@code null} for none
   */
  public ReportRequest setMetrics(java.util.List<Metric> metrics) {
    this.metrics = metrics;
    return this;
  }

  /**
   * Sort order on output rows. To compare two rows, the elements of the following are applied in
   * order until a difference is found. All date ranges in the output get the same row order.
   * @return value or {@code null} for none
   */
  public java.util.List<OrderBy> getOrderBys() {
    return orderBys;
  }

  /**
   * Sort order on output rows. To compare two rows, the elements of the following are applied in
   * order until a difference is found. All date ranges in the output get the same row order.
   * @param orderBys orderBys or {@code null} for none
   */
  public ReportRequest setOrderBys(java.util.List<OrderBy> orderBys) {
    this.orderBys = orderBys;
    return this;
  }

  /**
   * Page size is for paging and specifies the maximum number of returned rows. Page size should be
   * >= 0. A query returns the default of 1,000 rows. The Analytics Core Reporting API returns a
   * maximum of 100,000 rows per request, no matter how many you ask for. It can also return fewer
   * rows than requested, if there aren't as many dimension segments as you expect. For instance,
   * there are fewer than 300 possible values for `ga:country`, so when segmenting only by country,
   * you can't get more than 300 rows, even if you set `pageSize` to a higher value.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPageSize() {
    return pageSize;
  }

  /**
   * Page size is for paging and specifies the maximum number of returned rows. Page size should be
   * >= 0. A query returns the default of 1,000 rows. The Analytics Core Reporting API returns a
   * maximum of 100,000 rows per request, no matter how many you ask for. It can also return fewer
   * rows than requested, if there aren't as many dimension segments as you expect. For instance,
   * there are fewer than 300 possible values for `ga:country`, so when segmenting only by country,
   * you can't get more than 300 rows, even if you set `pageSize` to a higher value.
   * @param pageSize pageSize or {@code null} for none
   */
  public ReportRequest setPageSize(java.lang.Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

  /**
   * A continuation token to get the next page of the results. Adding this to the request will
   * return the rows after the pageToken. The pageToken should be the value returned in the
   * nextPageToken parameter in the response to the GetReports request.
   * @return value or {@code null} for none
   */
  public java.lang.String getPageToken() {
    return pageToken;
  }

  /**
   * A continuation token to get the next page of the results. Adding this to the request will
   * return the rows after the pageToken. The pageToken should be the value returned in the
   * nextPageToken parameter in the response to the GetReports request.
   * @param pageToken pageToken or {@code null} for none
   */
  public ReportRequest setPageToken(java.lang.String pageToken) {
    this.pageToken = pageToken;
    return this;
  }

  /**
   * The pivot definitions. Requests can have a maximum of 2 pivots.
   * @return value or {@code null} for none
   */
  public java.util.List<Pivot> getPivots() {
    return pivots;
  }

  /**
   * The pivot definitions. Requests can have a maximum of 2 pivots.
   * @param pivots pivots or {@code null} for none
   */
  public ReportRequest setPivots(java.util.List<Pivot> pivots) {
    this.pivots = pivots;
    return this;
  }

  /**
   * The desired report [sample](https://support.google.com/analytics/answer/2637192) size. If the
   * the `samplingLevel` field is unspecified the `DEFAULT` sampling level is used. Every
   * [ReportRequest](#ReportRequest) within a `batchGet` method must contain the same
   * `samplingLevel` definition. See [developer
   * guide](/analytics/devguides/reporting/core/v4/basics#sampling) for details.
   * @return value or {@code null} for none
   */
  public java.lang.String getSamplingLevel() {
    return samplingLevel;
  }

  /**
   * The desired report [sample](https://support.google.com/analytics/answer/2637192) size. If the
   * the `samplingLevel` field is unspecified the `DEFAULT` sampling level is used. Every
   * [ReportRequest](#ReportRequest) within a `batchGet` method must contain the same
   * `samplingLevel` definition. See [developer
   * guide](/analytics/devguides/reporting/core/v4/basics#sampling) for details.
   * @param samplingLevel samplingLevel or {@code null} for none
   */
  public ReportRequest setSamplingLevel(java.lang.String samplingLevel) {
    this.samplingLevel = samplingLevel;
    return this;
  }

  /**
   * Segment the data returned for the request. A segment definition helps look at a subset of the
   * segment request. A request can contain up to four segments. Every
   * [ReportRequest](#ReportRequest) within a `batchGet` method must contain the same `segments`
   * definition. Requests with segments must have the `ga:segment` dimension.
   * @return value or {@code null} for none
   */
  public java.util.List<Segment> getSegments() {
    return segments;
  }

  /**
   * Segment the data returned for the request. A segment definition helps look at a subset of the
   * segment request. A request can contain up to four segments. Every
   * [ReportRequest](#ReportRequest) within a `batchGet` method must contain the same `segments`
   * definition. Requests with segments must have the `ga:segment` dimension.
   * @param segments segments or {@code null} for none
   */
  public ReportRequest setSegments(java.util.List<Segment> segments) {
    this.segments = segments;
    return this;
  }

  /**
   * The Analytics [view ID](https://support.google.com/analytics/answer/1009618) from which to
   * retrieve data. Every [ReportRequest](#ReportRequest) within a `batchGet` method must contain
   * the same `viewId`.
   * @return value or {@code null} for none
   */
  public java.lang.String getViewId() {
    return viewId;
  }

  /**
   * The Analytics [view ID](https://support.google.com/analytics/answer/1009618) from which to
   * retrieve data. Every [ReportRequest](#ReportRequest) within a `batchGet` method must contain
   * the same `viewId`.
   * @param viewId viewId or {@code null} for none
   */
  public ReportRequest setViewId(java.lang.String viewId) {
    this.viewId = viewId;
    return this;
  }

  @Override
  public ReportRequest set(String fieldName, Object value) {
    return (ReportRequest) super.set(fieldName, value);
  }

  @Override
  public ReportRequest clone() {
    return (ReportRequest) super.clone();
  }

}
