/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * Details of the products in an e-commerce transaction.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ProductData extends com.google.api.client.json.GenericJson {

  /**
   * The total revenue from purchased product items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double itemRevenue;

  /**
   * The product name, supplied by the e-commerce tracking application, for the purchased items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String productName;

  /**
   * Total number of this product units in the transaction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long productQuantity;

  /**
   * Unique code that represents the product.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String productSku;

  /**
   * The total revenue from purchased product items.
   * @return value or {@code null} for none
   */
  public java.lang.Double getItemRevenue() {
    return itemRevenue;
  }

  /**
   * The total revenue from purchased product items.
   * @param itemRevenue itemRevenue or {@code null} for none
   */
  public ProductData setItemRevenue(java.lang.Double itemRevenue) {
    this.itemRevenue = itemRevenue;
    return this;
  }

  /**
   * The product name, supplied by the e-commerce tracking application, for the purchased items.
   * @return value or {@code null} for none
   */
  public java.lang.String getProductName() {
    return productName;
  }

  /**
   * The product name, supplied by the e-commerce tracking application, for the purchased items.
   * @param productName productName or {@code null} for none
   */
  public ProductData setProductName(java.lang.String productName) {
    this.productName = productName;
    return this;
  }

  /**
   * Total number of this product units in the transaction.
   * @return value or {@code null} for none
   */
  public java.lang.Long getProductQuantity() {
    return productQuantity;
  }

  /**
   * Total number of this product units in the transaction.
   * @param productQuantity productQuantity or {@code null} for none
   */
  public ProductData setProductQuantity(java.lang.Long productQuantity) {
    this.productQuantity = productQuantity;
    return this;
  }

  /**
   * Unique code that represents the product.
   * @return value or {@code null} for none
   */
  public java.lang.String getProductSku() {
    return productSku;
  }

  /**
   * Unique code that represents the product.
   * @param productSku productSku or {@code null} for none
   */
  public ProductData setProductSku(java.lang.String productSku) {
    this.productSku = productSku;
    return this;
  }

  @Override
  public ProductData set(String fieldName, Object value) {
    return (ProductData) super.set(fieldName, value);
  }

  @Override
  public ProductData clone() {
    return (ProductData) super.clone();
  }

}
