/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * Represents details collected when the visitor views a page.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PageviewData extends com.google.api.client.json.GenericJson {

  /**
   * The URL of the page that the visitor viewed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pagePath;

  /**
   * The title of the page that the visitor viewed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String pageTitle;

  /**
   * The URL of the page that the visitor viewed.
   * @return value or {@code null} for none
   */
  public java.lang.String getPagePath() {
    return pagePath;
  }

  /**
   * The URL of the page that the visitor viewed.
   * @param pagePath pagePath or {@code null} for none
   */
  public PageviewData setPagePath(java.lang.String pagePath) {
    this.pagePath = pagePath;
    return this;
  }

  /**
   * The title of the page that the visitor viewed.
   * @return value or {@code null} for none
   */
  public java.lang.String getPageTitle() {
    return pageTitle;
  }

  /**
   * The title of the page that the visitor viewed.
   * @param pageTitle pageTitle or {@code null} for none
   */
  public PageviewData setPageTitle(java.lang.String pageTitle) {
    this.pageTitle = pageTitle;
    return this;
  }

  @Override
  public PageviewData set(String fieldName, Object value) {
    return (PageviewData) super.set(fieldName, value);
  }

  @Override
  public PageviewData clone() {
    return (PageviewData) super.clone();
  }

}
