/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * Specifies the sorting options.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrderBy extends com.google.api.client.json.GenericJson {

  /**
   * The field which to sort by. The default sort order is ascending. Example: `ga:browser`. Note,
   * that you can only specify one field for sort here. For example, `ga:browser, ga:city` is not
   * valid.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fieldName;

  /**
   * The order type. The default orderType is `VALUE`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String orderType;

  /**
   * The sorting order for the field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sortOrder;

  /**
   * The field which to sort by. The default sort order is ascending. Example: `ga:browser`. Note,
   * that you can only specify one field for sort here. For example, `ga:browser, ga:city` is not
   * valid.
   * @return value or {@code null} for none
   */
  public java.lang.String getFieldName() {
    return fieldName;
  }

  /**
   * The field which to sort by. The default sort order is ascending. Example: `ga:browser`. Note,
   * that you can only specify one field for sort here. For example, `ga:browser, ga:city` is not
   * valid.
   * @param fieldName fieldName or {@code null} for none
   */
  public OrderBy setFieldName(java.lang.String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

  /**
   * The order type. The default orderType is `VALUE`.
   * @return value or {@code null} for none
   */
  public java.lang.String getOrderType() {
    return orderType;
  }

  /**
   * The order type. The default orderType is `VALUE`.
   * @param orderType orderType or {@code null} for none
   */
  public OrderBy setOrderType(java.lang.String orderType) {
    this.orderType = orderType;
    return this;
  }

  /**
   * The sorting order for the field.
   * @return value or {@code null} for none
   */
  public java.lang.String getSortOrder() {
    return sortOrder;
  }

  /**
   * The sorting order for the field.
   * @param sortOrder sortOrder or {@code null} for none
   */
  public OrderBy setSortOrder(java.lang.String sortOrder) {
    this.sortOrder = sortOrder;
    return this;
  }

  @Override
  public OrderBy set(String fieldName, Object value) {
    return (OrderBy) super.set(fieldName, value);
  }

  @Override
  public OrderBy clone() {
    return (OrderBy) super.clone();
  }

}
