/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * A list of segment filters in the `OR` group are combined with the logical OR operator.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrFiltersForSegment extends com.google.api.client.json.GenericJson {

  /**
   * List of segment filters to be combined with a `OR` operator.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<SegmentFilterClause> segmentFilterClauses;

  /**
   * List of segment filters to be combined with a `OR` operator.
   * @return value or {@code null} for none
   */
  public java.util.List<SegmentFilterClause> getSegmentFilterClauses() {
    return segmentFilterClauses;
  }

  /**
   * List of segment filters to be combined with a `OR` operator.
   * @param segmentFilterClauses segmentFilterClauses or {@code null} for none
   */
  public OrFiltersForSegment setSegmentFilterClauses(java.util.List<SegmentFilterClause> segmentFilterClauses) {
    this.segmentFilterClauses = segmentFilterClauses;
    return this;
  }

  @Override
  public OrFiltersForSegment set(String fieldName, Object value) {
    return (OrFiltersForSegment) super.set(fieldName, value);
  }

  @Override
  public OrFiltersForSegment clone() {
    return (OrFiltersForSegment) super.clone();
  }

}
