/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * [Metrics](https://support.google.com/analytics/answer/1033861) are the quantitative measurements.
 * For example, the metric `ga:users` indicates the total number of users for the requested time
 * period.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Metric extends com.google.api.client.json.GenericJson {

  /**
   * An alias for the metric expression is an alternate name for the expression. The alias can be
   * used for filtering and sorting. This field is optional and is useful if the expression is not a
   * single metric but a complex expression which cannot be used in filtering and sorting. The alias
   * is also used in the response column header.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String alias;

  /**
   * A metric expression in the request. An expression is constructed from one or more metrics and
   * numbers. Accepted operators include: Plus (+), Minus (-), Negation (Unary -), Divided by (/),
   * Multiplied by (*), Parenthesis, Positive cardinal numbers (0-9), can include decimals and is
   * limited to 1024 characters. Example `ga:totalRefunds/ga:users`, in most cases the metric
   * expression is just a single metric name like `ga:users`. Adding mixed `MetricType` (E.g.,
   * `CURRENCY` + `PERCENTAGE`) metrics will result in unexpected results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String expression;

  /**
   * Specifies how the metric expression should be formatted, for example `INTEGER`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formattingType;

  /**
   * An alias for the metric expression is an alternate name for the expression. The alias can be
   * used for filtering and sorting. This field is optional and is useful if the expression is not a
   * single metric but a complex expression which cannot be used in filtering and sorting. The alias
   * is also used in the response column header.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlias() {
    return alias;
  }

  /**
   * An alias for the metric expression is an alternate name for the expression. The alias can be
   * used for filtering and sorting. This field is optional and is useful if the expression is not a
   * single metric but a complex expression which cannot be used in filtering and sorting. The alias
   * is also used in the response column header.
   * @param alias alias or {@code null} for none
   */
  public Metric setAlias(java.lang.String alias) {
    this.alias = alias;
    return this;
  }

  /**
   * A metric expression in the request. An expression is constructed from one or more metrics and
   * numbers. Accepted operators include: Plus (+), Minus (-), Negation (Unary -), Divided by (/),
   * Multiplied by (*), Parenthesis, Positive cardinal numbers (0-9), can include decimals and is
   * limited to 1024 characters. Example `ga:totalRefunds/ga:users`, in most cases the metric
   * expression is just a single metric name like `ga:users`. Adding mixed `MetricType` (E.g.,
   * `CURRENCY` + `PERCENTAGE`) metrics will result in unexpected results.
   * @return value or {@code null} for none
   */
  public java.lang.String getExpression() {
    return expression;
  }

  /**
   * A metric expression in the request. An expression is constructed from one or more metrics and
   * numbers. Accepted operators include: Plus (+), Minus (-), Negation (Unary -), Divided by (/),
   * Multiplied by (*), Parenthesis, Positive cardinal numbers (0-9), can include decimals and is
   * limited to 1024 characters. Example `ga:totalRefunds/ga:users`, in most cases the metric
   * expression is just a single metric name like `ga:users`. Adding mixed `MetricType` (E.g.,
   * `CURRENCY` + `PERCENTAGE`) metrics will result in unexpected results.
   * @param expression expression or {@code null} for none
   */
  public Metric setExpression(java.lang.String expression) {
    this.expression = expression;
    return this;
  }

  /**
   * Specifies how the metric expression should be formatted, for example `INTEGER`.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormattingType() {
    return formattingType;
  }

  /**
   * Specifies how the metric expression should be formatted, for example `INTEGER`.
   * @param formattingType formattingType or {@code null} for none
   */
  public Metric setFormattingType(java.lang.String formattingType) {
    this.formattingType = formattingType;
    return this;
  }

  @Override
  public Metric set(String fieldName, Object value) {
    return (Metric) super.set(fieldName, value);
  }

  @Override
  public Metric clone() {
    return (Metric) super.clone();
  }

}
