/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4.model;

/**
 * An Activity represents data for an activity of a user. Note that an Activity is different from a
 * hit. A hit might result in multiple Activity's. For example, if a hit includes a transaction and
 * a goal completion, there will be two Activity protos for this hit, one for ECOMMERCE and one for
 * GOAL. Conversely, multiple hits can also construct one Activity. In classic e-commerce, data for
 * one transaction might be sent through multiple hits. These hits will be merged into one ECOMMERCE
 * Activity.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Analytics Reporting API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Activity extends com.google.api.client.json.GenericJson {

  /**
   * Timestamp of the activity. If activities for a visit cross midnight and occur in two separate
   * dates, then two sessions (one per date) share the session identifier. For example, say session
   * ID 113472 has activity within 2019-08-20, and session ID 243742 has activity within 2019-08-25
   * and 2019-08-26. Session ID 113472 is one session, and session ID 243742 is two sessions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String activityTime;

  /**
   * Type of this activity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String activityType;

  /**
   * This will be set if `activity_type` equals `SCREEN_VIEW`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ScreenviewData appview;

  /**
   * For manual campaign tracking, it is the value of the utm_campaign campaign tracking parameter.
   * For AdWords autotagging, it is the name(s) of the online ad campaign(s) you use for the
   * property. If you use neither, its value is (not set).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String campaign;

  /**
   * The Channel Group associated with an end user's session for this View (defined by the View's
   * Channel Groupings).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String channelGrouping;

  /**
   * A list of all custom dimensions associated with this activity.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CustomDimension> customDimension;

  /**
   * This will be set if `activity_type` equals `ECOMMERCE`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EcommerceData ecommerce;

  /**
   * This field contains all the details pertaining to an event and will be set if `activity_type`
   * equals `EVENT`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EventData event;

  /**
   * This field contains a list of all the goals that were reached in this activity when
   * `activity_type` equals `GOAL`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GoalSetData goals;

  /**
   * The hostname from which the tracking request was made.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hostname;

  /**
   * For manual campaign tracking, it is the value of the utm_term campaign tracking parameter. For
   * AdWords traffic, it contains the best matching targeting criteria. For the display network,
   * where multiple targeting criteria could have caused the ad to show up, it returns the best
   * matching targeting criteria as selected by Ads. This could be display_keyword, site placement,
   * boomuserlist, user_interest, age, or gender. Otherwise its value is (not set).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String keyword;

  /**
   * The first page in users' sessions, or the landing page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String landingPagePath;

  /**
   * The type of referrals. For manual campaign tracking, it is the value of the utm_medium campaign
   * tracking parameter. For AdWords autotagging, it is cpc. If users came from a search engine
   * detected by Google Analytics, it is organic. If the referrer is not a search engine, it is
   * referral. If users came directly to the property and document.referrer is empty, its value is
   * (none).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String medium;

  /**
   * This will be set if `activity_type` equals `PAGEVIEW`. This field contains all the details
   * about the visitor and the page that was visited.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PageviewData pageview;

  /**
   * The source of referrals. For manual campaign tracking, it is the value of the utm_source
   * campaign tracking parameter. For AdWords autotagging, it is google. If you use neither, it is
   * the domain of the source (e.g., document.referrer) referring the users. It may also contain a
   * port address. If users arrived without a referrer, its value is (direct).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String source;

  /**
   * Timestamp of the activity. If activities for a visit cross midnight and occur in two separate
   * dates, then two sessions (one per date) share the session identifier. For example, say session
   * ID 113472 has activity within 2019-08-20, and session ID 243742 has activity within 2019-08-25
   * and 2019-08-26. Session ID 113472 is one session, and session ID 243742 is two sessions.
   * @return value or {@code null} for none
   */
  public String getActivityTime() {
    return activityTime;
  }

  /**
   * Timestamp of the activity. If activities for a visit cross midnight and occur in two separate
   * dates, then two sessions (one per date) share the session identifier. For example, say session
   * ID 113472 has activity within 2019-08-20, and session ID 243742 has activity within 2019-08-25
   * and 2019-08-26. Session ID 113472 is one session, and session ID 243742 is two sessions.
   * @param activityTime activityTime or {@code null} for none
   */
  public Activity setActivityTime(String activityTime) {
    this.activityTime = activityTime;
    return this;
  }

  /**
   * Type of this activity.
   * @return value or {@code null} for none
   */
  public java.lang.String getActivityType() {
    return activityType;
  }

  /**
   * Type of this activity.
   * @param activityType activityType or {@code null} for none
   */
  public Activity setActivityType(java.lang.String activityType) {
    this.activityType = activityType;
    return this;
  }

  /**
   * This will be set if `activity_type` equals `SCREEN_VIEW`.
   * @return value or {@code null} for none
   */
  public ScreenviewData getAppview() {
    return appview;
  }

  /**
   * This will be set if `activity_type` equals `SCREEN_VIEW`.
   * @param appview appview or {@code null} for none
   */
  public Activity setAppview(ScreenviewData appview) {
    this.appview = appview;
    return this;
  }

  /**
   * For manual campaign tracking, it is the value of the utm_campaign campaign tracking parameter.
   * For AdWords autotagging, it is the name(s) of the online ad campaign(s) you use for the
   * property. If you use neither, its value is (not set).
   * @return value or {@code null} for none
   */
  public java.lang.String getCampaign() {
    return campaign;
  }

  /**
   * For manual campaign tracking, it is the value of the utm_campaign campaign tracking parameter.
   * For AdWords autotagging, it is the name(s) of the online ad campaign(s) you use for the
   * property. If you use neither, its value is (not set).
   * @param campaign campaign or {@code null} for none
   */
  public Activity setCampaign(java.lang.String campaign) {
    this.campaign = campaign;
    return this;
  }

  /**
   * The Channel Group associated with an end user's session for this View (defined by the View's
   * Channel Groupings).
   * @return value or {@code null} for none
   */
  public java.lang.String getChannelGrouping() {
    return channelGrouping;
  }

  /**
   * The Channel Group associated with an end user's session for this View (defined by the View's
   * Channel Groupings).
   * @param channelGrouping channelGrouping or {@code null} for none
   */
  public Activity setChannelGrouping(java.lang.String channelGrouping) {
    this.channelGrouping = channelGrouping;
    return this;
  }

  /**
   * A list of all custom dimensions associated with this activity.
   * @return value or {@code null} for none
   */
  public java.util.List<CustomDimension> getCustomDimension() {
    return customDimension;
  }

  /**
   * A list of all custom dimensions associated with this activity.
   * @param customDimension customDimension or {@code null} for none
   */
  public Activity setCustomDimension(java.util.List<CustomDimension> customDimension) {
    this.customDimension = customDimension;
    return this;
  }

  /**
   * This will be set if `activity_type` equals `ECOMMERCE`.
   * @return value or {@code null} for none
   */
  public EcommerceData getEcommerce() {
    return ecommerce;
  }

  /**
   * This will be set if `activity_type` equals `ECOMMERCE`.
   * @param ecommerce ecommerce or {@code null} for none
   */
  public Activity setEcommerce(EcommerceData ecommerce) {
    this.ecommerce = ecommerce;
    return this;
  }

  /**
   * This field contains all the details pertaining to an event and will be set if `activity_type`
   * equals `EVENT`.
   * @return value or {@code null} for none
   */
  public EventData getEvent() {
    return event;
  }

  /**
   * This field contains all the details pertaining to an event and will be set if `activity_type`
   * equals `EVENT`.
   * @param event event or {@code null} for none
   */
  public Activity setEvent(EventData event) {
    this.event = event;
    return this;
  }

  /**
   * This field contains a list of all the goals that were reached in this activity when
   * `activity_type` equals `GOAL`.
   * @return value or {@code null} for none
   */
  public GoalSetData getGoals() {
    return goals;
  }

  /**
   * This field contains a list of all the goals that were reached in this activity when
   * `activity_type` equals `GOAL`.
   * @param goals goals or {@code null} for none
   */
  public Activity setGoals(GoalSetData goals) {
    this.goals = goals;
    return this;
  }

  /**
   * The hostname from which the tracking request was made.
   * @return value or {@code null} for none
   */
  public java.lang.String getHostname() {
    return hostname;
  }

  /**
   * The hostname from which the tracking request was made.
   * @param hostname hostname or {@code null} for none
   */
  public Activity setHostname(java.lang.String hostname) {
    this.hostname = hostname;
    return this;
  }

  /**
   * For manual campaign tracking, it is the value of the utm_term campaign tracking parameter. For
   * AdWords traffic, it contains the best matching targeting criteria. For the display network,
   * where multiple targeting criteria could have caused the ad to show up, it returns the best
   * matching targeting criteria as selected by Ads. This could be display_keyword, site placement,
   * boomuserlist, user_interest, age, or gender. Otherwise its value is (not set).
   * @return value or {@code null} for none
   */
  public java.lang.String getKeyword() {
    return keyword;
  }

  /**
   * For manual campaign tracking, it is the value of the utm_term campaign tracking parameter. For
   * AdWords traffic, it contains the best matching targeting criteria. For the display network,
   * where multiple targeting criteria could have caused the ad to show up, it returns the best
   * matching targeting criteria as selected by Ads. This could be display_keyword, site placement,
   * boomuserlist, user_interest, age, or gender. Otherwise its value is (not set).
   * @param keyword keyword or {@code null} for none
   */
  public Activity setKeyword(java.lang.String keyword) {
    this.keyword = keyword;
    return this;
  }

  /**
   * The first page in users' sessions, or the landing page.
   * @return value or {@code null} for none
   */
  public java.lang.String getLandingPagePath() {
    return landingPagePath;
  }

  /**
   * The first page in users' sessions, or the landing page.
   * @param landingPagePath landingPagePath or {@code null} for none
   */
  public Activity setLandingPagePath(java.lang.String landingPagePath) {
    this.landingPagePath = landingPagePath;
    return this;
  }

  /**
   * The type of referrals. For manual campaign tracking, it is the value of the utm_medium campaign
   * tracking parameter. For AdWords autotagging, it is cpc. If users came from a search engine
   * detected by Google Analytics, it is organic. If the referrer is not a search engine, it is
   * referral. If users came directly to the property and document.referrer is empty, its value is
   * (none).
   * @return value or {@code null} for none
   */
  public java.lang.String getMedium() {
    return medium;
  }

  /**
   * The type of referrals. For manual campaign tracking, it is the value of the utm_medium campaign
   * tracking parameter. For AdWords autotagging, it is cpc. If users came from a search engine
   * detected by Google Analytics, it is organic. If the referrer is not a search engine, it is
   * referral. If users came directly to the property and document.referrer is empty, its value is
   * (none).
   * @param medium medium or {@code null} for none
   */
  public Activity setMedium(java.lang.String medium) {
    this.medium = medium;
    return this;
  }

  /**
   * This will be set if `activity_type` equals `PAGEVIEW`. This field contains all the details
   * about the visitor and the page that was visited.
   * @return value or {@code null} for none
   */
  public PageviewData getPageview() {
    return pageview;
  }

  /**
   * This will be set if `activity_type` equals `PAGEVIEW`. This field contains all the details
   * about the visitor and the page that was visited.
   * @param pageview pageview or {@code null} for none
   */
  public Activity setPageview(PageviewData pageview) {
    this.pageview = pageview;
    return this;
  }

  /**
   * The source of referrals. For manual campaign tracking, it is the value of the utm_source
   * campaign tracking parameter. For AdWords autotagging, it is google. If you use neither, it is
   * the domain of the source (e.g., document.referrer) referring the users. It may also contain a
   * port address. If users arrived without a referrer, its value is (direct).
   * @return value or {@code null} for none
   */
  public java.lang.String getSource() {
    return source;
  }

  /**
   * The source of referrals. For manual campaign tracking, it is the value of the utm_source
   * campaign tracking parameter. For AdWords autotagging, it is google. If you use neither, it is
   * the domain of the source (e.g., document.referrer) referring the users. It may also contain a
   * port address. If users arrived without a referrer, its value is (direct).
   * @param source source or {@code null} for none
   */
  public Activity setSource(java.lang.String source) {
    this.source = source;
    return this;
  }

  @Override
  public Activity set(String fieldName, Object value) {
    return (Activity) super.set(fieldName, value);
  }

  @Override
  public Activity clone() {
    return (Activity) super.clone();
  }

}
