/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.analyticsreporting.v4;

/**
 * Service definition for AnalyticsReporting (v4).
 *
 * <p>
 * Accesses Analytics report data.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/analytics/devguides/reporting/core/v4/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link AnalyticsReportingRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class AnalyticsReporting extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the Analytics Reporting API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://analyticsreporting.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://analyticsreporting.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public AnalyticsReporting(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  AnalyticsReporting(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Reports collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code AnalyticsReporting analyticsreporting = new AnalyticsReporting(...);}
   *   {@code AnalyticsReporting.Reports.List request = analyticsreporting.reports().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Reports reports() {
    return new Reports();
  }

  /**
   * The "reports" collection of methods.
   */
  public class Reports {

    /**
     * Returns the Analytics data.
     *
     * Create a request for the method "reports.batchGet".
     *
     * This request holds the parameters needed by the analyticsreporting server.  After setting any
     * optional parameters, call the {@link BatchGet#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.analyticsreporting.v4.model.GetReportsRequest}
     * @return the request
     */
    public BatchGet batchGet(com.google.api.services.analyticsreporting.v4.model.GetReportsRequest content) throws java.io.IOException {
      BatchGet result = new BatchGet(content);
      initialize(result);
      return result;
    }

    public class BatchGet extends AnalyticsReportingRequest<com.google.api.services.analyticsreporting.v4.model.GetReportsResponse> {

      private static final String REST_PATH = "v4/reports:batchGet";

      /**
       * Returns the Analytics data.
       *
       * Create a request for the method "reports.batchGet".
       *
       * This request holds the parameters needed by the the analyticsreporting server.  After setting
       * any optional parameters, call the {@link BatchGet#execute()} method to invoke the remote
       * operation. <p> {@link
       * BatchGet#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.analyticsreporting.v4.model.GetReportsRequest}
       * @since 1.13
       */
      protected BatchGet(com.google.api.services.analyticsreporting.v4.model.GetReportsRequest content) {
        super(AnalyticsReporting.this, "POST", REST_PATH, content, com.google.api.services.analyticsreporting.v4.model.GetReportsResponse.class);
      }

      @Override
      public BatchGet set$Xgafv(java.lang.String $Xgafv) {
        return (BatchGet) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchGet setAccessToken(java.lang.String accessToken) {
        return (BatchGet) super.setAccessToken(accessToken);
      }

      @Override
      public BatchGet setAlt(java.lang.String alt) {
        return (BatchGet) super.setAlt(alt);
      }

      @Override
      public BatchGet setCallback(java.lang.String callback) {
        return (BatchGet) super.setCallback(callback);
      }

      @Override
      public BatchGet setFields(java.lang.String fields) {
        return (BatchGet) super.setFields(fields);
      }

      @Override
      public BatchGet setKey(java.lang.String key) {
        return (BatchGet) super.setKey(key);
      }

      @Override
      public BatchGet setOauthToken(java.lang.String oauthToken) {
        return (BatchGet) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchGet setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchGet) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchGet setQuotaUser(java.lang.String quotaUser) {
        return (BatchGet) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchGet setUploadType(java.lang.String uploadType) {
        return (BatchGet) super.setUploadType(uploadType);
      }

      @Override
      public BatchGet setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchGet) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public BatchGet set(String parameterName, Object value) {
        return (BatchGet) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the UserActivity collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code AnalyticsReporting analyticsreporting = new AnalyticsReporting(...);}
   *   {@code AnalyticsReporting.UserActivity.List request = analyticsreporting.userActivity().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public UserActivity userActivity() {
    return new UserActivity();
  }

  /**
   * The "userActivity" collection of methods.
   */
  public class UserActivity {

    /**
     * Returns User Activity data.
     *
     * Create a request for the method "userActivity.search".
     *
     * This request holds the parameters needed by the analyticsreporting server.  After setting any
     * optional parameters, call the {@link Search#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.analyticsreporting.v4.model.SearchUserActivityRequest}
     * @return the request
     */
    public Search search(com.google.api.services.analyticsreporting.v4.model.SearchUserActivityRequest content) throws java.io.IOException {
      Search result = new Search(content);
      initialize(result);
      return result;
    }

    public class Search extends AnalyticsReportingRequest<com.google.api.services.analyticsreporting.v4.model.SearchUserActivityResponse> {

      private static final String REST_PATH = "v4/userActivity:search";

      /**
       * Returns User Activity data.
       *
       * Create a request for the method "userActivity.search".
       *
       * This request holds the parameters needed by the the analyticsreporting server.  After setting
       * any optional parameters, call the {@link Search#execute()} method to invoke the remote
       * operation. <p> {@link
       * Search#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.analyticsreporting.v4.model.SearchUserActivityRequest}
       * @since 1.13
       */
      protected Search(com.google.api.services.analyticsreporting.v4.model.SearchUserActivityRequest content) {
        super(AnalyticsReporting.this, "POST", REST_PATH, content, com.google.api.services.analyticsreporting.v4.model.SearchUserActivityResponse.class);
      }

      @Override
      public Search set$Xgafv(java.lang.String $Xgafv) {
        return (Search) super.set$Xgafv($Xgafv);
      }

      @Override
      public Search setAccessToken(java.lang.String accessToken) {
        return (Search) super.setAccessToken(accessToken);
      }

      @Override
      public Search setAlt(java.lang.String alt) {
        return (Search) super.setAlt(alt);
      }

      @Override
      public Search setCallback(java.lang.String callback) {
        return (Search) super.setCallback(callback);
      }

      @Override
      public Search setFields(java.lang.String fields) {
        return (Search) super.setFields(fields);
      }

      @Override
      public Search setKey(java.lang.String key) {
        return (Search) super.setKey(key);
      }

      @Override
      public Search setOauthToken(java.lang.String oauthToken) {
        return (Search) super.setOauthToken(oauthToken);
      }

      @Override
      public Search setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Search) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Search setQuotaUser(java.lang.String quotaUser) {
        return (Search) super.setQuotaUser(quotaUser);
      }

      @Override
      public Search setUploadType(java.lang.String uploadType) {
        return (Search) super.setUploadType(uploadType);
      }

      @Override
      public Search setUploadProtocol(java.lang.String uploadProtocol) {
        return (Search) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Search set(String parameterName, Object value) {
        return (Search) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link AnalyticsReporting}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link AnalyticsReporting}. */
    @Override
    public AnalyticsReporting build() {
      return new AnalyticsReporting(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link AnalyticsReportingRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setAnalyticsReportingRequestInitializer(
        AnalyticsReportingRequestInitializer analyticsreportingRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(analyticsreportingRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
