/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.analytics;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.analytics.AnalyticsRequest;
import com.google.api.services.analytics.AnalyticsRequestInitializer;
import com.google.api.services.analytics.model.AccountSummaries;
import com.google.api.services.analytics.model.AccountTicket;
import com.google.api.services.analytics.model.AccountTreeRequest;
import com.google.api.services.analytics.model.AccountTreeResponse;
import com.google.api.services.analytics.model.Accounts;
import com.google.api.services.analytics.model.AnalyticsDataimportDeleteUploadDataRequest;
import com.google.api.services.analytics.model.Columns;
import com.google.api.services.analytics.model.CustomDataSources;
import com.google.api.services.analytics.model.CustomDimension;
import com.google.api.services.analytics.model.CustomDimensions;
import com.google.api.services.analytics.model.CustomMetric;
import com.google.api.services.analytics.model.CustomMetrics;
import com.google.api.services.analytics.model.EntityAdWordsLink;
import com.google.api.services.analytics.model.EntityAdWordsLinks;
import com.google.api.services.analytics.model.EntityUserLink;
import com.google.api.services.analytics.model.EntityUserLinks;
import com.google.api.services.analytics.model.Experiment;
import com.google.api.services.analytics.model.Experiments;
import com.google.api.services.analytics.model.Filter;
import com.google.api.services.analytics.model.Filters;
import com.google.api.services.analytics.model.GaData;
import com.google.api.services.analytics.model.Goal;
import com.google.api.services.analytics.model.Goals;
import com.google.api.services.analytics.model.HashClientIdRequest;
import com.google.api.services.analytics.model.HashClientIdResponse;
import com.google.api.services.analytics.model.McfData;
import com.google.api.services.analytics.model.Profile;
import com.google.api.services.analytics.model.ProfileFilterLink;
import com.google.api.services.analytics.model.ProfileFilterLinks;
import com.google.api.services.analytics.model.Profiles;
import com.google.api.services.analytics.model.RealtimeData;
import com.google.api.services.analytics.model.RemarketingAudience;
import com.google.api.services.analytics.model.RemarketingAudiences;
import com.google.api.services.analytics.model.Segments;
import com.google.api.services.analytics.model.UnsampledReport;
import com.google.api.services.analytics.model.UnsampledReports;
import com.google.api.services.analytics.model.Upload;
import com.google.api.services.analytics.model.Uploads;
import com.google.api.services.analytics.model.UserDeletionRequest;
import com.google.api.services.analytics.model.Webproperties;
import com.google.api.services.analytics.model.Webproperty;
import java.io.IOException;
import java.util.regex.Pattern;

public class Analytics
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://analytics.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://analytics.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "analytics/v3/";
    public static final String DEFAULT_BATCH_PATH = "batch/analytics/v3";
    public static final String DEFAULT_BASE_URL = "https://analytics.googleapis.com/analytics/v3/";

    public Analytics(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Analytics(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Data data() {
        return new Data();
    }

    public Management management() {
        return new Management();
    }

    public Metadata metadata() {
        return new Metadata();
    }

    public Provisioning provisioning() {
        return new Provisioning();
    }

    public UserDeletion userDeletion() {
        return new UserDeletion();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 1.32.1 of the Google Analytics API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Analytics.DEFAULT_MTLS_ROOT_URL;
            }
            return Analytics.DEFAULT_ROOT_URL;
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Analytics.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Analytics.DEFAULT_BATCH_PATH);
        }

        public Analytics build() {
            return new Analytics(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setAnalyticsRequestInitializer(AnalyticsRequestInitializer analyticsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)analyticsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class UserDeletion {
        public UserDeletionRequest userDeletionRequest() {
            return new UserDeletionRequest();
        }

        public class UserDeletionRequest {
            public Upsert upsert(com.google.api.services.analytics.model.UserDeletionRequest content) throws IOException {
                Upsert result = new Upsert(content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Upsert
            extends AnalyticsRequest<com.google.api.services.analytics.model.UserDeletionRequest> {
                private static final String REST_PATH = "userDeletion/userDeletionRequests:upsert";

                protected Upsert(com.google.api.services.analytics.model.UserDeletionRequest content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, com.google.api.services.analytics.model.UserDeletionRequest.class);
                }

                public Upsert setAlt(String alt) {
                    return (Upsert)super.setAlt(alt);
                }

                public Upsert setFields(String fields) {
                    return (Upsert)super.setFields(fields);
                }

                public Upsert setKey(String key) {
                    return (Upsert)super.setKey(key);
                }

                public Upsert setOauthToken(String oauthToken) {
                    return (Upsert)super.setOauthToken(oauthToken);
                }

                public Upsert setPrettyPrint(Boolean prettyPrint) {
                    return (Upsert)super.setPrettyPrint(prettyPrint);
                }

                public Upsert setQuotaUser(String quotaUser) {
                    return (Upsert)super.setQuotaUser(quotaUser);
                }

                public Upsert setUserIp(String userIp) {
                    return (Upsert)super.setUserIp(userIp);
                }

                @Override
                public Upsert set(String parameterName, Object value) {
                    return (Upsert)super.set(parameterName, value);
                }
            }
        }
    }

    public class Provisioning {
        public CreateAccountTicket createAccountTicket(AccountTicket content) throws IOException {
            CreateAccountTicket result = new CreateAccountTicket(content);
            Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public CreateAccountTree createAccountTree(AccountTreeRequest content) throws IOException {
            CreateAccountTree result = new CreateAccountTree(content);
            Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class CreateAccountTree
        extends AnalyticsRequest<AccountTreeResponse> {
            private static final String REST_PATH = "provisioning/createAccountTree";

            protected CreateAccountTree(AccountTreeRequest content) {
                super(Analytics.this, "POST", REST_PATH, (Object)content, AccountTreeResponse.class);
            }

            public CreateAccountTree setAlt(String alt) {
                return (CreateAccountTree)super.setAlt(alt);
            }

            public CreateAccountTree setFields(String fields) {
                return (CreateAccountTree)super.setFields(fields);
            }

            public CreateAccountTree setKey(String key) {
                return (CreateAccountTree)super.setKey(key);
            }

            public CreateAccountTree setOauthToken(String oauthToken) {
                return (CreateAccountTree)super.setOauthToken(oauthToken);
            }

            public CreateAccountTree setPrettyPrint(Boolean prettyPrint) {
                return (CreateAccountTree)super.setPrettyPrint(prettyPrint);
            }

            public CreateAccountTree setQuotaUser(String quotaUser) {
                return (CreateAccountTree)super.setQuotaUser(quotaUser);
            }

            public CreateAccountTree setUserIp(String userIp) {
                return (CreateAccountTree)super.setUserIp(userIp);
            }

            @Override
            public CreateAccountTree set(String parameterName, Object value) {
                return (CreateAccountTree)super.set(parameterName, value);
            }
        }

        public class CreateAccountTicket
        extends AnalyticsRequest<AccountTicket> {
            private static final String REST_PATH = "provisioning/createAccountTicket";

            protected CreateAccountTicket(AccountTicket content) {
                super(Analytics.this, "POST", REST_PATH, (Object)content, AccountTicket.class);
            }

            public CreateAccountTicket setAlt(String alt) {
                return (CreateAccountTicket)super.setAlt(alt);
            }

            public CreateAccountTicket setFields(String fields) {
                return (CreateAccountTicket)super.setFields(fields);
            }

            public CreateAccountTicket setKey(String key) {
                return (CreateAccountTicket)super.setKey(key);
            }

            public CreateAccountTicket setOauthToken(String oauthToken) {
                return (CreateAccountTicket)super.setOauthToken(oauthToken);
            }

            public CreateAccountTicket setPrettyPrint(Boolean prettyPrint) {
                return (CreateAccountTicket)super.setPrettyPrint(prettyPrint);
            }

            public CreateAccountTicket setQuotaUser(String quotaUser) {
                return (CreateAccountTicket)super.setQuotaUser(quotaUser);
            }

            public CreateAccountTicket setUserIp(String userIp) {
                return (CreateAccountTicket)super.setUserIp(userIp);
            }

            @Override
            public CreateAccountTicket set(String parameterName, Object value) {
                return (CreateAccountTicket)super.set(parameterName, value);
            }
        }
    }

    public class Metadata {
        public Columns columns() {
            return new Columns();
        }

        public class Columns {
            public List list(String reportType) throws IOException {
                List result = new List(reportType);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Columns> {
                private static final String REST_PATH = "metadata/{reportType}/columns";
                private final Pattern REPORT_TYPE_PATTERN;
                @Key
                private String reportType;

                protected List(String reportType) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Columns.class);
                    this.REPORT_TYPE_PATTERN = Pattern.compile("ga");
                    this.reportType = (String)Preconditions.checkNotNull((Object)reportType, (Object)"Required parameter reportType must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.REPORT_TYPE_PATTERN.matcher(reportType).matches(), (Object)"Parameter reportType must conform to the pattern ga");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getReportType() {
                    return this.reportType;
                }

                public List setReportType(String reportType) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.REPORT_TYPE_PATTERN.matcher(reportType).matches(), (Object)"Parameter reportType must conform to the pattern ga");
                    }
                    this.reportType = reportType;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }
    }

    public class Management {
        public AccountSummaries accountSummaries() {
            return new AccountSummaries();
        }

        public AccountUserLinks accountUserLinks() {
            return new AccountUserLinks();
        }

        public Accounts accounts() {
            return new Accounts();
        }

        public ClientId clientId() {
            return new ClientId();
        }

        public CustomDataSources customDataSources() {
            return new CustomDataSources();
        }

        public CustomDimensions customDimensions() {
            return new CustomDimensions();
        }

        public CustomMetrics customMetrics() {
            return new CustomMetrics();
        }

        public Experiments experiments() {
            return new Experiments();
        }

        public Filters filters() {
            return new Filters();
        }

        public Goals goals() {
            return new Goals();
        }

        public ProfileFilterLinks profileFilterLinks() {
            return new ProfileFilterLinks();
        }

        public ProfileUserLinks profileUserLinks() {
            return new ProfileUserLinks();
        }

        public Profiles profiles() {
            return new Profiles();
        }

        public RemarketingAudience remarketingAudience() {
            return new RemarketingAudience();
        }

        public Segments segments() {
            return new Segments();
        }

        public UnsampledReports unsampledReports() {
            return new UnsampledReports();
        }

        public Uploads uploads() {
            return new Uploads();
        }

        public WebPropertyAdWordsLinks webPropertyAdWordsLinks() {
            return new WebPropertyAdWordsLinks();
        }

        public Webproperties webproperties() {
            return new Webproperties();
        }

        public WebpropertyUserLinks webpropertyUserLinks() {
            return new WebpropertyUserLinks();
        }

        public class WebpropertyUserLinks {
            public Delete delete(String accountId, String webPropertyId, String linkId) throws IOException {
                Delete result = new Delete(accountId, webPropertyId, linkId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, String webPropertyId, EntityUserLink content) throws IOException {
                Insert result = new Insert(accountId, webPropertyId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId, String webPropertyId) throws IOException {
                List result = new List(accountId, webPropertyId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String webPropertyId, String linkId, EntityUserLink content) throws IOException {
                Update result = new Update(accountId, webPropertyId, linkId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AnalyticsRequest<EntityUserLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityUserLinks/{linkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String linkId;

                protected Update(String accountId, String webPropertyId, String linkId, EntityUserLink content) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)content, EntityUserLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.linkId = (String)Preconditions.checkNotNull((Object)linkId, (Object)"Required parameter linkId must be specified.");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Update setLinkId(String linkId) {
                    this.linkId = linkId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<EntityUserLinks> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityUserLinks";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId, String webPropertyId) {
                    super(Analytics.this, "GET", REST_PATH, null, EntityUserLinks.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<EntityUserLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityUserLinks";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Insert(String accountId, String webPropertyId, EntityUserLink content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, EntityUserLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityUserLinks/{linkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String linkId;

                protected Delete(String accountId, String webPropertyId, String linkId) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.linkId = (String)Preconditions.checkNotNull((Object)linkId, (Object)"Required parameter linkId must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Delete setLinkId(String linkId) {
                    this.linkId = linkId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Webproperties {
            public Get get(String accountId, String webPropertyId) throws IOException {
                Get result = new Get(accountId, webPropertyId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, Webproperty content) throws IOException {
                Insert result = new Insert(accountId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId) throws IOException {
                List result = new List(accountId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String accountId, String webPropertyId, Webproperty content) throws IOException {
                Patch result = new Patch(accountId, webPropertyId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String webPropertyId, Webproperty content) throws IOException {
                Update result = new Update(accountId, webPropertyId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AnalyticsRequest<Webproperty> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Update(String accountId, String webPropertyId, Webproperty content) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)content, Webproperty.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AnalyticsRequest<Webproperty> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Patch(String accountId, String webPropertyId, Webproperty content) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)content, Webproperty.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Webproperties> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties";
                @Key
                private String accountId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Webproperties.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<Webproperty> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties";
                @Key
                private String accountId;

                protected Insert(String accountId, Webproperty content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, Webproperty.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends AnalyticsRequest<Webproperty> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Get(String accountId, String webPropertyId) {
                    super(Analytics.this, "GET", REST_PATH, null, Webproperty.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("[0-9]+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-[0-9]+-[0-9]+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern [0-9]+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-[0-9]+-[0-9]+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern [0-9]+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String webPropertyId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-[0-9]+-[0-9]+");
                    }
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class WebPropertyAdWordsLinks {
            public Delete delete(String accountId, String webPropertyId, String webPropertyAdWordsLinkId) throws IOException {
                Delete result = new Delete(accountId, webPropertyId, webPropertyAdWordsLinkId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String accountId, String webPropertyId, String webPropertyAdWordsLinkId) throws IOException {
                Get result = new Get(accountId, webPropertyId, webPropertyAdWordsLinkId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, String webPropertyId, EntityAdWordsLink content) throws IOException {
                Insert result = new Insert(accountId, webPropertyId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId, String webPropertyId) throws IOException {
                List result = new List(accountId, webPropertyId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String accountId, String webPropertyId, String webPropertyAdWordsLinkId, EntityAdWordsLink content) throws IOException {
                Patch result = new Patch(accountId, webPropertyId, webPropertyAdWordsLinkId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String webPropertyId, String webPropertyAdWordsLinkId, EntityAdWordsLink content) throws IOException {
                Update result = new Update(accountId, webPropertyId, webPropertyAdWordsLinkId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AnalyticsRequest<EntityAdWordsLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks/{webPropertyAdWordsLinkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String webPropertyAdWordsLinkId;

                protected Update(String accountId, String webPropertyId, String webPropertyAdWordsLinkId, EntityAdWordsLink content) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)content, EntityAdWordsLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.webPropertyAdWordsLinkId = (String)Preconditions.checkNotNull((Object)webPropertyAdWordsLinkId, (Object)"Required parameter webPropertyAdWordsLinkId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getName(), "EntityAdWordsLink.getName()");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getWebPropertyAdWordsLinkId() {
                    return this.webPropertyAdWordsLinkId;
                }

                public Update setWebPropertyAdWordsLinkId(String webPropertyAdWordsLinkId) {
                    this.webPropertyAdWordsLinkId = webPropertyAdWordsLinkId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AnalyticsRequest<EntityAdWordsLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks/{webPropertyAdWordsLinkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String webPropertyAdWordsLinkId;

                protected Patch(String accountId, String webPropertyId, String webPropertyAdWordsLinkId, EntityAdWordsLink content) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)content, EntityAdWordsLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.webPropertyAdWordsLinkId = (String)Preconditions.checkNotNull((Object)webPropertyAdWordsLinkId, (Object)"Required parameter webPropertyAdWordsLinkId must be specified.");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getWebPropertyAdWordsLinkId() {
                    return this.webPropertyAdWordsLinkId;
                }

                public Patch setWebPropertyAdWordsLinkId(String webPropertyAdWordsLinkId) {
                    this.webPropertyAdWordsLinkId = webPropertyAdWordsLinkId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<EntityAdWordsLinks> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks";
                private final Pattern ACCOUNT_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId, String webPropertyId) {
                    super(Analytics.this, "GET", REST_PATH, null, EntityAdWordsLinks.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<EntityAdWordsLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Insert(String accountId, String webPropertyId, EntityAdWordsLink content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, EntityAdWordsLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getName(), "EntityAdWordsLink.getName()");
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends AnalyticsRequest<EntityAdWordsLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks/{webPropertyAdWordsLinkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String webPropertyAdWordsLinkId;

                protected Get(String accountId, String webPropertyId, String webPropertyAdWordsLinkId) {
                    super(Analytics.this, "GET", REST_PATH, null, EntityAdWordsLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.webPropertyAdWordsLinkId = (String)Preconditions.checkNotNull((Object)webPropertyAdWordsLinkId, (Object)"Required parameter webPropertyAdWordsLinkId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getWebPropertyAdWordsLinkId() {
                    return this.webPropertyAdWordsLinkId;
                }

                public Get setWebPropertyAdWordsLinkId(String webPropertyAdWordsLinkId) {
                    this.webPropertyAdWordsLinkId = webPropertyAdWordsLinkId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/entityAdWordsLinks/{webPropertyAdWordsLinkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String webPropertyAdWordsLinkId;

                protected Delete(String accountId, String webPropertyId, String webPropertyAdWordsLinkId) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.webPropertyAdWordsLinkId = (String)Preconditions.checkNotNull((Object)webPropertyAdWordsLinkId, (Object)"Required parameter webPropertyAdWordsLinkId must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getWebPropertyAdWordsLinkId() {
                    return this.webPropertyAdWordsLinkId;
                }

                public Delete setWebPropertyAdWordsLinkId(String webPropertyAdWordsLinkId) {
                    this.webPropertyAdWordsLinkId = webPropertyAdWordsLinkId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Uploads {
            public DeleteUploadData deleteUploadData(String accountId, String webPropertyId, String customDataSourceId, AnalyticsDataimportDeleteUploadDataRequest content) throws IOException {
                DeleteUploadData result = new DeleteUploadData(accountId, webPropertyId, customDataSourceId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String accountId, String webPropertyId, String customDataSourceId, String uploadId) throws IOException {
                Get result = new Get(accountId, webPropertyId, customDataSourceId, uploadId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId, String webPropertyId, String customDataSourceId) throws IOException {
                List result = new List(accountId, webPropertyId, customDataSourceId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public UploadData uploadData(String accountId, String webPropertyId, String customDataSourceId) throws IOException {
                UploadData result = new UploadData(accountId, webPropertyId, customDataSourceId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public UploadData uploadData(String accountId, String webPropertyId, String customDataSourceId, AbstractInputStreamContent mediaContent) throws IOException {
                UploadData result = new UploadData(accountId, webPropertyId, customDataSourceId, mediaContent);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class UploadData
            extends AnalyticsRequest<Upload> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/uploads";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDataSourceId;

                protected UploadData(String accountId, String webPropertyId, String customDataSourceId) {
                    super(Analytics.this, "POST", REST_PATH, null, Upload.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-\\d+-\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-\\d+-\\d+");
                    }
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)customDataSourceId, (Object)"Required parameter customDataSourceId must be specified.");
                }

                protected UploadData(String accountId, String webPropertyId, String customDataSourceId, AbstractInputStreamContent mediaContent) {
                    super(Analytics.this, "POST", "/upload/" + Analytics.this.getServicePath() + REST_PATH, null, Upload.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-\\d+-\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)customDataSourceId, (Object)"Required parameter customDataSourceId must be specified.");
                    this.initializeMediaUpload(mediaContent);
                }

                public UploadData setAlt(String alt) {
                    return (UploadData)super.setAlt(alt);
                }

                public UploadData setFields(String fields) {
                    return (UploadData)super.setFields(fields);
                }

                public UploadData setKey(String key) {
                    return (UploadData)super.setKey(key);
                }

                public UploadData setOauthToken(String oauthToken) {
                    return (UploadData)super.setOauthToken(oauthToken);
                }

                public UploadData setPrettyPrint(Boolean prettyPrint) {
                    return (UploadData)super.setPrettyPrint(prettyPrint);
                }

                public UploadData setQuotaUser(String quotaUser) {
                    return (UploadData)super.setQuotaUser(quotaUser);
                }

                public UploadData setUserIp(String userIp) {
                    return (UploadData)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public UploadData setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public UploadData setWebPropertyId(String webPropertyId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-\\d+-\\d+");
                    }
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getCustomDataSourceId() {
                    return this.customDataSourceId;
                }

                public UploadData setCustomDataSourceId(String customDataSourceId) {
                    this.customDataSourceId = customDataSourceId;
                    return this;
                }

                @Override
                public UploadData set(String parameterName, Object value) {
                    return (UploadData)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Uploads> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/uploads";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern CUSTOM_DATA_SOURCE_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDataSourceId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId, String webPropertyId, String customDataSourceId) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Uploads.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.CUSTOM_DATA_SOURCE_ID_PATTERN = Pattern.compile(".{22}");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)customDataSourceId, (Object)"Required parameter customDataSourceId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(customDataSourceId).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String webPropertyId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getCustomDataSourceId() {
                    return this.customDataSourceId;
                }

                public List setCustomDataSourceId(String customDataSourceId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(customDataSourceId).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                    this.customDataSourceId = customDataSourceId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AnalyticsRequest<Upload> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/uploads/{uploadId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern CUSTOM_DATA_SOURCE_ID_PATTERN;
                private final Pattern UPLOAD_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDataSourceId;
                @Key
                private String uploadId;

                protected Get(String accountId, String webPropertyId, String customDataSourceId, String uploadId) {
                    super(Analytics.this, "GET", REST_PATH, null, Upload.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.CUSTOM_DATA_SOURCE_ID_PATTERN = Pattern.compile(".{22}");
                    this.UPLOAD_ID_PATTERN = Pattern.compile(".{22}");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)customDataSourceId, (Object)"Required parameter customDataSourceId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(customDataSourceId).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                    this.uploadId = (String)Preconditions.checkNotNull((Object)uploadId, (Object)"Required parameter uploadId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.UPLOAD_ID_PATTERN.matcher(uploadId).matches(), (Object)"Parameter uploadId must conform to the pattern .{22}");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String webPropertyId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getCustomDataSourceId() {
                    return this.customDataSourceId;
                }

                public Get setCustomDataSourceId(String customDataSourceId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(customDataSourceId).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                    this.customDataSourceId = customDataSourceId;
                    return this;
                }

                public String getUploadId() {
                    return this.uploadId;
                }

                public Get setUploadId(String uploadId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.UPLOAD_ID_PATTERN.matcher(uploadId).matches(), (Object)"Parameter uploadId must conform to the pattern .{22}");
                    }
                    this.uploadId = uploadId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class DeleteUploadData
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources/{customDataSourceId}/deleteUploadData";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern CUSTOM_DATA_SOURCE_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDataSourceId;

                protected DeleteUploadData(String accountId, String webPropertyId, String customDataSourceId, AnalyticsDataimportDeleteUploadDataRequest content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, Void.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.CUSTOM_DATA_SOURCE_ID_PATTERN = Pattern.compile(".{22}");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.customDataSourceId = (String)Preconditions.checkNotNull((Object)customDataSourceId, (Object)"Required parameter customDataSourceId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(customDataSourceId).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                }

                public DeleteUploadData setAlt(String alt) {
                    return (DeleteUploadData)super.setAlt(alt);
                }

                public DeleteUploadData setFields(String fields) {
                    return (DeleteUploadData)super.setFields(fields);
                }

                public DeleteUploadData setKey(String key) {
                    return (DeleteUploadData)super.setKey(key);
                }

                public DeleteUploadData setOauthToken(String oauthToken) {
                    return (DeleteUploadData)super.setOauthToken(oauthToken);
                }

                public DeleteUploadData setPrettyPrint(Boolean prettyPrint) {
                    return (DeleteUploadData)super.setPrettyPrint(prettyPrint);
                }

                public DeleteUploadData setQuotaUser(String quotaUser) {
                    return (DeleteUploadData)super.setQuotaUser(quotaUser);
                }

                public DeleteUploadData setUserIp(String userIp) {
                    return (DeleteUploadData)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public DeleteUploadData setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public DeleteUploadData setWebPropertyId(String webPropertyId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getCustomDataSourceId() {
                    return this.customDataSourceId;
                }

                public DeleteUploadData setCustomDataSourceId(String customDataSourceId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.CUSTOM_DATA_SOURCE_ID_PATTERN.matcher(customDataSourceId).matches(), (Object)"Parameter customDataSourceId must conform to the pattern .{22}");
                    }
                    this.customDataSourceId = customDataSourceId;
                    return this;
                }

                @Override
                public DeleteUploadData set(String parameterName, Object value) {
                    return (DeleteUploadData)super.set(parameterName, value);
                }
            }
        }

        public class UnsampledReports {
            public Delete delete(String accountId, String webPropertyId, String profileId, String unsampledReportId) throws IOException {
                Delete result = new Delete(accountId, webPropertyId, profileId, unsampledReportId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String accountId, String webPropertyId, String profileId, String unsampledReportId) throws IOException {
                Get result = new Get(accountId, webPropertyId, profileId, unsampledReportId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, String webPropertyId, String profileId, UnsampledReport content) throws IOException {
                Insert result = new Insert(accountId, webPropertyId, profileId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId, String webPropertyId, String profileId) throws IOException {
                List result = new List(accountId, webPropertyId, profileId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.UnsampledReports> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/unsampledReports";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId, String webPropertyId, String profileId) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.UnsampledReports.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<UnsampledReport> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/unsampledReports";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Insert(String accountId, String webPropertyId, String profileId, UnsampledReport content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, UnsampledReport.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getEndDate(), "UnsampledReport.getEndDate()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getMetrics(), "UnsampledReport.getMetrics()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getStartDate(), "UnsampledReport.getStartDate()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getTitle(), "UnsampledReport.getTitle()");
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Insert setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends AnalyticsRequest<UnsampledReport> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/unsampledReports/{unsampledReportId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String unsampledReportId;

                protected Get(String accountId, String webPropertyId, String profileId, String unsampledReportId) {
                    super(Analytics.this, "GET", REST_PATH, null, UnsampledReport.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    this.unsampledReportId = (String)Preconditions.checkNotNull((Object)unsampledReportId, (Object)"Required parameter unsampledReportId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Get setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public String getUnsampledReportId() {
                    return this.unsampledReportId;
                }

                public Get setUnsampledReportId(String unsampledReportId) {
                    this.unsampledReportId = unsampledReportId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/unsampledReports/{unsampledReportId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String unsampledReportId;

                protected Delete(String accountId, String webPropertyId, String profileId, String unsampledReportId) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    this.unsampledReportId = (String)Preconditions.checkNotNull((Object)unsampledReportId, (Object)"Required parameter unsampledReportId must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Delete setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public String getUnsampledReportId() {
                    return this.unsampledReportId;
                }

                public Delete setUnsampledReportId(String unsampledReportId) {
                    this.unsampledReportId = unsampledReportId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Segments {
            public List list() throws IOException {
                List result = new List();
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Segments> {
                private static final String REST_PATH = "management/segments";
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List() {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Segments.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class RemarketingAudience {
            public Delete delete(String accountId, String webPropertyId, String remarketingAudienceId) throws IOException {
                Delete result = new Delete(accountId, webPropertyId, remarketingAudienceId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String accountId, String webPropertyId, String remarketingAudienceId) throws IOException {
                Get result = new Get(accountId, webPropertyId, remarketingAudienceId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, String webPropertyId, com.google.api.services.analytics.model.RemarketingAudience content) throws IOException {
                Insert result = new Insert(accountId, webPropertyId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId, String webPropertyId) throws IOException {
                List result = new List(accountId, webPropertyId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String accountId, String webPropertyId, String remarketingAudienceId, com.google.api.services.analytics.model.RemarketingAudience content) throws IOException {
                Patch result = new Patch(accountId, webPropertyId, remarketingAudienceId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String webPropertyId, String remarketingAudienceId, com.google.api.services.analytics.model.RemarketingAudience content) throws IOException {
                Update result = new Update(accountId, webPropertyId, remarketingAudienceId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AnalyticsRequest<com.google.api.services.analytics.model.RemarketingAudience> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/remarketingAudiences/{remarketingAudienceId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String remarketingAudienceId;

                protected Update(String accountId, String webPropertyId, String remarketingAudienceId, com.google.api.services.analytics.model.RemarketingAudience content) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)content, com.google.api.services.analytics.model.RemarketingAudience.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.remarketingAudienceId = (String)Preconditions.checkNotNull((Object)remarketingAudienceId, (Object)"Required parameter remarketingAudienceId must be specified.");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getRemarketingAudienceId() {
                    return this.remarketingAudienceId;
                }

                public Update setRemarketingAudienceId(String remarketingAudienceId) {
                    this.remarketingAudienceId = remarketingAudienceId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AnalyticsRequest<com.google.api.services.analytics.model.RemarketingAudience> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/remarketingAudiences/{remarketingAudienceId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String remarketingAudienceId;

                protected Patch(String accountId, String webPropertyId, String remarketingAudienceId, com.google.api.services.analytics.model.RemarketingAudience content) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)content, com.google.api.services.analytics.model.RemarketingAudience.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.remarketingAudienceId = (String)Preconditions.checkNotNull((Object)remarketingAudienceId, (Object)"Required parameter remarketingAudienceId must be specified.");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getRemarketingAudienceId() {
                    return this.remarketingAudienceId;
                }

                public Patch setRemarketingAudienceId(String remarketingAudienceId) {
                    this.remarketingAudienceId = remarketingAudienceId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<RemarketingAudiences> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/remarketingAudiences";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;
                @Key
                private String type;

                protected List(String accountId, String webPropertyId) {
                    super(Analytics.this, "GET", REST_PATH, null, RemarketingAudiences.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                public String getType() {
                    return this.type;
                }

                public List setType(String type) {
                    this.type = type;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<com.google.api.services.analytics.model.RemarketingAudience> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/remarketingAudiences";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Insert(String accountId, String webPropertyId, com.google.api.services.analytics.model.RemarketingAudience content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, com.google.api.services.analytics.model.RemarketingAudience.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends AnalyticsRequest<com.google.api.services.analytics.model.RemarketingAudience> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/remarketingAudiences/{remarketingAudienceId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String remarketingAudienceId;

                protected Get(String accountId, String webPropertyId, String remarketingAudienceId) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.RemarketingAudience.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.remarketingAudienceId = (String)Preconditions.checkNotNull((Object)remarketingAudienceId, (Object)"Required parameter remarketingAudienceId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getRemarketingAudienceId() {
                    return this.remarketingAudienceId;
                }

                public Get setRemarketingAudienceId(String remarketingAudienceId) {
                    this.remarketingAudienceId = remarketingAudienceId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/remarketingAudiences/{remarketingAudienceId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String remarketingAudienceId;

                protected Delete(String accountId, String webPropertyId, String remarketingAudienceId) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.remarketingAudienceId = (String)Preconditions.checkNotNull((Object)remarketingAudienceId, (Object)"Required parameter remarketingAudienceId must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getRemarketingAudienceId() {
                    return this.remarketingAudienceId;
                }

                public Delete setRemarketingAudienceId(String remarketingAudienceId) {
                    this.remarketingAudienceId = remarketingAudienceId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Profiles {
            public Delete delete(String accountId, String webPropertyId, String profileId) throws IOException {
                Delete result = new Delete(accountId, webPropertyId, profileId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String accountId, String webPropertyId, String profileId) throws IOException {
                Get result = new Get(accountId, webPropertyId, profileId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, String webPropertyId, Profile content) throws IOException {
                Insert result = new Insert(accountId, webPropertyId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId, String webPropertyId) throws IOException {
                List result = new List(accountId, webPropertyId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String accountId, String webPropertyId, String profileId, Profile content) throws IOException {
                Patch result = new Patch(accountId, webPropertyId, profileId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String webPropertyId, String profileId, Profile content) throws IOException {
                Update result = new Update(accountId, webPropertyId, profileId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AnalyticsRequest<Profile> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Update(String accountId, String webPropertyId, String profileId, Profile content) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)content, Profile.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Update setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AnalyticsRequest<Profile> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Patch(String accountId, String webPropertyId, String profileId, Profile content) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)content, Profile.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Patch setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Profiles> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId, String webPropertyId) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Profiles.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<Profile> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Insert(String accountId, String webPropertyId, Profile content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, Profile.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends AnalyticsRequest<Profile> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Get(String accountId, String webPropertyId, String profileId) {
                    super(Analytics.this, "GET", REST_PATH, null, Profile.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("[0-9]+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-[0-9]+-[0-9]+");
                    this.PROFILE_ID_PATTERN = Pattern.compile("[0-9]+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern [0-9]+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-[0-9]+-[0-9]+");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern [0-9]+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern [0-9]+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String webPropertyId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-[0-9]+-[0-9]+");
                    }
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Get setProfileId(String profileId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern [0-9]+");
                    }
                    this.profileId = profileId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Delete(String accountId, String webPropertyId, String profileId) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Delete setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class ProfileUserLinks {
            public Delete delete(String accountId, String webPropertyId, String profileId, String linkId) throws IOException {
                Delete result = new Delete(accountId, webPropertyId, profileId, linkId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, String webPropertyId, String profileId, EntityUserLink content) throws IOException {
                Insert result = new Insert(accountId, webPropertyId, profileId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId, String webPropertyId, String profileId) throws IOException {
                List result = new List(accountId, webPropertyId, profileId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String webPropertyId, String profileId, String linkId, EntityUserLink content) throws IOException {
                Update result = new Update(accountId, webPropertyId, profileId, linkId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AnalyticsRequest<EntityUserLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/entityUserLinks/{linkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String linkId;

                protected Update(String accountId, String webPropertyId, String profileId, String linkId, EntityUserLink content) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)content, EntityUserLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    this.linkId = (String)Preconditions.checkNotNull((Object)linkId, (Object)"Required parameter linkId must be specified.");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Update setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Update setLinkId(String linkId) {
                    this.linkId = linkId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<EntityUserLinks> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/entityUserLinks";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId, String webPropertyId, String profileId) {
                    super(Analytics.this, "GET", REST_PATH, null, EntityUserLinks.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<EntityUserLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/entityUserLinks";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Insert(String accountId, String webPropertyId, String profileId, EntityUserLink content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, EntityUserLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Insert setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/entityUserLinks/{linkId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String linkId;

                protected Delete(String accountId, String webPropertyId, String profileId, String linkId) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    this.linkId = (String)Preconditions.checkNotNull((Object)linkId, (Object)"Required parameter linkId must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Delete setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Delete setLinkId(String linkId) {
                    this.linkId = linkId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class ProfileFilterLinks {
            public Delete delete(String accountId, String webPropertyId, String profileId, String linkId) throws IOException {
                Delete result = new Delete(accountId, webPropertyId, profileId, linkId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String accountId, String webPropertyId, String profileId, String linkId) throws IOException {
                Get result = new Get(accountId, webPropertyId, profileId, linkId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, String webPropertyId, String profileId, ProfileFilterLink content) throws IOException {
                Insert result = new Insert(accountId, webPropertyId, profileId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId, String webPropertyId, String profileId) throws IOException {
                List result = new List(accountId, webPropertyId, profileId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String accountId, String webPropertyId, String profileId, String linkId, ProfileFilterLink content) throws IOException {
                Patch result = new Patch(accountId, webPropertyId, profileId, linkId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String webPropertyId, String profileId, String linkId, ProfileFilterLink content) throws IOException {
                Update result = new Update(accountId, webPropertyId, profileId, linkId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AnalyticsRequest<ProfileFilterLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks/{linkId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                private final Pattern LINK_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String linkId;

                protected Update(String accountId, String webPropertyId, String profileId, String linkId, ProfileFilterLink content) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)content, ProfileFilterLink.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.PROFILE_ID_PATTERN = Pattern.compile("\\d+");
                    this.LINK_ID_PATTERN = Pattern.compile("\\d+:\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.linkId = (String)Preconditions.checkNotNull((Object)linkId, (Object)"Required parameter linkId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(linkId).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String webPropertyId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Update setProfileId(String profileId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.profileId = profileId;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Update setLinkId(String linkId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(linkId).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                    this.linkId = linkId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AnalyticsRequest<ProfileFilterLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks/{linkId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                private final Pattern LINK_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String linkId;

                protected Patch(String accountId, String webPropertyId, String profileId, String linkId, ProfileFilterLink content) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)content, ProfileFilterLink.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.PROFILE_ID_PATTERN = Pattern.compile("\\d+");
                    this.LINK_ID_PATTERN = Pattern.compile("\\d+:\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.linkId = (String)Preconditions.checkNotNull((Object)linkId, (Object)"Required parameter linkId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(linkId).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String webPropertyId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Patch setProfileId(String profileId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.profileId = profileId;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Patch setLinkId(String linkId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(linkId).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                    this.linkId = linkId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.ProfileFilterLinks> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks";
                private final Pattern ACCOUNT_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId, String webPropertyId, String profileId) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.ProfileFilterLinks.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<ProfileFilterLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Insert(String accountId, String webPropertyId, String profileId, ProfileFilterLink content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, ProfileFilterLink.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.PROFILE_ID_PATTERN = Pattern.compile("\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String webPropertyId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Insert setProfileId(String profileId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.profileId = profileId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends AnalyticsRequest<ProfileFilterLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks/{linkId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                private final Pattern LINK_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String linkId;

                protected Get(String accountId, String webPropertyId, String profileId, String linkId) {
                    super(Analytics.this, "GET", REST_PATH, null, ProfileFilterLink.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.PROFILE_ID_PATTERN = Pattern.compile("\\d+");
                    this.LINK_ID_PATTERN = Pattern.compile("\\d+:\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.linkId = (String)Preconditions.checkNotNull((Object)linkId, (Object)"Required parameter linkId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(linkId).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String webPropertyId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Get setProfileId(String profileId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.profileId = profileId;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Get setLinkId(String linkId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(linkId).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                    this.linkId = linkId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/profileFilterLinks/{linkId}";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                private final Pattern LINK_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String linkId;

                protected Delete(String accountId, String webPropertyId, String profileId, String linkId) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.PROFILE_ID_PATTERN = Pattern.compile("\\d+");
                    this.LINK_ID_PATTERN = Pattern.compile("\\d+:\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.linkId = (String)Preconditions.checkNotNull((Object)linkId, (Object)"Required parameter linkId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(linkId).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String webPropertyId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Delete setProfileId(String profileId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.profileId = profileId;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Delete setLinkId(String linkId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.LINK_ID_PATTERN.matcher(linkId).matches(), (Object)"Parameter linkId must conform to the pattern \\d+:\\d+");
                    }
                    this.linkId = linkId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Goals {
            public Get get(String accountId, String webPropertyId, String profileId, String goalId) throws IOException {
                Get result = new Get(accountId, webPropertyId, profileId, goalId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, String webPropertyId, String profileId, Goal content) throws IOException {
                Insert result = new Insert(accountId, webPropertyId, profileId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId, String webPropertyId, String profileId) throws IOException {
                List result = new List(accountId, webPropertyId, profileId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String accountId, String webPropertyId, String profileId, String goalId, Goal content) throws IOException {
                Patch result = new Patch(accountId, webPropertyId, profileId, goalId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String webPropertyId, String profileId, String goalId, Goal content) throws IOException {
                Update result = new Update(accountId, webPropertyId, profileId, goalId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AnalyticsRequest<Goal> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals/{goalId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String goalId;

                protected Update(String accountId, String webPropertyId, String profileId, String goalId, Goal content) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)content, Goal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    this.goalId = (String)Preconditions.checkNotNull((Object)goalId, (Object)"Required parameter goalId must be specified.");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Update setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public String getGoalId() {
                    return this.goalId;
                }

                public Update setGoalId(String goalId) {
                    this.goalId = goalId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AnalyticsRequest<Goal> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals/{goalId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String goalId;

                protected Patch(String accountId, String webPropertyId, String profileId, String goalId, Goal content) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)content, Goal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    this.goalId = (String)Preconditions.checkNotNull((Object)goalId, (Object)"Required parameter goalId must be specified.");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Patch setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public String getGoalId() {
                    return this.goalId;
                }

                public Patch setGoalId(String goalId) {
                    this.goalId = goalId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Goals> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId, String webPropertyId, String profileId) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Goals.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<Goal> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Insert(String accountId, String webPropertyId, String profileId, Goal content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, Goal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Insert setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends AnalyticsRequest<Goal> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/goals/{goalId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String goalId;

                protected Get(String accountId, String webPropertyId, String profileId, String goalId) {
                    super(Analytics.this, "GET", REST_PATH, null, Goal.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    this.goalId = (String)Preconditions.checkNotNull((Object)goalId, (Object)"Required parameter goalId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Get setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public String getGoalId() {
                    return this.goalId;
                }

                public Get setGoalId(String goalId) {
                    this.goalId = goalId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Filters {
            public Delete delete(String accountId, String filterId) throws IOException {
                Delete result = new Delete(accountId, filterId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String accountId, String filterId) throws IOException {
                Get result = new Get(accountId, filterId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, Filter content) throws IOException {
                Insert result = new Insert(accountId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId) throws IOException {
                List result = new List(accountId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String accountId, String filterId, Filter content) throws IOException {
                Patch result = new Patch(accountId, filterId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String filterId, Filter content) throws IOException {
                Update result = new Update(accountId, filterId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AnalyticsRequest<Filter> {
                private static final String REST_PATH = "management/accounts/{accountId}/filters/{filterId}";
                @Key
                private String accountId;
                @Key
                private String filterId;

                protected Update(String accountId, String filterId, Filter content) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)content, Filter.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.filterId = (String)Preconditions.checkNotNull((Object)filterId, (Object)"Required parameter filterId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getName(), "Filter.getName()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getType(), "Filter.getType()");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getFilterId() {
                    return this.filterId;
                }

                public Update setFilterId(String filterId) {
                    this.filterId = filterId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AnalyticsRequest<Filter> {
                private static final String REST_PATH = "management/accounts/{accountId}/filters/{filterId}";
                @Key
                private String accountId;
                @Key
                private String filterId;

                protected Patch(String accountId, String filterId, Filter content) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)content, Filter.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.filterId = (String)Preconditions.checkNotNull((Object)filterId, (Object)"Required parameter filterId must be specified.");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getFilterId() {
                    return this.filterId;
                }

                public Patch setFilterId(String filterId) {
                    this.filterId = filterId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Filters> {
                private static final String REST_PATH = "management/accounts/{accountId}/filters";
                private final Pattern ACCOUNT_ID_PATTERN;
                @Key
                private String accountId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Filters.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<Filter> {
                private static final String REST_PATH = "management/accounts/{accountId}/filters";
                @Key
                private String accountId;

                protected Insert(String accountId, Filter content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, Filter.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getName(), "Filter.getName()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getType(), "Filter.getType()");
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends AnalyticsRequest<Filter> {
                private static final String REST_PATH = "management/accounts/{accountId}/filters/{filterId}";
                @Key
                private String accountId;
                @Key
                private String filterId;

                protected Get(String accountId, String filterId) {
                    super(Analytics.this, "GET", REST_PATH, null, Filter.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.filterId = (String)Preconditions.checkNotNull((Object)filterId, (Object)"Required parameter filterId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getFilterId() {
                    return this.filterId;
                }

                public Get setFilterId(String filterId) {
                    this.filterId = filterId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AnalyticsRequest<Filter> {
                private static final String REST_PATH = "management/accounts/{accountId}/filters/{filterId}";
                @Key
                private String accountId;
                @Key
                private String filterId;

                protected Delete(String accountId, String filterId) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Filter.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.filterId = (String)Preconditions.checkNotNull((Object)filterId, (Object)"Required parameter filterId must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getFilterId() {
                    return this.filterId;
                }

                public Delete setFilterId(String filterId) {
                    this.filterId = filterId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class Experiments {
            public Delete delete(String accountId, String webPropertyId, String profileId, String experimentId) throws IOException {
                Delete result = new Delete(accountId, webPropertyId, profileId, experimentId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String accountId, String webPropertyId, String profileId, String experimentId) throws IOException {
                Get result = new Get(accountId, webPropertyId, profileId, experimentId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, String webPropertyId, String profileId, Experiment content) throws IOException {
                Insert result = new Insert(accountId, webPropertyId, profileId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId, String webPropertyId, String profileId) throws IOException {
                List result = new List(accountId, webPropertyId, profileId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String accountId, String webPropertyId, String profileId, String experimentId, Experiment content) throws IOException {
                Patch result = new Patch(accountId, webPropertyId, profileId, experimentId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String webPropertyId, String profileId, String experimentId, Experiment content) throws IOException {
                Update result = new Update(accountId, webPropertyId, profileId, experimentId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AnalyticsRequest<Experiment> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String experimentId;

                protected Update(String accountId, String webPropertyId, String profileId, String experimentId, Experiment content) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)content, Experiment.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    this.experimentId = (String)Preconditions.checkNotNull((Object)experimentId, (Object)"Required parameter experimentId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getId(), "Experiment.getId()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getName(), "Experiment.getName()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getStatus(), "Experiment.getStatus()");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Update setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public String getExperimentId() {
                    return this.experimentId;
                }

                public Update setExperimentId(String experimentId) {
                    this.experimentId = experimentId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AnalyticsRequest<Experiment> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String experimentId;

                protected Patch(String accountId, String webPropertyId, String profileId, String experimentId, Experiment content) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)content, Experiment.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    this.experimentId = (String)Preconditions.checkNotNull((Object)experimentId, (Object)"Required parameter experimentId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getId(), "Experiment.getId()");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Patch setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public String getExperimentId() {
                    return this.experimentId;
                }

                public Patch setExperimentId(String experimentId) {
                    this.experimentId = experimentId;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Experiments> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                private final Pattern PROFILE_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId, String webPropertyId, String profileId) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Experiments.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.PROFILE_ID_PATTERN = Pattern.compile("\\d+");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String webPropertyId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public List setProfileId(String profileId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PROFILE_ID_PATTERN.matcher(profileId).matches(), (Object)"Parameter profileId must conform to the pattern \\d+");
                    }
                    this.profileId = profileId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<Experiment> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;

                protected Insert(String accountId, String webPropertyId, String profileId, Experiment content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, Experiment.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getName(), "Experiment.getName()");
                    this.checkRequiredParameter((Object)content, "content");
                    this.checkRequiredParameter(content.getStatus(), "Experiment.getStatus()");
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Insert setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends AnalyticsRequest<Experiment> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String experimentId;

                protected Get(String accountId, String webPropertyId, String profileId, String experimentId) {
                    super(Analytics.this, "GET", REST_PATH, null, Experiment.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    this.experimentId = (String)Preconditions.checkNotNull((Object)experimentId, (Object)"Required parameter experimentId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Get setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public String getExperimentId() {
                    return this.experimentId;
                }

                public Get setExperimentId(String experimentId) {
                    this.experimentId = experimentId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/profiles/{profileId}/experiments/{experimentId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String profileId;
                @Key
                private String experimentId;

                protected Delete(String accountId, String webPropertyId, String profileId, String experimentId) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.profileId = (String)Preconditions.checkNotNull((Object)profileId, (Object)"Required parameter profileId must be specified.");
                    this.experimentId = (String)Preconditions.checkNotNull((Object)experimentId, (Object)"Required parameter experimentId must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Delete setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getProfileId() {
                    return this.profileId;
                }

                public Delete setProfileId(String profileId) {
                    this.profileId = profileId;
                    return this;
                }

                public String getExperimentId() {
                    return this.experimentId;
                }

                public Delete setExperimentId(String experimentId) {
                    this.experimentId = experimentId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class CustomMetrics {
            public Get get(String accountId, String webPropertyId, String customMetricId) throws IOException {
                Get result = new Get(accountId, webPropertyId, customMetricId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, String webPropertyId, CustomMetric content) throws IOException {
                Insert result = new Insert(accountId, webPropertyId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId, String webPropertyId) throws IOException {
                List result = new List(accountId, webPropertyId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String accountId, String webPropertyId, String customMetricId, CustomMetric content) throws IOException {
                Patch result = new Patch(accountId, webPropertyId, customMetricId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String webPropertyId, String customMetricId, CustomMetric content) throws IOException {
                Update result = new Update(accountId, webPropertyId, customMetricId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AnalyticsRequest<CustomMetric> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics/{customMetricId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customMetricId;
                @Key
                private Boolean ignoreCustomDataSourceLinks;

                protected Update(String accountId, String webPropertyId, String customMetricId, CustomMetric content) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)content, CustomMetric.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.customMetricId = (String)Preconditions.checkNotNull((Object)customMetricId, (Object)"Required parameter customMetricId must be specified.");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getCustomMetricId() {
                    return this.customMetricId;
                }

                public Update setCustomMetricId(String customMetricId) {
                    this.customMetricId = customMetricId;
                    return this;
                }

                public Boolean getIgnoreCustomDataSourceLinks() {
                    return this.ignoreCustomDataSourceLinks;
                }

                public Update setIgnoreCustomDataSourceLinks(Boolean ignoreCustomDataSourceLinks) {
                    this.ignoreCustomDataSourceLinks = ignoreCustomDataSourceLinks;
                    return this;
                }

                public boolean isIgnoreCustomDataSourceLinks() {
                    if (this.ignoreCustomDataSourceLinks == null || this.ignoreCustomDataSourceLinks == com.google.api.client.util.Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.ignoreCustomDataSourceLinks;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AnalyticsRequest<CustomMetric> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics/{customMetricId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customMetricId;
                @Key
                private Boolean ignoreCustomDataSourceLinks;

                protected Patch(String accountId, String webPropertyId, String customMetricId, CustomMetric content) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)content, CustomMetric.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.customMetricId = (String)Preconditions.checkNotNull((Object)customMetricId, (Object)"Required parameter customMetricId must be specified.");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getCustomMetricId() {
                    return this.customMetricId;
                }

                public Patch setCustomMetricId(String customMetricId) {
                    this.customMetricId = customMetricId;
                    return this;
                }

                public Boolean getIgnoreCustomDataSourceLinks() {
                    return this.ignoreCustomDataSourceLinks;
                }

                public Patch setIgnoreCustomDataSourceLinks(Boolean ignoreCustomDataSourceLinks) {
                    this.ignoreCustomDataSourceLinks = ignoreCustomDataSourceLinks;
                    return this;
                }

                public boolean isIgnoreCustomDataSourceLinks() {
                    if (this.ignoreCustomDataSourceLinks == null || this.ignoreCustomDataSourceLinks == com.google.api.client.util.Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.ignoreCustomDataSourceLinks;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.CustomMetrics> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId, String webPropertyId) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomMetrics.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<CustomMetric> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Insert(String accountId, String webPropertyId, CustomMetric content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, CustomMetric.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends AnalyticsRequest<CustomMetric> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customMetrics/{customMetricId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customMetricId;

                protected Get(String accountId, String webPropertyId, String customMetricId) {
                    super(Analytics.this, "GET", REST_PATH, null, CustomMetric.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.customMetricId = (String)Preconditions.checkNotNull((Object)customMetricId, (Object)"Required parameter customMetricId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getCustomMetricId() {
                    return this.customMetricId;
                }

                public Get setCustomMetricId(String customMetricId) {
                    this.customMetricId = customMetricId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class CustomDimensions {
            public Get get(String accountId, String webPropertyId, String customDimensionId) throws IOException {
                Get result = new Get(accountId, webPropertyId, customDimensionId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, String webPropertyId, CustomDimension content) throws IOException {
                Insert result = new Insert(accountId, webPropertyId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId, String webPropertyId) throws IOException {
                List result = new List(accountId, webPropertyId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String accountId, String webPropertyId, String customDimensionId, CustomDimension content) throws IOException {
                Patch result = new Patch(accountId, webPropertyId, customDimensionId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String webPropertyId, String customDimensionId, CustomDimension content) throws IOException {
                Update result = new Update(accountId, webPropertyId, customDimensionId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AnalyticsRequest<CustomDimension> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions/{customDimensionId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDimensionId;
                @Key
                private Boolean ignoreCustomDataSourceLinks;

                protected Update(String accountId, String webPropertyId, String customDimensionId, CustomDimension content) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)content, CustomDimension.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.customDimensionId = (String)Preconditions.checkNotNull((Object)customDimensionId, (Object)"Required parameter customDimensionId must be specified.");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Update setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getCustomDimensionId() {
                    return this.customDimensionId;
                }

                public Update setCustomDimensionId(String customDimensionId) {
                    this.customDimensionId = customDimensionId;
                    return this;
                }

                public Boolean getIgnoreCustomDataSourceLinks() {
                    return this.ignoreCustomDataSourceLinks;
                }

                public Update setIgnoreCustomDataSourceLinks(Boolean ignoreCustomDataSourceLinks) {
                    this.ignoreCustomDataSourceLinks = ignoreCustomDataSourceLinks;
                    return this;
                }

                public boolean isIgnoreCustomDataSourceLinks() {
                    if (this.ignoreCustomDataSourceLinks == null || this.ignoreCustomDataSourceLinks == com.google.api.client.util.Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.ignoreCustomDataSourceLinks;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class Patch
            extends AnalyticsRequest<CustomDimension> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions/{customDimensionId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDimensionId;
                @Key
                private Boolean ignoreCustomDataSourceLinks;

                protected Patch(String accountId, String webPropertyId, String customDimensionId, CustomDimension content) {
                    super(Analytics.this, "PATCH", REST_PATH, (Object)content, CustomDimension.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.customDimensionId = (String)Preconditions.checkNotNull((Object)customDimensionId, (Object)"Required parameter customDimensionId must be specified.");
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUserIp(String userIp) {
                    return (Patch)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Patch setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Patch setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getCustomDimensionId() {
                    return this.customDimensionId;
                }

                public Patch setCustomDimensionId(String customDimensionId) {
                    this.customDimensionId = customDimensionId;
                    return this;
                }

                public Boolean getIgnoreCustomDataSourceLinks() {
                    return this.ignoreCustomDataSourceLinks;
                }

                public Patch setIgnoreCustomDataSourceLinks(Boolean ignoreCustomDataSourceLinks) {
                    this.ignoreCustomDataSourceLinks = ignoreCustomDataSourceLinks;
                    return this;
                }

                public boolean isIgnoreCustomDataSourceLinks() {
                    if (this.ignoreCustomDataSourceLinks == null || this.ignoreCustomDataSourceLinks == com.google.api.client.util.Data.NULL_BOOLEAN) {
                        return false;
                    }
                    return this.ignoreCustomDataSourceLinks;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.CustomDimensions> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId, String webPropertyId) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomDimensions.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<CustomDimension> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;

                protected Insert(String accountId, String webPropertyId, CustomDimension content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, CustomDimension.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Insert setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Get
            extends AnalyticsRequest<CustomDimension> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDimensions/{customDimensionId}";
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key
                private String customDimensionId;

                protected Get(String accountId, String webPropertyId, String customDimensionId) {
                    super(Analytics.this, "GET", REST_PATH, null, CustomDimension.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    this.customDimensionId = (String)Preconditions.checkNotNull((Object)customDimensionId, (Object)"Required parameter customDimensionId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Get setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public Get setWebPropertyId(String webPropertyId) {
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public String getCustomDimensionId() {
                    return this.customDimensionId;
                }

                public Get setCustomDimensionId(String customDimensionId) {
                    this.customDimensionId = customDimensionId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class CustomDataSources {
            public List list(String accountId, String webPropertyId) throws IOException {
                List result = new List(accountId, webPropertyId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.CustomDataSources> {
                private static final String REST_PATH = "management/accounts/{accountId}/webproperties/{webPropertyId}/customDataSources";
                private final Pattern ACCOUNT_ID_PATTERN;
                private final Pattern WEB_PROPERTY_ID_PATTERN;
                @Key
                private String accountId;
                @Key
                private String webPropertyId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId, String webPropertyId) {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.CustomDataSources.class);
                    this.ACCOUNT_ID_PATTERN = Pattern.compile("\\d+");
                    this.WEB_PROPERTY_ID_PATTERN = Pattern.compile("UA-(\\d+)-(\\d+)");
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.webPropertyId = (String)Preconditions.checkNotNull((Object)webPropertyId, (Object)"Required parameter webPropertyId must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.ACCOUNT_ID_PATTERN.matcher(accountId).matches(), (Object)"Parameter accountId must conform to the pattern \\d+");
                    }
                    this.accountId = accountId;
                    return this;
                }

                public String getWebPropertyId() {
                    return this.webPropertyId;
                }

                public List setWebPropertyId(String webPropertyId) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.WEB_PROPERTY_ID_PATTERN.matcher(webPropertyId).matches(), (Object)"Parameter webPropertyId must conform to the pattern UA-(\\d+)-(\\d+)");
                    }
                    this.webPropertyId = webPropertyId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class ClientId {
            public HashClientId hashClientId(HashClientIdRequest content) throws IOException {
                HashClientId result = new HashClientId(content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class HashClientId
            extends AnalyticsRequest<HashClientIdResponse> {
                private static final String REST_PATH = "management/clientId:hashClientId";

                protected HashClientId(HashClientIdRequest content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, HashClientIdResponse.class);
                }

                public HashClientId setAlt(String alt) {
                    return (HashClientId)super.setAlt(alt);
                }

                public HashClientId setFields(String fields) {
                    return (HashClientId)super.setFields(fields);
                }

                public HashClientId setKey(String key) {
                    return (HashClientId)super.setKey(key);
                }

                public HashClientId setOauthToken(String oauthToken) {
                    return (HashClientId)super.setOauthToken(oauthToken);
                }

                public HashClientId setPrettyPrint(Boolean prettyPrint) {
                    return (HashClientId)super.setPrettyPrint(prettyPrint);
                }

                public HashClientId setQuotaUser(String quotaUser) {
                    return (HashClientId)super.setQuotaUser(quotaUser);
                }

                public HashClientId setUserIp(String userIp) {
                    return (HashClientId)super.setUserIp(userIp);
                }

                @Override
                public HashClientId set(String parameterName, Object value) {
                    return (HashClientId)super.set(parameterName, value);
                }
            }
        }

        public class Accounts {
            public List list() throws IOException {
                List result = new List();
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.Accounts> {
                private static final String REST_PATH = "management/accounts";
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List() {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.Accounts.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }

        public class AccountUserLinks {
            public Delete delete(String accountId, String linkId) throws IOException {
                Delete result = new Delete(accountId, linkId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Insert insert(String accountId, EntityUserLink content) throws IOException {
                Insert result = new Insert(accountId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String accountId) throws IOException {
                List result = new List(accountId);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Update update(String accountId, String linkId, EntityUserLink content) throws IOException {
                Update result = new Update(accountId, linkId, content);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Update
            extends AnalyticsRequest<EntityUserLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/entityUserLinks/{linkId}";
                @Key
                private String accountId;
                @Key
                private String linkId;

                protected Update(String accountId, String linkId, EntityUserLink content) {
                    super(Analytics.this, "PUT", REST_PATH, (Object)content, EntityUserLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.linkId = (String)Preconditions.checkNotNull((Object)linkId, (Object)"Required parameter linkId must be specified.");
                }

                public Update setAlt(String alt) {
                    return (Update)super.setAlt(alt);
                }

                public Update setFields(String fields) {
                    return (Update)super.setFields(fields);
                }

                public Update setKey(String key) {
                    return (Update)super.setKey(key);
                }

                public Update setOauthToken(String oauthToken) {
                    return (Update)super.setOauthToken(oauthToken);
                }

                public Update setPrettyPrint(Boolean prettyPrint) {
                    return (Update)super.setPrettyPrint(prettyPrint);
                }

                public Update setQuotaUser(String quotaUser) {
                    return (Update)super.setQuotaUser(quotaUser);
                }

                public Update setUserIp(String userIp) {
                    return (Update)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Update setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Update setLinkId(String linkId) {
                    this.linkId = linkId;
                    return this;
                }

                @Override
                public Update set(String parameterName, Object value) {
                    return (Update)super.set(parameterName, value);
                }
            }

            public class List
            extends AnalyticsRequest<EntityUserLinks> {
                private static final String REST_PATH = "management/accounts/{accountId}/entityUserLinks";
                @Key
                private String accountId;
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List(String accountId) {
                    super(Analytics.this, "GET", REST_PATH, null, EntityUserLinks.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public List setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Insert
            extends AnalyticsRequest<EntityUserLink> {
                private static final String REST_PATH = "management/accounts/{accountId}/entityUserLinks";
                @Key
                private String accountId;

                protected Insert(String accountId, EntityUserLink content) {
                    super(Analytics.this, "POST", REST_PATH, (Object)content, EntityUserLink.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                }

                public Insert setAlt(String alt) {
                    return (Insert)super.setAlt(alt);
                }

                public Insert setFields(String fields) {
                    return (Insert)super.setFields(fields);
                }

                public Insert setKey(String key) {
                    return (Insert)super.setKey(key);
                }

                public Insert setOauthToken(String oauthToken) {
                    return (Insert)super.setOauthToken(oauthToken);
                }

                public Insert setPrettyPrint(Boolean prettyPrint) {
                    return (Insert)super.setPrettyPrint(prettyPrint);
                }

                public Insert setQuotaUser(String quotaUser) {
                    return (Insert)super.setQuotaUser(quotaUser);
                }

                public Insert setUserIp(String userIp) {
                    return (Insert)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Insert setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                @Override
                public Insert set(String parameterName, Object value) {
                    return (Insert)super.set(parameterName, value);
                }
            }

            public class Delete
            extends AnalyticsRequest<Void> {
                private static final String REST_PATH = "management/accounts/{accountId}/entityUserLinks/{linkId}";
                @Key
                private String accountId;
                @Key
                private String linkId;

                protected Delete(String accountId, String linkId) {
                    super(Analytics.this, "DELETE", REST_PATH, null, Void.class);
                    this.accountId = (String)Preconditions.checkNotNull((Object)accountId, (Object)"Required parameter accountId must be specified.");
                    this.linkId = (String)Preconditions.checkNotNull((Object)linkId, (Object)"Required parameter linkId must be specified.");
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUserIp(String userIp) {
                    return (Delete)super.setUserIp(userIp);
                }

                public String getAccountId() {
                    return this.accountId;
                }

                public Delete setAccountId(String accountId) {
                    this.accountId = accountId;
                    return this;
                }

                public String getLinkId() {
                    return this.linkId;
                }

                public Delete setLinkId(String linkId) {
                    this.linkId = linkId;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }
        }

        public class AccountSummaries {
            public List list() throws IOException {
                List result = new List();
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends AnalyticsRequest<com.google.api.services.analytics.model.AccountSummaries> {
                private static final String REST_PATH = "management/accountSummaries";
                @Key(value="max-results")
                private Integer maxResults;
                @Key(value="start-index")
                private Integer startIndex;

                protected List() {
                    super(Analytics.this, "GET", REST_PATH, null, com.google.api.services.analytics.model.AccountSummaries.class);
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUserIp(String userIp) {
                    return (List)super.setUserIp(userIp);
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public List setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public List setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }
        }
    }

    public class Data {
        public Ga ga() {
            return new Ga();
        }

        public Mcf mcf() {
            return new Mcf();
        }

        public Realtime realtime() {
            return new Realtime();
        }

        public class Realtime {
            public Get get(String ids, String metrics) throws IOException {
                Get result = new Get(ids, metrics);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends AnalyticsRequest<RealtimeData> {
                private static final String REST_PATH = "data/realtime";
                private final Pattern IDS_PATTERN;
                private final Pattern METRICS_PATTERN;
                private final Pattern DIMENSIONS_PATTERN;
                private final Pattern FILTERS_PATTERN;
                private final Pattern SORT_PATTERN;
                @Key
                private String ids;
                @Key
                private String metrics;
                @Key
                private String dimensions;
                @Key
                private String filters;
                @Key(value="max-results")
                private Integer maxResults;
                @Key
                private String sort;

                protected Get(String ids, String metrics) {
                    super(Analytics.this, "GET", REST_PATH, null, RealtimeData.class);
                    this.IDS_PATTERN = Pattern.compile("ga:[0-9]+");
                    this.METRICS_PATTERN = Pattern.compile("(ga:.+)|(rt:.+)");
                    this.DIMENSIONS_PATTERN = Pattern.compile("(ga:.+)|(rt:.+)");
                    this.FILTERS_PATTERN = Pattern.compile("(ga:.+)|(rt:.+)");
                    this.SORT_PATTERN = Pattern.compile("(-)?((ga:.+)|(rt:.+))");
                    this.ids = (String)Preconditions.checkNotNull((Object)ids, (Object)"Required parameter ids must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(ids).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.metrics = (String)Preconditions.checkNotNull((Object)metrics, (Object)"Required parameter metrics must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(metrics).matches(), (Object)"Parameter metrics must conform to the pattern (ga:.+)|(rt:.+)");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getIds() {
                    return this.ids;
                }

                public Get setIds(String ids) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(ids).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.ids = ids;
                    return this;
                }

                public String getMetrics() {
                    return this.metrics;
                }

                public Get setMetrics(String metrics) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(metrics).matches(), (Object)"Parameter metrics must conform to the pattern (ga:.+)|(rt:.+)");
                    }
                    this.metrics = metrics;
                    return this;
                }

                public String getDimensions() {
                    return this.dimensions;
                }

                public Get setDimensions(String dimensions) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DIMENSIONS_PATTERN.matcher(dimensions).matches(), (Object)"Parameter dimensions must conform to the pattern (ga:.+)|(rt:.+)");
                    }
                    this.dimensions = dimensions;
                    return this;
                }

                public String getFilters() {
                    return this.filters;
                }

                public Get setFilters(String filters) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.FILTERS_PATTERN.matcher(filters).matches(), (Object)"Parameter filters must conform to the pattern (ga:.+)|(rt:.+)");
                    }
                    this.filters = filters;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public Get setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getSort() {
                    return this.sort;
                }

                public Get setSort(String sort) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SORT_PATTERN.matcher(sort).matches(), (Object)"Parameter sort must conform to the pattern (-)?((ga:.+)|(rt:.+))");
                    }
                    this.sort = sort;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Mcf {
            public Get get(String ids, String startDate, String endDate, String metrics) throws IOException {
                Get result = new Get(ids, startDate, endDate, metrics);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends AnalyticsRequest<McfData> {
                private static final String REST_PATH = "data/mcf";
                private final Pattern IDS_PATTERN;
                private final Pattern START_DATE_PATTERN;
                private final Pattern END_DATE_PATTERN;
                private final Pattern METRICS_PATTERN;
                private final Pattern DIMENSIONS_PATTERN;
                private final Pattern FILTERS_PATTERN;
                private final Pattern SORT_PATTERN;
                @Key
                private String ids;
                @Key(value="start-date")
                private String startDate;
                @Key(value="end-date")
                private String endDate;
                @Key
                private String metrics;
                @Key
                private String dimensions;
                @Key
                private String filters;
                @Key(value="max-results")
                private Integer maxResults;
                @Key
                private String samplingLevel;
                @Key
                private String sort;
                @Key(value="start-index")
                private Integer startIndex;

                protected Get(String ids, String startDate, String endDate, String metrics) {
                    super(Analytics.this, "GET", REST_PATH, null, McfData.class);
                    this.IDS_PATTERN = Pattern.compile("ga:[0-9]+");
                    this.START_DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    this.END_DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    this.METRICS_PATTERN = Pattern.compile("mcf:.+");
                    this.DIMENSIONS_PATTERN = Pattern.compile("(mcf:.+)?");
                    this.FILTERS_PATTERN = Pattern.compile("mcf:.+");
                    this.SORT_PATTERN = Pattern.compile("(-)?mcf:.+");
                    this.ids = (String)Preconditions.checkNotNull((Object)ids, (Object)"Required parameter ids must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(ids).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.startDate = (String)Preconditions.checkNotNull((Object)startDate, (Object)"Required parameter startDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.START_DATE_PATTERN.matcher(startDate).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.endDate = (String)Preconditions.checkNotNull((Object)endDate, (Object)"Required parameter endDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.END_DATE_PATTERN.matcher(endDate).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.metrics = (String)Preconditions.checkNotNull((Object)metrics, (Object)"Required parameter metrics must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(metrics).matches(), (Object)"Parameter metrics must conform to the pattern mcf:.+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getIds() {
                    return this.ids;
                }

                public Get setIds(String ids) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(ids).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.ids = ids;
                    return this;
                }

                public String getStartDate() {
                    return this.startDate;
                }

                public Get setStartDate(String startDate) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.START_DATE_PATTERN.matcher(startDate).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.startDate = startDate;
                    return this;
                }

                public String getEndDate() {
                    return this.endDate;
                }

                public Get setEndDate(String endDate) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.END_DATE_PATTERN.matcher(endDate).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.endDate = endDate;
                    return this;
                }

                public String getMetrics() {
                    return this.metrics;
                }

                public Get setMetrics(String metrics) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(metrics).matches(), (Object)"Parameter metrics must conform to the pattern mcf:.+");
                    }
                    this.metrics = metrics;
                    return this;
                }

                public String getDimensions() {
                    return this.dimensions;
                }

                public Get setDimensions(String dimensions) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DIMENSIONS_PATTERN.matcher(dimensions).matches(), (Object)"Parameter dimensions must conform to the pattern (mcf:.+)?");
                    }
                    this.dimensions = dimensions;
                    return this;
                }

                public String getFilters() {
                    return this.filters;
                }

                public Get setFilters(String filters) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.FILTERS_PATTERN.matcher(filters).matches(), (Object)"Parameter filters must conform to the pattern mcf:.+");
                    }
                    this.filters = filters;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public Get setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getSamplingLevel() {
                    return this.samplingLevel;
                }

                public Get setSamplingLevel(String samplingLevel) {
                    this.samplingLevel = samplingLevel;
                    return this;
                }

                public String getSort() {
                    return this.sort;
                }

                public Get setSort(String sort) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SORT_PATTERN.matcher(sort).matches(), (Object)"Parameter sort must conform to the pattern (-)?mcf:.+");
                    }
                    this.sort = sort;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public Get setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }

        public class Ga {
            public Get get(String ids, String startDate, String endDate, String metrics) throws IOException {
                Get result = new Get(ids, startDate, endDate, metrics);
                Analytics.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Get
            extends AnalyticsRequest<GaData> {
                private static final String REST_PATH = "data/ga";
                private final Pattern IDS_PATTERN;
                private final Pattern START_DATE_PATTERN;
                private final Pattern END_DATE_PATTERN;
                private final Pattern METRICS_PATTERN;
                private final Pattern DIMENSIONS_PATTERN;
                private final Pattern FILTERS_PATTERN;
                private final Pattern SORT_PATTERN;
                @Key
                private String ids;
                @Key(value="start-date")
                private String startDate;
                @Key(value="end-date")
                private String endDate;
                @Key
                private String metrics;
                @Key
                private String dimensions;
                @Key
                private String filters;
                @Key(value="include-empty-rows")
                private Boolean includeEmptyRows;
                @Key(value="max-results")
                private Integer maxResults;
                @Key
                private String output;
                @Key
                private String samplingLevel;
                @Key
                private String segment;
                @Key
                private String sort;
                @Key(value="start-index")
                private Integer startIndex;

                protected Get(String ids, String startDate, String endDate, String metrics) {
                    super(Analytics.this, "GET", REST_PATH, null, GaData.class);
                    this.IDS_PATTERN = Pattern.compile("ga:[0-9]+");
                    this.START_DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    this.END_DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    this.METRICS_PATTERN = Pattern.compile("ga:.+");
                    this.DIMENSIONS_PATTERN = Pattern.compile("(ga:.+)?");
                    this.FILTERS_PATTERN = Pattern.compile("ga:.+");
                    this.SORT_PATTERN = Pattern.compile("(-)?ga:.+");
                    this.ids = (String)Preconditions.checkNotNull((Object)ids, (Object)"Required parameter ids must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(ids).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.startDate = (String)Preconditions.checkNotNull((Object)startDate, (Object)"Required parameter startDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.START_DATE_PATTERN.matcher(startDate).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.endDate = (String)Preconditions.checkNotNull((Object)endDate, (Object)"Required parameter endDate must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.END_DATE_PATTERN.matcher(endDate).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.metrics = (String)Preconditions.checkNotNull((Object)metrics, (Object)"Required parameter metrics must be specified.");
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(metrics).matches(), (Object)"Parameter metrics must conform to the pattern ga:.+");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUserIp(String userIp) {
                    return (Get)super.setUserIp(userIp);
                }

                public String getIds() {
                    return this.ids;
                }

                public Get setIds(String ids) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.IDS_PATTERN.matcher(ids).matches(), (Object)"Parameter ids must conform to the pattern ga:[0-9]+");
                    }
                    this.ids = ids;
                    return this;
                }

                public String getStartDate() {
                    return this.startDate;
                }

                public Get setStartDate(String startDate) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.START_DATE_PATTERN.matcher(startDate).matches(), (Object)"Parameter startDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.startDate = startDate;
                    return this;
                }

                public String getEndDate() {
                    return this.endDate;
                }

                public Get setEndDate(String endDate) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.END_DATE_PATTERN.matcher(endDate).matches(), (Object)"Parameter endDate must conform to the pattern [0-9]{4}-[0-9]{2}-[0-9]{2}|today|yesterday|[0-9]+(daysAgo)");
                    }
                    this.endDate = endDate;
                    return this;
                }

                public String getMetrics() {
                    return this.metrics;
                }

                public Get setMetrics(String metrics) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.METRICS_PATTERN.matcher(metrics).matches(), (Object)"Parameter metrics must conform to the pattern ga:.+");
                    }
                    this.metrics = metrics;
                    return this;
                }

                public String getDimensions() {
                    return this.dimensions;
                }

                public Get setDimensions(String dimensions) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.DIMENSIONS_PATTERN.matcher(dimensions).matches(), (Object)"Parameter dimensions must conform to the pattern (ga:.+)?");
                    }
                    this.dimensions = dimensions;
                    return this;
                }

                public String getFilters() {
                    return this.filters;
                }

                public Get setFilters(String filters) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.FILTERS_PATTERN.matcher(filters).matches(), (Object)"Parameter filters must conform to the pattern ga:.+");
                    }
                    this.filters = filters;
                    return this;
                }

                public Boolean getIncludeEmptyRows() {
                    return this.includeEmptyRows;
                }

                public Get setIncludeEmptyRows(Boolean includeEmptyRows) {
                    this.includeEmptyRows = includeEmptyRows;
                    return this;
                }

                public Integer getMaxResults() {
                    return this.maxResults;
                }

                public Get setMaxResults(Integer maxResults) {
                    this.maxResults = maxResults;
                    return this;
                }

                public String getOutput() {
                    return this.output;
                }

                public Get setOutput(String output) {
                    this.output = output;
                    return this;
                }

                public String getSamplingLevel() {
                    return this.samplingLevel;
                }

                public Get setSamplingLevel(String samplingLevel) {
                    this.samplingLevel = samplingLevel;
                    return this;
                }

                public String getSegment() {
                    return this.segment;
                }

                public Get setSegment(String segment) {
                    this.segment = segment;
                    return this;
                }

                public String getSort() {
                    return this.sort;
                }

                public Get setSort(String sort) {
                    if (!Analytics.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.SORT_PATTERN.matcher(sort).matches(), (Object)"Parameter sort must conform to the pattern (-)?ga:.+");
                    }
                    this.sort = sort;
                    return this;
                }

                public Integer getStartIndex() {
                    return this.startIndex;
                }

                public Get setStartIndex(Integer startIndex) {
                    this.startIndex = startIndex;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }
    }
}

