/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/audit/audit_log.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.audit;

/**
 *
 *
 * <pre>
 * Identity delegation history of an authenticated service account.
 * </pre>
 *
 * Protobuf type {@code google.cloud.audit.ServiceAccountDelegationInfo}
 */
public final class ServiceAccountDelegationInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.audit.ServiceAccountDelegationInfo)
    ServiceAccountDelegationInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ServiceAccountDelegationInfo.newBuilder() to construct.
  private ServiceAccountDelegationInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServiceAccountDelegationInfo() {
    principalSubject_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServiceAccountDelegationInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.audit.AuditLogProto
        .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.audit.AuditLogProto
        .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.audit.ServiceAccountDelegationInfo.class,
            com.google.cloud.audit.ServiceAccountDelegationInfo.Builder.class);
  }

  public interface FirstPartyPrincipalOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The email address of a Google account.
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @return The principalEmail.
     */
    java.lang.String getPrincipalEmail();
    /**
     *
     *
     * <pre>
     * The email address of a Google account.
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @return The bytes for principalEmail.
     */
    com.google.protobuf.ByteString getPrincipalEmailBytes();

    /**
     *
     *
     * <pre>
     * Metadata about the service that uses the service account.
     * </pre>
     *
     * <code>.google.protobuf.Struct service_metadata = 2;</code>
     *
     * @return Whether the serviceMetadata field is set.
     */
    boolean hasServiceMetadata();
    /**
     *
     *
     * <pre>
     * Metadata about the service that uses the service account.
     * </pre>
     *
     * <code>.google.protobuf.Struct service_metadata = 2;</code>
     *
     * @return The serviceMetadata.
     */
    com.google.protobuf.Struct getServiceMetadata();
    /**
     *
     *
     * <pre>
     * Metadata about the service that uses the service account.
     * </pre>
     *
     * <code>.google.protobuf.Struct service_metadata = 2;</code>
     */
    com.google.protobuf.StructOrBuilder getServiceMetadataOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * First party identity principal.
   * </pre>
   *
   * Protobuf type {@code google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal}
   */
  public static final class FirstPartyPrincipal extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal)
      FirstPartyPrincipalOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use FirstPartyPrincipal.newBuilder() to construct.
    private FirstPartyPrincipal(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FirstPartyPrincipal() {
      principalEmail_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FirstPartyPrincipal();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_FirstPartyPrincipal_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_FirstPartyPrincipal_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal.class,
              com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal.Builder
                  .class);
    }

    private int bitField0_;
    public static final int PRINCIPAL_EMAIL_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object principalEmail_ = "";
    /**
     *
     *
     * <pre>
     * The email address of a Google account.
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @return The principalEmail.
     */
    @java.lang.Override
    public java.lang.String getPrincipalEmail() {
      java.lang.Object ref = principalEmail_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        principalEmail_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The email address of a Google account.
     * </pre>
     *
     * <code>string principal_email = 1;</code>
     *
     * @return The bytes for principalEmail.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPrincipalEmailBytes() {
      java.lang.Object ref = principalEmail_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        principalEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVICE_METADATA_FIELD_NUMBER = 2;
    private com.google.protobuf.Struct serviceMetadata_;
    /**
     *
     *
     * <pre>
     * Metadata about the service that uses the service account.
     * </pre>
     *
     * <code>.google.protobuf.Struct service_metadata = 2;</code>
     *
     * @return Whether the serviceMetadata field is set.
     */
    @java.lang.Override
    public boolean hasServiceMetadata() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metadata about the service that uses the service account.
     * </pre>
     *
     * <code>.google.protobuf.Struct service_metadata = 2;</code>
     *
     * @return The serviceMetadata.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getServiceMetadata() {
      return serviceMetadata_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : serviceMetadata_;
    }
    /**
     *
     *
     * <pre>
     * Metadata about the service that uses the service account.
     * </pre>
     *
     * <code>.google.protobuf.Struct service_metadata = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getServiceMetadataOrBuilder() {
      return serviceMetadata_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : serviceMetadata_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principalEmail_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, principalEmail_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getServiceMetadata());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principalEmail_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, principalEmail_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getServiceMetadata());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal)) {
        return super.equals(obj);
      }
      com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal other =
          (com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal) obj;

      if (!getPrincipalEmail().equals(other.getPrincipalEmail())) return false;
      if (hasServiceMetadata() != other.hasServiceMetadata()) return false;
      if (hasServiceMetadata()) {
        if (!getServiceMetadata().equals(other.getServiceMetadata())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PRINCIPAL_EMAIL_FIELD_NUMBER;
      hash = (53 * hash) + getPrincipalEmail().hashCode();
      if (hasServiceMetadata()) {
        hash = (37 * hash) + SERVICE_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getServiceMetadata().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * First party identity principal.
     * </pre>
     *
     * Protobuf type {@code google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal)
        com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipalOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.audit.AuditLogProto
            .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_FirstPartyPrincipal_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.audit.AuditLogProto
            .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_FirstPartyPrincipal_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal.class,
                com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getServiceMetadataFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        principalEmail_ = "";
        serviceMetadata_ = null;
        if (serviceMetadataBuilder_ != null) {
          serviceMetadataBuilder_.dispose();
          serviceMetadataBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.audit.AuditLogProto
            .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_FirstPartyPrincipal_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
          getDefaultInstanceForType() {
        return com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal build() {
        com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
          buildPartial() {
        com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal result =
            new com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.principalEmail_ = principalEmail_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.serviceMetadata_ =
              serviceMetadataBuilder_ == null ? serviceMetadata_ : serviceMetadataBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal) {
          return mergeFrom(
              (com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal other) {
        if (other
            == com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
                .getDefaultInstance()) return this;
        if (!other.getPrincipalEmail().isEmpty()) {
          principalEmail_ = other.principalEmail_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasServiceMetadata()) {
          mergeServiceMetadata(other.getServiceMetadata());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  principalEmail_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getServiceMetadataFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object principalEmail_ = "";
      /**
       *
       *
       * <pre>
       * The email address of a Google account.
       * </pre>
       *
       * <code>string principal_email = 1;</code>
       *
       * @return The principalEmail.
       */
      public java.lang.String getPrincipalEmail() {
        java.lang.Object ref = principalEmail_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          principalEmail_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The email address of a Google account.
       * </pre>
       *
       * <code>string principal_email = 1;</code>
       *
       * @return The bytes for principalEmail.
       */
      public com.google.protobuf.ByteString getPrincipalEmailBytes() {
        java.lang.Object ref = principalEmail_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          principalEmail_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The email address of a Google account.
       * </pre>
       *
       * <code>string principal_email = 1;</code>
       *
       * @param value The principalEmail to set.
       * @return This builder for chaining.
       */
      public Builder setPrincipalEmail(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        principalEmail_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The email address of a Google account.
       * </pre>
       *
       * <code>string principal_email = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrincipalEmail() {
        principalEmail_ = getDefaultInstance().getPrincipalEmail();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The email address of a Google account.
       * </pre>
       *
       * <code>string principal_email = 1;</code>
       *
       * @param value The bytes for principalEmail to set.
       * @return This builder for chaining.
       */
      public Builder setPrincipalEmailBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        principalEmail_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.Struct serviceMetadata_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          serviceMetadataBuilder_;
      /**
       *
       *
       * <pre>
       * Metadata about the service that uses the service account.
       * </pre>
       *
       * <code>.google.protobuf.Struct service_metadata = 2;</code>
       *
       * @return Whether the serviceMetadata field is set.
       */
      public boolean hasServiceMetadata() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Metadata about the service that uses the service account.
       * </pre>
       *
       * <code>.google.protobuf.Struct service_metadata = 2;</code>
       *
       * @return The serviceMetadata.
       */
      public com.google.protobuf.Struct getServiceMetadata() {
        if (serviceMetadataBuilder_ == null) {
          return serviceMetadata_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : serviceMetadata_;
        } else {
          return serviceMetadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Metadata about the service that uses the service account.
       * </pre>
       *
       * <code>.google.protobuf.Struct service_metadata = 2;</code>
       */
      public Builder setServiceMetadata(com.google.protobuf.Struct value) {
        if (serviceMetadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          serviceMetadata_ = value;
        } else {
          serviceMetadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata about the service that uses the service account.
       * </pre>
       *
       * <code>.google.protobuf.Struct service_metadata = 2;</code>
       */
      public Builder setServiceMetadata(com.google.protobuf.Struct.Builder builderForValue) {
        if (serviceMetadataBuilder_ == null) {
          serviceMetadata_ = builderForValue.build();
        } else {
          serviceMetadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata about the service that uses the service account.
       * </pre>
       *
       * <code>.google.protobuf.Struct service_metadata = 2;</code>
       */
      public Builder mergeServiceMetadata(com.google.protobuf.Struct value) {
        if (serviceMetadataBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && serviceMetadata_ != null
              && serviceMetadata_ != com.google.protobuf.Struct.getDefaultInstance()) {
            getServiceMetadataBuilder().mergeFrom(value);
          } else {
            serviceMetadata_ = value;
          }
        } else {
          serviceMetadataBuilder_.mergeFrom(value);
        }
        if (serviceMetadata_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata about the service that uses the service account.
       * </pre>
       *
       * <code>.google.protobuf.Struct service_metadata = 2;</code>
       */
      public Builder clearServiceMetadata() {
        bitField0_ = (bitField0_ & ~0x00000002);
        serviceMetadata_ = null;
        if (serviceMetadataBuilder_ != null) {
          serviceMetadataBuilder_.dispose();
          serviceMetadataBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata about the service that uses the service account.
       * </pre>
       *
       * <code>.google.protobuf.Struct service_metadata = 2;</code>
       */
      public com.google.protobuf.Struct.Builder getServiceMetadataBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getServiceMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Metadata about the service that uses the service account.
       * </pre>
       *
       * <code>.google.protobuf.Struct service_metadata = 2;</code>
       */
      public com.google.protobuf.StructOrBuilder getServiceMetadataOrBuilder() {
        if (serviceMetadataBuilder_ != null) {
          return serviceMetadataBuilder_.getMessageOrBuilder();
        } else {
          return serviceMetadata_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : serviceMetadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Metadata about the service that uses the service account.
       * </pre>
       *
       * <code>.google.protobuf.Struct service_metadata = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getServiceMetadataFieldBuilder() {
        if (serviceMetadataBuilder_ == null) {
          serviceMetadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getServiceMetadata(), getParentForChildren(), isClean());
          serviceMetadata_ = null;
        }
        return serviceMetadataBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal)
    private static final com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal();
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FirstPartyPrincipal> PARSER =
        new com.google.protobuf.AbstractParser<FirstPartyPrincipal>() {
          @java.lang.Override
          public FirstPartyPrincipal parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FirstPartyPrincipal> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FirstPartyPrincipal> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ThirdPartyPrincipalOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Metadata about third party identity.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_claims = 1;</code>
     *
     * @return Whether the thirdPartyClaims field is set.
     */
    boolean hasThirdPartyClaims();
    /**
     *
     *
     * <pre>
     * Metadata about third party identity.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_claims = 1;</code>
     *
     * @return The thirdPartyClaims.
     */
    com.google.protobuf.Struct getThirdPartyClaims();
    /**
     *
     *
     * <pre>
     * Metadata about third party identity.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_claims = 1;</code>
     */
    com.google.protobuf.StructOrBuilder getThirdPartyClaimsOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Third party identity principal.
   * </pre>
   *
   * Protobuf type {@code google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal}
   */
  public static final class ThirdPartyPrincipal extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal)
      ThirdPartyPrincipalOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ThirdPartyPrincipal.newBuilder() to construct.
    private ThirdPartyPrincipal(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ThirdPartyPrincipal() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ThirdPartyPrincipal();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_ThirdPartyPrincipal_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_ThirdPartyPrincipal_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal.class,
              com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal.Builder
                  .class);
    }

    private int bitField0_;
    public static final int THIRD_PARTY_CLAIMS_FIELD_NUMBER = 1;
    private com.google.protobuf.Struct thirdPartyClaims_;
    /**
     *
     *
     * <pre>
     * Metadata about third party identity.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_claims = 1;</code>
     *
     * @return Whether the thirdPartyClaims field is set.
     */
    @java.lang.Override
    public boolean hasThirdPartyClaims() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Metadata about third party identity.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_claims = 1;</code>
     *
     * @return The thirdPartyClaims.
     */
    @java.lang.Override
    public com.google.protobuf.Struct getThirdPartyClaims() {
      return thirdPartyClaims_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : thirdPartyClaims_;
    }
    /**
     *
     *
     * <pre>
     * Metadata about third party identity.
     * </pre>
     *
     * <code>.google.protobuf.Struct third_party_claims = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StructOrBuilder getThirdPartyClaimsOrBuilder() {
      return thirdPartyClaims_ == null
          ? com.google.protobuf.Struct.getDefaultInstance()
          : thirdPartyClaims_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getThirdPartyClaims());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getThirdPartyClaims());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal)) {
        return super.equals(obj);
      }
      com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal other =
          (com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal) obj;

      if (hasThirdPartyClaims() != other.hasThirdPartyClaims()) return false;
      if (hasThirdPartyClaims()) {
        if (!getThirdPartyClaims().equals(other.getThirdPartyClaims())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasThirdPartyClaims()) {
        hash = (37 * hash) + THIRD_PARTY_CLAIMS_FIELD_NUMBER;
        hash = (53 * hash) + getThirdPartyClaims().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Third party identity principal.
     * </pre>
     *
     * Protobuf type {@code google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal)
        com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipalOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.audit.AuditLogProto
            .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_ThirdPartyPrincipal_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.audit.AuditLogProto
            .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_ThirdPartyPrincipal_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal.class,
                com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getThirdPartyClaimsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        thirdPartyClaims_ = null;
        if (thirdPartyClaimsBuilder_ != null) {
          thirdPartyClaimsBuilder_.dispose();
          thirdPartyClaimsBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.audit.AuditLogProto
            .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_ThirdPartyPrincipal_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
          getDefaultInstanceForType() {
        return com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal build() {
        com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
          buildPartial() {
        com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal result =
            new com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.thirdPartyClaims_ =
              thirdPartyClaimsBuilder_ == null
                  ? thirdPartyClaims_
                  : thirdPartyClaimsBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal) {
          return mergeFrom(
              (com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal other) {
        if (other
            == com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
                .getDefaultInstance()) return this;
        if (other.hasThirdPartyClaims()) {
          mergeThirdPartyClaims(other.getThirdPartyClaims());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getThirdPartyClaimsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Struct thirdPartyClaims_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          thirdPartyClaimsBuilder_;
      /**
       *
       *
       * <pre>
       * Metadata about third party identity.
       * </pre>
       *
       * <code>.google.protobuf.Struct third_party_claims = 1;</code>
       *
       * @return Whether the thirdPartyClaims field is set.
       */
      public boolean hasThirdPartyClaims() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Metadata about third party identity.
       * </pre>
       *
       * <code>.google.protobuf.Struct third_party_claims = 1;</code>
       *
       * @return The thirdPartyClaims.
       */
      public com.google.protobuf.Struct getThirdPartyClaims() {
        if (thirdPartyClaimsBuilder_ == null) {
          return thirdPartyClaims_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : thirdPartyClaims_;
        } else {
          return thirdPartyClaimsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Metadata about third party identity.
       * </pre>
       *
       * <code>.google.protobuf.Struct third_party_claims = 1;</code>
       */
      public Builder setThirdPartyClaims(com.google.protobuf.Struct value) {
        if (thirdPartyClaimsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          thirdPartyClaims_ = value;
        } else {
          thirdPartyClaimsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata about third party identity.
       * </pre>
       *
       * <code>.google.protobuf.Struct third_party_claims = 1;</code>
       */
      public Builder setThirdPartyClaims(com.google.protobuf.Struct.Builder builderForValue) {
        if (thirdPartyClaimsBuilder_ == null) {
          thirdPartyClaims_ = builderForValue.build();
        } else {
          thirdPartyClaimsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata about third party identity.
       * </pre>
       *
       * <code>.google.protobuf.Struct third_party_claims = 1;</code>
       */
      public Builder mergeThirdPartyClaims(com.google.protobuf.Struct value) {
        if (thirdPartyClaimsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && thirdPartyClaims_ != null
              && thirdPartyClaims_ != com.google.protobuf.Struct.getDefaultInstance()) {
            getThirdPartyClaimsBuilder().mergeFrom(value);
          } else {
            thirdPartyClaims_ = value;
          }
        } else {
          thirdPartyClaimsBuilder_.mergeFrom(value);
        }
        if (thirdPartyClaims_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata about third party identity.
       * </pre>
       *
       * <code>.google.protobuf.Struct third_party_claims = 1;</code>
       */
      public Builder clearThirdPartyClaims() {
        bitField0_ = (bitField0_ & ~0x00000001);
        thirdPartyClaims_ = null;
        if (thirdPartyClaimsBuilder_ != null) {
          thirdPartyClaimsBuilder_.dispose();
          thirdPartyClaimsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Metadata about third party identity.
       * </pre>
       *
       * <code>.google.protobuf.Struct third_party_claims = 1;</code>
       */
      public com.google.protobuf.Struct.Builder getThirdPartyClaimsBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getThirdPartyClaimsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Metadata about third party identity.
       * </pre>
       *
       * <code>.google.protobuf.Struct third_party_claims = 1;</code>
       */
      public com.google.protobuf.StructOrBuilder getThirdPartyClaimsOrBuilder() {
        if (thirdPartyClaimsBuilder_ != null) {
          return thirdPartyClaimsBuilder_.getMessageOrBuilder();
        } else {
          return thirdPartyClaims_ == null
              ? com.google.protobuf.Struct.getDefaultInstance()
              : thirdPartyClaims_;
        }
      }
      /**
       *
       *
       * <pre>
       * Metadata about third party identity.
       * </pre>
       *
       * <code>.google.protobuf.Struct third_party_claims = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Struct,
              com.google.protobuf.Struct.Builder,
              com.google.protobuf.StructOrBuilder>
          getThirdPartyClaimsFieldBuilder() {
        if (thirdPartyClaimsBuilder_ == null) {
          thirdPartyClaimsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Struct,
                  com.google.protobuf.Struct.Builder,
                  com.google.protobuf.StructOrBuilder>(
                  getThirdPartyClaims(), getParentForChildren(), isClean());
          thirdPartyClaims_ = null;
        }
        return thirdPartyClaimsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal)
    private static final com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal();
    }

    public static com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ThirdPartyPrincipal> PARSER =
        new com.google.protobuf.AbstractParser<ThirdPartyPrincipal>() {
          @java.lang.Override
          public ThirdPartyPrincipal parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ThirdPartyPrincipal> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ThirdPartyPrincipal> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int authorityCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object authority_;

  public enum AuthorityCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    FIRST_PARTY_PRINCIPAL(1),
    THIRD_PARTY_PRINCIPAL(2),
    AUTHORITY_NOT_SET(0);
    private final int value;

    private AuthorityCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AuthorityCase valueOf(int value) {
      return forNumber(value);
    }

    public static AuthorityCase forNumber(int value) {
      switch (value) {
        case 1:
          return FIRST_PARTY_PRINCIPAL;
        case 2:
          return THIRD_PARTY_PRINCIPAL;
        case 0:
          return AUTHORITY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AuthorityCase getAuthorityCase() {
    return AuthorityCase.forNumber(authorityCase_);
  }

  public static final int PRINCIPAL_SUBJECT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object principalSubject_ = "";
  /**
   *
   *
   * <pre>
   * A string representing the principal_subject associated with the identity.
   * For most identities, the format will be
   * `principal://iam.googleapis.com/{identity pool name}/subject/{subject)`
   * except for some GKE identities (GKE_WORKLOAD, FREEFORM, GKE_HUB_WORKLOAD)
   * that are still in the legacy format `serviceAccount:{identity pool
   * name}[{subject}]`
   * </pre>
   *
   * <code>string principal_subject = 3;</code>
   *
   * @return The principalSubject.
   */
  @java.lang.Override
  public java.lang.String getPrincipalSubject() {
    java.lang.Object ref = principalSubject_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      principalSubject_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A string representing the principal_subject associated with the identity.
   * For most identities, the format will be
   * `principal://iam.googleapis.com/{identity pool name}/subject/{subject)`
   * except for some GKE identities (GKE_WORKLOAD, FREEFORM, GKE_HUB_WORKLOAD)
   * that are still in the legacy format `serviceAccount:{identity pool
   * name}[{subject}]`
   * </pre>
   *
   * <code>string principal_subject = 3;</code>
   *
   * @return The bytes for principalSubject.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPrincipalSubjectBytes() {
    java.lang.Object ref = principalSubject_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      principalSubject_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FIRST_PARTY_PRINCIPAL_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * First party (Google) identity as the real authority.
   * </pre>
   *
   * <code>
   * .google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal first_party_principal = 1;
   * </code>
   *
   * @return Whether the firstPartyPrincipal field is set.
   */
  @java.lang.Override
  public boolean hasFirstPartyPrincipal() {
    return authorityCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * First party (Google) identity as the real authority.
   * </pre>
   *
   * <code>
   * .google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal first_party_principal = 1;
   * </code>
   *
   * @return The firstPartyPrincipal.
   */
  @java.lang.Override
  public com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
      getFirstPartyPrincipal() {
    if (authorityCase_ == 1) {
      return (com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal) authority_;
    }
    return com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * First party (Google) identity as the real authority.
   * </pre>
   *
   * <code>
   * .google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal first_party_principal = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipalOrBuilder
      getFirstPartyPrincipalOrBuilder() {
    if (authorityCase_ == 1) {
      return (com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal) authority_;
    }
    return com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
        .getDefaultInstance();
  }

  public static final int THIRD_PARTY_PRINCIPAL_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Third party identity as the real authority.
   * </pre>
   *
   * <code>
   * .google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal third_party_principal = 2;
   * </code>
   *
   * @return Whether the thirdPartyPrincipal field is set.
   */
  @java.lang.Override
  public boolean hasThirdPartyPrincipal() {
    return authorityCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Third party identity as the real authority.
   * </pre>
   *
   * <code>
   * .google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal third_party_principal = 2;
   * </code>
   *
   * @return The thirdPartyPrincipal.
   */
  @java.lang.Override
  public com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
      getThirdPartyPrincipal() {
    if (authorityCase_ == 2) {
      return (com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal) authority_;
    }
    return com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Third party identity as the real authority.
   * </pre>
   *
   * <code>
   * .google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal third_party_principal = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipalOrBuilder
      getThirdPartyPrincipalOrBuilder() {
    if (authorityCase_ == 2) {
      return (com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal) authority_;
    }
    return com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (authorityCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal) authority_);
    }
    if (authorityCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal) authority_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principalSubject_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, principalSubject_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (authorityCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal) authority_);
    }
    if (authorityCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal) authority_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(principalSubject_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, principalSubject_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.audit.ServiceAccountDelegationInfo)) {
      return super.equals(obj);
    }
    com.google.cloud.audit.ServiceAccountDelegationInfo other =
        (com.google.cloud.audit.ServiceAccountDelegationInfo) obj;

    if (!getPrincipalSubject().equals(other.getPrincipalSubject())) return false;
    if (!getAuthorityCase().equals(other.getAuthorityCase())) return false;
    switch (authorityCase_) {
      case 1:
        if (!getFirstPartyPrincipal().equals(other.getFirstPartyPrincipal())) return false;
        break;
      case 2:
        if (!getThirdPartyPrincipal().equals(other.getThirdPartyPrincipal())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PRINCIPAL_SUBJECT_FIELD_NUMBER;
    hash = (53 * hash) + getPrincipalSubject().hashCode();
    switch (authorityCase_) {
      case 1:
        hash = (37 * hash) + FIRST_PARTY_PRINCIPAL_FIELD_NUMBER;
        hash = (53 * hash) + getFirstPartyPrincipal().hashCode();
        break;
      case 2:
        hash = (37 * hash) + THIRD_PARTY_PRINCIPAL_FIELD_NUMBER;
        hash = (53 * hash) + getThirdPartyPrincipal().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.audit.ServiceAccountDelegationInfo parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.audit.ServiceAccountDelegationInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.audit.ServiceAccountDelegationInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.audit.ServiceAccountDelegationInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.audit.ServiceAccountDelegationInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.audit.ServiceAccountDelegationInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.audit.ServiceAccountDelegationInfo parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.audit.ServiceAccountDelegationInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.audit.ServiceAccountDelegationInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.audit.ServiceAccountDelegationInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.audit.ServiceAccountDelegationInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.audit.ServiceAccountDelegationInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.audit.ServiceAccountDelegationInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Identity delegation history of an authenticated service account.
   * </pre>
   *
   * Protobuf type {@code google.cloud.audit.ServiceAccountDelegationInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.audit.ServiceAccountDelegationInfo)
      com.google.cloud.audit.ServiceAccountDelegationInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.audit.ServiceAccountDelegationInfo.class,
              com.google.cloud.audit.ServiceAccountDelegationInfo.Builder.class);
    }

    // Construct using com.google.cloud.audit.ServiceAccountDelegationInfo.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      principalSubject_ = "";
      if (firstPartyPrincipalBuilder_ != null) {
        firstPartyPrincipalBuilder_.clear();
      }
      if (thirdPartyPrincipalBuilder_ != null) {
        thirdPartyPrincipalBuilder_.clear();
      }
      authorityCase_ = 0;
      authority_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.audit.AuditLogProto
          .internal_static_google_cloud_audit_ServiceAccountDelegationInfo_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.audit.ServiceAccountDelegationInfo getDefaultInstanceForType() {
      return com.google.cloud.audit.ServiceAccountDelegationInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.audit.ServiceAccountDelegationInfo build() {
      com.google.cloud.audit.ServiceAccountDelegationInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.audit.ServiceAccountDelegationInfo buildPartial() {
      com.google.cloud.audit.ServiceAccountDelegationInfo result =
          new com.google.cloud.audit.ServiceAccountDelegationInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.audit.ServiceAccountDelegationInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.principalSubject_ = principalSubject_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.audit.ServiceAccountDelegationInfo result) {
      result.authorityCase_ = authorityCase_;
      result.authority_ = this.authority_;
      if (authorityCase_ == 1 && firstPartyPrincipalBuilder_ != null) {
        result.authority_ = firstPartyPrincipalBuilder_.build();
      }
      if (authorityCase_ == 2 && thirdPartyPrincipalBuilder_ != null) {
        result.authority_ = thirdPartyPrincipalBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.audit.ServiceAccountDelegationInfo) {
        return mergeFrom((com.google.cloud.audit.ServiceAccountDelegationInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.audit.ServiceAccountDelegationInfo other) {
      if (other == com.google.cloud.audit.ServiceAccountDelegationInfo.getDefaultInstance())
        return this;
      if (!other.getPrincipalSubject().isEmpty()) {
        principalSubject_ = other.principalSubject_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getAuthorityCase()) {
        case FIRST_PARTY_PRINCIPAL:
          {
            mergeFirstPartyPrincipal(other.getFirstPartyPrincipal());
            break;
          }
        case THIRD_PARTY_PRINCIPAL:
          {
            mergeThirdPartyPrincipal(other.getThirdPartyPrincipal());
            break;
          }
        case AUTHORITY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getFirstPartyPrincipalFieldBuilder().getBuilder(), extensionRegistry);
                authorityCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getThirdPartyPrincipalFieldBuilder().getBuilder(), extensionRegistry);
                authorityCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                principalSubject_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int authorityCase_ = 0;
    private java.lang.Object authority_;

    public AuthorityCase getAuthorityCase() {
      return AuthorityCase.forNumber(authorityCase_);
    }

    public Builder clearAuthority() {
      authorityCase_ = 0;
      authority_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object principalSubject_ = "";
    /**
     *
     *
     * <pre>
     * A string representing the principal_subject associated with the identity.
     * For most identities, the format will be
     * `principal://iam.googleapis.com/{identity pool name}/subject/{subject)`
     * except for some GKE identities (GKE_WORKLOAD, FREEFORM, GKE_HUB_WORKLOAD)
     * that are still in the legacy format `serviceAccount:{identity pool
     * name}[{subject}]`
     * </pre>
     *
     * <code>string principal_subject = 3;</code>
     *
     * @return The principalSubject.
     */
    public java.lang.String getPrincipalSubject() {
      java.lang.Object ref = principalSubject_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        principalSubject_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A string representing the principal_subject associated with the identity.
     * For most identities, the format will be
     * `principal://iam.googleapis.com/{identity pool name}/subject/{subject)`
     * except for some GKE identities (GKE_WORKLOAD, FREEFORM, GKE_HUB_WORKLOAD)
     * that are still in the legacy format `serviceAccount:{identity pool
     * name}[{subject}]`
     * </pre>
     *
     * <code>string principal_subject = 3;</code>
     *
     * @return The bytes for principalSubject.
     */
    public com.google.protobuf.ByteString getPrincipalSubjectBytes() {
      java.lang.Object ref = principalSubject_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        principalSubject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A string representing the principal_subject associated with the identity.
     * For most identities, the format will be
     * `principal://iam.googleapis.com/{identity pool name}/subject/{subject)`
     * except for some GKE identities (GKE_WORKLOAD, FREEFORM, GKE_HUB_WORKLOAD)
     * that are still in the legacy format `serviceAccount:{identity pool
     * name}[{subject}]`
     * </pre>
     *
     * <code>string principal_subject = 3;</code>
     *
     * @param value The principalSubject to set.
     * @return This builder for chaining.
     */
    public Builder setPrincipalSubject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      principalSubject_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A string representing the principal_subject associated with the identity.
     * For most identities, the format will be
     * `principal://iam.googleapis.com/{identity pool name}/subject/{subject)`
     * except for some GKE identities (GKE_WORKLOAD, FREEFORM, GKE_HUB_WORKLOAD)
     * that are still in the legacy format `serviceAccount:{identity pool
     * name}[{subject}]`
     * </pre>
     *
     * <code>string principal_subject = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrincipalSubject() {
      principalSubject_ = getDefaultInstance().getPrincipalSubject();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A string representing the principal_subject associated with the identity.
     * For most identities, the format will be
     * `principal://iam.googleapis.com/{identity pool name}/subject/{subject)`
     * except for some GKE identities (GKE_WORKLOAD, FREEFORM, GKE_HUB_WORKLOAD)
     * that are still in the legacy format `serviceAccount:{identity pool
     * name}[{subject}]`
     * </pre>
     *
     * <code>string principal_subject = 3;</code>
     *
     * @param value The bytes for principalSubject to set.
     * @return This builder for chaining.
     */
    public Builder setPrincipalSubjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      principalSubject_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal,
            com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal.Builder,
            com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipalOrBuilder>
        firstPartyPrincipalBuilder_;
    /**
     *
     *
     * <pre>
     * First party (Google) identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal first_party_principal = 1;
     * </code>
     *
     * @return Whether the firstPartyPrincipal field is set.
     */
    @java.lang.Override
    public boolean hasFirstPartyPrincipal() {
      return authorityCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * First party (Google) identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal first_party_principal = 1;
     * </code>
     *
     * @return The firstPartyPrincipal.
     */
    @java.lang.Override
    public com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
        getFirstPartyPrincipal() {
      if (firstPartyPrincipalBuilder_ == null) {
        if (authorityCase_ == 1) {
          return (com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal)
              authority_;
        }
        return com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
            .getDefaultInstance();
      } else {
        if (authorityCase_ == 1) {
          return firstPartyPrincipalBuilder_.getMessage();
        }
        return com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * First party (Google) identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal first_party_principal = 1;
     * </code>
     */
    public Builder setFirstPartyPrincipal(
        com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal value) {
      if (firstPartyPrincipalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authority_ = value;
        onChanged();
      } else {
        firstPartyPrincipalBuilder_.setMessage(value);
      }
      authorityCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * First party (Google) identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal first_party_principal = 1;
     * </code>
     */
    public Builder setFirstPartyPrincipal(
        com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal.Builder
            builderForValue) {
      if (firstPartyPrincipalBuilder_ == null) {
        authority_ = builderForValue.build();
        onChanged();
      } else {
        firstPartyPrincipalBuilder_.setMessage(builderForValue.build());
      }
      authorityCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * First party (Google) identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal first_party_principal = 1;
     * </code>
     */
    public Builder mergeFirstPartyPrincipal(
        com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal value) {
      if (firstPartyPrincipalBuilder_ == null) {
        if (authorityCase_ == 1
            && authority_
                != com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
                    .getDefaultInstance()) {
          authority_ =
              com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal.newBuilder(
                      (com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal)
                          authority_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authority_ = value;
        }
        onChanged();
      } else {
        if (authorityCase_ == 1) {
          firstPartyPrincipalBuilder_.mergeFrom(value);
        } else {
          firstPartyPrincipalBuilder_.setMessage(value);
        }
      }
      authorityCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * First party (Google) identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal first_party_principal = 1;
     * </code>
     */
    public Builder clearFirstPartyPrincipal() {
      if (firstPartyPrincipalBuilder_ == null) {
        if (authorityCase_ == 1) {
          authorityCase_ = 0;
          authority_ = null;
          onChanged();
        }
      } else {
        if (authorityCase_ == 1) {
          authorityCase_ = 0;
          authority_ = null;
        }
        firstPartyPrincipalBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * First party (Google) identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal first_party_principal = 1;
     * </code>
     */
    public com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal.Builder
        getFirstPartyPrincipalBuilder() {
      return getFirstPartyPrincipalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * First party (Google) identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal first_party_principal = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipalOrBuilder
        getFirstPartyPrincipalOrBuilder() {
      if ((authorityCase_ == 1) && (firstPartyPrincipalBuilder_ != null)) {
        return firstPartyPrincipalBuilder_.getMessageOrBuilder();
      } else {
        if (authorityCase_ == 1) {
          return (com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal)
              authority_;
        }
        return com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * First party (Google) identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal first_party_principal = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal,
            com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal.Builder,
            com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipalOrBuilder>
        getFirstPartyPrincipalFieldBuilder() {
      if (firstPartyPrincipalBuilder_ == null) {
        if (!(authorityCase_ == 1)) {
          authority_ =
              com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
                  .getDefaultInstance();
        }
        firstPartyPrincipalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal,
                com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal.Builder,
                com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipalOrBuilder>(
                (com.google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal)
                    authority_,
                getParentForChildren(),
                isClean());
        authority_ = null;
      }
      authorityCase_ = 1;
      onChanged();
      return firstPartyPrincipalBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal,
            com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal.Builder,
            com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipalOrBuilder>
        thirdPartyPrincipalBuilder_;
    /**
     *
     *
     * <pre>
     * Third party identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal third_party_principal = 2;
     * </code>
     *
     * @return Whether the thirdPartyPrincipal field is set.
     */
    @java.lang.Override
    public boolean hasThirdPartyPrincipal() {
      return authorityCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Third party identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal third_party_principal = 2;
     * </code>
     *
     * @return The thirdPartyPrincipal.
     */
    @java.lang.Override
    public com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
        getThirdPartyPrincipal() {
      if (thirdPartyPrincipalBuilder_ == null) {
        if (authorityCase_ == 2) {
          return (com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal)
              authority_;
        }
        return com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
            .getDefaultInstance();
      } else {
        if (authorityCase_ == 2) {
          return thirdPartyPrincipalBuilder_.getMessage();
        }
        return com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Third party identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal third_party_principal = 2;
     * </code>
     */
    public Builder setThirdPartyPrincipal(
        com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal value) {
      if (thirdPartyPrincipalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authority_ = value;
        onChanged();
      } else {
        thirdPartyPrincipalBuilder_.setMessage(value);
      }
      authorityCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Third party identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal third_party_principal = 2;
     * </code>
     */
    public Builder setThirdPartyPrincipal(
        com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal.Builder
            builderForValue) {
      if (thirdPartyPrincipalBuilder_ == null) {
        authority_ = builderForValue.build();
        onChanged();
      } else {
        thirdPartyPrincipalBuilder_.setMessage(builderForValue.build());
      }
      authorityCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Third party identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal third_party_principal = 2;
     * </code>
     */
    public Builder mergeThirdPartyPrincipal(
        com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal value) {
      if (thirdPartyPrincipalBuilder_ == null) {
        if (authorityCase_ == 2
            && authority_
                != com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
                    .getDefaultInstance()) {
          authority_ =
              com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal.newBuilder(
                      (com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal)
                          authority_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authority_ = value;
        }
        onChanged();
      } else {
        if (authorityCase_ == 2) {
          thirdPartyPrincipalBuilder_.mergeFrom(value);
        } else {
          thirdPartyPrincipalBuilder_.setMessage(value);
        }
      }
      authorityCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Third party identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal third_party_principal = 2;
     * </code>
     */
    public Builder clearThirdPartyPrincipal() {
      if (thirdPartyPrincipalBuilder_ == null) {
        if (authorityCase_ == 2) {
          authorityCase_ = 0;
          authority_ = null;
          onChanged();
        }
      } else {
        if (authorityCase_ == 2) {
          authorityCase_ = 0;
          authority_ = null;
        }
        thirdPartyPrincipalBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Third party identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal third_party_principal = 2;
     * </code>
     */
    public com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal.Builder
        getThirdPartyPrincipalBuilder() {
      return getThirdPartyPrincipalFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Third party identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal third_party_principal = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipalOrBuilder
        getThirdPartyPrincipalOrBuilder() {
      if ((authorityCase_ == 2) && (thirdPartyPrincipalBuilder_ != null)) {
        return thirdPartyPrincipalBuilder_.getMessageOrBuilder();
      } else {
        if (authorityCase_ == 2) {
          return (com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal)
              authority_;
        }
        return com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Third party identity as the real authority.
     * </pre>
     *
     * <code>
     * .google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal third_party_principal = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal,
            com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal.Builder,
            com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipalOrBuilder>
        getThirdPartyPrincipalFieldBuilder() {
      if (thirdPartyPrincipalBuilder_ == null) {
        if (!(authorityCase_ == 2)) {
          authority_ =
              com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
                  .getDefaultInstance();
        }
        thirdPartyPrincipalBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal,
                com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal.Builder,
                com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipalOrBuilder>(
                (com.google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal)
                    authority_,
                getParentForChildren(),
                isClean());
        authority_ = null;
      }
      authorityCase_ = 2;
      onChanged();
      return thirdPartyPrincipalBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.audit.ServiceAccountDelegationInfo)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.audit.ServiceAccountDelegationInfo)
  private static final com.google.cloud.audit.ServiceAccountDelegationInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.audit.ServiceAccountDelegationInfo();
  }

  public static com.google.cloud.audit.ServiceAccountDelegationInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServiceAccountDelegationInfo> PARSER =
      new com.google.protobuf.AbstractParser<ServiceAccountDelegationInfo>() {
        @java.lang.Override
        public ServiceAccountDelegationInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServiceAccountDelegationInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServiceAccountDelegationInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.audit.ServiceAccountDelegationInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
