/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/client.proto

package com.google.api;

/**
 *
 *
 * <pre>
 * Details about how and where to publish client libraries.
 * </pre>
 *
 * Protobuf type {@code google.api.ClientLibrarySettings}
 */
public final class ClientLibrarySettings extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.ClientLibrarySettings)
    ClientLibrarySettingsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ClientLibrarySettings.newBuilder() to construct.
  private ClientLibrarySettings(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ClientLibrarySettings() {
    version_ = "";
    launchStage_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ClientLibrarySettings();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.ClientProto.internal_static_google_api_ClientLibrarySettings_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.ClientProto
        .internal_static_google_api_ClientLibrarySettings_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.ClientLibrarySettings.class,
            com.google.api.ClientLibrarySettings.Builder.class);
  }

  public static final int VERSION_FIELD_NUMBER = 1;
  private volatile java.lang.Object version_;
  /**
   *
   *
   * <pre>
   * Version of the API to apply these settings to.
   * </pre>
   *
   * <code>string version = 1;</code>
   *
   * @return The version.
   */
  @java.lang.Override
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Version of the API to apply these settings to.
   * </pre>
   *
   * <code>string version = 1;</code>
   *
   * @return The bytes for version.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAUNCH_STAGE_FIELD_NUMBER = 2;
  private int launchStage_;
  /**
   *
   *
   * <pre>
   * Launch stage of this version of the API.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 2;</code>
   *
   * @return The enum numeric value on the wire for launchStage.
   */
  @java.lang.Override
  public int getLaunchStageValue() {
    return launchStage_;
  }
  /**
   *
   *
   * <pre>
   * Launch stage of this version of the API.
   * </pre>
   *
   * <code>.google.api.LaunchStage launch_stage = 2;</code>
   *
   * @return The launchStage.
   */
  @java.lang.Override
  public com.google.api.LaunchStage getLaunchStage() {
    @SuppressWarnings("deprecation")
    com.google.api.LaunchStage result = com.google.api.LaunchStage.valueOf(launchStage_);
    return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
  }

  public static final int REST_NUMERIC_ENUMS_FIELD_NUMBER = 3;
  private boolean restNumericEnums_;
  /**
   *
   *
   * <pre>
   * When using transport=rest, the client request will encode enums as
   * numbers rather than strings.
   * </pre>
   *
   * <code>bool rest_numeric_enums = 3;</code>
   *
   * @return The restNumericEnums.
   */
  @java.lang.Override
  public boolean getRestNumericEnums() {
    return restNumericEnums_;
  }

  public static final int JAVA_SETTINGS_FIELD_NUMBER = 21;
  private com.google.api.JavaSettings javaSettings_;
  /**
   *
   *
   * <pre>
   * Settings for legacy Java features, supported in the Service YAML.
   * </pre>
   *
   * <code>.google.api.JavaSettings java_settings = 21;</code>
   *
   * @return Whether the javaSettings field is set.
   */
  @java.lang.Override
  public boolean hasJavaSettings() {
    return javaSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings for legacy Java features, supported in the Service YAML.
   * </pre>
   *
   * <code>.google.api.JavaSettings java_settings = 21;</code>
   *
   * @return The javaSettings.
   */
  @java.lang.Override
  public com.google.api.JavaSettings getJavaSettings() {
    return javaSettings_ == null ? com.google.api.JavaSettings.getDefaultInstance() : javaSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for legacy Java features, supported in the Service YAML.
   * </pre>
   *
   * <code>.google.api.JavaSettings java_settings = 21;</code>
   */
  @java.lang.Override
  public com.google.api.JavaSettingsOrBuilder getJavaSettingsOrBuilder() {
    return getJavaSettings();
  }

  public static final int CPP_SETTINGS_FIELD_NUMBER = 22;
  private com.google.api.CppSettings cppSettings_;
  /**
   *
   *
   * <pre>
   * Settings for C++ client libraries.
   * </pre>
   *
   * <code>.google.api.CppSettings cpp_settings = 22;</code>
   *
   * @return Whether the cppSettings field is set.
   */
  @java.lang.Override
  public boolean hasCppSettings() {
    return cppSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings for C++ client libraries.
   * </pre>
   *
   * <code>.google.api.CppSettings cpp_settings = 22;</code>
   *
   * @return The cppSettings.
   */
  @java.lang.Override
  public com.google.api.CppSettings getCppSettings() {
    return cppSettings_ == null ? com.google.api.CppSettings.getDefaultInstance() : cppSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for C++ client libraries.
   * </pre>
   *
   * <code>.google.api.CppSettings cpp_settings = 22;</code>
   */
  @java.lang.Override
  public com.google.api.CppSettingsOrBuilder getCppSettingsOrBuilder() {
    return getCppSettings();
  }

  public static final int PHP_SETTINGS_FIELD_NUMBER = 23;
  private com.google.api.PhpSettings phpSettings_;
  /**
   *
   *
   * <pre>
   * Settings for PHP client libraries.
   * </pre>
   *
   * <code>.google.api.PhpSettings php_settings = 23;</code>
   *
   * @return Whether the phpSettings field is set.
   */
  @java.lang.Override
  public boolean hasPhpSettings() {
    return phpSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings for PHP client libraries.
   * </pre>
   *
   * <code>.google.api.PhpSettings php_settings = 23;</code>
   *
   * @return The phpSettings.
   */
  @java.lang.Override
  public com.google.api.PhpSettings getPhpSettings() {
    return phpSettings_ == null ? com.google.api.PhpSettings.getDefaultInstance() : phpSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for PHP client libraries.
   * </pre>
   *
   * <code>.google.api.PhpSettings php_settings = 23;</code>
   */
  @java.lang.Override
  public com.google.api.PhpSettingsOrBuilder getPhpSettingsOrBuilder() {
    return getPhpSettings();
  }

  public static final int PYTHON_SETTINGS_FIELD_NUMBER = 24;
  private com.google.api.PythonSettings pythonSettings_;
  /**
   *
   *
   * <pre>
   * Settings for Python client libraries.
   * </pre>
   *
   * <code>.google.api.PythonSettings python_settings = 24;</code>
   *
   * @return Whether the pythonSettings field is set.
   */
  @java.lang.Override
  public boolean hasPythonSettings() {
    return pythonSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings for Python client libraries.
   * </pre>
   *
   * <code>.google.api.PythonSettings python_settings = 24;</code>
   *
   * @return The pythonSettings.
   */
  @java.lang.Override
  public com.google.api.PythonSettings getPythonSettings() {
    return pythonSettings_ == null
        ? com.google.api.PythonSettings.getDefaultInstance()
        : pythonSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for Python client libraries.
   * </pre>
   *
   * <code>.google.api.PythonSettings python_settings = 24;</code>
   */
  @java.lang.Override
  public com.google.api.PythonSettingsOrBuilder getPythonSettingsOrBuilder() {
    return getPythonSettings();
  }

  public static final int NODE_SETTINGS_FIELD_NUMBER = 25;
  private com.google.api.NodeSettings nodeSettings_;
  /**
   *
   *
   * <pre>
   * Settings for Node client libraries.
   * </pre>
   *
   * <code>.google.api.NodeSettings node_settings = 25;</code>
   *
   * @return Whether the nodeSettings field is set.
   */
  @java.lang.Override
  public boolean hasNodeSettings() {
    return nodeSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings for Node client libraries.
   * </pre>
   *
   * <code>.google.api.NodeSettings node_settings = 25;</code>
   *
   * @return The nodeSettings.
   */
  @java.lang.Override
  public com.google.api.NodeSettings getNodeSettings() {
    return nodeSettings_ == null ? com.google.api.NodeSettings.getDefaultInstance() : nodeSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for Node client libraries.
   * </pre>
   *
   * <code>.google.api.NodeSettings node_settings = 25;</code>
   */
  @java.lang.Override
  public com.google.api.NodeSettingsOrBuilder getNodeSettingsOrBuilder() {
    return getNodeSettings();
  }

  public static final int DOTNET_SETTINGS_FIELD_NUMBER = 26;
  private com.google.api.DotnetSettings dotnetSettings_;
  /**
   *
   *
   * <pre>
   * Settings for .NET client libraries.
   * </pre>
   *
   * <code>.google.api.DotnetSettings dotnet_settings = 26;</code>
   *
   * @return Whether the dotnetSettings field is set.
   */
  @java.lang.Override
  public boolean hasDotnetSettings() {
    return dotnetSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings for .NET client libraries.
   * </pre>
   *
   * <code>.google.api.DotnetSettings dotnet_settings = 26;</code>
   *
   * @return The dotnetSettings.
   */
  @java.lang.Override
  public com.google.api.DotnetSettings getDotnetSettings() {
    return dotnetSettings_ == null
        ? com.google.api.DotnetSettings.getDefaultInstance()
        : dotnetSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for .NET client libraries.
   * </pre>
   *
   * <code>.google.api.DotnetSettings dotnet_settings = 26;</code>
   */
  @java.lang.Override
  public com.google.api.DotnetSettingsOrBuilder getDotnetSettingsOrBuilder() {
    return getDotnetSettings();
  }

  public static final int RUBY_SETTINGS_FIELD_NUMBER = 27;
  private com.google.api.RubySettings rubySettings_;
  /**
   *
   *
   * <pre>
   * Settings for Ruby client libraries.
   * </pre>
   *
   * <code>.google.api.RubySettings ruby_settings = 27;</code>
   *
   * @return Whether the rubySettings field is set.
   */
  @java.lang.Override
  public boolean hasRubySettings() {
    return rubySettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings for Ruby client libraries.
   * </pre>
   *
   * <code>.google.api.RubySettings ruby_settings = 27;</code>
   *
   * @return The rubySettings.
   */
  @java.lang.Override
  public com.google.api.RubySettings getRubySettings() {
    return rubySettings_ == null ? com.google.api.RubySettings.getDefaultInstance() : rubySettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for Ruby client libraries.
   * </pre>
   *
   * <code>.google.api.RubySettings ruby_settings = 27;</code>
   */
  @java.lang.Override
  public com.google.api.RubySettingsOrBuilder getRubySettingsOrBuilder() {
    return getRubySettings();
  }

  public static final int GO_SETTINGS_FIELD_NUMBER = 28;
  private com.google.api.GoSettings goSettings_;
  /**
   *
   *
   * <pre>
   * Settings for Go client libraries.
   * </pre>
   *
   * <code>.google.api.GoSettings go_settings = 28;</code>
   *
   * @return Whether the goSettings field is set.
   */
  @java.lang.Override
  public boolean hasGoSettings() {
    return goSettings_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings for Go client libraries.
   * </pre>
   *
   * <code>.google.api.GoSettings go_settings = 28;</code>
   *
   * @return The goSettings.
   */
  @java.lang.Override
  public com.google.api.GoSettings getGoSettings() {
    return goSettings_ == null ? com.google.api.GoSettings.getDefaultInstance() : goSettings_;
  }
  /**
   *
   *
   * <pre>
   * Settings for Go client libraries.
   * </pre>
   *
   * <code>.google.api.GoSettings go_settings = 28;</code>
   */
  @java.lang.Override
  public com.google.api.GoSettingsOrBuilder getGoSettingsOrBuilder() {
    return getGoSettings();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, launchStage_);
    }
    if (restNumericEnums_ != false) {
      output.writeBool(3, restNumericEnums_);
    }
    if (javaSettings_ != null) {
      output.writeMessage(21, getJavaSettings());
    }
    if (cppSettings_ != null) {
      output.writeMessage(22, getCppSettings());
    }
    if (phpSettings_ != null) {
      output.writeMessage(23, getPhpSettings());
    }
    if (pythonSettings_ != null) {
      output.writeMessage(24, getPythonSettings());
    }
    if (nodeSettings_ != null) {
      output.writeMessage(25, getNodeSettings());
    }
    if (dotnetSettings_ != null) {
      output.writeMessage(26, getDotnetSettings());
    }
    if (rubySettings_ != null) {
      output.writeMessage(27, getRubySettings());
    }
    if (goSettings_ != null) {
      output.writeMessage(28, getGoSettings());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
    }
    if (launchStage_ != com.google.api.LaunchStage.LAUNCH_STAGE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, launchStage_);
    }
    if (restNumericEnums_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, restNumericEnums_);
    }
    if (javaSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(21, getJavaSettings());
    }
    if (cppSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getCppSettings());
    }
    if (phpSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getPhpSettings());
    }
    if (pythonSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getPythonSettings());
    }
    if (nodeSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(25, getNodeSettings());
    }
    if (dotnetSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(26, getDotnetSettings());
    }
    if (rubySettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(27, getRubySettings());
    }
    if (goSettings_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(28, getGoSettings());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.ClientLibrarySettings)) {
      return super.equals(obj);
    }
    com.google.api.ClientLibrarySettings other = (com.google.api.ClientLibrarySettings) obj;

    if (!getVersion().equals(other.getVersion())) return false;
    if (launchStage_ != other.launchStage_) return false;
    if (getRestNumericEnums() != other.getRestNumericEnums()) return false;
    if (hasJavaSettings() != other.hasJavaSettings()) return false;
    if (hasJavaSettings()) {
      if (!getJavaSettings().equals(other.getJavaSettings())) return false;
    }
    if (hasCppSettings() != other.hasCppSettings()) return false;
    if (hasCppSettings()) {
      if (!getCppSettings().equals(other.getCppSettings())) return false;
    }
    if (hasPhpSettings() != other.hasPhpSettings()) return false;
    if (hasPhpSettings()) {
      if (!getPhpSettings().equals(other.getPhpSettings())) return false;
    }
    if (hasPythonSettings() != other.hasPythonSettings()) return false;
    if (hasPythonSettings()) {
      if (!getPythonSettings().equals(other.getPythonSettings())) return false;
    }
    if (hasNodeSettings() != other.hasNodeSettings()) return false;
    if (hasNodeSettings()) {
      if (!getNodeSettings().equals(other.getNodeSettings())) return false;
    }
    if (hasDotnetSettings() != other.hasDotnetSettings()) return false;
    if (hasDotnetSettings()) {
      if (!getDotnetSettings().equals(other.getDotnetSettings())) return false;
    }
    if (hasRubySettings() != other.hasRubySettings()) return false;
    if (hasRubySettings()) {
      if (!getRubySettings().equals(other.getRubySettings())) return false;
    }
    if (hasGoSettings() != other.hasGoSettings()) return false;
    if (hasGoSettings()) {
      if (!getGoSettings().equals(other.getGoSettings())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    hash = (37 * hash) + LAUNCH_STAGE_FIELD_NUMBER;
    hash = (53 * hash) + launchStage_;
    hash = (37 * hash) + REST_NUMERIC_ENUMS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRestNumericEnums());
    if (hasJavaSettings()) {
      hash = (37 * hash) + JAVA_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getJavaSettings().hashCode();
    }
    if (hasCppSettings()) {
      hash = (37 * hash) + CPP_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getCppSettings().hashCode();
    }
    if (hasPhpSettings()) {
      hash = (37 * hash) + PHP_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getPhpSettings().hashCode();
    }
    if (hasPythonSettings()) {
      hash = (37 * hash) + PYTHON_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getPythonSettings().hashCode();
    }
    if (hasNodeSettings()) {
      hash = (37 * hash) + NODE_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getNodeSettings().hashCode();
    }
    if (hasDotnetSettings()) {
      hash = (37 * hash) + DOTNET_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getDotnetSettings().hashCode();
    }
    if (hasRubySettings()) {
      hash = (37 * hash) + RUBY_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getRubySettings().hashCode();
    }
    if (hasGoSettings()) {
      hash = (37 * hash) + GO_SETTINGS_FIELD_NUMBER;
      hash = (53 * hash) + getGoSettings().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.ClientLibrarySettings parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.ClientLibrarySettings parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.ClientLibrarySettings parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.ClientLibrarySettings parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.ClientLibrarySettings parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.ClientLibrarySettings parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.ClientLibrarySettings parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.ClientLibrarySettings parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.ClientLibrarySettings parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.ClientLibrarySettings parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.ClientLibrarySettings parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.ClientLibrarySettings parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.ClientLibrarySettings prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details about how and where to publish client libraries.
   * </pre>
   *
   * Protobuf type {@code google.api.ClientLibrarySettings}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.ClientLibrarySettings)
      com.google.api.ClientLibrarySettingsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.ClientProto.internal_static_google_api_ClientLibrarySettings_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.ClientProto
          .internal_static_google_api_ClientLibrarySettings_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.ClientLibrarySettings.class,
              com.google.api.ClientLibrarySettings.Builder.class);
    }

    // Construct using com.google.api.ClientLibrarySettings.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      version_ = "";

      launchStage_ = 0;

      restNumericEnums_ = false;

      if (javaSettingsBuilder_ == null) {
        javaSettings_ = null;
      } else {
        javaSettings_ = null;
        javaSettingsBuilder_ = null;
      }
      if (cppSettingsBuilder_ == null) {
        cppSettings_ = null;
      } else {
        cppSettings_ = null;
        cppSettingsBuilder_ = null;
      }
      if (phpSettingsBuilder_ == null) {
        phpSettings_ = null;
      } else {
        phpSettings_ = null;
        phpSettingsBuilder_ = null;
      }
      if (pythonSettingsBuilder_ == null) {
        pythonSettings_ = null;
      } else {
        pythonSettings_ = null;
        pythonSettingsBuilder_ = null;
      }
      if (nodeSettingsBuilder_ == null) {
        nodeSettings_ = null;
      } else {
        nodeSettings_ = null;
        nodeSettingsBuilder_ = null;
      }
      if (dotnetSettingsBuilder_ == null) {
        dotnetSettings_ = null;
      } else {
        dotnetSettings_ = null;
        dotnetSettingsBuilder_ = null;
      }
      if (rubySettingsBuilder_ == null) {
        rubySettings_ = null;
      } else {
        rubySettings_ = null;
        rubySettingsBuilder_ = null;
      }
      if (goSettingsBuilder_ == null) {
        goSettings_ = null;
      } else {
        goSettings_ = null;
        goSettingsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.ClientProto.internal_static_google_api_ClientLibrarySettings_descriptor;
    }

    @java.lang.Override
    public com.google.api.ClientLibrarySettings getDefaultInstanceForType() {
      return com.google.api.ClientLibrarySettings.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.ClientLibrarySettings build() {
      com.google.api.ClientLibrarySettings result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.ClientLibrarySettings buildPartial() {
      com.google.api.ClientLibrarySettings result = new com.google.api.ClientLibrarySettings(this);
      result.version_ = version_;
      result.launchStage_ = launchStage_;
      result.restNumericEnums_ = restNumericEnums_;
      if (javaSettingsBuilder_ == null) {
        result.javaSettings_ = javaSettings_;
      } else {
        result.javaSettings_ = javaSettingsBuilder_.build();
      }
      if (cppSettingsBuilder_ == null) {
        result.cppSettings_ = cppSettings_;
      } else {
        result.cppSettings_ = cppSettingsBuilder_.build();
      }
      if (phpSettingsBuilder_ == null) {
        result.phpSettings_ = phpSettings_;
      } else {
        result.phpSettings_ = phpSettingsBuilder_.build();
      }
      if (pythonSettingsBuilder_ == null) {
        result.pythonSettings_ = pythonSettings_;
      } else {
        result.pythonSettings_ = pythonSettingsBuilder_.build();
      }
      if (nodeSettingsBuilder_ == null) {
        result.nodeSettings_ = nodeSettings_;
      } else {
        result.nodeSettings_ = nodeSettingsBuilder_.build();
      }
      if (dotnetSettingsBuilder_ == null) {
        result.dotnetSettings_ = dotnetSettings_;
      } else {
        result.dotnetSettings_ = dotnetSettingsBuilder_.build();
      }
      if (rubySettingsBuilder_ == null) {
        result.rubySettings_ = rubySettings_;
      } else {
        result.rubySettings_ = rubySettingsBuilder_.build();
      }
      if (goSettingsBuilder_ == null) {
        result.goSettings_ = goSettings_;
      } else {
        result.goSettings_ = goSettingsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.ClientLibrarySettings) {
        return mergeFrom((com.google.api.ClientLibrarySettings) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.ClientLibrarySettings other) {
      if (other == com.google.api.ClientLibrarySettings.getDefaultInstance()) return this;
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        onChanged();
      }
      if (other.launchStage_ != 0) {
        setLaunchStageValue(other.getLaunchStageValue());
      }
      if (other.getRestNumericEnums() != false) {
        setRestNumericEnums(other.getRestNumericEnums());
      }
      if (other.hasJavaSettings()) {
        mergeJavaSettings(other.getJavaSettings());
      }
      if (other.hasCppSettings()) {
        mergeCppSettings(other.getCppSettings());
      }
      if (other.hasPhpSettings()) {
        mergePhpSettings(other.getPhpSettings());
      }
      if (other.hasPythonSettings()) {
        mergePythonSettings(other.getPythonSettings());
      }
      if (other.hasNodeSettings()) {
        mergeNodeSettings(other.getNodeSettings());
      }
      if (other.hasDotnetSettings()) {
        mergeDotnetSettings(other.getDotnetSettings());
      }
      if (other.hasRubySettings()) {
        mergeRubySettings(other.getRubySettings());
      }
      if (other.hasGoSettings()) {
        mergeGoSettings(other.getGoSettings());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                version_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                launchStage_ = input.readEnum();

                break;
              } // case 16
            case 24:
              {
                restNumericEnums_ = input.readBool();

                break;
              } // case 24
            case 170:
              {
                input.readMessage(getJavaSettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 170
            case 178:
              {
                input.readMessage(getCppSettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 178
            case 186:
              {
                input.readMessage(getPhpSettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 186
            case 194:
              {
                input.readMessage(getPythonSettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 194
            case 202:
              {
                input.readMessage(getNodeSettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 202
            case 210:
              {
                input.readMessage(getDotnetSettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 210
            case 218:
              {
                input.readMessage(getRubySettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 218
            case 226:
              {
                input.readMessage(getGoSettingsFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 226
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * Version of the API to apply these settings to.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Version of the API to apply these settings to.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Version of the API to apply these settings to.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      version_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Version of the API to apply these settings to.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {

      version_ = getDefaultInstance().getVersion();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Version of the API to apply these settings to.
     * </pre>
     *
     * <code>string version = 1;</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      version_ = value;
      onChanged();
      return this;
    }

    private int launchStage_ = 0;
    /**
     *
     *
     * <pre>
     * Launch stage of this version of the API.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 2;</code>
     *
     * @return The enum numeric value on the wire for launchStage.
     */
    @java.lang.Override
    public int getLaunchStageValue() {
      return launchStage_;
    }
    /**
     *
     *
     * <pre>
     * Launch stage of this version of the API.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 2;</code>
     *
     * @param value The enum numeric value on the wire for launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStageValue(int value) {

      launchStage_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Launch stage of this version of the API.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 2;</code>
     *
     * @return The launchStage.
     */
    @java.lang.Override
    public com.google.api.LaunchStage getLaunchStage() {
      @SuppressWarnings("deprecation")
      com.google.api.LaunchStage result = com.google.api.LaunchStage.valueOf(launchStage_);
      return result == null ? com.google.api.LaunchStage.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Launch stage of this version of the API.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 2;</code>
     *
     * @param value The launchStage to set.
     * @return This builder for chaining.
     */
    public Builder setLaunchStage(com.google.api.LaunchStage value) {
      if (value == null) {
        throw new NullPointerException();
      }

      launchStage_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Launch stage of this version of the API.
     * </pre>
     *
     * <code>.google.api.LaunchStage launch_stage = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLaunchStage() {

      launchStage_ = 0;
      onChanged();
      return this;
    }

    private boolean restNumericEnums_;
    /**
     *
     *
     * <pre>
     * When using transport=rest, the client request will encode enums as
     * numbers rather than strings.
     * </pre>
     *
     * <code>bool rest_numeric_enums = 3;</code>
     *
     * @return The restNumericEnums.
     */
    @java.lang.Override
    public boolean getRestNumericEnums() {
      return restNumericEnums_;
    }
    /**
     *
     *
     * <pre>
     * When using transport=rest, the client request will encode enums as
     * numbers rather than strings.
     * </pre>
     *
     * <code>bool rest_numeric_enums = 3;</code>
     *
     * @param value The restNumericEnums to set.
     * @return This builder for chaining.
     */
    public Builder setRestNumericEnums(boolean value) {

      restNumericEnums_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * When using transport=rest, the client request will encode enums as
     * numbers rather than strings.
     * </pre>
     *
     * <code>bool rest_numeric_enums = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRestNumericEnums() {

      restNumericEnums_ = false;
      onChanged();
      return this;
    }

    private com.google.api.JavaSettings javaSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.JavaSettings,
            com.google.api.JavaSettings.Builder,
            com.google.api.JavaSettingsOrBuilder>
        javaSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for legacy Java features, supported in the Service YAML.
     * </pre>
     *
     * <code>.google.api.JavaSettings java_settings = 21;</code>
     *
     * @return Whether the javaSettings field is set.
     */
    public boolean hasJavaSettings() {
      return javaSettingsBuilder_ != null || javaSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Settings for legacy Java features, supported in the Service YAML.
     * </pre>
     *
     * <code>.google.api.JavaSettings java_settings = 21;</code>
     *
     * @return The javaSettings.
     */
    public com.google.api.JavaSettings getJavaSettings() {
      if (javaSettingsBuilder_ == null) {
        return javaSettings_ == null
            ? com.google.api.JavaSettings.getDefaultInstance()
            : javaSettings_;
      } else {
        return javaSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for legacy Java features, supported in the Service YAML.
     * </pre>
     *
     * <code>.google.api.JavaSettings java_settings = 21;</code>
     */
    public Builder setJavaSettings(com.google.api.JavaSettings value) {
      if (javaSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        javaSettings_ = value;
        onChanged();
      } else {
        javaSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for legacy Java features, supported in the Service YAML.
     * </pre>
     *
     * <code>.google.api.JavaSettings java_settings = 21;</code>
     */
    public Builder setJavaSettings(com.google.api.JavaSettings.Builder builderForValue) {
      if (javaSettingsBuilder_ == null) {
        javaSettings_ = builderForValue.build();
        onChanged();
      } else {
        javaSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for legacy Java features, supported in the Service YAML.
     * </pre>
     *
     * <code>.google.api.JavaSettings java_settings = 21;</code>
     */
    public Builder mergeJavaSettings(com.google.api.JavaSettings value) {
      if (javaSettingsBuilder_ == null) {
        if (javaSettings_ != null) {
          javaSettings_ =
              com.google.api.JavaSettings.newBuilder(javaSettings_).mergeFrom(value).buildPartial();
        } else {
          javaSettings_ = value;
        }
        onChanged();
      } else {
        javaSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for legacy Java features, supported in the Service YAML.
     * </pre>
     *
     * <code>.google.api.JavaSettings java_settings = 21;</code>
     */
    public Builder clearJavaSettings() {
      if (javaSettingsBuilder_ == null) {
        javaSettings_ = null;
        onChanged();
      } else {
        javaSettings_ = null;
        javaSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for legacy Java features, supported in the Service YAML.
     * </pre>
     *
     * <code>.google.api.JavaSettings java_settings = 21;</code>
     */
    public com.google.api.JavaSettings.Builder getJavaSettingsBuilder() {

      onChanged();
      return getJavaSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for legacy Java features, supported in the Service YAML.
     * </pre>
     *
     * <code>.google.api.JavaSettings java_settings = 21;</code>
     */
    public com.google.api.JavaSettingsOrBuilder getJavaSettingsOrBuilder() {
      if (javaSettingsBuilder_ != null) {
        return javaSettingsBuilder_.getMessageOrBuilder();
      } else {
        return javaSettings_ == null
            ? com.google.api.JavaSettings.getDefaultInstance()
            : javaSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for legacy Java features, supported in the Service YAML.
     * </pre>
     *
     * <code>.google.api.JavaSettings java_settings = 21;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.JavaSettings,
            com.google.api.JavaSettings.Builder,
            com.google.api.JavaSettingsOrBuilder>
        getJavaSettingsFieldBuilder() {
      if (javaSettingsBuilder_ == null) {
        javaSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.JavaSettings,
                com.google.api.JavaSettings.Builder,
                com.google.api.JavaSettingsOrBuilder>(
                getJavaSettings(), getParentForChildren(), isClean());
        javaSettings_ = null;
      }
      return javaSettingsBuilder_;
    }

    private com.google.api.CppSettings cppSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.CppSettings,
            com.google.api.CppSettings.Builder,
            com.google.api.CppSettingsOrBuilder>
        cppSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for C++ client libraries.
     * </pre>
     *
     * <code>.google.api.CppSettings cpp_settings = 22;</code>
     *
     * @return Whether the cppSettings field is set.
     */
    public boolean hasCppSettings() {
      return cppSettingsBuilder_ != null || cppSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Settings for C++ client libraries.
     * </pre>
     *
     * <code>.google.api.CppSettings cpp_settings = 22;</code>
     *
     * @return The cppSettings.
     */
    public com.google.api.CppSettings getCppSettings() {
      if (cppSettingsBuilder_ == null) {
        return cppSettings_ == null
            ? com.google.api.CppSettings.getDefaultInstance()
            : cppSettings_;
      } else {
        return cppSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for C++ client libraries.
     * </pre>
     *
     * <code>.google.api.CppSettings cpp_settings = 22;</code>
     */
    public Builder setCppSettings(com.google.api.CppSettings value) {
      if (cppSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        cppSettings_ = value;
        onChanged();
      } else {
        cppSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for C++ client libraries.
     * </pre>
     *
     * <code>.google.api.CppSettings cpp_settings = 22;</code>
     */
    public Builder setCppSettings(com.google.api.CppSettings.Builder builderForValue) {
      if (cppSettingsBuilder_ == null) {
        cppSettings_ = builderForValue.build();
        onChanged();
      } else {
        cppSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for C++ client libraries.
     * </pre>
     *
     * <code>.google.api.CppSettings cpp_settings = 22;</code>
     */
    public Builder mergeCppSettings(com.google.api.CppSettings value) {
      if (cppSettingsBuilder_ == null) {
        if (cppSettings_ != null) {
          cppSettings_ =
              com.google.api.CppSettings.newBuilder(cppSettings_).mergeFrom(value).buildPartial();
        } else {
          cppSettings_ = value;
        }
        onChanged();
      } else {
        cppSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for C++ client libraries.
     * </pre>
     *
     * <code>.google.api.CppSettings cpp_settings = 22;</code>
     */
    public Builder clearCppSettings() {
      if (cppSettingsBuilder_ == null) {
        cppSettings_ = null;
        onChanged();
      } else {
        cppSettings_ = null;
        cppSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for C++ client libraries.
     * </pre>
     *
     * <code>.google.api.CppSettings cpp_settings = 22;</code>
     */
    public com.google.api.CppSettings.Builder getCppSettingsBuilder() {

      onChanged();
      return getCppSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for C++ client libraries.
     * </pre>
     *
     * <code>.google.api.CppSettings cpp_settings = 22;</code>
     */
    public com.google.api.CppSettingsOrBuilder getCppSettingsOrBuilder() {
      if (cppSettingsBuilder_ != null) {
        return cppSettingsBuilder_.getMessageOrBuilder();
      } else {
        return cppSettings_ == null
            ? com.google.api.CppSettings.getDefaultInstance()
            : cppSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for C++ client libraries.
     * </pre>
     *
     * <code>.google.api.CppSettings cpp_settings = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.CppSettings,
            com.google.api.CppSettings.Builder,
            com.google.api.CppSettingsOrBuilder>
        getCppSettingsFieldBuilder() {
      if (cppSettingsBuilder_ == null) {
        cppSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.CppSettings,
                com.google.api.CppSettings.Builder,
                com.google.api.CppSettingsOrBuilder>(
                getCppSettings(), getParentForChildren(), isClean());
        cppSettings_ = null;
      }
      return cppSettingsBuilder_;
    }

    private com.google.api.PhpSettings phpSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.PhpSettings,
            com.google.api.PhpSettings.Builder,
            com.google.api.PhpSettingsOrBuilder>
        phpSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for PHP client libraries.
     * </pre>
     *
     * <code>.google.api.PhpSettings php_settings = 23;</code>
     *
     * @return Whether the phpSettings field is set.
     */
    public boolean hasPhpSettings() {
      return phpSettingsBuilder_ != null || phpSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Settings for PHP client libraries.
     * </pre>
     *
     * <code>.google.api.PhpSettings php_settings = 23;</code>
     *
     * @return The phpSettings.
     */
    public com.google.api.PhpSettings getPhpSettings() {
      if (phpSettingsBuilder_ == null) {
        return phpSettings_ == null
            ? com.google.api.PhpSettings.getDefaultInstance()
            : phpSettings_;
      } else {
        return phpSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for PHP client libraries.
     * </pre>
     *
     * <code>.google.api.PhpSettings php_settings = 23;</code>
     */
    public Builder setPhpSettings(com.google.api.PhpSettings value) {
      if (phpSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        phpSettings_ = value;
        onChanged();
      } else {
        phpSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for PHP client libraries.
     * </pre>
     *
     * <code>.google.api.PhpSettings php_settings = 23;</code>
     */
    public Builder setPhpSettings(com.google.api.PhpSettings.Builder builderForValue) {
      if (phpSettingsBuilder_ == null) {
        phpSettings_ = builderForValue.build();
        onChanged();
      } else {
        phpSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for PHP client libraries.
     * </pre>
     *
     * <code>.google.api.PhpSettings php_settings = 23;</code>
     */
    public Builder mergePhpSettings(com.google.api.PhpSettings value) {
      if (phpSettingsBuilder_ == null) {
        if (phpSettings_ != null) {
          phpSettings_ =
              com.google.api.PhpSettings.newBuilder(phpSettings_).mergeFrom(value).buildPartial();
        } else {
          phpSettings_ = value;
        }
        onChanged();
      } else {
        phpSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for PHP client libraries.
     * </pre>
     *
     * <code>.google.api.PhpSettings php_settings = 23;</code>
     */
    public Builder clearPhpSettings() {
      if (phpSettingsBuilder_ == null) {
        phpSettings_ = null;
        onChanged();
      } else {
        phpSettings_ = null;
        phpSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for PHP client libraries.
     * </pre>
     *
     * <code>.google.api.PhpSettings php_settings = 23;</code>
     */
    public com.google.api.PhpSettings.Builder getPhpSettingsBuilder() {

      onChanged();
      return getPhpSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for PHP client libraries.
     * </pre>
     *
     * <code>.google.api.PhpSettings php_settings = 23;</code>
     */
    public com.google.api.PhpSettingsOrBuilder getPhpSettingsOrBuilder() {
      if (phpSettingsBuilder_ != null) {
        return phpSettingsBuilder_.getMessageOrBuilder();
      } else {
        return phpSettings_ == null
            ? com.google.api.PhpSettings.getDefaultInstance()
            : phpSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for PHP client libraries.
     * </pre>
     *
     * <code>.google.api.PhpSettings php_settings = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.PhpSettings,
            com.google.api.PhpSettings.Builder,
            com.google.api.PhpSettingsOrBuilder>
        getPhpSettingsFieldBuilder() {
      if (phpSettingsBuilder_ == null) {
        phpSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.PhpSettings,
                com.google.api.PhpSettings.Builder,
                com.google.api.PhpSettingsOrBuilder>(
                getPhpSettings(), getParentForChildren(), isClean());
        phpSettings_ = null;
      }
      return phpSettingsBuilder_;
    }

    private com.google.api.PythonSettings pythonSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.PythonSettings,
            com.google.api.PythonSettings.Builder,
            com.google.api.PythonSettingsOrBuilder>
        pythonSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for Python client libraries.
     * </pre>
     *
     * <code>.google.api.PythonSettings python_settings = 24;</code>
     *
     * @return Whether the pythonSettings field is set.
     */
    public boolean hasPythonSettings() {
      return pythonSettingsBuilder_ != null || pythonSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Settings for Python client libraries.
     * </pre>
     *
     * <code>.google.api.PythonSettings python_settings = 24;</code>
     *
     * @return The pythonSettings.
     */
    public com.google.api.PythonSettings getPythonSettings() {
      if (pythonSettingsBuilder_ == null) {
        return pythonSettings_ == null
            ? com.google.api.PythonSettings.getDefaultInstance()
            : pythonSettings_;
      } else {
        return pythonSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for Python client libraries.
     * </pre>
     *
     * <code>.google.api.PythonSettings python_settings = 24;</code>
     */
    public Builder setPythonSettings(com.google.api.PythonSettings value) {
      if (pythonSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pythonSettings_ = value;
        onChanged();
      } else {
        pythonSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Python client libraries.
     * </pre>
     *
     * <code>.google.api.PythonSettings python_settings = 24;</code>
     */
    public Builder setPythonSettings(com.google.api.PythonSettings.Builder builderForValue) {
      if (pythonSettingsBuilder_ == null) {
        pythonSettings_ = builderForValue.build();
        onChanged();
      } else {
        pythonSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Python client libraries.
     * </pre>
     *
     * <code>.google.api.PythonSettings python_settings = 24;</code>
     */
    public Builder mergePythonSettings(com.google.api.PythonSettings value) {
      if (pythonSettingsBuilder_ == null) {
        if (pythonSettings_ != null) {
          pythonSettings_ =
              com.google.api.PythonSettings.newBuilder(pythonSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          pythonSettings_ = value;
        }
        onChanged();
      } else {
        pythonSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Python client libraries.
     * </pre>
     *
     * <code>.google.api.PythonSettings python_settings = 24;</code>
     */
    public Builder clearPythonSettings() {
      if (pythonSettingsBuilder_ == null) {
        pythonSettings_ = null;
        onChanged();
      } else {
        pythonSettings_ = null;
        pythonSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Python client libraries.
     * </pre>
     *
     * <code>.google.api.PythonSettings python_settings = 24;</code>
     */
    public com.google.api.PythonSettings.Builder getPythonSettingsBuilder() {

      onChanged();
      return getPythonSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for Python client libraries.
     * </pre>
     *
     * <code>.google.api.PythonSettings python_settings = 24;</code>
     */
    public com.google.api.PythonSettingsOrBuilder getPythonSettingsOrBuilder() {
      if (pythonSettingsBuilder_ != null) {
        return pythonSettingsBuilder_.getMessageOrBuilder();
      } else {
        return pythonSettings_ == null
            ? com.google.api.PythonSettings.getDefaultInstance()
            : pythonSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for Python client libraries.
     * </pre>
     *
     * <code>.google.api.PythonSettings python_settings = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.PythonSettings,
            com.google.api.PythonSettings.Builder,
            com.google.api.PythonSettingsOrBuilder>
        getPythonSettingsFieldBuilder() {
      if (pythonSettingsBuilder_ == null) {
        pythonSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.PythonSettings,
                com.google.api.PythonSettings.Builder,
                com.google.api.PythonSettingsOrBuilder>(
                getPythonSettings(), getParentForChildren(), isClean());
        pythonSettings_ = null;
      }
      return pythonSettingsBuilder_;
    }

    private com.google.api.NodeSettings nodeSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.NodeSettings,
            com.google.api.NodeSettings.Builder,
            com.google.api.NodeSettingsOrBuilder>
        nodeSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for Node client libraries.
     * </pre>
     *
     * <code>.google.api.NodeSettings node_settings = 25;</code>
     *
     * @return Whether the nodeSettings field is set.
     */
    public boolean hasNodeSettings() {
      return nodeSettingsBuilder_ != null || nodeSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Settings for Node client libraries.
     * </pre>
     *
     * <code>.google.api.NodeSettings node_settings = 25;</code>
     *
     * @return The nodeSettings.
     */
    public com.google.api.NodeSettings getNodeSettings() {
      if (nodeSettingsBuilder_ == null) {
        return nodeSettings_ == null
            ? com.google.api.NodeSettings.getDefaultInstance()
            : nodeSettings_;
      } else {
        return nodeSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for Node client libraries.
     * </pre>
     *
     * <code>.google.api.NodeSettings node_settings = 25;</code>
     */
    public Builder setNodeSettings(com.google.api.NodeSettings value) {
      if (nodeSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        nodeSettings_ = value;
        onChanged();
      } else {
        nodeSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Node client libraries.
     * </pre>
     *
     * <code>.google.api.NodeSettings node_settings = 25;</code>
     */
    public Builder setNodeSettings(com.google.api.NodeSettings.Builder builderForValue) {
      if (nodeSettingsBuilder_ == null) {
        nodeSettings_ = builderForValue.build();
        onChanged();
      } else {
        nodeSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Node client libraries.
     * </pre>
     *
     * <code>.google.api.NodeSettings node_settings = 25;</code>
     */
    public Builder mergeNodeSettings(com.google.api.NodeSettings value) {
      if (nodeSettingsBuilder_ == null) {
        if (nodeSettings_ != null) {
          nodeSettings_ =
              com.google.api.NodeSettings.newBuilder(nodeSettings_).mergeFrom(value).buildPartial();
        } else {
          nodeSettings_ = value;
        }
        onChanged();
      } else {
        nodeSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Node client libraries.
     * </pre>
     *
     * <code>.google.api.NodeSettings node_settings = 25;</code>
     */
    public Builder clearNodeSettings() {
      if (nodeSettingsBuilder_ == null) {
        nodeSettings_ = null;
        onChanged();
      } else {
        nodeSettings_ = null;
        nodeSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Node client libraries.
     * </pre>
     *
     * <code>.google.api.NodeSettings node_settings = 25;</code>
     */
    public com.google.api.NodeSettings.Builder getNodeSettingsBuilder() {

      onChanged();
      return getNodeSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for Node client libraries.
     * </pre>
     *
     * <code>.google.api.NodeSettings node_settings = 25;</code>
     */
    public com.google.api.NodeSettingsOrBuilder getNodeSettingsOrBuilder() {
      if (nodeSettingsBuilder_ != null) {
        return nodeSettingsBuilder_.getMessageOrBuilder();
      } else {
        return nodeSettings_ == null
            ? com.google.api.NodeSettings.getDefaultInstance()
            : nodeSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for Node client libraries.
     * </pre>
     *
     * <code>.google.api.NodeSettings node_settings = 25;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.NodeSettings,
            com.google.api.NodeSettings.Builder,
            com.google.api.NodeSettingsOrBuilder>
        getNodeSettingsFieldBuilder() {
      if (nodeSettingsBuilder_ == null) {
        nodeSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.NodeSettings,
                com.google.api.NodeSettings.Builder,
                com.google.api.NodeSettingsOrBuilder>(
                getNodeSettings(), getParentForChildren(), isClean());
        nodeSettings_ = null;
      }
      return nodeSettingsBuilder_;
    }

    private com.google.api.DotnetSettings dotnetSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.DotnetSettings,
            com.google.api.DotnetSettings.Builder,
            com.google.api.DotnetSettingsOrBuilder>
        dotnetSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for .NET client libraries.
     * </pre>
     *
     * <code>.google.api.DotnetSettings dotnet_settings = 26;</code>
     *
     * @return Whether the dotnetSettings field is set.
     */
    public boolean hasDotnetSettings() {
      return dotnetSettingsBuilder_ != null || dotnetSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Settings for .NET client libraries.
     * </pre>
     *
     * <code>.google.api.DotnetSettings dotnet_settings = 26;</code>
     *
     * @return The dotnetSettings.
     */
    public com.google.api.DotnetSettings getDotnetSettings() {
      if (dotnetSettingsBuilder_ == null) {
        return dotnetSettings_ == null
            ? com.google.api.DotnetSettings.getDefaultInstance()
            : dotnetSettings_;
      } else {
        return dotnetSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for .NET client libraries.
     * </pre>
     *
     * <code>.google.api.DotnetSettings dotnet_settings = 26;</code>
     */
    public Builder setDotnetSettings(com.google.api.DotnetSettings value) {
      if (dotnetSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dotnetSettings_ = value;
        onChanged();
      } else {
        dotnetSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for .NET client libraries.
     * </pre>
     *
     * <code>.google.api.DotnetSettings dotnet_settings = 26;</code>
     */
    public Builder setDotnetSettings(com.google.api.DotnetSettings.Builder builderForValue) {
      if (dotnetSettingsBuilder_ == null) {
        dotnetSettings_ = builderForValue.build();
        onChanged();
      } else {
        dotnetSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for .NET client libraries.
     * </pre>
     *
     * <code>.google.api.DotnetSettings dotnet_settings = 26;</code>
     */
    public Builder mergeDotnetSettings(com.google.api.DotnetSettings value) {
      if (dotnetSettingsBuilder_ == null) {
        if (dotnetSettings_ != null) {
          dotnetSettings_ =
              com.google.api.DotnetSettings.newBuilder(dotnetSettings_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dotnetSettings_ = value;
        }
        onChanged();
      } else {
        dotnetSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for .NET client libraries.
     * </pre>
     *
     * <code>.google.api.DotnetSettings dotnet_settings = 26;</code>
     */
    public Builder clearDotnetSettings() {
      if (dotnetSettingsBuilder_ == null) {
        dotnetSettings_ = null;
        onChanged();
      } else {
        dotnetSettings_ = null;
        dotnetSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for .NET client libraries.
     * </pre>
     *
     * <code>.google.api.DotnetSettings dotnet_settings = 26;</code>
     */
    public com.google.api.DotnetSettings.Builder getDotnetSettingsBuilder() {

      onChanged();
      return getDotnetSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for .NET client libraries.
     * </pre>
     *
     * <code>.google.api.DotnetSettings dotnet_settings = 26;</code>
     */
    public com.google.api.DotnetSettingsOrBuilder getDotnetSettingsOrBuilder() {
      if (dotnetSettingsBuilder_ != null) {
        return dotnetSettingsBuilder_.getMessageOrBuilder();
      } else {
        return dotnetSettings_ == null
            ? com.google.api.DotnetSettings.getDefaultInstance()
            : dotnetSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for .NET client libraries.
     * </pre>
     *
     * <code>.google.api.DotnetSettings dotnet_settings = 26;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.DotnetSettings,
            com.google.api.DotnetSettings.Builder,
            com.google.api.DotnetSettingsOrBuilder>
        getDotnetSettingsFieldBuilder() {
      if (dotnetSettingsBuilder_ == null) {
        dotnetSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.DotnetSettings,
                com.google.api.DotnetSettings.Builder,
                com.google.api.DotnetSettingsOrBuilder>(
                getDotnetSettings(), getParentForChildren(), isClean());
        dotnetSettings_ = null;
      }
      return dotnetSettingsBuilder_;
    }

    private com.google.api.RubySettings rubySettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.RubySettings,
            com.google.api.RubySettings.Builder,
            com.google.api.RubySettingsOrBuilder>
        rubySettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for Ruby client libraries.
     * </pre>
     *
     * <code>.google.api.RubySettings ruby_settings = 27;</code>
     *
     * @return Whether the rubySettings field is set.
     */
    public boolean hasRubySettings() {
      return rubySettingsBuilder_ != null || rubySettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Settings for Ruby client libraries.
     * </pre>
     *
     * <code>.google.api.RubySettings ruby_settings = 27;</code>
     *
     * @return The rubySettings.
     */
    public com.google.api.RubySettings getRubySettings() {
      if (rubySettingsBuilder_ == null) {
        return rubySettings_ == null
            ? com.google.api.RubySettings.getDefaultInstance()
            : rubySettings_;
      } else {
        return rubySettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for Ruby client libraries.
     * </pre>
     *
     * <code>.google.api.RubySettings ruby_settings = 27;</code>
     */
    public Builder setRubySettings(com.google.api.RubySettings value) {
      if (rubySettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rubySettings_ = value;
        onChanged();
      } else {
        rubySettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Ruby client libraries.
     * </pre>
     *
     * <code>.google.api.RubySettings ruby_settings = 27;</code>
     */
    public Builder setRubySettings(com.google.api.RubySettings.Builder builderForValue) {
      if (rubySettingsBuilder_ == null) {
        rubySettings_ = builderForValue.build();
        onChanged();
      } else {
        rubySettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Ruby client libraries.
     * </pre>
     *
     * <code>.google.api.RubySettings ruby_settings = 27;</code>
     */
    public Builder mergeRubySettings(com.google.api.RubySettings value) {
      if (rubySettingsBuilder_ == null) {
        if (rubySettings_ != null) {
          rubySettings_ =
              com.google.api.RubySettings.newBuilder(rubySettings_).mergeFrom(value).buildPartial();
        } else {
          rubySettings_ = value;
        }
        onChanged();
      } else {
        rubySettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Ruby client libraries.
     * </pre>
     *
     * <code>.google.api.RubySettings ruby_settings = 27;</code>
     */
    public Builder clearRubySettings() {
      if (rubySettingsBuilder_ == null) {
        rubySettings_ = null;
        onChanged();
      } else {
        rubySettings_ = null;
        rubySettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Ruby client libraries.
     * </pre>
     *
     * <code>.google.api.RubySettings ruby_settings = 27;</code>
     */
    public com.google.api.RubySettings.Builder getRubySettingsBuilder() {

      onChanged();
      return getRubySettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for Ruby client libraries.
     * </pre>
     *
     * <code>.google.api.RubySettings ruby_settings = 27;</code>
     */
    public com.google.api.RubySettingsOrBuilder getRubySettingsOrBuilder() {
      if (rubySettingsBuilder_ != null) {
        return rubySettingsBuilder_.getMessageOrBuilder();
      } else {
        return rubySettings_ == null
            ? com.google.api.RubySettings.getDefaultInstance()
            : rubySettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for Ruby client libraries.
     * </pre>
     *
     * <code>.google.api.RubySettings ruby_settings = 27;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.RubySettings,
            com.google.api.RubySettings.Builder,
            com.google.api.RubySettingsOrBuilder>
        getRubySettingsFieldBuilder() {
      if (rubySettingsBuilder_ == null) {
        rubySettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.RubySettings,
                com.google.api.RubySettings.Builder,
                com.google.api.RubySettingsOrBuilder>(
                getRubySettings(), getParentForChildren(), isClean());
        rubySettings_ = null;
      }
      return rubySettingsBuilder_;
    }

    private com.google.api.GoSettings goSettings_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.GoSettings,
            com.google.api.GoSettings.Builder,
            com.google.api.GoSettingsOrBuilder>
        goSettingsBuilder_;
    /**
     *
     *
     * <pre>
     * Settings for Go client libraries.
     * </pre>
     *
     * <code>.google.api.GoSettings go_settings = 28;</code>
     *
     * @return Whether the goSettings field is set.
     */
    public boolean hasGoSettings() {
      return goSettingsBuilder_ != null || goSettings_ != null;
    }
    /**
     *
     *
     * <pre>
     * Settings for Go client libraries.
     * </pre>
     *
     * <code>.google.api.GoSettings go_settings = 28;</code>
     *
     * @return The goSettings.
     */
    public com.google.api.GoSettings getGoSettings() {
      if (goSettingsBuilder_ == null) {
        return goSettings_ == null ? com.google.api.GoSettings.getDefaultInstance() : goSettings_;
      } else {
        return goSettingsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for Go client libraries.
     * </pre>
     *
     * <code>.google.api.GoSettings go_settings = 28;</code>
     */
    public Builder setGoSettings(com.google.api.GoSettings value) {
      if (goSettingsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        goSettings_ = value;
        onChanged();
      } else {
        goSettingsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Go client libraries.
     * </pre>
     *
     * <code>.google.api.GoSettings go_settings = 28;</code>
     */
    public Builder setGoSettings(com.google.api.GoSettings.Builder builderForValue) {
      if (goSettingsBuilder_ == null) {
        goSettings_ = builderForValue.build();
        onChanged();
      } else {
        goSettingsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Go client libraries.
     * </pre>
     *
     * <code>.google.api.GoSettings go_settings = 28;</code>
     */
    public Builder mergeGoSettings(com.google.api.GoSettings value) {
      if (goSettingsBuilder_ == null) {
        if (goSettings_ != null) {
          goSettings_ =
              com.google.api.GoSettings.newBuilder(goSettings_).mergeFrom(value).buildPartial();
        } else {
          goSettings_ = value;
        }
        onChanged();
      } else {
        goSettingsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Go client libraries.
     * </pre>
     *
     * <code>.google.api.GoSettings go_settings = 28;</code>
     */
    public Builder clearGoSettings() {
      if (goSettingsBuilder_ == null) {
        goSettings_ = null;
        onChanged();
      } else {
        goSettings_ = null;
        goSettingsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings for Go client libraries.
     * </pre>
     *
     * <code>.google.api.GoSettings go_settings = 28;</code>
     */
    public com.google.api.GoSettings.Builder getGoSettingsBuilder() {

      onChanged();
      return getGoSettingsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings for Go client libraries.
     * </pre>
     *
     * <code>.google.api.GoSettings go_settings = 28;</code>
     */
    public com.google.api.GoSettingsOrBuilder getGoSettingsOrBuilder() {
      if (goSettingsBuilder_ != null) {
        return goSettingsBuilder_.getMessageOrBuilder();
      } else {
        return goSettings_ == null ? com.google.api.GoSettings.getDefaultInstance() : goSettings_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings for Go client libraries.
     * </pre>
     *
     * <code>.google.api.GoSettings go_settings = 28;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.GoSettings,
            com.google.api.GoSettings.Builder,
            com.google.api.GoSettingsOrBuilder>
        getGoSettingsFieldBuilder() {
      if (goSettingsBuilder_ == null) {
        goSettingsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.GoSettings,
                com.google.api.GoSettings.Builder,
                com.google.api.GoSettingsOrBuilder>(
                getGoSettings(), getParentForChildren(), isClean());
        goSettings_ = null;
      }
      return goSettingsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.ClientLibrarySettings)
  }

  // @@protoc_insertion_point(class_scope:google.api.ClientLibrarySettings)
  private static final com.google.api.ClientLibrarySettings DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.ClientLibrarySettings();
  }

  public static com.google.api.ClientLibrarySettings getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ClientLibrarySettings> PARSER =
      new com.google.protobuf.AbstractParser<ClientLibrarySettings>() {
        @java.lang.Override
        public ClientLibrarySettings parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ClientLibrarySettings> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ClientLibrarySettings> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.ClientLibrarySettings getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
