/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vertexai.api;

import com.google.cloud.vertexai.api.Content;
import com.google.cloud.vertexai.api.ContentOrBuilder;
import com.google.cloud.vertexai.api.GenerateContentRequestOrBuilder;
import com.google.cloud.vertexai.api.GenerationConfig;
import com.google.cloud.vertexai.api.GenerationConfigOrBuilder;
import com.google.cloud.vertexai.api.PredictionServiceProto;
import com.google.cloud.vertexai.api.SafetySetting;
import com.google.cloud.vertexai.api.SafetySettingOrBuilder;
import com.google.cloud.vertexai.api.Tool;
import com.google.cloud.vertexai.api.ToolOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class GenerateContentRequest
extends GeneratedMessageV3
implements GenerateContentRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int MODEL_FIELD_NUMBER = 5;
    private volatile Object model_ = "";
    public static final int CONTENTS_FIELD_NUMBER = 2;
    private List<Content> contents_;
    public static final int TOOLS_FIELD_NUMBER = 6;
    private List<Tool> tools_;
    public static final int SAFETY_SETTINGS_FIELD_NUMBER = 3;
    private List<SafetySetting> safetySettings_;
    public static final int GENERATION_CONFIG_FIELD_NUMBER = 4;
    private GenerationConfig generationConfig_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final GenerateContentRequest DEFAULT_INSTANCE = new GenerateContentRequest();
    private static final Parser<GenerateContentRequest> PARSER = new AbstractParser<GenerateContentRequest>(){

        public GenerateContentRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = GenerateContentRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private GenerateContentRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private GenerateContentRequest() {
        this.model_ = "";
        this.contents_ = Collections.emptyList();
        this.tools_ = Collections.emptyList();
        this.safetySettings_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new GenerateContentRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return PredictionServiceProto.internal_static_google_cloud_vertexai_v1_GenerateContentRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return PredictionServiceProto.internal_static_google_cloud_vertexai_v1_GenerateContentRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateContentRequest.class, Builder.class);
    }

    @Override
    public String getModel() {
        Object ref = this.model_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.model_ = s;
        return s;
    }

    @Override
    public ByteString getModelBytes() {
        Object ref = this.model_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.model_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<Content> getContentsList() {
        return this.contents_;
    }

    @Override
    public List<? extends ContentOrBuilder> getContentsOrBuilderList() {
        return this.contents_;
    }

    @Override
    public int getContentsCount() {
        return this.contents_.size();
    }

    @Override
    public Content getContents(int index) {
        return this.contents_.get(index);
    }

    @Override
    public ContentOrBuilder getContentsOrBuilder(int index) {
        return this.contents_.get(index);
    }

    @Override
    public List<Tool> getToolsList() {
        return this.tools_;
    }

    @Override
    public List<? extends ToolOrBuilder> getToolsOrBuilderList() {
        return this.tools_;
    }

    @Override
    public int getToolsCount() {
        return this.tools_.size();
    }

    @Override
    public Tool getTools(int index) {
        return this.tools_.get(index);
    }

    @Override
    public ToolOrBuilder getToolsOrBuilder(int index) {
        return this.tools_.get(index);
    }

    @Override
    public List<SafetySetting> getSafetySettingsList() {
        return this.safetySettings_;
    }

    @Override
    public List<? extends SafetySettingOrBuilder> getSafetySettingsOrBuilderList() {
        return this.safetySettings_;
    }

    @Override
    public int getSafetySettingsCount() {
        return this.safetySettings_.size();
    }

    @Override
    public SafetySetting getSafetySettings(int index) {
        return this.safetySettings_.get(index);
    }

    @Override
    public SafetySettingOrBuilder getSafetySettingsOrBuilder(int index) {
        return this.safetySettings_.get(index);
    }

    @Override
    public boolean hasGenerationConfig() {
        return this.generationConfig_ != null;
    }

    @Override
    public GenerationConfig getGenerationConfig() {
        return this.generationConfig_ == null ? GenerationConfig.getDefaultInstance() : this.generationConfig_;
    }

    @Override
    public GenerationConfigOrBuilder getGenerationConfigOrBuilder() {
        return this.generationConfig_ == null ? GenerationConfig.getDefaultInstance() : this.generationConfig_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        for (i = 0; i < this.contents_.size(); ++i) {
            output.writeMessage(2, (MessageLite)this.contents_.get(i));
        }
        for (i = 0; i < this.safetySettings_.size(); ++i) {
            output.writeMessage(3, (MessageLite)this.safetySettings_.get(i));
        }
        if (this.generationConfig_ != null) {
            output.writeMessage(4, (MessageLite)this.getGenerationConfig());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.model_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.model_);
        }
        for (i = 0; i < this.tools_.size(); ++i) {
            output.writeMessage(6, (MessageLite)this.tools_.get(i));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (i = 0; i < this.contents_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)((MessageLite)this.contents_.get(i)));
        }
        for (i = 0; i < this.safetySettings_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)((MessageLite)this.safetySettings_.get(i)));
        }
        if (this.generationConfig_ != null) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getGenerationConfig());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.model_)) {
            size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.model_);
        }
        for (i = 0; i < this.tools_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((MessageLite)this.tools_.get(i)));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GenerateContentRequest)) {
            return super.equals(obj);
        }
        GenerateContentRequest other = (GenerateContentRequest)obj;
        if (!this.getModel().equals(other.getModel())) {
            return false;
        }
        if (!this.getContentsList().equals(other.getContentsList())) {
            return false;
        }
        if (!this.getToolsList().equals(other.getToolsList())) {
            return false;
        }
        if (!this.getSafetySettingsList().equals(other.getSafetySettingsList())) {
            return false;
        }
        if (this.hasGenerationConfig() != other.hasGenerationConfig()) {
            return false;
        }
        if (this.hasGenerationConfig() && !this.getGenerationConfig().equals(other.getGenerationConfig())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + GenerateContentRequest.getDescriptor().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.getModel().hashCode();
        if (this.getContentsCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getContentsList().hashCode();
        }
        if (this.getToolsCount() > 0) {
            hash = 37 * hash + 6;
            hash = 53 * hash + this.getToolsList().hashCode();
        }
        if (this.getSafetySettingsCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getSafetySettingsList().hashCode();
        }
        if (this.hasGenerationConfig()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getGenerationConfig().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static GenerateContentRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (GenerateContentRequest)PARSER.parseFrom(data);
    }

    public static GenerateContentRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateContentRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateContentRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (GenerateContentRequest)PARSER.parseFrom(data);
    }

    public static GenerateContentRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateContentRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateContentRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (GenerateContentRequest)PARSER.parseFrom(data);
    }

    public static GenerateContentRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (GenerateContentRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static GenerateContentRequest parseFrom(InputStream input) throws IOException {
        return (GenerateContentRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateContentRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateContentRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateContentRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (GenerateContentRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static GenerateContentRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateContentRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static GenerateContentRequest parseFrom(CodedInputStream input) throws IOException {
        return (GenerateContentRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static GenerateContentRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (GenerateContentRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return GenerateContentRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(GenerateContentRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static GenerateContentRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<GenerateContentRequest> parser() {
        return PARSER;
    }

    public Parser<GenerateContentRequest> getParserForType() {
        return PARSER;
    }

    public GenerateContentRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements GenerateContentRequestOrBuilder {
        private int bitField0_;
        private Object model_ = "";
        private List<Content> contents_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Content, Content.Builder, ContentOrBuilder> contentsBuilder_;
        private List<Tool> tools_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<Tool, Tool.Builder, ToolOrBuilder> toolsBuilder_;
        private List<SafetySetting> safetySettings_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<SafetySetting, SafetySetting.Builder, SafetySettingOrBuilder> safetySettingsBuilder_;
        private GenerationConfig generationConfig_;
        private SingleFieldBuilderV3<GenerationConfig, GenerationConfig.Builder, GenerationConfigOrBuilder> generationConfigBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return PredictionServiceProto.internal_static_google_cloud_vertexai_v1_GenerateContentRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return PredictionServiceProto.internal_static_google_cloud_vertexai_v1_GenerateContentRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(GenerateContentRequest.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.model_ = "";
            if (this.contentsBuilder_ == null) {
                this.contents_ = Collections.emptyList();
            } else {
                this.contents_ = null;
                this.contentsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFD;
            if (this.toolsBuilder_ == null) {
                this.tools_ = Collections.emptyList();
            } else {
                this.tools_ = null;
                this.toolsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            if (this.safetySettingsBuilder_ == null) {
                this.safetySettings_ = Collections.emptyList();
            } else {
                this.safetySettings_ = null;
                this.safetySettingsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFF7;
            this.generationConfig_ = null;
            if (this.generationConfigBuilder_ != null) {
                this.generationConfigBuilder_.dispose();
                this.generationConfigBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return PredictionServiceProto.internal_static_google_cloud_vertexai_v1_GenerateContentRequest_descriptor;
        }

        public GenerateContentRequest getDefaultInstanceForType() {
            return GenerateContentRequest.getDefaultInstance();
        }

        public GenerateContentRequest build() {
            GenerateContentRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public GenerateContentRequest buildPartial() {
            GenerateContentRequest result = new GenerateContentRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(GenerateContentRequest result) {
            if (this.contentsBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.contents_ = Collections.unmodifiableList(this.contents_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.contents_ = this.contents_;
            } else {
                result.contents_ = this.contentsBuilder_.build();
            }
            if (this.toolsBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.tools_ = Collections.unmodifiableList(this.tools_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.tools_ = this.tools_;
            } else {
                result.tools_ = this.toolsBuilder_.build();
            }
            if (this.safetySettingsBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0) {
                    this.safetySettings_ = Collections.unmodifiableList(this.safetySettings_);
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                result.safetySettings_ = this.safetySettings_;
            } else {
                result.safetySettings_ = this.safetySettingsBuilder_.build();
            }
        }

        private void buildPartial0(GenerateContentRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.model_ = this.model_;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.generationConfig_ = this.generationConfigBuilder_ == null ? this.generationConfig_ : (GenerationConfig)this.generationConfigBuilder_.build();
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof GenerateContentRequest) {
                return this.mergeFrom((GenerateContentRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(GenerateContentRequest other) {
            if (other == GenerateContentRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getModel().isEmpty()) {
                this.model_ = other.model_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (this.contentsBuilder_ == null) {
                if (!other.contents_.isEmpty()) {
                    if (this.contents_.isEmpty()) {
                        this.contents_ = other.contents_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureContentsIsMutable();
                        this.contents_.addAll(other.contents_);
                    }
                    this.onChanged();
                }
            } else if (!other.contents_.isEmpty()) {
                if (this.contentsBuilder_.isEmpty()) {
                    this.contentsBuilder_.dispose();
                    this.contentsBuilder_ = null;
                    this.contents_ = other.contents_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.contentsBuilder_ = alwaysUseFieldBuilders ? this.getContentsFieldBuilder() : null;
                } else {
                    this.contentsBuilder_.addAllMessages((Iterable)other.contents_);
                }
            }
            if (this.toolsBuilder_ == null) {
                if (!other.tools_.isEmpty()) {
                    if (this.tools_.isEmpty()) {
                        this.tools_ = other.tools_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureToolsIsMutable();
                        this.tools_.addAll(other.tools_);
                    }
                    this.onChanged();
                }
            } else if (!other.tools_.isEmpty()) {
                if (this.toolsBuilder_.isEmpty()) {
                    this.toolsBuilder_.dispose();
                    this.toolsBuilder_ = null;
                    this.tools_ = other.tools_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.toolsBuilder_ = alwaysUseFieldBuilders ? this.getToolsFieldBuilder() : null;
                } else {
                    this.toolsBuilder_.addAllMessages((Iterable)other.tools_);
                }
            }
            if (this.safetySettingsBuilder_ == null) {
                if (!other.safetySettings_.isEmpty()) {
                    if (this.safetySettings_.isEmpty()) {
                        this.safetySettings_ = other.safetySettings_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensureSafetySettingsIsMutable();
                        this.safetySettings_.addAll(other.safetySettings_);
                    }
                    this.onChanged();
                }
            } else if (!other.safetySettings_.isEmpty()) {
                if (this.safetySettingsBuilder_.isEmpty()) {
                    this.safetySettingsBuilder_.dispose();
                    this.safetySettingsBuilder_ = null;
                    this.safetySettings_ = other.safetySettings_;
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.safetySettingsBuilder_ = alwaysUseFieldBuilders ? this.getSafetySettingsFieldBuilder() : null;
                } else {
                    this.safetySettingsBuilder_.addAllMessages((Iterable)other.safetySettings_);
                }
            }
            if (other.hasGenerationConfig()) {
                this.mergeGenerationConfig(other.getGenerationConfig());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block13: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block13;
                        }
                        case 18: {
                            GeneratedMessageV3 m = (Content)input.readMessage(Content.parser(), extensionRegistry);
                            if (this.contentsBuilder_ == null) {
                                this.ensureContentsIsMutable();
                                this.contents_.add((Content)m);
                                continue block13;
                            }
                            this.contentsBuilder_.addMessage((AbstractMessage)m);
                            continue block13;
                        }
                        case 26: {
                            GeneratedMessageV3 m = (SafetySetting)input.readMessage(SafetySetting.parser(), extensionRegistry);
                            if (this.safetySettingsBuilder_ == null) {
                                this.ensureSafetySettingsIsMutable();
                                this.safetySettings_.add((SafetySetting)m);
                                continue block13;
                            }
                            this.safetySettingsBuilder_.addMessage((AbstractMessage)m);
                            continue block13;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getGenerationConfigFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block13;
                        }
                        case 42: {
                            this.model_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block13;
                        }
                        case 50: {
                            GeneratedMessageV3 m = (Tool)input.readMessage(Tool.parser(), extensionRegistry);
                            if (this.toolsBuilder_ == null) {
                                this.ensureToolsIsMutable();
                                this.tools_.add((Tool)m);
                                continue block13;
                            }
                            this.toolsBuilder_.addMessage((AbstractMessage)m);
                            continue block13;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getModel() {
            Object ref = this.model_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.model_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getModelBytes() {
            Object ref = this.model_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.model_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setModel(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.model_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearModel() {
            this.model_ = GenerateContentRequest.getDefaultInstance().getModel();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setModelBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            GenerateContentRequest.checkByteStringIsUtf8((ByteString)value);
            this.model_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        private void ensureContentsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.contents_ = new ArrayList<Content>(this.contents_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<Content> getContentsList() {
            if (this.contentsBuilder_ == null) {
                return Collections.unmodifiableList(this.contents_);
            }
            return this.contentsBuilder_.getMessageList();
        }

        @Override
        public int getContentsCount() {
            if (this.contentsBuilder_ == null) {
                return this.contents_.size();
            }
            return this.contentsBuilder_.getCount();
        }

        @Override
        public Content getContents(int index) {
            if (this.contentsBuilder_ == null) {
                return this.contents_.get(index);
            }
            return (Content)this.contentsBuilder_.getMessage(index);
        }

        public Builder setContents(int index, Content value) {
            if (this.contentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureContentsIsMutable();
                this.contents_.set(index, value);
                this.onChanged();
            } else {
                this.contentsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setContents(int index, Content.Builder builderForValue) {
            if (this.contentsBuilder_ == null) {
                this.ensureContentsIsMutable();
                this.contents_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.contentsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addContents(Content value) {
            if (this.contentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureContentsIsMutable();
                this.contents_.add(value);
                this.onChanged();
            } else {
                this.contentsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addContents(int index, Content value) {
            if (this.contentsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureContentsIsMutable();
                this.contents_.add(index, value);
                this.onChanged();
            } else {
                this.contentsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addContents(Content.Builder builderForValue) {
            if (this.contentsBuilder_ == null) {
                this.ensureContentsIsMutable();
                this.contents_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.contentsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addContents(int index, Content.Builder builderForValue) {
            if (this.contentsBuilder_ == null) {
                this.ensureContentsIsMutable();
                this.contents_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.contentsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllContents(Iterable<? extends Content> values) {
            if (this.contentsBuilder_ == null) {
                this.ensureContentsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.contents_);
                this.onChanged();
            } else {
                this.contentsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearContents() {
            if (this.contentsBuilder_ == null) {
                this.contents_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.contentsBuilder_.clear();
            }
            return this;
        }

        public Builder removeContents(int index) {
            if (this.contentsBuilder_ == null) {
                this.ensureContentsIsMutable();
                this.contents_.remove(index);
                this.onChanged();
            } else {
                this.contentsBuilder_.remove(index);
            }
            return this;
        }

        public Content.Builder getContentsBuilder(int index) {
            return (Content.Builder)this.getContentsFieldBuilder().getBuilder(index);
        }

        @Override
        public ContentOrBuilder getContentsOrBuilder(int index) {
            if (this.contentsBuilder_ == null) {
                return this.contents_.get(index);
            }
            return (ContentOrBuilder)this.contentsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ContentOrBuilder> getContentsOrBuilderList() {
            if (this.contentsBuilder_ != null) {
                return this.contentsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.contents_);
        }

        public Content.Builder addContentsBuilder() {
            return (Content.Builder)this.getContentsFieldBuilder().addBuilder((AbstractMessage)Content.getDefaultInstance());
        }

        public Content.Builder addContentsBuilder(int index) {
            return (Content.Builder)this.getContentsFieldBuilder().addBuilder(index, (AbstractMessage)Content.getDefaultInstance());
        }

        public List<Content.Builder> getContentsBuilderList() {
            return this.getContentsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Content, Content.Builder, ContentOrBuilder> getContentsFieldBuilder() {
            if (this.contentsBuilder_ == null) {
                this.contentsBuilder_ = new RepeatedFieldBuilderV3(this.contents_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.contents_ = null;
            }
            return this.contentsBuilder_;
        }

        private void ensureToolsIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.tools_ = new ArrayList<Tool>(this.tools_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<Tool> getToolsList() {
            if (this.toolsBuilder_ == null) {
                return Collections.unmodifiableList(this.tools_);
            }
            return this.toolsBuilder_.getMessageList();
        }

        @Override
        public int getToolsCount() {
            if (this.toolsBuilder_ == null) {
                return this.tools_.size();
            }
            return this.toolsBuilder_.getCount();
        }

        @Override
        public Tool getTools(int index) {
            if (this.toolsBuilder_ == null) {
                return this.tools_.get(index);
            }
            return (Tool)this.toolsBuilder_.getMessage(index);
        }

        public Builder setTools(int index, Tool value) {
            if (this.toolsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureToolsIsMutable();
                this.tools_.set(index, value);
                this.onChanged();
            } else {
                this.toolsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setTools(int index, Tool.Builder builderForValue) {
            if (this.toolsBuilder_ == null) {
                this.ensureToolsIsMutable();
                this.tools_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.toolsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addTools(Tool value) {
            if (this.toolsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureToolsIsMutable();
                this.tools_.add(value);
                this.onChanged();
            } else {
                this.toolsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addTools(int index, Tool value) {
            if (this.toolsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureToolsIsMutable();
                this.tools_.add(index, value);
                this.onChanged();
            } else {
                this.toolsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addTools(Tool.Builder builderForValue) {
            if (this.toolsBuilder_ == null) {
                this.ensureToolsIsMutable();
                this.tools_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.toolsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addTools(int index, Tool.Builder builderForValue) {
            if (this.toolsBuilder_ == null) {
                this.ensureToolsIsMutable();
                this.tools_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.toolsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllTools(Iterable<? extends Tool> values) {
            if (this.toolsBuilder_ == null) {
                this.ensureToolsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.tools_);
                this.onChanged();
            } else {
                this.toolsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearTools() {
            if (this.toolsBuilder_ == null) {
                this.tools_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.toolsBuilder_.clear();
            }
            return this;
        }

        public Builder removeTools(int index) {
            if (this.toolsBuilder_ == null) {
                this.ensureToolsIsMutable();
                this.tools_.remove(index);
                this.onChanged();
            } else {
                this.toolsBuilder_.remove(index);
            }
            return this;
        }

        public Tool.Builder getToolsBuilder(int index) {
            return (Tool.Builder)this.getToolsFieldBuilder().getBuilder(index);
        }

        @Override
        public ToolOrBuilder getToolsOrBuilder(int index) {
            if (this.toolsBuilder_ == null) {
                return this.tools_.get(index);
            }
            return (ToolOrBuilder)this.toolsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends ToolOrBuilder> getToolsOrBuilderList() {
            if (this.toolsBuilder_ != null) {
                return this.toolsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.tools_);
        }

        public Tool.Builder addToolsBuilder() {
            return (Tool.Builder)this.getToolsFieldBuilder().addBuilder((AbstractMessage)Tool.getDefaultInstance());
        }

        public Tool.Builder addToolsBuilder(int index) {
            return (Tool.Builder)this.getToolsFieldBuilder().addBuilder(index, (AbstractMessage)Tool.getDefaultInstance());
        }

        public List<Tool.Builder> getToolsBuilderList() {
            return this.getToolsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<Tool, Tool.Builder, ToolOrBuilder> getToolsFieldBuilder() {
            if (this.toolsBuilder_ == null) {
                this.toolsBuilder_ = new RepeatedFieldBuilderV3(this.tools_, (this.bitField0_ & 4) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.tools_ = null;
            }
            return this.toolsBuilder_;
        }

        private void ensureSafetySettingsIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.safetySettings_ = new ArrayList<SafetySetting>(this.safetySettings_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<SafetySetting> getSafetySettingsList() {
            if (this.safetySettingsBuilder_ == null) {
                return Collections.unmodifiableList(this.safetySettings_);
            }
            return this.safetySettingsBuilder_.getMessageList();
        }

        @Override
        public int getSafetySettingsCount() {
            if (this.safetySettingsBuilder_ == null) {
                return this.safetySettings_.size();
            }
            return this.safetySettingsBuilder_.getCount();
        }

        @Override
        public SafetySetting getSafetySettings(int index) {
            if (this.safetySettingsBuilder_ == null) {
                return this.safetySettings_.get(index);
            }
            return (SafetySetting)this.safetySettingsBuilder_.getMessage(index);
        }

        public Builder setSafetySettings(int index, SafetySetting value) {
            if (this.safetySettingsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSafetySettingsIsMutable();
                this.safetySettings_.set(index, value);
                this.onChanged();
            } else {
                this.safetySettingsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setSafetySettings(int index, SafetySetting.Builder builderForValue) {
            if (this.safetySettingsBuilder_ == null) {
                this.ensureSafetySettingsIsMutable();
                this.safetySettings_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.safetySettingsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addSafetySettings(SafetySetting value) {
            if (this.safetySettingsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSafetySettingsIsMutable();
                this.safetySettings_.add(value);
                this.onChanged();
            } else {
                this.safetySettingsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addSafetySettings(int index, SafetySetting value) {
            if (this.safetySettingsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureSafetySettingsIsMutable();
                this.safetySettings_.add(index, value);
                this.onChanged();
            } else {
                this.safetySettingsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addSafetySettings(SafetySetting.Builder builderForValue) {
            if (this.safetySettingsBuilder_ == null) {
                this.ensureSafetySettingsIsMutable();
                this.safetySettings_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.safetySettingsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addSafetySettings(int index, SafetySetting.Builder builderForValue) {
            if (this.safetySettingsBuilder_ == null) {
                this.ensureSafetySettingsIsMutable();
                this.safetySettings_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.safetySettingsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllSafetySettings(Iterable<? extends SafetySetting> values) {
            if (this.safetySettingsBuilder_ == null) {
                this.ensureSafetySettingsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.safetySettings_);
                this.onChanged();
            } else {
                this.safetySettingsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearSafetySettings() {
            if (this.safetySettingsBuilder_ == null) {
                this.safetySettings_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
            } else {
                this.safetySettingsBuilder_.clear();
            }
            return this;
        }

        public Builder removeSafetySettings(int index) {
            if (this.safetySettingsBuilder_ == null) {
                this.ensureSafetySettingsIsMutable();
                this.safetySettings_.remove(index);
                this.onChanged();
            } else {
                this.safetySettingsBuilder_.remove(index);
            }
            return this;
        }

        public SafetySetting.Builder getSafetySettingsBuilder(int index) {
            return (SafetySetting.Builder)this.getSafetySettingsFieldBuilder().getBuilder(index);
        }

        @Override
        public SafetySettingOrBuilder getSafetySettingsOrBuilder(int index) {
            if (this.safetySettingsBuilder_ == null) {
                return this.safetySettings_.get(index);
            }
            return (SafetySettingOrBuilder)this.safetySettingsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends SafetySettingOrBuilder> getSafetySettingsOrBuilderList() {
            if (this.safetySettingsBuilder_ != null) {
                return this.safetySettingsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.safetySettings_);
        }

        public SafetySetting.Builder addSafetySettingsBuilder() {
            return (SafetySetting.Builder)this.getSafetySettingsFieldBuilder().addBuilder((AbstractMessage)SafetySetting.getDefaultInstance());
        }

        public SafetySetting.Builder addSafetySettingsBuilder(int index) {
            return (SafetySetting.Builder)this.getSafetySettingsFieldBuilder().addBuilder(index, (AbstractMessage)SafetySetting.getDefaultInstance());
        }

        public List<SafetySetting.Builder> getSafetySettingsBuilderList() {
            return this.getSafetySettingsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<SafetySetting, SafetySetting.Builder, SafetySettingOrBuilder> getSafetySettingsFieldBuilder() {
            if (this.safetySettingsBuilder_ == null) {
                this.safetySettingsBuilder_ = new RepeatedFieldBuilderV3(this.safetySettings_, (this.bitField0_ & 8) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.safetySettings_ = null;
            }
            return this.safetySettingsBuilder_;
        }

        @Override
        public boolean hasGenerationConfig() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public GenerationConfig getGenerationConfig() {
            if (this.generationConfigBuilder_ == null) {
                return this.generationConfig_ == null ? GenerationConfig.getDefaultInstance() : this.generationConfig_;
            }
            return (GenerationConfig)this.generationConfigBuilder_.getMessage();
        }

        public Builder setGenerationConfig(GenerationConfig value) {
            if (this.generationConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.generationConfig_ = value;
            } else {
                this.generationConfigBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setGenerationConfig(GenerationConfig.Builder builderForValue) {
            if (this.generationConfigBuilder_ == null) {
                this.generationConfig_ = builderForValue.build();
            } else {
                this.generationConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeGenerationConfig(GenerationConfig value) {
            if (this.generationConfigBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.generationConfig_ != null && this.generationConfig_ != GenerationConfig.getDefaultInstance()) {
                    this.getGenerationConfigBuilder().mergeFrom(value);
                } else {
                    this.generationConfig_ = value;
                }
            } else {
                this.generationConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearGenerationConfig() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.generationConfig_ = null;
            if (this.generationConfigBuilder_ != null) {
                this.generationConfigBuilder_.dispose();
                this.generationConfigBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public GenerationConfig.Builder getGenerationConfigBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (GenerationConfig.Builder)this.getGenerationConfigFieldBuilder().getBuilder();
        }

        @Override
        public GenerationConfigOrBuilder getGenerationConfigOrBuilder() {
            if (this.generationConfigBuilder_ != null) {
                return (GenerationConfigOrBuilder)this.generationConfigBuilder_.getMessageOrBuilder();
            }
            return this.generationConfig_ == null ? GenerationConfig.getDefaultInstance() : this.generationConfig_;
        }

        private SingleFieldBuilderV3<GenerationConfig, GenerationConfig.Builder, GenerationConfigOrBuilder> getGenerationConfigFieldBuilder() {
            if (this.generationConfigBuilder_ == null) {
                this.generationConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getGenerationConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.generationConfig_ = null;
            }
            return this.generationConfigBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

