/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.translate.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GlossaryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_GLOSSARY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/glossaries/{glossary}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String glossary;

    @Deprecated
    protected GlossaryName() {
        this.project = null;
        this.location = null;
        this.glossary = null;
    }

    private GlossaryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.glossary = (String)Preconditions.checkNotNull((Object)builder.getGlossary());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getGlossary() {
        return this.glossary;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static GlossaryName of(String project, String location, String glossary) {
        return GlossaryName.newBuilder().setProject(project).setLocation(location).setGlossary(glossary).build();
    }

    public static String format(String project, String location, String glossary) {
        return GlossaryName.newBuilder().setProject(project).setLocation(location).setGlossary(glossary).build().toString();
    }

    public static GlossaryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_GLOSSARY.validatedMatch(formattedString, "GlossaryName.parse: formattedString not in valid format");
        return GlossaryName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("glossary"));
    }

    public static List<GlossaryName> parseList(List<String> formattedStrings) {
        ArrayList<GlossaryName> list = new ArrayList<GlossaryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GlossaryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GlossaryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GlossaryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_GLOSSARY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GlossaryName glossaryName = this;
            synchronized (glossaryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.glossary != null) {
                        fieldMapBuilder.put((Object)"glossary", (Object)this.glossary);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_GLOSSARY.instantiate(new String[]{"project", this.project, "location", this.location, "glossary", this.glossary});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            GlossaryName that = (GlossaryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.glossary, that.glossary);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.glossary);
    }

    public static class Builder {
        private String project;
        private String location;
        private String glossary;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getGlossary() {
            return this.glossary;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setGlossary(String glossary) {
            this.glossary = glossary;
            return this;
        }

        private Builder(GlossaryName glossaryName) {
            this.project = glossaryName.project;
            this.location = glossaryName.location;
            this.glossary = glossaryName.glossary;
        }

        public GlossaryName build() {
            return new GlossaryName(this);
        }
    }
}

