/*
 * Decompiled with CFR 0.152.
 */
package com.google.spanner.admin.instance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.spanner.admin.instance.v1.InstanceNameType;
import java.util.Map;

public class InstanceName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/instances/{instance}");
    private final String project;
    private final String instance;

    public String getProject() {
        return this.project;
    }

    public String getInstance() {
        return this.instance;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private InstanceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
    }

    public static InstanceName create(String project, String instance) {
        return InstanceName.newBuilder().setProject(project).setInstance(instance).build();
    }

    public static InstanceName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "InstanceName.parse: formattedString not in valid format");
        return InstanceName.create((String)matchMap.get("project"), (String)matchMap.get("instance"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return InstanceNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "instance", this.instance});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InstanceName) {
            InstanceName that = (InstanceName)o;
            return this.project.equals(that.project) && this.instance.equals(that.instance);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.instance.hashCode();
    }

    public static class Builder {
        private String project;
        private String instance;

        public String getProject() {
            return this.project;
        }

        public String getInstance() {
            return this.instance;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        private Builder() {
        }

        private Builder(InstanceName instanceName) {
            this.project = instanceName.project;
            this.instance = instanceName.instance;
        }

        public InstanceName build() {
            return new InstanceName(this);
        }
    }
}

