/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/pubsublite/v1/subscriber.proto

package com.google.cloud.pubsublite.proto;

/**
 *
 *
 * <pre>
 * PartitionAssignments should not race with acknowledgements. There
 * should be exactly one unacknowledged PartitionAssignment at a time. If not,
 * the client must break the stream.
 * </pre>
 *
 * Protobuf type {@code google.cloud.pubsublite.v1.PartitionAssignment}
 */
public final class PartitionAssignment extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.pubsublite.v1.PartitionAssignment)
    PartitionAssignmentOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PartitionAssignment.newBuilder() to construct.
  private PartitionAssignment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PartitionAssignment() {
    partitions_ = emptyLongList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PartitionAssignment();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private PartitionAssignment(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                partitions_ = newLongList();
                mutable_bitField0_ |= 0x00000001;
              }
              partitions_.addLong(input.readInt64());
              break;
            }
          case 10:
            {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              if (!((mutable_bitField0_ & 0x00000001) != 0) && input.getBytesUntilLimit() > 0) {
                partitions_ = newLongList();
                mutable_bitField0_ |= 0x00000001;
              }
              while (input.getBytesUntilLimit() > 0) {
                partitions_.addLong(input.readInt64());
              }
              input.popLimit(limit);
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        partitions_.makeImmutable(); // C
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.pubsublite.proto.SubscriberProto
        .internal_static_google_cloud_pubsublite_v1_PartitionAssignment_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.pubsublite.proto.SubscriberProto
        .internal_static_google_cloud_pubsublite_v1_PartitionAssignment_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.pubsublite.proto.PartitionAssignment.class,
            com.google.cloud.pubsublite.proto.PartitionAssignment.Builder.class);
  }

  public static final int PARTITIONS_FIELD_NUMBER = 1;
  private com.google.protobuf.Internal.LongList partitions_;
  /**
   *
   *
   * <pre>
   * The list of partition numbers this subscriber is assigned to.
   * </pre>
   *
   * <code>repeated int64 partitions = 1;</code>
   *
   * @return A list containing the partitions.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long> getPartitionsList() {
    return partitions_;
  }
  /**
   *
   *
   * <pre>
   * The list of partition numbers this subscriber is assigned to.
   * </pre>
   *
   * <code>repeated int64 partitions = 1;</code>
   *
   * @return The count of partitions.
   */
  public int getPartitionsCount() {
    return partitions_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of partition numbers this subscriber is assigned to.
   * </pre>
   *
   * <code>repeated int64 partitions = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The partitions at the given index.
   */
  public long getPartitions(int index) {
    return partitions_.getLong(index);
  }

  private int partitionsMemoizedSerializedSize = -1;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (getPartitionsList().size() > 0) {
      output.writeUInt32NoTag(10);
      output.writeUInt32NoTag(partitionsMemoizedSerializedSize);
    }
    for (int i = 0; i < partitions_.size(); i++) {
      output.writeInt64NoTag(partitions_.getLong(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < partitions_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt64SizeNoTag(partitions_.getLong(i));
      }
      size += dataSize;
      if (!getPartitionsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      partitionsMemoizedSerializedSize = dataSize;
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.pubsublite.proto.PartitionAssignment)) {
      return super.equals(obj);
    }
    com.google.cloud.pubsublite.proto.PartitionAssignment other =
        (com.google.cloud.pubsublite.proto.PartitionAssignment) obj;

    if (!getPartitionsList().equals(other.getPartitionsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getPartitionsCount() > 0) {
      hash = (37 * hash) + PARTITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPartitionsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.pubsublite.proto.PartitionAssignment parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.pubsublite.proto.PartitionAssignment parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.PartitionAssignment parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.pubsublite.proto.PartitionAssignment parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.PartitionAssignment parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.pubsublite.proto.PartitionAssignment parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.PartitionAssignment parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.pubsublite.proto.PartitionAssignment parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.PartitionAssignment parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.pubsublite.proto.PartitionAssignment parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.PartitionAssignment parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.pubsublite.proto.PartitionAssignment parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.pubsublite.proto.PartitionAssignment prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * PartitionAssignments should not race with acknowledgements. There
   * should be exactly one unacknowledged PartitionAssignment at a time. If not,
   * the client must break the stream.
   * </pre>
   *
   * Protobuf type {@code google.cloud.pubsublite.v1.PartitionAssignment}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.pubsublite.v1.PartitionAssignment)
      com.google.cloud.pubsublite.proto.PartitionAssignmentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.pubsublite.proto.SubscriberProto
          .internal_static_google_cloud_pubsublite_v1_PartitionAssignment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.pubsublite.proto.SubscriberProto
          .internal_static_google_cloud_pubsublite_v1_PartitionAssignment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.pubsublite.proto.PartitionAssignment.class,
              com.google.cloud.pubsublite.proto.PartitionAssignment.Builder.class);
    }

    // Construct using com.google.cloud.pubsublite.proto.PartitionAssignment.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      partitions_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.pubsublite.proto.SubscriberProto
          .internal_static_google_cloud_pubsublite_v1_PartitionAssignment_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.PartitionAssignment getDefaultInstanceForType() {
      return com.google.cloud.pubsublite.proto.PartitionAssignment.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.PartitionAssignment build() {
      com.google.cloud.pubsublite.proto.PartitionAssignment result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.PartitionAssignment buildPartial() {
      com.google.cloud.pubsublite.proto.PartitionAssignment result =
          new com.google.cloud.pubsublite.proto.PartitionAssignment(this);
      int from_bitField0_ = bitField0_;
      if (((bitField0_ & 0x00000001) != 0)) {
        partitions_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.partitions_ = partitions_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.pubsublite.proto.PartitionAssignment) {
        return mergeFrom((com.google.cloud.pubsublite.proto.PartitionAssignment) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.pubsublite.proto.PartitionAssignment other) {
      if (other == com.google.cloud.pubsublite.proto.PartitionAssignment.getDefaultInstance())
        return this;
      if (!other.partitions_.isEmpty()) {
        if (partitions_.isEmpty()) {
          partitions_ = other.partitions_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensurePartitionsIsMutable();
          partitions_.addAll(other.partitions_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.pubsublite.proto.PartitionAssignment parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.pubsublite.proto.PartitionAssignment) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Internal.LongList partitions_ = emptyLongList();

    private void ensurePartitionsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        partitions_ = mutableCopy(partitions_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * The list of partition numbers this subscriber is assigned to.
     * </pre>
     *
     * <code>repeated int64 partitions = 1;</code>
     *
     * @return A list containing the partitions.
     */
    public java.util.List<java.lang.Long> getPartitionsList() {
      return ((bitField0_ & 0x00000001) != 0)
          ? java.util.Collections.unmodifiableList(partitions_)
          : partitions_;
    }
    /**
     *
     *
     * <pre>
     * The list of partition numbers this subscriber is assigned to.
     * </pre>
     *
     * <code>repeated int64 partitions = 1;</code>
     *
     * @return The count of partitions.
     */
    public int getPartitionsCount() {
      return partitions_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of partition numbers this subscriber is assigned to.
     * </pre>
     *
     * <code>repeated int64 partitions = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The partitions at the given index.
     */
    public long getPartitions(int index) {
      return partitions_.getLong(index);
    }
    /**
     *
     *
     * <pre>
     * The list of partition numbers this subscriber is assigned to.
     * </pre>
     *
     * <code>repeated int64 partitions = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The partitions to set.
     * @return This builder for chaining.
     */
    public Builder setPartitions(int index, long value) {
      ensurePartitionsIsMutable();
      partitions_.setLong(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of partition numbers this subscriber is assigned to.
     * </pre>
     *
     * <code>repeated int64 partitions = 1;</code>
     *
     * @param value The partitions to add.
     * @return This builder for chaining.
     */
    public Builder addPartitions(long value) {
      ensurePartitionsIsMutable();
      partitions_.addLong(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of partition numbers this subscriber is assigned to.
     * </pre>
     *
     * <code>repeated int64 partitions = 1;</code>
     *
     * @param values The partitions to add.
     * @return This builder for chaining.
     */
    public Builder addAllPartitions(java.lang.Iterable<? extends java.lang.Long> values) {
      ensurePartitionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partitions_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of partition numbers this subscriber is assigned to.
     * </pre>
     *
     * <code>repeated int64 partitions = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPartitions() {
      partitions_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.pubsublite.v1.PartitionAssignment)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.pubsublite.v1.PartitionAssignment)
  private static final com.google.cloud.pubsublite.proto.PartitionAssignment DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.pubsublite.proto.PartitionAssignment();
  }

  public static com.google.cloud.pubsublite.proto.PartitionAssignment getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PartitionAssignment> PARSER =
      new com.google.protobuf.AbstractParser<PartitionAssignment>() {
        @java.lang.Override
        public PartitionAssignment parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new PartitionAssignment(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<PartitionAssignment> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PartitionAssignment> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.pubsublite.proto.PartitionAssignment getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
