/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/pubsublite/v1/common.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.pubsublite.proto;

/**
 *
 *
 * <pre>
 * Metadata about a subscription resource.
 * </pre>
 *
 * Protobuf type {@code google.cloud.pubsublite.v1.Subscription}
 */
public final class Subscription extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.pubsublite.v1.Subscription)
    SubscriptionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Subscription.newBuilder() to construct.
  private Subscription(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Subscription() {
    name_ = "";
    topic_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Subscription();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.pubsublite.proto.CommonProto
        .internal_static_google_cloud_pubsublite_v1_Subscription_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.pubsublite.proto.CommonProto
        .internal_static_google_cloud_pubsublite_v1_Subscription_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.pubsublite.proto.Subscription.class,
            com.google.cloud.pubsublite.proto.Subscription.Builder.class);
  }

  public interface DeliveryConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.pubsublite.v1.Subscription.DeliveryConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The DeliveryRequirement for this subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement delivery_requirement = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for deliveryRequirement.
     */
    int getDeliveryRequirementValue();
    /**
     *
     *
     * <pre>
     * The DeliveryRequirement for this subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement delivery_requirement = 3;
     * </code>
     *
     * @return The deliveryRequirement.
     */
    com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.DeliveryRequirement
        getDeliveryRequirement();
  }
  /**
   *
   *
   * <pre>
   * The settings for a subscription's message delivery.
   * </pre>
   *
   * Protobuf type {@code google.cloud.pubsublite.v1.Subscription.DeliveryConfig}
   */
  public static final class DeliveryConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.pubsublite.v1.Subscription.DeliveryConfig)
      DeliveryConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeliveryConfig.newBuilder() to construct.
    private DeliveryConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeliveryConfig() {
      deliveryRequirement_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeliveryConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.pubsublite.proto.CommonProto
          .internal_static_google_cloud_pubsublite_v1_Subscription_DeliveryConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.pubsublite.proto.CommonProto
          .internal_static_google_cloud_pubsublite_v1_Subscription_DeliveryConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.class,
              com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * When this subscription should send messages to subscribers relative to
     * messages persistence in storage. For details, see [Creating Lite
     * subscriptions](https://cloud.google.com/pubsub/lite/docs/subscriptions#creating_lite_subscriptions).
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement}
     */
    public enum DeliveryRequirement implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>DELIVERY_REQUIREMENT_UNSPECIFIED = 0;</code>
       */
      DELIVERY_REQUIREMENT_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The server does not wait for a published message to be successfully
       * written to storage before delivering it to subscribers.
       * </pre>
       *
       * <code>DELIVER_IMMEDIATELY = 1;</code>
       */
      DELIVER_IMMEDIATELY(1),
      /**
       *
       *
       * <pre>
       * The server will not deliver a published message to subscribers until
       * the message has been successfully written to storage. This will result
       * in higher end-to-end latency, but consistent delivery.
       * </pre>
       *
       * <code>DELIVER_AFTER_STORED = 2;</code>
       */
      DELIVER_AFTER_STORED(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value. This value is unused.
       * </pre>
       *
       * <code>DELIVERY_REQUIREMENT_UNSPECIFIED = 0;</code>
       */
      public static final int DELIVERY_REQUIREMENT_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The server does not wait for a published message to be successfully
       * written to storage before delivering it to subscribers.
       * </pre>
       *
       * <code>DELIVER_IMMEDIATELY = 1;</code>
       */
      public static final int DELIVER_IMMEDIATELY_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The server will not deliver a published message to subscribers until
       * the message has been successfully written to storage. This will result
       * in higher end-to-end latency, but consistent delivery.
       * </pre>
       *
       * <code>DELIVER_AFTER_STORED = 2;</code>
       */
      public static final int DELIVER_AFTER_STORED_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static DeliveryRequirement valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static DeliveryRequirement forNumber(int value) {
        switch (value) {
          case 0:
            return DELIVERY_REQUIREMENT_UNSPECIFIED;
          case 1:
            return DELIVER_IMMEDIATELY;
          case 2:
            return DELIVER_AFTER_STORED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<DeliveryRequirement>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<DeliveryRequirement>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<DeliveryRequirement>() {
                public DeliveryRequirement findValueByNumber(int number) {
                  return DeliveryRequirement.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final DeliveryRequirement[] VALUES = values();

      public static DeliveryRequirement valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private DeliveryRequirement(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement)
    }

    public static final int DELIVERY_REQUIREMENT_FIELD_NUMBER = 3;
    private int deliveryRequirement_ = 0;
    /**
     *
     *
     * <pre>
     * The DeliveryRequirement for this subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement delivery_requirement = 3;
     * </code>
     *
     * @return The enum numeric value on the wire for deliveryRequirement.
     */
    @java.lang.Override
    public int getDeliveryRequirementValue() {
      return deliveryRequirement_;
    }
    /**
     *
     *
     * <pre>
     * The DeliveryRequirement for this subscription.
     * </pre>
     *
     * <code>
     * .google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement delivery_requirement = 3;
     * </code>
     *
     * @return The deliveryRequirement.
     */
    @java.lang.Override
    public com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.DeliveryRequirement
        getDeliveryRequirement() {
      com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.DeliveryRequirement result =
          com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.DeliveryRequirement
              .forNumber(deliveryRequirement_);
      return result == null
          ? com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.DeliveryRequirement
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (deliveryRequirement_
          != com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.DeliveryRequirement
              .DELIVERY_REQUIREMENT_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(3, deliveryRequirement_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (deliveryRequirement_
          != com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.DeliveryRequirement
              .DELIVERY_REQUIREMENT_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, deliveryRequirement_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig other =
          (com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig) obj;

      if (deliveryRequirement_ != other.deliveryRequirement_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DELIVERY_REQUIREMENT_FIELD_NUMBER;
      hash = (53 * hash) + deliveryRequirement_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The settings for a subscription's message delivery.
     * </pre>
     *
     * Protobuf type {@code google.cloud.pubsublite.v1.Subscription.DeliveryConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.pubsublite.v1.Subscription.DeliveryConfig)
        com.google.cloud.pubsublite.proto.Subscription.DeliveryConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.pubsublite.proto.CommonProto
            .internal_static_google_cloud_pubsublite_v1_Subscription_DeliveryConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.pubsublite.proto.CommonProto
            .internal_static_google_cloud_pubsublite_v1_Subscription_DeliveryConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.class,
                com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.Builder.class);
      }

      // Construct using com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        deliveryRequirement_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.pubsublite.proto.CommonProto
            .internal_static_google_cloud_pubsublite_v1_Subscription_DeliveryConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig
          getDefaultInstanceForType() {
        return com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig build() {
        com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig buildPartial() {
        com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig result =
            new com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.deliveryRequirement_ = deliveryRequirement_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig) {
          return mergeFrom((com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig other) {
        if (other
            == com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.getDefaultInstance())
          return this;
        if (other.deliveryRequirement_ != 0) {
          setDeliveryRequirementValue(other.getDeliveryRequirementValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 24:
                {
                  deliveryRequirement_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 24
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int deliveryRequirement_ = 0;
      /**
       *
       *
       * <pre>
       * The DeliveryRequirement for this subscription.
       * </pre>
       *
       * <code>
       * .google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement delivery_requirement = 3;
       * </code>
       *
       * @return The enum numeric value on the wire for deliveryRequirement.
       */
      @java.lang.Override
      public int getDeliveryRequirementValue() {
        return deliveryRequirement_;
      }
      /**
       *
       *
       * <pre>
       * The DeliveryRequirement for this subscription.
       * </pre>
       *
       * <code>
       * .google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement delivery_requirement = 3;
       * </code>
       *
       * @param value The enum numeric value on the wire for deliveryRequirement to set.
       * @return This builder for chaining.
       */
      public Builder setDeliveryRequirementValue(int value) {
        deliveryRequirement_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The DeliveryRequirement for this subscription.
       * </pre>
       *
       * <code>
       * .google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement delivery_requirement = 3;
       * </code>
       *
       * @return The deliveryRequirement.
       */
      @java.lang.Override
      public com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.DeliveryRequirement
          getDeliveryRequirement() {
        com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.DeliveryRequirement result =
            com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.DeliveryRequirement
                .forNumber(deliveryRequirement_);
        return result == null
            ? com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.DeliveryRequirement
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The DeliveryRequirement for this subscription.
       * </pre>
       *
       * <code>
       * .google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement delivery_requirement = 3;
       * </code>
       *
       * @param value The deliveryRequirement to set.
       * @return This builder for chaining.
       */
      public Builder setDeliveryRequirement(
          com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.DeliveryRequirement value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        deliveryRequirement_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The DeliveryRequirement for this subscription.
       * </pre>
       *
       * <code>
       * .google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement delivery_requirement = 3;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDeliveryRequirement() {
        bitField0_ = (bitField0_ & ~0x00000001);
        deliveryRequirement_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.pubsublite.v1.Subscription.DeliveryConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.pubsublite.v1.Subscription.DeliveryConfig)
    private static final com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig();
    }

    public static com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeliveryConfig> PARSER =
        new com.google.protobuf.AbstractParser<DeliveryConfig>() {
          @java.lang.Override
          public DeliveryConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeliveryConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeliveryConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the subscription.
   * Structured like:
   * projects/{project_number}/locations/{location}/subscriptions/{subscription_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the subscription.
   * Structured like:
   * projects/{project_number}/locations/{location}/subscriptions/{subscription_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TOPIC_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object topic_ = "";
  /**
   *
   *
   * <pre>
   * The name of the topic this subscription is attached to.
   * Structured like:
   * projects/{project_number}/locations/{location}/topics/{topic_id}
   * </pre>
   *
   * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The topic.
   */
  @java.lang.Override
  public java.lang.String getTopic() {
    java.lang.Object ref = topic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      topic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the topic this subscription is attached to.
   * Structured like:
   * projects/{project_number}/locations/{location}/topics/{topic_id}
   * </pre>
   *
   * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for topic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTopicBytes() {
    java.lang.Object ref = topic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      topic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DELIVERY_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig deliveryConfig_;
  /**
   *
   *
   * <pre>
   * The settings for this subscription's message delivery.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.Subscription.DeliveryConfig delivery_config = 3;</code>
   *
   * @return Whether the deliveryConfig field is set.
   */
  @java.lang.Override
  public boolean hasDeliveryConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The settings for this subscription's message delivery.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.Subscription.DeliveryConfig delivery_config = 3;</code>
   *
   * @return The deliveryConfig.
   */
  @java.lang.Override
  public com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig getDeliveryConfig() {
    return deliveryConfig_ == null
        ? com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.getDefaultInstance()
        : deliveryConfig_;
  }
  /**
   *
   *
   * <pre>
   * The settings for this subscription's message delivery.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.Subscription.DeliveryConfig delivery_config = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.pubsublite.proto.Subscription.DeliveryConfigOrBuilder
      getDeliveryConfigOrBuilder() {
    return deliveryConfig_ == null
        ? com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.getDefaultInstance()
        : deliveryConfig_;
  }

  public static final int EXPORT_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.pubsublite.proto.ExportConfig exportConfig_;
  /**
   *
   *
   * <pre>
   * If present, messages are automatically written from the Pub/Sub Lite topic
   * associated with this subscription to a destination.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.ExportConfig export_config = 4;</code>
   *
   * @return Whether the exportConfig field is set.
   */
  @java.lang.Override
  public boolean hasExportConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * If present, messages are automatically written from the Pub/Sub Lite topic
   * associated with this subscription to a destination.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.ExportConfig export_config = 4;</code>
   *
   * @return The exportConfig.
   */
  @java.lang.Override
  public com.google.cloud.pubsublite.proto.ExportConfig getExportConfig() {
    return exportConfig_ == null
        ? com.google.cloud.pubsublite.proto.ExportConfig.getDefaultInstance()
        : exportConfig_;
  }
  /**
   *
   *
   * <pre>
   * If present, messages are automatically written from the Pub/Sub Lite topic
   * associated with this subscription to a destination.
   * </pre>
   *
   * <code>.google.cloud.pubsublite.v1.ExportConfig export_config = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.pubsublite.proto.ExportConfigOrBuilder getExportConfigOrBuilder() {
    return exportConfig_ == null
        ? com.google.cloud.pubsublite.proto.ExportConfig.getDefaultInstance()
        : exportConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, topic_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getDeliveryConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getExportConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, topic_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDeliveryConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getExportConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.pubsublite.proto.Subscription)) {
      return super.equals(obj);
    }
    com.google.cloud.pubsublite.proto.Subscription other =
        (com.google.cloud.pubsublite.proto.Subscription) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTopic().equals(other.getTopic())) return false;
    if (hasDeliveryConfig() != other.hasDeliveryConfig()) return false;
    if (hasDeliveryConfig()) {
      if (!getDeliveryConfig().equals(other.getDeliveryConfig())) return false;
    }
    if (hasExportConfig() != other.hasExportConfig()) return false;
    if (hasExportConfig()) {
      if (!getExportConfig().equals(other.getExportConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getTopic().hashCode();
    if (hasDeliveryConfig()) {
      hash = (37 * hash) + DELIVERY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getDeliveryConfig().hashCode();
    }
    if (hasExportConfig()) {
      hash = (37 * hash) + EXPORT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getExportConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.pubsublite.proto.Subscription parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.pubsublite.proto.Subscription parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.Subscription parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.pubsublite.proto.Subscription parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.Subscription parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.pubsublite.proto.Subscription parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.Subscription parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.pubsublite.proto.Subscription parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.Subscription parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.pubsublite.proto.Subscription parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.pubsublite.proto.Subscription parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.pubsublite.proto.Subscription parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.pubsublite.proto.Subscription prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata about a subscription resource.
   * </pre>
   *
   * Protobuf type {@code google.cloud.pubsublite.v1.Subscription}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.pubsublite.v1.Subscription)
      com.google.cloud.pubsublite.proto.SubscriptionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.pubsublite.proto.CommonProto
          .internal_static_google_cloud_pubsublite_v1_Subscription_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.pubsublite.proto.CommonProto
          .internal_static_google_cloud_pubsublite_v1_Subscription_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.pubsublite.proto.Subscription.class,
              com.google.cloud.pubsublite.proto.Subscription.Builder.class);
    }

    // Construct using com.google.cloud.pubsublite.proto.Subscription.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDeliveryConfigFieldBuilder();
        getExportConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      topic_ = "";
      deliveryConfig_ = null;
      if (deliveryConfigBuilder_ != null) {
        deliveryConfigBuilder_.dispose();
        deliveryConfigBuilder_ = null;
      }
      exportConfig_ = null;
      if (exportConfigBuilder_ != null) {
        exportConfigBuilder_.dispose();
        exportConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.pubsublite.proto.CommonProto
          .internal_static_google_cloud_pubsublite_v1_Subscription_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.Subscription getDefaultInstanceForType() {
      return com.google.cloud.pubsublite.proto.Subscription.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.Subscription build() {
      com.google.cloud.pubsublite.proto.Subscription result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.pubsublite.proto.Subscription buildPartial() {
      com.google.cloud.pubsublite.proto.Subscription result =
          new com.google.cloud.pubsublite.proto.Subscription(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.pubsublite.proto.Subscription result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.topic_ = topic_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.deliveryConfig_ =
            deliveryConfigBuilder_ == null ? deliveryConfig_ : deliveryConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.exportConfig_ =
            exportConfigBuilder_ == null ? exportConfig_ : exportConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.pubsublite.proto.Subscription) {
        return mergeFrom((com.google.cloud.pubsublite.proto.Subscription) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.pubsublite.proto.Subscription other) {
      if (other == com.google.cloud.pubsublite.proto.Subscription.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTopic().isEmpty()) {
        topic_ = other.topic_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDeliveryConfig()) {
        mergeDeliveryConfig(other.getDeliveryConfig());
      }
      if (other.hasExportConfig()) {
        mergeExportConfig(other.getExportConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                topic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDeliveryConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getExportConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the subscription.
     * Structured like:
     * projects/{project_number}/locations/{location}/subscriptions/{subscription_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the subscription.
     * Structured like:
     * projects/{project_number}/locations/{location}/subscriptions/{subscription_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the subscription.
     * Structured like:
     * projects/{project_number}/locations/{location}/subscriptions/{subscription_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the subscription.
     * Structured like:
     * projects/{project_number}/locations/{location}/subscriptions/{subscription_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the subscription.
     * Structured like:
     * projects/{project_number}/locations/{location}/subscriptions/{subscription_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object topic_ = "";
    /**
     *
     *
     * <pre>
     * The name of the topic this subscription is attached to.
     * Structured like:
     * projects/{project_number}/locations/{location}/topics/{topic_id}
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The topic.
     */
    public java.lang.String getTopic() {
      java.lang.Object ref = topic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the topic this subscription is attached to.
     * Structured like:
     * projects/{project_number}/locations/{location}/topics/{topic_id}
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for topic.
     */
    public com.google.protobuf.ByteString getTopicBytes() {
      java.lang.Object ref = topic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        topic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the topic this subscription is attached to.
     * Structured like:
     * projects/{project_number}/locations/{location}/topics/{topic_id}
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The topic to set.
     * @return This builder for chaining.
     */
    public Builder setTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      topic_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the topic this subscription is attached to.
     * Structured like:
     * projects/{project_number}/locations/{location}/topics/{topic_id}
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTopic() {
      topic_ = getDefaultInstance().getTopic();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the topic this subscription is attached to.
     * Structured like:
     * projects/{project_number}/locations/{location}/topics/{topic_id}
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for topic to set.
     * @return This builder for chaining.
     */
    public Builder setTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      topic_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig deliveryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig,
            com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.Builder,
            com.google.cloud.pubsublite.proto.Subscription.DeliveryConfigOrBuilder>
        deliveryConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The settings for this subscription's message delivery.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Subscription.DeliveryConfig delivery_config = 3;</code>
     *
     * @return Whether the deliveryConfig field is set.
     */
    public boolean hasDeliveryConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The settings for this subscription's message delivery.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Subscription.DeliveryConfig delivery_config = 3;</code>
     *
     * @return The deliveryConfig.
     */
    public com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig getDeliveryConfig() {
      if (deliveryConfigBuilder_ == null) {
        return deliveryConfig_ == null
            ? com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.getDefaultInstance()
            : deliveryConfig_;
      } else {
        return deliveryConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The settings for this subscription's message delivery.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Subscription.DeliveryConfig delivery_config = 3;</code>
     */
    public Builder setDeliveryConfig(
        com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig value) {
      if (deliveryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deliveryConfig_ = value;
      } else {
        deliveryConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The settings for this subscription's message delivery.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Subscription.DeliveryConfig delivery_config = 3;</code>
     */
    public Builder setDeliveryConfig(
        com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.Builder builderForValue) {
      if (deliveryConfigBuilder_ == null) {
        deliveryConfig_ = builderForValue.build();
      } else {
        deliveryConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The settings for this subscription's message delivery.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Subscription.DeliveryConfig delivery_config = 3;</code>
     */
    public Builder mergeDeliveryConfig(
        com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig value) {
      if (deliveryConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && deliveryConfig_ != null
            && deliveryConfig_
                != com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig
                    .getDefaultInstance()) {
          getDeliveryConfigBuilder().mergeFrom(value);
        } else {
          deliveryConfig_ = value;
        }
      } else {
        deliveryConfigBuilder_.mergeFrom(value);
      }
      if (deliveryConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The settings for this subscription's message delivery.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Subscription.DeliveryConfig delivery_config = 3;</code>
     */
    public Builder clearDeliveryConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      deliveryConfig_ = null;
      if (deliveryConfigBuilder_ != null) {
        deliveryConfigBuilder_.dispose();
        deliveryConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The settings for this subscription's message delivery.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Subscription.DeliveryConfig delivery_config = 3;</code>
     */
    public com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.Builder
        getDeliveryConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDeliveryConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The settings for this subscription's message delivery.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Subscription.DeliveryConfig delivery_config = 3;</code>
     */
    public com.google.cloud.pubsublite.proto.Subscription.DeliveryConfigOrBuilder
        getDeliveryConfigOrBuilder() {
      if (deliveryConfigBuilder_ != null) {
        return deliveryConfigBuilder_.getMessageOrBuilder();
      } else {
        return deliveryConfig_ == null
            ? com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.getDefaultInstance()
            : deliveryConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The settings for this subscription's message delivery.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.Subscription.DeliveryConfig delivery_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig,
            com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.Builder,
            com.google.cloud.pubsublite.proto.Subscription.DeliveryConfigOrBuilder>
        getDeliveryConfigFieldBuilder() {
      if (deliveryConfigBuilder_ == null) {
        deliveryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig,
                com.google.cloud.pubsublite.proto.Subscription.DeliveryConfig.Builder,
                com.google.cloud.pubsublite.proto.Subscription.DeliveryConfigOrBuilder>(
                getDeliveryConfig(), getParentForChildren(), isClean());
        deliveryConfig_ = null;
      }
      return deliveryConfigBuilder_;
    }

    private com.google.cloud.pubsublite.proto.ExportConfig exportConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.pubsublite.proto.ExportConfig,
            com.google.cloud.pubsublite.proto.ExportConfig.Builder,
            com.google.cloud.pubsublite.proto.ExportConfigOrBuilder>
        exportConfigBuilder_;
    /**
     *
     *
     * <pre>
     * If present, messages are automatically written from the Pub/Sub Lite topic
     * associated with this subscription to a destination.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig export_config = 4;</code>
     *
     * @return Whether the exportConfig field is set.
     */
    public boolean hasExportConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * If present, messages are automatically written from the Pub/Sub Lite topic
     * associated with this subscription to a destination.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig export_config = 4;</code>
     *
     * @return The exportConfig.
     */
    public com.google.cloud.pubsublite.proto.ExportConfig getExportConfig() {
      if (exportConfigBuilder_ == null) {
        return exportConfig_ == null
            ? com.google.cloud.pubsublite.proto.ExportConfig.getDefaultInstance()
            : exportConfig_;
      } else {
        return exportConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If present, messages are automatically written from the Pub/Sub Lite topic
     * associated with this subscription to a destination.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig export_config = 4;</code>
     */
    public Builder setExportConfig(com.google.cloud.pubsublite.proto.ExportConfig value) {
      if (exportConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        exportConfig_ = value;
      } else {
        exportConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, messages are automatically written from the Pub/Sub Lite topic
     * associated with this subscription to a destination.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig export_config = 4;</code>
     */
    public Builder setExportConfig(
        com.google.cloud.pubsublite.proto.ExportConfig.Builder builderForValue) {
      if (exportConfigBuilder_ == null) {
        exportConfig_ = builderForValue.build();
      } else {
        exportConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, messages are automatically written from the Pub/Sub Lite topic
     * associated with this subscription to a destination.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig export_config = 4;</code>
     */
    public Builder mergeExportConfig(com.google.cloud.pubsublite.proto.ExportConfig value) {
      if (exportConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && exportConfig_ != null
            && exportConfig_
                != com.google.cloud.pubsublite.proto.ExportConfig.getDefaultInstance()) {
          getExportConfigBuilder().mergeFrom(value);
        } else {
          exportConfig_ = value;
        }
      } else {
        exportConfigBuilder_.mergeFrom(value);
      }
      if (exportConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, messages are automatically written from the Pub/Sub Lite topic
     * associated with this subscription to a destination.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig export_config = 4;</code>
     */
    public Builder clearExportConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      exportConfig_ = null;
      if (exportConfigBuilder_ != null) {
        exportConfigBuilder_.dispose();
        exportConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, messages are automatically written from the Pub/Sub Lite topic
     * associated with this subscription to a destination.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig export_config = 4;</code>
     */
    public com.google.cloud.pubsublite.proto.ExportConfig.Builder getExportConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getExportConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If present, messages are automatically written from the Pub/Sub Lite topic
     * associated with this subscription to a destination.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig export_config = 4;</code>
     */
    public com.google.cloud.pubsublite.proto.ExportConfigOrBuilder getExportConfigOrBuilder() {
      if (exportConfigBuilder_ != null) {
        return exportConfigBuilder_.getMessageOrBuilder();
      } else {
        return exportConfig_ == null
            ? com.google.cloud.pubsublite.proto.ExportConfig.getDefaultInstance()
            : exportConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * If present, messages are automatically written from the Pub/Sub Lite topic
     * associated with this subscription to a destination.
     * </pre>
     *
     * <code>.google.cloud.pubsublite.v1.ExportConfig export_config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.pubsublite.proto.ExportConfig,
            com.google.cloud.pubsublite.proto.ExportConfig.Builder,
            com.google.cloud.pubsublite.proto.ExportConfigOrBuilder>
        getExportConfigFieldBuilder() {
      if (exportConfigBuilder_ == null) {
        exportConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.pubsublite.proto.ExportConfig,
                com.google.cloud.pubsublite.proto.ExportConfig.Builder,
                com.google.cloud.pubsublite.proto.ExportConfigOrBuilder>(
                getExportConfig(), getParentForChildren(), isClean());
        exportConfig_ = null;
      }
      return exportConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.pubsublite.v1.Subscription)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.pubsublite.v1.Subscription)
  private static final com.google.cloud.pubsublite.proto.Subscription DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.pubsublite.proto.Subscription();
  }

  public static com.google.cloud.pubsublite.proto.Subscription getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Subscription> PARSER =
      new com.google.protobuf.AbstractParser<Subscription>() {
        @java.lang.Override
        public Subscription parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Subscription> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Subscription> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.pubsublite.proto.Subscription getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
