/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.Distribution;
import com.google.api.DistributionOrBuilder;
import com.google.monitoring.v3.CommonProto;
import com.google.monitoring.v3.TypedValueOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class TypedValue
extends GeneratedMessageV3
implements TypedValueOrBuilder {
    private static final long serialVersionUID = 0L;
    private int valueCase_ = 0;
    private Object value_;
    public static final int BOOL_VALUE_FIELD_NUMBER = 1;
    public static final int INT64_VALUE_FIELD_NUMBER = 2;
    public static final int DOUBLE_VALUE_FIELD_NUMBER = 3;
    public static final int STRING_VALUE_FIELD_NUMBER = 4;
    public static final int DISTRIBUTION_VALUE_FIELD_NUMBER = 5;
    private byte memoizedIsInitialized = (byte)-1;
    private static final TypedValue DEFAULT_INSTANCE = new TypedValue();
    private static final Parser<TypedValue> PARSER = new AbstractParser<TypedValue>(){

        public TypedValue parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = TypedValue.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private TypedValue(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private TypedValue() {
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new TypedValue();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CommonProto.internal_static_google_monitoring_v3_TypedValue_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CommonProto.internal_static_google_monitoring_v3_TypedValue_fieldAccessorTable.ensureFieldAccessorsInitialized(TypedValue.class, Builder.class);
    }

    @Override
    public ValueCase getValueCase() {
        return ValueCase.forNumber(this.valueCase_);
    }

    @Override
    public boolean hasBoolValue() {
        return this.valueCase_ == 1;
    }

    @Override
    public boolean getBoolValue() {
        if (this.valueCase_ == 1) {
            return (Boolean)this.value_;
        }
        return false;
    }

    @Override
    public boolean hasInt64Value() {
        return this.valueCase_ == 2;
    }

    @Override
    public long getInt64Value() {
        if (this.valueCase_ == 2) {
            return (Long)this.value_;
        }
        return 0L;
    }

    @Override
    public boolean hasDoubleValue() {
        return this.valueCase_ == 3;
    }

    @Override
    public double getDoubleValue() {
        if (this.valueCase_ == 3) {
            return (Double)this.value_;
        }
        return 0.0;
    }

    @Override
    public boolean hasStringValue() {
        return this.valueCase_ == 4;
    }

    @Override
    public String getStringValue() {
        Object ref = "";
        if (this.valueCase_ == 4) {
            ref = this.value_;
        }
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        if (this.valueCase_ == 4) {
            this.value_ = s;
        }
        return s;
    }

    @Override
    public ByteString getStringValueBytes() {
        Object ref = "";
        if (this.valueCase_ == 4) {
            ref = this.value_;
        }
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            if (this.valueCase_ == 4) {
                this.value_ = b;
            }
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasDistributionValue() {
        return this.valueCase_ == 5;
    }

    @Override
    public Distribution getDistributionValue() {
        if (this.valueCase_ == 5) {
            return (Distribution)this.value_;
        }
        return Distribution.getDefaultInstance();
    }

    @Override
    public DistributionOrBuilder getDistributionValueOrBuilder() {
        if (this.valueCase_ == 5) {
            return (Distribution)this.value_;
        }
        return Distribution.getDefaultInstance();
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (this.valueCase_ == 1) {
            output.writeBool(1, ((Boolean)this.value_).booleanValue());
        }
        if (this.valueCase_ == 2) {
            output.writeInt64(2, ((Long)this.value_).longValue());
        }
        if (this.valueCase_ == 3) {
            output.writeDouble(3, ((Double)this.value_).doubleValue());
        }
        if (this.valueCase_ == 4) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.value_);
        }
        if (this.valueCase_ == 5) {
            output.writeMessage(5, (MessageLite)((Distribution)this.value_));
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.valueCase_ == 1) {
            size += CodedOutputStream.computeBoolSize((int)1, (boolean)((Boolean)this.value_));
        }
        if (this.valueCase_ == 2) {
            size += CodedOutputStream.computeInt64Size((int)2, (long)((Long)this.value_));
        }
        if (this.valueCase_ == 3) {
            size += CodedOutputStream.computeDoubleSize((int)3, (double)((Double)this.value_));
        }
        if (this.valueCase_ == 4) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.value_);
        }
        if (this.valueCase_ == 5) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)((Distribution)this.value_));
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TypedValue)) {
            return super.equals(obj);
        }
        TypedValue other = (TypedValue)obj;
        if (!this.getValueCase().equals((Object)other.getValueCase())) {
            return false;
        }
        switch (this.valueCase_) {
            case 1: {
                if (this.getBoolValue() == other.getBoolValue()) break;
                return false;
            }
            case 2: {
                if (this.getInt64Value() == other.getInt64Value()) break;
                return false;
            }
            case 3: {
                if (Double.doubleToLongBits(this.getDoubleValue()) == Double.doubleToLongBits(other.getDoubleValue())) break;
                return false;
            }
            case 4: {
                if (this.getStringValue().equals(other.getStringValue())) break;
                return false;
            }
            case 5: {
                if (this.getDistributionValue().equals((Object)other.getDistributionValue())) break;
                return false;
            }
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + TypedValue.getDescriptor().hashCode();
        switch (this.valueCase_) {
            case 1: {
                hash = 37 * hash + 1;
                hash = 53 * hash + Internal.hashBoolean((boolean)this.getBoolValue());
                break;
            }
            case 2: {
                hash = 37 * hash + 2;
                hash = 53 * hash + Internal.hashLong((long)this.getInt64Value());
                break;
            }
            case 3: {
                hash = 37 * hash + 3;
                hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getDoubleValue()));
                break;
            }
            case 4: {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.getStringValue().hashCode();
                break;
            }
            case 5: {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getDistributionValue().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static TypedValue parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (TypedValue)PARSER.parseFrom(data);
    }

    public static TypedValue parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TypedValue)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TypedValue parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (TypedValue)PARSER.parseFrom(data);
    }

    public static TypedValue parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TypedValue)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TypedValue parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (TypedValue)PARSER.parseFrom(data);
    }

    public static TypedValue parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (TypedValue)PARSER.parseFrom(data, extensionRegistry);
    }

    public static TypedValue parseFrom(InputStream input) throws IOException {
        return (TypedValue)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static TypedValue parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TypedValue)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TypedValue parseDelimitedFrom(InputStream input) throws IOException {
        return (TypedValue)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static TypedValue parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TypedValue)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static TypedValue parseFrom(CodedInputStream input) throws IOException {
        return (TypedValue)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static TypedValue parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (TypedValue)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return TypedValue.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(TypedValue prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static TypedValue getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<TypedValue> parser() {
        return PARSER;
    }

    public Parser<TypedValue> getParserForType() {
        return PARSER;
    }

    public TypedValue getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements TypedValueOrBuilder {
        private int valueCase_ = 0;
        private Object value_;
        private SingleFieldBuilderV3<Distribution, Distribution.Builder, DistributionOrBuilder> distributionValueBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return CommonProto.internal_static_google_monitoring_v3_TypedValue_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CommonProto.internal_static_google_monitoring_v3_TypedValue_fieldAccessorTable.ensureFieldAccessorsInitialized(TypedValue.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            if (this.distributionValueBuilder_ != null) {
                this.distributionValueBuilder_.clear();
            }
            this.valueCase_ = 0;
            this.value_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CommonProto.internal_static_google_monitoring_v3_TypedValue_descriptor;
        }

        public TypedValue getDefaultInstanceForType() {
            return TypedValue.getDefaultInstance();
        }

        public TypedValue build() {
            TypedValue result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public TypedValue buildPartial() {
            TypedValue result = new TypedValue(this);
            if (this.valueCase_ == 1) {
                result.value_ = this.value_;
            }
            if (this.valueCase_ == 2) {
                result.value_ = this.value_;
            }
            if (this.valueCase_ == 3) {
                result.value_ = this.value_;
            }
            if (this.valueCase_ == 4) {
                result.value_ = this.value_;
            }
            if (this.valueCase_ == 5) {
                if (this.distributionValueBuilder_ == null) {
                    result.value_ = this.value_;
                } else {
                    result.value_ = this.distributionValueBuilder_.build();
                }
            }
            result.valueCase_ = this.valueCase_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof TypedValue) {
                return this.mergeFrom((TypedValue)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(TypedValue other) {
            if (other == TypedValue.getDefaultInstance()) {
                return this;
            }
            switch (other.getValueCase()) {
                case BOOL_VALUE: {
                    this.setBoolValue(other.getBoolValue());
                    break;
                }
                case INT64_VALUE: {
                    this.setInt64Value(other.getInt64Value());
                    break;
                }
                case DOUBLE_VALUE: {
                    this.setDoubleValue(other.getDoubleValue());
                    break;
                }
                case STRING_VALUE: {
                    this.valueCase_ = 4;
                    this.value_ = other.value_;
                    this.onChanged();
                    break;
                }
                case DISTRIBUTION_VALUE: {
                    this.mergeDistributionValue(other.getDistributionValue());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block13: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block13;
                        }
                        case 8: {
                            this.value_ = input.readBool();
                            this.valueCase_ = 1;
                            continue block13;
                        }
                        case 16: {
                            this.value_ = input.readInt64();
                            this.valueCase_ = 2;
                            continue block13;
                        }
                        case 25: {
                            this.value_ = input.readDouble();
                            this.valueCase_ = 3;
                            continue block13;
                        }
                        case 34: {
                            String s = input.readStringRequireUtf8();
                            this.valueCase_ = 4;
                            this.value_ = s;
                            continue block13;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getDistributionValueFieldBuilder().getBuilder(), extensionRegistry);
                            this.valueCase_ = 5;
                            continue block13;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public ValueCase getValueCase() {
            return ValueCase.forNumber(this.valueCase_);
        }

        public Builder clearValue() {
            this.valueCase_ = 0;
            this.value_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasBoolValue() {
            return this.valueCase_ == 1;
        }

        @Override
        public boolean getBoolValue() {
            if (this.valueCase_ == 1) {
                return (Boolean)this.value_;
            }
            return false;
        }

        public Builder setBoolValue(boolean value) {
            this.valueCase_ = 1;
            this.value_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearBoolValue() {
            if (this.valueCase_ == 1) {
                this.valueCase_ = 0;
                this.value_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasInt64Value() {
            return this.valueCase_ == 2;
        }

        @Override
        public long getInt64Value() {
            if (this.valueCase_ == 2) {
                return (Long)this.value_;
            }
            return 0L;
        }

        public Builder setInt64Value(long value) {
            this.valueCase_ = 2;
            this.value_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearInt64Value() {
            if (this.valueCase_ == 2) {
                this.valueCase_ = 0;
                this.value_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasDoubleValue() {
            return this.valueCase_ == 3;
        }

        @Override
        public double getDoubleValue() {
            if (this.valueCase_ == 3) {
                return (Double)this.value_;
            }
            return 0.0;
        }

        public Builder setDoubleValue(double value) {
            this.valueCase_ = 3;
            this.value_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearDoubleValue() {
            if (this.valueCase_ == 3) {
                this.valueCase_ = 0;
                this.value_ = null;
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasStringValue() {
            return this.valueCase_ == 4;
        }

        @Override
        public String getStringValue() {
            Object ref = "";
            if (this.valueCase_ == 4) {
                ref = this.value_;
            }
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                if (this.valueCase_ == 4) {
                    this.value_ = s;
                }
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getStringValueBytes() {
            Object ref = "";
            if (this.valueCase_ == 4) {
                ref = this.value_;
            }
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                if (this.valueCase_ == 4) {
                    this.value_ = b;
                }
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setStringValue(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.valueCase_ = 4;
            this.value_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearStringValue() {
            if (this.valueCase_ == 4) {
                this.valueCase_ = 0;
                this.value_ = null;
                this.onChanged();
            }
            return this;
        }

        public Builder setStringValueBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            TypedValue.checkByteStringIsUtf8((ByteString)value);
            this.valueCase_ = 4;
            this.value_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasDistributionValue() {
            return this.valueCase_ == 5;
        }

        @Override
        public Distribution getDistributionValue() {
            if (this.distributionValueBuilder_ == null) {
                if (this.valueCase_ == 5) {
                    return (Distribution)this.value_;
                }
                return Distribution.getDefaultInstance();
            }
            if (this.valueCase_ == 5) {
                return (Distribution)this.distributionValueBuilder_.getMessage();
            }
            return Distribution.getDefaultInstance();
        }

        public Builder setDistributionValue(Distribution value) {
            if (this.distributionValueBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.value_ = value;
                this.onChanged();
            } else {
                this.distributionValueBuilder_.setMessage((AbstractMessage)value);
            }
            this.valueCase_ = 5;
            return this;
        }

        public Builder setDistributionValue(Distribution.Builder builderForValue) {
            if (this.distributionValueBuilder_ == null) {
                this.value_ = builderForValue.build();
                this.onChanged();
            } else {
                this.distributionValueBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.valueCase_ = 5;
            return this;
        }

        public Builder mergeDistributionValue(Distribution value) {
            if (this.distributionValueBuilder_ == null) {
                this.value_ = this.valueCase_ == 5 && this.value_ != Distribution.getDefaultInstance() ? Distribution.newBuilder((Distribution)((Distribution)this.value_)).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.valueCase_ == 5) {
                this.distributionValueBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.distributionValueBuilder_.setMessage((AbstractMessage)value);
            }
            this.valueCase_ = 5;
            return this;
        }

        public Builder clearDistributionValue() {
            if (this.distributionValueBuilder_ == null) {
                if (this.valueCase_ == 5) {
                    this.valueCase_ = 0;
                    this.value_ = null;
                    this.onChanged();
                }
            } else {
                if (this.valueCase_ == 5) {
                    this.valueCase_ = 0;
                    this.value_ = null;
                }
                this.distributionValueBuilder_.clear();
            }
            return this;
        }

        public Distribution.Builder getDistributionValueBuilder() {
            return (Distribution.Builder)this.getDistributionValueFieldBuilder().getBuilder();
        }

        @Override
        public DistributionOrBuilder getDistributionValueOrBuilder() {
            if (this.valueCase_ == 5 && this.distributionValueBuilder_ != null) {
                return (DistributionOrBuilder)this.distributionValueBuilder_.getMessageOrBuilder();
            }
            if (this.valueCase_ == 5) {
                return (Distribution)this.value_;
            }
            return Distribution.getDefaultInstance();
        }

        private SingleFieldBuilderV3<Distribution, Distribution.Builder, DistributionOrBuilder> getDistributionValueFieldBuilder() {
            if (this.distributionValueBuilder_ == null) {
                if (this.valueCase_ != 5) {
                    this.value_ = Distribution.getDefaultInstance();
                }
                this.distributionValueBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((Distribution)this.value_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.value_ = null;
            }
            this.valueCase_ = 5;
            this.onChanged();
            return this.distributionValueBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum ValueCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        BOOL_VALUE(1),
        INT64_VALUE(2),
        DOUBLE_VALUE(3),
        STRING_VALUE(4),
        DISTRIBUTION_VALUE(5),
        VALUE_NOT_SET(0);

        private final int value;

        private ValueCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static ValueCase valueOf(int value) {
            return ValueCase.forNumber(value);
        }

        public static ValueCase forNumber(int value) {
            switch (value) {
                case 1: {
                    return BOOL_VALUE;
                }
                case 2: {
                    return INT64_VALUE;
                }
                case 3: {
                    return DOUBLE_VALUE;
                }
                case 4: {
                    return STRING_VALUE;
                }
                case 5: {
                    return DISTRIBUTION_VALUE;
                }
                case 0: {
                    return VALUE_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }
}

