/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/service.proto

// Protobuf Java Version: 3.25.4
package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * A Service-Level Indicator (SLI) describes the "performance" of a service. For
 * some services, the SLI is well-defined. In such cases, the SLI can be
 * described easily by referencing the well-known SLI and providing the needed
 * parameters. Alternatively, a "custom" SLI can be defined with a query to the
 * underlying metric store. An SLI is defined to be `good_service /
 * total_service` over any queried time interval. The value of performance
 * always falls into the range `0 &lt;= performance &lt;= 1`. A custom SLI describes
 * how to compute this ratio, whether this is by dividing values from a pair of
 * time series, cutting a `Distribution` into good and bad counts, or counting
 * time windows in which the service complies with a criterion. For separation
 * of concerns, a single Service-Level Indicator measures performance for only
 * one aspect of service quality, such as fraction of successful queries or
 * fast-enough queries.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.ServiceLevelIndicator}
 */
public final class ServiceLevelIndicator extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.ServiceLevelIndicator)
    ServiceLevelIndicatorOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ServiceLevelIndicator.newBuilder() to construct.
  private ServiceLevelIndicator(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServiceLevelIndicator() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServiceLevelIndicator();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.ServiceMonitoringProto
        .internal_static_google_monitoring_v3_ServiceLevelIndicator_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.ServiceMonitoringProto
        .internal_static_google_monitoring_v3_ServiceLevelIndicator_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.ServiceLevelIndicator.class,
            com.google.monitoring.v3.ServiceLevelIndicator.Builder.class);
  }

  private int typeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object type_;

  public enum TypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BASIC_SLI(4),
    REQUEST_BASED(1),
    WINDOWS_BASED(2),
    TYPE_NOT_SET(0);
    private final int value;

    private TypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeCase forNumber(int value) {
      switch (value) {
        case 4:
          return BASIC_SLI;
        case 1:
          return REQUEST_BASED;
        case 2:
          return WINDOWS_BASED;
        case 0:
          return TYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeCase getTypeCase() {
    return TypeCase.forNumber(typeCase_);
  }

  public static final int BASIC_SLI_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Basic SLI on a well-known service type.
   * </pre>
   *
   * <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
   *
   * @return Whether the basicSli field is set.
   */
  @java.lang.Override
  public boolean hasBasicSli() {
    return typeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Basic SLI on a well-known service type.
   * </pre>
   *
   * <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
   *
   * @return The basicSli.
   */
  @java.lang.Override
  public com.google.monitoring.v3.BasicSli getBasicSli() {
    if (typeCase_ == 4) {
      return (com.google.monitoring.v3.BasicSli) type_;
    }
    return com.google.monitoring.v3.BasicSli.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Basic SLI on a well-known service type.
   * </pre>
   *
   * <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.BasicSliOrBuilder getBasicSliOrBuilder() {
    if (typeCase_ == 4) {
      return (com.google.monitoring.v3.BasicSli) type_;
    }
    return com.google.monitoring.v3.BasicSli.getDefaultInstance();
  }

  public static final int REQUEST_BASED_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Request-based SLIs
   * </pre>
   *
   * <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
   *
   * @return Whether the requestBased field is set.
   */
  @java.lang.Override
  public boolean hasRequestBased() {
    return typeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Request-based SLIs
   * </pre>
   *
   * <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
   *
   * @return The requestBased.
   */
  @java.lang.Override
  public com.google.monitoring.v3.RequestBasedSli getRequestBased() {
    if (typeCase_ == 1) {
      return (com.google.monitoring.v3.RequestBasedSli) type_;
    }
    return com.google.monitoring.v3.RequestBasedSli.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Request-based SLIs
   * </pre>
   *
   * <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.RequestBasedSliOrBuilder getRequestBasedOrBuilder() {
    if (typeCase_ == 1) {
      return (com.google.monitoring.v3.RequestBasedSli) type_;
    }
    return com.google.monitoring.v3.RequestBasedSli.getDefaultInstance();
  }

  public static final int WINDOWS_BASED_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Windows-based SLIs
   * </pre>
   *
   * <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
   *
   * @return Whether the windowsBased field is set.
   */
  @java.lang.Override
  public boolean hasWindowsBased() {
    return typeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Windows-based SLIs
   * </pre>
   *
   * <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
   *
   * @return The windowsBased.
   */
  @java.lang.Override
  public com.google.monitoring.v3.WindowsBasedSli getWindowsBased() {
    if (typeCase_ == 2) {
      return (com.google.monitoring.v3.WindowsBasedSli) type_;
    }
    return com.google.monitoring.v3.WindowsBasedSli.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Windows-based SLIs
   * </pre>
   *
   * <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.WindowsBasedSliOrBuilder getWindowsBasedOrBuilder() {
    if (typeCase_ == 2) {
      return (com.google.monitoring.v3.WindowsBasedSli) type_;
    }
    return com.google.monitoring.v3.WindowsBasedSli.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (typeCase_ == 1) {
      output.writeMessage(1, (com.google.monitoring.v3.RequestBasedSli) type_);
    }
    if (typeCase_ == 2) {
      output.writeMessage(2, (com.google.monitoring.v3.WindowsBasedSli) type_);
    }
    if (typeCase_ == 4) {
      output.writeMessage(4, (com.google.monitoring.v3.BasicSli) type_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (typeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.monitoring.v3.RequestBasedSli) type_);
    }
    if (typeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.monitoring.v3.WindowsBasedSli) type_);
    }
    if (typeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.monitoring.v3.BasicSli) type_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.ServiceLevelIndicator)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.ServiceLevelIndicator other =
        (com.google.monitoring.v3.ServiceLevelIndicator) obj;

    if (!getTypeCase().equals(other.getTypeCase())) return false;
    switch (typeCase_) {
      case 4:
        if (!getBasicSli().equals(other.getBasicSli())) return false;
        break;
      case 1:
        if (!getRequestBased().equals(other.getRequestBased())) return false;
        break;
      case 2:
        if (!getWindowsBased().equals(other.getWindowsBased())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (typeCase_) {
      case 4:
        hash = (37 * hash) + BASIC_SLI_FIELD_NUMBER;
        hash = (53 * hash) + getBasicSli().hashCode();
        break;
      case 1:
        hash = (37 * hash) + REQUEST_BASED_FIELD_NUMBER;
        hash = (53 * hash) + getRequestBased().hashCode();
        break;
      case 2:
        hash = (37 * hash) + WINDOWS_BASED_FIELD_NUMBER;
        hash = (53 * hash) + getWindowsBased().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.ServiceLevelIndicator parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ServiceLevelIndicator parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ServiceLevelIndicator parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ServiceLevelIndicator parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ServiceLevelIndicator parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.ServiceLevelIndicator parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.ServiceLevelIndicator parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ServiceLevelIndicator parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.ServiceLevelIndicator parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ServiceLevelIndicator parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.ServiceLevelIndicator parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.ServiceLevelIndicator parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.ServiceLevelIndicator prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Service-Level Indicator (SLI) describes the "performance" of a service. For
   * some services, the SLI is well-defined. In such cases, the SLI can be
   * described easily by referencing the well-known SLI and providing the needed
   * parameters. Alternatively, a "custom" SLI can be defined with a query to the
   * underlying metric store. An SLI is defined to be `good_service /
   * total_service` over any queried time interval. The value of performance
   * always falls into the range `0 &lt;= performance &lt;= 1`. A custom SLI describes
   * how to compute this ratio, whether this is by dividing values from a pair of
   * time series, cutting a `Distribution` into good and bad counts, or counting
   * time windows in which the service complies with a criterion. For separation
   * of concerns, a single Service-Level Indicator measures performance for only
   * one aspect of service quality, such as fraction of successful queries or
   * fast-enough queries.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.ServiceLevelIndicator}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.ServiceLevelIndicator)
      com.google.monitoring.v3.ServiceLevelIndicatorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_ServiceLevelIndicator_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_ServiceLevelIndicator_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.ServiceLevelIndicator.class,
              com.google.monitoring.v3.ServiceLevelIndicator.Builder.class);
    }

    // Construct using com.google.monitoring.v3.ServiceLevelIndicator.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (basicSliBuilder_ != null) {
        basicSliBuilder_.clear();
      }
      if (requestBasedBuilder_ != null) {
        requestBasedBuilder_.clear();
      }
      if (windowsBasedBuilder_ != null) {
        windowsBasedBuilder_.clear();
      }
      typeCase_ = 0;
      type_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.ServiceMonitoringProto
          .internal_static_google_monitoring_v3_ServiceLevelIndicator_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.ServiceLevelIndicator getDefaultInstanceForType() {
      return com.google.monitoring.v3.ServiceLevelIndicator.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.ServiceLevelIndicator build() {
      com.google.monitoring.v3.ServiceLevelIndicator result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.ServiceLevelIndicator buildPartial() {
      com.google.monitoring.v3.ServiceLevelIndicator result =
          new com.google.monitoring.v3.ServiceLevelIndicator(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.monitoring.v3.ServiceLevelIndicator result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.monitoring.v3.ServiceLevelIndicator result) {
      result.typeCase_ = typeCase_;
      result.type_ = this.type_;
      if (typeCase_ == 4 && basicSliBuilder_ != null) {
        result.type_ = basicSliBuilder_.build();
      }
      if (typeCase_ == 1 && requestBasedBuilder_ != null) {
        result.type_ = requestBasedBuilder_.build();
      }
      if (typeCase_ == 2 && windowsBasedBuilder_ != null) {
        result.type_ = windowsBasedBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.ServiceLevelIndicator) {
        return mergeFrom((com.google.monitoring.v3.ServiceLevelIndicator) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.ServiceLevelIndicator other) {
      if (other == com.google.monitoring.v3.ServiceLevelIndicator.getDefaultInstance()) return this;
      switch (other.getTypeCase()) {
        case BASIC_SLI:
          {
            mergeBasicSli(other.getBasicSli());
            break;
          }
        case REQUEST_BASED:
          {
            mergeRequestBased(other.getRequestBased());
            break;
          }
        case WINDOWS_BASED:
          {
            mergeWindowsBased(other.getWindowsBased());
            break;
          }
        case TYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getRequestBasedFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getWindowsBasedFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 2;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getBasicSliFieldBuilder().getBuilder(), extensionRegistry);
                typeCase_ = 4;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeCase_ = 0;
    private java.lang.Object type_;

    public TypeCase getTypeCase() {
      return TypeCase.forNumber(typeCase_);
    }

    public Builder clearType() {
      typeCase_ = 0;
      type_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.BasicSli,
            com.google.monitoring.v3.BasicSli.Builder,
            com.google.monitoring.v3.BasicSliOrBuilder>
        basicSliBuilder_;
    /**
     *
     *
     * <pre>
     * Basic SLI on a well-known service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
     *
     * @return Whether the basicSli field is set.
     */
    @java.lang.Override
    public boolean hasBasicSli() {
      return typeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Basic SLI on a well-known service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
     *
     * @return The basicSli.
     */
    @java.lang.Override
    public com.google.monitoring.v3.BasicSli getBasicSli() {
      if (basicSliBuilder_ == null) {
        if (typeCase_ == 4) {
          return (com.google.monitoring.v3.BasicSli) type_;
        }
        return com.google.monitoring.v3.BasicSli.getDefaultInstance();
      } else {
        if (typeCase_ == 4) {
          return basicSliBuilder_.getMessage();
        }
        return com.google.monitoring.v3.BasicSli.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Basic SLI on a well-known service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
     */
    public Builder setBasicSli(com.google.monitoring.v3.BasicSli value) {
      if (basicSliBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        basicSliBuilder_.setMessage(value);
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Basic SLI on a well-known service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
     */
    public Builder setBasicSli(com.google.monitoring.v3.BasicSli.Builder builderForValue) {
      if (basicSliBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        basicSliBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Basic SLI on a well-known service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
     */
    public Builder mergeBasicSli(com.google.monitoring.v3.BasicSli value) {
      if (basicSliBuilder_ == null) {
        if (typeCase_ == 4 && type_ != com.google.monitoring.v3.BasicSli.getDefaultInstance()) {
          type_ =
              com.google.monitoring.v3.BasicSli.newBuilder(
                      (com.google.monitoring.v3.BasicSli) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 4) {
          basicSliBuilder_.mergeFrom(value);
        } else {
          basicSliBuilder_.setMessage(value);
        }
      }
      typeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Basic SLI on a well-known service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
     */
    public Builder clearBasicSli() {
      if (basicSliBuilder_ == null) {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 4) {
          typeCase_ = 0;
          type_ = null;
        }
        basicSliBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Basic SLI on a well-known service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
     */
    public com.google.monitoring.v3.BasicSli.Builder getBasicSliBuilder() {
      return getBasicSliFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Basic SLI on a well-known service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.BasicSliOrBuilder getBasicSliOrBuilder() {
      if ((typeCase_ == 4) && (basicSliBuilder_ != null)) {
        return basicSliBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 4) {
          return (com.google.monitoring.v3.BasicSli) type_;
        }
        return com.google.monitoring.v3.BasicSli.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Basic SLI on a well-known service type.
     * </pre>
     *
     * <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.BasicSli,
            com.google.monitoring.v3.BasicSli.Builder,
            com.google.monitoring.v3.BasicSliOrBuilder>
        getBasicSliFieldBuilder() {
      if (basicSliBuilder_ == null) {
        if (!(typeCase_ == 4)) {
          type_ = com.google.monitoring.v3.BasicSli.getDefaultInstance();
        }
        basicSliBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.BasicSli,
                com.google.monitoring.v3.BasicSli.Builder,
                com.google.monitoring.v3.BasicSliOrBuilder>(
                (com.google.monitoring.v3.BasicSli) type_, getParentForChildren(), isClean());
        type_ = null;
      }
      typeCase_ = 4;
      onChanged();
      return basicSliBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.RequestBasedSli,
            com.google.monitoring.v3.RequestBasedSli.Builder,
            com.google.monitoring.v3.RequestBasedSliOrBuilder>
        requestBasedBuilder_;
    /**
     *
     *
     * <pre>
     * Request-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
     *
     * @return Whether the requestBased field is set.
     */
    @java.lang.Override
    public boolean hasRequestBased() {
      return typeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Request-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
     *
     * @return The requestBased.
     */
    @java.lang.Override
    public com.google.monitoring.v3.RequestBasedSli getRequestBased() {
      if (requestBasedBuilder_ == null) {
        if (typeCase_ == 1) {
          return (com.google.monitoring.v3.RequestBasedSli) type_;
        }
        return com.google.monitoring.v3.RequestBasedSli.getDefaultInstance();
      } else {
        if (typeCase_ == 1) {
          return requestBasedBuilder_.getMessage();
        }
        return com.google.monitoring.v3.RequestBasedSli.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Request-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
     */
    public Builder setRequestBased(com.google.monitoring.v3.RequestBasedSli value) {
      if (requestBasedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        requestBasedBuilder_.setMessage(value);
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Request-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
     */
    public Builder setRequestBased(
        com.google.monitoring.v3.RequestBasedSli.Builder builderForValue) {
      if (requestBasedBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        requestBasedBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Request-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
     */
    public Builder mergeRequestBased(com.google.monitoring.v3.RequestBasedSli value) {
      if (requestBasedBuilder_ == null) {
        if (typeCase_ == 1
            && type_ != com.google.monitoring.v3.RequestBasedSli.getDefaultInstance()) {
          type_ =
              com.google.monitoring.v3.RequestBasedSli.newBuilder(
                      (com.google.monitoring.v3.RequestBasedSli) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 1) {
          requestBasedBuilder_.mergeFrom(value);
        } else {
          requestBasedBuilder_.setMessage(value);
        }
      }
      typeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Request-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
     */
    public Builder clearRequestBased() {
      if (requestBasedBuilder_ == null) {
        if (typeCase_ == 1) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 1) {
          typeCase_ = 0;
          type_ = null;
        }
        requestBasedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Request-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
     */
    public com.google.monitoring.v3.RequestBasedSli.Builder getRequestBasedBuilder() {
      return getRequestBasedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Request-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.RequestBasedSliOrBuilder getRequestBasedOrBuilder() {
      if ((typeCase_ == 1) && (requestBasedBuilder_ != null)) {
        return requestBasedBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 1) {
          return (com.google.monitoring.v3.RequestBasedSli) type_;
        }
        return com.google.monitoring.v3.RequestBasedSli.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Request-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.RequestBasedSli,
            com.google.monitoring.v3.RequestBasedSli.Builder,
            com.google.monitoring.v3.RequestBasedSliOrBuilder>
        getRequestBasedFieldBuilder() {
      if (requestBasedBuilder_ == null) {
        if (!(typeCase_ == 1)) {
          type_ = com.google.monitoring.v3.RequestBasedSli.getDefaultInstance();
        }
        requestBasedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.RequestBasedSli,
                com.google.monitoring.v3.RequestBasedSli.Builder,
                com.google.monitoring.v3.RequestBasedSliOrBuilder>(
                (com.google.monitoring.v3.RequestBasedSli) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 1;
      onChanged();
      return requestBasedBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.WindowsBasedSli,
            com.google.monitoring.v3.WindowsBasedSli.Builder,
            com.google.monitoring.v3.WindowsBasedSliOrBuilder>
        windowsBasedBuilder_;
    /**
     *
     *
     * <pre>
     * Windows-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
     *
     * @return Whether the windowsBased field is set.
     */
    @java.lang.Override
    public boolean hasWindowsBased() {
      return typeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Windows-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
     *
     * @return The windowsBased.
     */
    @java.lang.Override
    public com.google.monitoring.v3.WindowsBasedSli getWindowsBased() {
      if (windowsBasedBuilder_ == null) {
        if (typeCase_ == 2) {
          return (com.google.monitoring.v3.WindowsBasedSli) type_;
        }
        return com.google.monitoring.v3.WindowsBasedSli.getDefaultInstance();
      } else {
        if (typeCase_ == 2) {
          return windowsBasedBuilder_.getMessage();
        }
        return com.google.monitoring.v3.WindowsBasedSli.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Windows-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
     */
    public Builder setWindowsBased(com.google.monitoring.v3.WindowsBasedSli value) {
      if (windowsBasedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        onChanged();
      } else {
        windowsBasedBuilder_.setMessage(value);
      }
      typeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Windows-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
     */
    public Builder setWindowsBased(
        com.google.monitoring.v3.WindowsBasedSli.Builder builderForValue) {
      if (windowsBasedBuilder_ == null) {
        type_ = builderForValue.build();
        onChanged();
      } else {
        windowsBasedBuilder_.setMessage(builderForValue.build());
      }
      typeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Windows-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
     */
    public Builder mergeWindowsBased(com.google.monitoring.v3.WindowsBasedSli value) {
      if (windowsBasedBuilder_ == null) {
        if (typeCase_ == 2
            && type_ != com.google.monitoring.v3.WindowsBasedSli.getDefaultInstance()) {
          type_ =
              com.google.monitoring.v3.WindowsBasedSli.newBuilder(
                      (com.google.monitoring.v3.WindowsBasedSli) type_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          type_ = value;
        }
        onChanged();
      } else {
        if (typeCase_ == 2) {
          windowsBasedBuilder_.mergeFrom(value);
        } else {
          windowsBasedBuilder_.setMessage(value);
        }
      }
      typeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Windows-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
     */
    public Builder clearWindowsBased() {
      if (windowsBasedBuilder_ == null) {
        if (typeCase_ == 2) {
          typeCase_ = 0;
          type_ = null;
          onChanged();
        }
      } else {
        if (typeCase_ == 2) {
          typeCase_ = 0;
          type_ = null;
        }
        windowsBasedBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Windows-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
     */
    public com.google.monitoring.v3.WindowsBasedSli.Builder getWindowsBasedBuilder() {
      return getWindowsBasedFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Windows-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
     */
    @java.lang.Override
    public com.google.monitoring.v3.WindowsBasedSliOrBuilder getWindowsBasedOrBuilder() {
      if ((typeCase_ == 2) && (windowsBasedBuilder_ != null)) {
        return windowsBasedBuilder_.getMessageOrBuilder();
      } else {
        if (typeCase_ == 2) {
          return (com.google.monitoring.v3.WindowsBasedSli) type_;
        }
        return com.google.monitoring.v3.WindowsBasedSli.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Windows-based SLIs
     * </pre>
     *
     * <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.WindowsBasedSli,
            com.google.monitoring.v3.WindowsBasedSli.Builder,
            com.google.monitoring.v3.WindowsBasedSliOrBuilder>
        getWindowsBasedFieldBuilder() {
      if (windowsBasedBuilder_ == null) {
        if (!(typeCase_ == 2)) {
          type_ = com.google.monitoring.v3.WindowsBasedSli.getDefaultInstance();
        }
        windowsBasedBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.WindowsBasedSli,
                com.google.monitoring.v3.WindowsBasedSli.Builder,
                com.google.monitoring.v3.WindowsBasedSliOrBuilder>(
                (com.google.monitoring.v3.WindowsBasedSli) type_,
                getParentForChildren(),
                isClean());
        type_ = null;
      }
      typeCase_ = 2;
      onChanged();
      return windowsBasedBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.ServiceLevelIndicator)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.ServiceLevelIndicator)
  private static final com.google.monitoring.v3.ServiceLevelIndicator DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.ServiceLevelIndicator();
  }

  public static com.google.monitoring.v3.ServiceLevelIndicator getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServiceLevelIndicator> PARSER =
      new com.google.protobuf.AbstractParser<ServiceLevelIndicator>() {
        @java.lang.Override
        public ServiceLevelIndicator parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServiceLevelIndicator> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServiceLevelIndicator> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.ServiceLevelIndicator getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
