/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AlertPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_ALERT_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/alertPolicies/{alert_policy}");
    private static final PathTemplate ORGANIZATION_ALERT_POLICY = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/alertPolicies/{alert_policy}");
    private static final PathTemplate FOLDER_ALERT_POLICY = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/alertPolicies/{alert_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String alertPolicy;
    private final String organization;
    private final String folder;

    @Deprecated
    protected AlertPolicyName() {
        this.project = null;
        this.alertPolicy = null;
        this.organization = null;
        this.folder = null;
    }

    private AlertPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.alertPolicy = (String)Preconditions.checkNotNull((Object)builder.getAlertPolicy());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_ALERT_POLICY;
    }

    private AlertPolicyName(OrganizationAlertPolicyBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.alertPolicy = (String)Preconditions.checkNotNull((Object)builder.getAlertPolicy());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_ALERT_POLICY;
    }

    private AlertPolicyName(FolderAlertPolicyBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.alertPolicy = (String)Preconditions.checkNotNull((Object)builder.getAlertPolicy());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_ALERT_POLICY;
    }

    public String getProject() {
        return this.project;
    }

    public String getAlertPolicy() {
        return this.alertPolicy;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectAlertPolicyBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationAlertPolicyBuilder newOrganizationAlertPolicyBuilder() {
        return new OrganizationAlertPolicyBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderAlertPolicyBuilder newFolderAlertPolicyBuilder() {
        return new FolderAlertPolicyBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AlertPolicyName of(String project, String alertPolicy) {
        return AlertPolicyName.newBuilder().setProject(project).setAlertPolicy(alertPolicy).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static AlertPolicyName ofProjectAlertPolicyName(String project, String alertPolicy) {
        return AlertPolicyName.newBuilder().setProject(project).setAlertPolicy(alertPolicy).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static AlertPolicyName ofOrganizationAlertPolicyName(String organization, String alertPolicy) {
        return AlertPolicyName.newOrganizationAlertPolicyBuilder().setOrganization(organization).setAlertPolicy(alertPolicy).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static AlertPolicyName ofFolderAlertPolicyName(String folder, String alertPolicy) {
        return AlertPolicyName.newFolderAlertPolicyBuilder().setFolder(folder).setAlertPolicy(alertPolicy).build();
    }

    public static String format(String project, String alertPolicy) {
        return AlertPolicyName.newBuilder().setProject(project).setAlertPolicy(alertPolicy).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectAlertPolicyName(String project, String alertPolicy) {
        return AlertPolicyName.newBuilder().setProject(project).setAlertPolicy(alertPolicy).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationAlertPolicyName(String organization, String alertPolicy) {
        return AlertPolicyName.newOrganizationAlertPolicyBuilder().setOrganization(organization).setAlertPolicy(alertPolicy).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderAlertPolicyName(String folder, String alertPolicy) {
        return AlertPolicyName.newFolderAlertPolicyBuilder().setFolder(folder).setAlertPolicy(alertPolicy).build().toString();
    }

    public static AlertPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_ALERT_POLICY.matches(formattedString)) {
            Map matchMap = PROJECT_ALERT_POLICY.match(formattedString);
            return AlertPolicyName.ofProjectAlertPolicyName((String)matchMap.get("project"), (String)matchMap.get("alert_policy"));
        }
        if (ORGANIZATION_ALERT_POLICY.matches(formattedString)) {
            Map matchMap = ORGANIZATION_ALERT_POLICY.match(formattedString);
            return AlertPolicyName.ofOrganizationAlertPolicyName((String)matchMap.get("organization"), (String)matchMap.get("alert_policy"));
        }
        if (FOLDER_ALERT_POLICY.matches(formattedString)) {
            Map matchMap = FOLDER_ALERT_POLICY.match(formattedString);
            return AlertPolicyName.ofFolderAlertPolicyName((String)matchMap.get("folder"), (String)matchMap.get("alert_policy"));
        }
        throw new ValidationException("AlertPolicyName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<AlertPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<AlertPolicyName> list = new ArrayList<AlertPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AlertPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AlertPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AlertPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_ALERT_POLICY.matches(formattedString) || ORGANIZATION_ALERT_POLICY.matches(formattedString) || FOLDER_ALERT_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AlertPolicyName alertPolicyName = this;
            synchronized (alertPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.alertPolicy != null) {
                        fieldMapBuilder.put((Object)"alert_policy", (Object)this.alertPolicy);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AlertPolicyName that = (AlertPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.alertPolicy, that.alertPolicy) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.alertPolicy);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.folder);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderAlertPolicyBuilder {
        private String folder;
        private String alertPolicy;

        protected FolderAlertPolicyBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getAlertPolicy() {
            return this.alertPolicy;
        }

        public FolderAlertPolicyBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderAlertPolicyBuilder setAlertPolicy(String alertPolicy) {
            this.alertPolicy = alertPolicy;
            return this;
        }

        public AlertPolicyName build() {
            return new AlertPolicyName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationAlertPolicyBuilder {
        private String organization;
        private String alertPolicy;

        protected OrganizationAlertPolicyBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getAlertPolicy() {
            return this.alertPolicy;
        }

        public OrganizationAlertPolicyBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationAlertPolicyBuilder setAlertPolicy(String alertPolicy) {
            this.alertPolicy = alertPolicy;
            return this;
        }

        public AlertPolicyName build() {
            return new AlertPolicyName(this);
        }
    }

    public static class Builder {
        private String project;
        private String alertPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getAlertPolicy() {
            return this.alertPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setAlertPolicy(String alertPolicy) {
            this.alertPolicy = alertPolicy;
            return this;
        }

        private Builder(AlertPolicyName alertPolicyName) {
            Preconditions.checkArgument((boolean)Objects.equals(alertPolicyName.pathTemplate, PROJECT_ALERT_POLICY), (Object)"toBuilder is only supported when AlertPolicyName has the pattern of projects/{project}/alertPolicies/{alert_policy}");
            this.project = alertPolicyName.project;
            this.alertPolicy = alertPolicyName.alertPolicy;
        }

        public AlertPolicyName build() {
            return new AlertPolicyName(this);
        }
    }
}

