/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/monitoring/v3/snooze_service.proto

package com.google.monitoring.v3;

/**
 *
 *
 * <pre>
 * The message definition for updating a `Snooze`. The field, `snooze.name`
 * identifies the `Snooze` to be updated. The remainder of `snooze` gives the
 * content the `Snooze` in question will be assigned.
 *
 * What fields can be updated depends on the start time and end time of the
 * `Snooze`.
 *
 *   * end time is in the past: These `Snooze`s are considered
 *     read-only and cannot be updated.
 *   * start time is in the past and end time is in the future: `display_name`
 *     and `interval.end_time` can be updated.
 *   * start time is in the future: `display_name`, `interval.start_time` and
 *     `interval.end_time` can be updated.
 * </pre>
 *
 * Protobuf type {@code google.monitoring.v3.UpdateSnoozeRequest}
 */
public final class UpdateSnoozeRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.monitoring.v3.UpdateSnoozeRequest)
    UpdateSnoozeRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateSnoozeRequest.newBuilder() to construct.
  private UpdateSnoozeRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateSnoozeRequest() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateSnoozeRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.monitoring.v3.SnoozeServiceProto
        .internal_static_google_monitoring_v3_UpdateSnoozeRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.monitoring.v3.SnoozeServiceProto
        .internal_static_google_monitoring_v3_UpdateSnoozeRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.monitoring.v3.UpdateSnoozeRequest.class,
            com.google.monitoring.v3.UpdateSnoozeRequest.Builder.class);
  }

  public static final int SNOOZE_FIELD_NUMBER = 1;
  private com.google.monitoring.v3.Snooze snooze_;
  /**
   *
   *
   * <pre>
   * Required. The `Snooze` to update. Must have the name field present.
   * </pre>
   *
   * <code>.google.monitoring.v3.Snooze snooze = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the snooze field is set.
   */
  @java.lang.Override
  public boolean hasSnooze() {
    return snooze_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The `Snooze` to update. Must have the name field present.
   * </pre>
   *
   * <code>.google.monitoring.v3.Snooze snooze = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The snooze.
   */
  @java.lang.Override
  public com.google.monitoring.v3.Snooze getSnooze() {
    return snooze_ == null ? com.google.monitoring.v3.Snooze.getDefaultInstance() : snooze_;
  }
  /**
   *
   *
   * <pre>
   * Required. The `Snooze` to update. Must have the name field present.
   * </pre>
   *
   * <code>.google.monitoring.v3.Snooze snooze = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.monitoring.v3.SnoozeOrBuilder getSnoozeOrBuilder() {
    return snooze_ == null ? com.google.monitoring.v3.Snooze.getDefaultInstance() : snooze_;
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 2;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Required. The fields to update.
   *
   * For each field listed in `update_mask`:
   *
   *   * If the `Snooze` object supplied in the `UpdateSnoozeRequest` has a
   *     value for that field, the value of the field in the existing `Snooze`
   *     will be set to the value of the field in the supplied `Snooze`.
   *   * If the field does not have a value in the supplied `Snooze`, the field
   *     in the existing `Snooze` is set to its default value.
   *
   * Fields not listed retain their existing value.
   *
   * The following are the field names that are accepted in `update_mask`:
   *
   *   * `display_name`
   *   * `interval.start_time`
   *   * `interval.end_time`
   *
   * That said, the start time and end time of the `Snooze` determines which
   * fields can legally be updated. Before attempting an update, users should
   * consult the documentation for `UpdateSnoozeRequest`, which talks about
   * which fields can be updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return updateMask_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The fields to update.
   *
   * For each field listed in `update_mask`:
   *
   *   * If the `Snooze` object supplied in the `UpdateSnoozeRequest` has a
   *     value for that field, the value of the field in the existing `Snooze`
   *     will be set to the value of the field in the supplied `Snooze`.
   *   * If the field does not have a value in the supplied `Snooze`, the field
   *     in the existing `Snooze` is set to its default value.
   *
   * Fields not listed retain their existing value.
   *
   * The following are the field names that are accepted in `update_mask`:
   *
   *   * `display_name`
   *   * `interval.start_time`
   *   * `interval.end_time`
   *
   * That said, the start time and end time of the `Snooze` determines which
   * fields can legally be updated. Before attempting an update, users should
   * consult the documentation for `UpdateSnoozeRequest`, which talks about
   * which fields can be updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Required. The fields to update.
   *
   * For each field listed in `update_mask`:
   *
   *   * If the `Snooze` object supplied in the `UpdateSnoozeRequest` has a
   *     value for that field, the value of the field in the existing `Snooze`
   *     will be set to the value of the field in the supplied `Snooze`.
   *   * If the field does not have a value in the supplied `Snooze`, the field
   *     in the existing `Snooze` is set to its default value.
   *
   * Fields not listed retain their existing value.
   *
   * The following are the field names that are accepted in `update_mask`:
   *
   *   * `display_name`
   *   * `interval.start_time`
   *   * `interval.end_time`
   *
   * That said, the start time and end time of the `Snooze` determines which
   * fields can legally be updated. Before attempting an update, users should
   * consult the documentation for `UpdateSnoozeRequest`, which talks about
   * which fields can be updated.
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (snooze_ != null) {
      output.writeMessage(1, getSnooze());
    }
    if (updateMask_ != null) {
      output.writeMessage(2, getUpdateMask());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (snooze_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSnooze());
    }
    if (updateMask_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpdateMask());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.monitoring.v3.UpdateSnoozeRequest)) {
      return super.equals(obj);
    }
    com.google.monitoring.v3.UpdateSnoozeRequest other =
        (com.google.monitoring.v3.UpdateSnoozeRequest) obj;

    if (hasSnooze() != other.hasSnooze()) return false;
    if (hasSnooze()) {
      if (!getSnooze().equals(other.getSnooze())) return false;
    }
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSnooze()) {
      hash = (37 * hash) + SNOOZE_FIELD_NUMBER;
      hash = (53 * hash) + getSnooze().hashCode();
    }
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.monitoring.v3.UpdateSnoozeRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.UpdateSnoozeRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.UpdateSnoozeRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.UpdateSnoozeRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.UpdateSnoozeRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.monitoring.v3.UpdateSnoozeRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.monitoring.v3.UpdateSnoozeRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.UpdateSnoozeRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.UpdateSnoozeRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.UpdateSnoozeRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.monitoring.v3.UpdateSnoozeRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.monitoring.v3.UpdateSnoozeRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.monitoring.v3.UpdateSnoozeRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The message definition for updating a `Snooze`. The field, `snooze.name`
   * identifies the `Snooze` to be updated. The remainder of `snooze` gives the
   * content the `Snooze` in question will be assigned.
   *
   * What fields can be updated depends on the start time and end time of the
   * `Snooze`.
   *
   *   * end time is in the past: These `Snooze`s are considered
   *     read-only and cannot be updated.
   *   * start time is in the past and end time is in the future: `display_name`
   *     and `interval.end_time` can be updated.
   *   * start time is in the future: `display_name`, `interval.start_time` and
   *     `interval.end_time` can be updated.
   * </pre>
   *
   * Protobuf type {@code google.monitoring.v3.UpdateSnoozeRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.monitoring.v3.UpdateSnoozeRequest)
      com.google.monitoring.v3.UpdateSnoozeRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.monitoring.v3.SnoozeServiceProto
          .internal_static_google_monitoring_v3_UpdateSnoozeRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.monitoring.v3.SnoozeServiceProto
          .internal_static_google_monitoring_v3_UpdateSnoozeRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.monitoring.v3.UpdateSnoozeRequest.class,
              com.google.monitoring.v3.UpdateSnoozeRequest.Builder.class);
    }

    // Construct using com.google.monitoring.v3.UpdateSnoozeRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      snooze_ = null;
      if (snoozeBuilder_ != null) {
        snoozeBuilder_.dispose();
        snoozeBuilder_ = null;
      }
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.monitoring.v3.SnoozeServiceProto
          .internal_static_google_monitoring_v3_UpdateSnoozeRequest_descriptor;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UpdateSnoozeRequest getDefaultInstanceForType() {
      return com.google.monitoring.v3.UpdateSnoozeRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.monitoring.v3.UpdateSnoozeRequest build() {
      com.google.monitoring.v3.UpdateSnoozeRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.monitoring.v3.UpdateSnoozeRequest buildPartial() {
      com.google.monitoring.v3.UpdateSnoozeRequest result =
          new com.google.monitoring.v3.UpdateSnoozeRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.monitoring.v3.UpdateSnoozeRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.snooze_ = snoozeBuilder_ == null ? snooze_ : snoozeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.monitoring.v3.UpdateSnoozeRequest) {
        return mergeFrom((com.google.monitoring.v3.UpdateSnoozeRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.monitoring.v3.UpdateSnoozeRequest other) {
      if (other == com.google.monitoring.v3.UpdateSnoozeRequest.getDefaultInstance()) return this;
      if (other.hasSnooze()) {
        mergeSnooze(other.getSnooze());
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getSnoozeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.monitoring.v3.Snooze snooze_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Snooze,
            com.google.monitoring.v3.Snooze.Builder,
            com.google.monitoring.v3.SnoozeOrBuilder>
        snoozeBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` to update. Must have the name field present.
     * </pre>
     *
     * <code>.google.monitoring.v3.Snooze snooze = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the snooze field is set.
     */
    public boolean hasSnooze() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` to update. Must have the name field present.
     * </pre>
     *
     * <code>.google.monitoring.v3.Snooze snooze = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The snooze.
     */
    public com.google.monitoring.v3.Snooze getSnooze() {
      if (snoozeBuilder_ == null) {
        return snooze_ == null ? com.google.monitoring.v3.Snooze.getDefaultInstance() : snooze_;
      } else {
        return snoozeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` to update. Must have the name field present.
     * </pre>
     *
     * <code>.google.monitoring.v3.Snooze snooze = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSnooze(com.google.monitoring.v3.Snooze value) {
      if (snoozeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        snooze_ = value;
      } else {
        snoozeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` to update. Must have the name field present.
     * </pre>
     *
     * <code>.google.monitoring.v3.Snooze snooze = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setSnooze(com.google.monitoring.v3.Snooze.Builder builderForValue) {
      if (snoozeBuilder_ == null) {
        snooze_ = builderForValue.build();
      } else {
        snoozeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` to update. Must have the name field present.
     * </pre>
     *
     * <code>.google.monitoring.v3.Snooze snooze = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeSnooze(com.google.monitoring.v3.Snooze value) {
      if (snoozeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && snooze_ != null
            && snooze_ != com.google.monitoring.v3.Snooze.getDefaultInstance()) {
          getSnoozeBuilder().mergeFrom(value);
        } else {
          snooze_ = value;
        }
      } else {
        snoozeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` to update. Must have the name field present.
     * </pre>
     *
     * <code>.google.monitoring.v3.Snooze snooze = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearSnooze() {
      bitField0_ = (bitField0_ & ~0x00000001);
      snooze_ = null;
      if (snoozeBuilder_ != null) {
        snoozeBuilder_.dispose();
        snoozeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` to update. Must have the name field present.
     * </pre>
     *
     * <code>.google.monitoring.v3.Snooze snooze = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.monitoring.v3.Snooze.Builder getSnoozeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getSnoozeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` to update. Must have the name field present.
     * </pre>
     *
     * <code>.google.monitoring.v3.Snooze snooze = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.monitoring.v3.SnoozeOrBuilder getSnoozeOrBuilder() {
      if (snoozeBuilder_ != null) {
        return snoozeBuilder_.getMessageOrBuilder();
      } else {
        return snooze_ == null ? com.google.monitoring.v3.Snooze.getDefaultInstance() : snooze_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `Snooze` to update. Must have the name field present.
     * </pre>
     *
     * <code>.google.monitoring.v3.Snooze snooze = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.monitoring.v3.Snooze,
            com.google.monitoring.v3.Snooze.Builder,
            com.google.monitoring.v3.SnoozeOrBuilder>
        getSnoozeFieldBuilder() {
      if (snoozeBuilder_ == null) {
        snoozeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.monitoring.v3.Snooze,
                com.google.monitoring.v3.Snooze.Builder,
                com.google.monitoring.v3.SnoozeOrBuilder>(
                getSnooze(), getParentForChildren(), isClean());
        snooze_ = null;
      }
      return snoozeBuilder_;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The fields to update.
     *
     * For each field listed in `update_mask`:
     *
     *   * If the `Snooze` object supplied in the `UpdateSnoozeRequest` has a
     *     value for that field, the value of the field in the existing `Snooze`
     *     will be set to the value of the field in the supplied `Snooze`.
     *   * If the field does not have a value in the supplied `Snooze`, the field
     *     in the existing `Snooze` is set to its default value.
     *
     * Fields not listed retain their existing value.
     *
     * The following are the field names that are accepted in `update_mask`:
     *
     *   * `display_name`
     *   * `interval.start_time`
     *   * `interval.end_time`
     *
     * That said, the start time and end time of the `Snooze` determines which
     * fields can legally be updated. Before attempting an update, users should
     * consult the documentation for `UpdateSnoozeRequest`, which talks about
     * which fields can be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The fields to update.
     *
     * For each field listed in `update_mask`:
     *
     *   * If the `Snooze` object supplied in the `UpdateSnoozeRequest` has a
     *     value for that field, the value of the field in the existing `Snooze`
     *     will be set to the value of the field in the supplied `Snooze`.
     *   * If the field does not have a value in the supplied `Snooze`, the field
     *     in the existing `Snooze` is set to its default value.
     *
     * Fields not listed retain their existing value.
     *
     * The following are the field names that are accepted in `update_mask`:
     *
     *   * `display_name`
     *   * `interval.start_time`
     *   * `interval.end_time`
     *
     * That said, the start time and end time of the `Snooze` determines which
     * fields can legally be updated. Before attempting an update, users should
     * consult the documentation for `UpdateSnoozeRequest`, which talks about
     * which fields can be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fields to update.
     *
     * For each field listed in `update_mask`:
     *
     *   * If the `Snooze` object supplied in the `UpdateSnoozeRequest` has a
     *     value for that field, the value of the field in the existing `Snooze`
     *     will be set to the value of the field in the supplied `Snooze`.
     *   * If the field does not have a value in the supplied `Snooze`, the field
     *     in the existing `Snooze` is set to its default value.
     *
     * Fields not listed retain their existing value.
     *
     * The following are the field names that are accepted in `update_mask`:
     *
     *   * `display_name`
     *   * `interval.start_time`
     *   * `interval.end_time`
     *
     * That said, the start time and end time of the `Snooze` determines which
     * fields can legally be updated. Before attempting an update, users should
     * consult the documentation for `UpdateSnoozeRequest`, which talks about
     * which fields can be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fields to update.
     *
     * For each field listed in `update_mask`:
     *
     *   * If the `Snooze` object supplied in the `UpdateSnoozeRequest` has a
     *     value for that field, the value of the field in the existing `Snooze`
     *     will be set to the value of the field in the supplied `Snooze`.
     *   * If the field does not have a value in the supplied `Snooze`, the field
     *     in the existing `Snooze` is set to its default value.
     *
     * Fields not listed retain their existing value.
     *
     * The following are the field names that are accepted in `update_mask`:
     *
     *   * `display_name`
     *   * `interval.start_time`
     *   * `interval.end_time`
     *
     * That said, the start time and end time of the `Snooze` determines which
     * fields can legally be updated. Before attempting an update, users should
     * consult the documentation for `UpdateSnoozeRequest`, which talks about
     * which fields can be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fields to update.
     *
     * For each field listed in `update_mask`:
     *
     *   * If the `Snooze` object supplied in the `UpdateSnoozeRequest` has a
     *     value for that field, the value of the field in the existing `Snooze`
     *     will be set to the value of the field in the supplied `Snooze`.
     *   * If the field does not have a value in the supplied `Snooze`, the field
     *     in the existing `Snooze` is set to its default value.
     *
     * Fields not listed retain their existing value.
     *
     * The following are the field names that are accepted in `update_mask`:
     *
     *   * `display_name`
     *   * `interval.start_time`
     *   * `interval.end_time`
     *
     * That said, the start time and end time of the `Snooze` determines which
     * fields can legally be updated. Before attempting an update, users should
     * consult the documentation for `UpdateSnoozeRequest`, which talks about
     * which fields can be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fields to update.
     *
     * For each field listed in `update_mask`:
     *
     *   * If the `Snooze` object supplied in the `UpdateSnoozeRequest` has a
     *     value for that field, the value of the field in the existing `Snooze`
     *     will be set to the value of the field in the supplied `Snooze`.
     *   * If the field does not have a value in the supplied `Snooze`, the field
     *     in the existing `Snooze` is set to its default value.
     *
     * Fields not listed retain their existing value.
     *
     * The following are the field names that are accepted in `update_mask`:
     *
     *   * `display_name`
     *   * `interval.start_time`
     *   * `interval.end_time`
     *
     * That said, the start time and end time of the `Snooze` determines which
     * fields can legally be updated. Before attempting an update, users should
     * consult the documentation for `UpdateSnoozeRequest`, which talks about
     * which fields can be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000002);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The fields to update.
     *
     * For each field listed in `update_mask`:
     *
     *   * If the `Snooze` object supplied in the `UpdateSnoozeRequest` has a
     *     value for that field, the value of the field in the existing `Snooze`
     *     will be set to the value of the field in the supplied `Snooze`.
     *   * If the field does not have a value in the supplied `Snooze`, the field
     *     in the existing `Snooze` is set to its default value.
     *
     * Fields not listed retain their existing value.
     *
     * The following are the field names that are accepted in `update_mask`:
     *
     *   * `display_name`
     *   * `interval.start_time`
     *   * `interval.end_time`
     *
     * That said, the start time and end time of the `Snooze` determines which
     * fields can legally be updated. Before attempting an update, users should
     * consult the documentation for `UpdateSnoozeRequest`, which talks about
     * which fields can be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The fields to update.
     *
     * For each field listed in `update_mask`:
     *
     *   * If the `Snooze` object supplied in the `UpdateSnoozeRequest` has a
     *     value for that field, the value of the field in the existing `Snooze`
     *     will be set to the value of the field in the supplied `Snooze`.
     *   * If the field does not have a value in the supplied `Snooze`, the field
     *     in the existing `Snooze` is set to its default value.
     *
     * Fields not listed retain their existing value.
     *
     * The following are the field names that are accepted in `update_mask`:
     *
     *   * `display_name`
     *   * `interval.start_time`
     *   * `interval.end_time`
     *
     * That said, the start time and end time of the `Snooze` determines which
     * fields can legally be updated. Before attempting an update, users should
     * consult the documentation for `UpdateSnoozeRequest`, which talks about
     * which fields can be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The fields to update.
     *
     * For each field listed in `update_mask`:
     *
     *   * If the `Snooze` object supplied in the `UpdateSnoozeRequest` has a
     *     value for that field, the value of the field in the existing `Snooze`
     *     will be set to the value of the field in the supplied `Snooze`.
     *   * If the field does not have a value in the supplied `Snooze`, the field
     *     in the existing `Snooze` is set to its default value.
     *
     * Fields not listed retain their existing value.
     *
     * The following are the field names that are accepted in `update_mask`:
     *
     *   * `display_name`
     *   * `interval.start_time`
     *   * `interval.end_time`
     *
     * That said, the start time and end time of the `Snooze` determines which
     * fields can legally be updated. Before attempting an update, users should
     * consult the documentation for `UpdateSnoozeRequest`, which talks about
     * which fields can be updated.
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.monitoring.v3.UpdateSnoozeRequest)
  }

  // @@protoc_insertion_point(class_scope:google.monitoring.v3.UpdateSnoozeRequest)
  private static final com.google.monitoring.v3.UpdateSnoozeRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.monitoring.v3.UpdateSnoozeRequest();
  }

  public static com.google.monitoring.v3.UpdateSnoozeRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateSnoozeRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpdateSnoozeRequest>() {
        @java.lang.Override
        public UpdateSnoozeRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateSnoozeRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateSnoozeRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.monitoring.v3.UpdateSnoozeRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
