/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.v3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SnoozeName
implements ResourceName {
    private static final PathTemplate PROJECT_SNOOZE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/snoozes/{snooze}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String snooze;

    @Deprecated
    protected SnoozeName() {
        this.project = null;
        this.snooze = null;
    }

    private SnoozeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.snooze = (String)Preconditions.checkNotNull((Object)builder.getSnooze());
    }

    public String getProject() {
        return this.project;
    }

    public String getSnooze() {
        return this.snooze;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SnoozeName of(String project, String snooze) {
        return SnoozeName.newBuilder().setProject(project).setSnooze(snooze).build();
    }

    public static String format(String project, String snooze) {
        return SnoozeName.newBuilder().setProject(project).setSnooze(snooze).build().toString();
    }

    public static SnoozeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_SNOOZE.validatedMatch(formattedString, "SnoozeName.parse: formattedString not in valid format");
        return SnoozeName.of((String)matchMap.get("project"), (String)matchMap.get("snooze"));
    }

    public static List<SnoozeName> parseList(List<String> formattedStrings) {
        ArrayList<SnoozeName> list = new ArrayList<SnoozeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SnoozeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SnoozeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SnoozeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SNOOZE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SnoozeName snoozeName = this;
            synchronized (snoozeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.snooze != null) {
                        fieldMapBuilder.put((Object)"snooze", (Object)this.snooze);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_SNOOZE.instantiate(new String[]{"project", this.project, "snooze", this.snooze});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SnoozeName that = (SnoozeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.snooze, that.snooze);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.snooze);
    }

    public static class Builder {
        private String project;
        private String snooze;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getSnooze() {
            return this.snooze;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setSnooze(String snooze) {
            this.snooze = snooze;
            return this;
        }

        private Builder(SnoozeName snoozeName) {
            this.project = snoozeName.project;
            this.snooze = snoozeName.snooze;
        }

        public SnoozeName build() {
            return new SnoozeName(this);
        }
    }
}

