/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v2beta/functions.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.functions.v2beta;

/**
 *
 *
 * <pre>
 * Describes the Service being deployed.
 * Currently Supported : Cloud Run (fully managed).
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v2beta.ServiceConfig}
 */
public final class ServiceConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v2beta.ServiceConfig)
    ServiceConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ServiceConfig.newBuilder() to construct.
  private ServiceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServiceConfig() {
    service_ = "";
    availableMemory_ = "";
    availableCpu_ = "";
    vpcConnector_ = "";
    vpcConnectorEgressSettings_ = 0;
    ingressSettings_ = 0;
    uri_ = "";
    serviceAccountEmail_ = "";
    secretEnvironmentVariables_ = java.util.Collections.emptyList();
    secretVolumes_ = java.util.Collections.emptyList();
    revision_ = "";
    securityLevel_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServiceConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v2beta.FunctionsProto
        .internal_static_google_cloud_functions_v2beta_ServiceConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetEnvironmentVariables();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v2beta.FunctionsProto
        .internal_static_google_cloud_functions_v2beta_ServiceConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v2beta.ServiceConfig.class,
            com.google.cloud.functions.v2beta.ServiceConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Available egress settings.
   *
   * This controls what traffic is diverted through the VPC Access Connector
   * resource. By default PRIVATE_RANGES_ONLY will be used.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings}
   */
  public enum VpcConnectorEgressSettings implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED = 0;</code>
     */
    VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use the VPC Access Connector only for private IP space from RFC1918.
     * </pre>
     *
     * <code>PRIVATE_RANGES_ONLY = 1;</code>
     */
    PRIVATE_RANGES_ONLY(1),
    /**
     *
     *
     * <pre>
     * Force the use of VPC Access Connector for all egress traffic from the
     * function.
     * </pre>
     *
     * <code>ALL_TRAFFIC = 2;</code>
     */
    ALL_TRAFFIC(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED = 0;</code>
     */
    public static final int VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use the VPC Access Connector only for private IP space from RFC1918.
     * </pre>
     *
     * <code>PRIVATE_RANGES_ONLY = 1;</code>
     */
    public static final int PRIVATE_RANGES_ONLY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Force the use of VPC Access Connector for all egress traffic from the
     * function.
     * </pre>
     *
     * <code>ALL_TRAFFIC = 2;</code>
     */
    public static final int ALL_TRAFFIC_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static VpcConnectorEgressSettings valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static VpcConnectorEgressSettings forNumber(int value) {
      switch (value) {
        case 0:
          return VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED;
        case 1:
          return PRIVATE_RANGES_ONLY;
        case 2:
          return ALL_TRAFFIC;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<VpcConnectorEgressSettings>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<VpcConnectorEgressSettings>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<VpcConnectorEgressSettings>() {
              public VpcConnectorEgressSettings findValueByNumber(int number) {
                return VpcConnectorEgressSettings.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v2beta.ServiceConfig.getDescriptor().getEnumTypes().get(0);
    }

    private static final VpcConnectorEgressSettings[] VALUES = values();

    public static VpcConnectorEgressSettings valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private VpcConnectorEgressSettings(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings)
  }

  /**
   *
   *
   * <pre>
   * Available ingress settings.
   *
   * This controls what traffic can reach the function.
   *
   * If unspecified, ALLOW_ALL will be used.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v2beta.ServiceConfig.IngressSettings}
   */
  public enum IngressSettings implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>INGRESS_SETTINGS_UNSPECIFIED = 0;</code>
     */
    INGRESS_SETTINGS_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from public and private sources.
     * </pre>
     *
     * <code>ALLOW_ALL = 1;</code>
     */
    ALLOW_ALL(1),
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from only private VPC sources.
     * </pre>
     *
     * <code>ALLOW_INTERNAL_ONLY = 2;</code>
     */
    ALLOW_INTERNAL_ONLY(2),
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from private VPC sources and through GCLB.
     * </pre>
     *
     * <code>ALLOW_INTERNAL_AND_GCLB = 3;</code>
     */
    ALLOW_INTERNAL_AND_GCLB(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>INGRESS_SETTINGS_UNSPECIFIED = 0;</code>
     */
    public static final int INGRESS_SETTINGS_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from public and private sources.
     * </pre>
     *
     * <code>ALLOW_ALL = 1;</code>
     */
    public static final int ALLOW_ALL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from only private VPC sources.
     * </pre>
     *
     * <code>ALLOW_INTERNAL_ONLY = 2;</code>
     */
    public static final int ALLOW_INTERNAL_ONLY_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Allow HTTP traffic from private VPC sources and through GCLB.
     * </pre>
     *
     * <code>ALLOW_INTERNAL_AND_GCLB = 3;</code>
     */
    public static final int ALLOW_INTERNAL_AND_GCLB_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IngressSettings valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IngressSettings forNumber(int value) {
      switch (value) {
        case 0:
          return INGRESS_SETTINGS_UNSPECIFIED;
        case 1:
          return ALLOW_ALL;
        case 2:
          return ALLOW_INTERNAL_ONLY;
        case 3:
          return ALLOW_INTERNAL_AND_GCLB;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IngressSettings> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IngressSettings>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<IngressSettings>() {
              public IngressSettings findValueByNumber(int number) {
                return IngressSettings.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v2beta.ServiceConfig.getDescriptor().getEnumTypes().get(1);
    }

    private static final IngressSettings[] VALUES = values();

    public static IngressSettings valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IngressSettings(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v2beta.ServiceConfig.IngressSettings)
  }

  /**
   *
   *
   * <pre>
   * Available security level settings.
   *
   * This enforces security protocol on function URL.
   *
   * Security level is only configurable for 1st Gen functions, If unspecified,
   * SECURE_OPTIONAL will be used. 2nd Gen functions are SECURE_ALWAYS ONLY.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v2beta.ServiceConfig.SecurityLevel}
   */
  public enum SecurityLevel implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SECURITY_LEVEL_UNSPECIFIED = 0;</code>
     */
    SECURITY_LEVEL_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Requests for a URL that match this handler that do not use HTTPS are
     * automatically redirected to the HTTPS URL with the same path. Query
     * parameters are reserved for the redirect.
     * </pre>
     *
     * <code>SECURE_ALWAYS = 1;</code>
     */
    SECURE_ALWAYS(1),
    /**
     *
     *
     * <pre>
     * Both HTTP and HTTPS requests with URLs that match the handler succeed
     * without redirects. The application can examine the request to determine
     * which protocol was used and respond accordingly.
     * </pre>
     *
     * <code>SECURE_OPTIONAL = 2;</code>
     */
    SECURE_OPTIONAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified.
     * </pre>
     *
     * <code>SECURITY_LEVEL_UNSPECIFIED = 0;</code>
     */
    public static final int SECURITY_LEVEL_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Requests for a URL that match this handler that do not use HTTPS are
     * automatically redirected to the HTTPS URL with the same path. Query
     * parameters are reserved for the redirect.
     * </pre>
     *
     * <code>SECURE_ALWAYS = 1;</code>
     */
    public static final int SECURE_ALWAYS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Both HTTP and HTTPS requests with URLs that match the handler succeed
     * without redirects. The application can examine the request to determine
     * which protocol was used and respond accordingly.
     * </pre>
     *
     * <code>SECURE_OPTIONAL = 2;</code>
     */
    public static final int SECURE_OPTIONAL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SecurityLevel valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SecurityLevel forNumber(int value) {
      switch (value) {
        case 0:
          return SECURITY_LEVEL_UNSPECIFIED;
        case 1:
          return SECURE_ALWAYS;
        case 2:
          return SECURE_OPTIONAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SecurityLevel> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SecurityLevel> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SecurityLevel>() {
          public SecurityLevel findValueByNumber(int number) {
            return SecurityLevel.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v2beta.ServiceConfig.getDescriptor().getEnumTypes().get(2);
    }

    private static final SecurityLevel[] VALUES = values();

    public static SecurityLevel valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SecurityLevel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v2beta.ServiceConfig.SecurityLevel)
  }

  public static final int SERVICE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object service_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the service associated with a Function.
   * The format of this field is
   * `projects/{project}/locations/{region}/services/{service}`
   * </pre>
   *
   * <code>
   * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The service.
   */
  @java.lang.Override
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the service associated with a Function.
   * The format of this field is
   * `projects/{project}/locations/{region}/services/{service}`
   * </pre>
   *
   * <code>
   * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for service.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIMEOUT_SECONDS_FIELD_NUMBER = 2;
  private int timeoutSeconds_ = 0;
  /**
   *
   *
   * <pre>
   * The function execution timeout. Execution is considered failed and
   * can be terminated if the function is not completed at the end of the
   * timeout period. Defaults to 60 seconds.
   * </pre>
   *
   * <code>int32 timeout_seconds = 2;</code>
   *
   * @return The timeoutSeconds.
   */
  @java.lang.Override
  public int getTimeoutSeconds() {
    return timeoutSeconds_;
  }

  public static final int AVAILABLE_MEMORY_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object availableMemory_ = "";
  /**
   *
   *
   * <pre>
   * The amount of memory available for a function.
   * Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
   * supplied the value is interpreted as bytes.
   * See
   * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
   * a full description.
   * </pre>
   *
   * <code>string available_memory = 13;</code>
   *
   * @return The availableMemory.
   */
  @java.lang.Override
  public java.lang.String getAvailableMemory() {
    java.lang.Object ref = availableMemory_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      availableMemory_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The amount of memory available for a function.
   * Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
   * supplied the value is interpreted as bytes.
   * See
   * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
   * a full description.
   * </pre>
   *
   * <code>string available_memory = 13;</code>
   *
   * @return The bytes for availableMemory.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAvailableMemoryBytes() {
    java.lang.Object ref = availableMemory_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      availableMemory_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AVAILABLE_CPU_FIELD_NUMBER = 22;

  @SuppressWarnings("serial")
  private volatile java.lang.Object availableCpu_ = "";
  /**
   *
   *
   * <pre>
   * [Preview] The number of CPUs used in a single container instance.
   * Default value is calculated from available memory.
   * Supports the same values as Cloud Run, see
   * https://cloud.google.com/run/docs/reference/rest/v1/Container#resourcerequirements
   * Example: "1" indicates 1 vCPU
   * </pre>
   *
   * <code>string available_cpu = 22;</code>
   *
   * @return The availableCpu.
   */
  @java.lang.Override
  public java.lang.String getAvailableCpu() {
    java.lang.Object ref = availableCpu_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      availableCpu_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Preview] The number of CPUs used in a single container instance.
   * Default value is calculated from available memory.
   * Supports the same values as Cloud Run, see
   * https://cloud.google.com/run/docs/reference/rest/v1/Container#resourcerequirements
   * Example: "1" indicates 1 vCPU
   * </pre>
   *
   * <code>string available_cpu = 22;</code>
   *
   * @return The bytes for availableCpu.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAvailableCpuBytes() {
    java.lang.Object ref = availableCpu_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      availableCpu_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENVIRONMENT_VARIABLES_FIELD_NUMBER = 4;

  private static final class EnvironmentVariablesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.functions.v2beta.FunctionsProto
                .internal_static_google_cloud_functions_v2beta_ServiceConfig_EnvironmentVariablesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> environmentVariables_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetEnvironmentVariables() {
    if (environmentVariables_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          EnvironmentVariablesDefaultEntryHolder.defaultEntry);
    }
    return environmentVariables_;
  }

  public int getEnvironmentVariablesCount() {
    return internalGetEnvironmentVariables().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Environment variables that shall be available during function execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 4;</code>
   */
  @java.lang.Override
  public boolean containsEnvironmentVariables(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetEnvironmentVariables().getMap().containsKey(key);
  }
  /** Use {@link #getEnvironmentVariablesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
    return getEnvironmentVariablesMap();
  }
  /**
   *
   *
   * <pre>
   * Environment variables that shall be available during function execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariablesMap() {
    return internalGetEnvironmentVariables().getMap();
  }
  /**
   *
   *
   * <pre>
   * Environment variables that shall be available during function execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getEnvironmentVariablesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetEnvironmentVariables().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Environment variables that shall be available during function execution.
   * </pre>
   *
   * <code>map&lt;string, string&gt; environment_variables = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getEnvironmentVariablesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetEnvironmentVariables().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int MAX_INSTANCE_COUNT_FIELD_NUMBER = 5;
  private int maxInstanceCount_ = 0;
  /**
   *
   *
   * <pre>
   * The limit on the maximum number of function instances that may coexist at a
   * given time.
   *
   * In some cases, such as rapid traffic surges, Cloud Functions may, for a
   * short period of time, create more instances than the specified max
   * instances limit. If your function cannot tolerate this temporary behavior,
   * you may want to factor in a safety margin and set a lower max instances
   * value than your function can tolerate.
   *
   * See the [Max
   * Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
   * more details.
   * </pre>
   *
   * <code>int32 max_instance_count = 5;</code>
   *
   * @return The maxInstanceCount.
   */
  @java.lang.Override
  public int getMaxInstanceCount() {
    return maxInstanceCount_;
  }

  public static final int MIN_INSTANCE_COUNT_FIELD_NUMBER = 12;
  private int minInstanceCount_ = 0;
  /**
   *
   *
   * <pre>
   * The limit on the minimum number of function instances that may coexist at a
   * given time.
   *
   * Function instances are kept in idle state for a short period after they
   * finished executing the request to reduce cold start time for subsequent
   * requests. Setting a minimum instance count will ensure that the given
   * number of instances are kept running in idle state always. This can help
   * with cold start times when jump in incoming request count occurs after the
   * idle instance would have been stopped in the default case.
   * </pre>
   *
   * <code>int32 min_instance_count = 12;</code>
   *
   * @return The minInstanceCount.
   */
  @java.lang.Override
  public int getMinInstanceCount() {
    return minInstanceCount_;
  }

  public static final int VPC_CONNECTOR_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object vpcConnector_ = "";
  /**
   *
   *
   * <pre>
   * The Serverless VPC Access connector that this cloud function can connect
   * to. The format of this field is `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
   * </pre>
   *
   * <code>string vpc_connector = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The vpcConnector.
   */
  @java.lang.Override
  public java.lang.String getVpcConnector() {
    java.lang.Object ref = vpcConnector_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      vpcConnector_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Serverless VPC Access connector that this cloud function can connect
   * to. The format of this field is `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
   * </pre>
   *
   * <code>string vpc_connector = 6 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for vpcConnector.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVpcConnectorBytes() {
    java.lang.Object ref = vpcConnector_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      vpcConnector_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VPC_CONNECTOR_EGRESS_SETTINGS_FIELD_NUMBER = 7;
  private int vpcConnectorEgressSettings_ = 0;
  /**
   *
   *
   * <pre>
   * The egress settings for the connector, controlling what traffic is diverted
   * through it.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings vpc_connector_egress_settings = 7;
   * </code>
   *
   * @return The enum numeric value on the wire for vpcConnectorEgressSettings.
   */
  @java.lang.Override
  public int getVpcConnectorEgressSettingsValue() {
    return vpcConnectorEgressSettings_;
  }
  /**
   *
   *
   * <pre>
   * The egress settings for the connector, controlling what traffic is diverted
   * through it.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings vpc_connector_egress_settings = 7;
   * </code>
   *
   * @return The vpcConnectorEgressSettings.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings
      getVpcConnectorEgressSettings() {
    com.google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings result =
        com.google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings.forNumber(
            vpcConnectorEgressSettings_);
    return result == null
        ? com.google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings.UNRECOGNIZED
        : result;
  }

  public static final int INGRESS_SETTINGS_FIELD_NUMBER = 8;
  private int ingressSettings_ = 0;
  /**
   *
   *
   * <pre>
   * The ingress settings for the function, controlling what traffic can reach
   * it.
   * </pre>
   *
   * <code>.google.cloud.functions.v2beta.ServiceConfig.IngressSettings ingress_settings = 8;</code>
   *
   * @return The enum numeric value on the wire for ingressSettings.
   */
  @java.lang.Override
  public int getIngressSettingsValue() {
    return ingressSettings_;
  }
  /**
   *
   *
   * <pre>
   * The ingress settings for the function, controlling what traffic can reach
   * it.
   * </pre>
   *
   * <code>.google.cloud.functions.v2beta.ServiceConfig.IngressSettings ingress_settings = 8;</code>
   *
   * @return The ingressSettings.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2beta.ServiceConfig.IngressSettings getIngressSettings() {
    com.google.cloud.functions.v2beta.ServiceConfig.IngressSettings result =
        com.google.cloud.functions.v2beta.ServiceConfig.IngressSettings.forNumber(ingressSettings_);
    return result == null
        ? com.google.cloud.functions.v2beta.ServiceConfig.IngressSettings.UNRECOGNIZED
        : result;
  }

  public static final int URI_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object uri_ = "";
  /**
   *
   *
   * <pre>
   * Output only. URI of the Service deployed.
   * </pre>
   *
   * <code>string uri = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The uri.
   */
  @java.lang.Override
  public java.lang.String getUri() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      uri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. URI of the Service deployed.
   * </pre>
   *
   * <code>string uri = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for uri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUriBytes() {
    java.lang.Object ref = uri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      uri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccountEmail_ = "";
  /**
   *
   *
   * <pre>
   * The email of the service's service account. If empty, defaults to
   * `{project_number}-compute&#64;developer.gserviceaccount.com`.
   * </pre>
   *
   * <code>string service_account_email = 10;</code>
   *
   * @return The serviceAccountEmail.
   */
  @java.lang.Override
  public java.lang.String getServiceAccountEmail() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccountEmail_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The email of the service's service account. If empty, defaults to
   * `{project_number}-compute&#64;developer.gserviceaccount.com`.
   * </pre>
   *
   * <code>string service_account_email = 10;</code>
   *
   * @return The bytes for serviceAccountEmail.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
    java.lang.Object ref = serviceAccountEmail_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccountEmail_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALL_TRAFFIC_ON_LATEST_REVISION_FIELD_NUMBER = 16;
  private boolean allTrafficOnLatestRevision_ = false;
  /**
   *
   *
   * <pre>
   * Whether 100% of traffic is routed to the latest revision.
   * On CreateFunction and UpdateFunction, when set to true, the revision being
   * deployed will serve 100% of traffic, ignoring any traffic split settings,
   * if any. On GetFunction, true will be returned if the latest revision is
   * serving 100% of traffic.
   * </pre>
   *
   * <code>bool all_traffic_on_latest_revision = 16;</code>
   *
   * @return The allTrafficOnLatestRevision.
   */
  @java.lang.Override
  public boolean getAllTrafficOnLatestRevision() {
    return allTrafficOnLatestRevision_;
  }

  public static final int SECRET_ENVIRONMENT_VARIABLES_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.functions.v2beta.SecretEnvVar>
      secretEnvironmentVariables_;
  /**
   *
   *
   * <pre>
   * Secret environment variables configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.functions.v2beta.SecretEnvVar>
      getSecretEnvironmentVariablesList() {
    return secretEnvironmentVariables_;
  }
  /**
   *
   *
   * <pre>
   * Secret environment variables configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.functions.v2beta.SecretEnvVarOrBuilder>
      getSecretEnvironmentVariablesOrBuilderList() {
    return secretEnvironmentVariables_;
  }
  /**
   *
   *
   * <pre>
   * Secret environment variables configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
   * </code>
   */
  @java.lang.Override
  public int getSecretEnvironmentVariablesCount() {
    return secretEnvironmentVariables_.size();
  }
  /**
   *
   *
   * <pre>
   * Secret environment variables configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2beta.SecretEnvVar getSecretEnvironmentVariables(int index) {
    return secretEnvironmentVariables_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Secret environment variables configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2beta.SecretEnvVarOrBuilder
      getSecretEnvironmentVariablesOrBuilder(int index) {
    return secretEnvironmentVariables_.get(index);
  }

  public static final int SECRET_VOLUMES_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.functions.v2beta.SecretVolume> secretVolumes_;
  /**
   *
   *
   * <pre>
   * Secret volumes configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.functions.v2beta.SecretVolume> getSecretVolumesList() {
    return secretVolumes_;
  }
  /**
   *
   *
   * <pre>
   * Secret volumes configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.functions.v2beta.SecretVolumeOrBuilder>
      getSecretVolumesOrBuilderList() {
    return secretVolumes_;
  }
  /**
   *
   *
   * <pre>
   * Secret volumes configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
   */
  @java.lang.Override
  public int getSecretVolumesCount() {
    return secretVolumes_.size();
  }
  /**
   *
   *
   * <pre>
   * Secret volumes configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2beta.SecretVolume getSecretVolumes(int index) {
    return secretVolumes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Secret volumes configuration.
   * </pre>
   *
   * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2beta.SecretVolumeOrBuilder getSecretVolumesOrBuilder(
      int index) {
    return secretVolumes_.get(index);
  }

  public static final int REVISION_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object revision_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The name of service revision.
   * </pre>
   *
   * <code>string revision = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The revision.
   */
  @java.lang.Override
  public java.lang.String getRevision() {
    java.lang.Object ref = revision_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      revision_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of service revision.
   * </pre>
   *
   * <code>string revision = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for revision.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRevisionBytes() {
    java.lang.Object ref = revision_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      revision_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_INSTANCE_REQUEST_CONCURRENCY_FIELD_NUMBER = 20;
  private int maxInstanceRequestConcurrency_ = 0;
  /**
   *
   *
   * <pre>
   * [Preview] Sets the maximum number of concurrent requests that each instance
   * can receive. Defaults to 1.
   * </pre>
   *
   * <code>int32 max_instance_request_concurrency = 20;</code>
   *
   * @return The maxInstanceRequestConcurrency.
   */
  @java.lang.Override
  public int getMaxInstanceRequestConcurrency() {
    return maxInstanceRequestConcurrency_;
  }

  public static final int SECURITY_LEVEL_FIELD_NUMBER = 21;
  private int securityLevel_ = 0;
  /**
   *
   *
   * <pre>
   * Security level configure whether the function only accepts https.
   * This configuration is only applicable to 1st Gen functions with Http
   * trigger. By default https is optional for 1st Gen functions; 2nd Gen
   * functions are https ONLY.
   * </pre>
   *
   * <code>.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel security_level = 21;</code>
   *
   * @return The enum numeric value on the wire for securityLevel.
   */
  @java.lang.Override
  public int getSecurityLevelValue() {
    return securityLevel_;
  }
  /**
   *
   *
   * <pre>
   * Security level configure whether the function only accepts https.
   * This configuration is only applicable to 1st Gen functions with Http
   * trigger. By default https is optional for 1st Gen functions; 2nd Gen
   * functions are https ONLY.
   * </pre>
   *
   * <code>.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel security_level = 21;</code>
   *
   * @return The securityLevel.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel getSecurityLevel() {
    com.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel result =
        com.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel.forNumber(securityLevel_);
    return result == null
        ? com.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
    }
    if (timeoutSeconds_ != 0) {
      output.writeInt32(2, timeoutSeconds_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetEnvironmentVariables(),
        EnvironmentVariablesDefaultEntryHolder.defaultEntry,
        4);
    if (maxInstanceCount_ != 0) {
      output.writeInt32(5, maxInstanceCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vpcConnector_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, vpcConnector_);
    }
    if (vpcConnectorEgressSettings_
        != com.google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings
            .VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, vpcConnectorEgressSettings_);
    }
    if (ingressSettings_
        != com.google.cloud.functions.v2beta.ServiceConfig.IngressSettings
            .INGRESS_SETTINGS_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, ingressSettings_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, serviceAccountEmail_);
    }
    if (minInstanceCount_ != 0) {
      output.writeInt32(12, minInstanceCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(availableMemory_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, availableMemory_);
    }
    if (allTrafficOnLatestRevision_ != false) {
      output.writeBool(16, allTrafficOnLatestRevision_);
    }
    for (int i = 0; i < secretEnvironmentVariables_.size(); i++) {
      output.writeMessage(17, secretEnvironmentVariables_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revision_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, revision_);
    }
    for (int i = 0; i < secretVolumes_.size(); i++) {
      output.writeMessage(19, secretVolumes_.get(i));
    }
    if (maxInstanceRequestConcurrency_ != 0) {
      output.writeInt32(20, maxInstanceRequestConcurrency_);
    }
    if (securityLevel_
        != com.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel.SECURITY_LEVEL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(21, securityLevel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(availableCpu_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 22, availableCpu_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
    }
    if (timeoutSeconds_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, timeoutSeconds_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetEnvironmentVariables().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> environmentVariables__ =
          EnvironmentVariablesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, environmentVariables__);
    }
    if (maxInstanceCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, maxInstanceCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(vpcConnector_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, vpcConnector_);
    }
    if (vpcConnectorEgressSettings_
        != com.google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings
            .VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, vpcConnectorEgressSettings_);
    }
    if (ingressSettings_
        != com.google.cloud.functions.v2beta.ServiceConfig.IngressSettings
            .INGRESS_SETTINGS_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, ingressSettings_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(uri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, uri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceAccountEmail_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, serviceAccountEmail_);
    }
    if (minInstanceCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(12, minInstanceCount_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(availableMemory_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, availableMemory_);
    }
    if (allTrafficOnLatestRevision_ != false) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(16, allTrafficOnLatestRevision_);
    }
    for (int i = 0; i < secretEnvironmentVariables_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, secretEnvironmentVariables_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(revision_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, revision_);
    }
    for (int i = 0; i < secretVolumes_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(19, secretVolumes_.get(i));
    }
    if (maxInstanceRequestConcurrency_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              20, maxInstanceRequestConcurrency_);
    }
    if (securityLevel_
        != com.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel.SECURITY_LEVEL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(21, securityLevel_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(availableCpu_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(22, availableCpu_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v2beta.ServiceConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v2beta.ServiceConfig other =
        (com.google.cloud.functions.v2beta.ServiceConfig) obj;

    if (!getService().equals(other.getService())) return false;
    if (getTimeoutSeconds() != other.getTimeoutSeconds()) return false;
    if (!getAvailableMemory().equals(other.getAvailableMemory())) return false;
    if (!getAvailableCpu().equals(other.getAvailableCpu())) return false;
    if (!internalGetEnvironmentVariables().equals(other.internalGetEnvironmentVariables()))
      return false;
    if (getMaxInstanceCount() != other.getMaxInstanceCount()) return false;
    if (getMinInstanceCount() != other.getMinInstanceCount()) return false;
    if (!getVpcConnector().equals(other.getVpcConnector())) return false;
    if (vpcConnectorEgressSettings_ != other.vpcConnectorEgressSettings_) return false;
    if (ingressSettings_ != other.ingressSettings_) return false;
    if (!getUri().equals(other.getUri())) return false;
    if (!getServiceAccountEmail().equals(other.getServiceAccountEmail())) return false;
    if (getAllTrafficOnLatestRevision() != other.getAllTrafficOnLatestRevision()) return false;
    if (!getSecretEnvironmentVariablesList().equals(other.getSecretEnvironmentVariablesList()))
      return false;
    if (!getSecretVolumesList().equals(other.getSecretVolumesList())) return false;
    if (!getRevision().equals(other.getRevision())) return false;
    if (getMaxInstanceRequestConcurrency() != other.getMaxInstanceRequestConcurrency())
      return false;
    if (securityLevel_ != other.securityLevel_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getService().hashCode();
    hash = (37 * hash) + TIMEOUT_SECONDS_FIELD_NUMBER;
    hash = (53 * hash) + getTimeoutSeconds();
    hash = (37 * hash) + AVAILABLE_MEMORY_FIELD_NUMBER;
    hash = (53 * hash) + getAvailableMemory().hashCode();
    hash = (37 * hash) + AVAILABLE_CPU_FIELD_NUMBER;
    hash = (53 * hash) + getAvailableCpu().hashCode();
    if (!internalGetEnvironmentVariables().getMap().isEmpty()) {
      hash = (37 * hash) + ENVIRONMENT_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetEnvironmentVariables().hashCode();
    }
    hash = (37 * hash) + MAX_INSTANCE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getMaxInstanceCount();
    hash = (37 * hash) + MIN_INSTANCE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getMinInstanceCount();
    hash = (37 * hash) + VPC_CONNECTOR_FIELD_NUMBER;
    hash = (53 * hash) + getVpcConnector().hashCode();
    hash = (37 * hash) + VPC_CONNECTOR_EGRESS_SETTINGS_FIELD_NUMBER;
    hash = (53 * hash) + vpcConnectorEgressSettings_;
    hash = (37 * hash) + INGRESS_SETTINGS_FIELD_NUMBER;
    hash = (53 * hash) + ingressSettings_;
    hash = (37 * hash) + URI_FIELD_NUMBER;
    hash = (53 * hash) + getUri().hashCode();
    hash = (37 * hash) + SERVICE_ACCOUNT_EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + getServiceAccountEmail().hashCode();
    hash = (37 * hash) + ALL_TRAFFIC_ON_LATEST_REVISION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllTrafficOnLatestRevision());
    if (getSecretEnvironmentVariablesCount() > 0) {
      hash = (37 * hash) + SECRET_ENVIRONMENT_VARIABLES_FIELD_NUMBER;
      hash = (53 * hash) + getSecretEnvironmentVariablesList().hashCode();
    }
    if (getSecretVolumesCount() > 0) {
      hash = (37 * hash) + SECRET_VOLUMES_FIELD_NUMBER;
      hash = (53 * hash) + getSecretVolumesList().hashCode();
    }
    hash = (37 * hash) + REVISION_FIELD_NUMBER;
    hash = (53 * hash) + getRevision().hashCode();
    hash = (37 * hash) + MAX_INSTANCE_REQUEST_CONCURRENCY_FIELD_NUMBER;
    hash = (53 * hash) + getMaxInstanceRequestConcurrency();
    hash = (37 * hash) + SECURITY_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + securityLevel_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v2beta.ServiceConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2beta.ServiceConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2beta.ServiceConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2beta.ServiceConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2beta.ServiceConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2beta.ServiceConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2beta.ServiceConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2beta.ServiceConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2beta.ServiceConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2beta.ServiceConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2beta.ServiceConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2beta.ServiceConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v2beta.ServiceConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes the Service being deployed.
   * Currently Supported : Cloud Run (fully managed).
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v2beta.ServiceConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v2beta.ServiceConfig)
      com.google.cloud.functions.v2beta.ServiceConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v2beta.FunctionsProto
          .internal_static_google_cloud_functions_v2beta_ServiceConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetEnvironmentVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableEnvironmentVariables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v2beta.FunctionsProto
          .internal_static_google_cloud_functions_v2beta_ServiceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v2beta.ServiceConfig.class,
              com.google.cloud.functions.v2beta.ServiceConfig.Builder.class);
    }

    // Construct using com.google.cloud.functions.v2beta.ServiceConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      service_ = "";
      timeoutSeconds_ = 0;
      availableMemory_ = "";
      availableCpu_ = "";
      internalGetMutableEnvironmentVariables().clear();
      maxInstanceCount_ = 0;
      minInstanceCount_ = 0;
      vpcConnector_ = "";
      vpcConnectorEgressSettings_ = 0;
      ingressSettings_ = 0;
      uri_ = "";
      serviceAccountEmail_ = "";
      allTrafficOnLatestRevision_ = false;
      if (secretEnvironmentVariablesBuilder_ == null) {
        secretEnvironmentVariables_ = java.util.Collections.emptyList();
      } else {
        secretEnvironmentVariables_ = null;
        secretEnvironmentVariablesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      if (secretVolumesBuilder_ == null) {
        secretVolumes_ = java.util.Collections.emptyList();
      } else {
        secretVolumes_ = null;
        secretVolumesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      revision_ = "";
      maxInstanceRequestConcurrency_ = 0;
      securityLevel_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v2beta.FunctionsProto
          .internal_static_google_cloud_functions_v2beta_ServiceConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2beta.ServiceConfig getDefaultInstanceForType() {
      return com.google.cloud.functions.v2beta.ServiceConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v2beta.ServiceConfig build() {
      com.google.cloud.functions.v2beta.ServiceConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2beta.ServiceConfig buildPartial() {
      com.google.cloud.functions.v2beta.ServiceConfig result =
          new com.google.cloud.functions.v2beta.ServiceConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.functions.v2beta.ServiceConfig result) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          secretEnvironmentVariables_ =
              java.util.Collections.unmodifiableList(secretEnvironmentVariables_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.secretEnvironmentVariables_ = secretEnvironmentVariables_;
      } else {
        result.secretEnvironmentVariables_ = secretEnvironmentVariablesBuilder_.build();
      }
      if (secretVolumesBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          secretVolumes_ = java.util.Collections.unmodifiableList(secretVolumes_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.secretVolumes_ = secretVolumes_;
      } else {
        result.secretVolumes_ = secretVolumesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.functions.v2beta.ServiceConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.service_ = service_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.timeoutSeconds_ = timeoutSeconds_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.availableMemory_ = availableMemory_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.availableCpu_ = availableCpu_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.environmentVariables_ = internalGetEnvironmentVariables();
        result.environmentVariables_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.maxInstanceCount_ = maxInstanceCount_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.minInstanceCount_ = minInstanceCount_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.vpcConnector_ = vpcConnector_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.vpcConnectorEgressSettings_ = vpcConnectorEgressSettings_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.ingressSettings_ = ingressSettings_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.uri_ = uri_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.serviceAccountEmail_ = serviceAccountEmail_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.allTrafficOnLatestRevision_ = allTrafficOnLatestRevision_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.revision_ = revision_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.maxInstanceRequestConcurrency_ = maxInstanceRequestConcurrency_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.securityLevel_ = securityLevel_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v2beta.ServiceConfig) {
        return mergeFrom((com.google.cloud.functions.v2beta.ServiceConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v2beta.ServiceConfig other) {
      if (other == com.google.cloud.functions.v2beta.ServiceConfig.getDefaultInstance())
        return this;
      if (!other.getService().isEmpty()) {
        service_ = other.service_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getTimeoutSeconds() != 0) {
        setTimeoutSeconds(other.getTimeoutSeconds());
      }
      if (!other.getAvailableMemory().isEmpty()) {
        availableMemory_ = other.availableMemory_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getAvailableCpu().isEmpty()) {
        availableCpu_ = other.availableCpu_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      internalGetMutableEnvironmentVariables().mergeFrom(other.internalGetEnvironmentVariables());
      bitField0_ |= 0x00000010;
      if (other.getMaxInstanceCount() != 0) {
        setMaxInstanceCount(other.getMaxInstanceCount());
      }
      if (other.getMinInstanceCount() != 0) {
        setMinInstanceCount(other.getMinInstanceCount());
      }
      if (!other.getVpcConnector().isEmpty()) {
        vpcConnector_ = other.vpcConnector_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.vpcConnectorEgressSettings_ != 0) {
        setVpcConnectorEgressSettingsValue(other.getVpcConnectorEgressSettingsValue());
      }
      if (other.ingressSettings_ != 0) {
        setIngressSettingsValue(other.getIngressSettingsValue());
      }
      if (!other.getUri().isEmpty()) {
        uri_ = other.uri_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.getServiceAccountEmail().isEmpty()) {
        serviceAccountEmail_ = other.serviceAccountEmail_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (other.getAllTrafficOnLatestRevision() != false) {
        setAllTrafficOnLatestRevision(other.getAllTrafficOnLatestRevision());
      }
      if (secretEnvironmentVariablesBuilder_ == null) {
        if (!other.secretEnvironmentVariables_.isEmpty()) {
          if (secretEnvironmentVariables_.isEmpty()) {
            secretEnvironmentVariables_ = other.secretEnvironmentVariables_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureSecretEnvironmentVariablesIsMutable();
            secretEnvironmentVariables_.addAll(other.secretEnvironmentVariables_);
          }
          onChanged();
        }
      } else {
        if (!other.secretEnvironmentVariables_.isEmpty()) {
          if (secretEnvironmentVariablesBuilder_.isEmpty()) {
            secretEnvironmentVariablesBuilder_.dispose();
            secretEnvironmentVariablesBuilder_ = null;
            secretEnvironmentVariables_ = other.secretEnvironmentVariables_;
            bitField0_ = (bitField0_ & ~0x00002000);
            secretEnvironmentVariablesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSecretEnvironmentVariablesFieldBuilder()
                    : null;
          } else {
            secretEnvironmentVariablesBuilder_.addAllMessages(other.secretEnvironmentVariables_);
          }
        }
      }
      if (secretVolumesBuilder_ == null) {
        if (!other.secretVolumes_.isEmpty()) {
          if (secretVolumes_.isEmpty()) {
            secretVolumes_ = other.secretVolumes_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureSecretVolumesIsMutable();
            secretVolumes_.addAll(other.secretVolumes_);
          }
          onChanged();
        }
      } else {
        if (!other.secretVolumes_.isEmpty()) {
          if (secretVolumesBuilder_.isEmpty()) {
            secretVolumesBuilder_.dispose();
            secretVolumesBuilder_ = null;
            secretVolumes_ = other.secretVolumes_;
            bitField0_ = (bitField0_ & ~0x00004000);
            secretVolumesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSecretVolumesFieldBuilder()
                    : null;
          } else {
            secretVolumesBuilder_.addAllMessages(other.secretVolumes_);
          }
        }
      }
      if (!other.getRevision().isEmpty()) {
        revision_ = other.revision_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      if (other.getMaxInstanceRequestConcurrency() != 0) {
        setMaxInstanceRequestConcurrency(other.getMaxInstanceRequestConcurrency());
      }
      if (other.securityLevel_ != 0) {
        setSecurityLevelValue(other.getSecurityLevelValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                service_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                timeoutSeconds_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    environmentVariables__ =
                        input.readMessage(
                            EnvironmentVariablesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableEnvironmentVariables()
                    .getMutableMap()
                    .put(environmentVariables__.getKey(), environmentVariables__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 40:
              {
                maxInstanceCount_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 50:
              {
                vpcConnector_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 56:
              {
                vpcConnectorEgressSettings_ = input.readEnum();
                bitField0_ |= 0x00000100;
                break;
              } // case 56
            case 64:
              {
                ingressSettings_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 64
            case 74:
              {
                uri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 74
            case 82:
              {
                serviceAccountEmail_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 82
            case 96:
              {
                minInstanceCount_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 96
            case 106:
              {
                availableMemory_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 106
            case 128:
              {
                allTrafficOnLatestRevision_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 128
            case 138:
              {
                com.google.cloud.functions.v2beta.SecretEnvVar m =
                    input.readMessage(
                        com.google.cloud.functions.v2beta.SecretEnvVar.parser(), extensionRegistry);
                if (secretEnvironmentVariablesBuilder_ == null) {
                  ensureSecretEnvironmentVariablesIsMutable();
                  secretEnvironmentVariables_.add(m);
                } else {
                  secretEnvironmentVariablesBuilder_.addMessage(m);
                }
                break;
              } // case 138
            case 146:
              {
                revision_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 146
            case 154:
              {
                com.google.cloud.functions.v2beta.SecretVolume m =
                    input.readMessage(
                        com.google.cloud.functions.v2beta.SecretVolume.parser(), extensionRegistry);
                if (secretVolumesBuilder_ == null) {
                  ensureSecretVolumesIsMutable();
                  secretVolumes_.add(m);
                } else {
                  secretVolumesBuilder_.addMessage(m);
                }
                break;
              } // case 154
            case 160:
              {
                maxInstanceRequestConcurrency_ = input.readInt32();
                bitField0_ |= 0x00010000;
                break;
              } // case 160
            case 168:
              {
                securityLevel_ = input.readEnum();
                bitField0_ |= 0x00020000;
                break;
              } // case 168
            case 178:
              {
                availableCpu_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 178
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the service associated with a Function.
     * The format of this field is
     * `projects/{project}/locations/{region}/services/{service}`
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the service associated with a Function.
     * The format of this field is
     * `projects/{project}/locations/{region}/services/{service}`
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the service associated with a Function.
     * The format of this field is
     * `projects/{project}/locations/{region}/services/{service}`
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      service_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the service associated with a Function.
     * The format of this field is
     * `projects/{project}/locations/{region}/services/{service}`
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {
      service_ = getDefaultInstance().getService();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the service associated with a Function.
     * The format of this field is
     * `projects/{project}/locations/{region}/services/{service}`
     * </pre>
     *
     * <code>
     * string service = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      service_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int timeoutSeconds_;
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>int32 timeout_seconds = 2;</code>
     *
     * @return The timeoutSeconds.
     */
    @java.lang.Override
    public int getTimeoutSeconds() {
      return timeoutSeconds_;
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>int32 timeout_seconds = 2;</code>
     *
     * @param value The timeoutSeconds to set.
     * @return This builder for chaining.
     */
    public Builder setTimeoutSeconds(int value) {

      timeoutSeconds_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The function execution timeout. Execution is considered failed and
     * can be terminated if the function is not completed at the end of the
     * timeout period. Defaults to 60 seconds.
     * </pre>
     *
     * <code>int32 timeout_seconds = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTimeoutSeconds() {
      bitField0_ = (bitField0_ & ~0x00000002);
      timeoutSeconds_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object availableMemory_ = "";
    /**
     *
     *
     * <pre>
     * The amount of memory available for a function.
     * Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
     * supplied the value is interpreted as bytes.
     * See
     * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
     * a full description.
     * </pre>
     *
     * <code>string available_memory = 13;</code>
     *
     * @return The availableMemory.
     */
    public java.lang.String getAvailableMemory() {
      java.lang.Object ref = availableMemory_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        availableMemory_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The amount of memory available for a function.
     * Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
     * supplied the value is interpreted as bytes.
     * See
     * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
     * a full description.
     * </pre>
     *
     * <code>string available_memory = 13;</code>
     *
     * @return The bytes for availableMemory.
     */
    public com.google.protobuf.ByteString getAvailableMemoryBytes() {
      java.lang.Object ref = availableMemory_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        availableMemory_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The amount of memory available for a function.
     * Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
     * supplied the value is interpreted as bytes.
     * See
     * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
     * a full description.
     * </pre>
     *
     * <code>string available_memory = 13;</code>
     *
     * @param value The availableMemory to set.
     * @return This builder for chaining.
     */
    public Builder setAvailableMemory(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      availableMemory_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The amount of memory available for a function.
     * Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
     * supplied the value is interpreted as bytes.
     * See
     * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
     * a full description.
     * </pre>
     *
     * <code>string available_memory = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvailableMemory() {
      availableMemory_ = getDefaultInstance().getAvailableMemory();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The amount of memory available for a function.
     * Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
     * supplied the value is interpreted as bytes.
     * See
     * https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
     * a full description.
     * </pre>
     *
     * <code>string available_memory = 13;</code>
     *
     * @param value The bytes for availableMemory to set.
     * @return This builder for chaining.
     */
    public Builder setAvailableMemoryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      availableMemory_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object availableCpu_ = "";
    /**
     *
     *
     * <pre>
     * [Preview] The number of CPUs used in a single container instance.
     * Default value is calculated from available memory.
     * Supports the same values as Cloud Run, see
     * https://cloud.google.com/run/docs/reference/rest/v1/Container#resourcerequirements
     * Example: "1" indicates 1 vCPU
     * </pre>
     *
     * <code>string available_cpu = 22;</code>
     *
     * @return The availableCpu.
     */
    public java.lang.String getAvailableCpu() {
      java.lang.Object ref = availableCpu_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        availableCpu_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Preview] The number of CPUs used in a single container instance.
     * Default value is calculated from available memory.
     * Supports the same values as Cloud Run, see
     * https://cloud.google.com/run/docs/reference/rest/v1/Container#resourcerequirements
     * Example: "1" indicates 1 vCPU
     * </pre>
     *
     * <code>string available_cpu = 22;</code>
     *
     * @return The bytes for availableCpu.
     */
    public com.google.protobuf.ByteString getAvailableCpuBytes() {
      java.lang.Object ref = availableCpu_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        availableCpu_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Preview] The number of CPUs used in a single container instance.
     * Default value is calculated from available memory.
     * Supports the same values as Cloud Run, see
     * https://cloud.google.com/run/docs/reference/rest/v1/Container#resourcerequirements
     * Example: "1" indicates 1 vCPU
     * </pre>
     *
     * <code>string available_cpu = 22;</code>
     *
     * @param value The availableCpu to set.
     * @return This builder for chaining.
     */
    public Builder setAvailableCpu(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      availableCpu_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Preview] The number of CPUs used in a single container instance.
     * Default value is calculated from available memory.
     * Supports the same values as Cloud Run, see
     * https://cloud.google.com/run/docs/reference/rest/v1/Container#resourcerequirements
     * Example: "1" indicates 1 vCPU
     * </pre>
     *
     * <code>string available_cpu = 22;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAvailableCpu() {
      availableCpu_ = getDefaultInstance().getAvailableCpu();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Preview] The number of CPUs used in a single container instance.
     * Default value is calculated from available memory.
     * Supports the same values as Cloud Run, see
     * https://cloud.google.com/run/docs/reference/rest/v1/Container#resourcerequirements
     * Example: "1" indicates 1 vCPU
     * </pre>
     *
     * <code>string available_cpu = 22;</code>
     *
     * @param value The bytes for availableCpu to set.
     * @return This builder for chaining.
     */
    public Builder setAvailableCpuBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      availableCpu_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> environmentVariables_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetEnvironmentVariables() {
      if (environmentVariables_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            EnvironmentVariablesDefaultEntryHolder.defaultEntry);
      }
      return environmentVariables_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableEnvironmentVariables() {
      if (environmentVariables_ == null) {
        environmentVariables_ =
            com.google.protobuf.MapField.newMapField(
                EnvironmentVariablesDefaultEntryHolder.defaultEntry);
      }
      if (!environmentVariables_.isMutable()) {
        environmentVariables_ = environmentVariables_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return environmentVariables_;
    }

    public int getEnvironmentVariablesCount() {
      return internalGetEnvironmentVariables().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 4;</code>
     */
    @java.lang.Override
    public boolean containsEnvironmentVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetEnvironmentVariables().getMap().containsKey(key);
    }
    /** Use {@link #getEnvironmentVariablesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariables() {
      return getEnvironmentVariablesMap();
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getEnvironmentVariablesMap() {
      return internalGetEnvironmentVariables().getMap();
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getEnvironmentVariablesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetEnvironmentVariables().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getEnvironmentVariablesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetEnvironmentVariables().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearEnvironmentVariables() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableEnvironmentVariables().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 4;</code>
     */
    public Builder removeEnvironmentVariables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableEnvironmentVariables().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableEnvironmentVariables() {
      bitField0_ |= 0x00000010;
      return internalGetMutableEnvironmentVariables().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 4;</code>
     */
    public Builder putEnvironmentVariables(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableEnvironmentVariables().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Environment variables that shall be available during function execution.
     * </pre>
     *
     * <code>map&lt;string, string&gt; environment_variables = 4;</code>
     */
    public Builder putAllEnvironmentVariables(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableEnvironmentVariables().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private int maxInstanceCount_;
    /**
     *
     *
     * <pre>
     * The limit on the maximum number of function instances that may coexist at a
     * given time.
     *
     * In some cases, such as rapid traffic surges, Cloud Functions may, for a
     * short period of time, create more instances than the specified max
     * instances limit. If your function cannot tolerate this temporary behavior,
     * you may want to factor in a safety margin and set a lower max instances
     * value than your function can tolerate.
     *
     * See the [Max
     * Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
     * more details.
     * </pre>
     *
     * <code>int32 max_instance_count = 5;</code>
     *
     * @return The maxInstanceCount.
     */
    @java.lang.Override
    public int getMaxInstanceCount() {
      return maxInstanceCount_;
    }
    /**
     *
     *
     * <pre>
     * The limit on the maximum number of function instances that may coexist at a
     * given time.
     *
     * In some cases, such as rapid traffic surges, Cloud Functions may, for a
     * short period of time, create more instances than the specified max
     * instances limit. If your function cannot tolerate this temporary behavior,
     * you may want to factor in a safety margin and set a lower max instances
     * value than your function can tolerate.
     *
     * See the [Max
     * Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
     * more details.
     * </pre>
     *
     * <code>int32 max_instance_count = 5;</code>
     *
     * @param value The maxInstanceCount to set.
     * @return This builder for chaining.
     */
    public Builder setMaxInstanceCount(int value) {

      maxInstanceCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The limit on the maximum number of function instances that may coexist at a
     * given time.
     *
     * In some cases, such as rapid traffic surges, Cloud Functions may, for a
     * short period of time, create more instances than the specified max
     * instances limit. If your function cannot tolerate this temporary behavior,
     * you may want to factor in a safety margin and set a lower max instances
     * value than your function can tolerate.
     *
     * See the [Max
     * Instances](https://cloud.google.com/functions/docs/max-instances) Guide for
     * more details.
     * </pre>
     *
     * <code>int32 max_instance_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxInstanceCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      maxInstanceCount_ = 0;
      onChanged();
      return this;
    }

    private int minInstanceCount_;
    /**
     *
     *
     * <pre>
     * The limit on the minimum number of function instances that may coexist at a
     * given time.
     *
     * Function instances are kept in idle state for a short period after they
     * finished executing the request to reduce cold start time for subsequent
     * requests. Setting a minimum instance count will ensure that the given
     * number of instances are kept running in idle state always. This can help
     * with cold start times when jump in incoming request count occurs after the
     * idle instance would have been stopped in the default case.
     * </pre>
     *
     * <code>int32 min_instance_count = 12;</code>
     *
     * @return The minInstanceCount.
     */
    @java.lang.Override
    public int getMinInstanceCount() {
      return minInstanceCount_;
    }
    /**
     *
     *
     * <pre>
     * The limit on the minimum number of function instances that may coexist at a
     * given time.
     *
     * Function instances are kept in idle state for a short period after they
     * finished executing the request to reduce cold start time for subsequent
     * requests. Setting a minimum instance count will ensure that the given
     * number of instances are kept running in idle state always. This can help
     * with cold start times when jump in incoming request count occurs after the
     * idle instance would have been stopped in the default case.
     * </pre>
     *
     * <code>int32 min_instance_count = 12;</code>
     *
     * @param value The minInstanceCount to set.
     * @return This builder for chaining.
     */
    public Builder setMinInstanceCount(int value) {

      minInstanceCount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The limit on the minimum number of function instances that may coexist at a
     * given time.
     *
     * Function instances are kept in idle state for a short period after they
     * finished executing the request to reduce cold start time for subsequent
     * requests. Setting a minimum instance count will ensure that the given
     * number of instances are kept running in idle state always. This can help
     * with cold start times when jump in incoming request count occurs after the
     * idle instance would have been stopped in the default case.
     * </pre>
     *
     * <code>int32 min_instance_count = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMinInstanceCount() {
      bitField0_ = (bitField0_ & ~0x00000040);
      minInstanceCount_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object vpcConnector_ = "";
    /**
     *
     *
     * <pre>
     * The Serverless VPC Access connector that this cloud function can connect
     * to. The format of this field is `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
     * </pre>
     *
     * <code>string vpc_connector = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The vpcConnector.
     */
    public java.lang.String getVpcConnector() {
      java.lang.Object ref = vpcConnector_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        vpcConnector_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Serverless VPC Access connector that this cloud function can connect
     * to. The format of this field is `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
     * </pre>
     *
     * <code>string vpc_connector = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for vpcConnector.
     */
    public com.google.protobuf.ByteString getVpcConnectorBytes() {
      java.lang.Object ref = vpcConnector_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        vpcConnector_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Serverless VPC Access connector that this cloud function can connect
     * to. The format of this field is `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
     * </pre>
     *
     * <code>string vpc_connector = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The vpcConnector to set.
     * @return This builder for chaining.
     */
    public Builder setVpcConnector(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      vpcConnector_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Serverless VPC Access connector that this cloud function can connect
     * to. The format of this field is `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
     * </pre>
     *
     * <code>string vpc_connector = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVpcConnector() {
      vpcConnector_ = getDefaultInstance().getVpcConnector();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Serverless VPC Access connector that this cloud function can connect
     * to. The format of this field is `projects/&#42;&#47;locations/&#42;&#47;connectors/&#42;`.
     * </pre>
     *
     * <code>string vpc_connector = 6 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for vpcConnector to set.
     * @return This builder for chaining.
     */
    public Builder setVpcConnectorBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      vpcConnector_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private int vpcConnectorEgressSettings_ = 0;
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings vpc_connector_egress_settings = 7;
     * </code>
     *
     * @return The enum numeric value on the wire for vpcConnectorEgressSettings.
     */
    @java.lang.Override
    public int getVpcConnectorEgressSettingsValue() {
      return vpcConnectorEgressSettings_;
    }
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings vpc_connector_egress_settings = 7;
     * </code>
     *
     * @param value The enum numeric value on the wire for vpcConnectorEgressSettings to set.
     * @return This builder for chaining.
     */
    public Builder setVpcConnectorEgressSettingsValue(int value) {
      vpcConnectorEgressSettings_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings vpc_connector_egress_settings = 7;
     * </code>
     *
     * @return The vpcConnectorEgressSettings.
     */
    @java.lang.Override
    public com.google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings
        getVpcConnectorEgressSettings() {
      com.google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings result =
          com.google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings.forNumber(
              vpcConnectorEgressSettings_);
      return result == null
          ? com.google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings vpc_connector_egress_settings = 7;
     * </code>
     *
     * @param value The vpcConnectorEgressSettings to set.
     * @return This builder for chaining.
     */
    public Builder setVpcConnectorEgressSettings(
        com.google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000100;
      vpcConnectorEgressSettings_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The egress settings for the connector, controlling what traffic is diverted
     * through it.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2beta.ServiceConfig.VpcConnectorEgressSettings vpc_connector_egress_settings = 7;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVpcConnectorEgressSettings() {
      bitField0_ = (bitField0_ & ~0x00000100);
      vpcConnectorEgressSettings_ = 0;
      onChanged();
      return this;
    }

    private int ingressSettings_ = 0;
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v2beta.ServiceConfig.IngressSettings ingress_settings = 8;
     * </code>
     *
     * @return The enum numeric value on the wire for ingressSettings.
     */
    @java.lang.Override
    public int getIngressSettingsValue() {
      return ingressSettings_;
    }
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v2beta.ServiceConfig.IngressSettings ingress_settings = 8;
     * </code>
     *
     * @param value The enum numeric value on the wire for ingressSettings to set.
     * @return This builder for chaining.
     */
    public Builder setIngressSettingsValue(int value) {
      ingressSettings_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v2beta.ServiceConfig.IngressSettings ingress_settings = 8;
     * </code>
     *
     * @return The ingressSettings.
     */
    @java.lang.Override
    public com.google.cloud.functions.v2beta.ServiceConfig.IngressSettings getIngressSettings() {
      com.google.cloud.functions.v2beta.ServiceConfig.IngressSettings result =
          com.google.cloud.functions.v2beta.ServiceConfig.IngressSettings.forNumber(
              ingressSettings_);
      return result == null
          ? com.google.cloud.functions.v2beta.ServiceConfig.IngressSettings.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v2beta.ServiceConfig.IngressSettings ingress_settings = 8;
     * </code>
     *
     * @param value The ingressSettings to set.
     * @return This builder for chaining.
     */
    public Builder setIngressSettings(
        com.google.cloud.functions.v2beta.ServiceConfig.IngressSettings value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      ingressSettings_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The ingress settings for the function, controlling what traffic can reach
     * it.
     * </pre>
     *
     * <code>.google.cloud.functions.v2beta.ServiceConfig.IngressSettings ingress_settings = 8;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIngressSettings() {
      bitField0_ = (bitField0_ & ~0x00000200);
      ingressSettings_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object uri_ = "";
    /**
     *
     *
     * <pre>
     * Output only. URI of the Service deployed.
     * </pre>
     *
     * <code>string uri = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The uri.
     */
    public java.lang.String getUri() {
      java.lang.Object ref = uri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URI of the Service deployed.
     * </pre>
     *
     * <code>string uri = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for uri.
     */
    public com.google.protobuf.ByteString getUriBytes() {
      java.lang.Object ref = uri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        uri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. URI of the Service deployed.
     * </pre>
     *
     * <code>string uri = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The uri to set.
     * @return This builder for chaining.
     */
    public Builder setUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      uri_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URI of the Service deployed.
     * </pre>
     *
     * <code>string uri = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUri() {
      uri_ = getDefaultInstance().getUri();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. URI of the Service deployed.
     * </pre>
     *
     * <code>string uri = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for uri to set.
     * @return This builder for chaining.
     */
    public Builder setUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      uri_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object serviceAccountEmail_ = "";
    /**
     *
     *
     * <pre>
     * The email of the service's service account. If empty, defaults to
     * `{project_number}-compute&#64;developer.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 10;</code>
     *
     * @return The serviceAccountEmail.
     */
    public java.lang.String getServiceAccountEmail() {
      java.lang.Object ref = serviceAccountEmail_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccountEmail_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The email of the service's service account. If empty, defaults to
     * `{project_number}-compute&#64;developer.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 10;</code>
     *
     * @return The bytes for serviceAccountEmail.
     */
    public com.google.protobuf.ByteString getServiceAccountEmailBytes() {
      java.lang.Object ref = serviceAccountEmail_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccountEmail_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The email of the service's service account. If empty, defaults to
     * `{project_number}-compute&#64;developer.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 10;</code>
     *
     * @param value The serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmail(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccountEmail_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email of the service's service account. If empty, defaults to
     * `{project_number}-compute&#64;developer.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccountEmail() {
      serviceAccountEmail_ = getDefaultInstance().getServiceAccountEmail();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The email of the service's service account. If empty, defaults to
     * `{project_number}-compute&#64;developer.gserviceaccount.com`.
     * </pre>
     *
     * <code>string service_account_email = 10;</code>
     *
     * @param value The bytes for serviceAccountEmail to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountEmailBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccountEmail_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private boolean allTrafficOnLatestRevision_;
    /**
     *
     *
     * <pre>
     * Whether 100% of traffic is routed to the latest revision.
     * On CreateFunction and UpdateFunction, when set to true, the revision being
     * deployed will serve 100% of traffic, ignoring any traffic split settings,
     * if any. On GetFunction, true will be returned if the latest revision is
     * serving 100% of traffic.
     * </pre>
     *
     * <code>bool all_traffic_on_latest_revision = 16;</code>
     *
     * @return The allTrafficOnLatestRevision.
     */
    @java.lang.Override
    public boolean getAllTrafficOnLatestRevision() {
      return allTrafficOnLatestRevision_;
    }
    /**
     *
     *
     * <pre>
     * Whether 100% of traffic is routed to the latest revision.
     * On CreateFunction and UpdateFunction, when set to true, the revision being
     * deployed will serve 100% of traffic, ignoring any traffic split settings,
     * if any. On GetFunction, true will be returned if the latest revision is
     * serving 100% of traffic.
     * </pre>
     *
     * <code>bool all_traffic_on_latest_revision = 16;</code>
     *
     * @param value The allTrafficOnLatestRevision to set.
     * @return This builder for chaining.
     */
    public Builder setAllTrafficOnLatestRevision(boolean value) {

      allTrafficOnLatestRevision_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether 100% of traffic is routed to the latest revision.
     * On CreateFunction and UpdateFunction, when set to true, the revision being
     * deployed will serve 100% of traffic, ignoring any traffic split settings,
     * if any. On GetFunction, true will be returned if the latest revision is
     * serving 100% of traffic.
     * </pre>
     *
     * <code>bool all_traffic_on_latest_revision = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllTrafficOnLatestRevision() {
      bitField0_ = (bitField0_ & ~0x00001000);
      allTrafficOnLatestRevision_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.functions.v2beta.SecretEnvVar>
        secretEnvironmentVariables_ = java.util.Collections.emptyList();

    private void ensureSecretEnvironmentVariablesIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        secretEnvironmentVariables_ =
            new java.util.ArrayList<com.google.cloud.functions.v2beta.SecretEnvVar>(
                secretEnvironmentVariables_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2beta.SecretEnvVar,
            com.google.cloud.functions.v2beta.SecretEnvVar.Builder,
            com.google.cloud.functions.v2beta.SecretEnvVarOrBuilder>
        secretEnvironmentVariablesBuilder_;

    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public java.util.List<com.google.cloud.functions.v2beta.SecretEnvVar>
        getSecretEnvironmentVariablesList() {
      if (secretEnvironmentVariablesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(secretEnvironmentVariables_);
      } else {
        return secretEnvironmentVariablesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public int getSecretEnvironmentVariablesCount() {
      if (secretEnvironmentVariablesBuilder_ == null) {
        return secretEnvironmentVariables_.size();
      } else {
        return secretEnvironmentVariablesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public com.google.cloud.functions.v2beta.SecretEnvVar getSecretEnvironmentVariables(int index) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        return secretEnvironmentVariables_.get(index);
      } else {
        return secretEnvironmentVariablesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public Builder setSecretEnvironmentVariables(
        int index, com.google.cloud.functions.v2beta.SecretEnvVar value) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.set(index, value);
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public Builder setSecretEnvironmentVariables(
        int index, com.google.cloud.functions.v2beta.SecretEnvVar.Builder builderForValue) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.set(index, builderForValue.build());
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public Builder addSecretEnvironmentVariables(
        com.google.cloud.functions.v2beta.SecretEnvVar value) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.add(value);
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public Builder addSecretEnvironmentVariables(
        int index, com.google.cloud.functions.v2beta.SecretEnvVar value) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.add(index, value);
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public Builder addSecretEnvironmentVariables(
        com.google.cloud.functions.v2beta.SecretEnvVar.Builder builderForValue) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.add(builderForValue.build());
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public Builder addSecretEnvironmentVariables(
        int index, com.google.cloud.functions.v2beta.SecretEnvVar.Builder builderForValue) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.add(index, builderForValue.build());
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public Builder addAllSecretEnvironmentVariables(
        java.lang.Iterable<? extends com.google.cloud.functions.v2beta.SecretEnvVar> values) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        ensureSecretEnvironmentVariablesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secretEnvironmentVariables_);
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public Builder clearSecretEnvironmentVariables() {
      if (secretEnvironmentVariablesBuilder_ == null) {
        secretEnvironmentVariables_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public Builder removeSecretEnvironmentVariables(int index) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        ensureSecretEnvironmentVariablesIsMutable();
        secretEnvironmentVariables_.remove(index);
        onChanged();
      } else {
        secretEnvironmentVariablesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public com.google.cloud.functions.v2beta.SecretEnvVar.Builder
        getSecretEnvironmentVariablesBuilder(int index) {
      return getSecretEnvironmentVariablesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public com.google.cloud.functions.v2beta.SecretEnvVarOrBuilder
        getSecretEnvironmentVariablesOrBuilder(int index) {
      if (secretEnvironmentVariablesBuilder_ == null) {
        return secretEnvironmentVariables_.get(index);
      } else {
        return secretEnvironmentVariablesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.functions.v2beta.SecretEnvVarOrBuilder>
        getSecretEnvironmentVariablesOrBuilderList() {
      if (secretEnvironmentVariablesBuilder_ != null) {
        return secretEnvironmentVariablesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(secretEnvironmentVariables_);
      }
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public com.google.cloud.functions.v2beta.SecretEnvVar.Builder
        addSecretEnvironmentVariablesBuilder() {
      return getSecretEnvironmentVariablesFieldBuilder()
          .addBuilder(com.google.cloud.functions.v2beta.SecretEnvVar.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public com.google.cloud.functions.v2beta.SecretEnvVar.Builder
        addSecretEnvironmentVariablesBuilder(int index) {
      return getSecretEnvironmentVariablesFieldBuilder()
          .addBuilder(index, com.google.cloud.functions.v2beta.SecretEnvVar.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secret environment variables configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretEnvVar secret_environment_variables = 17;
     * </code>
     */
    public java.util.List<com.google.cloud.functions.v2beta.SecretEnvVar.Builder>
        getSecretEnvironmentVariablesBuilderList() {
      return getSecretEnvironmentVariablesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2beta.SecretEnvVar,
            com.google.cloud.functions.v2beta.SecretEnvVar.Builder,
            com.google.cloud.functions.v2beta.SecretEnvVarOrBuilder>
        getSecretEnvironmentVariablesFieldBuilder() {
      if (secretEnvironmentVariablesBuilder_ == null) {
        secretEnvironmentVariablesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.functions.v2beta.SecretEnvVar,
                com.google.cloud.functions.v2beta.SecretEnvVar.Builder,
                com.google.cloud.functions.v2beta.SecretEnvVarOrBuilder>(
                secretEnvironmentVariables_,
                ((bitField0_ & 0x00002000) != 0),
                getParentForChildren(),
                isClean());
        secretEnvironmentVariables_ = null;
      }
      return secretEnvironmentVariablesBuilder_;
    }

    private java.util.List<com.google.cloud.functions.v2beta.SecretVolume> secretVolumes_ =
        java.util.Collections.emptyList();

    private void ensureSecretVolumesIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        secretVolumes_ =
            new java.util.ArrayList<com.google.cloud.functions.v2beta.SecretVolume>(secretVolumes_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2beta.SecretVolume,
            com.google.cloud.functions.v2beta.SecretVolume.Builder,
            com.google.cloud.functions.v2beta.SecretVolumeOrBuilder>
        secretVolumesBuilder_;

    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public java.util.List<com.google.cloud.functions.v2beta.SecretVolume> getSecretVolumesList() {
      if (secretVolumesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(secretVolumes_);
      } else {
        return secretVolumesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public int getSecretVolumesCount() {
      if (secretVolumesBuilder_ == null) {
        return secretVolumes_.size();
      } else {
        return secretVolumesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public com.google.cloud.functions.v2beta.SecretVolume getSecretVolumes(int index) {
      if (secretVolumesBuilder_ == null) {
        return secretVolumes_.get(index);
      } else {
        return secretVolumesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public Builder setSecretVolumes(
        int index, com.google.cloud.functions.v2beta.SecretVolume value) {
      if (secretVolumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretVolumesIsMutable();
        secretVolumes_.set(index, value);
        onChanged();
      } else {
        secretVolumesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public Builder setSecretVolumes(
        int index, com.google.cloud.functions.v2beta.SecretVolume.Builder builderForValue) {
      if (secretVolumesBuilder_ == null) {
        ensureSecretVolumesIsMutable();
        secretVolumes_.set(index, builderForValue.build());
        onChanged();
      } else {
        secretVolumesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public Builder addSecretVolumes(com.google.cloud.functions.v2beta.SecretVolume value) {
      if (secretVolumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretVolumesIsMutable();
        secretVolumes_.add(value);
        onChanged();
      } else {
        secretVolumesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public Builder addSecretVolumes(
        int index, com.google.cloud.functions.v2beta.SecretVolume value) {
      if (secretVolumesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSecretVolumesIsMutable();
        secretVolumes_.add(index, value);
        onChanged();
      } else {
        secretVolumesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public Builder addSecretVolumes(
        com.google.cloud.functions.v2beta.SecretVolume.Builder builderForValue) {
      if (secretVolumesBuilder_ == null) {
        ensureSecretVolumesIsMutable();
        secretVolumes_.add(builderForValue.build());
        onChanged();
      } else {
        secretVolumesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public Builder addSecretVolumes(
        int index, com.google.cloud.functions.v2beta.SecretVolume.Builder builderForValue) {
      if (secretVolumesBuilder_ == null) {
        ensureSecretVolumesIsMutable();
        secretVolumes_.add(index, builderForValue.build());
        onChanged();
      } else {
        secretVolumesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public Builder addAllSecretVolumes(
        java.lang.Iterable<? extends com.google.cloud.functions.v2beta.SecretVolume> values) {
      if (secretVolumesBuilder_ == null) {
        ensureSecretVolumesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secretVolumes_);
        onChanged();
      } else {
        secretVolumesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public Builder clearSecretVolumes() {
      if (secretVolumesBuilder_ == null) {
        secretVolumes_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        secretVolumesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public Builder removeSecretVolumes(int index) {
      if (secretVolumesBuilder_ == null) {
        ensureSecretVolumesIsMutable();
        secretVolumes_.remove(index);
        onChanged();
      } else {
        secretVolumesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public com.google.cloud.functions.v2beta.SecretVolume.Builder getSecretVolumesBuilder(
        int index) {
      return getSecretVolumesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public com.google.cloud.functions.v2beta.SecretVolumeOrBuilder getSecretVolumesOrBuilder(
        int index) {
      if (secretVolumesBuilder_ == null) {
        return secretVolumes_.get(index);
      } else {
        return secretVolumesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public java.util.List<? extends com.google.cloud.functions.v2beta.SecretVolumeOrBuilder>
        getSecretVolumesOrBuilderList() {
      if (secretVolumesBuilder_ != null) {
        return secretVolumesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(secretVolumes_);
      }
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public com.google.cloud.functions.v2beta.SecretVolume.Builder addSecretVolumesBuilder() {
      return getSecretVolumesFieldBuilder()
          .addBuilder(com.google.cloud.functions.v2beta.SecretVolume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public com.google.cloud.functions.v2beta.SecretVolume.Builder addSecretVolumesBuilder(
        int index) {
      return getSecretVolumesFieldBuilder()
          .addBuilder(index, com.google.cloud.functions.v2beta.SecretVolume.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Secret volumes configuration.
     * </pre>
     *
     * <code>repeated .google.cloud.functions.v2beta.SecretVolume secret_volumes = 19;</code>
     */
    public java.util.List<com.google.cloud.functions.v2beta.SecretVolume.Builder>
        getSecretVolumesBuilderList() {
      return getSecretVolumesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2beta.SecretVolume,
            com.google.cloud.functions.v2beta.SecretVolume.Builder,
            com.google.cloud.functions.v2beta.SecretVolumeOrBuilder>
        getSecretVolumesFieldBuilder() {
      if (secretVolumesBuilder_ == null) {
        secretVolumesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.functions.v2beta.SecretVolume,
                com.google.cloud.functions.v2beta.SecretVolume.Builder,
                com.google.cloud.functions.v2beta.SecretVolumeOrBuilder>(
                secretVolumes_,
                ((bitField0_ & 0x00004000) != 0),
                getParentForChildren(),
                isClean());
        secretVolumes_ = null;
      }
      return secretVolumesBuilder_;
    }

    private java.lang.Object revision_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of service revision.
     * </pre>
     *
     * <code>string revision = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The revision.
     */
    public java.lang.String getRevision() {
      java.lang.Object ref = revision_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        revision_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of service revision.
     * </pre>
     *
     * <code>string revision = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for revision.
     */
    public com.google.protobuf.ByteString getRevisionBytes() {
      java.lang.Object ref = revision_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        revision_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of service revision.
     * </pre>
     *
     * <code>string revision = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The revision to set.
     * @return This builder for chaining.
     */
    public Builder setRevision(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      revision_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of service revision.
     * </pre>
     *
     * <code>string revision = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRevision() {
      revision_ = getDefaultInstance().getRevision();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of service revision.
     * </pre>
     *
     * <code>string revision = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for revision to set.
     * @return This builder for chaining.
     */
    public Builder setRevisionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      revision_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    private int maxInstanceRequestConcurrency_;
    /**
     *
     *
     * <pre>
     * [Preview] Sets the maximum number of concurrent requests that each instance
     * can receive. Defaults to 1.
     * </pre>
     *
     * <code>int32 max_instance_request_concurrency = 20;</code>
     *
     * @return The maxInstanceRequestConcurrency.
     */
    @java.lang.Override
    public int getMaxInstanceRequestConcurrency() {
      return maxInstanceRequestConcurrency_;
    }
    /**
     *
     *
     * <pre>
     * [Preview] Sets the maximum number of concurrent requests that each instance
     * can receive. Defaults to 1.
     * </pre>
     *
     * <code>int32 max_instance_request_concurrency = 20;</code>
     *
     * @param value The maxInstanceRequestConcurrency to set.
     * @return This builder for chaining.
     */
    public Builder setMaxInstanceRequestConcurrency(int value) {

      maxInstanceRequestConcurrency_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Preview] Sets the maximum number of concurrent requests that each instance
     * can receive. Defaults to 1.
     * </pre>
     *
     * <code>int32 max_instance_request_concurrency = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxInstanceRequestConcurrency() {
      bitField0_ = (bitField0_ & ~0x00010000);
      maxInstanceRequestConcurrency_ = 0;
      onChanged();
      return this;
    }

    private int securityLevel_ = 0;
    /**
     *
     *
     * <pre>
     * Security level configure whether the function only accepts https.
     * This configuration is only applicable to 1st Gen functions with Http
     * trigger. By default https is optional for 1st Gen functions; 2nd Gen
     * functions are https ONLY.
     * </pre>
     *
     * <code>.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel security_level = 21;</code>
     *
     * @return The enum numeric value on the wire for securityLevel.
     */
    @java.lang.Override
    public int getSecurityLevelValue() {
      return securityLevel_;
    }
    /**
     *
     *
     * <pre>
     * Security level configure whether the function only accepts https.
     * This configuration is only applicable to 1st Gen functions with Http
     * trigger. By default https is optional for 1st Gen functions; 2nd Gen
     * functions are https ONLY.
     * </pre>
     *
     * <code>.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel security_level = 21;</code>
     *
     * @param value The enum numeric value on the wire for securityLevel to set.
     * @return This builder for chaining.
     */
    public Builder setSecurityLevelValue(int value) {
      securityLevel_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Security level configure whether the function only accepts https.
     * This configuration is only applicable to 1st Gen functions with Http
     * trigger. By default https is optional for 1st Gen functions; 2nd Gen
     * functions are https ONLY.
     * </pre>
     *
     * <code>.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel security_level = 21;</code>
     *
     * @return The securityLevel.
     */
    @java.lang.Override
    public com.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel getSecurityLevel() {
      com.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel result =
          com.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel.forNumber(securityLevel_);
      return result == null
          ? com.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Security level configure whether the function only accepts https.
     * This configuration is only applicable to 1st Gen functions with Http
     * trigger. By default https is optional for 1st Gen functions; 2nd Gen
     * functions are https ONLY.
     * </pre>
     *
     * <code>.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel security_level = 21;</code>
     *
     * @param value The securityLevel to set.
     * @return This builder for chaining.
     */
    public Builder setSecurityLevel(
        com.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00020000;
      securityLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Security level configure whether the function only accepts https.
     * This configuration is only applicable to 1st Gen functions with Http
     * trigger. By default https is optional for 1st Gen functions; 2nd Gen
     * functions are https ONLY.
     * </pre>
     *
     * <code>.google.cloud.functions.v2beta.ServiceConfig.SecurityLevel security_level = 21;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSecurityLevel() {
      bitField0_ = (bitField0_ & ~0x00020000);
      securityLevel_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v2beta.ServiceConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v2beta.ServiceConfig)
  private static final com.google.cloud.functions.v2beta.ServiceConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v2beta.ServiceConfig();
  }

  public static com.google.cloud.functions.v2beta.ServiceConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServiceConfig> PARSER =
      new com.google.protobuf.AbstractParser<ServiceConfig>() {
        @java.lang.Override
        public ServiceConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServiceConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServiceConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v2beta.ServiceConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
