/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v2beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CryptoKeyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_KEY_RING_CRYPTO_KEY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String keyRing;
    private final String cryptoKey;

    @Deprecated
    protected CryptoKeyName() {
        this.project = null;
        this.location = null;
        this.keyRing = null;
        this.cryptoKey = null;
    }

    private CryptoKeyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.keyRing = (String)Preconditions.checkNotNull((Object)builder.getKeyRing());
        this.cryptoKey = (String)Preconditions.checkNotNull((Object)builder.getCryptoKey());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getKeyRing() {
        return this.keyRing;
    }

    public String getCryptoKey() {
        return this.cryptoKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CryptoKeyName of(String project, String location, String keyRing, String cryptoKey) {
        return CryptoKeyName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setCryptoKey(cryptoKey).build();
    }

    public static String format(String project, String location, String keyRing, String cryptoKey) {
        return CryptoKeyName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setCryptoKey(cryptoKey).build().toString();
    }

    public static CryptoKeyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_KEY_RING_CRYPTO_KEY.validatedMatch(formattedString, "CryptoKeyName.parse: formattedString not in valid format");
        return CryptoKeyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("key_ring"), (String)matchMap.get("crypto_key"));
    }

    public static List<CryptoKeyName> parseList(List<String> formattedStrings) {
        ArrayList<CryptoKeyName> list = new ArrayList<CryptoKeyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CryptoKeyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CryptoKeyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CryptoKeyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_KEY_RING_CRYPTO_KEY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CryptoKeyName cryptoKeyName = this;
            synchronized (cryptoKeyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.keyRing != null) {
                        fieldMapBuilder.put((Object)"key_ring", (Object)this.keyRing);
                    }
                    if (this.cryptoKey != null) {
                        fieldMapBuilder.put((Object)"crypto_key", (Object)this.cryptoKey);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_KEY_RING_CRYPTO_KEY.instantiate(new String[]{"project", this.project, "location", this.location, "key_ring", this.keyRing, "crypto_key", this.cryptoKey});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CryptoKeyName that = (CryptoKeyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.keyRing, that.keyRing) && Objects.equals(this.cryptoKey, that.cryptoKey);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.keyRing);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cryptoKey);
    }

    public static class Builder {
        private String project;
        private String location;
        private String keyRing;
        private String cryptoKey;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKeyRing() {
            return this.keyRing;
        }

        public String getCryptoKey() {
            return this.cryptoKey;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setKeyRing(String keyRing) {
            this.keyRing = keyRing;
            return this;
        }

        public Builder setCryptoKey(String cryptoKey) {
            this.cryptoKey = cryptoKey;
            return this;
        }

        private Builder(CryptoKeyName cryptoKeyName) {
            this.project = cryptoKeyName.project;
            this.location = cryptoKeyName.location;
            this.keyRing = cryptoKeyName.keyRing;
            this.cryptoKey = cryptoKeyName.cryptoKey;
        }

        public CryptoKeyName build() {
            return new CryptoKeyName(this);
        }
    }
}

