/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v2/functions.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.functions.v2;

/**
 *
 *
 * <pre>
 * Describes a Cloud Function that contains user computation executed in
 * response to an event. It encapsulates function and trigger configurations.
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v2.Function}
 */
public final class Function extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v2.Function)
    FunctionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Function.newBuilder() to construct.
  private Function(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Function() {
    name_ = "";
    description_ = "";
    state_ = 0;
    stateMessages_ = java.util.Collections.emptyList();
    environment_ = 0;
    url_ = "";
    kmsKeyName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Function();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v2.FunctionsProto
        .internal_static_google_cloud_functions_v2_Function_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 8:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v2.FunctionsProto
        .internal_static_google_cloud_functions_v2_Function_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v2.Function.class,
            com.google.cloud.functions.v2.Function.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Describes the current state of the function.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.functions.v2.Function.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. Invalid state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Function has been successfully deployed and is serving.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    ACTIVE(1),
    /**
     *
     *
     * <pre>
     * Function deployment failed and the function is not serving.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    FAILED(2),
    /**
     *
     *
     * <pre>
     * Function is being created or updated.
     * </pre>
     *
     * <code>DEPLOYING = 3;</code>
     */
    DEPLOYING(3),
    /**
     *
     *
     * <pre>
     * Function is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    DELETING(4),
    /**
     *
     *
     * <pre>
     * Function deployment failed and the function serving state is undefined.
     * The function should be updated or deleted to move it out of this state.
     * </pre>
     *
     * <code>UNKNOWN = 5;</code>
     */
    UNKNOWN(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. Invalid state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Function has been successfully deployed and is serving.
     * </pre>
     *
     * <code>ACTIVE = 1;</code>
     */
    public static final int ACTIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Function deployment failed and the function is not serving.
     * </pre>
     *
     * <code>FAILED = 2;</code>
     */
    public static final int FAILED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Function is being created or updated.
     * </pre>
     *
     * <code>DEPLOYING = 3;</code>
     */
    public static final int DEPLOYING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Function is being deleted.
     * </pre>
     *
     * <code>DELETING = 4;</code>
     */
    public static final int DELETING_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Function deployment failed and the function serving state is undefined.
     * The function should be updated or deleted to move it out of this state.
     * </pre>
     *
     * <code>UNKNOWN = 5;</code>
     */
    public static final int UNKNOWN_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return ACTIVE;
        case 2:
          return FAILED;
        case 3:
          return DEPLOYING;
        case 4:
          return DELETING;
        case 5:
          return UNKNOWN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.functions.v2.Function.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.functions.v2.Function.State)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * A user-defined name of the function. Function names must be unique
   * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A user-defined name of the function. Function names must be unique
   * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * User-provided description of a function.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * User-provided description of a function.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUILD_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.functions.v2.BuildConfig buildConfig_;
  /**
   *
   *
   * <pre>
   * Describes the Build step of the function that builds a container from the
   * given source.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.BuildConfig build_config = 3;</code>
   *
   * @return Whether the buildConfig field is set.
   */
  @java.lang.Override
  public boolean hasBuildConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Describes the Build step of the function that builds a container from the
   * given source.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.BuildConfig build_config = 3;</code>
   *
   * @return The buildConfig.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.BuildConfig getBuildConfig() {
    return buildConfig_ == null
        ? com.google.cloud.functions.v2.BuildConfig.getDefaultInstance()
        : buildConfig_;
  }
  /**
   *
   *
   * <pre>
   * Describes the Build step of the function that builds a container from the
   * given source.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.BuildConfig build_config = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.BuildConfigOrBuilder getBuildConfigOrBuilder() {
    return buildConfig_ == null
        ? com.google.cloud.functions.v2.BuildConfig.getDefaultInstance()
        : buildConfig_;
  }

  public static final int SERVICE_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.functions.v2.ServiceConfig serviceConfig_;
  /**
   *
   *
   * <pre>
   * Describes the Service being deployed. Currently deploys services to Cloud
   * Run (fully managed).
   * </pre>
   *
   * <code>.google.cloud.functions.v2.ServiceConfig service_config = 4;</code>
   *
   * @return Whether the serviceConfig field is set.
   */
  @java.lang.Override
  public boolean hasServiceConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Describes the Service being deployed. Currently deploys services to Cloud
   * Run (fully managed).
   * </pre>
   *
   * <code>.google.cloud.functions.v2.ServiceConfig service_config = 4;</code>
   *
   * @return The serviceConfig.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.ServiceConfig getServiceConfig() {
    return serviceConfig_ == null
        ? com.google.cloud.functions.v2.ServiceConfig.getDefaultInstance()
        : serviceConfig_;
  }
  /**
   *
   *
   * <pre>
   * Describes the Service being deployed. Currently deploys services to Cloud
   * Run (fully managed).
   * </pre>
   *
   * <code>.google.cloud.functions.v2.ServiceConfig service_config = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.ServiceConfigOrBuilder getServiceConfigOrBuilder() {
    return serviceConfig_ == null
        ? com.google.cloud.functions.v2.ServiceConfig.getDefaultInstance()
        : serviceConfig_;
  }

  public static final int EVENT_TRIGGER_FIELD_NUMBER = 5;
  private com.google.cloud.functions.v2.EventTrigger eventTrigger_;
  /**
   *
   *
   * <pre>
   * An Eventarc trigger managed by Google Cloud Functions that fires events in
   * response to a condition in another service.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.EventTrigger event_trigger = 5;</code>
   *
   * @return Whether the eventTrigger field is set.
   */
  @java.lang.Override
  public boolean hasEventTrigger() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * An Eventarc trigger managed by Google Cloud Functions that fires events in
   * response to a condition in another service.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.EventTrigger event_trigger = 5;</code>
   *
   * @return The eventTrigger.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.EventTrigger getEventTrigger() {
    return eventTrigger_ == null
        ? com.google.cloud.functions.v2.EventTrigger.getDefaultInstance()
        : eventTrigger_;
  }
  /**
   *
   *
   * <pre>
   * An Eventarc trigger managed by Google Cloud Functions that fires events in
   * response to a condition in another service.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.EventTrigger event_trigger = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.EventTriggerOrBuilder getEventTriggerOrBuilder() {
    return eventTrigger_ == null
        ? com.google.cloud.functions.v2.EventTrigger.getDefaultInstance()
        : eventTrigger_;
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. State of the function.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v2.Function.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State of the function.
   * </pre>
   *
   * <code>
   * .google.cloud.functions.v2.Function.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.Function.State getState() {
    com.google.cloud.functions.v2.Function.State result =
        com.google.cloud.functions.v2.Function.State.forNumber(state_);
    return result == null ? com.google.cloud.functions.v2.Function.State.UNRECOGNIZED : result;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Cloud Function.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Cloud Function.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last update timestamp of a Cloud Function.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 8;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.functions.v2.FunctionsProto
                .internal_static_google_cloud_functions_v2_Function_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this Cloud Function.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }
  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this Cloud Function.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this Cloud Function.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Labels associated with this Cloud Function.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 8;</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int STATE_MESSAGES_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.functions.v2.StateMessage> stateMessages_;
  /**
   *
   *
   * <pre>
   * Output only. State Messages for this Cloud Function.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.functions.v2.StateMessage> getStateMessagesList() {
    return stateMessages_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State Messages for this Cloud Function.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.functions.v2.StateMessageOrBuilder>
      getStateMessagesOrBuilderList() {
    return stateMessages_;
  }
  /**
   *
   *
   * <pre>
   * Output only. State Messages for this Cloud Function.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getStateMessagesCount() {
    return stateMessages_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. State Messages for this Cloud Function.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.StateMessage getStateMessages(int index) {
    return stateMessages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. State Messages for this Cloud Function.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.StateMessageOrBuilder getStateMessagesOrBuilder(int index) {
    return stateMessages_.get(index);
  }

  public static final int ENVIRONMENT_FIELD_NUMBER = 10;
  private int environment_ = 0;
  /**
   *
   *
   * <pre>
   * Describe whether the function is 1st Gen or 2nd Gen.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.Environment environment = 10;</code>
   *
   * @return The enum numeric value on the wire for environment.
   */
  @java.lang.Override
  public int getEnvironmentValue() {
    return environment_;
  }
  /**
   *
   *
   * <pre>
   * Describe whether the function is 1st Gen or 2nd Gen.
   * </pre>
   *
   * <code>.google.cloud.functions.v2.Environment environment = 10;</code>
   *
   * @return The environment.
   */
  @java.lang.Override
  public com.google.cloud.functions.v2.Environment getEnvironment() {
    com.google.cloud.functions.v2.Environment result =
        com.google.cloud.functions.v2.Environment.forNumber(environment_);
    return result == null ? com.google.cloud.functions.v2.Environment.UNRECOGNIZED : result;
  }

  public static final int URL_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object url_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The deployed url for the function.
   * </pre>
   *
   * <code>string url = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The url.
   */
  @java.lang.Override
  public java.lang.String getUrl() {
    java.lang.Object ref = url_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      url_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The deployed url for the function.
   * </pre>
   *
   * <code>string url = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for url.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUrlBytes() {
    java.lang.Object ref = url_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      url_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KMS_KEY_NAME_FIELD_NUMBER = 25;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kmsKeyName_ = "";
  /**
   *
   *
   * <pre>
   * [Preview] Resource name of a KMS crypto key (managed by the user) used to
   * encrypt/decrypt function resources.
   *
   * It must match the pattern
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
   * </pre>
   *
   * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The kmsKeyName.
   */
  @java.lang.Override
  public java.lang.String getKmsKeyName() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kmsKeyName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * [Preview] Resource name of a KMS crypto key (managed by the user) used to
   * encrypt/decrypt function resources.
   *
   * It must match the pattern
   * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
   * </pre>
   *
   * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
   *
   * @return The bytes for kmsKeyName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKmsKeyNameBytes() {
    java.lang.Object ref = kmsKeyName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kmsKeyName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getBuildConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getServiceConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getEventTrigger());
    }
    if (state_ != com.google.cloud.functions.v2.Function.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, state_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(7, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 8);
    for (int i = 0; i < stateMessages_.size(); i++) {
      output.writeMessage(9, stateMessages_.get(i));
    }
    if (environment_
        != com.google.cloud.functions.v2.Environment.ENVIRONMENT_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, environment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, url_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 25, kmsKeyName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getBuildConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getServiceConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEventTrigger());
    }
    if (state_ != com.google.cloud.functions.v2.Function.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, labels__);
    }
    for (int i = 0; i < stateMessages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, stateMessages_.get(i));
    }
    if (environment_
        != com.google.cloud.functions.v2.Environment.ENVIRONMENT_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, environment_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, url_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(kmsKeyName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(25, kmsKeyName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v2.Function)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v2.Function other = (com.google.cloud.functions.v2.Function) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasBuildConfig() != other.hasBuildConfig()) return false;
    if (hasBuildConfig()) {
      if (!getBuildConfig().equals(other.getBuildConfig())) return false;
    }
    if (hasServiceConfig() != other.hasServiceConfig()) return false;
    if (hasServiceConfig()) {
      if (!getServiceConfig().equals(other.getServiceConfig())) return false;
    }
    if (hasEventTrigger() != other.hasEventTrigger()) return false;
    if (hasEventTrigger()) {
      if (!getEventTrigger().equals(other.getEventTrigger())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getStateMessagesList().equals(other.getStateMessagesList())) return false;
    if (environment_ != other.environment_) return false;
    if (!getUrl().equals(other.getUrl())) return false;
    if (!getKmsKeyName().equals(other.getKmsKeyName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasBuildConfig()) {
      hash = (37 * hash) + BUILD_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getBuildConfig().hashCode();
    }
    if (hasServiceConfig()) {
      hash = (37 * hash) + SERVICE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getServiceConfig().hashCode();
    }
    if (hasEventTrigger()) {
      hash = (37 * hash) + EVENT_TRIGGER_FIELD_NUMBER;
      hash = (53 * hash) + getEventTrigger().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getStateMessagesCount() > 0) {
      hash = (37 * hash) + STATE_MESSAGES_FIELD_NUMBER;
      hash = (53 * hash) + getStateMessagesList().hashCode();
    }
    hash = (37 * hash) + ENVIRONMENT_FIELD_NUMBER;
    hash = (53 * hash) + environment_;
    hash = (37 * hash) + URL_FIELD_NUMBER;
    hash = (53 * hash) + getUrl().hashCode();
    hash = (37 * hash) + KMS_KEY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getKmsKeyName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v2.Function parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2.Function parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.Function parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2.Function parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.Function parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v2.Function parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.Function parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2.Function parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.Function parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2.Function parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v2.Function parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v2.Function parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v2.Function prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes a Cloud Function that contains user computation executed in
   * response to an event. It encapsulates function and trigger configurations.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v2.Function}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v2.Function)
      com.google.cloud.functions.v2.FunctionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v2.FunctionsProto
          .internal_static_google_cloud_functions_v2_Function_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v2.FunctionsProto
          .internal_static_google_cloud_functions_v2_Function_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v2.Function.class,
              com.google.cloud.functions.v2.Function.Builder.class);
    }

    // Construct using com.google.cloud.functions.v2.Function.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getBuildConfigFieldBuilder();
        getServiceConfigFieldBuilder();
        getEventTriggerFieldBuilder();
        getUpdateTimeFieldBuilder();
        getStateMessagesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      buildConfig_ = null;
      if (buildConfigBuilder_ != null) {
        buildConfigBuilder_.dispose();
        buildConfigBuilder_ = null;
      }
      serviceConfig_ = null;
      if (serviceConfigBuilder_ != null) {
        serviceConfigBuilder_.dispose();
        serviceConfigBuilder_ = null;
      }
      eventTrigger_ = null;
      if (eventTriggerBuilder_ != null) {
        eventTriggerBuilder_.dispose();
        eventTriggerBuilder_ = null;
      }
      state_ = 0;
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      if (stateMessagesBuilder_ == null) {
        stateMessages_ = java.util.Collections.emptyList();
      } else {
        stateMessages_ = null;
        stateMessagesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      environment_ = 0;
      url_ = "";
      kmsKeyName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v2.FunctionsProto
          .internal_static_google_cloud_functions_v2_Function_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2.Function getDefaultInstanceForType() {
      return com.google.cloud.functions.v2.Function.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v2.Function build() {
      com.google.cloud.functions.v2.Function result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v2.Function buildPartial() {
      com.google.cloud.functions.v2.Function result =
          new com.google.cloud.functions.v2.Function(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.functions.v2.Function result) {
      if (stateMessagesBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          stateMessages_ = java.util.Collections.unmodifiableList(stateMessages_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.stateMessages_ = stateMessages_;
      } else {
        result.stateMessages_ = stateMessagesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.functions.v2.Function result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.buildConfig_ =
            buildConfigBuilder_ == null ? buildConfig_ : buildConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.serviceConfig_ =
            serviceConfigBuilder_ == null ? serviceConfig_ : serviceConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.eventTrigger_ =
            eventTriggerBuilder_ == null ? eventTrigger_ : eventTriggerBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.environment_ = environment_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.url_ = url_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.kmsKeyName_ = kmsKeyName_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v2.Function) {
        return mergeFrom((com.google.cloud.functions.v2.Function) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v2.Function other) {
      if (other == com.google.cloud.functions.v2.Function.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasBuildConfig()) {
        mergeBuildConfig(other.getBuildConfig());
      }
      if (other.hasServiceConfig()) {
        mergeServiceConfig(other.getServiceConfig());
      }
      if (other.hasEventTrigger()) {
        mergeEventTrigger(other.getEventTrigger());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000080;
      if (stateMessagesBuilder_ == null) {
        if (!other.stateMessages_.isEmpty()) {
          if (stateMessages_.isEmpty()) {
            stateMessages_ = other.stateMessages_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureStateMessagesIsMutable();
            stateMessages_.addAll(other.stateMessages_);
          }
          onChanged();
        }
      } else {
        if (!other.stateMessages_.isEmpty()) {
          if (stateMessagesBuilder_.isEmpty()) {
            stateMessagesBuilder_.dispose();
            stateMessagesBuilder_ = null;
            stateMessages_ = other.stateMessages_;
            bitField0_ = (bitField0_ & ~0x00000100);
            stateMessagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStateMessagesFieldBuilder()
                    : null;
          } else {
            stateMessagesBuilder_.addAllMessages(other.stateMessages_);
          }
        }
      }
      if (other.environment_ != 0) {
        setEnvironmentValue(other.getEnvironmentValue());
      }
      if (!other.getUrl().isEmpty()) {
        url_ = other.url_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (!other.getKmsKeyName().isEmpty()) {
        kmsKeyName_ = other.kmsKeyName_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getBuildConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getServiceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getEventTriggerFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                com.google.cloud.functions.v2.StateMessage m =
                    input.readMessage(
                        com.google.cloud.functions.v2.StateMessage.parser(), extensionRegistry);
                if (stateMessagesBuilder_ == null) {
                  ensureStateMessagesIsMutable();
                  stateMessages_.add(m);
                } else {
                  stateMessagesBuilder_.addMessage(m);
                }
                break;
              } // case 74
            case 80:
              {
                environment_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 114:
              {
                url_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 114
            case 202:
              {
                kmsKeyName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 202
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A user-defined name of the function. Function names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;functions/&#42;`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User-provided description of a function.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.functions.v2.BuildConfig buildConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.BuildConfig,
            com.google.cloud.functions.v2.BuildConfig.Builder,
            com.google.cloud.functions.v2.BuildConfigOrBuilder>
        buildConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Describes the Build step of the function that builds a container from the
     * given source.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig build_config = 3;</code>
     *
     * @return Whether the buildConfig field is set.
     */
    public boolean hasBuildConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Describes the Build step of the function that builds a container from the
     * given source.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig build_config = 3;</code>
     *
     * @return The buildConfig.
     */
    public com.google.cloud.functions.v2.BuildConfig getBuildConfig() {
      if (buildConfigBuilder_ == null) {
        return buildConfig_ == null
            ? com.google.cloud.functions.v2.BuildConfig.getDefaultInstance()
            : buildConfig_;
      } else {
        return buildConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the Build step of the function that builds a container from the
     * given source.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig build_config = 3;</code>
     */
    public Builder setBuildConfig(com.google.cloud.functions.v2.BuildConfig value) {
      if (buildConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        buildConfig_ = value;
      } else {
        buildConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the Build step of the function that builds a container from the
     * given source.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig build_config = 3;</code>
     */
    public Builder setBuildConfig(
        com.google.cloud.functions.v2.BuildConfig.Builder builderForValue) {
      if (buildConfigBuilder_ == null) {
        buildConfig_ = builderForValue.build();
      } else {
        buildConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the Build step of the function that builds a container from the
     * given source.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig build_config = 3;</code>
     */
    public Builder mergeBuildConfig(com.google.cloud.functions.v2.BuildConfig value) {
      if (buildConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && buildConfig_ != null
            && buildConfig_ != com.google.cloud.functions.v2.BuildConfig.getDefaultInstance()) {
          getBuildConfigBuilder().mergeFrom(value);
        } else {
          buildConfig_ = value;
        }
      } else {
        buildConfigBuilder_.mergeFrom(value);
      }
      if (buildConfig_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the Build step of the function that builds a container from the
     * given source.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig build_config = 3;</code>
     */
    public Builder clearBuildConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      buildConfig_ = null;
      if (buildConfigBuilder_ != null) {
        buildConfigBuilder_.dispose();
        buildConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the Build step of the function that builds a container from the
     * given source.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig build_config = 3;</code>
     */
    public com.google.cloud.functions.v2.BuildConfig.Builder getBuildConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getBuildConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Describes the Build step of the function that builds a container from the
     * given source.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig build_config = 3;</code>
     */
    public com.google.cloud.functions.v2.BuildConfigOrBuilder getBuildConfigOrBuilder() {
      if (buildConfigBuilder_ != null) {
        return buildConfigBuilder_.getMessageOrBuilder();
      } else {
        return buildConfig_ == null
            ? com.google.cloud.functions.v2.BuildConfig.getDefaultInstance()
            : buildConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the Build step of the function that builds a container from the
     * given source.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.BuildConfig build_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.BuildConfig,
            com.google.cloud.functions.v2.BuildConfig.Builder,
            com.google.cloud.functions.v2.BuildConfigOrBuilder>
        getBuildConfigFieldBuilder() {
      if (buildConfigBuilder_ == null) {
        buildConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v2.BuildConfig,
                com.google.cloud.functions.v2.BuildConfig.Builder,
                com.google.cloud.functions.v2.BuildConfigOrBuilder>(
                getBuildConfig(), getParentForChildren(), isClean());
        buildConfig_ = null;
      }
      return buildConfigBuilder_;
    }

    private com.google.cloud.functions.v2.ServiceConfig serviceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.ServiceConfig,
            com.google.cloud.functions.v2.ServiceConfig.Builder,
            com.google.cloud.functions.v2.ServiceConfigOrBuilder>
        serviceConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Describes the Service being deployed. Currently deploys services to Cloud
     * Run (fully managed).
     * </pre>
     *
     * <code>.google.cloud.functions.v2.ServiceConfig service_config = 4;</code>
     *
     * @return Whether the serviceConfig field is set.
     */
    public boolean hasServiceConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Describes the Service being deployed. Currently deploys services to Cloud
     * Run (fully managed).
     * </pre>
     *
     * <code>.google.cloud.functions.v2.ServiceConfig service_config = 4;</code>
     *
     * @return The serviceConfig.
     */
    public com.google.cloud.functions.v2.ServiceConfig getServiceConfig() {
      if (serviceConfigBuilder_ == null) {
        return serviceConfig_ == null
            ? com.google.cloud.functions.v2.ServiceConfig.getDefaultInstance()
            : serviceConfig_;
      } else {
        return serviceConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the Service being deployed. Currently deploys services to Cloud
     * Run (fully managed).
     * </pre>
     *
     * <code>.google.cloud.functions.v2.ServiceConfig service_config = 4;</code>
     */
    public Builder setServiceConfig(com.google.cloud.functions.v2.ServiceConfig value) {
      if (serviceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        serviceConfig_ = value;
      } else {
        serviceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the Service being deployed. Currently deploys services to Cloud
     * Run (fully managed).
     * </pre>
     *
     * <code>.google.cloud.functions.v2.ServiceConfig service_config = 4;</code>
     */
    public Builder setServiceConfig(
        com.google.cloud.functions.v2.ServiceConfig.Builder builderForValue) {
      if (serviceConfigBuilder_ == null) {
        serviceConfig_ = builderForValue.build();
      } else {
        serviceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the Service being deployed. Currently deploys services to Cloud
     * Run (fully managed).
     * </pre>
     *
     * <code>.google.cloud.functions.v2.ServiceConfig service_config = 4;</code>
     */
    public Builder mergeServiceConfig(com.google.cloud.functions.v2.ServiceConfig value) {
      if (serviceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && serviceConfig_ != null
            && serviceConfig_ != com.google.cloud.functions.v2.ServiceConfig.getDefaultInstance()) {
          getServiceConfigBuilder().mergeFrom(value);
        } else {
          serviceConfig_ = value;
        }
      } else {
        serviceConfigBuilder_.mergeFrom(value);
      }
      if (serviceConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the Service being deployed. Currently deploys services to Cloud
     * Run (fully managed).
     * </pre>
     *
     * <code>.google.cloud.functions.v2.ServiceConfig service_config = 4;</code>
     */
    public Builder clearServiceConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      serviceConfig_ = null;
      if (serviceConfigBuilder_ != null) {
        serviceConfigBuilder_.dispose();
        serviceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describes the Service being deployed. Currently deploys services to Cloud
     * Run (fully managed).
     * </pre>
     *
     * <code>.google.cloud.functions.v2.ServiceConfig service_config = 4;</code>
     */
    public com.google.cloud.functions.v2.ServiceConfig.Builder getServiceConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getServiceConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Describes the Service being deployed. Currently deploys services to Cloud
     * Run (fully managed).
     * </pre>
     *
     * <code>.google.cloud.functions.v2.ServiceConfig service_config = 4;</code>
     */
    public com.google.cloud.functions.v2.ServiceConfigOrBuilder getServiceConfigOrBuilder() {
      if (serviceConfigBuilder_ != null) {
        return serviceConfigBuilder_.getMessageOrBuilder();
      } else {
        return serviceConfig_ == null
            ? com.google.cloud.functions.v2.ServiceConfig.getDefaultInstance()
            : serviceConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Describes the Service being deployed. Currently deploys services to Cloud
     * Run (fully managed).
     * </pre>
     *
     * <code>.google.cloud.functions.v2.ServiceConfig service_config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.ServiceConfig,
            com.google.cloud.functions.v2.ServiceConfig.Builder,
            com.google.cloud.functions.v2.ServiceConfigOrBuilder>
        getServiceConfigFieldBuilder() {
      if (serviceConfigBuilder_ == null) {
        serviceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v2.ServiceConfig,
                com.google.cloud.functions.v2.ServiceConfig.Builder,
                com.google.cloud.functions.v2.ServiceConfigOrBuilder>(
                getServiceConfig(), getParentForChildren(), isClean());
        serviceConfig_ = null;
      }
      return serviceConfigBuilder_;
    }

    private com.google.cloud.functions.v2.EventTrigger eventTrigger_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.EventTrigger,
            com.google.cloud.functions.v2.EventTrigger.Builder,
            com.google.cloud.functions.v2.EventTriggerOrBuilder>
        eventTriggerBuilder_;
    /**
     *
     *
     * <pre>
     * An Eventarc trigger managed by Google Cloud Functions that fires events in
     * response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.EventTrigger event_trigger = 5;</code>
     *
     * @return Whether the eventTrigger field is set.
     */
    public boolean hasEventTrigger() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * An Eventarc trigger managed by Google Cloud Functions that fires events in
     * response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.EventTrigger event_trigger = 5;</code>
     *
     * @return The eventTrigger.
     */
    public com.google.cloud.functions.v2.EventTrigger getEventTrigger() {
      if (eventTriggerBuilder_ == null) {
        return eventTrigger_ == null
            ? com.google.cloud.functions.v2.EventTrigger.getDefaultInstance()
            : eventTrigger_;
      } else {
        return eventTriggerBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * An Eventarc trigger managed by Google Cloud Functions that fires events in
     * response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.EventTrigger event_trigger = 5;</code>
     */
    public Builder setEventTrigger(com.google.cloud.functions.v2.EventTrigger value) {
      if (eventTriggerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        eventTrigger_ = value;
      } else {
        eventTriggerBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An Eventarc trigger managed by Google Cloud Functions that fires events in
     * response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.EventTrigger event_trigger = 5;</code>
     */
    public Builder setEventTrigger(
        com.google.cloud.functions.v2.EventTrigger.Builder builderForValue) {
      if (eventTriggerBuilder_ == null) {
        eventTrigger_ = builderForValue.build();
      } else {
        eventTriggerBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An Eventarc trigger managed by Google Cloud Functions that fires events in
     * response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.EventTrigger event_trigger = 5;</code>
     */
    public Builder mergeEventTrigger(com.google.cloud.functions.v2.EventTrigger value) {
      if (eventTriggerBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && eventTrigger_ != null
            && eventTrigger_ != com.google.cloud.functions.v2.EventTrigger.getDefaultInstance()) {
          getEventTriggerBuilder().mergeFrom(value);
        } else {
          eventTrigger_ = value;
        }
      } else {
        eventTriggerBuilder_.mergeFrom(value);
      }
      if (eventTrigger_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An Eventarc trigger managed by Google Cloud Functions that fires events in
     * response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.EventTrigger event_trigger = 5;</code>
     */
    public Builder clearEventTrigger() {
      bitField0_ = (bitField0_ & ~0x00000010);
      eventTrigger_ = null;
      if (eventTriggerBuilder_ != null) {
        eventTriggerBuilder_.dispose();
        eventTriggerBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An Eventarc trigger managed by Google Cloud Functions that fires events in
     * response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.EventTrigger event_trigger = 5;</code>
     */
    public com.google.cloud.functions.v2.EventTrigger.Builder getEventTriggerBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEventTriggerFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An Eventarc trigger managed by Google Cloud Functions that fires events in
     * response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.EventTrigger event_trigger = 5;</code>
     */
    public com.google.cloud.functions.v2.EventTriggerOrBuilder getEventTriggerOrBuilder() {
      if (eventTriggerBuilder_ != null) {
        return eventTriggerBuilder_.getMessageOrBuilder();
      } else {
        return eventTrigger_ == null
            ? com.google.cloud.functions.v2.EventTrigger.getDefaultInstance()
            : eventTrigger_;
      }
    }
    /**
     *
     *
     * <pre>
     * An Eventarc trigger managed by Google Cloud Functions that fires events in
     * response to a condition in another service.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.EventTrigger event_trigger = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v2.EventTrigger,
            com.google.cloud.functions.v2.EventTrigger.Builder,
            com.google.cloud.functions.v2.EventTriggerOrBuilder>
        getEventTriggerFieldBuilder() {
      if (eventTriggerBuilder_ == null) {
        eventTriggerBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v2.EventTrigger,
                com.google.cloud.functions.v2.EventTrigger.Builder,
                com.google.cloud.functions.v2.EventTriggerOrBuilder>(
                getEventTrigger(), getParentForChildren(), isClean());
        eventTrigger_ = null;
      }
      return eventTriggerBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. State of the function.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.Function.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the function.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.Function.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the function.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.Function.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.functions.v2.Function.State getState() {
      com.google.cloud.functions.v2.Function.State result =
          com.google.cloud.functions.v2.Function.State.forNumber(state_);
      return result == null ? com.google.cloud.functions.v2.Function.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the function.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.Function.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.functions.v2.Function.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State of the function.
     * </pre>
     *
     * <code>
     * .google.cloud.functions.v2.Function.State state = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000020);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last update timestamp of a Cloud Function.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }
    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000080);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000080;
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000080;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Labels associated with this Cloud Function.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 8;</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000080;
      return this;
    }

    private java.util.List<com.google.cloud.functions.v2.StateMessage> stateMessages_ =
        java.util.Collections.emptyList();

    private void ensureStateMessagesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        stateMessages_ =
            new java.util.ArrayList<com.google.cloud.functions.v2.StateMessage>(stateMessages_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2.StateMessage,
            com.google.cloud.functions.v2.StateMessage.Builder,
            com.google.cloud.functions.v2.StateMessageOrBuilder>
        stateMessagesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.functions.v2.StateMessage> getStateMessagesList() {
      if (stateMessagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(stateMessages_);
      } else {
        return stateMessagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getStateMessagesCount() {
      if (stateMessagesBuilder_ == null) {
        return stateMessages_.size();
      } else {
        return stateMessagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.functions.v2.StateMessage getStateMessages(int index) {
      if (stateMessagesBuilder_ == null) {
        return stateMessages_.get(index);
      } else {
        return stateMessagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateMessages(int index, com.google.cloud.functions.v2.StateMessage value) {
      if (stateMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStateMessagesIsMutable();
        stateMessages_.set(index, value);
        onChanged();
      } else {
        stateMessagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStateMessages(
        int index, com.google.cloud.functions.v2.StateMessage.Builder builderForValue) {
      if (stateMessagesBuilder_ == null) {
        ensureStateMessagesIsMutable();
        stateMessages_.set(index, builderForValue.build());
        onChanged();
      } else {
        stateMessagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStateMessages(com.google.cloud.functions.v2.StateMessage value) {
      if (stateMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStateMessagesIsMutable();
        stateMessages_.add(value);
        onChanged();
      } else {
        stateMessagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStateMessages(int index, com.google.cloud.functions.v2.StateMessage value) {
      if (stateMessagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStateMessagesIsMutable();
        stateMessages_.add(index, value);
        onChanged();
      } else {
        stateMessagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStateMessages(
        com.google.cloud.functions.v2.StateMessage.Builder builderForValue) {
      if (stateMessagesBuilder_ == null) {
        ensureStateMessagesIsMutable();
        stateMessages_.add(builderForValue.build());
        onChanged();
      } else {
        stateMessagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStateMessages(
        int index, com.google.cloud.functions.v2.StateMessage.Builder builderForValue) {
      if (stateMessagesBuilder_ == null) {
        ensureStateMessagesIsMutable();
        stateMessages_.add(index, builderForValue.build());
        onChanged();
      } else {
        stateMessagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllStateMessages(
        java.lang.Iterable<? extends com.google.cloud.functions.v2.StateMessage> values) {
      if (stateMessagesBuilder_ == null) {
        ensureStateMessagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stateMessages_);
        onChanged();
      } else {
        stateMessagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStateMessages() {
      if (stateMessagesBuilder_ == null) {
        stateMessages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        stateMessagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeStateMessages(int index) {
      if (stateMessagesBuilder_ == null) {
        ensureStateMessagesIsMutable();
        stateMessages_.remove(index);
        onChanged();
      } else {
        stateMessagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.functions.v2.StateMessage.Builder getStateMessagesBuilder(int index) {
      return getStateMessagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.functions.v2.StateMessageOrBuilder getStateMessagesOrBuilder(
        int index) {
      if (stateMessagesBuilder_ == null) {
        return stateMessages_.get(index);
      } else {
        return stateMessagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.functions.v2.StateMessageOrBuilder>
        getStateMessagesOrBuilderList() {
      if (stateMessagesBuilder_ != null) {
        return stateMessagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(stateMessages_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.functions.v2.StateMessage.Builder addStateMessagesBuilder() {
      return getStateMessagesFieldBuilder()
          .addBuilder(com.google.cloud.functions.v2.StateMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.functions.v2.StateMessage.Builder addStateMessagesBuilder(int index) {
      return getStateMessagesFieldBuilder()
          .addBuilder(index, com.google.cloud.functions.v2.StateMessage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. State Messages for this Cloud Function.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.functions.v2.StateMessage state_messages = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.functions.v2.StateMessage.Builder>
        getStateMessagesBuilderList() {
      return getStateMessagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.functions.v2.StateMessage,
            com.google.cloud.functions.v2.StateMessage.Builder,
            com.google.cloud.functions.v2.StateMessageOrBuilder>
        getStateMessagesFieldBuilder() {
      if (stateMessagesBuilder_ == null) {
        stateMessagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.functions.v2.StateMessage,
                com.google.cloud.functions.v2.StateMessage.Builder,
                com.google.cloud.functions.v2.StateMessageOrBuilder>(
                stateMessages_,
                ((bitField0_ & 0x00000100) != 0),
                getParentForChildren(),
                isClean());
        stateMessages_ = null;
      }
      return stateMessagesBuilder_;
    }

    private int environment_ = 0;
    /**
     *
     *
     * <pre>
     * Describe whether the function is 1st Gen or 2nd Gen.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Environment environment = 10;</code>
     *
     * @return The enum numeric value on the wire for environment.
     */
    @java.lang.Override
    public int getEnvironmentValue() {
      return environment_;
    }
    /**
     *
     *
     * <pre>
     * Describe whether the function is 1st Gen or 2nd Gen.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Environment environment = 10;</code>
     *
     * @param value The enum numeric value on the wire for environment to set.
     * @return This builder for chaining.
     */
    public Builder setEnvironmentValue(int value) {
      environment_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describe whether the function is 1st Gen or 2nd Gen.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Environment environment = 10;</code>
     *
     * @return The environment.
     */
    @java.lang.Override
    public com.google.cloud.functions.v2.Environment getEnvironment() {
      com.google.cloud.functions.v2.Environment result =
          com.google.cloud.functions.v2.Environment.forNumber(environment_);
      return result == null ? com.google.cloud.functions.v2.Environment.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Describe whether the function is 1st Gen or 2nd Gen.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Environment environment = 10;</code>
     *
     * @param value The environment to set.
     * @return This builder for chaining.
     */
    public Builder setEnvironment(com.google.cloud.functions.v2.Environment value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      environment_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describe whether the function is 1st Gen or 2nd Gen.
     * </pre>
     *
     * <code>.google.cloud.functions.v2.Environment environment = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnvironment() {
      bitField0_ = (bitField0_ & ~0x00000200);
      environment_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object url_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The deployed url for the function.
     * </pre>
     *
     * <code>string url = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The url.
     */
    public java.lang.String getUrl() {
      java.lang.Object ref = url_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        url_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The deployed url for the function.
     * </pre>
     *
     * <code>string url = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for url.
     */
    public com.google.protobuf.ByteString getUrlBytes() {
      java.lang.Object ref = url_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        url_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The deployed url for the function.
     * </pre>
     *
     * <code>string url = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The url to set.
     * @return This builder for chaining.
     */
    public Builder setUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      url_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The deployed url for the function.
     * </pre>
     *
     * <code>string url = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUrl() {
      url_ = getDefaultInstance().getUrl();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The deployed url for the function.
     * </pre>
     *
     * <code>string url = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for url to set.
     * @return This builder for chaining.
     */
    public Builder setUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      url_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private java.lang.Object kmsKeyName_ = "";
    /**
     *
     *
     * <pre>
     * [Preview] Resource name of a KMS crypto key (managed by the user) used to
     * encrypt/decrypt function resources.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The kmsKeyName.
     */
    public java.lang.String getKmsKeyName() {
      java.lang.Object ref = kmsKeyName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kmsKeyName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Preview] Resource name of a KMS crypto key (managed by the user) used to
     * encrypt/decrypt function resources.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return The bytes for kmsKeyName.
     */
    public com.google.protobuf.ByteString getKmsKeyNameBytes() {
      java.lang.Object ref = kmsKeyName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kmsKeyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * [Preview] Resource name of a KMS crypto key (managed by the user) used to
     * encrypt/decrypt function resources.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kmsKeyName_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Preview] Resource name of a KMS crypto key (managed by the user) used to
     * encrypt/decrypt function resources.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKmsKeyName() {
      kmsKeyName_ = getDefaultInstance().getKmsKeyName();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * [Preview] Resource name of a KMS crypto key (managed by the user) used to
     * encrypt/decrypt function resources.
     *
     * It must match the pattern
     * `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`.
     * </pre>
     *
     * <code>string kms_key_name = 25 [(.google.api.resource_reference) = { ... }</code>
     *
     * @param value The bytes for kmsKeyName to set.
     * @return This builder for chaining.
     */
    public Builder setKmsKeyNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kmsKeyName_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v2.Function)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v2.Function)
  private static final com.google.cloud.functions.v2.Function DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v2.Function();
  }

  public static com.google.cloud.functions.v2.Function getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Function> PARSER =
      new com.google.protobuf.AbstractParser<Function>() {
        @java.lang.Override
        public Function parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Function> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Function> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v2.Function getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
