/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v1/functions.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.functions.v1;

/**
 *
 *
 * <pre>
 * Describes the policy in case of function's execution failure.
 * If empty, then defaults to ignoring failures (i.e. not retrying them).
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v1.FailurePolicy}
 */
public final class FailurePolicy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v1.FailurePolicy)
    FailurePolicyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FailurePolicy.newBuilder() to construct.
  private FailurePolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FailurePolicy() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FailurePolicy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v1.FunctionsProto
        .internal_static_google_cloud_functions_v1_FailurePolicy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v1.FunctionsProto
        .internal_static_google_cloud_functions_v1_FailurePolicy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v1.FailurePolicy.class,
            com.google.cloud.functions.v1.FailurePolicy.Builder.class);
  }

  public interface RetryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.functions.v1.FailurePolicy.Retry)
      com.google.protobuf.MessageOrBuilder {}
  /**
   *
   *
   * <pre>
   * Describes the retry policy in case of function's execution failure.
   * A function execution will be retried on any failure.
   * A failed execution will be retried up to 7 days with an exponential backoff
   * (capped at 10 seconds).
   * Retried execution is charged as any other execution.
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v1.FailurePolicy.Retry}
   */
  public static final class Retry extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.functions.v1.FailurePolicy.Retry)
      RetryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Retry.newBuilder() to construct.
    private Retry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Retry() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Retry();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_FailurePolicy_Retry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_FailurePolicy_Retry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v1.FailurePolicy.Retry.class,
              com.google.cloud.functions.v1.FailurePolicy.Retry.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.functions.v1.FailurePolicy.Retry)) {
        return super.equals(obj);
      }
      com.google.cloud.functions.v1.FailurePolicy.Retry other =
          (com.google.cloud.functions.v1.FailurePolicy.Retry) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.functions.v1.FailurePolicy.Retry parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v1.FailurePolicy.Retry parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.FailurePolicy.Retry parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v1.FailurePolicy.Retry parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.FailurePolicy.Retry parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.functions.v1.FailurePolicy.Retry parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.FailurePolicy.Retry parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v1.FailurePolicy.Retry parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.FailurePolicy.Retry parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v1.FailurePolicy.Retry parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.functions.v1.FailurePolicy.Retry parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.functions.v1.FailurePolicy.Retry parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.functions.v1.FailurePolicy.Retry prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Describes the retry policy in case of function's execution failure.
     * A function execution will be retried on any failure.
     * A failed execution will be retried up to 7 days with an exponential backoff
     * (capped at 10 seconds).
     * Retried execution is charged as any other execution.
     * </pre>
     *
     * Protobuf type {@code google.cloud.functions.v1.FailurePolicy.Retry}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.functions.v1.FailurePolicy.Retry)
        com.google.cloud.functions.v1.FailurePolicy.RetryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.functions.v1.FunctionsProto
            .internal_static_google_cloud_functions_v1_FailurePolicy_Retry_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.functions.v1.FunctionsProto
            .internal_static_google_cloud_functions_v1_FailurePolicy_Retry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.functions.v1.FailurePolicy.Retry.class,
                com.google.cloud.functions.v1.FailurePolicy.Retry.Builder.class);
      }

      // Construct using com.google.cloud.functions.v1.FailurePolicy.Retry.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.functions.v1.FunctionsProto
            .internal_static_google_cloud_functions_v1_FailurePolicy_Retry_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.functions.v1.FailurePolicy.Retry getDefaultInstanceForType() {
        return com.google.cloud.functions.v1.FailurePolicy.Retry.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.functions.v1.FailurePolicy.Retry build() {
        com.google.cloud.functions.v1.FailurePolicy.Retry result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.functions.v1.FailurePolicy.Retry buildPartial() {
        com.google.cloud.functions.v1.FailurePolicy.Retry result =
            new com.google.cloud.functions.v1.FailurePolicy.Retry(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.functions.v1.FailurePolicy.Retry) {
          return mergeFrom((com.google.cloud.functions.v1.FailurePolicy.Retry) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.functions.v1.FailurePolicy.Retry other) {
        if (other == com.google.cloud.functions.v1.FailurePolicy.Retry.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.functions.v1.FailurePolicy.Retry)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.functions.v1.FailurePolicy.Retry)
    private static final com.google.cloud.functions.v1.FailurePolicy.Retry DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.functions.v1.FailurePolicy.Retry();
    }

    public static com.google.cloud.functions.v1.FailurePolicy.Retry getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Retry> PARSER =
        new com.google.protobuf.AbstractParser<Retry>() {
          @java.lang.Override
          public Retry parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Retry> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Retry> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.FailurePolicy.Retry getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int actionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object action_;

  public enum ActionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    RETRY(1),
    ACTION_NOT_SET(0);
    private final int value;

    private ActionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ActionCase valueOf(int value) {
      return forNumber(value);
    }

    public static ActionCase forNumber(int value) {
      switch (value) {
        case 1:
          return RETRY;
        case 0:
          return ACTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ActionCase getActionCase() {
    return ActionCase.forNumber(actionCase_);
  }

  public static final int RETRY_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * If specified, then the function will be retried in case of a failure.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.FailurePolicy.Retry retry = 1;</code>
   *
   * @return Whether the retry field is set.
   */
  @java.lang.Override
  public boolean hasRetry() {
    return actionCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * If specified, then the function will be retried in case of a failure.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.FailurePolicy.Retry retry = 1;</code>
   *
   * @return The retry.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.FailurePolicy.Retry getRetry() {
    if (actionCase_ == 1) {
      return (com.google.cloud.functions.v1.FailurePolicy.Retry) action_;
    }
    return com.google.cloud.functions.v1.FailurePolicy.Retry.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If specified, then the function will be retried in case of a failure.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.FailurePolicy.Retry retry = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.FailurePolicy.RetryOrBuilder getRetryOrBuilder() {
    if (actionCase_ == 1) {
      return (com.google.cloud.functions.v1.FailurePolicy.Retry) action_;
    }
    return com.google.cloud.functions.v1.FailurePolicy.Retry.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (actionCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.functions.v1.FailurePolicy.Retry) action_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (actionCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.functions.v1.FailurePolicy.Retry) action_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v1.FailurePolicy)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v1.FailurePolicy other =
        (com.google.cloud.functions.v1.FailurePolicy) obj;

    if (!getActionCase().equals(other.getActionCase())) return false;
    switch (actionCase_) {
      case 1:
        if (!getRetry().equals(other.getRetry())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (actionCase_) {
      case 1:
        hash = (37 * hash) + RETRY_FIELD_NUMBER;
        hash = (53 * hash) + getRetry().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v1.FailurePolicy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.FailurePolicy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.FailurePolicy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.FailurePolicy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.FailurePolicy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.FailurePolicy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.FailurePolicy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.FailurePolicy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.FailurePolicy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.FailurePolicy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.FailurePolicy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.FailurePolicy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v1.FailurePolicy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes the policy in case of function's execution failure.
   * If empty, then defaults to ignoring failures (i.e. not retrying them).
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v1.FailurePolicy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v1.FailurePolicy)
      com.google.cloud.functions.v1.FailurePolicyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_FailurePolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_FailurePolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v1.FailurePolicy.class,
              com.google.cloud.functions.v1.FailurePolicy.Builder.class);
    }

    // Construct using com.google.cloud.functions.v1.FailurePolicy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (retryBuilder_ != null) {
        retryBuilder_.clear();
      }
      actionCase_ = 0;
      action_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v1.FunctionsProto
          .internal_static_google_cloud_functions_v1_FailurePolicy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.FailurePolicy getDefaultInstanceForType() {
      return com.google.cloud.functions.v1.FailurePolicy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.FailurePolicy build() {
      com.google.cloud.functions.v1.FailurePolicy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.FailurePolicy buildPartial() {
      com.google.cloud.functions.v1.FailurePolicy result =
          new com.google.cloud.functions.v1.FailurePolicy(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.functions.v1.FailurePolicy result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.functions.v1.FailurePolicy result) {
      result.actionCase_ = actionCase_;
      result.action_ = this.action_;
      if (actionCase_ == 1 && retryBuilder_ != null) {
        result.action_ = retryBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v1.FailurePolicy) {
        return mergeFrom((com.google.cloud.functions.v1.FailurePolicy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v1.FailurePolicy other) {
      if (other == com.google.cloud.functions.v1.FailurePolicy.getDefaultInstance()) return this;
      switch (other.getActionCase()) {
        case RETRY:
          {
            mergeRetry(other.getRetry());
            break;
          }
        case ACTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getRetryFieldBuilder().getBuilder(), extensionRegistry);
                actionCase_ = 1;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int actionCase_ = 0;
    private java.lang.Object action_;

    public ActionCase getActionCase() {
      return ActionCase.forNumber(actionCase_);
    }

    public Builder clearAction() {
      actionCase_ = 0;
      action_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.FailurePolicy.Retry,
            com.google.cloud.functions.v1.FailurePolicy.Retry.Builder,
            com.google.cloud.functions.v1.FailurePolicy.RetryOrBuilder>
        retryBuilder_;
    /**
     *
     *
     * <pre>
     * If specified, then the function will be retried in case of a failure.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy.Retry retry = 1;</code>
     *
     * @return Whether the retry field is set.
     */
    @java.lang.Override
    public boolean hasRetry() {
      return actionCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * If specified, then the function will be retried in case of a failure.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy.Retry retry = 1;</code>
     *
     * @return The retry.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.FailurePolicy.Retry getRetry() {
      if (retryBuilder_ == null) {
        if (actionCase_ == 1) {
          return (com.google.cloud.functions.v1.FailurePolicy.Retry) action_;
        }
        return com.google.cloud.functions.v1.FailurePolicy.Retry.getDefaultInstance();
      } else {
        if (actionCase_ == 1) {
          return retryBuilder_.getMessage();
        }
        return com.google.cloud.functions.v1.FailurePolicy.Retry.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, then the function will be retried in case of a failure.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy.Retry retry = 1;</code>
     */
    public Builder setRetry(com.google.cloud.functions.v1.FailurePolicy.Retry value) {
      if (retryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        action_ = value;
        onChanged();
      } else {
        retryBuilder_.setMessage(value);
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, then the function will be retried in case of a failure.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy.Retry retry = 1;</code>
     */
    public Builder setRetry(
        com.google.cloud.functions.v1.FailurePolicy.Retry.Builder builderForValue) {
      if (retryBuilder_ == null) {
        action_ = builderForValue.build();
        onChanged();
      } else {
        retryBuilder_.setMessage(builderForValue.build());
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, then the function will be retried in case of a failure.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy.Retry retry = 1;</code>
     */
    public Builder mergeRetry(com.google.cloud.functions.v1.FailurePolicy.Retry value) {
      if (retryBuilder_ == null) {
        if (actionCase_ == 1
            && action_ != com.google.cloud.functions.v1.FailurePolicy.Retry.getDefaultInstance()) {
          action_ =
              com.google.cloud.functions.v1.FailurePolicy.Retry.newBuilder(
                      (com.google.cloud.functions.v1.FailurePolicy.Retry) action_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          action_ = value;
        }
        onChanged();
      } else {
        if (actionCase_ == 1) {
          retryBuilder_.mergeFrom(value);
        } else {
          retryBuilder_.setMessage(value);
        }
      }
      actionCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, then the function will be retried in case of a failure.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy.Retry retry = 1;</code>
     */
    public Builder clearRetry() {
      if (retryBuilder_ == null) {
        if (actionCase_ == 1) {
          actionCase_ = 0;
          action_ = null;
          onChanged();
        }
      } else {
        if (actionCase_ == 1) {
          actionCase_ = 0;
          action_ = null;
        }
        retryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, then the function will be retried in case of a failure.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy.Retry retry = 1;</code>
     */
    public com.google.cloud.functions.v1.FailurePolicy.Retry.Builder getRetryBuilder() {
      return getRetryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If specified, then the function will be retried in case of a failure.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy.Retry retry = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.FailurePolicy.RetryOrBuilder getRetryOrBuilder() {
      if ((actionCase_ == 1) && (retryBuilder_ != null)) {
        return retryBuilder_.getMessageOrBuilder();
      } else {
        if (actionCase_ == 1) {
          return (com.google.cloud.functions.v1.FailurePolicy.Retry) action_;
        }
        return com.google.cloud.functions.v1.FailurePolicy.Retry.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, then the function will be retried in case of a failure.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.FailurePolicy.Retry retry = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.functions.v1.FailurePolicy.Retry,
            com.google.cloud.functions.v1.FailurePolicy.Retry.Builder,
            com.google.cloud.functions.v1.FailurePolicy.RetryOrBuilder>
        getRetryFieldBuilder() {
      if (retryBuilder_ == null) {
        if (!(actionCase_ == 1)) {
          action_ = com.google.cloud.functions.v1.FailurePolicy.Retry.getDefaultInstance();
        }
        retryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.functions.v1.FailurePolicy.Retry,
                com.google.cloud.functions.v1.FailurePolicy.Retry.Builder,
                com.google.cloud.functions.v1.FailurePolicy.RetryOrBuilder>(
                (com.google.cloud.functions.v1.FailurePolicy.Retry) action_,
                getParentForChildren(),
                isClean());
        action_ = null;
      }
      actionCase_ = 1;
      onChanged();
      return retryBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v1.FailurePolicy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v1.FailurePolicy)
  private static final com.google.cloud.functions.v1.FailurePolicy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v1.FailurePolicy();
  }

  public static com.google.cloud.functions.v1.FailurePolicy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FailurePolicy> PARSER =
      new com.google.protobuf.AbstractParser<FailurePolicy>() {
        @java.lang.Override
        public FailurePolicy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FailurePolicy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FailurePolicy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v1.FailurePolicy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
