/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/functions/v1/operations.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.functions.v1;

/**
 *
 *
 * <pre>
 * Metadata describing an [Operation][google.longrunning.Operation]
 * </pre>
 *
 * Protobuf type {@code google.cloud.functions.v1.OperationMetadataV1}
 */
public final class OperationMetadataV1 extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.functions.v1.OperationMetadataV1)
    OperationMetadataV1OrBuilder {
  private static final long serialVersionUID = 0L;
  // Use OperationMetadataV1.newBuilder() to construct.
  private OperationMetadataV1(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private OperationMetadataV1() {
    target_ = "";
    type_ = 0;
    buildId_ = "";
    sourceToken_ = "";
    buildName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new OperationMetadataV1();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.functions.v1.FunctionsOperationsProto
        .internal_static_google_cloud_functions_v1_OperationMetadataV1_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.functions.v1.FunctionsOperationsProto
        .internal_static_google_cloud_functions_v1_OperationMetadataV1_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.functions.v1.OperationMetadataV1.class,
            com.google.cloud.functions.v1.OperationMetadataV1.Builder.class);
  }

  private int bitField0_;
  public static final int TARGET_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object target_ = "";
  /**
   *
   *
   * <pre>
   * Target of the operation - for example
   * `projects/project-1/locations/region-1/functions/function-1`
   * </pre>
   *
   * <code>string target = 1;</code>
   *
   * @return The target.
   */
  @java.lang.Override
  public java.lang.String getTarget() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      target_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Target of the operation - for example
   * `projects/project-1/locations/region-1/functions/function-1`
   * </pre>
   *
   * <code>string target = 1;</code>
   *
   * @return The bytes for target.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTargetBytes() {
    java.lang.Object ref = target_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      target_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Type of operation.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.OperationType type = 2;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Type of operation.
   * </pre>
   *
   * <code>.google.cloud.functions.v1.OperationType type = 2;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.functions.v1.OperationType getType() {
    com.google.cloud.functions.v1.OperationType result =
        com.google.cloud.functions.v1.OperationType.forNumber(type_);
    return result == null ? com.google.cloud.functions.v1.OperationType.UNRECOGNIZED : result;
  }

  public static final int REQUEST_FIELD_NUMBER = 3;
  private com.google.protobuf.Any request_;
  /**
   *
   *
   * <pre>
   * The original request that started the operation.
   * </pre>
   *
   * <code>.google.protobuf.Any request = 3;</code>
   *
   * @return Whether the request field is set.
   */
  @java.lang.Override
  public boolean hasRequest() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The original request that started the operation.
   * </pre>
   *
   * <code>.google.protobuf.Any request = 3;</code>
   *
   * @return The request.
   */
  @java.lang.Override
  public com.google.protobuf.Any getRequest() {
    return request_ == null ? com.google.protobuf.Any.getDefaultInstance() : request_;
  }
  /**
   *
   *
   * <pre>
   * The original request that started the operation.
   * </pre>
   *
   * <code>.google.protobuf.Any request = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.AnyOrBuilder getRequestOrBuilder() {
    return request_ == null ? com.google.protobuf.Any.getDefaultInstance() : request_;
  }

  public static final int VERSION_ID_FIELD_NUMBER = 4;
  private long versionId_ = 0L;
  /**
   *
   *
   * <pre>
   * Version id of the function created or updated by an API call.
   * This field is only populated for Create and Update operations.
   * </pre>
   *
   * <code>int64 version_id = 4;</code>
   *
   * @return The versionId.
   */
  @java.lang.Override
  public long getVersionId() {
    return versionId_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * The last update timestamp of the operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * The last update timestamp of the operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * The last update timestamp of the operation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int BUILD_ID_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object buildId_ = "";
  /**
   *
   *
   * <pre>
   * The Cloud Build ID of the function created or updated by an API call.
   * This field is only populated for Create and Update operations.
   * </pre>
   *
   * <code>string build_id = 6;</code>
   *
   * @return The buildId.
   */
  @java.lang.Override
  public java.lang.String getBuildId() {
    java.lang.Object ref = buildId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      buildId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Cloud Build ID of the function created or updated by an API call.
   * This field is only populated for Create and Update operations.
   * </pre>
   *
   * <code>string build_id = 6;</code>
   *
   * @return The bytes for buildId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildIdBytes() {
    java.lang.Object ref = buildId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      buildId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_TOKEN_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceToken_ = "";
  /**
   *
   *
   * <pre>
   * An identifier for Firebase function sources. Disclaimer: This field is only
   * supported for Firebase function deployments.
   * </pre>
   *
   * <code>string source_token = 7;</code>
   *
   * @return The sourceToken.
   */
  @java.lang.Override
  public java.lang.String getSourceToken() {
    java.lang.Object ref = sourceToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * An identifier for Firebase function sources. Disclaimer: This field is only
   * supported for Firebase function deployments.
   * </pre>
   *
   * <code>string source_token = 7;</code>
   *
   * @return The bytes for sourceToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceTokenBytes() {
    java.lang.Object ref = sourceToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BUILD_NAME_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object buildName_ = "";
  /**
   *
   *
   * <pre>
   * The Cloud Build Name of the function deployment.
   * This field is only populated for Create and Update operations.
   * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
   * </pre>
   *
   * <code>string build_name = 8;</code>
   *
   * @return The buildName.
   */
  @java.lang.Override
  public java.lang.String getBuildName() {
    java.lang.Object ref = buildName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      buildName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The Cloud Build Name of the function deployment.
   * This field is only populated for Create and Update operations.
   * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
   * </pre>
   *
   * <code>string build_name = 8;</code>
   *
   * @return The bytes for buildName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBuildNameBytes() {
    java.lang.Object ref = buildName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      buildName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, target_);
    }
    if (type_ != com.google.cloud.functions.v1.OperationType.OPERATION_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, type_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getRequest());
    }
    if (versionId_ != 0L) {
      output.writeInt64(4, versionId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, buildId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, sourceToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, buildName_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, target_);
    }
    if (type_ != com.google.cloud.functions.v1.OperationType.OPERATION_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRequest());
    }
    if (versionId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, versionId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, buildId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, sourceToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(buildName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, buildName_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.functions.v1.OperationMetadataV1)) {
      return super.equals(obj);
    }
    com.google.cloud.functions.v1.OperationMetadataV1 other =
        (com.google.cloud.functions.v1.OperationMetadataV1) obj;

    if (!getTarget().equals(other.getTarget())) return false;
    if (type_ != other.type_) return false;
    if (hasRequest() != other.hasRequest()) return false;
    if (hasRequest()) {
      if (!getRequest().equals(other.getRequest())) return false;
    }
    if (getVersionId() != other.getVersionId()) return false;
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!getBuildId().equals(other.getBuildId())) return false;
    if (!getSourceToken().equals(other.getSourceToken())) return false;
    if (!getBuildName().equals(other.getBuildName())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TARGET_FIELD_NUMBER;
    hash = (53 * hash) + getTarget().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (hasRequest()) {
      hash = (37 * hash) + REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getRequest().hashCode();
    }
    hash = (37 * hash) + VERSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getVersionId());
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + BUILD_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBuildId().hashCode();
    hash = (37 * hash) + SOURCE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getSourceToken().hashCode();
    hash = (37 * hash) + BUILD_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getBuildName().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.functions.v1.OperationMetadataV1 parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.OperationMetadataV1 parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.OperationMetadataV1 parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.OperationMetadataV1 parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.OperationMetadataV1 parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.functions.v1.OperationMetadataV1 parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.OperationMetadataV1 parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.OperationMetadataV1 parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.OperationMetadataV1 parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.OperationMetadataV1 parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.functions.v1.OperationMetadataV1 parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.functions.v1.OperationMetadataV1 parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.functions.v1.OperationMetadataV1 prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata describing an [Operation][google.longrunning.Operation]
   * </pre>
   *
   * Protobuf type {@code google.cloud.functions.v1.OperationMetadataV1}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.functions.v1.OperationMetadataV1)
      com.google.cloud.functions.v1.OperationMetadataV1OrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.functions.v1.FunctionsOperationsProto
          .internal_static_google_cloud_functions_v1_OperationMetadataV1_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.functions.v1.FunctionsOperationsProto
          .internal_static_google_cloud_functions_v1_OperationMetadataV1_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.functions.v1.OperationMetadataV1.class,
              com.google.cloud.functions.v1.OperationMetadataV1.Builder.class);
    }

    // Construct using com.google.cloud.functions.v1.OperationMetadataV1.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRequestFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      target_ = "";
      type_ = 0;
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      versionId_ = 0L;
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      buildId_ = "";
      sourceToken_ = "";
      buildName_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.functions.v1.FunctionsOperationsProto
          .internal_static_google_cloud_functions_v1_OperationMetadataV1_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.OperationMetadataV1 getDefaultInstanceForType() {
      return com.google.cloud.functions.v1.OperationMetadataV1.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.OperationMetadataV1 build() {
      com.google.cloud.functions.v1.OperationMetadataV1 result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.functions.v1.OperationMetadataV1 buildPartial() {
      com.google.cloud.functions.v1.OperationMetadataV1 result =
          new com.google.cloud.functions.v1.OperationMetadataV1(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.functions.v1.OperationMetadataV1 result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.target_ = target_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.request_ = requestBuilder_ == null ? request_ : requestBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.versionId_ = versionId_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.buildId_ = buildId_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.sourceToken_ = sourceToken_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.buildName_ = buildName_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.functions.v1.OperationMetadataV1) {
        return mergeFrom((com.google.cloud.functions.v1.OperationMetadataV1) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.functions.v1.OperationMetadataV1 other) {
      if (other == com.google.cloud.functions.v1.OperationMetadataV1.getDefaultInstance())
        return this;
      if (!other.getTarget().isEmpty()) {
        target_ = other.target_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.hasRequest()) {
        mergeRequest(other.getRequest());
      }
      if (other.getVersionId() != 0L) {
        setVersionId(other.getVersionId());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (!other.getBuildId().isEmpty()) {
        buildId_ = other.buildId_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getSourceToken().isEmpty()) {
        sourceToken_ = other.sourceToken_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getBuildName().isEmpty()) {
        buildName_ = other.buildName_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                target_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getRequestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                versionId_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                buildId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                sourceToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                buildName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object target_ = "";
    /**
     *
     *
     * <pre>
     * Target of the operation - for example
     * `projects/project-1/locations/region-1/functions/function-1`
     * </pre>
     *
     * <code>string target = 1;</code>
     *
     * @return The target.
     */
    public java.lang.String getTarget() {
      java.lang.Object ref = target_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        target_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Target of the operation - for example
     * `projects/project-1/locations/region-1/functions/function-1`
     * </pre>
     *
     * <code>string target = 1;</code>
     *
     * @return The bytes for target.
     */
    public com.google.protobuf.ByteString getTargetBytes() {
      java.lang.Object ref = target_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        target_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Target of the operation - for example
     * `projects/project-1/locations/region-1/functions/function-1`
     * </pre>
     *
     * <code>string target = 1;</code>
     *
     * @param value The target to set.
     * @return This builder for chaining.
     */
    public Builder setTarget(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      target_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target of the operation - for example
     * `projects/project-1/locations/region-1/functions/function-1`
     * </pre>
     *
     * <code>string target = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTarget() {
      target_ = getDefaultInstance().getTarget();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Target of the operation - for example
     * `projects/project-1/locations/region-1/functions/function-1`
     * </pre>
     *
     * <code>string target = 1;</code>
     *
     * @param value The bytes for target to set.
     * @return This builder for chaining.
     */
    public Builder setTargetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      target_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Type of operation.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.OperationType type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Type of operation.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.OperationType type = 2;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of operation.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.OperationType type = 2;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.functions.v1.OperationType getType() {
      com.google.cloud.functions.v1.OperationType result =
          com.google.cloud.functions.v1.OperationType.forNumber(type_);
      return result == null ? com.google.cloud.functions.v1.OperationType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Type of operation.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.OperationType type = 2;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.functions.v1.OperationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of operation.
     * </pre>
     *
     * <code>.google.cloud.functions.v1.OperationType type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Any request_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Any,
            com.google.protobuf.Any.Builder,
            com.google.protobuf.AnyOrBuilder>
        requestBuilder_;
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request = 3;</code>
     *
     * @return Whether the request field is set.
     */
    public boolean hasRequest() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request = 3;</code>
     *
     * @return The request.
     */
    public com.google.protobuf.Any getRequest() {
      if (requestBuilder_ == null) {
        return request_ == null ? com.google.protobuf.Any.getDefaultInstance() : request_;
      } else {
        return requestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request = 3;</code>
     */
    public Builder setRequest(com.google.protobuf.Any value) {
      if (requestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        request_ = value;
      } else {
        requestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request = 3;</code>
     */
    public Builder setRequest(com.google.protobuf.Any.Builder builderForValue) {
      if (requestBuilder_ == null) {
        request_ = builderForValue.build();
      } else {
        requestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request = 3;</code>
     */
    public Builder mergeRequest(com.google.protobuf.Any value) {
      if (requestBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && request_ != null
            && request_ != com.google.protobuf.Any.getDefaultInstance()) {
          getRequestBuilder().mergeFrom(value);
        } else {
          request_ = value;
        }
      } else {
        requestBuilder_.mergeFrom(value);
      }
      if (request_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request = 3;</code>
     */
    public Builder clearRequest() {
      bitField0_ = (bitField0_ & ~0x00000004);
      request_ = null;
      if (requestBuilder_ != null) {
        requestBuilder_.dispose();
        requestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request = 3;</code>
     */
    public com.google.protobuf.Any.Builder getRequestBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request = 3;</code>
     */
    public com.google.protobuf.AnyOrBuilder getRequestOrBuilder() {
      if (requestBuilder_ != null) {
        return requestBuilder_.getMessageOrBuilder();
      } else {
        return request_ == null ? com.google.protobuf.Any.getDefaultInstance() : request_;
      }
    }
    /**
     *
     *
     * <pre>
     * The original request that started the operation.
     * </pre>
     *
     * <code>.google.protobuf.Any request = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Any,
            com.google.protobuf.Any.Builder,
            com.google.protobuf.AnyOrBuilder>
        getRequestFieldBuilder() {
      if (requestBuilder_ == null) {
        requestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Any,
                com.google.protobuf.Any.Builder,
                com.google.protobuf.AnyOrBuilder>(getRequest(), getParentForChildren(), isClean());
        request_ = null;
      }
      return requestBuilder_;
    }

    private long versionId_;
    /**
     *
     *
     * <pre>
     * Version id of the function created or updated by an API call.
     * This field is only populated for Create and Update operations.
     * </pre>
     *
     * <code>int64 version_id = 4;</code>
     *
     * @return The versionId.
     */
    @java.lang.Override
    public long getVersionId() {
      return versionId_;
    }
    /**
     *
     *
     * <pre>
     * Version id of the function created or updated by an API call.
     * This field is only populated for Create and Update operations.
     * </pre>
     *
     * <code>int64 version_id = 4;</code>
     *
     * @param value The versionId to set.
     * @return This builder for chaining.
     */
    public Builder setVersionId(long value) {

      versionId_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Version id of the function created or updated by an API call.
     * This field is only populated for Create and Update operations.
     * </pre>
     *
     * <code>int64 version_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionId() {
      bitField0_ = (bitField0_ & ~0x00000008);
      versionId_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The last update timestamp of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The last update timestamp of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The last update timestamp of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last update timestamp of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last update timestamp of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last update timestamp of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last update timestamp of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The last update timestamp of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The last update timestamp of the operation.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private java.lang.Object buildId_ = "";
    /**
     *
     *
     * <pre>
     * The Cloud Build ID of the function created or updated by an API call.
     * This field is only populated for Create and Update operations.
     * </pre>
     *
     * <code>string build_id = 6;</code>
     *
     * @return The buildId.
     */
    public java.lang.String getBuildId() {
      java.lang.Object ref = buildId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        buildId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Build ID of the function created or updated by an API call.
     * This field is only populated for Create and Update operations.
     * </pre>
     *
     * <code>string build_id = 6;</code>
     *
     * @return The bytes for buildId.
     */
    public com.google.protobuf.ByteString getBuildIdBytes() {
      java.lang.Object ref = buildId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        buildId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Build ID of the function created or updated by an API call.
     * This field is only populated for Create and Update operations.
     * </pre>
     *
     * <code>string build_id = 6;</code>
     *
     * @param value The buildId to set.
     * @return This builder for chaining.
     */
    public Builder setBuildId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      buildId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Build ID of the function created or updated by an API call.
     * This field is only populated for Create and Update operations.
     * </pre>
     *
     * <code>string build_id = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildId() {
      buildId_ = getDefaultInstance().getBuildId();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Build ID of the function created or updated by an API call.
     * This field is only populated for Create and Update operations.
     * </pre>
     *
     * <code>string build_id = 6;</code>
     *
     * @param value The bytes for buildId to set.
     * @return This builder for chaining.
     */
    public Builder setBuildIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      buildId_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object sourceToken_ = "";
    /**
     *
     *
     * <pre>
     * An identifier for Firebase function sources. Disclaimer: This field is only
     * supported for Firebase function deployments.
     * </pre>
     *
     * <code>string source_token = 7;</code>
     *
     * @return The sourceToken.
     */
    public java.lang.String getSourceToken() {
      java.lang.Object ref = sourceToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An identifier for Firebase function sources. Disclaimer: This field is only
     * supported for Firebase function deployments.
     * </pre>
     *
     * <code>string source_token = 7;</code>
     *
     * @return The bytes for sourceToken.
     */
    public com.google.protobuf.ByteString getSourceTokenBytes() {
      java.lang.Object ref = sourceToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * An identifier for Firebase function sources. Disclaimer: This field is only
     * supported for Firebase function deployments.
     * </pre>
     *
     * <code>string source_token = 7;</code>
     *
     * @param value The sourceToken to set.
     * @return This builder for chaining.
     */
    public Builder setSourceToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceToken_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An identifier for Firebase function sources. Disclaimer: This field is only
     * supported for Firebase function deployments.
     * </pre>
     *
     * <code>string source_token = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceToken() {
      sourceToken_ = getDefaultInstance().getSourceToken();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An identifier for Firebase function sources. Disclaimer: This field is only
     * supported for Firebase function deployments.
     * </pre>
     *
     * <code>string source_token = 7;</code>
     *
     * @param value The bytes for sourceToken to set.
     * @return This builder for chaining.
     */
    public Builder setSourceTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceToken_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object buildName_ = "";
    /**
     *
     *
     * <pre>
     * The Cloud Build Name of the function deployment.
     * This field is only populated for Create and Update operations.
     * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
     * </pre>
     *
     * <code>string build_name = 8;</code>
     *
     * @return The buildName.
     */
    public java.lang.String getBuildName() {
      java.lang.Object ref = buildName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        buildName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Build Name of the function deployment.
     * This field is only populated for Create and Update operations.
     * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
     * </pre>
     *
     * <code>string build_name = 8;</code>
     *
     * @return The bytes for buildName.
     */
    public com.google.protobuf.ByteString getBuildNameBytes() {
      java.lang.Object ref = buildName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        buildName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The Cloud Build Name of the function deployment.
     * This field is only populated for Create and Update operations.
     * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
     * </pre>
     *
     * <code>string build_name = 8;</code>
     *
     * @param value The buildName to set.
     * @return This builder for chaining.
     */
    public Builder setBuildName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      buildName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Build Name of the function deployment.
     * This field is only populated for Create and Update operations.
     * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
     * </pre>
     *
     * <code>string build_name = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBuildName() {
      buildName_ = getDefaultInstance().getBuildName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Cloud Build Name of the function deployment.
     * This field is only populated for Create and Update operations.
     * `projects/&lt;project-number&gt;/locations/&lt;region&gt;/builds/&lt;build-id&gt;`.
     * </pre>
     *
     * <code>string build_name = 8;</code>
     *
     * @param value The bytes for buildName to set.
     * @return This builder for chaining.
     */
    public Builder setBuildNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      buildName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.functions.v1.OperationMetadataV1)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.functions.v1.OperationMetadataV1)
  private static final com.google.cloud.functions.v1.OperationMetadataV1 DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.functions.v1.OperationMetadataV1();
  }

  public static com.google.cloud.functions.v1.OperationMetadataV1 getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<OperationMetadataV1> PARSER =
      new com.google.protobuf.AbstractParser<OperationMetadataV1>() {
        @java.lang.Override
        public OperationMetadataV1 parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<OperationMetadataV1> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<OperationMetadataV1> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.functions.v1.OperationMetadataV1 getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
