/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EngineName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_ENGINE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/engines/{engine}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String collection;
    private final String engine;

    @Deprecated
    protected EngineName() {
        this.project = null;
        this.location = null;
        this.collection = null;
        this.engine = null;
    }

    private EngineName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.engine = (String)Preconditions.checkNotNull((Object)builder.getEngine());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getEngine() {
        return this.engine;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static EngineName of(String project, String location, String collection, String engine) {
        return EngineName.newBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).build();
    }

    public static String format(String project, String location, String collection, String engine) {
        return EngineName.newBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).build().toString();
    }

    public static EngineName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_COLLECTION_ENGINE.validatedMatch(formattedString, "EngineName.parse: formattedString not in valid format");
        return EngineName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("engine"));
    }

    public static List<EngineName> parseList(List<String> formattedStrings) {
        ArrayList<EngineName> list = new ArrayList<EngineName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(EngineName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<EngineName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (EngineName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_COLLECTION_ENGINE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            EngineName engineName = this;
            synchronized (engineName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    if (this.engine != null) {
                        fieldMapBuilder.put((Object)"engine", (Object)this.engine);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_COLLECTION_ENGINE.instantiate(new String[]{"project", this.project, "location", this.location, "collection", this.collection, "engine", this.engine});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            EngineName that = (EngineName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.collection, that.collection) && Objects.equals(this.engine, that.engine);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.collection);
        h *= 1000003;
        return h ^= Objects.hashCode(this.engine);
    }

    public static class Builder {
        private String project;
        private String location;
        private String collection;
        private String engine;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getEngine() {
            return this.engine;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public Builder setEngine(String engine) {
            this.engine = engine;
            return this;
        }

        private Builder(EngineName engineName) {
            this.project = engineName.project;
            this.location = engineName.location;
            this.collection = engineName.collection;
            this.engine = engineName.engine;
        }

        public EngineName build() {
            return new EngineName(this);
        }
    }
}

