/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversationProfileName
implements ResourceName {
    private static final PathTemplate PROJECT_CONVERSATION_PROFILE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/conversationProfiles/{conversation_profile}");
    private static final PathTemplate PROJECT_LOCATION_CONVERSATION_PROFILE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/conversationProfiles/{conversation_profile}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String conversationProfile;
    private final String location;

    @Deprecated
    protected ConversationProfileName() {
        this.project = null;
        this.conversationProfile = null;
        this.location = null;
    }

    private ConversationProfileName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.conversationProfile = (String)Preconditions.checkNotNull((Object)builder.getConversationProfile());
        this.location = null;
        this.pathTemplate = PROJECT_CONVERSATION_PROFILE;
    }

    private ConversationProfileName(ProjectLocationConversationProfileBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.conversationProfile = (String)Preconditions.checkNotNull((Object)builder.getConversationProfile());
        this.pathTemplate = PROJECT_LOCATION_CONVERSATION_PROFILE;
    }

    public String getProject() {
        return this.project;
    }

    public String getConversationProfile() {
        return this.conversationProfile;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectConversationProfileBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationConversationProfileBuilder newProjectLocationConversationProfileBuilder() {
        return new ProjectLocationConversationProfileBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversationProfileName of(String project, String conversationProfile) {
        return ConversationProfileName.newBuilder().setProject(project).setConversationProfile(conversationProfile).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ConversationProfileName ofProjectConversationProfileName(String project, String conversationProfile) {
        return ConversationProfileName.newBuilder().setProject(project).setConversationProfile(conversationProfile).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static ConversationProfileName ofProjectLocationConversationProfileName(String project, String location, String conversationProfile) {
        return ConversationProfileName.newProjectLocationConversationProfileBuilder().setProject(project).setLocation(location).setConversationProfile(conversationProfile).build();
    }

    public static String format(String project, String conversationProfile) {
        return ConversationProfileName.newBuilder().setProject(project).setConversationProfile(conversationProfile).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectConversationProfileName(String project, String conversationProfile) {
        return ConversationProfileName.newBuilder().setProject(project).setConversationProfile(conversationProfile).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationConversationProfileName(String project, String location, String conversationProfile) {
        return ConversationProfileName.newProjectLocationConversationProfileBuilder().setProject(project).setLocation(location).setConversationProfile(conversationProfile).build().toString();
    }

    public static ConversationProfileName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_CONVERSATION_PROFILE.matches(formattedString)) {
            Map matchMap = PROJECT_CONVERSATION_PROFILE.match(formattedString);
            return ConversationProfileName.ofProjectConversationProfileName((String)matchMap.get("project"), (String)matchMap.get("conversation_profile"));
        }
        if (PROJECT_LOCATION_CONVERSATION_PROFILE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_CONVERSATION_PROFILE.match(formattedString);
            return ConversationProfileName.ofProjectLocationConversationProfileName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("conversation_profile"));
        }
        throw new ValidationException("ConversationProfileName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ConversationProfileName> parseList(List<String> formattedStrings) {
        ArrayList<ConversationProfileName> list = new ArrayList<ConversationProfileName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversationProfileName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversationProfileName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversationProfileName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_CONVERSATION_PROFILE.matches(formattedString) || PROJECT_LOCATION_CONVERSATION_PROFILE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversationProfileName conversationProfileName = this;
            synchronized (conversationProfileName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.conversationProfile != null) {
                        fieldMapBuilder.put((Object)"conversation_profile", (Object)this.conversationProfile);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ConversationProfileName that = (ConversationProfileName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.conversationProfile, that.conversationProfile) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.conversationProfile);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationConversationProfileBuilder {
        private String project;
        private String location;
        private String conversationProfile;

        protected ProjectLocationConversationProfileBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getConversationProfile() {
            return this.conversationProfile;
        }

        public ProjectLocationConversationProfileBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationConversationProfileBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationConversationProfileBuilder setConversationProfile(String conversationProfile) {
            this.conversationProfile = conversationProfile;
            return this;
        }

        public ConversationProfileName build() {
            return new ConversationProfileName(this);
        }
    }

    public static class Builder {
        private String project;
        private String conversationProfile;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getConversationProfile() {
            return this.conversationProfile;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setConversationProfile(String conversationProfile) {
            this.conversationProfile = conversationProfile;
            return this;
        }

        private Builder(ConversationProfileName conversationProfileName) {
            Preconditions.checkArgument((boolean)Objects.equals(conversationProfileName.pathTemplate, PROJECT_CONVERSATION_PROFILE), (Object)"toBuilder is only supported when ConversationProfileName has the pattern of projects/{project}/conversationProfiles/{conversation_profile}");
            this.project = conversationProfileName.project;
            this.conversationProfile = conversationProfileName.conversationProfile;
        }

        public ConversationProfileName build() {
            return new ConversationProfileName(this);
        }
    }
}

