/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/request_stats.proto

package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * RequestStats is the container for additional information pertaining to a
 * single request, helpful for evaluating the performance of the sent request.
 * Currently, there are the following supported methods:
 *   * google.bigtable.v2.ReadRows
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.RequestStats}
 */
public final class RequestStats extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.RequestStats)
    RequestStatsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RequestStats.newBuilder() to construct.
  private RequestStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RequestStats() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RequestStats();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.RequestStatsProto
        .internal_static_google_bigtable_v2_RequestStats_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.RequestStatsProto
        .internal_static_google_bigtable_v2_RequestStats_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.RequestStats.class,
            com.google.bigtable.v2.RequestStats.Builder.class);
  }

  private int statsCase_ = 0;
  private java.lang.Object stats_;

  public enum StatsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    READ_EFFICIENCY_STATS(1),
    ALL_READ_STATS(2),
    STATS_NOT_SET(0);
    private final int value;

    private StatsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StatsCase valueOf(int value) {
      return forNumber(value);
    }

    public static StatsCase forNumber(int value) {
      switch (value) {
        case 1:
          return READ_EFFICIENCY_STATS;
        case 2:
          return ALL_READ_STATS;
        case 0:
          return STATS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public StatsCase getStatsCase() {
    return StatsCase.forNumber(statsCase_);
  }

  public static final int READ_EFFICIENCY_STATS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Available with the
   * ReadRowsRequest.RequestStatsView.REQUEST_STATS_EFFICIENCY view, see
   * package google.bigtable.v2.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadEfficiencyStats read_efficiency_stats = 1;</code>
   *
   * @return Whether the readEfficiencyStats field is set.
   */
  @java.lang.Override
  public boolean hasReadEfficiencyStats() {
    return statsCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Available with the
   * ReadRowsRequest.RequestStatsView.REQUEST_STATS_EFFICIENCY view, see
   * package google.bigtable.v2.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadEfficiencyStats read_efficiency_stats = 1;</code>
   *
   * @return The readEfficiencyStats.
   */
  @java.lang.Override
  public com.google.bigtable.v2.ReadEfficiencyStats getReadEfficiencyStats() {
    if (statsCase_ == 1) {
      return (com.google.bigtable.v2.ReadEfficiencyStats) stats_;
    }
    return com.google.bigtable.v2.ReadEfficiencyStats.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Available with the
   * ReadRowsRequest.RequestStatsView.REQUEST_STATS_EFFICIENCY view, see
   * package google.bigtable.v2.
   * </pre>
   *
   * <code>.google.bigtable.v2.ReadEfficiencyStats read_efficiency_stats = 1;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.ReadEfficiencyStatsOrBuilder getReadEfficiencyStatsOrBuilder() {
    if (statsCase_ == 1) {
      return (com.google.bigtable.v2.ReadEfficiencyStats) stats_;
    }
    return com.google.bigtable.v2.ReadEfficiencyStats.getDefaultInstance();
  }

  public static final int ALL_READ_STATS_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Available with the ReadRowsRequest.RequestStatsView.REQUEST_STATS_FULL
   * view, see package google.bigtable.v2.
   * </pre>
   *
   * <code>.google.bigtable.v2.AllReadStats all_read_stats = 2;</code>
   *
   * @return Whether the allReadStats field is set.
   */
  @java.lang.Override
  public boolean hasAllReadStats() {
    return statsCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Available with the ReadRowsRequest.RequestStatsView.REQUEST_STATS_FULL
   * view, see package google.bigtable.v2.
   * </pre>
   *
   * <code>.google.bigtable.v2.AllReadStats all_read_stats = 2;</code>
   *
   * @return The allReadStats.
   */
  @java.lang.Override
  public com.google.bigtable.v2.AllReadStats getAllReadStats() {
    if (statsCase_ == 2) {
      return (com.google.bigtable.v2.AllReadStats) stats_;
    }
    return com.google.bigtable.v2.AllReadStats.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Available with the ReadRowsRequest.RequestStatsView.REQUEST_STATS_FULL
   * view, see package google.bigtable.v2.
   * </pre>
   *
   * <code>.google.bigtable.v2.AllReadStats all_read_stats = 2;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.AllReadStatsOrBuilder getAllReadStatsOrBuilder() {
    if (statsCase_ == 2) {
      return (com.google.bigtable.v2.AllReadStats) stats_;
    }
    return com.google.bigtable.v2.AllReadStats.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (statsCase_ == 1) {
      output.writeMessage(1, (com.google.bigtable.v2.ReadEfficiencyStats) stats_);
    }
    if (statsCase_ == 2) {
      output.writeMessage(2, (com.google.bigtable.v2.AllReadStats) stats_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (statsCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.bigtable.v2.ReadEfficiencyStats) stats_);
    }
    if (statsCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.bigtable.v2.AllReadStats) stats_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.RequestStats)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.RequestStats other = (com.google.bigtable.v2.RequestStats) obj;

    if (!getStatsCase().equals(other.getStatsCase())) return false;
    switch (statsCase_) {
      case 1:
        if (!getReadEfficiencyStats().equals(other.getReadEfficiencyStats())) return false;
        break;
      case 2:
        if (!getAllReadStats().equals(other.getAllReadStats())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (statsCase_) {
      case 1:
        hash = (37 * hash) + READ_EFFICIENCY_STATS_FIELD_NUMBER;
        hash = (53 * hash) + getReadEfficiencyStats().hashCode();
        break;
      case 2:
        hash = (37 * hash) + ALL_READ_STATS_FIELD_NUMBER;
        hash = (53 * hash) + getAllReadStats().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.RequestStats parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.RequestStats parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.RequestStats parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.RequestStats parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.RequestStats parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.RequestStats parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.RequestStats parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.RequestStats parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.RequestStats parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.RequestStats parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.RequestStats parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.RequestStats parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.RequestStats prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * RequestStats is the container for additional information pertaining to a
   * single request, helpful for evaluating the performance of the sent request.
   * Currently, there are the following supported methods:
   *   * google.bigtable.v2.ReadRows
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.RequestStats}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.RequestStats)
      com.google.bigtable.v2.RequestStatsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.RequestStatsProto
          .internal_static_google_bigtable_v2_RequestStats_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.RequestStatsProto
          .internal_static_google_bigtable_v2_RequestStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.RequestStats.class,
              com.google.bigtable.v2.RequestStats.Builder.class);
    }

    // Construct using com.google.bigtable.v2.RequestStats.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (readEfficiencyStatsBuilder_ != null) {
        readEfficiencyStatsBuilder_.clear();
      }
      if (allReadStatsBuilder_ != null) {
        allReadStatsBuilder_.clear();
      }
      statsCase_ = 0;
      stats_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.RequestStatsProto
          .internal_static_google_bigtable_v2_RequestStats_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.RequestStats getDefaultInstanceForType() {
      return com.google.bigtable.v2.RequestStats.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.RequestStats build() {
      com.google.bigtable.v2.RequestStats result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.RequestStats buildPartial() {
      com.google.bigtable.v2.RequestStats result = new com.google.bigtable.v2.RequestStats(this);
      if (statsCase_ == 1) {
        if (readEfficiencyStatsBuilder_ == null) {
          result.stats_ = stats_;
        } else {
          result.stats_ = readEfficiencyStatsBuilder_.build();
        }
      }
      if (statsCase_ == 2) {
        if (allReadStatsBuilder_ == null) {
          result.stats_ = stats_;
        } else {
          result.stats_ = allReadStatsBuilder_.build();
        }
      }
      result.statsCase_ = statsCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.RequestStats) {
        return mergeFrom((com.google.bigtable.v2.RequestStats) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.RequestStats other) {
      if (other == com.google.bigtable.v2.RequestStats.getDefaultInstance()) return this;
      switch (other.getStatsCase()) {
        case READ_EFFICIENCY_STATS:
          {
            mergeReadEfficiencyStats(other.getReadEfficiencyStats());
            break;
          }
        case ALL_READ_STATS:
          {
            mergeAllReadStats(other.getAllReadStats());
            break;
          }
        case STATS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getReadEfficiencyStatsFieldBuilder().getBuilder(), extensionRegistry);
                statsCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getAllReadStatsFieldBuilder().getBuilder(), extensionRegistry);
                statsCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int statsCase_ = 0;
    private java.lang.Object stats_;

    public StatsCase getStatsCase() {
      return StatsCase.forNumber(statsCase_);
    }

    public Builder clearStats() {
      statsCase_ = 0;
      stats_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ReadEfficiencyStats,
            com.google.bigtable.v2.ReadEfficiencyStats.Builder,
            com.google.bigtable.v2.ReadEfficiencyStatsOrBuilder>
        readEfficiencyStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Available with the
     * ReadRowsRequest.RequestStatsView.REQUEST_STATS_EFFICIENCY view, see
     * package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadEfficiencyStats read_efficiency_stats = 1;</code>
     *
     * @return Whether the readEfficiencyStats field is set.
     */
    @java.lang.Override
    public boolean hasReadEfficiencyStats() {
      return statsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Available with the
     * ReadRowsRequest.RequestStatsView.REQUEST_STATS_EFFICIENCY view, see
     * package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadEfficiencyStats read_efficiency_stats = 1;</code>
     *
     * @return The readEfficiencyStats.
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadEfficiencyStats getReadEfficiencyStats() {
      if (readEfficiencyStatsBuilder_ == null) {
        if (statsCase_ == 1) {
          return (com.google.bigtable.v2.ReadEfficiencyStats) stats_;
        }
        return com.google.bigtable.v2.ReadEfficiencyStats.getDefaultInstance();
      } else {
        if (statsCase_ == 1) {
          return readEfficiencyStatsBuilder_.getMessage();
        }
        return com.google.bigtable.v2.ReadEfficiencyStats.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Available with the
     * ReadRowsRequest.RequestStatsView.REQUEST_STATS_EFFICIENCY view, see
     * package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadEfficiencyStats read_efficiency_stats = 1;</code>
     */
    public Builder setReadEfficiencyStats(com.google.bigtable.v2.ReadEfficiencyStats value) {
      if (readEfficiencyStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stats_ = value;
        onChanged();
      } else {
        readEfficiencyStatsBuilder_.setMessage(value);
      }
      statsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available with the
     * ReadRowsRequest.RequestStatsView.REQUEST_STATS_EFFICIENCY view, see
     * package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadEfficiencyStats read_efficiency_stats = 1;</code>
     */
    public Builder setReadEfficiencyStats(
        com.google.bigtable.v2.ReadEfficiencyStats.Builder builderForValue) {
      if (readEfficiencyStatsBuilder_ == null) {
        stats_ = builderForValue.build();
        onChanged();
      } else {
        readEfficiencyStatsBuilder_.setMessage(builderForValue.build());
      }
      statsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available with the
     * ReadRowsRequest.RequestStatsView.REQUEST_STATS_EFFICIENCY view, see
     * package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadEfficiencyStats read_efficiency_stats = 1;</code>
     */
    public Builder mergeReadEfficiencyStats(com.google.bigtable.v2.ReadEfficiencyStats value) {
      if (readEfficiencyStatsBuilder_ == null) {
        if (statsCase_ == 1
            && stats_ != com.google.bigtable.v2.ReadEfficiencyStats.getDefaultInstance()) {
          stats_ =
              com.google.bigtable.v2.ReadEfficiencyStats.newBuilder(
                      (com.google.bigtable.v2.ReadEfficiencyStats) stats_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stats_ = value;
        }
        onChanged();
      } else {
        if (statsCase_ == 1) {
          readEfficiencyStatsBuilder_.mergeFrom(value);
        } else {
          readEfficiencyStatsBuilder_.setMessage(value);
        }
      }
      statsCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available with the
     * ReadRowsRequest.RequestStatsView.REQUEST_STATS_EFFICIENCY view, see
     * package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadEfficiencyStats read_efficiency_stats = 1;</code>
     */
    public Builder clearReadEfficiencyStats() {
      if (readEfficiencyStatsBuilder_ == null) {
        if (statsCase_ == 1) {
          statsCase_ = 0;
          stats_ = null;
          onChanged();
        }
      } else {
        if (statsCase_ == 1) {
          statsCase_ = 0;
          stats_ = null;
        }
        readEfficiencyStatsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available with the
     * ReadRowsRequest.RequestStatsView.REQUEST_STATS_EFFICIENCY view, see
     * package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadEfficiencyStats read_efficiency_stats = 1;</code>
     */
    public com.google.bigtable.v2.ReadEfficiencyStats.Builder getReadEfficiencyStatsBuilder() {
      return getReadEfficiencyStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Available with the
     * ReadRowsRequest.RequestStatsView.REQUEST_STATS_EFFICIENCY view, see
     * package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadEfficiencyStats read_efficiency_stats = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ReadEfficiencyStatsOrBuilder getReadEfficiencyStatsOrBuilder() {
      if ((statsCase_ == 1) && (readEfficiencyStatsBuilder_ != null)) {
        return readEfficiencyStatsBuilder_.getMessageOrBuilder();
      } else {
        if (statsCase_ == 1) {
          return (com.google.bigtable.v2.ReadEfficiencyStats) stats_;
        }
        return com.google.bigtable.v2.ReadEfficiencyStats.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Available with the
     * ReadRowsRequest.RequestStatsView.REQUEST_STATS_EFFICIENCY view, see
     * package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.ReadEfficiencyStats read_efficiency_stats = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ReadEfficiencyStats,
            com.google.bigtable.v2.ReadEfficiencyStats.Builder,
            com.google.bigtable.v2.ReadEfficiencyStatsOrBuilder>
        getReadEfficiencyStatsFieldBuilder() {
      if (readEfficiencyStatsBuilder_ == null) {
        if (!(statsCase_ == 1)) {
          stats_ = com.google.bigtable.v2.ReadEfficiencyStats.getDefaultInstance();
        }
        readEfficiencyStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.ReadEfficiencyStats,
                com.google.bigtable.v2.ReadEfficiencyStats.Builder,
                com.google.bigtable.v2.ReadEfficiencyStatsOrBuilder>(
                (com.google.bigtable.v2.ReadEfficiencyStats) stats_,
                getParentForChildren(),
                isClean());
        stats_ = null;
      }
      statsCase_ = 1;
      onChanged();
      ;
      return readEfficiencyStatsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.AllReadStats,
            com.google.bigtable.v2.AllReadStats.Builder,
            com.google.bigtable.v2.AllReadStatsOrBuilder>
        allReadStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Available with the ReadRowsRequest.RequestStatsView.REQUEST_STATS_FULL
     * view, see package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.AllReadStats all_read_stats = 2;</code>
     *
     * @return Whether the allReadStats field is set.
     */
    @java.lang.Override
    public boolean hasAllReadStats() {
      return statsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Available with the ReadRowsRequest.RequestStatsView.REQUEST_STATS_FULL
     * view, see package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.AllReadStats all_read_stats = 2;</code>
     *
     * @return The allReadStats.
     */
    @java.lang.Override
    public com.google.bigtable.v2.AllReadStats getAllReadStats() {
      if (allReadStatsBuilder_ == null) {
        if (statsCase_ == 2) {
          return (com.google.bigtable.v2.AllReadStats) stats_;
        }
        return com.google.bigtable.v2.AllReadStats.getDefaultInstance();
      } else {
        if (statsCase_ == 2) {
          return allReadStatsBuilder_.getMessage();
        }
        return com.google.bigtable.v2.AllReadStats.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Available with the ReadRowsRequest.RequestStatsView.REQUEST_STATS_FULL
     * view, see package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.AllReadStats all_read_stats = 2;</code>
     */
    public Builder setAllReadStats(com.google.bigtable.v2.AllReadStats value) {
      if (allReadStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stats_ = value;
        onChanged();
      } else {
        allReadStatsBuilder_.setMessage(value);
      }
      statsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available with the ReadRowsRequest.RequestStatsView.REQUEST_STATS_FULL
     * view, see package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.AllReadStats all_read_stats = 2;</code>
     */
    public Builder setAllReadStats(com.google.bigtable.v2.AllReadStats.Builder builderForValue) {
      if (allReadStatsBuilder_ == null) {
        stats_ = builderForValue.build();
        onChanged();
      } else {
        allReadStatsBuilder_.setMessage(builderForValue.build());
      }
      statsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available with the ReadRowsRequest.RequestStatsView.REQUEST_STATS_FULL
     * view, see package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.AllReadStats all_read_stats = 2;</code>
     */
    public Builder mergeAllReadStats(com.google.bigtable.v2.AllReadStats value) {
      if (allReadStatsBuilder_ == null) {
        if (statsCase_ == 2 && stats_ != com.google.bigtable.v2.AllReadStats.getDefaultInstance()) {
          stats_ =
              com.google.bigtable.v2.AllReadStats.newBuilder(
                      (com.google.bigtable.v2.AllReadStats) stats_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stats_ = value;
        }
        onChanged();
      } else {
        if (statsCase_ == 2) {
          allReadStatsBuilder_.mergeFrom(value);
        } else {
          allReadStatsBuilder_.setMessage(value);
        }
      }
      statsCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available with the ReadRowsRequest.RequestStatsView.REQUEST_STATS_FULL
     * view, see package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.AllReadStats all_read_stats = 2;</code>
     */
    public Builder clearAllReadStats() {
      if (allReadStatsBuilder_ == null) {
        if (statsCase_ == 2) {
          statsCase_ = 0;
          stats_ = null;
          onChanged();
        }
      } else {
        if (statsCase_ == 2) {
          statsCase_ = 0;
          stats_ = null;
        }
        allReadStatsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Available with the ReadRowsRequest.RequestStatsView.REQUEST_STATS_FULL
     * view, see package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.AllReadStats all_read_stats = 2;</code>
     */
    public com.google.bigtable.v2.AllReadStats.Builder getAllReadStatsBuilder() {
      return getAllReadStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Available with the ReadRowsRequest.RequestStatsView.REQUEST_STATS_FULL
     * view, see package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.AllReadStats all_read_stats = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.AllReadStatsOrBuilder getAllReadStatsOrBuilder() {
      if ((statsCase_ == 2) && (allReadStatsBuilder_ != null)) {
        return allReadStatsBuilder_.getMessageOrBuilder();
      } else {
        if (statsCase_ == 2) {
          return (com.google.bigtable.v2.AllReadStats) stats_;
        }
        return com.google.bigtable.v2.AllReadStats.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Available with the ReadRowsRequest.RequestStatsView.REQUEST_STATS_FULL
     * view, see package google.bigtable.v2.
     * </pre>
     *
     * <code>.google.bigtable.v2.AllReadStats all_read_stats = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.AllReadStats,
            com.google.bigtable.v2.AllReadStats.Builder,
            com.google.bigtable.v2.AllReadStatsOrBuilder>
        getAllReadStatsFieldBuilder() {
      if (allReadStatsBuilder_ == null) {
        if (!(statsCase_ == 2)) {
          stats_ = com.google.bigtable.v2.AllReadStats.getDefaultInstance();
        }
        allReadStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.AllReadStats,
                com.google.bigtable.v2.AllReadStats.Builder,
                com.google.bigtable.v2.AllReadStatsOrBuilder>(
                (com.google.bigtable.v2.AllReadStats) stats_, getParentForChildren(), isClean());
        stats_ = null;
      }
      statsCase_ = 2;
      onChanged();
      ;
      return allReadStatsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.RequestStats)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.RequestStats)
  private static final com.google.bigtable.v2.RequestStats DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.RequestStats();
  }

  public static com.google.bigtable.v2.RequestStats getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RequestStats> PARSER =
      new com.google.protobuf.AbstractParser<RequestStats>() {
        @java.lang.Override
        public RequestStats parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RequestStats> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RequestStats> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.RequestStats getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
