/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/bigtable.proto

package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * Response message for BigtableService.MutateRows.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.MutateRowsResponse}
 */
public final class MutateRowsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.MutateRowsResponse)
    MutateRowsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MutateRowsResponse.newBuilder() to construct.
  private MutateRowsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MutateRowsResponse() {
    entries_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MutateRowsResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_MutateRowsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_MutateRowsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.MutateRowsResponse.class,
            com.google.bigtable.v2.MutateRowsResponse.Builder.class);
  }

  public interface EntryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.MutateRowsResponse.Entry)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The index into the original request's `entries` list of the Entry
     * for which a result is being reported.
     * </pre>
     *
     * <code>int64 index = 1;</code>
     *
     * @return The index.
     */
    long getIndex();

    /**
     *
     *
     * <pre>
     * The result of the request Entry identified by `index`.
     * Depending on how requests are batched during execution, it is possible
     * for one Entry to fail due to an error with another Entry. In the event
     * that this occurs, the same error will be reported for both entries.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return Whether the status field is set.
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * The result of the request Entry identified by `index`.
     * Depending on how requests are batched during execution, it is possible
     * for one Entry to fail due to an error with another Entry. In the event
     * that this occurs, the same error will be reported for both entries.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return The status.
     */
    com.google.rpc.Status getStatus();
    /**
     *
     *
     * <pre>
     * The result of the request Entry identified by `index`.
     * Depending on how requests are batched during execution, it is possible
     * for one Entry to fail due to an error with another Entry. In the event
     * that this occurs, the same error will be reported for both entries.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    com.google.rpc.StatusOrBuilder getStatusOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The result of applying a passed mutation in the original request.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.MutateRowsResponse.Entry}
   */
  public static final class Entry extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.MutateRowsResponse.Entry)
      EntryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Entry.newBuilder() to construct.
    private Entry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Entry() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Entry();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_MutateRowsResponse_Entry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_MutateRowsResponse_Entry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.MutateRowsResponse.Entry.class,
              com.google.bigtable.v2.MutateRowsResponse.Entry.Builder.class);
    }

    public static final int INDEX_FIELD_NUMBER = 1;
    private long index_;
    /**
     *
     *
     * <pre>
     * The index into the original request's `entries` list of the Entry
     * for which a result is being reported.
     * </pre>
     *
     * <code>int64 index = 1;</code>
     *
     * @return The index.
     */
    @java.lang.Override
    public long getIndex() {
      return index_;
    }

    public static final int STATUS_FIELD_NUMBER = 2;
    private com.google.rpc.Status status_;
    /**
     *
     *
     * <pre>
     * The result of the request Entry identified by `index`.
     * Depending on how requests are batched during execution, it is possible
     * for one Entry to fail due to an error with another Entry. In the event
     * that this occurs, the same error will be reported for both entries.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return Whether the status field is set.
     */
    @java.lang.Override
    public boolean hasStatus() {
      return status_ != null;
    }
    /**
     *
     *
     * <pre>
     * The result of the request Entry identified by `index`.
     * Depending on how requests are batched during execution, it is possible
     * for one Entry to fail due to an error with another Entry. In the event
     * that this occurs, the same error will be reported for both entries.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     *
     * @return The status.
     */
    @java.lang.Override
    public com.google.rpc.Status getStatus() {
      return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
    }
    /**
     *
     *
     * <pre>
     * The result of the request Entry identified by `index`.
     * Depending on how requests are batched during execution, it is possible
     * for one Entry to fail due to an error with another Entry. In the event
     * that this occurs, the same error will be reported for both entries.
     * </pre>
     *
     * <code>.google.rpc.Status status = 2;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      return getStatus();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (index_ != 0L) {
        output.writeInt64(1, index_);
      }
      if (status_ != null) {
        output.writeMessage(2, getStatus());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (index_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, index_);
      }
      if (status_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStatus());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.MutateRowsResponse.Entry)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.MutateRowsResponse.Entry other =
          (com.google.bigtable.v2.MutateRowsResponse.Entry) obj;

      if (getIndex() != other.getIndex()) return false;
      if (hasStatus() != other.hasStatus()) return false;
      if (hasStatus()) {
        if (!getStatus().equals(other.getStatus())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + INDEX_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIndex());
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.MutateRowsResponse.Entry parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.MutateRowsResponse.Entry parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.MutateRowsResponse.Entry parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.MutateRowsResponse.Entry parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.MutateRowsResponse.Entry parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.MutateRowsResponse.Entry parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.MutateRowsResponse.Entry parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.MutateRowsResponse.Entry parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.MutateRowsResponse.Entry parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.MutateRowsResponse.Entry parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.MutateRowsResponse.Entry parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.MutateRowsResponse.Entry parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.v2.MutateRowsResponse.Entry prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The result of applying a passed mutation in the original request.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.MutateRowsResponse.Entry}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.MutateRowsResponse.Entry)
        com.google.bigtable.v2.MutateRowsResponse.EntryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_MutateRowsResponse_Entry_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_MutateRowsResponse_Entry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.MutateRowsResponse.Entry.class,
                com.google.bigtable.v2.MutateRowsResponse.Entry.Builder.class);
      }

      // Construct using com.google.bigtable.v2.MutateRowsResponse.Entry.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        index_ = 0L;

        if (statusBuilder_ == null) {
          status_ = null;
        } else {
          status_ = null;
          statusBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_MutateRowsResponse_Entry_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.MutateRowsResponse.Entry getDefaultInstanceForType() {
        return com.google.bigtable.v2.MutateRowsResponse.Entry.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.MutateRowsResponse.Entry build() {
        com.google.bigtable.v2.MutateRowsResponse.Entry result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.MutateRowsResponse.Entry buildPartial() {
        com.google.bigtable.v2.MutateRowsResponse.Entry result =
            new com.google.bigtable.v2.MutateRowsResponse.Entry(this);
        result.index_ = index_;
        if (statusBuilder_ == null) {
          result.status_ = status_;
        } else {
          result.status_ = statusBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.MutateRowsResponse.Entry) {
          return mergeFrom((com.google.bigtable.v2.MutateRowsResponse.Entry) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.MutateRowsResponse.Entry other) {
        if (other == com.google.bigtable.v2.MutateRowsResponse.Entry.getDefaultInstance())
          return this;
        if (other.getIndex() != 0L) {
          setIndex(other.getIndex());
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  index_ = input.readInt64();

                  break;
                } // case 8
              case 18:
                {
                  input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);

                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private long index_;
      /**
       *
       *
       * <pre>
       * The index into the original request's `entries` list of the Entry
       * for which a result is being reported.
       * </pre>
       *
       * <code>int64 index = 1;</code>
       *
       * @return The index.
       */
      @java.lang.Override
      public long getIndex() {
        return index_;
      }
      /**
       *
       *
       * <pre>
       * The index into the original request's `entries` list of the Entry
       * for which a result is being reported.
       * </pre>
       *
       * <code>int64 index = 1;</code>
       *
       * @param value The index to set.
       * @return This builder for chaining.
       */
      public Builder setIndex(long value) {

        index_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The index into the original request's `entries` list of the Entry
       * for which a result is being reported.
       * </pre>
       *
       * <code>int64 index = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIndex() {

        index_ = 0L;
        onChanged();
        return this;
      }

      private com.google.rpc.Status status_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * The result of the request Entry identified by `index`.
       * Depending on how requests are batched during execution, it is possible
       * for one Entry to fail due to an error with another Entry. In the event
       * that this occurs, the same error will be reported for both entries.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       *
       * @return Whether the status field is set.
       */
      public boolean hasStatus() {
        return statusBuilder_ != null || status_ != null;
      }
      /**
       *
       *
       * <pre>
       * The result of the request Entry identified by `index`.
       * Depending on how requests are batched during execution, it is possible
       * for one Entry to fail due to an error with another Entry. In the event
       * that this occurs, the same error will be reported for both entries.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       *
       * @return The status.
       */
      public com.google.rpc.Status getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The result of the request Entry identified by `index`.
       * Depending on how requests are batched during execution, it is possible
       * for one Entry to fail due to an error with another Entry. In the event
       * that this occurs, the same error will be reported for both entries.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder setStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
          onChanged();
        } else {
          statusBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The result of the request Entry identified by `index`.
       * Depending on how requests are batched during execution, it is possible
       * for one Entry to fail due to an error with another Entry. In the event
       * that this occurs, the same error will be reported for both entries.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
          onChanged();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The result of the request Entry identified by `index`.
       * Depending on how requests are batched during execution, it is possible
       * for one Entry to fail due to an error with another Entry. In the event
       * that this occurs, the same error will be reported for both entries.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder mergeStatus(com.google.rpc.Status value) {
        if (statusBuilder_ == null) {
          if (status_ != null) {
            status_ = com.google.rpc.Status.newBuilder(status_).mergeFrom(value).buildPartial();
          } else {
            status_ = value;
          }
          onChanged();
        } else {
          statusBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The result of the request Entry identified by `index`.
       * Depending on how requests are batched during execution, it is possible
       * for one Entry to fail due to an error with another Entry. In the event
       * that this occurs, the same error will be reported for both entries.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public Builder clearStatus() {
        if (statusBuilder_ == null) {
          status_ = null;
          onChanged();
        } else {
          status_ = null;
          statusBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The result of the request Entry identified by `index`.
       * Depending on how requests are batched during execution, it is possible
       * for one Entry to fail due to an error with another Entry. In the event
       * that this occurs, the same error will be reported for both entries.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public com.google.rpc.Status.Builder getStatusBuilder() {

        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The result of the request Entry identified by `index`.
       * Depending on how requests are batched during execution, it is possible
       * for one Entry to fail due to an error with another Entry. In the event
       * that this occurs, the same error will be reported for both entries.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * The result of the request Entry identified by `index`.
       * Depending on how requests are batched during execution, it is possible
       * for one Entry to fail due to an error with another Entry. In the event
       * that this occurs, the same error will be reported for both entries.
       * </pre>
       *
       * <code>.google.rpc.Status status = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.MutateRowsResponse.Entry)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.MutateRowsResponse.Entry)
    private static final com.google.bigtable.v2.MutateRowsResponse.Entry DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.MutateRowsResponse.Entry();
    }

    public static com.google.bigtable.v2.MutateRowsResponse.Entry getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Entry> PARSER =
        new com.google.protobuf.AbstractParser<Entry>() {
          @java.lang.Override
          public Entry parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Entry> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Entry> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.MutateRowsResponse.Entry getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ENTRIES_FIELD_NUMBER = 1;
  private java.util.List<com.google.bigtable.v2.MutateRowsResponse.Entry> entries_;
  /**
   *
   *
   * <pre>
   * One or more results for Entries from the batch request.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.bigtable.v2.MutateRowsResponse.Entry> getEntriesList() {
    return entries_;
  }
  /**
   *
   *
   * <pre>
   * One or more results for Entries from the batch request.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.bigtable.v2.MutateRowsResponse.EntryOrBuilder>
      getEntriesOrBuilderList() {
    return entries_;
  }
  /**
   *
   *
   * <pre>
   * One or more results for Entries from the batch request.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
   */
  @java.lang.Override
  public int getEntriesCount() {
    return entries_.size();
  }
  /**
   *
   *
   * <pre>
   * One or more results for Entries from the batch request.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.MutateRowsResponse.Entry getEntries(int index) {
    return entries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * One or more results for Entries from the batch request.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.MutateRowsResponse.EntryOrBuilder getEntriesOrBuilder(int index) {
    return entries_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < entries_.size(); i++) {
      output.writeMessage(1, entries_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < entries_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, entries_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.MutateRowsResponse)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.MutateRowsResponse other =
        (com.google.bigtable.v2.MutateRowsResponse) obj;

    if (!getEntriesList().equals(other.getEntriesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getEntriesCount() > 0) {
      hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
      hash = (53 * hash) + getEntriesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.MutateRowsResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.MutateRowsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.MutateRowsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.MutateRowsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowsResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.MutateRowsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.MutateRowsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.MutateRowsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.MutateRowsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for BigtableService.MutateRows.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.MutateRowsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.MutateRowsResponse)
      com.google.bigtable.v2.MutateRowsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_MutateRowsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_MutateRowsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.MutateRowsResponse.class,
              com.google.bigtable.v2.MutateRowsResponse.Builder.class);
    }

    // Construct using com.google.bigtable.v2.MutateRowsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (entriesBuilder_ == null) {
        entries_ = java.util.Collections.emptyList();
      } else {
        entries_ = null;
        entriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_MutateRowsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.MutateRowsResponse getDefaultInstanceForType() {
      return com.google.bigtable.v2.MutateRowsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.MutateRowsResponse build() {
      com.google.bigtable.v2.MutateRowsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.MutateRowsResponse buildPartial() {
      com.google.bigtable.v2.MutateRowsResponse result =
          new com.google.bigtable.v2.MutateRowsResponse(this);
      int from_bitField0_ = bitField0_;
      if (entriesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          entries_ = java.util.Collections.unmodifiableList(entries_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.entries_ = entries_;
      } else {
        result.entries_ = entriesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.MutateRowsResponse) {
        return mergeFrom((com.google.bigtable.v2.MutateRowsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.MutateRowsResponse other) {
      if (other == com.google.bigtable.v2.MutateRowsResponse.getDefaultInstance()) return this;
      if (entriesBuilder_ == null) {
        if (!other.entries_.isEmpty()) {
          if (entries_.isEmpty()) {
            entries_ = other.entries_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureEntriesIsMutable();
            entries_.addAll(other.entries_);
          }
          onChanged();
        }
      } else {
        if (!other.entries_.isEmpty()) {
          if (entriesBuilder_.isEmpty()) {
            entriesBuilder_.dispose();
            entriesBuilder_ = null;
            entries_ = other.entries_;
            bitField0_ = (bitField0_ & ~0x00000001);
            entriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEntriesFieldBuilder()
                    : null;
          } else {
            entriesBuilder_.addAllMessages(other.entries_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.bigtable.v2.MutateRowsResponse.Entry m =
                    input.readMessage(
                        com.google.bigtable.v2.MutateRowsResponse.Entry.parser(),
                        extensionRegistry);
                if (entriesBuilder_ == null) {
                  ensureEntriesIsMutable();
                  entries_.add(m);
                } else {
                  entriesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.bigtable.v2.MutateRowsResponse.Entry> entries_ =
        java.util.Collections.emptyList();

    private void ensureEntriesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        entries_ =
            new java.util.ArrayList<com.google.bigtable.v2.MutateRowsResponse.Entry>(entries_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.MutateRowsResponse.Entry,
            com.google.bigtable.v2.MutateRowsResponse.Entry.Builder,
            com.google.bigtable.v2.MutateRowsResponse.EntryOrBuilder>
        entriesBuilder_;

    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public java.util.List<com.google.bigtable.v2.MutateRowsResponse.Entry> getEntriesList() {
      if (entriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(entries_);
      } else {
        return entriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public int getEntriesCount() {
      if (entriesBuilder_ == null) {
        return entries_.size();
      } else {
        return entriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public com.google.bigtable.v2.MutateRowsResponse.Entry getEntries(int index) {
      if (entriesBuilder_ == null) {
        return entries_.get(index);
      } else {
        return entriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public Builder setEntries(int index, com.google.bigtable.v2.MutateRowsResponse.Entry value) {
      if (entriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntriesIsMutable();
        entries_.set(index, value);
        onChanged();
      } else {
        entriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public Builder setEntries(
        int index, com.google.bigtable.v2.MutateRowsResponse.Entry.Builder builderForValue) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.set(index, builderForValue.build());
        onChanged();
      } else {
        entriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public Builder addEntries(com.google.bigtable.v2.MutateRowsResponse.Entry value) {
      if (entriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntriesIsMutable();
        entries_.add(value);
        onChanged();
      } else {
        entriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public Builder addEntries(int index, com.google.bigtable.v2.MutateRowsResponse.Entry value) {
      if (entriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntriesIsMutable();
        entries_.add(index, value);
        onChanged();
      } else {
        entriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public Builder addEntries(
        com.google.bigtable.v2.MutateRowsResponse.Entry.Builder builderForValue) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.add(builderForValue.build());
        onChanged();
      } else {
        entriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public Builder addEntries(
        int index, com.google.bigtable.v2.MutateRowsResponse.Entry.Builder builderForValue) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.add(index, builderForValue.build());
        onChanged();
      } else {
        entriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public Builder addAllEntries(
        java.lang.Iterable<? extends com.google.bigtable.v2.MutateRowsResponse.Entry> values) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entries_);
        onChanged();
      } else {
        entriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public Builder clearEntries() {
      if (entriesBuilder_ == null) {
        entries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        entriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public Builder removeEntries(int index) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.remove(index);
        onChanged();
      } else {
        entriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public com.google.bigtable.v2.MutateRowsResponse.Entry.Builder getEntriesBuilder(int index) {
      return getEntriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public com.google.bigtable.v2.MutateRowsResponse.EntryOrBuilder getEntriesOrBuilder(int index) {
      if (entriesBuilder_ == null) {
        return entries_.get(index);
      } else {
        return entriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public java.util.List<? extends com.google.bigtable.v2.MutateRowsResponse.EntryOrBuilder>
        getEntriesOrBuilderList() {
      if (entriesBuilder_ != null) {
        return entriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(entries_);
      }
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public com.google.bigtable.v2.MutateRowsResponse.Entry.Builder addEntriesBuilder() {
      return getEntriesFieldBuilder()
          .addBuilder(com.google.bigtable.v2.MutateRowsResponse.Entry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public com.google.bigtable.v2.MutateRowsResponse.Entry.Builder addEntriesBuilder(int index) {
      return getEntriesFieldBuilder()
          .addBuilder(index, com.google.bigtable.v2.MutateRowsResponse.Entry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * One or more results for Entries from the batch request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.MutateRowsResponse.Entry entries = 1;</code>
     */
    public java.util.List<com.google.bigtable.v2.MutateRowsResponse.Entry.Builder>
        getEntriesBuilderList() {
      return getEntriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.MutateRowsResponse.Entry,
            com.google.bigtable.v2.MutateRowsResponse.Entry.Builder,
            com.google.bigtable.v2.MutateRowsResponse.EntryOrBuilder>
        getEntriesFieldBuilder() {
      if (entriesBuilder_ == null) {
        entriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.bigtable.v2.MutateRowsResponse.Entry,
                com.google.bigtable.v2.MutateRowsResponse.Entry.Builder,
                com.google.bigtable.v2.MutateRowsResponse.EntryOrBuilder>(
                entries_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        entries_ = null;
      }
      return entriesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.MutateRowsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.MutateRowsResponse)
  private static final com.google.bigtable.v2.MutateRowsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.MutateRowsResponse();
  }

  public static com.google.bigtable.v2.MutateRowsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MutateRowsResponse> PARSER =
      new com.google.protobuf.AbstractParser<MutateRowsResponse>() {
        @java.lang.Override
        public MutateRowsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MutateRowsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MutateRowsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.MutateRowsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
