/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/bigtable.proto

package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * Request message for BigtableService.MutateRows.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.MutateRowsRequest}
 */
public final class MutateRowsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.MutateRowsRequest)
    MutateRowsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MutateRowsRequest.newBuilder() to construct.
  private MutateRowsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MutateRowsRequest() {
    tableName_ = "";
    appProfileId_ = "";
    entries_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MutateRowsRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_MutateRowsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_MutateRowsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.MutateRowsRequest.class,
            com.google.bigtable.v2.MutateRowsRequest.Builder.class);
  }

  public interface EntryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.MutateRowsRequest.Entry)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The key of the row to which the `mutations` should be applied.
     * </pre>
     *
     * <code>bytes row_key = 1;</code>
     *
     * @return The rowKey.
     */
    com.google.protobuf.ByteString getRowKey();

    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row.
     * Mutations are applied in order, meaning that earlier mutations can be
     * masked by later ones. You must specify at least one mutation.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<com.google.bigtable.v2.Mutation> getMutationsList();
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row.
     * Mutations are applied in order, meaning that earlier mutations can be
     * masked by later ones. You must specify at least one mutation.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.bigtable.v2.Mutation getMutations(int index);
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row.
     * Mutations are applied in order, meaning that earlier mutations can be
     * masked by later ones. You must specify at least one mutation.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    int getMutationsCount();
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row.
     * Mutations are applied in order, meaning that earlier mutations can be
     * masked by later ones. You must specify at least one mutation.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    java.util.List<? extends com.google.bigtable.v2.MutationOrBuilder> getMutationsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row.
     * Mutations are applied in order, meaning that earlier mutations can be
     * masked by later ones. You must specify at least one mutation.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.bigtable.v2.MutationOrBuilder getMutationsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A mutation for a given row.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.MutateRowsRequest.Entry}
   */
  public static final class Entry extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.MutateRowsRequest.Entry)
      EntryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Entry.newBuilder() to construct.
    private Entry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Entry() {
      rowKey_ = com.google.protobuf.ByteString.EMPTY;
      mutations_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Entry();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_MutateRowsRequest_Entry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_MutateRowsRequest_Entry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.MutateRowsRequest.Entry.class,
              com.google.bigtable.v2.MutateRowsRequest.Entry.Builder.class);
    }

    public static final int ROW_KEY_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString rowKey_;
    /**
     *
     *
     * <pre>
     * The key of the row to which the `mutations` should be applied.
     * </pre>
     *
     * <code>bytes row_key = 1;</code>
     *
     * @return The rowKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRowKey() {
      return rowKey_;
    }

    public static final int MUTATIONS_FIELD_NUMBER = 2;
    private java.util.List<com.google.bigtable.v2.Mutation> mutations_;
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row.
     * Mutations are applied in order, meaning that earlier mutations can be
     * masked by later ones. You must specify at least one mutation.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.bigtable.v2.Mutation> getMutationsList() {
      return mutations_;
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row.
     * Mutations are applied in order, meaning that earlier mutations can be
     * masked by later ones. You must specify at least one mutation.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.bigtable.v2.MutationOrBuilder>
        getMutationsOrBuilderList() {
      return mutations_;
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row.
     * Mutations are applied in order, meaning that earlier mutations can be
     * masked by later ones. You must specify at least one mutation.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public int getMutationsCount() {
      return mutations_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row.
     * Mutations are applied in order, meaning that earlier mutations can be
     * masked by later ones. You must specify at least one mutation.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation getMutations(int index) {
      return mutations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row.
     * Mutations are applied in order, meaning that earlier mutations can be
     * masked by later ones. You must specify at least one mutation.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.MutationOrBuilder getMutationsOrBuilder(int index) {
      return mutations_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!rowKey_.isEmpty()) {
        output.writeBytes(1, rowKey_);
      }
      for (int i = 0; i < mutations_.size(); i++) {
        output.writeMessage(2, mutations_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!rowKey_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, rowKey_);
      }
      for (int i = 0; i < mutations_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, mutations_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.MutateRowsRequest.Entry)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.MutateRowsRequest.Entry other =
          (com.google.bigtable.v2.MutateRowsRequest.Entry) obj;

      if (!getRowKey().equals(other.getRowKey())) return false;
      if (!getMutationsList().equals(other.getMutationsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ROW_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getRowKey().hashCode();
      if (getMutationsCount() > 0) {
        hash = (37 * hash) + MUTATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getMutationsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.MutateRowsRequest.Entry parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.MutateRowsRequest.Entry parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.MutateRowsRequest.Entry parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.MutateRowsRequest.Entry parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.MutateRowsRequest.Entry parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.MutateRowsRequest.Entry parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.MutateRowsRequest.Entry parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.MutateRowsRequest.Entry parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.MutateRowsRequest.Entry parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.MutateRowsRequest.Entry parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.MutateRowsRequest.Entry parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.MutateRowsRequest.Entry parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.v2.MutateRowsRequest.Entry prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A mutation for a given row.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.MutateRowsRequest.Entry}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.MutateRowsRequest.Entry)
        com.google.bigtable.v2.MutateRowsRequest.EntryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_MutateRowsRequest_Entry_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_MutateRowsRequest_Entry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.MutateRowsRequest.Entry.class,
                com.google.bigtable.v2.MutateRowsRequest.Entry.Builder.class);
      }

      // Construct using com.google.bigtable.v2.MutateRowsRequest.Entry.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        rowKey_ = com.google.protobuf.ByteString.EMPTY;

        if (mutationsBuilder_ == null) {
          mutations_ = java.util.Collections.emptyList();
        } else {
          mutations_ = null;
          mutationsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_MutateRowsRequest_Entry_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.MutateRowsRequest.Entry getDefaultInstanceForType() {
        return com.google.bigtable.v2.MutateRowsRequest.Entry.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.MutateRowsRequest.Entry build() {
        com.google.bigtable.v2.MutateRowsRequest.Entry result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.MutateRowsRequest.Entry buildPartial() {
        com.google.bigtable.v2.MutateRowsRequest.Entry result =
            new com.google.bigtable.v2.MutateRowsRequest.Entry(this);
        int from_bitField0_ = bitField0_;
        result.rowKey_ = rowKey_;
        if (mutationsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            mutations_ = java.util.Collections.unmodifiableList(mutations_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.mutations_ = mutations_;
        } else {
          result.mutations_ = mutationsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.MutateRowsRequest.Entry) {
          return mergeFrom((com.google.bigtable.v2.MutateRowsRequest.Entry) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.MutateRowsRequest.Entry other) {
        if (other == com.google.bigtable.v2.MutateRowsRequest.Entry.getDefaultInstance())
          return this;
        if (other.getRowKey() != com.google.protobuf.ByteString.EMPTY) {
          setRowKey(other.getRowKey());
        }
        if (mutationsBuilder_ == null) {
          if (!other.mutations_.isEmpty()) {
            if (mutations_.isEmpty()) {
              mutations_ = other.mutations_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureMutationsIsMutable();
              mutations_.addAll(other.mutations_);
            }
            onChanged();
          }
        } else {
          if (!other.mutations_.isEmpty()) {
            if (mutationsBuilder_.isEmpty()) {
              mutationsBuilder_.dispose();
              mutationsBuilder_ = null;
              mutations_ = other.mutations_;
              bitField0_ = (bitField0_ & ~0x00000001);
              mutationsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getMutationsFieldBuilder()
                      : null;
            } else {
              mutationsBuilder_.addAllMessages(other.mutations_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  rowKey_ = input.readBytes();

                  break;
                } // case 10
              case 18:
                {
                  com.google.bigtable.v2.Mutation m =
                      input.readMessage(
                          com.google.bigtable.v2.Mutation.parser(), extensionRegistry);
                  if (mutationsBuilder_ == null) {
                    ensureMutationsIsMutable();
                    mutations_.add(m);
                  } else {
                    mutationsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.ByteString rowKey_ = com.google.protobuf.ByteString.EMPTY;
      /**
       *
       *
       * <pre>
       * The key of the row to which the `mutations` should be applied.
       * </pre>
       *
       * <code>bytes row_key = 1;</code>
       *
       * @return The rowKey.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRowKey() {
        return rowKey_;
      }
      /**
       *
       *
       * <pre>
       * The key of the row to which the `mutations` should be applied.
       * </pre>
       *
       * <code>bytes row_key = 1;</code>
       *
       * @param value The rowKey to set.
       * @return This builder for chaining.
       */
      public Builder setRowKey(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }

        rowKey_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The key of the row to which the `mutations` should be applied.
       * </pre>
       *
       * <code>bytes row_key = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRowKey() {

        rowKey_ = getDefaultInstance().getRowKey();
        onChanged();
        return this;
      }

      private java.util.List<com.google.bigtable.v2.Mutation> mutations_ =
          java.util.Collections.emptyList();

      private void ensureMutationsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          mutations_ = new java.util.ArrayList<com.google.bigtable.v2.Mutation>(mutations_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.v2.Mutation,
              com.google.bigtable.v2.Mutation.Builder,
              com.google.bigtable.v2.MutationOrBuilder>
          mutationsBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.bigtable.v2.Mutation> getMutationsList() {
        if (mutationsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(mutations_);
        } else {
          return mutationsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public int getMutationsCount() {
        if (mutationsBuilder_ == null) {
          return mutations_.size();
        } else {
          return mutationsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.bigtable.v2.Mutation getMutations(int index) {
        if (mutationsBuilder_ == null) {
          return mutations_.get(index);
        } else {
          return mutationsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMutations(int index, com.google.bigtable.v2.Mutation value) {
        if (mutationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMutationsIsMutable();
          mutations_.set(index, value);
          onChanged();
        } else {
          mutationsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setMutations(
          int index, com.google.bigtable.v2.Mutation.Builder builderForValue) {
        if (mutationsBuilder_ == null) {
          ensureMutationsIsMutable();
          mutations_.set(index, builderForValue.build());
          onChanged();
        } else {
          mutationsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addMutations(com.google.bigtable.v2.Mutation value) {
        if (mutationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMutationsIsMutable();
          mutations_.add(value);
          onChanged();
        } else {
          mutationsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addMutations(int index, com.google.bigtable.v2.Mutation value) {
        if (mutationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMutationsIsMutable();
          mutations_.add(index, value);
          onChanged();
        } else {
          mutationsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addMutations(com.google.bigtable.v2.Mutation.Builder builderForValue) {
        if (mutationsBuilder_ == null) {
          ensureMutationsIsMutable();
          mutations_.add(builderForValue.build());
          onChanged();
        } else {
          mutationsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addMutations(
          int index, com.google.bigtable.v2.Mutation.Builder builderForValue) {
        if (mutationsBuilder_ == null) {
          ensureMutationsIsMutable();
          mutations_.add(index, builderForValue.build());
          onChanged();
        } else {
          mutationsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder addAllMutations(
          java.lang.Iterable<? extends com.google.bigtable.v2.Mutation> values) {
        if (mutationsBuilder_ == null) {
          ensureMutationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mutations_);
          onChanged();
        } else {
          mutationsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearMutations() {
        if (mutationsBuilder_ == null) {
          mutations_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          mutationsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder removeMutations(int index) {
        if (mutationsBuilder_ == null) {
          ensureMutationsIsMutable();
          mutations_.remove(index);
          onChanged();
        } else {
          mutationsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.bigtable.v2.Mutation.Builder getMutationsBuilder(int index) {
        return getMutationsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.bigtable.v2.MutationOrBuilder getMutationsOrBuilder(int index) {
        if (mutationsBuilder_ == null) {
          return mutations_.get(index);
        } else {
          return mutationsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<? extends com.google.bigtable.v2.MutationOrBuilder>
          getMutationsOrBuilderList() {
        if (mutationsBuilder_ != null) {
          return mutationsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(mutations_);
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.bigtable.v2.Mutation.Builder addMutationsBuilder() {
        return getMutationsFieldBuilder()
            .addBuilder(com.google.bigtable.v2.Mutation.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.bigtable.v2.Mutation.Builder addMutationsBuilder(int index) {
        return getMutationsFieldBuilder()
            .addBuilder(index, com.google.bigtable.v2.Mutation.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Required. Changes to be atomically applied to the specified row.
       * Mutations are applied in order, meaning that earlier mutations can be
       * masked by later ones. You must specify at least one mutation.
       * </pre>
       *
       * <code>
       * repeated .google.bigtable.v2.Mutation mutations = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public java.util.List<com.google.bigtable.v2.Mutation.Builder> getMutationsBuilderList() {
        return getMutationsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.v2.Mutation,
              com.google.bigtable.v2.Mutation.Builder,
              com.google.bigtable.v2.MutationOrBuilder>
          getMutationsFieldBuilder() {
        if (mutationsBuilder_ == null) {
          mutationsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.bigtable.v2.Mutation,
                  com.google.bigtable.v2.Mutation.Builder,
                  com.google.bigtable.v2.MutationOrBuilder>(
                  mutations_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          mutations_ = null;
        }
        return mutationsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.MutateRowsRequest.Entry)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.MutateRowsRequest.Entry)
    private static final com.google.bigtable.v2.MutateRowsRequest.Entry DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.MutateRowsRequest.Entry();
    }

    public static com.google.bigtable.v2.MutateRowsRequest.Entry getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Entry> PARSER =
        new com.google.protobuf.AbstractParser<Entry>() {
          @java.lang.Override
          public Entry parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Entry> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Entry> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.MutateRowsRequest.Entry getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int TABLE_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object tableName_;
  /**
   *
   *
   * <pre>
   * Required. The unique name of the table to which the mutations should be
   * applied.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The tableName.
   */
  @java.lang.Override
  public java.lang.String getTableName() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique name of the table to which the mutations should be
   * applied.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for tableName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableNameBytes() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_PROFILE_ID_FIELD_NUMBER = 3;
  private volatile java.lang.Object appProfileId_;
  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * </pre>
   *
   * <code>string app_profile_id = 3;</code>
   *
   * @return The appProfileId.
   */
  @java.lang.Override
  public java.lang.String getAppProfileId() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      appProfileId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * </pre>
   *
   * <code>string app_profile_id = 3;</code>
   *
   * @return The bytes for appProfileId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAppProfileIdBytes() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      appProfileId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENTRIES_FIELD_NUMBER = 2;
  private java.util.List<com.google.bigtable.v2.MutateRowsRequest.Entry> entries_;
  /**
   *
   *
   * <pre>
   * Required. The row keys and corresponding mutations to be applied in bulk.
   * Each entry is applied as an atomic mutation, but the entries may be
   * applied in arbitrary order (even between entries for the same row).
   * At least one entry must be specified, and in total the entries can
   * contain at most 100000 mutations.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.bigtable.v2.MutateRowsRequest.Entry> getEntriesList() {
    return entries_;
  }
  /**
   *
   *
   * <pre>
   * Required. The row keys and corresponding mutations to be applied in bulk.
   * Each entry is applied as an atomic mutation, but the entries may be
   * applied in arbitrary order (even between entries for the same row).
   * At least one entry must be specified, and in total the entries can
   * contain at most 100000 mutations.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.bigtable.v2.MutateRowsRequest.EntryOrBuilder>
      getEntriesOrBuilderList() {
    return entries_;
  }
  /**
   *
   *
   * <pre>
   * Required. The row keys and corresponding mutations to be applied in bulk.
   * Each entry is applied as an atomic mutation, but the entries may be
   * applied in arbitrary order (even between entries for the same row).
   * At least one entry must be specified, and in total the entries can
   * contain at most 100000 mutations.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getEntriesCount() {
    return entries_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The row keys and corresponding mutations to be applied in bulk.
   * Each entry is applied as an atomic mutation, but the entries may be
   * applied in arbitrary order (even between entries for the same row).
   * At least one entry must be specified, and in total the entries can
   * contain at most 100000 mutations.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.MutateRowsRequest.Entry getEntries(int index) {
    return entries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The row keys and corresponding mutations to be applied in bulk.
   * Each entry is applied as an atomic mutation, but the entries may be
   * applied in arbitrary order (even between entries for the same row).
   * At least one entry must be specified, and in total the entries can
   * contain at most 100000 mutations.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.MutateRowsRequest.EntryOrBuilder getEntriesOrBuilder(int index) {
    return entries_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tableName_);
    }
    for (int i = 0; i < entries_.size(); i++) {
      output.writeMessage(2, entries_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appProfileId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, appProfileId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tableName_);
    }
    for (int i = 0; i < entries_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, entries_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appProfileId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, appProfileId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.MutateRowsRequest)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.MutateRowsRequest other = (com.google.bigtable.v2.MutateRowsRequest) obj;

    if (!getTableName().equals(other.getTableName())) return false;
    if (!getAppProfileId().equals(other.getAppProfileId())) return false;
    if (!getEntriesList().equals(other.getEntriesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TABLE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTableName().hashCode();
    hash = (37 * hash) + APP_PROFILE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAppProfileId().hashCode();
    if (getEntriesCount() > 0) {
      hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
      hash = (53 * hash) + getEntriesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.MutateRowsRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.MutateRowsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.MutateRowsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.MutateRowsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowsRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.MutateRowsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.MutateRowsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.MutateRowsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.MutateRowsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for BigtableService.MutateRows.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.MutateRowsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.MutateRowsRequest)
      com.google.bigtable.v2.MutateRowsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_MutateRowsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_MutateRowsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.MutateRowsRequest.class,
              com.google.bigtable.v2.MutateRowsRequest.Builder.class);
    }

    // Construct using com.google.bigtable.v2.MutateRowsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      tableName_ = "";

      appProfileId_ = "";

      if (entriesBuilder_ == null) {
        entries_ = java.util.Collections.emptyList();
      } else {
        entries_ = null;
        entriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_MutateRowsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.MutateRowsRequest getDefaultInstanceForType() {
      return com.google.bigtable.v2.MutateRowsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.MutateRowsRequest build() {
      com.google.bigtable.v2.MutateRowsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.MutateRowsRequest buildPartial() {
      com.google.bigtable.v2.MutateRowsRequest result =
          new com.google.bigtable.v2.MutateRowsRequest(this);
      int from_bitField0_ = bitField0_;
      result.tableName_ = tableName_;
      result.appProfileId_ = appProfileId_;
      if (entriesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          entries_ = java.util.Collections.unmodifiableList(entries_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.entries_ = entries_;
      } else {
        result.entries_ = entriesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.MutateRowsRequest) {
        return mergeFrom((com.google.bigtable.v2.MutateRowsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.MutateRowsRequest other) {
      if (other == com.google.bigtable.v2.MutateRowsRequest.getDefaultInstance()) return this;
      if (!other.getTableName().isEmpty()) {
        tableName_ = other.tableName_;
        onChanged();
      }
      if (!other.getAppProfileId().isEmpty()) {
        appProfileId_ = other.appProfileId_;
        onChanged();
      }
      if (entriesBuilder_ == null) {
        if (!other.entries_.isEmpty()) {
          if (entries_.isEmpty()) {
            entries_ = other.entries_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureEntriesIsMutable();
            entries_.addAll(other.entries_);
          }
          onChanged();
        }
      } else {
        if (!other.entries_.isEmpty()) {
          if (entriesBuilder_.isEmpty()) {
            entriesBuilder_.dispose();
            entriesBuilder_ = null;
            entries_ = other.entries_;
            bitField0_ = (bitField0_ & ~0x00000001);
            entriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEntriesFieldBuilder()
                    : null;
          } else {
            entriesBuilder_.addAllMessages(other.entries_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                tableName_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                com.google.bigtable.v2.MutateRowsRequest.Entry m =
                    input.readMessage(
                        com.google.bigtable.v2.MutateRowsRequest.Entry.parser(), extensionRegistry);
                if (entriesBuilder_ == null) {
                  ensureEntriesIsMutable();
                  entries_.add(m);
                } else {
                  entriesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                appProfileId_ = input.readStringRequireUtf8();

                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object tableName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the mutations should be
     * applied.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The tableName.
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the mutations should be
     * applied.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for tableName.
     */
    public com.google.protobuf.ByteString getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the mutations should be
     * applied.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tableName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the mutations should be
     * applied.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableName() {

      tableName_ = getDefaultInstance().getTableName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the mutations should be
     * applied.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      tableName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object appProfileId_ = "";
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 3;</code>
     *
     * @return The appProfileId.
     */
    public java.lang.String getAppProfileId() {
      java.lang.Object ref = appProfileId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        appProfileId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 3;</code>
     *
     * @return The bytes for appProfileId.
     */
    public com.google.protobuf.ByteString getAppProfileIdBytes() {
      java.lang.Object ref = appProfileId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        appProfileId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 3;</code>
     *
     * @param value The appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      appProfileId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppProfileId() {

      appProfileId_ = getDefaultInstance().getAppProfileId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 3;</code>
     *
     * @param value The bytes for appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      appProfileId_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.bigtable.v2.MutateRowsRequest.Entry> entries_ =
        java.util.Collections.emptyList();

    private void ensureEntriesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        entries_ =
            new java.util.ArrayList<com.google.bigtable.v2.MutateRowsRequest.Entry>(entries_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.MutateRowsRequest.Entry,
            com.google.bigtable.v2.MutateRowsRequest.Entry.Builder,
            com.google.bigtable.v2.MutateRowsRequest.EntryOrBuilder>
        entriesBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.bigtable.v2.MutateRowsRequest.Entry> getEntriesList() {
      if (entriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(entries_);
      } else {
        return entriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getEntriesCount() {
      if (entriesBuilder_ == null) {
        return entries_.size();
      } else {
        return entriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.MutateRowsRequest.Entry getEntries(int index) {
      if (entriesBuilder_ == null) {
        return entries_.get(index);
      } else {
        return entriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setEntries(int index, com.google.bigtable.v2.MutateRowsRequest.Entry value) {
      if (entriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntriesIsMutable();
        entries_.set(index, value);
        onChanged();
      } else {
        entriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setEntries(
        int index, com.google.bigtable.v2.MutateRowsRequest.Entry.Builder builderForValue) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.set(index, builderForValue.build());
        onChanged();
      } else {
        entriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addEntries(com.google.bigtable.v2.MutateRowsRequest.Entry value) {
      if (entriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntriesIsMutable();
        entries_.add(value);
        onChanged();
      } else {
        entriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addEntries(int index, com.google.bigtable.v2.MutateRowsRequest.Entry value) {
      if (entriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEntriesIsMutable();
        entries_.add(index, value);
        onChanged();
      } else {
        entriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addEntries(
        com.google.bigtable.v2.MutateRowsRequest.Entry.Builder builderForValue) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.add(builderForValue.build());
        onChanged();
      } else {
        entriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addEntries(
        int index, com.google.bigtable.v2.MutateRowsRequest.Entry.Builder builderForValue) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.add(index, builderForValue.build());
        onChanged();
      } else {
        entriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllEntries(
        java.lang.Iterable<? extends com.google.bigtable.v2.MutateRowsRequest.Entry> values) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entries_);
        onChanged();
      } else {
        entriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearEntries() {
      if (entriesBuilder_ == null) {
        entries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        entriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeEntries(int index) {
      if (entriesBuilder_ == null) {
        ensureEntriesIsMutable();
        entries_.remove(index);
        onChanged();
      } else {
        entriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.MutateRowsRequest.Entry.Builder getEntriesBuilder(int index) {
      return getEntriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.MutateRowsRequest.EntryOrBuilder getEntriesOrBuilder(int index) {
      if (entriesBuilder_ == null) {
        return entries_.get(index);
      } else {
        return entriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.bigtable.v2.MutateRowsRequest.EntryOrBuilder>
        getEntriesOrBuilderList() {
      if (entriesBuilder_ != null) {
        return entriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(entries_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.MutateRowsRequest.Entry.Builder addEntriesBuilder() {
      return getEntriesFieldBuilder()
          .addBuilder(com.google.bigtable.v2.MutateRowsRequest.Entry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.MutateRowsRequest.Entry.Builder addEntriesBuilder(int index) {
      return getEntriesFieldBuilder()
          .addBuilder(index, com.google.bigtable.v2.MutateRowsRequest.Entry.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The row keys and corresponding mutations to be applied in bulk.
     * Each entry is applied as an atomic mutation, but the entries may be
     * applied in arbitrary order (even between entries for the same row).
     * At least one entry must be specified, and in total the entries can
     * contain at most 100000 mutations.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.MutateRowsRequest.Entry entries = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.bigtable.v2.MutateRowsRequest.Entry.Builder>
        getEntriesBuilderList() {
      return getEntriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.MutateRowsRequest.Entry,
            com.google.bigtable.v2.MutateRowsRequest.Entry.Builder,
            com.google.bigtable.v2.MutateRowsRequest.EntryOrBuilder>
        getEntriesFieldBuilder() {
      if (entriesBuilder_ == null) {
        entriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.bigtable.v2.MutateRowsRequest.Entry,
                com.google.bigtable.v2.MutateRowsRequest.Entry.Builder,
                com.google.bigtable.v2.MutateRowsRequest.EntryOrBuilder>(
                entries_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        entries_ = null;
      }
      return entriesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.MutateRowsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.MutateRowsRequest)
  private static final com.google.bigtable.v2.MutateRowsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.MutateRowsRequest();
  }

  public static com.google.bigtable.v2.MutateRowsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MutateRowsRequest> PARSER =
      new com.google.protobuf.AbstractParser<MutateRowsRequest>() {
        @java.lang.Override
        public MutateRowsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MutateRowsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MutateRowsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.MutateRowsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
