/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/bigtable.proto

package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * Request message for Bigtable.MutateRow.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.MutateRowRequest}
 */
public final class MutateRowRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.MutateRowRequest)
    MutateRowRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use MutateRowRequest.newBuilder() to construct.
  private MutateRowRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MutateRowRequest() {
    tableName_ = "";
    appProfileId_ = "";
    rowKey_ = com.google.protobuf.ByteString.EMPTY;
    mutations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MutateRowRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_MutateRowRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_MutateRowRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.MutateRowRequest.class,
            com.google.bigtable.v2.MutateRowRequest.Builder.class);
  }

  public static final int TABLE_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object tableName_;
  /**
   *
   *
   * <pre>
   * Required. The unique name of the table to which the mutation should be
   * applied. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The tableName.
   */
  @java.lang.Override
  public java.lang.String getTableName() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique name of the table to which the mutation should be
   * applied. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for tableName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableNameBytes() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_PROFILE_ID_FIELD_NUMBER = 4;
  private volatile java.lang.Object appProfileId_;
  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * </pre>
   *
   * <code>string app_profile_id = 4;</code>
   *
   * @return The appProfileId.
   */
  @java.lang.Override
  public java.lang.String getAppProfileId() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      appProfileId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * </pre>
   *
   * <code>string app_profile_id = 4;</code>
   *
   * @return The bytes for appProfileId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAppProfileIdBytes() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      appProfileId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROW_KEY_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString rowKey_;
  /**
   *
   *
   * <pre>
   * Required. The key of the row to which the mutation should be applied.
   * </pre>
   *
   * <code>bytes row_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The rowKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRowKey() {
    return rowKey_;
  }

  public static final int MUTATIONS_FIELD_NUMBER = 3;
  private java.util.List<com.google.bigtable.v2.Mutation> mutations_;
  /**
   *
   *
   * <pre>
   * Required. Changes to be atomically applied to the specified row. Entries
   * are applied in order, meaning that earlier mutations can be masked by later
   * ones. Must contain at least one entry and at most 100000.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.bigtable.v2.Mutation> getMutationsList() {
    return mutations_;
  }
  /**
   *
   *
   * <pre>
   * Required. Changes to be atomically applied to the specified row. Entries
   * are applied in order, meaning that earlier mutations can be masked by later
   * ones. Must contain at least one entry and at most 100000.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.bigtable.v2.MutationOrBuilder>
      getMutationsOrBuilderList() {
    return mutations_;
  }
  /**
   *
   *
   * <pre>
   * Required. Changes to be atomically applied to the specified row. Entries
   * are applied in order, meaning that earlier mutations can be masked by later
   * ones. Must contain at least one entry and at most 100000.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getMutationsCount() {
    return mutations_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Changes to be atomically applied to the specified row. Entries
   * are applied in order, meaning that earlier mutations can be masked by later
   * ones. Must contain at least one entry and at most 100000.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation getMutations(int index) {
    return mutations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Changes to be atomically applied to the specified row. Entries
   * are applied in order, meaning that earlier mutations can be masked by later
   * ones. Must contain at least one entry and at most 100000.
   * </pre>
   *
   * <code>
   * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.MutationOrBuilder getMutationsOrBuilder(int index) {
    return mutations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tableName_);
    }
    if (!rowKey_.isEmpty()) {
      output.writeBytes(2, rowKey_);
    }
    for (int i = 0; i < mutations_.size(); i++) {
      output.writeMessage(3, mutations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appProfileId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, appProfileId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tableName_);
    }
    if (!rowKey_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, rowKey_);
    }
    for (int i = 0; i < mutations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, mutations_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appProfileId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, appProfileId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.MutateRowRequest)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.MutateRowRequest other = (com.google.bigtable.v2.MutateRowRequest) obj;

    if (!getTableName().equals(other.getTableName())) return false;
    if (!getAppProfileId().equals(other.getAppProfileId())) return false;
    if (!getRowKey().equals(other.getRowKey())) return false;
    if (!getMutationsList().equals(other.getMutationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TABLE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTableName().hashCode();
    hash = (37 * hash) + APP_PROFILE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAppProfileId().hashCode();
    hash = (37 * hash) + ROW_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getRowKey().hashCode();
    if (getMutationsCount() > 0) {
      hash = (37 * hash) + MUTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getMutationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.MutateRowRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.MutateRowRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.MutateRowRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.MutateRowRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.MutateRowRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.MutateRowRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.MutateRowRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.MutateRowRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.MutateRowRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for Bigtable.MutateRow.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.MutateRowRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.MutateRowRequest)
      com.google.bigtable.v2.MutateRowRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_MutateRowRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_MutateRowRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.MutateRowRequest.class,
              com.google.bigtable.v2.MutateRowRequest.Builder.class);
    }

    // Construct using com.google.bigtable.v2.MutateRowRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      tableName_ = "";

      appProfileId_ = "";

      rowKey_ = com.google.protobuf.ByteString.EMPTY;

      if (mutationsBuilder_ == null) {
        mutations_ = java.util.Collections.emptyList();
      } else {
        mutations_ = null;
        mutationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_MutateRowRequest_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.MutateRowRequest getDefaultInstanceForType() {
      return com.google.bigtable.v2.MutateRowRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.MutateRowRequest build() {
      com.google.bigtable.v2.MutateRowRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.MutateRowRequest buildPartial() {
      com.google.bigtable.v2.MutateRowRequest result =
          new com.google.bigtable.v2.MutateRowRequest(this);
      int from_bitField0_ = bitField0_;
      result.tableName_ = tableName_;
      result.appProfileId_ = appProfileId_;
      result.rowKey_ = rowKey_;
      if (mutationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          mutations_ = java.util.Collections.unmodifiableList(mutations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.mutations_ = mutations_;
      } else {
        result.mutations_ = mutationsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.MutateRowRequest) {
        return mergeFrom((com.google.bigtable.v2.MutateRowRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.MutateRowRequest other) {
      if (other == com.google.bigtable.v2.MutateRowRequest.getDefaultInstance()) return this;
      if (!other.getTableName().isEmpty()) {
        tableName_ = other.tableName_;
        onChanged();
      }
      if (!other.getAppProfileId().isEmpty()) {
        appProfileId_ = other.appProfileId_;
        onChanged();
      }
      if (other.getRowKey() != com.google.protobuf.ByteString.EMPTY) {
        setRowKey(other.getRowKey());
      }
      if (mutationsBuilder_ == null) {
        if (!other.mutations_.isEmpty()) {
          if (mutations_.isEmpty()) {
            mutations_ = other.mutations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureMutationsIsMutable();
            mutations_.addAll(other.mutations_);
          }
          onChanged();
        }
      } else {
        if (!other.mutations_.isEmpty()) {
          if (mutationsBuilder_.isEmpty()) {
            mutationsBuilder_.dispose();
            mutationsBuilder_ = null;
            mutations_ = other.mutations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            mutationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMutationsFieldBuilder()
                    : null;
          } else {
            mutationsBuilder_.addAllMessages(other.mutations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                tableName_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                rowKey_ = input.readBytes();

                break;
              } // case 18
            case 26:
              {
                com.google.bigtable.v2.Mutation m =
                    input.readMessage(com.google.bigtable.v2.Mutation.parser(), extensionRegistry);
                if (mutationsBuilder_ == null) {
                  ensureMutationsIsMutable();
                  mutations_.add(m);
                } else {
                  mutationsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                appProfileId_ = input.readStringRequireUtf8();

                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object tableName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the mutation should be
     * applied. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The tableName.
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the mutation should be
     * applied. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for tableName.
     */
    public com.google.protobuf.ByteString getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the mutation should be
     * applied. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tableName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the mutation should be
     * applied. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableName() {

      tableName_ = getDefaultInstance().getTableName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the mutation should be
     * applied. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      tableName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object appProfileId_ = "";
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 4;</code>
     *
     * @return The appProfileId.
     */
    public java.lang.String getAppProfileId() {
      java.lang.Object ref = appProfileId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        appProfileId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 4;</code>
     *
     * @return The bytes for appProfileId.
     */
    public com.google.protobuf.ByteString getAppProfileIdBytes() {
      java.lang.Object ref = appProfileId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        appProfileId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 4;</code>
     *
     * @param value The appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      appProfileId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppProfileId() {

      appProfileId_ = getDefaultInstance().getAppProfileId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 4;</code>
     *
     * @param value The bytes for appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      appProfileId_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString rowKey_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Required. The key of the row to which the mutation should be applied.
     * </pre>
     *
     * <code>bytes row_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The rowKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRowKey() {
      return rowKey_;
    }
    /**
     *
     *
     * <pre>
     * Required. The key of the row to which the mutation should be applied.
     * </pre>
     *
     * <code>bytes row_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The rowKey to set.
     * @return This builder for chaining.
     */
    public Builder setRowKey(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      rowKey_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The key of the row to which the mutation should be applied.
     * </pre>
     *
     * <code>bytes row_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowKey() {

      rowKey_ = getDefaultInstance().getRowKey();
      onChanged();
      return this;
    }

    private java.util.List<com.google.bigtable.v2.Mutation> mutations_ =
        java.util.Collections.emptyList();

    private void ensureMutationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        mutations_ = new java.util.ArrayList<com.google.bigtable.v2.Mutation>(mutations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.Mutation,
            com.google.bigtable.v2.Mutation.Builder,
            com.google.bigtable.v2.MutationOrBuilder>
        mutationsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.bigtable.v2.Mutation> getMutationsList() {
      if (mutationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(mutations_);
      } else {
        return mutationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getMutationsCount() {
      if (mutationsBuilder_ == null) {
        return mutations_.size();
      } else {
        return mutationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.Mutation getMutations(int index) {
      if (mutationsBuilder_ == null) {
        return mutations_.get(index);
      } else {
        return mutationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMutations(int index, com.google.bigtable.v2.Mutation value) {
      if (mutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationsIsMutable();
        mutations_.set(index, value);
        onChanged();
      } else {
        mutationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMutations(
        int index, com.google.bigtable.v2.Mutation.Builder builderForValue) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        mutations_.set(index, builderForValue.build());
        onChanged();
      } else {
        mutationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMutations(com.google.bigtable.v2.Mutation value) {
      if (mutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationsIsMutable();
        mutations_.add(value);
        onChanged();
      } else {
        mutationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMutations(int index, com.google.bigtable.v2.Mutation value) {
      if (mutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMutationsIsMutable();
        mutations_.add(index, value);
        onChanged();
      } else {
        mutationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMutations(com.google.bigtable.v2.Mutation.Builder builderForValue) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        mutations_.add(builderForValue.build());
        onChanged();
      } else {
        mutationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMutations(
        int index, com.google.bigtable.v2.Mutation.Builder builderForValue) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        mutations_.add(index, builderForValue.build());
        onChanged();
      } else {
        mutationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllMutations(
        java.lang.Iterable<? extends com.google.bigtable.v2.Mutation> values) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mutations_);
        onChanged();
      } else {
        mutationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearMutations() {
      if (mutationsBuilder_ == null) {
        mutations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        mutationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeMutations(int index) {
      if (mutationsBuilder_ == null) {
        ensureMutationsIsMutable();
        mutations_.remove(index);
        onChanged();
      } else {
        mutationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.Mutation.Builder getMutationsBuilder(int index) {
      return getMutationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.MutationOrBuilder getMutationsOrBuilder(int index) {
      if (mutationsBuilder_ == null) {
        return mutations_.get(index);
      } else {
        return mutationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.bigtable.v2.MutationOrBuilder>
        getMutationsOrBuilderList() {
      if (mutationsBuilder_ != null) {
        return mutationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(mutations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.Mutation.Builder addMutationsBuilder() {
      return getMutationsFieldBuilder()
          .addBuilder(com.google.bigtable.v2.Mutation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.bigtable.v2.Mutation.Builder addMutationsBuilder(int index) {
      return getMutationsFieldBuilder()
          .addBuilder(index, com.google.bigtable.v2.Mutation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Changes to be atomically applied to the specified row. Entries
     * are applied in order, meaning that earlier mutations can be masked by later
     * ones. Must contain at least one entry and at most 100000.
     * </pre>
     *
     * <code>
     * repeated .google.bigtable.v2.Mutation mutations = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.bigtable.v2.Mutation.Builder> getMutationsBuilderList() {
      return getMutationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.Mutation,
            com.google.bigtable.v2.Mutation.Builder,
            com.google.bigtable.v2.MutationOrBuilder>
        getMutationsFieldBuilder() {
      if (mutationsBuilder_ == null) {
        mutationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.bigtable.v2.Mutation,
                com.google.bigtable.v2.Mutation.Builder,
                com.google.bigtable.v2.MutationOrBuilder>(
                mutations_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        mutations_ = null;
      }
      return mutationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.MutateRowRequest)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.MutateRowRequest)
  private static final com.google.bigtable.v2.MutateRowRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.MutateRowRequest();
  }

  public static com.google.bigtable.v2.MutateRowRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MutateRowRequest> PARSER =
      new com.google.protobuf.AbstractParser<MutateRowRequest>() {
        @java.lang.Override
        public MutateRowRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MutateRowRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MutateRowRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.MutateRowRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
